{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetTranslation: TVector3;
    procedure SetTranslation(const Value: TVector3);
    function GetRotation: TVector4;
    procedure SetRotation(const Value: TVector4);
    function GetScaleFactor: TVector3;
    procedure SetScaleFactor(const Value: TVector3);
    function GetScaleOrientation: TVector4;
    procedure SetScaleOrientation(const Value: TVector4);
    function GetCenter: TVector3;
    procedure SetCenter(const Value: TVector3);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;
    class function ForVRMLVersion(const Version: TX3DVersion): Boolean; override;

    strict private FFdTranslation: TSFVec3f;
    { Internal wrapper for property @code(Translation). This wrapper API may change, we advise to access simpler @code(Translation) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdTranslation: TSFVec3f read FFdTranslation;
    {  }
    property Translation: TVector3 read GetTranslation write SetTranslation;

    strict private FFdRotation: TSFRotation;
    { Internal wrapper for property @code(Rotation). This wrapper API may change, we advise to access simpler @code(Rotation) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdRotation: TSFRotation read FFdRotation;
    {  }
    property Rotation: TVector4 read GetRotation write SetRotation;

    strict private FFdScaleFactor: TSFVec3f;
    { Internal wrapper for property @code(ScaleFactor). This wrapper API may change, we advise to access simpler @code(ScaleFactor) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdScaleFactor: TSFVec3f read FFdScaleFactor;
    {  }
    property ScaleFactor: TVector3 read GetScaleFactor write SetScaleFactor;

    strict private FFdScaleOrientation: TSFRotation;
    { Internal wrapper for property @code(ScaleOrientation). This wrapper API may change, we advise to access simpler @code(ScaleOrientation) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdScaleOrientation: TSFRotation read FFdScaleOrientation;
    {  }
    property ScaleOrientation: TVector4 read GetScaleOrientation write SetScaleOrientation;

    strict private FFdCenter: TSFVec3f;
    { Internal wrapper for property @code(Center). This wrapper API may change, we advise to access simpler @code(Center) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdCenter: TSFVec3f read FFdCenter;
    {  }
    property Center: TVector3 read GetCenter write SetCenter;

{$endif read_interface}

{$ifdef read_implementation}

{ TTransformNode_1 ----------------------------------------------- }

function TTransformNode_1.GetTranslation: TVector3;
begin
  Result := FdTranslation.Value;
end;

procedure TTransformNode_1.SetTranslation(const Value: TVector3);
begin
  FdTranslation.Send(Value);
end;

function TTransformNode_1.GetRotation: TVector4;
begin
  Result := FdRotation.Value;
end;

procedure TTransformNode_1.SetRotation(const Value: TVector4);
begin
  FdRotation.Send(Value);
end;

function TTransformNode_1.GetScaleFactor: TVector3;
begin
  Result := FdScaleFactor.Value;
end;

procedure TTransformNode_1.SetScaleFactor(const Value: TVector3);
begin
  FdScaleFactor.Send(Value);
end;

function TTransformNode_1.GetScaleOrientation: TVector4;
begin
  Result := FdScaleOrientation.Value;
end;

procedure TTransformNode_1.SetScaleOrientation(const Value: TVector4);
begin
  FdScaleOrientation.Send(Value);
end;

function TTransformNode_1.GetCenter: TVector3;
begin
  Result := FdCenter.Value;
end;

procedure TTransformNode_1.SetCenter(const Value: TVector3);
begin
  FdCenter.Send(Value);
end;

class function TTransformNode_1.ForVRMLVersion(const Version: TX3DVersion): Boolean;
begin
  Result := Version.Major <= 1; // parse this node only in VRML 1.0 and Inventor files
end;

class function TTransformNode_1.ClassX3DType: String;
begin
  Result := 'Transform';
end;

procedure TTransformNode_1.CreateNode;
begin
  inherited;

  FFdTranslation := TSFVec3f.Create(Self, True, 'translation', Vector3(0, 0, 0));
   FdTranslation.ChangeAlways := chEverything;
  AddField(FFdTranslation);

  FFdRotation := TSFRotation.Create(Self, True, 'rotation', Vector3(0, 0, 1), 0);
   FdRotation.ChangeAlways := chEverything;
  AddField(FFdRotation);

  FFdScaleFactor := TSFVec3f.Create(Self, True, 'scaleFactor', Vector3(1, 1, 1));
   FdScaleFactor.ChangeAlways := chEverything;
  AddField(FFdScaleFactor);

  FFdScaleOrientation := TSFRotation.Create(Self, True, 'scaleOrientation', Vector3(0, 0, 1), 0);
   FdScaleOrientation.ChangeAlways := chEverything;
  AddField(FFdScaleOrientation);

  FFdCenter := TSFVec3f.Create(Self, True, 'center', Vector3(0, 0, 0));
   FdCenter.ChangeAlways := chEverything;
  AddField(FFdCenter);
end;

{$endif read_implementation}
