-module(wx_test_enums).
-export([test/0]).

-include("wx_test_lib.hrl").

t(Name, {ignore, _Name}) ->
    try
         _Val = wxe_util:get_const(Name), %% Assert
         %% io:format("Varies: ~p ~p~n", [_Name, _Val]),
         ok
    catch _:{badmatch,[]} ->
        io:format("Not found: ~p ~p~n", [Name, {ignore, _Name}]),
       fail
    end;
t(Name, D1) -> t2(Name, D1, (catch wxe_util:get_const(Name))).

t2(_Name, D1, D1) -> ok;
t2(_Name, _D1, undefined) -> ok;  %% Not available in this version
t2(Name, D1, {'EXIT', {D2,_}}) ->
    io:format("Fail: ~p ~p ~p~n", [Name, D1, D2]);
t2(Name, D1, D2) ->
    io:format("Fail: ~p ~p ~p~n", [Name, D1, D2]),
    %% ?m({Name, D1}, {Name, D2}),
    ok.
test() ->
   wx:new(),
    t(wxDefaultCoord, ?wxDefaultCoord),
    t(wxDefaultSize, ?wxDefaultSize),
    t(wxDefaultPosition, ?wxDefaultPosition),
    t(wx_GL_CORE_PROFILE, {ignore, "WX_GL_CORE_PROFILE"}),
    t(wx_GL_MAJOR_VERSION, {ignore, "WX_GL_MAJOR_VERSION"}),
    t(wx_GL_MINOR_VERSION, {ignore, "WX_GL_MINOR_VERSION"}),
    t(wxBLACK, {ignore, "wxBLACK"}),
    t(wxBLACK_BRUSH, {ignore, "wxBLACK_BRUSH"}),
    t(wxBLACK_DASHED_PEN, {ignore, "wxBLACK_DASHED_PEN"}),
    t(wxBLACK_PEN, {ignore, "wxBLACK_PEN"}),
    t(wxBLUE, {ignore, "wxBLUE"}),
    t(wxBLUE_BRUSH, {ignore, "wxBLUE_BRUSH"}),
    t(wxCROSS_CURSOR, {ignore, "wxCROSS_CURSOR"}),
    t(wxCYAN, {ignore, "wxCYAN"}),
    t(wxCYAN_BRUSH, {ignore, "wxCYAN_BRUSH"}),
    t(wxCYAN_PEN, {ignore, "wxCYAN_PEN"}),
    t(wxGREEN, {ignore, "wxGREEN"}),
    t(wxGREEN_BRUSH, {ignore, "wxGREEN_BRUSH"}),
    t(wxGREEN_PEN, {ignore, "wxGREEN_PEN"}),
    t(wxGREY_BRUSH, {ignore, "wxGREY_BRUSH"}),
    t(wxGREY_PEN, {ignore, "wxGREY_PEN"}),
    t(wxHOURGLASS_CURSOR, {ignore, "wxHOURGLASS_CURSOR"}),
    t(wxITALIC_FONT, {ignore, "wxITALIC_FONT"}),
    t(wxLIGHT_GREY, {ignore, "wxLIGHT_GREY"}),
    t(wxLIGHT_GREY_BRUSH, {ignore, "wxLIGHT_GREY_BRUSH"}),
    t(wxLIGHT_GREY_PEN, {ignore, "wxLIGHT_GREY_PEN"}),
    t(wxMEDIUM_GREY_BRUSH, {ignore, "wxMEDIUM_GREY_BRUSH"}),
    t(wxMEDIUM_GREY_PEN, {ignore, "wxMEDIUM_GREY_PEN"}),
    t(wxNORMAL_FONT, {ignore, "wxNORMAL_FONT"}),
    t(wxNullBitmap, {ignore, "wxNullBitmap"}),
    t(wxNullBrush, {ignore, "wxNullBrush"}),
    t(wxNullCursor, {ignore, "wxNullCursor"}),
    t(wxNullFont, {ignore, "wxNullFont"}),
    t(wxNullIcon, {ignore, "wxNullIcon"}),
    t(wxNullPalette, {ignore, "wxNullPalette"}),
    t(wxNullPen, {ignore, "wxNullPen"}),
    t(wxRED, {ignore, "wxRED"}),
    t(wxRED_BRUSH, {ignore, "wxRED_BRUSH"}),
    t(wxRED_PEN, {ignore, "wxRED_PEN"}),
    t(wxSMALL_FONT, {ignore, "wxSMALL_FONT"}),
    t(wxSTANDARD_CURSOR, {ignore, "wxSTANDARD_CURSOR"}),
    t(wxSWISS_FONT, {ignore, "wxSWISS_FONT"}),
    t(wxTRANSPARENT_BRUSH, {ignore, "wxTRANSPARENT_BRUSH"}),
    t(wxTRANSPARENT_PEN, {ignore, "wxTRANSPARENT_PEN"}),
    t(wxWHITE, {ignore, "wxWHITE"}),
    t(wxWHITE_BRUSH, {ignore, "wxWHITE_BRUSH"}),
    t(wxWHITE_PEN, {ignore, "wxWHITE_PEN"}),
    t(wxACCEL_NORMAL, ?wxACCEL_NORMAL),
    t(wxACCEL_ALT, ?wxACCEL_ALT),
    t(wxACCEL_CTRL, ?wxACCEL_CTRL),
    t(wxACCEL_SHIFT, ?wxACCEL_SHIFT),
    t(wxACCEL_RAW_CTRL, {ignore, "wxACCEL_RAW_CTRL"}),
    t(wxACCEL_CMD, ?wxACCEL_CMD),
    t(wxTB_FLAT, ?wxTB_FLAT),
    t(wxTB_DOCKABLE, ?wxTB_DOCKABLE),
    t(wxTB_NOICONS, ?wxTB_NOICONS),
    t(wxTB_TEXT, ?wxTB_TEXT),
    t(wxTB_NODIVIDER, ?wxTB_NODIVIDER),
    t(wxTB_NOALIGN, ?wxTB_NOALIGN),
    t(wxTB_HORZ_LAYOUT, ?wxTB_HORZ_LAYOUT),
    t(wxTB_NO_TOOLTIPS, ?wxTB_NO_TOOLTIPS),
    t(wxTB_BOTTOM, ?wxTB_BOTTOM),
    t(wxTB_RIGHT, ?wxTB_RIGHT),
    t(wxMOUSE_BTN_AUX2, ?wxMOUSE_BTN_AUX2),
    t(wxMOUSE_BTN_AUX1, ?wxMOUSE_BTN_AUX1),
    t(wxAUI_INSERT_PANE, ?wxAUI_INSERT_PANE),
    t(wxAUI_INSERT_ROW, ?wxAUI_INSERT_ROW),
    t(wxAUI_INSERT_DOCK, ?wxAUI_INSERT_DOCK),
    t(wxBU_NOTEXT, ?wxBU_NOTEXT),
    t(wxBU_EXACTFIT, ?wxBU_EXACTFIT),
    t(wxBU_ALIGN_MASK, ?wxBU_ALIGN_MASK),
    t(wxBU_BOTTOM, ?wxBU_BOTTOM),
    t(wxBU_RIGHT, ?wxBU_RIGHT),
    t(wxBU_TOP, ?wxBU_TOP),
    t(wxBU_LEFT, ?wxBU_LEFT),
    t(wxAUI_NB_TOP, ?wxAUI_NB_TOP),
    t(wxAUI_NB_LEFT, ?wxAUI_NB_LEFT),
    t(wxAUI_NB_RIGHT, ?wxAUI_NB_RIGHT),
    t(wxAUI_NB_BOTTOM, ?wxAUI_NB_BOTTOM),
    t(wxAUI_NB_TAB_SPLIT, ?wxAUI_NB_TAB_SPLIT),
    t(wxAUI_NB_TAB_MOVE, ?wxAUI_NB_TAB_MOVE),
    t(wxAUI_NB_TAB_EXTERNAL_MOVE, ?wxAUI_NB_TAB_EXTERNAL_MOVE),
    t(wxAUI_NB_TAB_FIXED_WIDTH, ?wxAUI_NB_TAB_FIXED_WIDTH),
    t(wxAUI_NB_SCROLL_BUTTONS, ?wxAUI_NB_SCROLL_BUTTONS),
    t(wxAUI_NB_WINDOWLIST_BUTTON, ?wxAUI_NB_WINDOWLIST_BUTTON),
    t(wxAUI_NB_CLOSE_BUTTON, ?wxAUI_NB_CLOSE_BUTTON),
    t(wxAUI_NB_CLOSE_ON_ACTIVE_TAB, ?wxAUI_NB_CLOSE_ON_ACTIVE_TAB),
    t(wxAUI_NB_CLOSE_ON_ALL_TABS, ?wxAUI_NB_CLOSE_ON_ALL_TABS),
    t(wxAUI_NB_MIDDLE_CLICK_CLOSE, ?wxAUI_NB_MIDDLE_CLICK_CLOSE),
    t(wxAUI_NB_DEFAULT_STYLE, ?wxAUI_NB_DEFAULT_STYLE),
    t(wxBITMAP_SCREEN_DEPTH, ?wxBITMAP_SCREEN_DEPTH),
    t(wxBK_HITTEST_NOWHERE, ?wxBK_HITTEST_NOWHERE),
    t(wxBK_HITTEST_ONICON, ?wxBK_HITTEST_ONICON),
    t(wxBK_HITTEST_ONLABEL, ?wxBK_HITTEST_ONLABEL),
    t(wxBK_HITTEST_ONPAGE, ?wxBK_HITTEST_ONPAGE),
    t(wxBK_ALIGN_MASK, ?wxBK_ALIGN_MASK),
    t(wxBK_RIGHT, ?wxBK_RIGHT),
    t(wxBK_LEFT, ?wxBK_LEFT),
    t(wxBK_BOTTOM, ?wxBK_BOTTOM),
    t(wxBK_TOP, ?wxBK_TOP),
    t(wxBK_DEFAULT, ?wxBK_DEFAULT),
    t(wxBRUSHSTYLE_INVALID, ?wxBRUSHSTYLE_INVALID),
    t(wxBRUSHSTYLE_SOLID, ?wxBRUSHSTYLE_SOLID),
    t(wxBRUSHSTYLE_TRANSPARENT, ?wxBRUSHSTYLE_TRANSPARENT),
    t(wxBRUSHSTYLE_STIPPLE_MASK_OPAQUE, ?wxBRUSHSTYLE_STIPPLE_MASK_OPAQUE),
    t(wxBRUSHSTYLE_STIPPLE_MASK, ?wxBRUSHSTYLE_STIPPLE_MASK),
    t(wxBRUSHSTYLE_STIPPLE, ?wxBRUSHSTYLE_STIPPLE),
    t(wxBRUSHSTYLE_BDIAGONAL_HATCH, ?wxBRUSHSTYLE_BDIAGONAL_HATCH),
    t(wxBRUSHSTYLE_CROSSDIAG_HATCH, ?wxBRUSHSTYLE_CROSSDIAG_HATCH),
    t(wxBRUSHSTYLE_FDIAGONAL_HATCH, ?wxBRUSHSTYLE_FDIAGONAL_HATCH),
    t(wxBRUSHSTYLE_CROSS_HATCH, ?wxBRUSHSTYLE_CROSS_HATCH),
    t(wxBRUSHSTYLE_HORIZONTAL_HATCH, ?wxBRUSHSTYLE_HORIZONTAL_HATCH),
    t(wxBRUSHSTYLE_VERTICAL_HATCH, ?wxBRUSHSTYLE_VERTICAL_HATCH),
    t(wxBRUSHSTYLE_FIRST_HATCH, ?wxBRUSHSTYLE_FIRST_HATCH),
    t(wxBRUSHSTYLE_LAST_HATCH, ?wxBRUSHSTYLE_LAST_HATCH),
    t(wxCAL_MONDAY_FIRST, ?wxCAL_MONDAY_FIRST),
    t(wxCAL_SHOW_HOLIDAYS, ?wxCAL_SHOW_HOLIDAYS),
    t(wxCAL_NO_YEAR_CHANGE, ?wxCAL_NO_YEAR_CHANGE),
    t(wxCAL_NO_MONTH_CHANGE, ?wxCAL_NO_MONTH_CHANGE),
    t(wxCAL_SEQUENTIAL_MONTH_SELECTION, ?wxCAL_SEQUENTIAL_MONTH_SELECTION),
    t(wxCAL_SHOW_SURROUNDING_WEEKS, ?wxCAL_SHOW_SURROUNDING_WEEKS),
    t(wxCAL_SHOW_WEEK_NUMBERS, ?wxCAL_SHOW_WEEK_NUMBERS),
    t(wxCAL_BORDER_NONE, ?wxCAL_BORDER_NONE),
    t(wxCAL_BORDER_SQUARE, ?wxCAL_BORDER_SQUARE),
    t(wxCAL_BORDER_ROUND, ?wxCAL_BORDER_ROUND),
    t(wxCAL_HITTEST_NOWHERE, ?wxCAL_HITTEST_NOWHERE),
    t(wxCAL_HITTEST_HEADER, ?wxCAL_HITTEST_HEADER),
    t(wxCAL_HITTEST_DAY, ?wxCAL_HITTEST_DAY),
    t(wxCAL_HITTEST_INCMONTH, ?wxCAL_HITTEST_INCMONTH),
    t(wxCAL_HITTEST_DECMONTH, ?wxCAL_HITTEST_DECMONTH),
    t(wxCAL_HITTEST_SURROUNDING_WEEK, ?wxCAL_HITTEST_SURROUNDING_WEEK),
    t(wxCAL_HITTEST_WEEK, ?wxCAL_HITTEST_WEEK),
    t(wxCHK_ALLOW_3RD_STATE_FOR_USER, ?wxCHK_ALLOW_3RD_STATE_FOR_USER),
    t(wxCHK_3STATE, ?wxCHK_3STATE),
    t(wxCHK_2STATE, ?wxCHK_2STATE),
    t(wxCHK_UNCHECKED, ?wxCHK_UNCHECKED),
    t(wxCHK_CHECKED, ?wxCHK_CHECKED),
    t(wxCHK_UNDETERMINED, ?wxCHK_UNDETERMINED),
    t(wxCHOICEDLG_STYLE, ?wxCHOICEDLG_STYLE),
    t(wxCHOICE_HEIGHT, ?wxCHOICE_HEIGHT),
    t(wxCHOICE_WIDTH, ?wxCHOICE_WIDTH),
    t(wxCHB_ALIGN_MASK, ?wxCHB_ALIGN_MASK),
    t(wxCHB_RIGHT, ?wxCHB_RIGHT),
    t(wxCHB_LEFT, ?wxCHB_LEFT),
    t(wxCHB_BOTTOM, ?wxCHB_BOTTOM),
    t(wxCHB_TOP, ?wxCHB_TOP),
    t(wxCHB_DEFAULT, ?wxCHB_DEFAULT),
    t(wxActivateEvent_Reason_Mouse, ?wxActivateEvent_Reason_Mouse),
    t(wxActivateEvent_Reason_Unknown, ?wxActivateEvent_Reason_Unknown),
    t(wxAuiNotebook_NO_IMAGE, ?wxAuiNotebook_NO_IMAGE),
    t(wxBookCtrlBase_NO_IMAGE, ?wxBookCtrlBase_NO_IMAGE),
    t(wxChoicebook_NO_IMAGE, ?wxChoicebook_NO_IMAGE),
    t(wxColourData_NUM_CUSTOM, ?wxColourData_NUM_CUSTOM),
    t(wxDataObject_Get, ?wxDataObject_Get),
    t(wxDataObject_Set, ?wxDataObject_Set),
    t(wxDataObject_Both, ?wxDataObject_Both),
    t(wxDateTime_Gregorian, ?wxDateTime_Gregorian),
    t(wxDateTime_Julian, ?wxDateTime_Julian),
    t(wxDateTime_Country_Unknown, ?wxDateTime_Country_Unknown),
    t(wxDateTime_Country_Default, ?wxDateTime_Country_Default),
    t(wxDateTime_Country_WesternEurope_Start, ?wxDateTime_Country_WesternEurope_Start),
    t(wxDateTime_Country_EEC, ?wxDateTime_Country_EEC),
    t(wxDateTime_France, ?wxDateTime_France),
    t(wxDateTime_Germany, ?wxDateTime_Germany),
    t(wxDateTime_UK, ?wxDateTime_UK),
    t(wxDateTime_Country_WesternEurope_End, ?wxDateTime_Country_WesternEurope_End),
    t(wxDateTime_Russia, ?wxDateTime_Russia),
    t(wxDateTime_USA, ?wxDateTime_USA),
    t(wxDateTime_Jan, ?wxDateTime_Jan),
    t(wxDateTime_Feb, ?wxDateTime_Feb),
    t(wxDateTime_Mar, ?wxDateTime_Mar),
    t(wxDateTime_Apr, ?wxDateTime_Apr),
    t(wxDateTime_May, ?wxDateTime_May),
    t(wxDateTime_Jun, ?wxDateTime_Jun),
    t(wxDateTime_Jul, ?wxDateTime_Jul),
    t(wxDateTime_Aug, ?wxDateTime_Aug),
    t(wxDateTime_Sep, ?wxDateTime_Sep),
    t(wxDateTime_Oct, ?wxDateTime_Oct),
    t(wxDateTime_Nov, ?wxDateTime_Nov),
    t(wxDateTime_Dec, ?wxDateTime_Dec),
    t(wxDateTime_Inv_Month, ?wxDateTime_Inv_Month),
    t(wxDateTime_Name_Full, ?wxDateTime_Name_Full),
    t(wxDateTime_Name_Abbr, ?wxDateTime_Name_Abbr),
    t(wxDateTime_Local, ?wxDateTime_Local),
    t(wxDateTime_GMT_12, ?wxDateTime_GMT_12),
    t(wxDateTime_GMT_11, ?wxDateTime_GMT_11),
    t(wxDateTime_GMT_10, ?wxDateTime_GMT_10),
    t(wxDateTime_GMT_9, ?wxDateTime_GMT_9),
    t(wxDateTime_GMT_8, ?wxDateTime_GMT_8),
    t(wxDateTime_GMT_7, ?wxDateTime_GMT_7),
    t(wxDateTime_GMT_6, ?wxDateTime_GMT_6),
    t(wxDateTime_GMT_5, ?wxDateTime_GMT_5),
    t(wxDateTime_GMT_4, ?wxDateTime_GMT_4),
    t(wxDateTime_GMT_3, ?wxDateTime_GMT_3),
    t(wxDateTime_GMT_2, ?wxDateTime_GMT_2),
    t(wxDateTime_GMT_1, ?wxDateTime_GMT_1),
    t(wxDateTime_GMT0, ?wxDateTime_GMT0),
    t(wxDateTime_GMT1, ?wxDateTime_GMT1),
    t(wxDateTime_GMT2, ?wxDateTime_GMT2),
    t(wxDateTime_GMT3, ?wxDateTime_GMT3),
    t(wxDateTime_GMT4, ?wxDateTime_GMT4),
    t(wxDateTime_GMT5, ?wxDateTime_GMT5),
    t(wxDateTime_GMT6, ?wxDateTime_GMT6),
    t(wxDateTime_GMT7, ?wxDateTime_GMT7),
    t(wxDateTime_GMT8, ?wxDateTime_GMT8),
    t(wxDateTime_GMT9, ?wxDateTime_GMT9),
    t(wxDateTime_GMT10, ?wxDateTime_GMT10),
    t(wxDateTime_GMT11, ?wxDateTime_GMT11),
    t(wxDateTime_GMT12, ?wxDateTime_GMT12),
    t(wxDateTime_GMT13, ?wxDateTime_GMT13),
    t(wxDateTime_WET, ?wxDateTime_WET),
    t(wxDateTime_WEST, ?wxDateTime_WEST),
    t(wxDateTime_CET, ?wxDateTime_CET),
    t(wxDateTime_CEST, ?wxDateTime_CEST),
    t(wxDateTime_EET, ?wxDateTime_EET),
    t(wxDateTime_EEST, ?wxDateTime_EEST),
    t(wxDateTime_MSK, ?wxDateTime_MSK),
    t(wxDateTime_MSD, ?wxDateTime_MSD),
    t(wxDateTime_AST, ?wxDateTime_AST),
    t(wxDateTime_ADT, ?wxDateTime_ADT),
    t(wxDateTime_EST, ?wxDateTime_EST),
    t(wxDateTime_EDT, ?wxDateTime_EDT),
    t(wxDateTime_CST, ?wxDateTime_CST),
    t(wxDateTime_CDT, ?wxDateTime_CDT),
    t(wxDateTime_MST, ?wxDateTime_MST),
    t(wxDateTime_MDT, ?wxDateTime_MDT),
    t(wxDateTime_PST, ?wxDateTime_PST),
    t(wxDateTime_PDT, ?wxDateTime_PDT),
    t(wxDateTime_HST, ?wxDateTime_HST),
    t(wxDateTime_AKST, ?wxDateTime_AKST),
    t(wxDateTime_AKDT, ?wxDateTime_AKDT),
    t(wxDateTime_A_WST, ?wxDateTime_A_WST),
    t(wxDateTime_A_CST, ?wxDateTime_A_CST),
    t(wxDateTime_A_EST, ?wxDateTime_A_EST),
    t(wxDateTime_A_ESST, ?wxDateTime_A_ESST),
    t(wxDateTime_NZST, ?wxDateTime_NZST),
    t(wxDateTime_NZDT, ?wxDateTime_NZDT),
    t(wxDateTime_UTC, ?wxDateTime_UTC),
    t(wxDateTime_Sun, ?wxDateTime_Sun),
    t(wxDateTime_Mon, ?wxDateTime_Mon),
    t(wxDateTime_Tue, ?wxDateTime_Tue),
    t(wxDateTime_Wed, ?wxDateTime_Wed),
    t(wxDateTime_Thu, ?wxDateTime_Thu),
    t(wxDateTime_Fri, ?wxDateTime_Fri),
    t(wxDateTime_Sat, ?wxDateTime_Sat),
    t(wxDateTime_Inv_WeekDay, ?wxDateTime_Inv_WeekDay),
    t(wxDateTime_Default_First, ?wxDateTime_Default_First),
    t(wxDateTime_Monday_First, ?wxDateTime_Monday_First),
    t(wxDateTime_Sunday_First, ?wxDateTime_Sunday_First),
    t(wxDateTime_Inv_Year, ?wxDateTime_Inv_Year),
    t(wxGrid_CellSpan_Inside, ?wxGrid_CellSpan_Inside),
    t(wxGrid_CellSpan_None, ?wxGrid_CellSpan_None),
    t(wxGrid_CellSpan_Main, ?wxGrid_CellSpan_Main),
    t(wxGrid_Tab_Stop, ?wxGrid_Tab_Stop),
    t(wxGrid_Tab_Wrap, ?wxGrid_Tab_Wrap),
    t(wxGrid_Tab_Leave, ?wxGrid_Tab_Leave),
    t(wxGrid_wxGridSelectCells, ?wxGrid_wxGridSelectCells),
    t(wxGrid_wxGridSelectRows, ?wxGrid_wxGridSelectRows),
    t(wxGrid_wxGridSelectColumns, ?wxGrid_wxGridSelectColumns),
    t(wxGrid_wxGridSelectRowsOrColumns, ?wxGrid_wxGridSelectRowsOrColumns),
    t(wxGridCellAttr_Any, ?wxGridCellAttr_Any),
    t(wxGridCellAttr_Default, ?wxGridCellAttr_Default),
    t(wxGridCellAttr_Cell, ?wxGridCellAttr_Cell),
    t(wxGridCellAttr_Row, ?wxGridCellAttr_Row),
    t(wxGridCellAttr_Col, ?wxGridCellAttr_Col),
    t(wxGridCellAttr_Merged, ?wxGridCellAttr_Merged),
    t(wxHelpEvent_Origin_Unknown, ?wxHelpEvent_Origin_Unknown),
    t(wxHelpEvent_Origin_Keyboard, ?wxHelpEvent_Origin_Keyboard),
    t(wxHelpEvent_Origin_HelpButton, ?wxHelpEvent_Origin_HelpButton),
    t(wxHtmlEasyPrinting_Prompt_Never, ?wxHtmlEasyPrinting_Prompt_Never),
    t(wxHtmlEasyPrinting_Prompt_Once, ?wxHtmlEasyPrinting_Prompt_Once),
    t(wxHtmlEasyPrinting_Prompt_Always, ?wxHtmlEasyPrinting_Prompt_Always),
    t(wxIconBundle_FALLBACK_NONE, ?wxIconBundle_FALLBACK_NONE),
    t(wxIconBundle_FALLBACK_SYSTEM, ?wxIconBundle_FALLBACK_SYSTEM),
    t(wxIconBundle_FALLBACK_NEAREST_LARGER, ?wxIconBundle_FALLBACK_NEAREST_LARGER),
    t(wxListbook_NO_IMAGE, ?wxListbook_NO_IMAGE),
    t(wxNavigationKeyEvent_IsBackward, ?wxNavigationKeyEvent_IsBackward),
    t(wxNavigationKeyEvent_IsForward, ?wxNavigationKeyEvent_IsForward),
    t(wxNavigationKeyEvent_WinChange, ?wxNavigationKeyEvent_WinChange),
    t(wxNavigationKeyEvent_FromTab, ?wxNavigationKeyEvent_FromTab),
    t(wxNotebook_NO_IMAGE, ?wxNotebook_NO_IMAGE),
    t(wxStaticBitmap_Scale_None, ?wxStaticBitmap_Scale_None),
    t(wxStaticBitmap_Scale_Fill, ?wxStaticBitmap_Scale_Fill),
    t(wxStaticBitmap_Scale_AspectFit, ?wxStaticBitmap_Scale_AspectFit),
    t(wxStaticBitmap_Scale_AspectFill, ?wxStaticBitmap_Scale_AspectFill),
    t(wxToolbook_NO_IMAGE, ?wxToolbook_NO_IMAGE),
    t(wxTreebook_NO_IMAGE, ?wxTreebook_NO_IMAGE),
    t(wxCLRP_SHOW_ALPHA, ?wxCLRP_SHOW_ALPHA),
    t(wxCLRP_SHOW_LABEL, ?wxCLRP_SHOW_LABEL),
    t(wxCLRP_DEFAULT_STYLE, ?wxCLRP_DEFAULT_STYLE),
    t(wxCLRP_USE_TEXTCTRL, ?wxCLRP_USE_TEXTCTRL),
    t(wxPRINTBIN_DEFAULT, ?wxPRINTBIN_DEFAULT),
    t(wxPRINTBIN_ONLYONE, ?wxPRINTBIN_ONLYONE),
    t(wxPRINTBIN_LOWER, ?wxPRINTBIN_LOWER),
    t(wxPRINTBIN_MIDDLE, ?wxPRINTBIN_MIDDLE),
    t(wxPRINTBIN_MANUAL, ?wxPRINTBIN_MANUAL),
    t(wxPRINTBIN_ENVELOPE, ?wxPRINTBIN_ENVELOPE),
    t(wxPRINTBIN_ENVMANUAL, ?wxPRINTBIN_ENVMANUAL),
    t(wxPRINTBIN_AUTO, ?wxPRINTBIN_AUTO),
    t(wxPRINTBIN_TRACTOR, ?wxPRINTBIN_TRACTOR),
    t(wxPRINTBIN_SMALLFMT, ?wxPRINTBIN_SMALLFMT),
    t(wxPRINTBIN_LARGEFMT, ?wxPRINTBIN_LARGEFMT),
    t(wxPRINTBIN_LARGECAPACITY, ?wxPRINTBIN_LARGECAPACITY),
    t(wxPRINTBIN_CASSETTE, ?wxPRINTBIN_CASSETTE),
    t(wxPRINTBIN_FORMSOURCE, ?wxPRINTBIN_FORMSOURCE),
    t(wxPRINTBIN_USER, ?wxPRINTBIN_USER),
    t(wxDP_DEFAULT, ?wxDP_DEFAULT),
    t(wxDP_SPIN, ?wxDP_SPIN),
    t(wxDP_DROPDOWN, ?wxDP_DROPDOWN),
    t(wxDP_SHOWCENTURY, ?wxDP_SHOWCENTURY),
    t(wxDP_ALLOWNONE, ?wxDP_ALLOWNONE),
    t(wxFLOOD_SURFACE, ?wxFLOOD_SURFACE),
    t(wxFLOOD_BORDER, ?wxFLOOD_BORDER),
    t(wxMM_TEXT, ?wxMM_TEXT),
    t(wxMM_METRIC, ?wxMM_METRIC),
    t(wxMM_LOMETRIC, ?wxMM_LOMETRIC),
    t(wxMM_TWIPS, ?wxMM_TWIPS),
    t(wxMM_POINTS, ?wxMM_POINTS),
    t(wxCLEAR, ?wxCLEAR),
    t(wxXOR, ?wxXOR),
    t(wxINVERT, ?wxINVERT),
    t(wxOR_REVERSE, ?wxOR_REVERSE),
    t(wxAND_REVERSE, ?wxAND_REVERSE),
    t(wxCOPY, ?wxCOPY),
    t(wxAND, ?wxAND),
    t(wxAND_INVERT, ?wxAND_INVERT),
    t(wxNO_OP, ?wxNO_OP),
    t(wxNOR, ?wxNOR),
    t(wxEQUIV, ?wxEQUIV),
    t(wxSRC_INVERT, ?wxSRC_INVERT),
    t(wxOR_INVERT, ?wxOR_INVERT),
    t(wxNAND, ?wxNAND),
    t(wxOR, ?wxOR),
    t(wxSET, ?wxSET),
    t(wxALWAYS_NATIVE_DOUBLE_BUFFER, {ignore, "wxALWAYS_NATIVE_DOUBLE_BUFFER"}),
    t(wxBUFFER_USES_SHARED_BUFFER, ?wxBUFFER_USES_SHARED_BUFFER),
    t(wxBUFFER_CLIENT_AREA, ?wxBUFFER_CLIENT_AREA),
    t(wxBUFFER_VIRTUAL_AREA, ?wxBUFFER_VIRTUAL_AREA),
    t(wxRESIZE_BORDER, ?wxRESIZE_BORDER),
    t(wxTINY_CAPTION, ?wxTINY_CAPTION),
    t(wxMAXIMIZE_BOX, ?wxMAXIMIZE_BOX),
    t(wxMINIMIZE_BOX, ?wxMINIMIZE_BOX),
    t(wxSYSTEM_MENU, ?wxSYSTEM_MENU),
    t(wxCLOSE_BOX, ?wxCLOSE_BOX),
    t(wxMAXIMIZE, ?wxMAXIMIZE),
    t(wxMINIMIZE, ?wxMINIMIZE),
    t(wxICONIZE, ?wxICONIZE),
    t(wxSTAY_ON_TOP, ?wxSTAY_ON_TOP),
    t(wxBETA_NUMBER, {ignore, "wxBETA_NUMBER"}),
    t(wxSUBRELEASE_NUMBER, {ignore, "wxSUBRELEASE_NUMBER"}),
    t(wxRELEASE_NUMBER, {ignore, "wxRELEASE_NUMBER"}),
    t(wxMINOR_VERSION, {ignore, "wxMINOR_VERSION"}),
    t(wxMAJOR_VERSION, {ignore, "wxMAJOR_VERSION"}),
    t(wxBROWSER_NEW_WINDOW, ?wxBROWSER_NEW_WINDOW),
    t(wxTOPLEVEL_EX_DIALOG, ?wxTOPLEVEL_EX_DIALOG),
    t(wxWS_EX_VALIDATE_RECURSIVELY, ?wxWS_EX_VALIDATE_RECURSIVELY),
    t(wxScrolledWindowStyle, ?wxScrolledWindowStyle),
    t(wxLC_USER_TEXT, ?wxLC_USER_TEXT),
    t(wxFRAME_SHAPED, ?wxFRAME_SHAPED),
    t(wxID_TREECTRL, ?wxID_TREECTRL),
    t(wxCENTER_ON_SCREEN, ?wxCENTER_ON_SCREEN),
    t(wxCENTRE_ON_SCREEN, ?wxCENTRE_ON_SCREEN),
    t(wxCENTER_FRAME, ?wxCENTER_FRAME),
    t(wxPRINT_QUALITY_DRAFT, ?wxPRINT_QUALITY_DRAFT),
    t(wxPRINT_QUALITY_LOW, ?wxPRINT_QUALITY_LOW),
    t(wxPRINT_QUALITY_MEDIUM, ?wxPRINT_QUALITY_MEDIUM),
    t(wxPRINT_QUALITY_HIGH, ?wxPRINT_QUALITY_HIGH),
    t(wxBG_STYLE_CUSTOM, {ignore, "wxBG_STYLE_CUSTOM"}),
    t(wxNOT_FOUND, ?wxNOT_FOUND),
    t(wxICON_MASK, ?wxICON_MASK),
    t(wxICON_AUTH_NEEDED, ?wxICON_AUTH_NEEDED),
    t(wxICON_NONE, ?wxICON_NONE),
    t(wxSETUP, ?wxSETUP),
    t(wxMORE, ?wxMORE),
    t(wxRESET, ?wxRESET),
    t(wxBACKWARD, ?wxBACKWARD),
    t(wxFORWARD, ?wxFORWARD),
    t(wxHELP, ?wxHELP),
    t(wxICON_ASTERISK, ?wxICON_ASTERISK),
    t(wxICON_STOP, ?wxICON_STOP),
    t(wxICON_INFORMATION, ?wxICON_INFORMATION),
    t(wxICON_QUESTION, ?wxICON_QUESTION),
    t(wxICON_ERROR, ?wxICON_ERROR),
    t(wxICON_WARNING, ?wxICON_WARNING),
    t(wxICON_HAND, ?wxICON_HAND),
    t(wxICON_EXCLAMATION, ?wxICON_EXCLAMATION),
    t(wxCANCEL_DEFAULT, ?wxCANCEL_DEFAULT),
    t(wxNO_DEFAULT, ?wxNO_DEFAULT),
    t(wxYES_DEFAULT, ?wxYES_DEFAULT),
    t(wxOK_DEFAULT, ?wxOK_DEFAULT),
    t(wxCLOSE, ?wxCLOSE),
    t(wxAPPLY, ?wxAPPLY),
    t(wxCANCEL, ?wxCANCEL),
    t(wxYES_NO, ?wxYES_NO),
    t(wxNO, ?wxNO),
    t(wxOK, ?wxOK),
    t(wxYES, ?wxYES),
    t(wxLI_VERTICAL, ?wxLI_VERTICAL),
    t(wxLI_HORIZONTAL, ?wxLI_HORIZONTAL),
    t(wxBI_EXPAND, ?wxBI_EXPAND),
    t(wxTC_OWNERDRAW, ?wxTC_OWNERDRAW),
    t(wxTC_MULTILINE, ?wxTC_MULTILINE),
    t(wxTC_BOTTOM, ?wxTC_BOTTOM),
    t(wxTC_RIGHT, ?wxTC_RIGHT),
    t(wxTC_LEFT, ?wxTC_LEFT),
    t(wxTC_TOP, ?wxTC_TOP),
    t(wxTC_FIXEDWIDTH, ?wxTC_FIXEDWIDTH),
    t(wxTC_RIGHTJUSTIFY, ?wxTC_RIGHTJUSTIFY),
    t(wxSP_WRAP, ?wxSP_WRAP),
    t(wxSP_ARROW_KEYS, ?wxSP_ARROW_KEYS),
    t(wxSP_VERTICAL, ?wxSP_VERTICAL),
    t(wxSP_HORIZONTAL, ?wxSP_HORIZONTAL),
    t(wxSB_VERTICAL, ?wxSB_VERTICAL),
    t(wxSB_HORIZONTAL, ?wxSB_HORIZONTAL),
    t(wxRB_SINGLE, ?wxRB_SINGLE),
    t(wxRB_GROUP, ?wxRB_GROUP),
    t(wxRA_VERTICAL, ?wxRA_VERTICAL),
    t(wxRA_HORIZONTAL, ?wxRA_HORIZONTAL),
    t(wxRA_SPECIFY_ROWS, ?wxRA_SPECIFY_ROWS),
    t(wxRA_SPECIFY_COLS, ?wxRA_SPECIFY_COLS),
    t(wxRA_TOPTOBOTTOM, ?wxRA_TOPTOBOTTOM),
    t(wxRA_LEFTTORIGHT, ?wxRA_LEFTTORIGHT),
    t(wxCB_DROPDOWN, ?wxCB_DROPDOWN),
    t(wxCB_READONLY, ?wxCB_READONLY),
    t(wxCB_SORT, ?wxCB_SORT),
    t(wxCB_SIMPLE, ?wxCB_SIMPLE),
    t(wxLB_INT_HEIGHT, ?wxLB_INT_HEIGHT),
    t(wxLB_HSCROLL, ?wxLB_HSCROLL),
    t(wxLB_NO_SB, ?wxLB_NO_SB),
    t(wxLB_ALWAYS_SB, ?wxLB_ALWAYS_SB),
    t(wxLB_OWNERDRAW, ?wxLB_OWNERDRAW),
    t(wxLB_NEEDED_SB, ?wxLB_NEEDED_SB),
    t(wxLB_EXTENDED, ?wxLB_EXTENDED),
    t(wxLB_MULTIPLE, ?wxLB_MULTIPLE),
    t(wxLB_SINGLE, ?wxLB_SINGLE),
    t(wxLB_SORT, ?wxLB_SORT),
    t(wxFIXED_LENGTH, ?wxFIXED_LENGTH),
    t(wxCOLOURED, ?wxCOLOURED),
    t(wxMENU_TEAROFF, ?wxMENU_TEAROFF),
    t(wxMB_DOCKABLE, ?wxMB_DOCKABLE),
    t(wxFRAME_NO_WINDOW_MENU, ?wxFRAME_NO_WINDOW_MENU),
    t(wxFRAME_DRAWER, ?wxFRAME_DRAWER),
    t(wxDIALOG_EX_CONTEXTHELP, ?wxDIALOG_EX_CONTEXTHELP),
    t(wxFRAME_EX_CONTEXTHELP, ?wxFRAME_EX_CONTEXTHELP),
    t(wxWS_EX_CONTEXTHELP, ?wxWS_EX_CONTEXTHELP),
    t(wxDIALOG_EX_METAL, ?wxDIALOG_EX_METAL),
    t(wxFRAME_EX_METAL, ?wxFRAME_EX_METAL),
    t(wxWS_EX_PROCESS_UI_UPDATES, ?wxWS_EX_PROCESS_UI_UPDATES),
    t(wxWS_EX_PROCESS_IDLE, ?wxWS_EX_PROCESS_IDLE),
    t(wxWS_EX_THEMED_BACKGROUND, ?wxWS_EX_THEMED_BACKGROUND),
    t(wxWS_EX_TRANSIENT, ?wxWS_EX_TRANSIENT),
    t(wxWS_EX_BLOCK_EVENTS, ?wxWS_EX_BLOCK_EVENTS),
    t(wxWINDOW_STYLE_MASK, ?wxWINDOW_STYLE_MASK),
    t(wxNO_FULL_REPAINT_ON_RESIZE, ?wxNO_FULL_REPAINT_ON_RESIZE),
    t(wxFULL_REPAINT_ON_RESIZE, ?wxFULL_REPAINT_ON_RESIZE),
    t(wxPOPUP_WINDOW, ?wxPOPUP_WINDOW),
    t(wxBACKINGSTORE, ?wxBACKINGSTORE),
    t(wxRETAINED, {ignore, "wxRETAINED"}),
    t(wxWANTS_CHARS, ?wxWANTS_CHARS),
    t(wxTAB_TRAVERSAL, ?wxTAB_TRAVERSAL),
    t(wxTRANSPARENT_WINDOW, ?wxTRANSPARENT_WINDOW),
    t(wxCLIP_SIBLINGS, ?wxCLIP_SIBLINGS),
    t(wxCLIP_CHILDREN, ?wxCLIP_CHILDREN),
    t(wxALWAYS_SHOW_SB, ?wxALWAYS_SHOW_SB),
    t(wxNO_BORDER, ?wxNO_BORDER),
    t(wxSTATIC_BORDER, ?wxSTATIC_BORDER),
    t(wxSIMPLE_BORDER, ?wxSIMPLE_BORDER),
    t(wxBORDER, ?wxBORDER),
    t(wxRAISED_BORDER, ?wxRAISED_BORDER),
    t(wxSUNKEN_BORDER, ?wxSUNKEN_BORDER),
    t(wxDOUBLE_BORDER, ?wxDOUBLE_BORDER),
    t(wxCAPTION, ?wxCAPTION),
    t(wxHSCROLL, ?wxHSCROLL),
    t(wxVSCROLL, ?wxVSCROLL),
    t(wxSIZE_FORCE_EVENT, ?wxSIZE_FORCE_EVENT),
    t(wxSIZE_FORCE, ?wxSIZE_FORCE),
    t(wxSIZE_NO_ADJUSTMENTS, ?wxSIZE_NO_ADJUSTMENTS),
    t(wxSIZE_ALLOW_MINUS_ONE, ?wxSIZE_ALLOW_MINUS_ONE),
    t(wxSIZE_USE_EXISTING, ?wxSIZE_USE_EXISTING),
    t(wxSIZE_AUTO, ?wxSIZE_AUTO),
    t(wxSIZE_AUTO_HEIGHT, ?wxSIZE_AUTO_HEIGHT),
    t(wxSIZE_AUTO_WIDTH, ?wxSIZE_AUTO_WIDTH),
    t(wxDEFAULT_CONTROL_BORDER, {ignore, "wxDEFAULT_CONTROL_BORDER"}),
    t(wxALIGN_INVALID, ?wxALIGN_INVALID),
    t(wxALIGN_NOT, ?wxALIGN_NOT),
    t(wxALIGN_CENTER_HORIZONTAL, ?wxALIGN_CENTER_HORIZONTAL),
    t(wxALIGN_CENTRE_HORIZONTAL, ?wxALIGN_CENTRE_HORIZONTAL),
    t(wxALIGN_LEFT, ?wxALIGN_LEFT),
    t(wxALIGN_TOP, ?wxALIGN_TOP),
    t(wxALIGN_RIGHT, ?wxALIGN_RIGHT),
    t(wxALIGN_BOTTOM, ?wxALIGN_BOTTOM),
    t(wxALIGN_CENTER_VERTICAL, ?wxALIGN_CENTER_VERTICAL),
    t(wxALIGN_CENTRE_VERTICAL, ?wxALIGN_CENTRE_VERTICAL),
    t(wxALIGN_CENTER, ?wxALIGN_CENTER),
    t(wxALIGN_CENTRE, ?wxALIGN_CENTRE),
    t(wxALIGN_MASK, ?wxALIGN_MASK),
    t(wxBG_STYLE_ERASE, {ignore, "wxBG_STYLE_ERASE"}),
    t(wxBG_STYLE_SYSTEM, {ignore, "wxBG_STYLE_SYSTEM"}),
    t(wxBG_STYLE_PAINT, {ignore, "wxBG_STYLE_PAINT"}),
    t(wxBG_STYLE_COLOUR, {ignore, "wxBG_STYLE_COLOUR"}),
    t(wxBG_STYLE_TRANSPARENT, {ignore, "wxBG_STYLE_TRANSPARENT"}),
    t(wxBORDER_DEFAULT, ?wxBORDER_DEFAULT),
    t(wxBORDER_NONE, ?wxBORDER_NONE),
    t(wxBORDER_STATIC, ?wxBORDER_STATIC),
    t(wxBORDER_SIMPLE, ?wxBORDER_SIMPLE),
    t(wxBORDER_RAISED, ?wxBORDER_RAISED),
    t(wxBORDER_SUNKEN, ?wxBORDER_SUNKEN),
    t(wxBORDER_DOUBLE, ?wxBORDER_DOUBLE),
    t(wxBORDER_THEME, ?wxBORDER_THEME),
    t(wxBORDER_MASK, ?wxBORDER_MASK),
    t(wxDF_INVALID, ?wxDF_INVALID),
    t(wxDF_TEXT, ?wxDF_TEXT),
    t(wxDF_BITMAP, ?wxDF_BITMAP),
    t(wxDF_METAFILE, ?wxDF_METAFILE),
    t(wxDF_SYLK, ?wxDF_SYLK),
    t(wxDF_DIF, ?wxDF_DIF),
    t(wxDF_TIFF, ?wxDF_TIFF),
    t(wxDF_OEMTEXT, ?wxDF_OEMTEXT),
    t(wxDF_DIB, ?wxDF_DIB),
    t(wxDF_PALETTE, ?wxDF_PALETTE),
    t(wxDF_PENDATA, ?wxDF_PENDATA),
    t(wxDF_RIFF, ?wxDF_RIFF),
    t(wxDF_WAVE, ?wxDF_WAVE),
    t(wxDF_UNICODETEXT, ?wxDF_UNICODETEXT),
    t(wxDF_ENHMETAFILE, ?wxDF_ENHMETAFILE),
    t(wxDF_FILENAME, ?wxDF_FILENAME),
    t(wxDF_LOCALE, ?wxDF_LOCALE),
    t(wxDF_PRIVATE, ?wxDF_PRIVATE),
    t(wxDF_HTML, ?wxDF_HTML),
    t(wxDF_MAX, ?wxDF_MAX),
    t(wxDEFAULT, ?wxDEFAULT),
    t(wxDECORATIVE, ?wxDECORATIVE),
    t(wxROMAN, ?wxROMAN),
    t(wxSCRIPT, ?wxSCRIPT),
    t(wxSWISS, ?wxSWISS),
    t(wxMODERN, ?wxMODERN),
    t(wxTELETYPE, ?wxTELETYPE),
    t(wxVARIABLE, ?wxVARIABLE),
    t(wxFIXED, ?wxFIXED),
    t(wxNORMAL, ?wxNORMAL),
    t(wxLIGHT, ?wxLIGHT),
    t(wxBOLD, ?wxBOLD),
    t(wxITALIC, ?wxITALIC),
    t(wxSLANT, ?wxSLANT),
    t(wxSOLID, ?wxSOLID),
    t(wxDOT, ?wxDOT),
    t(wxLONG_DASH, ?wxLONG_DASH),
    t(wxSHORT_DASH, ?wxSHORT_DASH),
    t(wxDOT_DASH, ?wxDOT_DASH),
    t(wxUSER_DASH, ?wxUSER_DASH),
    t(wxTRANSPARENT, ?wxTRANSPARENT),
    t(wxSTIPPLE_MASK_OPAQUE, ?wxSTIPPLE_MASK_OPAQUE),
    t(wxSTIPPLE_MASK, ?wxSTIPPLE_MASK),
    t(wxSTIPPLE, ?wxSTIPPLE),
    t(wxBDIAGONAL_HATCH, ?wxBDIAGONAL_HATCH),
    t(wxCROSSDIAG_HATCH, ?wxCROSSDIAG_HATCH),
    t(wxFDIAGONAL_HATCH, ?wxFDIAGONAL_HATCH),
    t(wxCROSS_HATCH, ?wxCROSS_HATCH),
    t(wxHORIZONTAL_HATCH, ?wxHORIZONTAL_HATCH),
    t(wxVERTICAL_HATCH, ?wxVERTICAL_HATCH),
    t(wxFIRST_HATCH, ?wxFIRST_HATCH),
    t(wxLAST_HATCH, ?wxLAST_HATCH),
    t(wxLEFT, ?wxLEFT),
    t(wxRIGHT, ?wxRIGHT),
    t(wxUP, ?wxUP),
    t(wxDOWN, ?wxDOWN),
    t(wxTOP, ?wxTOP),
    t(wxBOTTOM, ?wxBOTTOM),
    t(wxNORTH, ?wxNORTH),
    t(wxSOUTH, ?wxSOUTH),
    t(wxWEST, ?wxWEST),
    t(wxEAST, ?wxEAST),
    t(wxALL, ?wxALL),
    t(wxDIRECTION_MASK, ?wxDIRECTION_MASK),
    t(wxDUPLEX_SIMPLEX, ?wxDUPLEX_SIMPLEX),
    t(wxDUPLEX_HORIZONTAL, ?wxDUPLEX_HORIZONTAL),
    t(wxDUPLEX_VERTICAL, ?wxDUPLEX_VERTICAL),
    t(wxCENTRE, ?wxCENTRE),
    t(wxCENTER, ?wxCENTER),
    t(wxHT_NOWHERE, ?wxHT_NOWHERE),
    t(wxHT_SCROLLBAR_FIRST, ?wxHT_SCROLLBAR_FIRST),
    t(wxHT_SCROLLBAR_ARROW_LINE_1, ?wxHT_SCROLLBAR_ARROW_LINE_1),
    t(wxHT_SCROLLBAR_ARROW_LINE_2, ?wxHT_SCROLLBAR_ARROW_LINE_2),
    t(wxHT_SCROLLBAR_ARROW_PAGE_1, ?wxHT_SCROLLBAR_ARROW_PAGE_1),
    t(wxHT_SCROLLBAR_ARROW_PAGE_2, ?wxHT_SCROLLBAR_ARROW_PAGE_2),
    t(wxHT_SCROLLBAR_THUMB, ?wxHT_SCROLLBAR_THUMB),
    t(wxHT_SCROLLBAR_BAR_1, ?wxHT_SCROLLBAR_BAR_1),
    t(wxHT_SCROLLBAR_BAR_2, ?wxHT_SCROLLBAR_BAR_2),
    t(wxHT_SCROLLBAR_LAST, ?wxHT_SCROLLBAR_LAST),
    t(wxHT_WINDOW_OUTSIDE, ?wxHT_WINDOW_OUTSIDE),
    t(wxHT_WINDOW_INSIDE, ?wxHT_WINDOW_INSIDE),
    t(wxHT_WINDOW_VERT_SCROLLBAR, ?wxHT_WINDOW_VERT_SCROLLBAR),
    t(wxHT_WINDOW_HORZ_SCROLLBAR, ?wxHT_WINDOW_HORZ_SCROLLBAR),
    t(wxHT_WINDOW_CORNER, ?wxHT_WINDOW_CORNER),
    t(wxHT_MAX, ?wxHT_MAX),
    t(wxITEM_SEPARATOR, ?wxITEM_SEPARATOR),
    t(wxITEM_NORMAL, ?wxITEM_NORMAL),
    t(wxITEM_CHECK, ?wxITEM_CHECK),
    t(wxITEM_RADIO, ?wxITEM_RADIO),
    t(wxITEM_DROPDOWN, ?wxITEM_DROPDOWN),
    t(wxk_NONE, ?WXK_NONE),
    t(wxk_CONTROL_A, ?WXK_CONTROL_A),
    t(wxk_CONTROL_B, ?WXK_CONTROL_B),
    t(wxk_CONTROL_C, ?WXK_CONTROL_C),
    t(wxk_CONTROL_D, ?WXK_CONTROL_D),
    t(wxk_CONTROL_E, ?WXK_CONTROL_E),
    t(wxk_CONTROL_F, ?WXK_CONTROL_F),
    t(wxk_CONTROL_G, ?WXK_CONTROL_G),
    t(wxk_CONTROL_H, ?WXK_CONTROL_H),
    t(wxk_CONTROL_I, ?WXK_CONTROL_I),
    t(wxk_CONTROL_J, ?WXK_CONTROL_J),
    t(wxk_CONTROL_K, ?WXK_CONTROL_K),
    t(wxk_CONTROL_L, ?WXK_CONTROL_L),
    t(wxk_CONTROL_M, ?WXK_CONTROL_M),
    t(wxk_CONTROL_N, ?WXK_CONTROL_N),
    t(wxk_CONTROL_O, ?WXK_CONTROL_O),
    t(wxk_CONTROL_P, ?WXK_CONTROL_P),
    t(wxk_CONTROL_Q, ?WXK_CONTROL_Q),
    t(wxk_CONTROL_R, ?WXK_CONTROL_R),
    t(wxk_CONTROL_S, ?WXK_CONTROL_S),
    t(wxk_CONTROL_T, ?WXK_CONTROL_T),
    t(wxk_CONTROL_U, ?WXK_CONTROL_U),
    t(wxk_CONTROL_V, ?WXK_CONTROL_V),
    t(wxk_CONTROL_W, ?WXK_CONTROL_W),
    t(wxk_CONTROL_X, ?WXK_CONTROL_X),
    t(wxk_CONTROL_Y, ?WXK_CONTROL_Y),
    t(wxk_CONTROL_Z, ?WXK_CONTROL_Z),
    t(wxk_BACK, ?WXK_BACK),
    t(wxk_TAB, ?WXK_TAB),
    t(wxk_RETURN, ?WXK_RETURN),
    t(wxk_ESCAPE, ?WXK_ESCAPE),
    t(wxk_SPACE, ?WXK_SPACE),
    t(wxk_DELETE, ?WXK_DELETE),
    t(wxk_START, ?WXK_START),
    t(wxk_LBUTTON, ?WXK_LBUTTON),
    t(wxk_RBUTTON, ?WXK_RBUTTON),
    t(wxk_CANCEL, ?WXK_CANCEL),
    t(wxk_MBUTTON, ?WXK_MBUTTON),
    t(wxk_CLEAR, ?WXK_CLEAR),
    t(wxk_SHIFT, ?WXK_SHIFT),
    t(wxk_ALT, ?WXK_ALT),
    t(wxk_CONTROL, ?WXK_CONTROL),
    t(wxk_MENU, ?WXK_MENU),
    t(wxk_PAUSE, ?WXK_PAUSE),
    t(wxk_CAPITAL, ?WXK_CAPITAL),
    t(wxk_END, ?WXK_END),
    t(wxk_HOME, ?WXK_HOME),
    t(wxk_LEFT, ?WXK_LEFT),
    t(wxk_UP, ?WXK_UP),
    t(wxk_RIGHT, ?WXK_RIGHT),
    t(wxk_DOWN, ?WXK_DOWN),
    t(wxk_SELECT, ?WXK_SELECT),
    t(wxk_PRINT, ?WXK_PRINT),
    t(wxk_EXECUTE, ?WXK_EXECUTE),
    t(wxk_SNAPSHOT, ?WXK_SNAPSHOT),
    t(wxk_INSERT, ?WXK_INSERT),
    t(wxk_HELP, ?WXK_HELP),
    t(wxk_NUMPAD0, ?WXK_NUMPAD0),
    t(wxk_NUMPAD1, ?WXK_NUMPAD1),
    t(wxk_NUMPAD2, ?WXK_NUMPAD2),
    t(wxk_NUMPAD3, ?WXK_NUMPAD3),
    t(wxk_NUMPAD4, ?WXK_NUMPAD4),
    t(wxk_NUMPAD5, ?WXK_NUMPAD5),
    t(wxk_NUMPAD6, ?WXK_NUMPAD6),
    t(wxk_NUMPAD7, ?WXK_NUMPAD7),
    t(wxk_NUMPAD8, ?WXK_NUMPAD8),
    t(wxk_NUMPAD9, ?WXK_NUMPAD9),
    t(wxk_MULTIPLY, ?WXK_MULTIPLY),
    t(wxk_ADD, ?WXK_ADD),
    t(wxk_SEPARATOR, ?WXK_SEPARATOR),
    t(wxk_SUBTRACT, ?WXK_SUBTRACT),
    t(wxk_DECIMAL, ?WXK_DECIMAL),
    t(wxk_DIVIDE, ?WXK_DIVIDE),
    t(wxk_F1, ?WXK_F1),
    t(wxk_F2, ?WXK_F2),
    t(wxk_F3, ?WXK_F3),
    t(wxk_F4, ?WXK_F4),
    t(wxk_F5, ?WXK_F5),
    t(wxk_F6, ?WXK_F6),
    t(wxk_F7, ?WXK_F7),
    t(wxk_F8, ?WXK_F8),
    t(wxk_F9, ?WXK_F9),
    t(wxk_F10, ?WXK_F10),
    t(wxk_F11, ?WXK_F11),
    t(wxk_F12, ?WXK_F12),
    t(wxk_F13, ?WXK_F13),
    t(wxk_F14, ?WXK_F14),
    t(wxk_F15, ?WXK_F15),
    t(wxk_F16, ?WXK_F16),
    t(wxk_F17, ?WXK_F17),
    t(wxk_F18, ?WXK_F18),
    t(wxk_F19, ?WXK_F19),
    t(wxk_F20, ?WXK_F20),
    t(wxk_F21, ?WXK_F21),
    t(wxk_F22, ?WXK_F22),
    t(wxk_F23, ?WXK_F23),
    t(wxk_F24, ?WXK_F24),
    t(wxk_NUMLOCK, ?WXK_NUMLOCK),
    t(wxk_SCROLL, ?WXK_SCROLL),
    t(wxk_PAGEUP, ?WXK_PAGEUP),
    t(wxk_PAGEDOWN, ?WXK_PAGEDOWN),
    t(wxk_NUMPAD_SPACE, ?WXK_NUMPAD_SPACE),
    t(wxk_NUMPAD_TAB, ?WXK_NUMPAD_TAB),
    t(wxk_NUMPAD_ENTER, ?WXK_NUMPAD_ENTER),
    t(wxk_NUMPAD_F1, ?WXK_NUMPAD_F1),
    t(wxk_NUMPAD_F2, ?WXK_NUMPAD_F2),
    t(wxk_NUMPAD_F3, ?WXK_NUMPAD_F3),
    t(wxk_NUMPAD_F4, ?WXK_NUMPAD_F4),
    t(wxk_NUMPAD_HOME, ?WXK_NUMPAD_HOME),
    t(wxk_NUMPAD_LEFT, ?WXK_NUMPAD_LEFT),
    t(wxk_NUMPAD_UP, ?WXK_NUMPAD_UP),
    t(wxk_NUMPAD_RIGHT, ?WXK_NUMPAD_RIGHT),
    t(wxk_NUMPAD_DOWN, ?WXK_NUMPAD_DOWN),
    t(wxk_NUMPAD_PAGEUP, ?WXK_NUMPAD_PAGEUP),
    t(wxk_NUMPAD_PAGEDOWN, ?WXK_NUMPAD_PAGEDOWN),
    t(wxk_NUMPAD_END, ?WXK_NUMPAD_END),
    t(wxk_NUMPAD_BEGIN, ?WXK_NUMPAD_BEGIN),
    t(wxk_NUMPAD_INSERT, ?WXK_NUMPAD_INSERT),
    t(wxk_NUMPAD_DELETE, ?WXK_NUMPAD_DELETE),
    t(wxk_NUMPAD_EQUAL, ?WXK_NUMPAD_EQUAL),
    t(wxk_NUMPAD_MULTIPLY, ?WXK_NUMPAD_MULTIPLY),
    t(wxk_NUMPAD_ADD, ?WXK_NUMPAD_ADD),
    t(wxk_NUMPAD_SEPARATOR, ?WXK_NUMPAD_SEPARATOR),
    t(wxk_NUMPAD_SUBTRACT, ?WXK_NUMPAD_SUBTRACT),
    t(wxk_NUMPAD_DECIMAL, ?WXK_NUMPAD_DECIMAL),
    t(wxk_NUMPAD_DIVIDE, ?WXK_NUMPAD_DIVIDE),
    t(wxk_WINDOWS_LEFT, ?WXK_WINDOWS_LEFT),
    t(wxk_WINDOWS_RIGHT, ?WXK_WINDOWS_RIGHT),
    t(wxk_WINDOWS_MENU, ?WXK_WINDOWS_MENU),
    t(wxk_RAW_CONTROL, {ignore, "WXK_RAW_CONTROL"}),
    t(wxk_COMMAND, ?WXK_COMMAND),
    t(wxk_SPECIAL1, {ignore, "WXK_SPECIAL1"}),
    t(wxk_SPECIAL2, {ignore, "WXK_SPECIAL2"}),
    t(wxk_SPECIAL3, {ignore, "WXK_SPECIAL3"}),
    t(wxk_SPECIAL4, {ignore, "WXK_SPECIAL4"}),
    t(wxk_SPECIAL5, {ignore, "WXK_SPECIAL5"}),
    t(wxk_SPECIAL6, {ignore, "WXK_SPECIAL6"}),
    t(wxk_SPECIAL7, {ignore, "WXK_SPECIAL7"}),
    t(wxk_SPECIAL8, {ignore, "WXK_SPECIAL8"}),
    t(wxk_SPECIAL9, {ignore, "WXK_SPECIAL9"}),
    t(wxk_SPECIAL10, {ignore, "WXK_SPECIAL10"}),
    t(wxk_SPECIAL11, {ignore, "WXK_SPECIAL11"}),
    t(wxk_SPECIAL12, {ignore, "WXK_SPECIAL12"}),
    t(wxk_SPECIAL13, {ignore, "WXK_SPECIAL13"}),
    t(wxk_SPECIAL14, {ignore, "WXK_SPECIAL14"}),
    t(wxk_SPECIAL15, {ignore, "WXK_SPECIAL15"}),
    t(wxk_SPECIAL16, {ignore, "WXK_SPECIAL16"}),
    t(wxk_SPECIAL17, {ignore, "WXK_SPECIAL17"}),
    t(wxk_SPECIAL18, {ignore, "WXK_SPECIAL18"}),
    t(wxk_SPECIAL19, {ignore, "WXK_SPECIAL19"}),
    t(wxk_SPECIAL20, {ignore, "WXK_SPECIAL20"}),
    t(wxk_BROWSER_BACK, ?WXK_BROWSER_BACK),
    t(wxk_BROWSER_FORWARD, ?WXK_BROWSER_FORWARD),
    t(wxk_BROWSER_REFRESH, ?WXK_BROWSER_REFRESH),
    t(wxk_BROWSER_STOP, ?WXK_BROWSER_STOP),
    t(wxk_BROWSER_SEARCH, ?WXK_BROWSER_SEARCH),
    t(wxk_BROWSER_FAVORITES, ?WXK_BROWSER_FAVORITES),
    t(wxk_BROWSER_HOME, ?WXK_BROWSER_HOME),
    t(wxk_VOLUME_MUTE, ?WXK_VOLUME_MUTE),
    t(wxk_VOLUME_DOWN, ?WXK_VOLUME_DOWN),
    t(wxk_VOLUME_UP, ?WXK_VOLUME_UP),
    t(wxk_MEDIA_NEXT_TRACK, ?WXK_MEDIA_NEXT_TRACK),
    t(wxk_MEDIA_PREV_TRACK, ?WXK_MEDIA_PREV_TRACK),
    t(wxk_MEDIA_STOP, ?WXK_MEDIA_STOP),
    t(wxk_MEDIA_PLAY_PAUSE, ?WXK_MEDIA_PLAY_PAUSE),
    t(wxk_LAUNCH_MAIL, ?WXK_LAUNCH_MAIL),
    t(wxk_LAUNCH_APP1, ?WXK_LAUNCH_APP1),
    t(wxk_LAUNCH_APP2, ?WXK_LAUNCH_APP2),
    t(wxMOD_NONE, ?wxMOD_NONE),
    t(wxMOD_ALT, ?wxMOD_ALT),
    t(wxMOD_CONTROL, ?wxMOD_CONTROL),
    t(wxMOD_ALTGR, ?wxMOD_ALTGR),
    t(wxMOD_SHIFT, ?wxMOD_SHIFT),
    t(wxMOD_META, ?wxMOD_META),
    t(wxMOD_WIN, ?wxMOD_WIN),
    t(wxMOD_RAW_CONTROL, {ignore, "wxMOD_RAW_CONTROL"}),
    t(wxMOD_CMD, ?wxMOD_CMD),
    t(wxMOD_ALL, ?wxMOD_ALL),
    t(wxHORIZONTAL, ?wxHORIZONTAL),
    t(wxVERTICAL, ?wxVERTICAL),
    t(wxBOTH, ?wxBOTH),
    t(wxORIENTATION_MASK, ?wxORIENTATION_MASK),
    t(wxPAPER_NONE, ?wxPAPER_NONE),
    t(wxPAPER_LETTER, ?wxPAPER_LETTER),
    t(wxPAPER_LEGAL, ?wxPAPER_LEGAL),
    t(wxPAPER_A4, ?wxPAPER_A4),
    t(wxPAPER_CSHEET, ?wxPAPER_CSHEET),
    t(wxPAPER_DSHEET, ?wxPAPER_DSHEET),
    t(wxPAPER_ESHEET, ?wxPAPER_ESHEET),
    t(wxPAPER_LETTERSMALL, ?wxPAPER_LETTERSMALL),
    t(wxPAPER_TABLOID, ?wxPAPER_TABLOID),
    t(wxPAPER_LEDGER, ?wxPAPER_LEDGER),
    t(wxPAPER_STATEMENT, ?wxPAPER_STATEMENT),
    t(wxPAPER_EXECUTIVE, ?wxPAPER_EXECUTIVE),
    t(wxPAPER_A3, ?wxPAPER_A3),
    t(wxPAPER_A4SMALL, ?wxPAPER_A4SMALL),
    t(wxPAPER_A5, ?wxPAPER_A5),
    t(wxPAPER_B4, ?wxPAPER_B4),
    t(wxPAPER_B5, ?wxPAPER_B5),
    t(wxPAPER_FOLIO, ?wxPAPER_FOLIO),
    t(wxPAPER_QUARTO, ?wxPAPER_QUARTO),
    t(wxPAPER_10X14, ?wxPAPER_10X14),
    t(wxPAPER_11X17, ?wxPAPER_11X17),
    t(wxPAPER_NOTE, ?wxPAPER_NOTE),
    t(wxPAPER_ENV_9, ?wxPAPER_ENV_9),
    t(wxPAPER_ENV_10, ?wxPAPER_ENV_10),
    t(wxPAPER_ENV_11, ?wxPAPER_ENV_11),
    t(wxPAPER_ENV_12, ?wxPAPER_ENV_12),
    t(wxPAPER_ENV_14, ?wxPAPER_ENV_14),
    t(wxPAPER_ENV_DL, ?wxPAPER_ENV_DL),
    t(wxPAPER_ENV_C5, ?wxPAPER_ENV_C5),
    t(wxPAPER_ENV_C3, ?wxPAPER_ENV_C3),
    t(wxPAPER_ENV_C4, ?wxPAPER_ENV_C4),
    t(wxPAPER_ENV_C6, ?wxPAPER_ENV_C6),
    t(wxPAPER_ENV_C65, ?wxPAPER_ENV_C65),
    t(wxPAPER_ENV_B4, ?wxPAPER_ENV_B4),
    t(wxPAPER_ENV_B5, ?wxPAPER_ENV_B5),
    t(wxPAPER_ENV_B6, ?wxPAPER_ENV_B6),
    t(wxPAPER_ENV_ITALY, ?wxPAPER_ENV_ITALY),
    t(wxPAPER_ENV_MONARCH, ?wxPAPER_ENV_MONARCH),
    t(wxPAPER_ENV_PERSONAL, ?wxPAPER_ENV_PERSONAL),
    t(wxPAPER_FANFOLD_US, ?wxPAPER_FANFOLD_US),
    t(wxPAPER_FANFOLD_STD_GERMAN, ?wxPAPER_FANFOLD_STD_GERMAN),
    t(wxPAPER_FANFOLD_LGL_GERMAN, ?wxPAPER_FANFOLD_LGL_GERMAN),
    t(wxPAPER_ISO_B4, ?wxPAPER_ISO_B4),
    t(wxPAPER_JAPANESE_POSTCARD, ?wxPAPER_JAPANESE_POSTCARD),
    t(wxPAPER_9X11, ?wxPAPER_9X11),
    t(wxPAPER_10X11, ?wxPAPER_10X11),
    t(wxPAPER_15X11, ?wxPAPER_15X11),
    t(wxPAPER_ENV_INVITE, ?wxPAPER_ENV_INVITE),
    t(wxPAPER_LETTER_EXTRA, ?wxPAPER_LETTER_EXTRA),
    t(wxPAPER_LEGAL_EXTRA, ?wxPAPER_LEGAL_EXTRA),
    t(wxPAPER_TABLOID_EXTRA, ?wxPAPER_TABLOID_EXTRA),
    t(wxPAPER_A4_EXTRA, ?wxPAPER_A4_EXTRA),
    t(wxPAPER_LETTER_TRANSVERSE, ?wxPAPER_LETTER_TRANSVERSE),
    t(wxPAPER_A4_TRANSVERSE, ?wxPAPER_A4_TRANSVERSE),
    t(wxPAPER_LETTER_EXTRA_TRANSVERSE, ?wxPAPER_LETTER_EXTRA_TRANSVERSE),
    t(wxPAPER_A_PLUS, ?wxPAPER_A_PLUS),
    t(wxPAPER_B_PLUS, ?wxPAPER_B_PLUS),
    t(wxPAPER_LETTER_PLUS, ?wxPAPER_LETTER_PLUS),
    t(wxPAPER_A4_PLUS, ?wxPAPER_A4_PLUS),
    t(wxPAPER_A5_TRANSVERSE, ?wxPAPER_A5_TRANSVERSE),
    t(wxPAPER_B5_TRANSVERSE, ?wxPAPER_B5_TRANSVERSE),
    t(wxPAPER_A3_EXTRA, ?wxPAPER_A3_EXTRA),
    t(wxPAPER_A5_EXTRA, ?wxPAPER_A5_EXTRA),
    t(wxPAPER_B5_EXTRA, ?wxPAPER_B5_EXTRA),
    t(wxPAPER_A2, ?wxPAPER_A2),
    t(wxPAPER_A3_TRANSVERSE, ?wxPAPER_A3_TRANSVERSE),
    t(wxPAPER_A3_EXTRA_TRANSVERSE, ?wxPAPER_A3_EXTRA_TRANSVERSE),
    t(wxPAPER_DBL_JAPANESE_POSTCARD, ?wxPAPER_DBL_JAPANESE_POSTCARD),
    t(wxPAPER_A6, ?wxPAPER_A6),
    t(wxPAPER_JENV_KAKU2, ?wxPAPER_JENV_KAKU2),
    t(wxPAPER_JENV_KAKU3, ?wxPAPER_JENV_KAKU3),
    t(wxPAPER_JENV_CHOU3, ?wxPAPER_JENV_CHOU3),
    t(wxPAPER_JENV_CHOU4, ?wxPAPER_JENV_CHOU4),
    t(wxPAPER_LETTER_ROTATED, ?wxPAPER_LETTER_ROTATED),
    t(wxPAPER_A3_ROTATED, ?wxPAPER_A3_ROTATED),
    t(wxPAPER_A4_ROTATED, ?wxPAPER_A4_ROTATED),
    t(wxPAPER_A5_ROTATED, ?wxPAPER_A5_ROTATED),
    t(wxPAPER_B4_JIS_ROTATED, ?wxPAPER_B4_JIS_ROTATED),
    t(wxPAPER_B5_JIS_ROTATED, ?wxPAPER_B5_JIS_ROTATED),
    t(wxPAPER_JAPANESE_POSTCARD_ROTATED, ?wxPAPER_JAPANESE_POSTCARD_ROTATED),
    t(wxPAPER_DBL_JAPANESE_POSTCARD_ROTATED, ?wxPAPER_DBL_JAPANESE_POSTCARD_ROTATED),
    t(wxPAPER_A6_ROTATED, ?wxPAPER_A6_ROTATED),
    t(wxPAPER_JENV_KAKU2_ROTATED, ?wxPAPER_JENV_KAKU2_ROTATED),
    t(wxPAPER_JENV_KAKU3_ROTATED, ?wxPAPER_JENV_KAKU3_ROTATED),
    t(wxPAPER_JENV_CHOU3_ROTATED, ?wxPAPER_JENV_CHOU3_ROTATED),
    t(wxPAPER_JENV_CHOU4_ROTATED, ?wxPAPER_JENV_CHOU4_ROTATED),
    t(wxPAPER_B6_JIS, ?wxPAPER_B6_JIS),
    t(wxPAPER_B6_JIS_ROTATED, ?wxPAPER_B6_JIS_ROTATED),
    t(wxPAPER_12X11, ?wxPAPER_12X11),
    t(wxPAPER_JENV_YOU4, ?wxPAPER_JENV_YOU4),
    t(wxPAPER_JENV_YOU4_ROTATED, ?wxPAPER_JENV_YOU4_ROTATED),
    t(wxPAPER_P16K, ?wxPAPER_P16K),
    t(wxPAPER_P32K, ?wxPAPER_P32K),
    t(wxPAPER_P32KBIG, ?wxPAPER_P32KBIG),
    t(wxPAPER_PENV_1, ?wxPAPER_PENV_1),
    t(wxPAPER_PENV_2, ?wxPAPER_PENV_2),
    t(wxPAPER_PENV_3, ?wxPAPER_PENV_3),
    t(wxPAPER_PENV_4, ?wxPAPER_PENV_4),
    t(wxPAPER_PENV_5, ?wxPAPER_PENV_5),
    t(wxPAPER_PENV_6, ?wxPAPER_PENV_6),
    t(wxPAPER_PENV_7, ?wxPAPER_PENV_7),
    t(wxPAPER_PENV_8, ?wxPAPER_PENV_8),
    t(wxPAPER_PENV_9, ?wxPAPER_PENV_9),
    t(wxPAPER_PENV_10, ?wxPAPER_PENV_10),
    t(wxPAPER_P16K_ROTATED, ?wxPAPER_P16K_ROTATED),
    t(wxPAPER_P32K_ROTATED, ?wxPAPER_P32K_ROTATED),
    t(wxPAPER_P32KBIG_ROTATED, ?wxPAPER_P32KBIG_ROTATED),
    t(wxPAPER_PENV_1_ROTATED, ?wxPAPER_PENV_1_ROTATED),
    t(wxPAPER_PENV_2_ROTATED, ?wxPAPER_PENV_2_ROTATED),
    t(wxPAPER_PENV_3_ROTATED, ?wxPAPER_PENV_3_ROTATED),
    t(wxPAPER_PENV_4_ROTATED, ?wxPAPER_PENV_4_ROTATED),
    t(wxPAPER_PENV_5_ROTATED, ?wxPAPER_PENV_5_ROTATED),
    t(wxPAPER_PENV_6_ROTATED, ?wxPAPER_PENV_6_ROTATED),
    t(wxPAPER_PENV_7_ROTATED, ?wxPAPER_PENV_7_ROTATED),
    t(wxPAPER_PENV_8_ROTATED, ?wxPAPER_PENV_8_ROTATED),
    t(wxPAPER_PENV_9_ROTATED, ?wxPAPER_PENV_9_ROTATED),
    t(wxPAPER_PENV_10_ROTATED, ?wxPAPER_PENV_10_ROTATED),
    t(wxPAPER_A0, ?wxPAPER_A0),
    t(wxPAPER_A1, ?wxPAPER_A1),
    t(wxPRINT_MODE_NONE, ?wxPRINT_MODE_NONE),
    t(wxPRINT_MODE_PREVIEW, ?wxPRINT_MODE_PREVIEW),
    t(wxPRINT_MODE_FILE, ?wxPRINT_MODE_FILE),
    t(wxPRINT_MODE_PRINTER, ?wxPRINT_MODE_PRINTER),
    t(wxPRINT_MODE_STREAM, ?wxPRINT_MODE_STREAM),
    t(wxPORTRAIT, ?wxPORTRAIT),
    t(wxLANDSCAPE, ?wxLANDSCAPE),
    t(wxFIXED_MINSIZE, ?wxFIXED_MINSIZE),
    t(wxRESERVE_SPACE_EVEN_IF_HIDDEN, ?wxRESERVE_SPACE_EVEN_IF_HIDDEN),
    t(wxSIZER_FLAG_BITS_MASK, ?wxSIZER_FLAG_BITS_MASK),
    t(wxID_AUTO_LOWEST, {ignore, "wxID_AUTO_LOWEST"}),
    t(wxID_AUTO_HIGHEST, ?wxID_AUTO_HIGHEST),
    t(wxID_NONE, ?wxID_NONE),
    t(wxID_SEPARATOR, ?wxID_SEPARATOR),
    t(wxID_ANY, ?wxID_ANY),
    t(wxID_LOWEST, ?wxID_LOWEST),
    t(wxID_OPEN, ?wxID_OPEN),
    t(wxID_CLOSE, ?wxID_CLOSE),
    t(wxID_NEW, ?wxID_NEW),
    t(wxID_SAVE, ?wxID_SAVE),
    t(wxID_SAVEAS, ?wxID_SAVEAS),
    t(wxID_REVERT, ?wxID_REVERT),
    t(wxID_EXIT, ?wxID_EXIT),
    t(wxID_UNDO, ?wxID_UNDO),
    t(wxID_REDO, ?wxID_REDO),
    t(wxID_HELP, ?wxID_HELP),
    t(wxID_PRINT, ?wxID_PRINT),
    t(wxID_PRINT_SETUP, ?wxID_PRINT_SETUP),
    t(wxID_PAGE_SETUP, ?wxID_PAGE_SETUP),
    t(wxID_PREVIEW, ?wxID_PREVIEW),
    t(wxID_ABOUT, ?wxID_ABOUT),
    t(wxID_HELP_CONTENTS, ?wxID_HELP_CONTENTS),
    t(wxID_HELP_INDEX, ?wxID_HELP_INDEX),
    t(wxID_HELP_SEARCH, ?wxID_HELP_SEARCH),
    t(wxID_HELP_COMMANDS, ?wxID_HELP_COMMANDS),
    t(wxID_HELP_PROCEDURES, ?wxID_HELP_PROCEDURES),
    t(wxID_HELP_CONTEXT, ?wxID_HELP_CONTEXT),
    t(wxID_CLOSE_ALL, ?wxID_CLOSE_ALL),
    t(wxID_PREFERENCES, ?wxID_PREFERENCES),
    t(wxID_EDIT, ?wxID_EDIT),
    t(wxID_CUT, ?wxID_CUT),
    t(wxID_COPY, ?wxID_COPY),
    t(wxID_PASTE, ?wxID_PASTE),
    t(wxID_CLEAR, ?wxID_CLEAR),
    t(wxID_FIND, ?wxID_FIND),
    t(wxID_DUPLICATE, ?wxID_DUPLICATE),
    t(wxID_SELECTALL, ?wxID_SELECTALL),
    t(wxID_DELETE, ?wxID_DELETE),
    t(wxID_REPLACE, ?wxID_REPLACE),
    t(wxID_REPLACE_ALL, ?wxID_REPLACE_ALL),
    t(wxID_PROPERTIES, ?wxID_PROPERTIES),
    t(wxID_VIEW_DETAILS, ?wxID_VIEW_DETAILS),
    t(wxID_VIEW_LARGEICONS, ?wxID_VIEW_LARGEICONS),
    t(wxID_VIEW_SMALLICONS, ?wxID_VIEW_SMALLICONS),
    t(wxID_VIEW_LIST, ?wxID_VIEW_LIST),
    t(wxID_VIEW_SORTDATE, ?wxID_VIEW_SORTDATE),
    t(wxID_VIEW_SORTNAME, ?wxID_VIEW_SORTNAME),
    t(wxID_VIEW_SORTSIZE, ?wxID_VIEW_SORTSIZE),
    t(wxID_VIEW_SORTTYPE, ?wxID_VIEW_SORTTYPE),
    t(wxID_FILE, ?wxID_FILE),
    t(wxID_FILE1, ?wxID_FILE1),
    t(wxID_FILE2, ?wxID_FILE2),
    t(wxID_FILE3, ?wxID_FILE3),
    t(wxID_FILE4, ?wxID_FILE4),
    t(wxID_FILE5, ?wxID_FILE5),
    t(wxID_FILE6, ?wxID_FILE6),
    t(wxID_FILE7, ?wxID_FILE7),
    t(wxID_FILE8, ?wxID_FILE8),
    t(wxID_FILE9, ?wxID_FILE9),
    t(wxID_OK, ?wxID_OK),
    t(wxID_CANCEL, ?wxID_CANCEL),
    t(wxID_APPLY, ?wxID_APPLY),
    t(wxID_YES, ?wxID_YES),
    t(wxID_NO, ?wxID_NO),
    t(wxID_STATIC, ?wxID_STATIC),
    t(wxID_FORWARD, ?wxID_FORWARD),
    t(wxID_BACKWARD, ?wxID_BACKWARD),
    t(wxID_DEFAULT, ?wxID_DEFAULT),
    t(wxID_MORE, ?wxID_MORE),
    t(wxID_SETUP, ?wxID_SETUP),
    t(wxID_RESET, ?wxID_RESET),
    t(wxID_CONTEXT_HELP, ?wxID_CONTEXT_HELP),
    t(wxID_YESTOALL, ?wxID_YESTOALL),
    t(wxID_NOTOALL, ?wxID_NOTOALL),
    t(wxID_ABORT, ?wxID_ABORT),
    t(wxID_RETRY, ?wxID_RETRY),
    t(wxID_IGNORE, ?wxID_IGNORE),
    t(wxID_ADD, ?wxID_ADD),
    t(wxID_REMOVE, ?wxID_REMOVE),
    t(wxID_UP, ?wxID_UP),
    t(wxID_DOWN, ?wxID_DOWN),
    t(wxID_HOME, ?wxID_HOME),
    t(wxID_REFRESH, ?wxID_REFRESH),
    t(wxID_STOP, ?wxID_STOP),
    t(wxID_INDEX, ?wxID_INDEX),
    t(wxID_BOLD, ?wxID_BOLD),
    t(wxID_ITALIC, ?wxID_ITALIC),
    t(wxID_JUSTIFY_CENTER, ?wxID_JUSTIFY_CENTER),
    t(wxID_JUSTIFY_FILL, ?wxID_JUSTIFY_FILL),
    t(wxID_JUSTIFY_RIGHT, ?wxID_JUSTIFY_RIGHT),
    t(wxID_JUSTIFY_LEFT, ?wxID_JUSTIFY_LEFT),
    t(wxID_UNDERLINE, ?wxID_UNDERLINE),
    t(wxID_INDENT, ?wxID_INDENT),
    t(wxID_UNINDENT, ?wxID_UNINDENT),
    t(wxID_ZOOM_100, ?wxID_ZOOM_100),
    t(wxID_ZOOM_FIT, ?wxID_ZOOM_FIT),
    t(wxID_ZOOM_IN, ?wxID_ZOOM_IN),
    t(wxID_ZOOM_OUT, ?wxID_ZOOM_OUT),
    t(wxID_UNDELETE, ?wxID_UNDELETE),
    t(wxID_REVERT_TO_SAVED, ?wxID_REVERT_TO_SAVED),
    t(wxID_CDROM, ?wxID_CDROM),
    t(wxID_CONVERT, ?wxID_CONVERT),
    t(wxID_EXECUTE, ?wxID_EXECUTE),
    t(wxID_FLOPPY, ?wxID_FLOPPY),
    t(wxID_HARDDISK, ?wxID_HARDDISK),
    t(wxID_BOTTOM, ?wxID_BOTTOM),
    t(wxID_FIRST, ?wxID_FIRST),
    t(wxID_LAST, ?wxID_LAST),
    t(wxID_TOP, ?wxID_TOP),
    t(wxID_INFO, ?wxID_INFO),
    t(wxID_JUMP_TO, ?wxID_JUMP_TO),
    t(wxID_NETWORK, ?wxID_NETWORK),
    t(wxID_SELECT_COLOR, ?wxID_SELECT_COLOR),
    t(wxID_SELECT_FONT, ?wxID_SELECT_FONT),
    t(wxID_SORT_ASCENDING, ?wxID_SORT_ASCENDING),
    t(wxID_SORT_DESCENDING, ?wxID_SORT_DESCENDING),
    t(wxID_SPELL_CHECK, ?wxID_SPELL_CHECK),
    t(wxID_STRIKETHROUGH, ?wxID_STRIKETHROUGH),
    t(wxID_SYSTEM_MENU, ?wxID_SYSTEM_MENU),
    t(wxID_CLOSE_FRAME, ?wxID_CLOSE_FRAME),
    t(wxID_MOVE_FRAME, ?wxID_MOVE_FRAME),
    t(wxID_RESIZE_FRAME, ?wxID_RESIZE_FRAME),
    t(wxID_MAXIMIZE_FRAME, ?wxID_MAXIMIZE_FRAME),
    t(wxID_ICONIZE_FRAME, ?wxID_ICONIZE_FRAME),
    t(wxID_RESTORE_FRAME, ?wxID_RESTORE_FRAME),
    t(wxID_MDI_WINDOW_FIRST, ?wxID_MDI_WINDOW_FIRST),
    t(wxID_MDI_WINDOW_CASCADE, ?wxID_MDI_WINDOW_CASCADE),
    t(wxID_MDI_WINDOW_TILE_HORZ, ?wxID_MDI_WINDOW_TILE_HORZ),
    t(wxID_MDI_WINDOW_TILE_VERT, ?wxID_MDI_WINDOW_TILE_VERT),
    t(wxID_MDI_WINDOW_ARRANGE_ICONS, ?wxID_MDI_WINDOW_ARRANGE_ICONS),
    t(wxID_MDI_WINDOW_PREV, ?wxID_MDI_WINDOW_PREV),
    t(wxID_MDI_WINDOW_NEXT, ?wxID_MDI_WINDOW_NEXT),
    t(wxID_MDI_WINDOW_LAST, ?wxID_MDI_WINDOW_LAST),
    t(wxID_FILEDLGG, ?wxID_FILEDLGG),
    t(wxID_FILECTRL, ?wxID_FILECTRL),
    t(wxID_HIGHEST, ?wxID_HIGHEST),
    t(wxSTRETCH_NOT, ?wxSTRETCH_NOT),
    t(wxSHRINK, ?wxSHRINK),
    t(wxGROW, ?wxGROW),
    t(wxEXPAND, ?wxEXPAND),
    t(wxSHAPED, ?wxSHAPED),
    t(wxTILE, ?wxTILE),
    t(wxSTRETCH_MASK, ?wxSTRETCH_MASK),
    t(wxUPDATE_UI_NONE, ?wxUPDATE_UI_NONE),
    t(wxUPDATE_UI_RECURSE, ?wxUPDATE_UI_RECURSE),
    t(wxUPDATE_UI_FROMIDLE, ?wxUPDATE_UI_FROMIDLE),
    t(wxDIALOG_ADAPTATION_LOOSE_BUTTONS, ?wxDIALOG_ADAPTATION_LOOSE_BUTTONS),
    t(wxDIALOG_ADAPTATION_ANY_SIZER, ?wxDIALOG_ADAPTATION_ANY_SIZER),
    t(wxDIALOG_ADAPTATION_STANDARD_SIZER, ?wxDIALOG_ADAPTATION_STANDARD_SIZER),
    t(wxDIALOG_ADAPTATION_NONE, ?wxDIALOG_ADAPTATION_NONE),
    t(wxDEFAULT_DIALOG_STYLE, ?wxDEFAULT_DIALOG_STYLE),
    t(wxDIALOG_NO_PARENT, ?wxDIALOG_NO_PARENT),
    t(wxDIALOG_ADAPTATION_MODE_DEFAULT, ?wxDIALOG_ADAPTATION_MODE_DEFAULT),
    t(wxDIALOG_ADAPTATION_MODE_ENABLED, ?wxDIALOG_ADAPTATION_MODE_ENABLED),
    t(wxDIALOG_ADAPTATION_MODE_DISABLED, ?wxDIALOG_ADAPTATION_MODE_DISABLED),
    t(wxDIRCTRL_DIR_ONLY, ?wxDIRCTRL_DIR_ONLY),
    t(wxDIRCTRL_SELECT_FIRST, ?wxDIRCTRL_SELECT_FIRST),
    t(wxDIRCTRL_SHOW_FILTERS, ?wxDIRCTRL_SHOW_FILTERS),
    t(wxDIRCTRL_3D_INTERNAL, ?wxDIRCTRL_3D_INTERNAL),
    t(wxDIRCTRL_EDIT_LABELS, ?wxDIRCTRL_EDIT_LABELS),
    t(wxDIRCTRL_MULTIPLE, ?wxDIRCTRL_MULTIPLE),
    t(wxDIRCTRL_DEFAULT_STYLE, ?wxDIRCTRL_DEFAULT_STYLE),
    t(wxDD_DEFAULT_STYLE, ?wxDD_DEFAULT_STYLE),
    t(wxDD_NEW_DIR_BUTTON, ?wxDD_NEW_DIR_BUTTON),
    t(wxDD_SHOW_HIDDEN, ?wxDD_SHOW_HIDDEN),
    t(wxDD_MULTIPLE, ?wxDD_MULTIPLE),
    t(wxDD_DIR_MUST_EXIST, ?wxDD_DIR_MUST_EXIST),
    t(wxDD_CHANGE_DIR, ?wxDD_CHANGE_DIR),
    t(wxDrag_CopyOnly, ?wxDrag_CopyOnly),
    t(wxDrag_AllowMove, ?wxDrag_AllowMove),
    t(wxDrag_DefaultMove, ?wxDrag_DefaultMove),
    t(wxDragError, ?wxDragError),
    t(wxDragNone, ?wxDragNone),
    t(wxDragCopy, ?wxDragCopy),
    t(wxDragMove, ?wxDragMove),
    t(wxDragLink, ?wxDragLink),
    t(wxDragCancel, ?wxDragCancel),
    t(wxAUI_BUTTON_CLOSE, ?wxAUI_BUTTON_CLOSE),
    t(wxAUI_BUTTON_MAXIMIZE_RESTORE, ?wxAUI_BUTTON_MAXIMIZE_RESTORE),
    t(wxAUI_BUTTON_MINIMIZE, ?wxAUI_BUTTON_MINIMIZE),
    t(wxAUI_BUTTON_PIN, ?wxAUI_BUTTON_PIN),
    t(wxAUI_BUTTON_OPTIONS, ?wxAUI_BUTTON_OPTIONS),
    t(wxAUI_BUTTON_WINDOWLIST, ?wxAUI_BUTTON_WINDOWLIST),
    t(wxAUI_BUTTON_LEFT, ?wxAUI_BUTTON_LEFT),
    t(wxAUI_BUTTON_RIGHT, ?wxAUI_BUTTON_RIGHT),
    t(wxAUI_BUTTON_UP, ?wxAUI_BUTTON_UP),
    t(wxAUI_BUTTON_DOWN, ?wxAUI_BUTTON_DOWN),
    t(wxAUI_BUTTON_CUSTOM1, ?wxAUI_BUTTON_CUSTOM1),
    t(wxAUI_BUTTON_CUSTOM2, ?wxAUI_BUTTON_CUSTOM2),
    t(wxAUI_BUTTON_CUSTOM3, ?wxAUI_BUTTON_CUSTOM3),
    t(wxAUI_BUTTON_STATE_NORMAL, ?wxAUI_BUTTON_STATE_NORMAL),
    t(wxAUI_BUTTON_STATE_HOVER, ?wxAUI_BUTTON_STATE_HOVER),
    t(wxAUI_BUTTON_STATE_PRESSED, ?wxAUI_BUTTON_STATE_PRESSED),
    t(wxAUI_BUTTON_STATE_DISABLED, ?wxAUI_BUTTON_STATE_DISABLED),
    t(wxAUI_BUTTON_STATE_HIDDEN, ?wxAUI_BUTTON_STATE_HIDDEN),
    t(wxAUI_BUTTON_STATE_CHECKED, ?wxAUI_BUTTON_STATE_CHECKED),
    t(wxAUI_GRADIENT_NONE, ?wxAUI_GRADIENT_NONE),
    t(wxAUI_GRADIENT_VERTICAL, ?wxAUI_GRADIENT_VERTICAL),
    t(wxAUI_GRADIENT_HORIZONTAL, ?wxAUI_GRADIENT_HORIZONTAL),
    t(wxAUI_DOCKART_SASH_SIZE, ?wxAUI_DOCKART_SASH_SIZE),
    t(wxAUI_DOCKART_CAPTION_SIZE, ?wxAUI_DOCKART_CAPTION_SIZE),
    t(wxAUI_DOCKART_GRIPPER_SIZE, ?wxAUI_DOCKART_GRIPPER_SIZE),
    t(wxAUI_DOCKART_PANE_BORDER_SIZE, ?wxAUI_DOCKART_PANE_BORDER_SIZE),
    t(wxAUI_DOCKART_PANE_BUTTON_SIZE, ?wxAUI_DOCKART_PANE_BUTTON_SIZE),
    t(wxAUI_DOCKART_BACKGROUND_COLOUR, ?wxAUI_DOCKART_BACKGROUND_COLOUR),
    t(wxAUI_DOCKART_SASH_COLOUR, ?wxAUI_DOCKART_SASH_COLOUR),
    t(wxAUI_DOCKART_ACTIVE_CAPTION_COLOUR, ?wxAUI_DOCKART_ACTIVE_CAPTION_COLOUR),
    t(wxAUI_DOCKART_ACTIVE_CAPTION_GRADIENT_COLOUR, ?wxAUI_DOCKART_ACTIVE_CAPTION_GRADIENT_COLOUR),
    t(wxAUI_DOCKART_INACTIVE_CAPTION_COLOUR, ?wxAUI_DOCKART_INACTIVE_CAPTION_COLOUR),
    t(wxAUI_DOCKART_INACTIVE_CAPTION_GRADIENT_COLOUR, ?wxAUI_DOCKART_INACTIVE_CAPTION_GRADIENT_COLOUR),
    t(wxAUI_DOCKART_ACTIVE_CAPTION_TEXT_COLOUR, ?wxAUI_DOCKART_ACTIVE_CAPTION_TEXT_COLOUR),
    t(wxAUI_DOCKART_INACTIVE_CAPTION_TEXT_COLOUR, ?wxAUI_DOCKART_INACTIVE_CAPTION_TEXT_COLOUR),
    t(wxAUI_DOCKART_BORDER_COLOUR, ?wxAUI_DOCKART_BORDER_COLOUR),
    t(wxAUI_DOCKART_GRIPPER_COLOUR, ?wxAUI_DOCKART_GRIPPER_COLOUR),
    t(wxAUI_DOCKART_CAPTION_FONT, ?wxAUI_DOCKART_CAPTION_FONT),
    t(wxAUI_DOCKART_GRADIENT_TYPE, ?wxAUI_DOCKART_GRADIENT_TYPE),
    t(wxJOYSTICK1, ?wxJOYSTICK1),
    t(wxJOYSTICK2, ?wxJOYSTICK2),
    t(wxJOY_BUTTON_ANY, ?wxJOY_BUTTON_ANY),
    t(wxJOY_BUTTON1, ?wxJOY_BUTTON1),
    t(wxJOY_BUTTON2, ?wxJOY_BUTTON2),
    t(wxJOY_BUTTON3, ?wxJOY_BUTTON3),
    t(wxJOY_BUTTON4, ?wxJOY_BUTTON4),
    t(wxEVENT_PROPAGATE_NONE, ?wxEVENT_PROPAGATE_NONE),
    t(wxEVENT_PROPAGATE_MAX, ?wxEVENT_PROPAGATE_MAX),
    t(wxIDLE_PROCESS_ALL, ?wxIDLE_PROCESS_ALL),
    t(wxIDLE_PROCESS_SPECIFIED, ?wxIDLE_PROCESS_SPECIFIED),
    t(wxk_CATEGORY_ARROW, ?WXK_CATEGORY_ARROW),
    t(wxk_CATEGORY_PAGING, ?WXK_CATEGORY_PAGING),
    t(wxk_CATEGORY_JUMP, ?WXK_CATEGORY_JUMP),
    t(wxk_CATEGORY_TAB, ?WXK_CATEGORY_TAB),
    t(wxk_CATEGORY_CUT, ?WXK_CATEGORY_CUT),
    t(wxk_CATEGORY_NAVIGATION, ?WXK_CATEGORY_NAVIGATION),
    t(wxMOUSE_WHEEL_VERTICAL, ?wxMOUSE_WHEEL_VERTICAL),
    t(wxMOUSE_WHEEL_HORIZONTAL, ?wxMOUSE_WHEEL_HORIZONTAL),
    t(wxUPDATE_UI_PROCESS_ALL, ?wxUPDATE_UI_PROCESS_ALL),
    t(wxUPDATE_UI_PROCESS_SPECIFIED, ?wxUPDATE_UI_PROCESS_SPECIFIED),
    t(wxFR_REPLACEDIALOG, ?wxFR_REPLACEDIALOG),
    t(wxFR_NOUPDOWN, ?wxFR_NOUPDOWN),
    t(wxFR_NOMATCHCASE, ?wxFR_NOMATCHCASE),
    t(wxFR_NOWHOLEWORD, ?wxFR_NOWHOLEWORD),
    t(wxFR_DOWN, ?wxFR_DOWN),
    t(wxFR_WHOLEWORD, ?wxFR_WHOLEWORD),
    t(wxFR_MATCHCASE, ?wxFR_MATCHCASE),
    t(wxFD_OPEN, ?wxFD_OPEN),
    t(wxFD_SAVE, ?wxFD_SAVE),
    t(wxFD_OVERWRITE_PROMPT, ?wxFD_OVERWRITE_PROMPT),
    t(wxFD_NO_FOLLOW, ?wxFD_NO_FOLLOW),
    t(wxFD_FILE_MUST_EXIST, ?wxFD_FILE_MUST_EXIST),
    t(wxFD_CHANGE_DIR, ?wxFD_CHANGE_DIR),
    t(wxFD_PREVIEW, ?wxFD_PREVIEW),
    t(wxFD_SHOW_HIDDEN, ?wxFD_SHOW_HIDDEN),
    t(wxFD_DEFAULT_STYLE, ?wxFD_DEFAULT_STYLE),
    t(wxDIRP_DEFAULT_STYLE, {ignore, "wxDIRP_DEFAULT_STYLE"}),
    t(wxDIRP_USE_TEXTCTRL, ?wxDIRP_USE_TEXTCTRL),
    t(wxDIRP_SMALL, ?wxDIRP_SMALL),
    t(wxDIRP_CHANGE_DIR, ?wxDIRP_CHANGE_DIR),
    t(wxDIRP_DIR_MUST_EXIST, ?wxDIRP_DIR_MUST_EXIST),
    t(wxFLP_DEFAULT_STYLE, {ignore, "wxFLP_DEFAULT_STYLE"}),
    t(wxFLP_USE_TEXTCTRL, ?wxFLP_USE_TEXTCTRL),
    t(wxFLP_SMALL, ?wxFLP_SMALL),
    t(wxFLP_CHANGE_DIR, ?wxFLP_CHANGE_DIR),
    t(wxFLP_FILE_MUST_EXIST, ?wxFLP_FILE_MUST_EXIST),
    t(wxFLP_OVERWRITE_PROMPT, ?wxFLP_OVERWRITE_PROMPT),
    t(wxFLP_SAVE, ?wxFLP_SAVE),
    t(wxFLP_OPEN, ?wxFLP_OPEN),
    t(wxFONTFAMILY_DEFAULT, ?wxFONTFAMILY_DEFAULT),
    t(wxFONTFAMILY_DECORATIVE, ?wxFONTFAMILY_DECORATIVE),
    t(wxFONTFAMILY_ROMAN, ?wxFONTFAMILY_ROMAN),
    t(wxFONTFAMILY_SCRIPT, ?wxFONTFAMILY_SCRIPT),
    t(wxFONTFAMILY_SWISS, ?wxFONTFAMILY_SWISS),
    t(wxFONTFAMILY_MODERN, ?wxFONTFAMILY_MODERN),
    t(wxFONTFAMILY_TELETYPE, ?wxFONTFAMILY_TELETYPE),
    t(wxFONTFAMILY_MAX, ?wxFONTFAMILY_MAX),
    t(wxFONTFAMILY_UNKNOWN, ?wxFONTFAMILY_UNKNOWN),
    t(wxFONTFLAG_DEFAULT, ?wxFONTFLAG_DEFAULT),
    t(wxFONTFLAG_ITALIC, ?wxFONTFLAG_ITALIC),
    t(wxFONTFLAG_SLANT, ?wxFONTFLAG_SLANT),
    t(wxFONTFLAG_LIGHT, ?wxFONTFLAG_LIGHT),
    t(wxFONTFLAG_BOLD, ?wxFONTFLAG_BOLD),
    t(wxFONTFLAG_ANTIALIASED, ?wxFONTFLAG_ANTIALIASED),
    t(wxFONTFLAG_NOT_ANTIALIASED, ?wxFONTFLAG_NOT_ANTIALIASED),
    t(wxFONTFLAG_UNDERLINED, ?wxFONTFLAG_UNDERLINED),
    t(wxFONTFLAG_STRIKETHROUGH, ?wxFONTFLAG_STRIKETHROUGH),
    t(wxFONTFLAG_MASK, ?wxFONTFLAG_MASK),
    t(wxFONTSTYLE_NORMAL, ?wxFONTSTYLE_NORMAL),
    t(wxFONTSTYLE_ITALIC, ?wxFONTSTYLE_ITALIC),
    t(wxFONTSTYLE_SLANT, ?wxFONTSTYLE_SLANT),
    t(wxFONTSTYLE_MAX, ?wxFONTSTYLE_MAX),
    t(wxFONTSIZE_XX_SMALL, ?wxFONTSIZE_XX_SMALL),
    t(wxFONTSIZE_X_SMALL, ?wxFONTSIZE_X_SMALL),
    t(wxFONTSIZE_SMALL, ?wxFONTSIZE_SMALL),
    t(wxFONTSIZE_MEDIUM, ?wxFONTSIZE_MEDIUM),
    t(wxFONTSIZE_LARGE, ?wxFONTSIZE_LARGE),
    t(wxFONTSIZE_X_LARGE, ?wxFONTSIZE_X_LARGE),
    t(wxFONTSIZE_XX_LARGE, ?wxFONTSIZE_XX_LARGE),
    t(wxFONTWEIGHT_INVALID, ?wxFONTWEIGHT_INVALID),
    t(wxFONTWEIGHT_THIN, ?wxFONTWEIGHT_THIN),
    t(wxFONTWEIGHT_EXTRALIGHT, ?wxFONTWEIGHT_EXTRALIGHT),
    t(wxFONTWEIGHT_LIGHT, {ignore, "wxFONTWEIGHT_LIGHT"}),
    t(wxFONTWEIGHT_NORMAL, {ignore, "wxFONTWEIGHT_NORMAL"}),
    t(wxFONTWEIGHT_MEDIUM, ?wxFONTWEIGHT_MEDIUM),
    t(wxFONTWEIGHT_SEMIBOLD, ?wxFONTWEIGHT_SEMIBOLD),
    t(wxFONTWEIGHT_BOLD, {ignore, "wxFONTWEIGHT_BOLD"}),
    t(wxFONTWEIGHT_EXTRABOLD, ?wxFONTWEIGHT_EXTRABOLD),
    t(wxFONTWEIGHT_HEAVY, ?wxFONTWEIGHT_HEAVY),
    t(wxFONTWEIGHT_EXTRAHEAVY, ?wxFONTWEIGHT_EXTRAHEAVY),
    t(wxFONTWEIGHT_MAX, {ignore, "wxFONTWEIGHT_MAX"}),
    t(wxFNTP_DEFAULT_STYLE, ?wxFNTP_DEFAULT_STYLE),
    t(wxFNTP_USE_TEXTCTRL, ?wxFNTP_USE_TEXTCTRL),
    t(wxFONTBTN_DEFAULT_STYLE, ?wxFONTBTN_DEFAULT_STYLE),
    t(wxFNTP_USEFONT_FOR_LABEL, ?wxFNTP_USEFONT_FOR_LABEL),
    t(wxFNTP_FONTDESC_AS_LABEL, ?wxFNTP_FONTDESC_AS_LABEL),
    t(wxFRAME_FLOAT_ON_PARENT, ?wxFRAME_FLOAT_ON_PARENT),
    t(wxFRAME_TOOL_WINDOW, ?wxFRAME_TOOL_WINDOW),
    t(wxFRAME_NO_TASKBAR, ?wxFRAME_NO_TASKBAR),
    t(wxAUI_DOCK_NONE, ?wxAUI_DOCK_NONE),
    t(wxAUI_DOCK_TOP, ?wxAUI_DOCK_TOP),
    t(wxAUI_DOCK_RIGHT, ?wxAUI_DOCK_RIGHT),
    t(wxAUI_DOCK_BOTTOM, ?wxAUI_DOCK_BOTTOM),
    t(wxAUI_DOCK_LEFT, ?wxAUI_DOCK_LEFT),
    t(wxAUI_DOCK_CENTER, ?wxAUI_DOCK_CENTER),
    t(wxAUI_DOCK_CENTRE, ?wxAUI_DOCK_CENTRE),
    t(wxAUI_MGR_ALLOW_FLOATING, ?wxAUI_MGR_ALLOW_FLOATING),
    t(wxAUI_MGR_ALLOW_ACTIVE_PANE, ?wxAUI_MGR_ALLOW_ACTIVE_PANE),
    t(wxAUI_MGR_TRANSPARENT_DRAG, ?wxAUI_MGR_TRANSPARENT_DRAG),
    t(wxAUI_MGR_TRANSPARENT_HINT, ?wxAUI_MGR_TRANSPARENT_HINT),
    t(wxAUI_MGR_VENETIAN_BLINDS_HINT, ?wxAUI_MGR_VENETIAN_BLINDS_HINT),
    t(wxAUI_MGR_RECTANGLE_HINT, ?wxAUI_MGR_RECTANGLE_HINT),
    t(wxAUI_MGR_HINT_FADE, ?wxAUI_MGR_HINT_FADE),
    t(wxAUI_MGR_NO_VENETIAN_BLINDS_FADE, ?wxAUI_MGR_NO_VENETIAN_BLINDS_FADE),
    t(wxAUI_MGR_LIVE_RESIZE, ?wxAUI_MGR_LIVE_RESIZE),
    t(wxAUI_MGR_DEFAULT, ?wxAUI_MGR_DEFAULT),
    t(wxGA_TEXT, ?wxGA_TEXT),
    t(wxGA_SMOOTH, ?wxGA_SMOOTH),
    t(wxGA_PROGRESS, ?wxGA_PROGRESS),
    t(wxGA_VERTICAL, ?wxGA_VERTICAL),
    t(wxGA_HORIZONTAL, ?wxGA_HORIZONTAL),
    t(wxBITMAP_TYPE_INVALID, ?wxBITMAP_TYPE_INVALID),
    t(wxBITMAP_TYPE_BMP, ?wxBITMAP_TYPE_BMP),
    t(wxBITMAP_TYPE_BMP_RESOURCE, ?wxBITMAP_TYPE_BMP_RESOURCE),
    t(wxBITMAP_TYPE_RESOURCE, ?wxBITMAP_TYPE_RESOURCE),
    t(wxBITMAP_TYPE_ICO, ?wxBITMAP_TYPE_ICO),
    t(wxBITMAP_TYPE_ICO_RESOURCE, ?wxBITMAP_TYPE_ICO_RESOURCE),
    t(wxBITMAP_TYPE_CUR, ?wxBITMAP_TYPE_CUR),
    t(wxBITMAP_TYPE_CUR_RESOURCE, ?wxBITMAP_TYPE_CUR_RESOURCE),
    t(wxBITMAP_TYPE_XBM, ?wxBITMAP_TYPE_XBM),
    t(wxBITMAP_TYPE_XBM_DATA, ?wxBITMAP_TYPE_XBM_DATA),
    t(wxBITMAP_TYPE_XPM, ?wxBITMAP_TYPE_XPM),
    t(wxBITMAP_TYPE_XPM_DATA, ?wxBITMAP_TYPE_XPM_DATA),
    t(wxBITMAP_TYPE_TIFF, ?wxBITMAP_TYPE_TIFF),
    t(wxBITMAP_TYPE_TIF, ?wxBITMAP_TYPE_TIF),
    t(wxBITMAP_TYPE_TIFF_RESOURCE, ?wxBITMAP_TYPE_TIFF_RESOURCE),
    t(wxBITMAP_TYPE_TIF_RESOURCE, ?wxBITMAP_TYPE_TIF_RESOURCE),
    t(wxBITMAP_TYPE_GIF, ?wxBITMAP_TYPE_GIF),
    t(wxBITMAP_TYPE_GIF_RESOURCE, ?wxBITMAP_TYPE_GIF_RESOURCE),
    t(wxBITMAP_TYPE_PNG, ?wxBITMAP_TYPE_PNG),
    t(wxBITMAP_TYPE_PNG_RESOURCE, ?wxBITMAP_TYPE_PNG_RESOURCE),
    t(wxBITMAP_TYPE_JPEG, ?wxBITMAP_TYPE_JPEG),
    t(wxBITMAP_TYPE_JPEG_RESOURCE, ?wxBITMAP_TYPE_JPEG_RESOURCE),
    t(wxBITMAP_TYPE_PNM, ?wxBITMAP_TYPE_PNM),
    t(wxBITMAP_TYPE_PNM_RESOURCE, ?wxBITMAP_TYPE_PNM_RESOURCE),
    t(wxBITMAP_TYPE_PCX, ?wxBITMAP_TYPE_PCX),
    t(wxBITMAP_TYPE_PCX_RESOURCE, ?wxBITMAP_TYPE_PCX_RESOURCE),
    t(wxBITMAP_TYPE_PICT, ?wxBITMAP_TYPE_PICT),
    t(wxBITMAP_TYPE_PICT_RESOURCE, ?wxBITMAP_TYPE_PICT_RESOURCE),
    t(wxBITMAP_TYPE_ICON, ?wxBITMAP_TYPE_ICON),
    t(wxBITMAP_TYPE_ICON_RESOURCE, ?wxBITMAP_TYPE_ICON_RESOURCE),
    t(wxBITMAP_TYPE_ANI, ?wxBITMAP_TYPE_ANI),
    t(wxBITMAP_TYPE_IFF, ?wxBITMAP_TYPE_IFF),
    t(wxBITMAP_TYPE_TGA, ?wxBITMAP_TYPE_TGA),
    t(wxBITMAP_TYPE_MACCURSOR, ?wxBITMAP_TYPE_MACCURSOR),
    t(wxBITMAP_TYPE_MACCURSOR_RESOURCE, ?wxBITMAP_TYPE_MACCURSOR_RESOURCE),
    t(wxBITMAP_TYPE_ANY, ?wxBITMAP_TYPE_ANY),
    t(wxELLIPSIZE_FLAGS_NONE, ?wxELLIPSIZE_FLAGS_NONE),
    t(wxELLIPSIZE_FLAGS_PROCESS_MNEMONICS, ?wxELLIPSIZE_FLAGS_PROCESS_MNEMONICS),
    t(wxELLIPSIZE_FLAGS_EXPAND_TABS, ?wxELLIPSIZE_FLAGS_EXPAND_TABS),
    t(wxELLIPSIZE_FLAGS_DEFAULT, ?wxELLIPSIZE_FLAGS_DEFAULT),
    t(wxELLIPSIZE_NONE, ?wxELLIPSIZE_NONE),
    t(wxELLIPSIZE_START, ?wxELLIPSIZE_START),
    t(wxELLIPSIZE_MIDDLE, ?wxELLIPSIZE_MIDDLE),
    t(wxELLIPSIZE_END, ?wxELLIPSIZE_END),
    t(wxODDEVEN_RULE, ?wxODDEVEN_RULE),
    t(wxWINDING_RULE, ?wxWINDING_RULE),
    t(wxCURSOR_NONE, ?wxCURSOR_NONE),
    t(wxCURSOR_ARROW, ?wxCURSOR_ARROW),
    t(wxCURSOR_RIGHT_ARROW, ?wxCURSOR_RIGHT_ARROW),
    t(wxCURSOR_BULLSEYE, ?wxCURSOR_BULLSEYE),
    t(wxCURSOR_CHAR, ?wxCURSOR_CHAR),
    t(wxCURSOR_CROSS, ?wxCURSOR_CROSS),
    t(wxCURSOR_HAND, ?wxCURSOR_HAND),
    t(wxCURSOR_IBEAM, ?wxCURSOR_IBEAM),
    t(wxCURSOR_LEFT_BUTTON, ?wxCURSOR_LEFT_BUTTON),
    t(wxCURSOR_MAGNIFIER, ?wxCURSOR_MAGNIFIER),
    t(wxCURSOR_MIDDLE_BUTTON, ?wxCURSOR_MIDDLE_BUTTON),
    t(wxCURSOR_NO_ENTRY, ?wxCURSOR_NO_ENTRY),
    t(wxCURSOR_PAINT_BRUSH, ?wxCURSOR_PAINT_BRUSH),
    t(wxCURSOR_PENCIL, ?wxCURSOR_PENCIL),
    t(wxCURSOR_POINT_LEFT, ?wxCURSOR_POINT_LEFT),
    t(wxCURSOR_POINT_RIGHT, ?wxCURSOR_POINT_RIGHT),
    t(wxCURSOR_QUESTION_ARROW, ?wxCURSOR_QUESTION_ARROW),
    t(wxCURSOR_RIGHT_BUTTON, ?wxCURSOR_RIGHT_BUTTON),
    t(wxCURSOR_SIZENESW, ?wxCURSOR_SIZENESW),
    t(wxCURSOR_SIZENS, ?wxCURSOR_SIZENS),
    t(wxCURSOR_SIZENWSE, ?wxCURSOR_SIZENWSE),
    t(wxCURSOR_SIZEWE, ?wxCURSOR_SIZEWE),
    t(wxCURSOR_SIZING, ?wxCURSOR_SIZING),
    t(wxCURSOR_SPRAYCAN, ?wxCURSOR_SPRAYCAN),
    t(wxCURSOR_WAIT, ?wxCURSOR_WAIT),
    t(wxCURSOR_WATCH, ?wxCURSOR_WATCH),
    t(wxCURSOR_BLANK, ?wxCURSOR_BLANK),
    t(wxCURSOR_DEFAULT, {ignore, "wxCURSOR_DEFAULT"}),
    t(wxCURSOR_ARROWWAIT, {ignore, "wxCURSOR_ARROWWAIT"}),
    t(wxCURSOR_MAX, {ignore, "wxCURSOR_MAX"}),
    t(wx_GL_RGBA, ?WX_GL_RGBA),
    t(wx_GL_BUFFER_SIZE, ?WX_GL_BUFFER_SIZE),
    t(wx_GL_LEVEL, ?WX_GL_LEVEL),
    t(wx_GL_DOUBLEBUFFER, ?WX_GL_DOUBLEBUFFER),
    t(wx_GL_STEREO, ?WX_GL_STEREO),
    t(wx_GL_AUX_BUFFERS, ?WX_GL_AUX_BUFFERS),
    t(wx_GL_MIN_RED, ?WX_GL_MIN_RED),
    t(wx_GL_MIN_GREEN, ?WX_GL_MIN_GREEN),
    t(wx_GL_MIN_BLUE, ?WX_GL_MIN_BLUE),
    t(wx_GL_MIN_ALPHA, ?WX_GL_MIN_ALPHA),
    t(wx_GL_DEPTH_SIZE, ?WX_GL_DEPTH_SIZE),
    t(wx_GL_STENCIL_SIZE, ?WX_GL_STENCIL_SIZE),
    t(wx_GL_MIN_ACCUM_RED, ?WX_GL_MIN_ACCUM_RED),
    t(wx_GL_MIN_ACCUM_GREEN, ?WX_GL_MIN_ACCUM_GREEN),
    t(wx_GL_MIN_ACCUM_BLUE, ?WX_GL_MIN_ACCUM_BLUE),
    t(wx_GL_MIN_ACCUM_ALPHA, ?WX_GL_MIN_ACCUM_ALPHA),
    t(wx_GL_SAMPLE_BUFFERS, ?WX_GL_SAMPLE_BUFFERS),
    t(wx_GL_SAMPLES, ?WX_GL_SAMPLES),
    t(wx_GL_FRAMEBUFFER_SRGB, ?WX_GL_FRAMEBUFFER_SRGB),
    t(wx_GL_COMPAT_PROFILE, ?wx_GL_COMPAT_PROFILE),
    t(wx_GL_FORWARD_COMPAT, ?WX_GL_FORWARD_COMPAT),
    t(wx_GL_ES2, ?WX_GL_ES2),
    t(wx_GL_DEBUG, ?WX_GL_DEBUG),
    t(wx_GL_ROBUST_ACCESS, ?WX_GL_ROBUST_ACCESS),
    t(wx_GL_NO_RESET_NOTIFY, ?WX_GL_NO_RESET_NOTIFY),
    t(wx_GL_LOSE_ON_RESET, ?WX_GL_LOSE_ON_RESET),
    t(wx_GL_RESET_ISOLATION, ?WX_GL_RESET_ISOLATION),
    t(wx_GL_RELEASE_FLUSH, ?WX_GL_RELEASE_FLUSH),
    t(wx_GL_RELEASE_NONE, ?WX_GL_RELEASE_NONE),
    t(wxANTIALIAS_NONE, ?wxANTIALIAS_NONE),
    t(wxANTIALIAS_DEFAULT, ?wxANTIALIAS_DEFAULT),
    t(wxCOMPOSITION_INVALID, ?wxCOMPOSITION_INVALID),
    t(wxCOMPOSITION_CLEAR, ?wxCOMPOSITION_CLEAR),
    t(wxCOMPOSITION_SOURCE, ?wxCOMPOSITION_SOURCE),
    t(wxCOMPOSITION_OVER, ?wxCOMPOSITION_OVER),
    t(wxCOMPOSITION_IN, ?wxCOMPOSITION_IN),
    t(wxCOMPOSITION_OUT, ?wxCOMPOSITION_OUT),
    t(wxCOMPOSITION_ATOP, ?wxCOMPOSITION_ATOP),
    t(wxCOMPOSITION_DEST, ?wxCOMPOSITION_DEST),
    t(wxCOMPOSITION_DEST_OVER, ?wxCOMPOSITION_DEST_OVER),
    t(wxCOMPOSITION_DEST_IN, ?wxCOMPOSITION_DEST_IN),
    t(wxCOMPOSITION_DEST_OUT, ?wxCOMPOSITION_DEST_OUT),
    t(wxCOMPOSITION_DEST_ATOP, ?wxCOMPOSITION_DEST_ATOP),
    t(wxCOMPOSITION_XOR, ?wxCOMPOSITION_XOR),
    t(wxCOMPOSITION_ADD, ?wxCOMPOSITION_ADD),
    t(wxGRADIENT_NONE, ?wxGRADIENT_NONE),
    t(wxGRADIENT_LINEAR, ?wxGRADIENT_LINEAR),
    t(wxGRADIENT_RADIAL, ?wxGRADIENT_RADIAL),
    t(wxINTERPOLATION_DEFAULT, ?wxINTERPOLATION_DEFAULT),
    t(wxINTERPOLATION_NONE, ?wxINTERPOLATION_NONE),
    t(wxINTERPOLATION_FAST, ?wxINTERPOLATION_FAST),
    t(wxINTERPOLATION_GOOD, ?wxINTERPOLATION_GOOD),
    t(wxINTERPOLATION_BEST, ?wxINTERPOLATION_BEST),
    t(wxGRID_AUTOSIZE, ?wxGRID_AUTOSIZE),
    t(wxGRID_FLOAT_FORMAT_FIXED, ?wxGRID_FLOAT_FORMAT_FIXED),
    t(wxGRID_FLOAT_FORMAT_SCIENTIFIC, ?wxGRID_FLOAT_FORMAT_SCIENTIFIC),
    t(wxGRID_FLOAT_FORMAT_COMPACT, ?wxGRID_FLOAT_FORMAT_COMPACT),
    t(wxGRID_FLOAT_FORMAT_UPPER, ?wxGRID_FLOAT_FORMAT_UPPER),
    t(wxGRID_FLOAT_FORMAT_DEFAULT, ?wxGRID_FLOAT_FORMAT_DEFAULT),
    t(wxGRID_DRAW_ROWS_HEADER, ?wxGRID_DRAW_ROWS_HEADER),
    t(wxGRID_DRAW_COLS_HEADER, ?wxGRID_DRAW_COLS_HEADER),
    t(wxGRID_DRAW_CELL_LINES, ?wxGRID_DRAW_CELL_LINES),
    t(wxGRID_DRAW_BOX_RECT, ?wxGRID_DRAW_BOX_RECT),
    t(wxGRID_DRAW_SELECTION, ?wxGRID_DRAW_SELECTION),
    t(wxGRID_DRAW_DEFAULT, ?wxGRID_DRAW_DEFAULT),
    t(wxGRIDTABLE_NOTIFY_ROWS_INSERTED, ?wxGRIDTABLE_NOTIFY_ROWS_INSERTED),
    t(wxGRIDTABLE_NOTIFY_ROWS_APPENDED, ?wxGRIDTABLE_NOTIFY_ROWS_APPENDED),
    t(wxGRIDTABLE_NOTIFY_ROWS_DELETED, ?wxGRIDTABLE_NOTIFY_ROWS_DELETED),
    t(wxGRIDTABLE_NOTIFY_COLS_INSERTED, ?wxGRIDTABLE_NOTIFY_COLS_INSERTED),
    t(wxGRIDTABLE_NOTIFY_COLS_APPENDED, ?wxGRIDTABLE_NOTIFY_COLS_APPENDED),
    t(wxGRIDTABLE_NOTIFY_COLS_DELETED, ?wxGRIDTABLE_NOTIFY_COLS_DELETED),
    t(wxHW_DEFAULT_STYLE, ?wxHW_DEFAULT_STYLE),
    t(wxHW_NO_SELECTION, ?wxHW_NO_SELECTION),
    t(wxHW_SCROLLBAR_AUTO, ?wxHW_SCROLLBAR_AUTO),
    t(wxHW_SCROLLBAR_NEVER, ?wxHW_SCROLLBAR_NEVER),
    t(wxHTML_OPEN, ?wxHTML_OPEN),
    t(wxHTML_BLOCK, ?wxHTML_BLOCK),
    t(wxHTML_REDIRECT, ?wxHTML_REDIRECT),
    t(wxPAGE_ODD, ?wxPAGE_ODD),
    t(wxPAGE_EVEN, ?wxPAGE_EVEN),
    t(wxPAGE_ALL, ?wxPAGE_ALL),
    t(wxICON_SCREEN_DEPTH, ?wxICON_SCREEN_DEPTH),
    t(wxBMP_24BPP, ?wxBMP_24BPP),
    t(wxBMP_8BPP, ?wxBMP_8BPP),
    t(wxBMP_8BPP_GREY, ?wxBMP_8BPP_GREY),
    t(wxBMP_8BPP_GRAY, ?wxBMP_8BPP_GRAY),
    t(wxBMP_8BPP_RED, ?wxBMP_8BPP_RED),
    t(wxBMP_8BPP_PALETTE, ?wxBMP_8BPP_PALETTE),
    t(wxBMP_4BPP, ?wxBMP_4BPP),
    t(wxBMP_1BPP, ?wxBMP_1BPP),
    t(wxBMP_1BPP_BW, ?wxBMP_1BPP_BW),
    t(wxPNG_TYPE_COLOUR, ?wxPNG_TYPE_COLOUR),
    t(wxPNG_TYPE_GREY, ?wxPNG_TYPE_GREY),
    t(wxPNG_TYPE_GREY_RED, ?wxPNG_TYPE_GREY_RED),
    t(wxPNG_TYPE_PALETTE, ?wxPNG_TYPE_PALETTE),
    t(wxIMAGE_QUALITY_NEAREST, {ignore, "wxIMAGE_QUALITY_NEAREST"}),
    t(wxIMAGE_QUALITY_BILINEAR, {ignore, "wxIMAGE_QUALITY_BILINEAR"}),
    t(wxIMAGE_QUALITY_BICUBIC, {ignore, "wxIMAGE_QUALITY_BICUBIC"}),
    t(wxIMAGE_QUALITY_BOX_AVERAGE, {ignore, "wxIMAGE_QUALITY_BOX_AVERAGE"}),
    t(wxIMAGE_QUALITY_NORMAL, {ignore, "wxIMAGE_QUALITY_NORMAL"}),
    t(wxIMAGE_QUALITY_HIGH, {ignore, "wxIMAGE_QUALITY_HIGH"}),
    t(wxIMAGE_RESOLUTION_NONE, ?wxIMAGE_RESOLUTION_NONE),
    t(wxIMAGE_RESOLUTION_INCHES, ?wxIMAGE_RESOLUTION_INCHES),
    t(wxIMAGE_RESOLUTION_CM, ?wxIMAGE_RESOLUTION_CM),
    t(wxIMAGE_LIST_NORMAL, ?wxIMAGE_LIST_NORMAL),
    t(wxIMAGE_LIST_SMALL, ?wxIMAGE_LIST_SMALL),
    t(wxIMAGE_LIST_STATE, ?wxIMAGE_LIST_STATE),
    t(wxIMAGELIST_DRAW_FOCUSED, ?wxIMAGELIST_DRAW_FOCUSED),
    t(wxIMAGELIST_DRAW_SELECTED, ?wxIMAGELIST_DRAW_SELECTED),
    t(wxIMAGELIST_DRAW_TRANSPARENT, ?wxIMAGELIST_DRAW_TRANSPARENT),
    t(wxIMAGELIST_DRAW_NORMAL, ?wxIMAGELIST_DRAW_NORMAL),
    t(wxLayout_Default, ?wxLayout_Default),
    t(wxLayout_LeftToRight, ?wxLayout_LeftToRight),
    t(wxLayout_RightToLeft, ?wxLayout_RightToLeft),
    t(wxLOCALE_CAT_NUMBER, ?wxLOCALE_CAT_NUMBER),
    t(wxLOCALE_CAT_DATE, ?wxLOCALE_CAT_DATE),
    t(wxLOCALE_CAT_MONEY, ?wxLOCALE_CAT_MONEY),
    t(wxLOCALE_CAT_DEFAULT, ?wxLOCALE_CAT_DEFAULT),
    t(wxLOCALE_THOUSANDS_SEP, ?wxLOCALE_THOUSANDS_SEP),
    t(wxLOCALE_DECIMAL_POINT, ?wxLOCALE_DECIMAL_POINT),
    t(wxLOCALE_SHORT_DATE_FMT, ?wxLOCALE_SHORT_DATE_FMT),
    t(wxLOCALE_LONG_DATE_FMT, ?wxLOCALE_LONG_DATE_FMT),
    t(wxLOCALE_DATE_TIME_FMT, ?wxLOCALE_DATE_TIME_FMT),
    t(wxLOCALE_TIME_FMT, ?wxLOCALE_TIME_FMT),
    t(wxLOCALE_DONT_LOAD_DEFAULT, ?wxLOCALE_DONT_LOAD_DEFAULT),
    t(wxLOCALE_LOAD_DEFAULT, ?wxLOCALE_LOAD_DEFAULT),
    t(wxLANGUAGE_DEFAULT, {ignore, "wxLANGUAGE_DEFAULT"}),
    t(wxLANGUAGE_UNKNOWN, {ignore, "wxLANGUAGE_UNKNOWN"}),
    t(wxLANGUAGE_ABKHAZIAN, {ignore, "wxLANGUAGE_ABKHAZIAN"}),
    t(wxLANGUAGE_AFAR, {ignore, "wxLANGUAGE_AFAR"}),
    t(wxLANGUAGE_AFRIKAANS, {ignore, "wxLANGUAGE_AFRIKAANS"}),
    t(wxLANGUAGE_ALBANIAN, {ignore, "wxLANGUAGE_ALBANIAN"}),
    t(wxLANGUAGE_AMHARIC, {ignore, "wxLANGUAGE_AMHARIC"}),
    t(wxLANGUAGE_ARABIC, {ignore, "wxLANGUAGE_ARABIC"}),
    t(wxLANGUAGE_ARABIC_ALGERIA, {ignore, "wxLANGUAGE_ARABIC_ALGERIA"}),
    t(wxLANGUAGE_ARABIC_BAHRAIN, {ignore, "wxLANGUAGE_ARABIC_BAHRAIN"}),
    t(wxLANGUAGE_ARABIC_EGYPT, {ignore, "wxLANGUAGE_ARABIC_EGYPT"}),
    t(wxLANGUAGE_ARABIC_IRAQ, {ignore, "wxLANGUAGE_ARABIC_IRAQ"}),
    t(wxLANGUAGE_ARABIC_JORDAN, {ignore, "wxLANGUAGE_ARABIC_JORDAN"}),
    t(wxLANGUAGE_ARABIC_KUWAIT, {ignore, "wxLANGUAGE_ARABIC_KUWAIT"}),
    t(wxLANGUAGE_ARABIC_LEBANON, {ignore, "wxLANGUAGE_ARABIC_LEBANON"}),
    t(wxLANGUAGE_ARABIC_LIBYA, {ignore, "wxLANGUAGE_ARABIC_LIBYA"}),
    t(wxLANGUAGE_ARABIC_MOROCCO, {ignore, "wxLANGUAGE_ARABIC_MOROCCO"}),
    t(wxLANGUAGE_ARABIC_OMAN, {ignore, "wxLANGUAGE_ARABIC_OMAN"}),
    t(wxLANGUAGE_ARABIC_QATAR, {ignore, "wxLANGUAGE_ARABIC_QATAR"}),
    t(wxLANGUAGE_ARABIC_SAUDI_ARABIA, {ignore, "wxLANGUAGE_ARABIC_SAUDI_ARABIA"}),
    t(wxLANGUAGE_ARABIC_SUDAN, {ignore, "wxLANGUAGE_ARABIC_SUDAN"}),
    t(wxLANGUAGE_ARABIC_SYRIA, {ignore, "wxLANGUAGE_ARABIC_SYRIA"}),
    t(wxLANGUAGE_ARABIC_TUNISIA, {ignore, "wxLANGUAGE_ARABIC_TUNISIA"}),
    t(wxLANGUAGE_ARABIC_UAE, {ignore, "wxLANGUAGE_ARABIC_UAE"}),
    t(wxLANGUAGE_ARABIC_YEMEN, {ignore, "wxLANGUAGE_ARABIC_YEMEN"}),
    t(wxLANGUAGE_ARMENIAN, {ignore, "wxLANGUAGE_ARMENIAN"}),
    t(wxLANGUAGE_ASSAMESE, {ignore, "wxLANGUAGE_ASSAMESE"}),
    t(wxLANGUAGE_ASTURIAN, {ignore, "wxLANGUAGE_ASTURIAN"}),
    t(wxLANGUAGE_AYMARA, {ignore, "wxLANGUAGE_AYMARA"}),
    t(wxLANGUAGE_AZERI, {ignore, "wxLANGUAGE_AZERI"}),
    t(wxLANGUAGE_AZERI_CYRILLIC, {ignore, "wxLANGUAGE_AZERI_CYRILLIC"}),
    t(wxLANGUAGE_AZERI_LATIN, {ignore, "wxLANGUAGE_AZERI_LATIN"}),
    t(wxLANGUAGE_BASHKIR, {ignore, "wxLANGUAGE_BASHKIR"}),
    t(wxLANGUAGE_BASQUE, {ignore, "wxLANGUAGE_BASQUE"}),
    t(wxLANGUAGE_BELARUSIAN, {ignore, "wxLANGUAGE_BELARUSIAN"}),
    t(wxLANGUAGE_BENGALI, {ignore, "wxLANGUAGE_BENGALI"}),
    t(wxLANGUAGE_BHUTANI, {ignore, "wxLANGUAGE_BHUTANI"}),
    t(wxLANGUAGE_BIHARI, {ignore, "wxLANGUAGE_BIHARI"}),
    t(wxLANGUAGE_BISLAMA, {ignore, "wxLANGUAGE_BISLAMA"}),
    t(wxLANGUAGE_BOSNIAN, {ignore, "wxLANGUAGE_BOSNIAN"}),
    t(wxLANGUAGE_BRETON, {ignore, "wxLANGUAGE_BRETON"}),
    t(wxLANGUAGE_BULGARIAN, {ignore, "wxLANGUAGE_BULGARIAN"}),
    t(wxLANGUAGE_BURMESE, {ignore, "wxLANGUAGE_BURMESE"}),
    t(wxLANGUAGE_CATALAN, {ignore, "wxLANGUAGE_CATALAN"}),
    t(wxLANGUAGE_CHINESE, {ignore, "wxLANGUAGE_CHINESE"}),
    t(wxLANGUAGE_CHINESE_SIMPLIFIED, {ignore, "wxLANGUAGE_CHINESE_SIMPLIFIED"}),
    t(wxLANGUAGE_CHINESE_TRADITIONAL, {ignore, "wxLANGUAGE_CHINESE_TRADITIONAL"}),
    t(wxLANGUAGE_CHINESE_HONGKONG, {ignore, "wxLANGUAGE_CHINESE_HONGKONG"}),
    t(wxLANGUAGE_CHINESE_MACAU, {ignore, "wxLANGUAGE_CHINESE_MACAU"}),
    t(wxLANGUAGE_CHINESE_SINGAPORE, {ignore, "wxLANGUAGE_CHINESE_SINGAPORE"}),
    t(wxLANGUAGE_CHINESE_TAIWAN, {ignore, "wxLANGUAGE_CHINESE_TAIWAN"}),
    t(wxLANGUAGE_CORSICAN, {ignore, "wxLANGUAGE_CORSICAN"}),
    t(wxLANGUAGE_CROATIAN, {ignore, "wxLANGUAGE_CROATIAN"}),
    t(wxLANGUAGE_CZECH, {ignore, "wxLANGUAGE_CZECH"}),
    t(wxLANGUAGE_DANISH, {ignore, "wxLANGUAGE_DANISH"}),
    t(wxLANGUAGE_DUTCH, {ignore, "wxLANGUAGE_DUTCH"}),
    t(wxLANGUAGE_DUTCH_BELGIAN, {ignore, "wxLANGUAGE_DUTCH_BELGIAN"}),
    t(wxLANGUAGE_ENGLISH, {ignore, "wxLANGUAGE_ENGLISH"}),
    t(wxLANGUAGE_ENGLISH_UK, {ignore, "wxLANGUAGE_ENGLISH_UK"}),
    t(wxLANGUAGE_ENGLISH_US, {ignore, "wxLANGUAGE_ENGLISH_US"}),
    t(wxLANGUAGE_ENGLISH_AUSTRALIA, {ignore, "wxLANGUAGE_ENGLISH_AUSTRALIA"}),
    t(wxLANGUAGE_ENGLISH_BELIZE, {ignore, "wxLANGUAGE_ENGLISH_BELIZE"}),
    t(wxLANGUAGE_ENGLISH_BOTSWANA, {ignore, "wxLANGUAGE_ENGLISH_BOTSWANA"}),
    t(wxLANGUAGE_ENGLISH_CANADA, {ignore, "wxLANGUAGE_ENGLISH_CANADA"}),
    t(wxLANGUAGE_ENGLISH_CARIBBEAN, {ignore, "wxLANGUAGE_ENGLISH_CARIBBEAN"}),
    t(wxLANGUAGE_ENGLISH_DENMARK, {ignore, "wxLANGUAGE_ENGLISH_DENMARK"}),
    t(wxLANGUAGE_ENGLISH_EIRE, {ignore, "wxLANGUAGE_ENGLISH_EIRE"}),
    t(wxLANGUAGE_ENGLISH_JAMAICA, {ignore, "wxLANGUAGE_ENGLISH_JAMAICA"}),
    t(wxLANGUAGE_ENGLISH_NEW_ZEALAND, {ignore, "wxLANGUAGE_ENGLISH_NEW_ZEALAND"}),
    t(wxLANGUAGE_ENGLISH_PHILIPPINES, {ignore, "wxLANGUAGE_ENGLISH_PHILIPPINES"}),
    t(wxLANGUAGE_ENGLISH_SOUTH_AFRICA, {ignore, "wxLANGUAGE_ENGLISH_SOUTH_AFRICA"}),
    t(wxLANGUAGE_ENGLISH_TRINIDAD, {ignore, "wxLANGUAGE_ENGLISH_TRINIDAD"}),
    t(wxLANGUAGE_ENGLISH_ZIMBABWE, {ignore, "wxLANGUAGE_ENGLISH_ZIMBABWE"}),
    t(wxLANGUAGE_ESPERANTO, {ignore, "wxLANGUAGE_ESPERANTO"}),
    t(wxLANGUAGE_ESTONIAN, {ignore, "wxLANGUAGE_ESTONIAN"}),
    t(wxLANGUAGE_FAEROESE, {ignore, "wxLANGUAGE_FAEROESE"}),
    t(wxLANGUAGE_FARSI, {ignore, "wxLANGUAGE_FARSI"}),
    t(wxLANGUAGE_FIJI, {ignore, "wxLANGUAGE_FIJI"}),
    t(wxLANGUAGE_FINNISH, {ignore, "wxLANGUAGE_FINNISH"}),
    t(wxLANGUAGE_FRENCH, {ignore, "wxLANGUAGE_FRENCH"}),
    t(wxLANGUAGE_FRENCH_BELGIAN, {ignore, "wxLANGUAGE_FRENCH_BELGIAN"}),
    t(wxLANGUAGE_FRENCH_CANADIAN, {ignore, "wxLANGUAGE_FRENCH_CANADIAN"}),
    t(wxLANGUAGE_FRENCH_LUXEMBOURG, {ignore, "wxLANGUAGE_FRENCH_LUXEMBOURG"}),
    t(wxLANGUAGE_FRENCH_MONACO, {ignore, "wxLANGUAGE_FRENCH_MONACO"}),
    t(wxLANGUAGE_FRENCH_SWISS, {ignore, "wxLANGUAGE_FRENCH_SWISS"}),
    t(wxLANGUAGE_FRISIAN, {ignore, "wxLANGUAGE_FRISIAN"}),
    t(wxLANGUAGE_GALICIAN, {ignore, "wxLANGUAGE_GALICIAN"}),
    t(wxLANGUAGE_GEORGIAN, {ignore, "wxLANGUAGE_GEORGIAN"}),
    t(wxLANGUAGE_GERMAN, {ignore, "wxLANGUAGE_GERMAN"}),
    t(wxLANGUAGE_GERMAN_AUSTRIAN, {ignore, "wxLANGUAGE_GERMAN_AUSTRIAN"}),
    t(wxLANGUAGE_GERMAN_BELGIUM, {ignore, "wxLANGUAGE_GERMAN_BELGIUM"}),
    t(wxLANGUAGE_GERMAN_LIECHTENSTEIN, {ignore, "wxLANGUAGE_GERMAN_LIECHTENSTEIN"}),
    t(wxLANGUAGE_GERMAN_LUXEMBOURG, {ignore, "wxLANGUAGE_GERMAN_LUXEMBOURG"}),
    t(wxLANGUAGE_GERMAN_SWISS, {ignore, "wxLANGUAGE_GERMAN_SWISS"}),
    t(wxLANGUAGE_GREEK, {ignore, "wxLANGUAGE_GREEK"}),
    t(wxLANGUAGE_GREENLANDIC, {ignore, "wxLANGUAGE_GREENLANDIC"}),
    t(wxLANGUAGE_GUARANI, {ignore, "wxLANGUAGE_GUARANI"}),
    t(wxLANGUAGE_GUJARATI, {ignore, "wxLANGUAGE_GUJARATI"}),
    t(wxLANGUAGE_HAUSA, {ignore, "wxLANGUAGE_HAUSA"}),
    t(wxLANGUAGE_HEBREW, {ignore, "wxLANGUAGE_HEBREW"}),
    t(wxLANGUAGE_HINDI, {ignore, "wxLANGUAGE_HINDI"}),
    t(wxLANGUAGE_HUNGARIAN, {ignore, "wxLANGUAGE_HUNGARIAN"}),
    t(wxLANGUAGE_ICELANDIC, {ignore, "wxLANGUAGE_ICELANDIC"}),
    t(wxLANGUAGE_INDONESIAN, {ignore, "wxLANGUAGE_INDONESIAN"}),
    t(wxLANGUAGE_INTERLINGUA, {ignore, "wxLANGUAGE_INTERLINGUA"}),
    t(wxLANGUAGE_INTERLINGUE, {ignore, "wxLANGUAGE_INTERLINGUE"}),
    t(wxLANGUAGE_INUKTITUT, {ignore, "wxLANGUAGE_INUKTITUT"}),
    t(wxLANGUAGE_INUPIAK, {ignore, "wxLANGUAGE_INUPIAK"}),
    t(wxLANGUAGE_IRISH, {ignore, "wxLANGUAGE_IRISH"}),
    t(wxLANGUAGE_ITALIAN, {ignore, "wxLANGUAGE_ITALIAN"}),
    t(wxLANGUAGE_ITALIAN_SWISS, {ignore, "wxLANGUAGE_ITALIAN_SWISS"}),
    t(wxLANGUAGE_JAPANESE, {ignore, "wxLANGUAGE_JAPANESE"}),
    t(wxLANGUAGE_JAVANESE, {ignore, "wxLANGUAGE_JAVANESE"}),
    t(wxLANGUAGE_KABYLE, {ignore, "wxLANGUAGE_KABYLE"}),
    t(wxLANGUAGE_KANNADA, {ignore, "wxLANGUAGE_KANNADA"}),
    t(wxLANGUAGE_KASHMIRI, {ignore, "wxLANGUAGE_KASHMIRI"}),
    t(wxLANGUAGE_KASHMIRI_INDIA, {ignore, "wxLANGUAGE_KASHMIRI_INDIA"}),
    t(wxLANGUAGE_KAZAKH, {ignore, "wxLANGUAGE_KAZAKH"}),
    t(wxLANGUAGE_KERNEWEK, {ignore, "wxLANGUAGE_KERNEWEK"}),
    t(wxLANGUAGE_KINYARWANDA, {ignore, "wxLANGUAGE_KINYARWANDA"}),
    t(wxLANGUAGE_KIRGHIZ, {ignore, "wxLANGUAGE_KIRGHIZ"}),
    t(wxLANGUAGE_KIRUNDI, {ignore, "wxLANGUAGE_KIRUNDI"}),
    t(wxLANGUAGE_KONKANI, {ignore, "wxLANGUAGE_KONKANI"}),
    t(wxLANGUAGE_KOREAN, {ignore, "wxLANGUAGE_KOREAN"}),
    t(wxLANGUAGE_KURDISH, {ignore, "wxLANGUAGE_KURDISH"}),
    t(wxLANGUAGE_LAOTHIAN, {ignore, "wxLANGUAGE_LAOTHIAN"}),
    t(wxLANGUAGE_LATIN, {ignore, "wxLANGUAGE_LATIN"}),
    t(wxLANGUAGE_LATVIAN, {ignore, "wxLANGUAGE_LATVIAN"}),
    t(wxLANGUAGE_LINGALA, {ignore, "wxLANGUAGE_LINGALA"}),
    t(wxLANGUAGE_LITHUANIAN, {ignore, "wxLANGUAGE_LITHUANIAN"}),
    t(wxLANGUAGE_MACEDONIAN, {ignore, "wxLANGUAGE_MACEDONIAN"}),
    t(wxLANGUAGE_MALAGASY, {ignore, "wxLANGUAGE_MALAGASY"}),
    t(wxLANGUAGE_MALAY, {ignore, "wxLANGUAGE_MALAY"}),
    t(wxLANGUAGE_MALAYALAM, {ignore, "wxLANGUAGE_MALAYALAM"}),
    t(wxLANGUAGE_MALAY_BRUNEI_DARUSSALAM, {ignore, "wxLANGUAGE_MALAY_BRUNEI_DARUSSALAM"}),
    t(wxLANGUAGE_MALAY_MALAYSIA, {ignore, "wxLANGUAGE_MALAY_MALAYSIA"}),
    t(wxLANGUAGE_MALTESE, {ignore, "wxLANGUAGE_MALTESE"}),
    t(wxLANGUAGE_MANIPURI, {ignore, "wxLANGUAGE_MANIPURI"}),
    t(wxLANGUAGE_MAORI, {ignore, "wxLANGUAGE_MAORI"}),
    t(wxLANGUAGE_MARATHI, {ignore, "wxLANGUAGE_MARATHI"}),
    t(wxLANGUAGE_MOLDAVIAN, {ignore, "wxLANGUAGE_MOLDAVIAN"}),
    t(wxLANGUAGE_MONGOLIAN, {ignore, "wxLANGUAGE_MONGOLIAN"}),
    t(wxLANGUAGE_NAURU, {ignore, "wxLANGUAGE_NAURU"}),
    t(wxLANGUAGE_NEPALI, {ignore, "wxLANGUAGE_NEPALI"}),
    t(wxLANGUAGE_NEPALI_INDIA, {ignore, "wxLANGUAGE_NEPALI_INDIA"}),
    t(wxLANGUAGE_NORWEGIAN_BOKMAL, {ignore, "wxLANGUAGE_NORWEGIAN_BOKMAL"}),
    t(wxLANGUAGE_NORWEGIAN_NYNORSK, {ignore, "wxLANGUAGE_NORWEGIAN_NYNORSK"}),
    t(wxLANGUAGE_OCCITAN, {ignore, "wxLANGUAGE_OCCITAN"}),
    t(wxLANGUAGE_ORIYA, {ignore, "wxLANGUAGE_ORIYA"}),
    t(wxLANGUAGE_OROMO, {ignore, "wxLANGUAGE_OROMO"}),
    t(wxLANGUAGE_PASHTO, {ignore, "wxLANGUAGE_PASHTO"}),
    t(wxLANGUAGE_POLISH, {ignore, "wxLANGUAGE_POLISH"}),
    t(wxLANGUAGE_PORTUGUESE, {ignore, "wxLANGUAGE_PORTUGUESE"}),
    t(wxLANGUAGE_PORTUGUESE_BRAZILIAN, {ignore, "wxLANGUAGE_PORTUGUESE_BRAZILIAN"}),
    t(wxLANGUAGE_PUNJABI, {ignore, "wxLANGUAGE_PUNJABI"}),
    t(wxLANGUAGE_QUECHUA, {ignore, "wxLANGUAGE_QUECHUA"}),
    t(wxLANGUAGE_RHAETO_ROMANCE, {ignore, "wxLANGUAGE_RHAETO_ROMANCE"}),
    t(wxLANGUAGE_ROMANIAN, {ignore, "wxLANGUAGE_ROMANIAN"}),
    t(wxLANGUAGE_RUSSIAN, {ignore, "wxLANGUAGE_RUSSIAN"}),
    t(wxLANGUAGE_RUSSIAN_UKRAINE, {ignore, "wxLANGUAGE_RUSSIAN_UKRAINE"}),
    t(wxLANGUAGE_SAMI, {ignore, "wxLANGUAGE_SAMI"}),
    t(wxLANGUAGE_SAMOAN, {ignore, "wxLANGUAGE_SAMOAN"}),
    t(wxLANGUAGE_SANGHO, {ignore, "wxLANGUAGE_SANGHO"}),
    t(wxLANGUAGE_SANSKRIT, {ignore, "wxLANGUAGE_SANSKRIT"}),
    t(wxLANGUAGE_SCOTS_GAELIC, {ignore, "wxLANGUAGE_SCOTS_GAELIC"}),
    t(wxLANGUAGE_SERBIAN, {ignore, "wxLANGUAGE_SERBIAN"}),
    t(wxLANGUAGE_SERBIAN_CYRILLIC, {ignore, "wxLANGUAGE_SERBIAN_CYRILLIC"}),
    t(wxLANGUAGE_SERBIAN_LATIN, {ignore, "wxLANGUAGE_SERBIAN_LATIN"}),
    t(wxLANGUAGE_SERBO_CROATIAN, {ignore, "wxLANGUAGE_SERBO_CROATIAN"}),
    t(wxLANGUAGE_SESOTHO, {ignore, "wxLANGUAGE_SESOTHO"}),
    t(wxLANGUAGE_SETSWANA, {ignore, "wxLANGUAGE_SETSWANA"}),
    t(wxLANGUAGE_SHONA, {ignore, "wxLANGUAGE_SHONA"}),
    t(wxLANGUAGE_SINDHI, {ignore, "wxLANGUAGE_SINDHI"}),
    t(wxLANGUAGE_SINHALESE, {ignore, "wxLANGUAGE_SINHALESE"}),
    t(wxLANGUAGE_SISWATI, {ignore, "wxLANGUAGE_SISWATI"}),
    t(wxLANGUAGE_SLOVAK, {ignore, "wxLANGUAGE_SLOVAK"}),
    t(wxLANGUAGE_SLOVENIAN, {ignore, "wxLANGUAGE_SLOVENIAN"}),
    t(wxLANGUAGE_SOMALI, {ignore, "wxLANGUAGE_SOMALI"}),
    t(wxLANGUAGE_SPANISH, {ignore, "wxLANGUAGE_SPANISH"}),
    t(wxLANGUAGE_SPANISH_ARGENTINA, {ignore, "wxLANGUAGE_SPANISH_ARGENTINA"}),
    t(wxLANGUAGE_SPANISH_BOLIVIA, {ignore, "wxLANGUAGE_SPANISH_BOLIVIA"}),
    t(wxLANGUAGE_SPANISH_CHILE, {ignore, "wxLANGUAGE_SPANISH_CHILE"}),
    t(wxLANGUAGE_SPANISH_COLOMBIA, {ignore, "wxLANGUAGE_SPANISH_COLOMBIA"}),
    t(wxLANGUAGE_SPANISH_COSTA_RICA, {ignore, "wxLANGUAGE_SPANISH_COSTA_RICA"}),
    t(wxLANGUAGE_SPANISH_DOMINICAN_REPUBLIC, {ignore, "wxLANGUAGE_SPANISH_DOMINICAN_REPUBLIC"}),
    t(wxLANGUAGE_SPANISH_ECUADOR, {ignore, "wxLANGUAGE_SPANISH_ECUADOR"}),
    t(wxLANGUAGE_SPANISH_EL_SALVADOR, {ignore, "wxLANGUAGE_SPANISH_EL_SALVADOR"}),
    t(wxLANGUAGE_SPANISH_GUATEMALA, {ignore, "wxLANGUAGE_SPANISH_GUATEMALA"}),
    t(wxLANGUAGE_SPANISH_HONDURAS, {ignore, "wxLANGUAGE_SPANISH_HONDURAS"}),
    t(wxLANGUAGE_SPANISH_MEXICAN, {ignore, "wxLANGUAGE_SPANISH_MEXICAN"}),
    t(wxLANGUAGE_SPANISH_MODERN, {ignore, "wxLANGUAGE_SPANISH_MODERN"}),
    t(wxLANGUAGE_SPANISH_NICARAGUA, {ignore, "wxLANGUAGE_SPANISH_NICARAGUA"}),
    t(wxLANGUAGE_SPANISH_PANAMA, {ignore, "wxLANGUAGE_SPANISH_PANAMA"}),
    t(wxLANGUAGE_SPANISH_PARAGUAY, {ignore, "wxLANGUAGE_SPANISH_PARAGUAY"}),
    t(wxLANGUAGE_SPANISH_PERU, {ignore, "wxLANGUAGE_SPANISH_PERU"}),
    t(wxLANGUAGE_SPANISH_PUERTO_RICO, {ignore, "wxLANGUAGE_SPANISH_PUERTO_RICO"}),
    t(wxLANGUAGE_SPANISH_URUGUAY, {ignore, "wxLANGUAGE_SPANISH_URUGUAY"}),
    t(wxLANGUAGE_SPANISH_US, {ignore, "wxLANGUAGE_SPANISH_US"}),
    t(wxLANGUAGE_SPANISH_VENEZUELA, {ignore, "wxLANGUAGE_SPANISH_VENEZUELA"}),
    t(wxLANGUAGE_SUNDANESE, {ignore, "wxLANGUAGE_SUNDANESE"}),
    t(wxLANGUAGE_SWAHILI, {ignore, "wxLANGUAGE_SWAHILI"}),
    t(wxLANGUAGE_SWEDISH, {ignore, "wxLANGUAGE_SWEDISH"}),
    t(wxLANGUAGE_SWEDISH_FINLAND, {ignore, "wxLANGUAGE_SWEDISH_FINLAND"}),
    t(wxLANGUAGE_TAGALOG, {ignore, "wxLANGUAGE_TAGALOG"}),
    t(wxLANGUAGE_TAJIK, {ignore, "wxLANGUAGE_TAJIK"}),
    t(wxLANGUAGE_TAMIL, {ignore, "wxLANGUAGE_TAMIL"}),
    t(wxLANGUAGE_TATAR, {ignore, "wxLANGUAGE_TATAR"}),
    t(wxLANGUAGE_TELUGU, {ignore, "wxLANGUAGE_TELUGU"}),
    t(wxLANGUAGE_THAI, {ignore, "wxLANGUAGE_THAI"}),
    t(wxLANGUAGE_TIBETAN, {ignore, "wxLANGUAGE_TIBETAN"}),
    t(wxLANGUAGE_TIGRINYA, {ignore, "wxLANGUAGE_TIGRINYA"}),
    t(wxLANGUAGE_TONGA, {ignore, "wxLANGUAGE_TONGA"}),
    t(wxLANGUAGE_TSONGA, {ignore, "wxLANGUAGE_TSONGA"}),
    t(wxLANGUAGE_TURKISH, {ignore, "wxLANGUAGE_TURKISH"}),
    t(wxLANGUAGE_TURKMEN, {ignore, "wxLANGUAGE_TURKMEN"}),
    t(wxLANGUAGE_TWI, {ignore, "wxLANGUAGE_TWI"}),
    t(wxLANGUAGE_UIGHUR, {ignore, "wxLANGUAGE_UIGHUR"}),
    t(wxLANGUAGE_UKRAINIAN, {ignore, "wxLANGUAGE_UKRAINIAN"}),
    t(wxLANGUAGE_URDU, {ignore, "wxLANGUAGE_URDU"}),
    t(wxLANGUAGE_URDU_INDIA, {ignore, "wxLANGUAGE_URDU_INDIA"}),
    t(wxLANGUAGE_URDU_PAKISTAN, {ignore, "wxLANGUAGE_URDU_PAKISTAN"}),
    t(wxLANGUAGE_UZBEK, {ignore, "wxLANGUAGE_UZBEK"}),
    t(wxLANGUAGE_UZBEK_CYRILLIC, {ignore, "wxLANGUAGE_UZBEK_CYRILLIC"}),
    t(wxLANGUAGE_UZBEK_LATIN, {ignore, "wxLANGUAGE_UZBEK_LATIN"}),
    t(wxLANGUAGE_VALENCIAN, {ignore, "wxLANGUAGE_VALENCIAN"}),
    t(wxLANGUAGE_VIETNAMESE, {ignore, "wxLANGUAGE_VIETNAMESE"}),
    t(wxLANGUAGE_VOLAPUK, {ignore, "wxLANGUAGE_VOLAPUK"}),
    t(wxLANGUAGE_WELSH, {ignore, "wxLANGUAGE_WELSH"}),
    t(wxLANGUAGE_WOLOF, {ignore, "wxLANGUAGE_WOLOF"}),
    t(wxLANGUAGE_XHOSA, {ignore, "wxLANGUAGE_XHOSA"}),
    t(wxLANGUAGE_YIDDISH, {ignore, "wxLANGUAGE_YIDDISH"}),
    t(wxLANGUAGE_YORUBA, {ignore, "wxLANGUAGE_YORUBA"}),
    t(wxLANGUAGE_ZHUANG, {ignore, "wxLANGUAGE_ZHUANG"}),
    t(wxLANGUAGE_ZULU, {ignore, "wxLANGUAGE_ZULU"}),
    t(wxLANGUAGE_USER_DEFINED, {ignore, "wxLANGUAGE_USER_DEFINED"}),
    t(wxLANGUAGE_CAMBODIAN, {ignore, "wxLANGUAGE_CAMBODIAN"}),
    t(wxLeft, ?wxLeft),
    t(wxTop, ?wxTop),
    t(wxRight, ?wxRight),
    t(wxBottom, ?wxBottom),
    t(wxWidth, ?wxWidth),
    t(wxHeight, ?wxHeight),
    t(wxCentre, ?wxCentre),
    t(wxCenter, ?wxCenter),
    t(wxCentreX, ?wxCentreX),
    t(wxCentreY, ?wxCentreY),
    t(wxUnconstrained, ?wxUnconstrained),
    t(wxAsIs, ?wxAsIs),
    t(wxPercentOf, ?wxPercentOf),
    t(wxAbove, ?wxAbove),
    t(wxBelow, ?wxBelow),
    t(wxLeftOf, ?wxLeftOf),
    t(wxRightOf, ?wxRightOf),
    t(wxSameAs, ?wxSameAs),
    t(wxAbsolute, ?wxAbsolute),
    t(wxLAYOUT_NONE, ?wxLAYOUT_NONE),
    t(wxLAYOUT_TOP, ?wxLAYOUT_TOP),
    t(wxLAYOUT_LEFT, ?wxLAYOUT_LEFT),
    t(wxLAYOUT_RIGHT, ?wxLAYOUT_RIGHT),
    t(wxLAYOUT_BOTTOM, ?wxLAYOUT_BOTTOM),
    t(wxLAYOUT_HORIZONTAL, ?wxLAYOUT_HORIZONTAL),
    t(wxLAYOUT_VERTICAL, ?wxLAYOUT_VERTICAL),
    t(wxLB_ALIGN_MASK, ?wxLB_ALIGN_MASK),
    t(wxLB_RIGHT, ?wxLB_RIGHT),
    t(wxLB_LEFT, ?wxLB_LEFT),
    t(wxLB_BOTTOM, ?wxLB_BOTTOM),
    t(wxLB_TOP, ?wxLB_TOP),
    t(wxLB_DEFAULT, ?wxLB_DEFAULT),
    t(wxLIST_NEXT_ABOVE, ?wxLIST_NEXT_ABOVE),
    t(wxLIST_NEXT_ALL, ?wxLIST_NEXT_ALL),
    t(wxLIST_NEXT_BELOW, ?wxLIST_NEXT_BELOW),
    t(wxLIST_NEXT_LEFT, ?wxLIST_NEXT_LEFT),
    t(wxLIST_NEXT_RIGHT, ?wxLIST_NEXT_RIGHT),
    t(wxLIST_ALIGN_DEFAULT, ?wxLIST_ALIGN_DEFAULT),
    t(wxLIST_ALIGN_LEFT, ?wxLIST_ALIGN_LEFT),
    t(wxLIST_ALIGN_TOP, ?wxLIST_ALIGN_TOP),
    t(wxLIST_ALIGN_SNAP_TO_GRID, ?wxLIST_ALIGN_SNAP_TO_GRID),
    t(wxLIST_AUTOSIZE, ?wxLIST_AUTOSIZE),
    t(wxLIST_AUTOSIZE_USEHEADER, ?wxLIST_AUTOSIZE_USEHEADER),
    t(wxLIST_RECT_BOUNDS, ?wxLIST_RECT_BOUNDS),
    t(wxLIST_RECT_ICON, ?wxLIST_RECT_ICON),
    t(wxLIST_RECT_LABEL, ?wxLIST_RECT_LABEL),
    t(wxLIST_FIND_UP, ?wxLIST_FIND_UP),
    t(wxLIST_FIND_DOWN, ?wxLIST_FIND_DOWN),
    t(wxLIST_FIND_LEFT, ?wxLIST_FIND_LEFT),
    t(wxLIST_FIND_RIGHT, ?wxLIST_FIND_RIGHT),
    t(wxLIST_HITTEST_ONITEM, ?wxLIST_HITTEST_ONITEM),
    t(wxLIST_HITTEST_TORIGHT, ?wxLIST_HITTEST_TORIGHT),
    t(wxLIST_HITTEST_TOLEFT, ?wxLIST_HITTEST_TOLEFT),
    t(wxLIST_HITTEST_ONITEMSTATEICON, ?wxLIST_HITTEST_ONITEMSTATEICON),
    t(wxLIST_HITTEST_ONITEMLABEL, ?wxLIST_HITTEST_ONITEMLABEL),
    t(wxLIST_HITTEST_ONITEMICON, ?wxLIST_HITTEST_ONITEMICON),
    t(wxLIST_HITTEST_NOWHERE, ?wxLIST_HITTEST_NOWHERE),
    t(wxLIST_HITTEST_BELOW, ?wxLIST_HITTEST_BELOW),
    t(wxLIST_HITTEST_ABOVE, ?wxLIST_HITTEST_ABOVE),
    t(wxLIST_STATE_CUT, ?wxLIST_STATE_CUT),
    t(wxLIST_STATE_SELECTED, ?wxLIST_STATE_SELECTED),
    t(wxLIST_STATE_FOCUSED, ?wxLIST_STATE_FOCUSED),
    t(wxLIST_STATE_DROPHILITED, ?wxLIST_STATE_DROPHILITED),
    t(wxLIST_STATE_DONTCARE, ?wxLIST_STATE_DONTCARE),
    t(wxLIST_MASK_FORMAT, ?wxLIST_MASK_FORMAT),
    t(wxLIST_MASK_WIDTH, ?wxLIST_MASK_WIDTH),
    t(wxLIST_SET_ITEM, ?wxLIST_SET_ITEM),
    t(wxLIST_MASK_DATA, ?wxLIST_MASK_DATA),
    t(wxLIST_MASK_IMAGE, ?wxLIST_MASK_IMAGE),
    t(wxLIST_MASK_TEXT, ?wxLIST_MASK_TEXT),
    t(wxLIST_MASK_STATE, ?wxLIST_MASK_STATE),
    t(wxLC_MASK_SORT, ?wxLC_MASK_SORT),
    t(wxLC_MASK_ALIGN, ?wxLC_MASK_ALIGN),
    t(wxLC_MASK_TYPE, ?wxLC_MASK_TYPE),
    t(wxLC_SORT_DESCENDING, ?wxLC_SORT_DESCENDING),
    t(wxLC_SORT_ASCENDING, ?wxLC_SORT_ASCENDING),
    t(wxLC_SINGLE_SEL, ?wxLC_SINGLE_SEL),
    t(wxLC_NO_SORT_HEADER, ?wxLC_NO_SORT_HEADER),
    t(wxLC_NO_HEADER, ?wxLC_NO_HEADER),
    t(wxLC_EDIT_LABELS, ?wxLC_EDIT_LABELS),
    t(wxLC_VIRTUAL, ?wxLC_VIRTUAL),
    t(wxLC_AUTOARRANGE, ?wxLC_AUTOARRANGE),
    t(wxLC_ALIGN_LEFT, ?wxLC_ALIGN_LEFT),
    t(wxLC_ALIGN_TOP, ?wxLC_ALIGN_TOP),
    t(wxLC_REPORT, ?wxLC_REPORT),
    t(wxLC_LIST, ?wxLC_LIST),
    t(wxLC_SMALL_ICON, ?wxLC_SMALL_ICON),
    t(wxLC_ICON, ?wxLC_ICON),
    t(wxLC_HRULES, ?wxLC_HRULES),
    t(wxLC_VRULES, ?wxLC_VRULES),
    t(wxLIST_FORMAT_LEFT, ?wxLIST_FORMAT_LEFT),
    t(wxLIST_FORMAT_RIGHT, ?wxLIST_FORMAT_RIGHT),
    t(wxLIST_FORMAT_CENTRE, ?wxLIST_FORMAT_CENTRE),
    t(wxLIST_FORMAT_CENTER, ?wxLIST_FORMAT_CENTER),
    t(wxLOG_FatalError, ?wxLOG_FatalError),
    t(wxLOG_Error, ?wxLOG_Error),
    t(wxLOG_Warning, ?wxLOG_Warning),
    t(wxLOG_Message, ?wxLOG_Message),
    t(wxLOG_Status, ?wxLOG_Status),
    t(wxLOG_Info, ?wxLOG_Info),
    t(wxLOG_Debug, ?wxLOG_Debug),
    t(wxLOG_Trace, ?wxLOG_Trace),
    t(wxLOG_Progress, ?wxLOG_Progress),
    t(wxLOG_User, ?wxLOG_User),
    t(wxLOG_Max, ?wxLOG_Max),
    t(wxMOUSE_BTN_ANY, ?wxMOUSE_BTN_ANY),
    t(wxMOUSE_BTN_NONE, ?wxMOUSE_BTN_NONE),
    t(wxMOUSE_BTN_LEFT, ?wxMOUSE_BTN_LEFT),
    t(wxMOUSE_BTN_MIDDLE, ?wxMOUSE_BTN_MIDDLE),
    t(wxMOUSE_BTN_RIGHT, ?wxMOUSE_BTN_RIGHT),
    t(wxMOUSE_BTN_MAX, ?wxMOUSE_BTN_MAX),
    t(wxNB_HITTEST_NOWHERE, ?wxNB_HITTEST_NOWHERE),
    t(wxNB_HITTEST_ONICON, ?wxNB_HITTEST_ONICON),
    t(wxNB_HITTEST_ONLABEL, ?wxNB_HITTEST_ONLABEL),
    t(wxNB_HITTEST_ONPAGE, ?wxNB_HITTEST_ONPAGE),
    t(wxNB_NOPAGETHEME, ?wxNB_NOPAGETHEME),
    t(wxNB_MULTILINE, ?wxNB_MULTILINE),
    t(wxNB_FIXEDWIDTH, ?wxNB_FIXEDWIDTH),
    t(wxNB_RIGHT, ?wxNB_RIGHT),
    t(wxNB_LEFT, ?wxNB_LEFT),
    t(wxNB_BOTTOM, ?wxNB_BOTTOM),
    t(wxNB_TOP, ?wxNB_TOP),
    t(wxNB_DEFAULT, ?wxNB_DEFAULT),
    t(wxCAP_INVALID, ?wxCAP_INVALID),
    t(wxCAP_ROUND, ?wxCAP_ROUND),
    t(wxCAP_PROJECTING, ?wxCAP_PROJECTING),
    t(wxCAP_BUTT, ?wxCAP_BUTT),
    t(wxJOIN_INVALID, ?wxJOIN_INVALID),
    t(wxJOIN_BEVEL, ?wxJOIN_BEVEL),
    t(wxJOIN_MITER, ?wxJOIN_MITER),
    t(wxJOIN_ROUND, ?wxJOIN_ROUND),
    t(wxPENSTYLE_INVALID, ?wxPENSTYLE_INVALID),
    t(wxPENSTYLE_SOLID, ?wxPENSTYLE_SOLID),
    t(wxPENSTYLE_DOT, ?wxPENSTYLE_DOT),
    t(wxPENSTYLE_LONG_DASH, ?wxPENSTYLE_LONG_DASH),
    t(wxPENSTYLE_SHORT_DASH, ?wxPENSTYLE_SHORT_DASH),
    t(wxPENSTYLE_DOT_DASH, ?wxPENSTYLE_DOT_DASH),
    t(wxPENSTYLE_USER_DASH, ?wxPENSTYLE_USER_DASH),
    t(wxPENSTYLE_TRANSPARENT, ?wxPENSTYLE_TRANSPARENT),
    t(wxPENSTYLE_STIPPLE_MASK_OPAQUE, ?wxPENSTYLE_STIPPLE_MASK_OPAQUE),
    t(wxPENSTYLE_STIPPLE_MASK, ?wxPENSTYLE_STIPPLE_MASK),
    t(wxPENSTYLE_STIPPLE, ?wxPENSTYLE_STIPPLE),
    t(wxPENSTYLE_BDIAGONAL_HATCH, ?wxPENSTYLE_BDIAGONAL_HATCH),
    t(wxPENSTYLE_CROSSDIAG_HATCH, ?wxPENSTYLE_CROSSDIAG_HATCH),
    t(wxPENSTYLE_FDIAGONAL_HATCH, ?wxPENSTYLE_FDIAGONAL_HATCH),
    t(wxPENSTYLE_CROSS_HATCH, ?wxPENSTYLE_CROSS_HATCH),
    t(wxPENSTYLE_HORIZONTAL_HATCH, ?wxPENSTYLE_HORIZONTAL_HATCH),
    t(wxPENSTYLE_VERTICAL_HATCH, ?wxPENSTYLE_VERTICAL_HATCH),
    t(wxPENSTYLE_FIRST_HATCH, ?wxPENSTYLE_FIRST_HATCH),
    t(wxPENSTYLE_LAST_HATCH, ?wxPENSTYLE_LAST_HATCH),
    t(wxPB_SMALL, ?wxPB_SMALL),
    t(wxPB_USE_TEXTCTRL, ?wxPB_USE_TEXTCTRL),
    t(wxPU_CONTAINS_CONTROLS, ?wxPU_CONTAINS_CONTROLS),
    t(wxID_PREVIEW_ZOOM_OUT, ?wxID_PREVIEW_ZOOM_OUT),
    t(wxID_PREVIEW_ZOOM_IN, ?wxID_PREVIEW_ZOOM_IN),
    t(wxID_PREVIEW_GOTO, ?wxID_PREVIEW_GOTO),
    t(wxID_PREVIEW_LAST, ?wxID_PREVIEW_LAST),
    t(wxID_PREVIEW_FIRST, ?wxID_PREVIEW_FIRST),
    t(wxID_PREVIEW_ZOOM, ?wxID_PREVIEW_ZOOM),
    t(wxID_PREVIEW_PRINT, ?wxID_PREVIEW_PRINT),
    t(wxID_PREVIEW_PREVIOUS, ?wxID_PREVIEW_PREVIOUS),
    t(wxID_PREVIEW_NEXT, ?wxID_PREVIEW_NEXT),
    t(wxID_PREVIEW_CLOSE, ?wxID_PREVIEW_CLOSE),
    t(wxPREVIEW_DEFAULT, ?wxPREVIEW_DEFAULT),
    t(wxPREVIEW_GOTO, ?wxPREVIEW_GOTO),
    t(wxPREVIEW_LAST, ?wxPREVIEW_LAST),
    t(wxPREVIEW_FIRST, ?wxPREVIEW_FIRST),
    t(wxPREVIEW_ZOOM, ?wxPREVIEW_ZOOM),
    t(wxPREVIEW_NEXT, ?wxPREVIEW_NEXT),
    t(wxPREVIEW_PREVIOUS, ?wxPREVIEW_PREVIOUS),
    t(wxPREVIEW_PRINT, ?wxPREVIEW_PRINT),
    t(wxPreviewFrame_AppModal, ?wxPreviewFrame_AppModal),
    t(wxPreviewFrame_WindowModal, ?wxPreviewFrame_WindowModal),
    t(wxPreviewFrame_NonModal, ?wxPreviewFrame_NonModal),
    t(wxPRINTER_NO_ERROR, ?wxPRINTER_NO_ERROR),
    t(wxPRINTER_CANCELLED, ?wxPRINTER_CANCELLED),
    t(wxPRINTER_ERROR, ?wxPRINTER_ERROR),
    t(wxPD_CAN_SKIP, ?wxPD_CAN_SKIP),
    t(wxPD_REMAINING_TIME, ?wxPD_REMAINING_TIME),
    t(wxPD_SMOOTH, ?wxPD_SMOOTH),
    t(wxPD_ESTIMATED_TIME, ?wxPD_ESTIMATED_TIME),
    t(wxPD_ELAPSED_TIME, ?wxPD_ELAPSED_TIME),
    t(wxPD_AUTO_HIDE, ?wxPD_AUTO_HIDE),
    t(wxPD_APP_MODAL, ?wxPD_APP_MODAL),
    t(wxPD_CAN_ABORT, ?wxPD_CAN_ABORT),
    t(wxOutRegion, ?wxOutRegion),
    t(wxPartRegion, ?wxPartRegion),
    t(wxInRegion, ?wxInRegion),
    t(wxSW_3D, ?wxSW_3D),
    t(wxSW_3DBORDER, ?wxSW_3DBORDER),
    t(wxSW_3DSASH, ?wxSW_3DSASH),
    t(wxSW_BORDER, ?wxSW_BORDER),
    t(wxSW_NOBORDER, ?wxSW_NOBORDER),
    t(wxSASH_STATUS_OK, ?wxSASH_STATUS_OK),
    t(wxSASH_STATUS_OUT_OF_RANGE, ?wxSASH_STATUS_OUT_OF_RANGE),
    t(wxSASH_TOP, ?wxSASH_TOP),
    t(wxSASH_RIGHT, ?wxSASH_RIGHT),
    t(wxSASH_BOTTOM, ?wxSASH_BOTTOM),
    t(wxSASH_LEFT, ?wxSASH_LEFT),
    t(wxSASH_NONE, ?wxSASH_NONE),
    t(wxSHOW_SB_NEVER, ?wxSHOW_SB_NEVER),
    t(wxSHOW_SB_DEFAULT, ?wxSHOW_SB_DEFAULT),
    t(wxSHOW_SB_ALWAYS, ?wxSHOW_SB_ALWAYS),
    t(wxSYS_COLOUR_SCROLLBAR, ?wxSYS_COLOUR_SCROLLBAR),
    t(wxSYS_COLOUR_DESKTOP, ?wxSYS_COLOUR_DESKTOP),
    t(wxSYS_COLOUR_ACTIVECAPTION, ?wxSYS_COLOUR_ACTIVECAPTION),
    t(wxSYS_COLOUR_INACTIVECAPTION, ?wxSYS_COLOUR_INACTIVECAPTION),
    t(wxSYS_COLOUR_MENU, ?wxSYS_COLOUR_MENU),
    t(wxSYS_COLOUR_WINDOW, ?wxSYS_COLOUR_WINDOW),
    t(wxSYS_COLOUR_WINDOWFRAME, ?wxSYS_COLOUR_WINDOWFRAME),
    t(wxSYS_COLOUR_MENUTEXT, ?wxSYS_COLOUR_MENUTEXT),
    t(wxSYS_COLOUR_WINDOWTEXT, ?wxSYS_COLOUR_WINDOWTEXT),
    t(wxSYS_COLOUR_CAPTIONTEXT, ?wxSYS_COLOUR_CAPTIONTEXT),
    t(wxSYS_COLOUR_ACTIVEBORDER, ?wxSYS_COLOUR_ACTIVEBORDER),
    t(wxSYS_COLOUR_INACTIVEBORDER, ?wxSYS_COLOUR_INACTIVEBORDER),
    t(wxSYS_COLOUR_APPWORKSPACE, ?wxSYS_COLOUR_APPWORKSPACE),
    t(wxSYS_COLOUR_HIGHLIGHT, ?wxSYS_COLOUR_HIGHLIGHT),
    t(wxSYS_COLOUR_HIGHLIGHTTEXT, ?wxSYS_COLOUR_HIGHLIGHTTEXT),
    t(wxSYS_COLOUR_BTNFACE, ?wxSYS_COLOUR_BTNFACE),
    t(wxSYS_COLOUR_BTNSHADOW, ?wxSYS_COLOUR_BTNSHADOW),
    t(wxSYS_COLOUR_GRAYTEXT, ?wxSYS_COLOUR_GRAYTEXT),
    t(wxSYS_COLOUR_BTNTEXT, ?wxSYS_COLOUR_BTNTEXT),
    t(wxSYS_COLOUR_INACTIVECAPTIONTEXT, ?wxSYS_COLOUR_INACTIVECAPTIONTEXT),
    t(wxSYS_COLOUR_BTNHIGHLIGHT, ?wxSYS_COLOUR_BTNHIGHLIGHT),
    t(wxSYS_COLOUR_3DDKSHADOW, ?wxSYS_COLOUR_3DDKSHADOW),
    t(wxSYS_COLOUR_3DLIGHT, ?wxSYS_COLOUR_3DLIGHT),
    t(wxSYS_COLOUR_INFOTEXT, ?wxSYS_COLOUR_INFOTEXT),
    t(wxSYS_COLOUR_INFOBK, ?wxSYS_COLOUR_INFOBK),
    t(wxSYS_COLOUR_LISTBOX, ?wxSYS_COLOUR_LISTBOX),
    t(wxSYS_COLOUR_HOTLIGHT, ?wxSYS_COLOUR_HOTLIGHT),
    t(wxSYS_COLOUR_GRADIENTACTIVECAPTION, ?wxSYS_COLOUR_GRADIENTACTIVECAPTION),
    t(wxSYS_COLOUR_GRADIENTINACTIVECAPTION, ?wxSYS_COLOUR_GRADIENTINACTIVECAPTION),
    t(wxSYS_COLOUR_MENUHILIGHT, ?wxSYS_COLOUR_MENUHILIGHT),
    t(wxSYS_COLOUR_MENUBAR, ?wxSYS_COLOUR_MENUBAR),
    t(wxSYS_COLOUR_LISTBOXTEXT, ?wxSYS_COLOUR_LISTBOXTEXT),
    t(wxSYS_COLOUR_LISTBOXHIGHLIGHTTEXT, ?wxSYS_COLOUR_LISTBOXHIGHLIGHTTEXT),
    t(wxSYS_COLOUR_BACKGROUND, ?wxSYS_COLOUR_BACKGROUND),
    t(wxSYS_COLOUR_3DFACE, ?wxSYS_COLOUR_3DFACE),
    t(wxSYS_COLOUR_3DSHADOW, ?wxSYS_COLOUR_3DSHADOW),
    t(wxSYS_COLOUR_BTNHILIGHT, ?wxSYS_COLOUR_BTNHILIGHT),
    t(wxSYS_COLOUR_3DHIGHLIGHT, ?wxSYS_COLOUR_3DHIGHLIGHT),
    t(wxSYS_COLOUR_3DHILIGHT, ?wxSYS_COLOUR_3DHILIGHT),
    t(wxSYS_COLOUR_FRAMEBK, ?wxSYS_COLOUR_FRAMEBK),
    t(wxSYS_CAN_DRAW_FRAME_DECORATIONS, ?wxSYS_CAN_DRAW_FRAME_DECORATIONS),
    t(wxSYS_CAN_ICONIZE_FRAME, ?wxSYS_CAN_ICONIZE_FRAME),
    t(wxSYS_TABLET_PRESENT, ?wxSYS_TABLET_PRESENT),
    t(wxSYS_OEM_FIXED_FONT, ?wxSYS_OEM_FIXED_FONT),
    t(wxSYS_ANSI_FIXED_FONT, ?wxSYS_ANSI_FIXED_FONT),
    t(wxSYS_ANSI_VAR_FONT, ?wxSYS_ANSI_VAR_FONT),
    t(wxSYS_SYSTEM_FONT, ?wxSYS_SYSTEM_FONT),
    t(wxSYS_DEVICE_DEFAULT_FONT, ?wxSYS_DEVICE_DEFAULT_FONT),
    t(wxSYS_DEFAULT_GUI_FONT, ?wxSYS_DEFAULT_GUI_FONT),
    t(wxSYS_MOUSE_BUTTONS, ?wxSYS_MOUSE_BUTTONS),
    t(wxSYS_BORDER_X, ?wxSYS_BORDER_X),
    t(wxSYS_BORDER_Y, ?wxSYS_BORDER_Y),
    t(wxSYS_CURSOR_X, ?wxSYS_CURSOR_X),
    t(wxSYS_CURSOR_Y, ?wxSYS_CURSOR_Y),
    t(wxSYS_DCLICK_X, ?wxSYS_DCLICK_X),
    t(wxSYS_DCLICK_Y, ?wxSYS_DCLICK_Y),
    t(wxSYS_DRAG_X, ?wxSYS_DRAG_X),
    t(wxSYS_DRAG_Y, ?wxSYS_DRAG_Y),
    t(wxSYS_EDGE_X, ?wxSYS_EDGE_X),
    t(wxSYS_EDGE_Y, ?wxSYS_EDGE_Y),
    t(wxSYS_HSCROLL_ARROW_X, ?wxSYS_HSCROLL_ARROW_X),
    t(wxSYS_HSCROLL_ARROW_Y, ?wxSYS_HSCROLL_ARROW_Y),
    t(wxSYS_HTHUMB_X, ?wxSYS_HTHUMB_X),
    t(wxSYS_ICON_X, ?wxSYS_ICON_X),
    t(wxSYS_ICON_Y, ?wxSYS_ICON_Y),
    t(wxSYS_ICONSPACING_X, ?wxSYS_ICONSPACING_X),
    t(wxSYS_ICONSPACING_Y, ?wxSYS_ICONSPACING_Y),
    t(wxSYS_WINDOWMIN_X, ?wxSYS_WINDOWMIN_X),
    t(wxSYS_WINDOWMIN_Y, ?wxSYS_WINDOWMIN_Y),
    t(wxSYS_SCREEN_X, ?wxSYS_SCREEN_X),
    t(wxSYS_SCREEN_Y, ?wxSYS_SCREEN_Y),
    t(wxSYS_FRAMESIZE_X, ?wxSYS_FRAMESIZE_X),
    t(wxSYS_FRAMESIZE_Y, ?wxSYS_FRAMESIZE_Y),
    t(wxSYS_SMALLICON_X, ?wxSYS_SMALLICON_X),
    t(wxSYS_SMALLICON_Y, ?wxSYS_SMALLICON_Y),
    t(wxSYS_HSCROLL_Y, ?wxSYS_HSCROLL_Y),
    t(wxSYS_VSCROLL_X, ?wxSYS_VSCROLL_X),
    t(wxSYS_VSCROLL_ARROW_X, ?wxSYS_VSCROLL_ARROW_X),
    t(wxSYS_VSCROLL_ARROW_Y, ?wxSYS_VSCROLL_ARROW_Y),
    t(wxSYS_VTHUMB_Y, ?wxSYS_VTHUMB_Y),
    t(wxSYS_CAPTION_Y, ?wxSYS_CAPTION_Y),
    t(wxSYS_MENU_Y, ?wxSYS_MENU_Y),
    t(wxSYS_NETWORK_PRESENT, ?wxSYS_NETWORK_PRESENT),
    t(wxSYS_PENWINDOWS_PRESENT, ?wxSYS_PENWINDOWS_PRESENT),
    t(wxSYS_SHOW_SOUNDS, ?wxSYS_SHOW_SOUNDS),
    t(wxSYS_SWAP_BUTTONS, ?wxSYS_SWAP_BUTTONS),
    t(wxSYS_DCLICK_MSEC, ?wxSYS_DCLICK_MSEC),
    t(wxSYS_CARET_ON_MSEC, ?wxSYS_CARET_ON_MSEC),
    t(wxSYS_CARET_OFF_MSEC, ?wxSYS_CARET_OFF_MSEC),
    t(wxSYS_CARET_TIMEOUT_MSEC, ?wxSYS_CARET_TIMEOUT_MSEC),
    t(wxSYS_SCREEN_NONE, ?wxSYS_SCREEN_NONE),
    t(wxSYS_SCREEN_TINY, ?wxSYS_SCREEN_TINY),
    t(wxSYS_SCREEN_PDA, ?wxSYS_SCREEN_PDA),
    t(wxSYS_SCREEN_SMALL, ?wxSYS_SCREEN_SMALL),
    t(wxSYS_SCREEN_DESKTOP, ?wxSYS_SCREEN_DESKTOP),
    t(wxFLEX_GROWMODE_NONE, ?wxFLEX_GROWMODE_NONE),
    t(wxFLEX_GROWMODE_SPECIFIED, ?wxFLEX_GROWMODE_SPECIFIED),
    t(wxFLEX_GROWMODE_ALL, ?wxFLEX_GROWMODE_ALL),
    t(wxSL_LABELS, {ignore, "wxSL_LABELS"}),
    t(wxSL_VALUE_LABEL, ?wxSL_VALUE_LABEL),
    t(wxSL_MIN_MAX_LABELS, ?wxSL_MIN_MAX_LABELS),
    t(wxSL_INVERSE, ?wxSL_INVERSE),
    t(wxSL_SELRANGE, ?wxSL_SELRANGE),
    t(wxSL_BOTH, ?wxSL_BOTH),
    t(wxSL_BOTTOM, ?wxSL_BOTTOM),
    t(wxSL_RIGHT, ?wxSL_RIGHT),
    t(wxSL_TOP, ?wxSL_TOP),
    t(wxSL_LEFT, ?wxSL_LEFT),
    t(wxSL_AUTOTICKS, ?wxSL_AUTOTICKS),
    t(wxSL_TICKS, ?wxSL_TICKS),
    t(wxSL_VERTICAL, ?wxSL_VERTICAL),
    t(wxSL_HORIZONTAL, ?wxSL_HORIZONTAL),
    t(wxSPLASH_NO_TIMEOUT, ?wxSPLASH_NO_TIMEOUT),
    t(wxSPLASH_TIMEOUT, ?wxSPLASH_TIMEOUT),
    t(wxSPLASH_NO_CENTRE, ?wxSPLASH_NO_CENTRE),
    t(wxSPLASH_CENTRE_ON_SCREEN, ?wxSPLASH_CENTRE_ON_SCREEN),
    t(wxSPLASH_CENTRE_ON_PARENT, ?wxSPLASH_CENTRE_ON_PARENT),
    t(wxSPLIT_DRAG_NONE, ?wxSPLIT_DRAG_NONE),
    t(wxSPLIT_DRAG_DRAGGING, ?wxSPLIT_DRAG_DRAGGING),
    t(wxSPLIT_DRAG_LEFT_DOWN, ?wxSPLIT_DRAG_LEFT_DOWN),
    t(wxSP_3D, ?wxSP_3D),
    t(wxSP_BORDER, ?wxSP_BORDER),
    t(wxSP_NO_XP_THEME, ?wxSP_NO_XP_THEME),
    t(wxSP_3DBORDER, ?wxSP_3DBORDER),
    t(wxSP_3DSASH, ?wxSP_3DSASH),
    t(wxSP_LIVE_UPDATE, ?wxSP_LIVE_UPDATE),
    t(wxSP_PERMIT_UNSPLIT, ?wxSP_PERMIT_UNSPLIT),
    t(wxSP_NOSASH, ?wxSP_NOSASH),
    t(wxSP_THIN_SASH, ?wxSP_THIN_SASH),
    t(wxSP_NOBORDER, ?wxSP_NOBORDER),
    t(wxSPLIT_HORIZONTAL, ?wxSPLIT_HORIZONTAL),
    t(wxSPLIT_VERTICAL, ?wxSPLIT_VERTICAL),
    t(wxST_ELLIPSIZE_END, ?wxST_ELLIPSIZE_END),
    t(wxST_ELLIPSIZE_MIDDLE, ?wxST_ELLIPSIZE_MIDDLE),
    t(wxST_ELLIPSIZE_START, ?wxST_ELLIPSIZE_START),
    t(wxST_NO_AUTORESIZE, ?wxST_NO_AUTORESIZE),
    t(wxSB_SUNKEN, ?wxSB_SUNKEN),
    t(wxSB_RAISED, ?wxSB_RAISED),
    t(wxSB_FLAT, ?wxSB_FLAT),
    t(wxSB_NORMAL, ?wxSB_NORMAL),
    t(wxSTB_DEFAULT_STYLE, ?wxSTB_DEFAULT_STYLE),
    t(wxSTB_ELLIPSIZE_END, ?wxSTB_ELLIPSIZE_END),
    t(wxSTB_ELLIPSIZE_MIDDLE, ?wxSTB_ELLIPSIZE_MIDDLE),
    t(wxSTB_ELLIPSIZE_START, ?wxSTB_ELLIPSIZE_START),
    t(wxSTB_SHOW_TIPS, ?wxSTB_SHOW_TIPS),
    t(wxSTB_SIZEGRIP, ?wxSTB_SIZEGRIP),
    t(wxSTC_CMD_VCHOMEDISPLAYEXTEND, ?wxSTC_CMD_VCHOMEDISPLAYEXTEND),
    t(wxSTC_CMD_VCHOMEDISPLAY, ?wxSTC_CMD_VCHOMEDISPLAY),
    t(wxSTC_CMD_SCROLLTOEND, ?wxSTC_CMD_SCROLLTOEND),
    t(wxSTC_CMD_SCROLLTOSTART, ?wxSTC_CMD_SCROLLTOSTART),
    t(wxSTC_CMD_MOVESELECTEDLINESDOWN, ?wxSTC_CMD_MOVESELECTEDLINESDOWN),
    t(wxSTC_CMD_MOVESELECTEDLINESUP, ?wxSTC_CMD_MOVESELECTEDLINESUP),
    t(wxSTC_CMD_VERTICALCENTRECARET, ?wxSTC_CMD_VERTICALCENTRECARET),
    t(wxSTC_CMD_WORDRIGHTENDEXTEND, ?wxSTC_CMD_WORDRIGHTENDEXTEND),
    t(wxSTC_CMD_WORDRIGHTEND, ?wxSTC_CMD_WORDRIGHTEND),
    t(wxSTC_CMD_WORDLEFTENDEXTEND, ?wxSTC_CMD_WORDLEFTENDEXTEND),
    t(wxSTC_CMD_WORDLEFTEND, ?wxSTC_CMD_WORDLEFTEND),
    t(wxSTC_CMD_STUTTEREDPAGEDOWNEXTEND, ?wxSTC_CMD_STUTTEREDPAGEDOWNEXTEND),
    t(wxSTC_CMD_STUTTEREDPAGEDOWN, ?wxSTC_CMD_STUTTEREDPAGEDOWN),
    t(wxSTC_CMD_STUTTEREDPAGEUPEXTEND, ?wxSTC_CMD_STUTTEREDPAGEUPEXTEND),
    t(wxSTC_CMD_STUTTEREDPAGEUP, ?wxSTC_CMD_STUTTEREDPAGEUP),
    t(wxSTC_CMD_PAGEDOWNRECTEXTEND, ?wxSTC_CMD_PAGEDOWNRECTEXTEND),
    t(wxSTC_CMD_PAGEUPRECTEXTEND, ?wxSTC_CMD_PAGEUPRECTEXTEND),
    t(wxSTC_CMD_LINEENDRECTEXTEND, ?wxSTC_CMD_LINEENDRECTEXTEND),
    t(wxSTC_CMD_VCHOMERECTEXTEND, ?wxSTC_CMD_VCHOMERECTEXTEND),
    t(wxSTC_CMD_HOMERECTEXTEND, ?wxSTC_CMD_HOMERECTEXTEND),
    t(wxSTC_CMD_CHARRIGHTRECTEXTEND, ?wxSTC_CMD_CHARRIGHTRECTEXTEND),
    t(wxSTC_CMD_CHARLEFTRECTEXTEND, ?wxSTC_CMD_CHARLEFTRECTEXTEND),
    t(wxSTC_CMD_LINEUPRECTEXTEND, ?wxSTC_CMD_LINEUPRECTEXTEND),
    t(wxSTC_CMD_LINEDOWNRECTEXTEND, ?wxSTC_CMD_LINEDOWNRECTEXTEND),
    t(wxSTC_CMD_PARAUPEXTEND, ?wxSTC_CMD_PARAUPEXTEND),
    t(wxSTC_CMD_PARAUP, ?wxSTC_CMD_PARAUP),
    t(wxSTC_CMD_PARADOWNEXTEND, ?wxSTC_CMD_PARADOWNEXTEND),
    t(wxSTC_CMD_PARADOWN, ?wxSTC_CMD_PARADOWN),
    t(wxSTC_CMD_DELLINERIGHT, ?wxSTC_CMD_DELLINERIGHT),
    t(wxSTC_CMD_DELLINELEFT, ?wxSTC_CMD_DELLINELEFT),
    t(wxSTC_CMD_WORDPARTRIGHTEXTEND, ?wxSTC_CMD_WORDPARTRIGHTEXTEND),
    t(wxSTC_CMD_WORDPARTRIGHT, ?wxSTC_CMD_WORDPARTRIGHT),
    t(wxSTC_CMD_WORDPARTLEFTEXTEND, ?wxSTC_CMD_WORDPARTLEFTEXTEND),
    t(wxSTC_CMD_WORDPARTLEFT, ?wxSTC_CMD_WORDPARTLEFT),
    t(wxSTC_CMD_LINECOPY, ?wxSTC_CMD_LINECOPY),
    t(wxSTC_CMD_VCHOMEWRAPEXTEND, ?wxSTC_CMD_VCHOMEWRAPEXTEND),
    t(wxSTC_CMD_VCHOMEWRAP, ?wxSTC_CMD_VCHOMEWRAP),
    t(wxSTC_CMD_LINEENDWRAPEXTEND, ?wxSTC_CMD_LINEENDWRAPEXTEND),
    t(wxSTC_CMD_LINEENDWRAP, ?wxSTC_CMD_LINEENDWRAP),
    t(wxSTC_CMD_HOMEWRAPEXTEND, ?wxSTC_CMD_HOMEWRAPEXTEND),
    t(wxSTC_CMD_HOMEWRAP, ?wxSTC_CMD_HOMEWRAP),
    t(wxSTC_CMD_LINEENDDISPLAYEXTEND, ?wxSTC_CMD_LINEENDDISPLAYEXTEND),
    t(wxSTC_CMD_LINEENDDISPLAY, ?wxSTC_CMD_LINEENDDISPLAY),
    t(wxSTC_CMD_HOMEDISPLAYEXTEND, ?wxSTC_CMD_HOMEDISPLAYEXTEND),
    t(wxSTC_CMD_HOMEDISPLAY, ?wxSTC_CMD_HOMEDISPLAY),
    t(wxSTC_CMD_DELETEBACKNOTLINE, ?wxSTC_CMD_DELETEBACKNOTLINE),
    t(wxSTC_CMD_LINESCROLLUP, ?wxSTC_CMD_LINESCROLLUP),
    t(wxSTC_CMD_LINESCROLLDOWN, ?wxSTC_CMD_LINESCROLLDOWN),
    t(wxSTC_CMD_UPPERCASE, ?wxSTC_CMD_UPPERCASE),
    t(wxSTC_CMD_LOWERCASE, ?wxSTC_CMD_LOWERCASE),
    t(wxSTC_CMD_LINEDUPLICATE, ?wxSTC_CMD_LINEDUPLICATE),
    t(wxSTC_CMD_LINETRANSPOSE, ?wxSTC_CMD_LINETRANSPOSE),
    t(wxSTC_CMD_LINEDELETE, ?wxSTC_CMD_LINEDELETE),
    t(wxSTC_CMD_LINECUT, ?wxSTC_CMD_LINECUT),
    t(wxSTC_CMD_DELWORDRIGHTEND, ?wxSTC_CMD_DELWORDRIGHTEND),
    t(wxSTC_CMD_DELWORDRIGHT, ?wxSTC_CMD_DELWORDRIGHT),
    t(wxSTC_CMD_DELWORDLEFT, ?wxSTC_CMD_DELWORDLEFT),
    t(wxSTC_CMD_ZOOMOUT, ?wxSTC_CMD_ZOOMOUT),
    t(wxSTC_CMD_ZOOMIN, ?wxSTC_CMD_ZOOMIN),
    t(wxSTC_CMD_VCHOMEEXTEND, ?wxSTC_CMD_VCHOMEEXTEND),
    t(wxSTC_CMD_VCHOME, ?wxSTC_CMD_VCHOME),
    t(wxSTC_CMD_FORMFEED, ?wxSTC_CMD_FORMFEED),
    t(wxSTC_CMD_NEWLINE, ?wxSTC_CMD_NEWLINE),
    t(wxSTC_CMD_BACKTAB, ?wxSTC_CMD_BACKTAB),
    t(wxSTC_CMD_TAB, ?wxSTC_CMD_TAB),
    t(wxSTC_CMD_DELETEBACK, ?wxSTC_CMD_DELETEBACK),
    t(wxSTC_CMD_CANCEL, ?wxSTC_CMD_CANCEL),
    t(wxSTC_CMD_EDITTOGGLEOVERTYPE, ?wxSTC_CMD_EDITTOGGLEOVERTYPE),
    t(wxSTC_CMD_PAGEDOWNEXTEND, ?wxSTC_CMD_PAGEDOWNEXTEND),
    t(wxSTC_CMD_PAGEDOWN, ?wxSTC_CMD_PAGEDOWN),
    t(wxSTC_CMD_PAGEUPEXTEND, ?wxSTC_CMD_PAGEUPEXTEND),
    t(wxSTC_CMD_PAGEUP, ?wxSTC_CMD_PAGEUP),
    t(wxSTC_CMD_DOCUMENTENDEXTEND, ?wxSTC_CMD_DOCUMENTENDEXTEND),
    t(wxSTC_CMD_DOCUMENTEND, ?wxSTC_CMD_DOCUMENTEND),
    t(wxSTC_CMD_DOCUMENTSTARTEXTEND, ?wxSTC_CMD_DOCUMENTSTARTEXTEND),
    t(wxSTC_CMD_DOCUMENTSTART, ?wxSTC_CMD_DOCUMENTSTART),
    t(wxSTC_CMD_LINEENDEXTEND, ?wxSTC_CMD_LINEENDEXTEND),
    t(wxSTC_CMD_LINEEND, ?wxSTC_CMD_LINEEND),
    t(wxSTC_CMD_HOMEEXTEND, ?wxSTC_CMD_HOMEEXTEND),
    t(wxSTC_CMD_HOME, ?wxSTC_CMD_HOME),
    t(wxSTC_CMD_WORDRIGHTEXTEND, ?wxSTC_CMD_WORDRIGHTEXTEND),
    t(wxSTC_CMD_WORDRIGHT, ?wxSTC_CMD_WORDRIGHT),
    t(wxSTC_CMD_WORDLEFTEXTEND, ?wxSTC_CMD_WORDLEFTEXTEND),
    t(wxSTC_CMD_WORDLEFT, ?wxSTC_CMD_WORDLEFT),
    t(wxSTC_CMD_CHARRIGHTEXTEND, ?wxSTC_CMD_CHARRIGHTEXTEND),
    t(wxSTC_CMD_CHARRIGHT, ?wxSTC_CMD_CHARRIGHT),
    t(wxSTC_CMD_CHARLEFTEXTEND, ?wxSTC_CMD_CHARLEFTEXTEND),
    t(wxSTC_CMD_CHARLEFT, ?wxSTC_CMD_CHARLEFT),
    t(wxSTC_CMD_LINEUPEXTEND, ?wxSTC_CMD_LINEUPEXTEND),
    t(wxSTC_CMD_LINEUP, ?wxSTC_CMD_LINEUP),
    t(wxSTC_CMD_LINEDOWNEXTEND, ?wxSTC_CMD_LINEDOWNEXTEND),
    t(wxSTC_CMD_LINEDOWN, ?wxSTC_CMD_LINEDOWN),
    t(wxSTC_CMD_CLEAR, ?wxSTC_CMD_CLEAR),
    t(wxSTC_CMD_PASTE, ?wxSTC_CMD_PASTE),
    t(wxSTC_CMD_COPY, ?wxSTC_CMD_COPY),
    t(wxSTC_CMD_CUT, ?wxSTC_CMD_CUT),
    t(wxSTC_CMD_UNDO, ?wxSTC_CMD_UNDO),
    t(wxSTC_CMD_SELECTALL, ?wxSTC_CMD_SELECTALL),
    t(wxSTC_CMD_REDO, ?wxSTC_CMD_REDO),
    t(wxSTC_INDICS_MASK, ?wxSTC_INDICS_MASK),
    t(wxSTC_INDIC2_MASK, ?wxSTC_INDIC2_MASK),
    t(wxSTC_INDIC1_MASK, ?wxSTC_INDIC1_MASK),
    t(wxSTC_INDIC0_MASK, ?wxSTC_INDIC0_MASK),
    t(wxSTC_EDI_BADSEGMENT, ?wxSTC_EDI_BADSEGMENT),
    t(wxSTC_EDI_UNH, ?wxSTC_EDI_UNH),
    t(wxSTC_EDI_UNA, ?wxSTC_EDI_UNA),
    t(wxSTC_EDI_SEP_RELEASE, ?wxSTC_EDI_SEP_RELEASE),
    t(wxSTC_EDI_SEP_COMPOSITE, ?wxSTC_EDI_SEP_COMPOSITE),
    t(wxSTC_EDI_SEP_ELEMENT, ?wxSTC_EDI_SEP_ELEMENT),
    t(wxSTC_EDI_SEGMENTEND, ?wxSTC_EDI_SEGMENTEND),
    t(wxSTC_EDI_SEGMENTSTART, ?wxSTC_EDI_SEGMENTSTART),
    t(wxSTC_EDI_DEFAULT, ?wxSTC_EDI_DEFAULT),
    t(wxSTC_JSON_ERROR, ?wxSTC_JSON_ERROR),
    t(wxSTC_JSON_LDKEYWORD, ?wxSTC_JSON_LDKEYWORD),
    t(wxSTC_JSON_KEYWORD, ?wxSTC_JSON_KEYWORD),
    t(wxSTC_JSON_COMPACTIRI, ?wxSTC_JSON_COMPACTIRI),
    t(wxSTC_JSON_URI, ?wxSTC_JSON_URI),
    t(wxSTC_JSON_OPERATOR, ?wxSTC_JSON_OPERATOR),
    t(wxSTC_JSON_BLOCKCOMMENT, ?wxSTC_JSON_BLOCKCOMMENT),
    t(wxSTC_JSON_LINECOMMENT, ?wxSTC_JSON_LINECOMMENT),
    t(wxSTC_JSON_ESCAPESEQUENCE, ?wxSTC_JSON_ESCAPESEQUENCE),
    t(wxSTC_JSON_PROPERTYNAME, ?wxSTC_JSON_PROPERTYNAME),
    t(wxSTC_JSON_STRINGEOL, ?wxSTC_JSON_STRINGEOL),
    t(wxSTC_JSON_STRING, ?wxSTC_JSON_STRING),
    t(wxSTC_JSON_NUMBER, ?wxSTC_JSON_NUMBER),
    t(wxSTC_JSON_DEFAULT, ?wxSTC_JSON_DEFAULT),
    t(wxSTC_HEX_GARBAGE, ?wxSTC_HEX_GARBAGE),
    t(wxSTC_HEX_CHECKSUM_WRONG, ?wxSTC_HEX_CHECKSUM_WRONG),
    t(wxSTC_HEX_CHECKSUM, ?wxSTC_HEX_CHECKSUM),
    t(wxSTC_HEX_DATA_EMPTY, ?wxSTC_HEX_DATA_EMPTY),
    t(wxSTC_HEX_DATA_UNKNOWN, ?wxSTC_HEX_DATA_UNKNOWN),
    t(wxSTC_HEX_DATA_EVEN, ?wxSTC_HEX_DATA_EVEN),
    t(wxSTC_HEX_DATA_ODD, ?wxSTC_HEX_DATA_ODD),
    t(wxSTC_HEX_EXTENDEDADDRESS, ?wxSTC_HEX_EXTENDEDADDRESS),
    t(wxSTC_HEX_ADDRESSFIELD_UNKNOWN, ?wxSTC_HEX_ADDRESSFIELD_UNKNOWN),
    t(wxSTC_HEX_STARTADDRESS, ?wxSTC_HEX_STARTADDRESS),
    t(wxSTC_HEX_RECCOUNT, ?wxSTC_HEX_RECCOUNT),
    t(wxSTC_HEX_DATAADDRESS, ?wxSTC_HEX_DATAADDRESS),
    t(wxSTC_HEX_NOADDRESS, ?wxSTC_HEX_NOADDRESS),
    t(wxSTC_HEX_BYTECOUNT_WRONG, ?wxSTC_HEX_BYTECOUNT_WRONG),
    t(wxSTC_HEX_BYTECOUNT, ?wxSTC_HEX_BYTECOUNT),
    t(wxSTC_HEX_RECTYPE_UNKNOWN, ?wxSTC_HEX_RECTYPE_UNKNOWN),
    t(wxSTC_HEX_RECTYPE, ?wxSTC_HEX_RECTYPE),
    t(wxSTC_HEX_RECSTART, ?wxSTC_HEX_RECSTART),
    t(wxSTC_HEX_DEFAULT, ?wxSTC_HEX_DEFAULT),
    t(wxSTC_BIBTEX_COMMENT, ?wxSTC_BIBTEX_COMMENT),
    t(wxSTC_BIBTEX_VALUE, ?wxSTC_BIBTEX_VALUE),
    t(wxSTC_BIBTEX_PARAMETER, ?wxSTC_BIBTEX_PARAMETER),
    t(wxSTC_BIBTEX_KEY, ?wxSTC_BIBTEX_KEY),
    t(wxSTC_BIBTEX_UNKNOWN_ENTRY, ?wxSTC_BIBTEX_UNKNOWN_ENTRY),
    t(wxSTC_BIBTEX_ENTRY, ?wxSTC_BIBTEX_ENTRY),
    t(wxSTC_BIBTEX_DEFAULT, ?wxSTC_BIBTEX_DEFAULT),
    t(wxSTC_REG_OPERATOR, ?wxSTC_REG_OPERATOR),
    t(wxSTC_REG_PARAMETER, ?wxSTC_REG_PARAMETER),
    t(wxSTC_REG_STRING_GUID, ?wxSTC_REG_STRING_GUID),
    t(wxSTC_REG_KEYPATH_GUID, ?wxSTC_REG_KEYPATH_GUID),
    t(wxSTC_REG_ESCAPED, ?wxSTC_REG_ESCAPED),
    t(wxSTC_REG_DELETEDKEY, ?wxSTC_REG_DELETEDKEY),
    t(wxSTC_REG_ADDEDKEY, ?wxSTC_REG_ADDEDKEY),
    t(wxSTC_REG_VALUETYPE, ?wxSTC_REG_VALUETYPE),
    t(wxSTC_REG_HEXDIGIT, ?wxSTC_REG_HEXDIGIT),
    t(wxSTC_REG_STRING, ?wxSTC_REG_STRING),
    t(wxSTC_REG_VALUENAME, ?wxSTC_REG_VALUENAME),
    t(wxSTC_REG_COMMENT, ?wxSTC_REG_COMMENT),
    t(wxSTC_REG_DEFAULT, ?wxSTC_REG_DEFAULT),
    t(wxSTC_DMIS_LABEL, ?wxSTC_DMIS_LABEL),
    t(wxSTC_DMIS_UNSUPPORTED_MINOR, ?wxSTC_DMIS_UNSUPPORTED_MINOR),
    t(wxSTC_DMIS_UNSUPPORTED_MAJOR, ?wxSTC_DMIS_UNSUPPORTED_MAJOR),
    t(wxSTC_DMIS_MINORWORD, ?wxSTC_DMIS_MINORWORD),
    t(wxSTC_DMIS_MAJORWORD, ?wxSTC_DMIS_MAJORWORD),
    t(wxSTC_DMIS_KEYWORD, ?wxSTC_DMIS_KEYWORD),
    t(wxSTC_DMIS_NUMBER, ?wxSTC_DMIS_NUMBER),
    t(wxSTC_DMIS_STRING, ?wxSTC_DMIS_STRING),
    t(wxSTC_DMIS_COMMENT, ?wxSTC_DMIS_COMMENT),
    t(wxSTC_DMIS_DEFAULT, ?wxSTC_DMIS_DEFAULT),
    t(wxSTC_DMAP_WORD3, ?wxSTC_DMAP_WORD3),
    t(wxSTC_DMAP_WORD2, ?wxSTC_DMAP_WORD2),
    t(wxSTC_DMAP_WORD, ?wxSTC_DMAP_WORD),
    t(wxSTC_DMAP_IDENTIFIER, ?wxSTC_DMAP_IDENTIFIER),
    t(wxSTC_DMAP_OPERATOR, ?wxSTC_DMAP_OPERATOR),
    t(wxSTC_DMAP_STRINGEOL, ?wxSTC_DMAP_STRINGEOL),
    t(wxSTC_DMAP_STRING2, ?wxSTC_DMAP_STRING2),
    t(wxSTC_DMAP_STRING1, ?wxSTC_DMAP_STRING1),
    t(wxSTC_DMAP_NUMBER, ?wxSTC_DMAP_NUMBER),
    t(wxSTC_DMAP_COMMENT, ?wxSTC_DMAP_COMMENT),
    t(wxSTC_DMAP_DEFAULT, ?wxSTC_DMAP_DEFAULT),
    t(wxSTC_RUST_BYTECHARACTER, ?wxSTC_RUST_BYTECHARACTER),
    t(wxSTC_RUST_BYTESTRINGR, ?wxSTC_RUST_BYTESTRINGR),
    t(wxSTC_RUST_BYTESTRING, ?wxSTC_RUST_BYTESTRING),
    t(wxSTC_RUST_LEXERROR, ?wxSTC_RUST_LEXERROR),
    t(wxSTC_RUST_MACRO, ?wxSTC_RUST_MACRO),
    t(wxSTC_RUST_LIFETIME, ?wxSTC_RUST_LIFETIME),
    t(wxSTC_RUST_IDENTIFIER, ?wxSTC_RUST_IDENTIFIER),
    t(wxSTC_RUST_OPERATOR, ?wxSTC_RUST_OPERATOR),
    t(wxSTC_RUST_CHARACTER, ?wxSTC_RUST_CHARACTER),
    t(wxSTC_RUST_STRINGR, ?wxSTC_RUST_STRINGR),
    t(wxSTC_RUST_STRING, ?wxSTC_RUST_STRING),
    t(wxSTC_RUST_WORD7, ?wxSTC_RUST_WORD7),
    t(wxSTC_RUST_WORD6, ?wxSTC_RUST_WORD6),
    t(wxSTC_RUST_WORD5, ?wxSTC_RUST_WORD5),
    t(wxSTC_RUST_WORD4, ?wxSTC_RUST_WORD4),
    t(wxSTC_RUST_WORD3, ?wxSTC_RUST_WORD3),
    t(wxSTC_RUST_WORD2, ?wxSTC_RUST_WORD2),
    t(wxSTC_RUST_WORD, ?wxSTC_RUST_WORD),
    t(wxSTC_RUST_NUMBER, ?wxSTC_RUST_NUMBER),
    t(wxSTC_RUST_COMMENTLINEDOC, ?wxSTC_RUST_COMMENTLINEDOC),
    t(wxSTC_RUST_COMMENTBLOCKDOC, ?wxSTC_RUST_COMMENTBLOCKDOC),
    t(wxSTC_RUST_COMMENTLINE, ?wxSTC_RUST_COMMENTLINE),
    t(wxSTC_RUST_COMMENTBLOCK, ?wxSTC_RUST_COMMENTBLOCK),
    t(wxSTC_RUST_DEFAULT, ?wxSTC_RUST_DEFAULT),
    t(wxSTC_KVIRC_STRING_VARIABLE, ?wxSTC_KVIRC_STRING_VARIABLE),
    t(wxSTC_KVIRC_STRING_FUNCTION, ?wxSTC_KVIRC_STRING_FUNCTION),
    t(wxSTC_KVIRC_OPERATOR, ?wxSTC_KVIRC_OPERATOR),
    t(wxSTC_KVIRC_NUMBER, ?wxSTC_KVIRC_NUMBER),
    t(wxSTC_KVIRC_VARIABLE, ?wxSTC_KVIRC_VARIABLE),
    t(wxSTC_KVIRC_FUNCTION, ?wxSTC_KVIRC_FUNCTION),
    t(wxSTC_KVIRC_FUNCTION_KEYWORD, ?wxSTC_KVIRC_FUNCTION_KEYWORD),
    t(wxSTC_KVIRC_KEYWORD, ?wxSTC_KVIRC_KEYWORD),
    t(wxSTC_KVIRC_WORD, ?wxSTC_KVIRC_WORD),
    t(wxSTC_KVIRC_STRING, ?wxSTC_KVIRC_STRING),
    t(wxSTC_KVIRC_COMMENTBLOCK, ?wxSTC_KVIRC_COMMENTBLOCK),
    t(wxSTC_KVIRC_COMMENT, ?wxSTC_KVIRC_COMMENT),
    t(wxSTC_KVIRC_DEFAULT, ?wxSTC_KVIRC_DEFAULT),
    t(wxSTC_STTXT_PRAGMAS, ?wxSTC_STTXT_PRAGMAS),
    t(wxSTC_STTXT_VARS, ?wxSTC_STTXT_VARS),
    t(wxSTC_STTXT_DATETIME, ?wxSTC_STTXT_DATETIME),
    t(wxSTC_STTXT_IDENTIFIER, ?wxSTC_STTXT_IDENTIFIER),
    t(wxSTC_STTXT_STRINGEOL, ?wxSTC_STTXT_STRINGEOL),
    t(wxSTC_STTXT_STRING2, ?wxSTC_STTXT_STRING2),
    t(wxSTC_STTXT_STRING1, ?wxSTC_STTXT_STRING1),
    t(wxSTC_STTXT_CHARACTER, ?wxSTC_STTXT_CHARACTER),
    t(wxSTC_STTXT_OPERATOR, ?wxSTC_STTXT_OPERATOR),
    t(wxSTC_STTXT_PRAGMA, ?wxSTC_STTXT_PRAGMA),
    t(wxSTC_STTXT_HEXNUMBER, ?wxSTC_STTXT_HEXNUMBER),
    t(wxSTC_STTXT_NUMBER, ?wxSTC_STTXT_NUMBER),
    t(wxSTC_STTXT_FB, ?wxSTC_STTXT_FB),
    t(wxSTC_STTXT_FUNCTION, ?wxSTC_STTXT_FUNCTION),
    t(wxSTC_STTXT_TYPE, ?wxSTC_STTXT_TYPE),
    t(wxSTC_STTXT_KEYWORD, ?wxSTC_STTXT_KEYWORD),
    t(wxSTC_STTXT_COMMENTLINE, ?wxSTC_STTXT_COMMENTLINE),
    t(wxSTC_STTXT_COMMENT, ?wxSTC_STTXT_COMMENT),
    t(wxSTC_STTXT_DEFAULT, ?wxSTC_STTXT_DEFAULT),
    t(wxSTC_VISUALPROLOG_STRING_VERBATIM_EOL, ?wxSTC_VISUALPROLOG_STRING_VERBATIM_EOL),
    t(wxSTC_VISUALPROLOG_STRING_VERBATIM_SPECIAL, ?wxSTC_VISUALPROLOG_STRING_VERBATIM_SPECIAL),
    t(wxSTC_VISUALPROLOG_STRING_VERBATIM, ?wxSTC_VISUALPROLOG_STRING_VERBATIM),
    t(wxSTC_VISUALPROLOG_STRING_EOL_OPEN, ?wxSTC_VISUALPROLOG_STRING_EOL_OPEN),
    t(wxSTC_VISUALPROLOG_STRING_ESCAPE_ERROR, ?wxSTC_VISUALPROLOG_STRING_ESCAPE_ERROR),
    t(wxSTC_VISUALPROLOG_STRING_ESCAPE, ?wxSTC_VISUALPROLOG_STRING_ESCAPE),
    t(wxSTC_VISUALPROLOG_STRING, ?wxSTC_VISUALPROLOG_STRING),
    t(wxSTC_VISUALPROLOG_CHARACTER_ESCAPE_ERROR, ?wxSTC_VISUALPROLOG_CHARACTER_ESCAPE_ERROR),
    t(wxSTC_VISUALPROLOG_CHARACTER_TOO_MANY, ?wxSTC_VISUALPROLOG_CHARACTER_TOO_MANY),
    t(wxSTC_VISUALPROLOG_CHARACTER, ?wxSTC_VISUALPROLOG_CHARACTER),
    t(wxSTC_VISUALPROLOG_OPERATOR, ?wxSTC_VISUALPROLOG_OPERATOR),
    t(wxSTC_VISUALPROLOG_NUMBER, ?wxSTC_VISUALPROLOG_NUMBER),
    t(wxSTC_VISUALPROLOG_ANONYMOUS, ?wxSTC_VISUALPROLOG_ANONYMOUS),
    t(wxSTC_VISUALPROLOG_VARIABLE, ?wxSTC_VISUALPROLOG_VARIABLE),
    t(wxSTC_VISUALPROLOG_IDENTIFIER, ?wxSTC_VISUALPROLOG_IDENTIFIER),
    t(wxSTC_VISUALPROLOG_COMMENT_KEY_ERROR, ?wxSTC_VISUALPROLOG_COMMENT_KEY_ERROR),
    t(wxSTC_VISUALPROLOG_COMMENT_KEY, ?wxSTC_VISUALPROLOG_COMMENT_KEY),
    t(wxSTC_VISUALPROLOG_COMMENT_LINE, ?wxSTC_VISUALPROLOG_COMMENT_LINE),
    t(wxSTC_VISUALPROLOG_COMMENT_BLOCK, ?wxSTC_VISUALPROLOG_COMMENT_BLOCK),
    t(wxSTC_VISUALPROLOG_KEY_DIRECTIVE, ?wxSTC_VISUALPROLOG_KEY_DIRECTIVE),
    t(wxSTC_VISUALPROLOG_KEY_MINOR, ?wxSTC_VISUALPROLOG_KEY_MINOR),
    t(wxSTC_VISUALPROLOG_KEY_MAJOR, ?wxSTC_VISUALPROLOG_KEY_MAJOR),
    t(wxSTC_VISUALPROLOG_DEFAULT, ?wxSTC_VISUALPROLOG_DEFAULT),
    t(wxSTC_OSCRIPT_METHOD, ?wxSTC_OSCRIPT_METHOD),
    t(wxSTC_OSCRIPT_PROPERTY, ?wxSTC_OSCRIPT_PROPERTY),
    t(wxSTC_OSCRIPT_OBJECT, ?wxSTC_OSCRIPT_OBJECT),
    t(wxSTC_OSCRIPT_FUNCTION, ?wxSTC_OSCRIPT_FUNCTION),
    t(wxSTC_OSCRIPT_TYPE, ?wxSTC_OSCRIPT_TYPE),
    t(wxSTC_OSCRIPT_LABEL, ?wxSTC_OSCRIPT_LABEL),
    t(wxSTC_OSCRIPT_OPERATOR, ?wxSTC_OSCRIPT_OPERATOR),
    t(wxSTC_OSCRIPT_KEYWORD, ?wxSTC_OSCRIPT_KEYWORD),
    t(wxSTC_OSCRIPT_GLOBAL, ?wxSTC_OSCRIPT_GLOBAL),
    t(wxSTC_OSCRIPT_IDENTIFIER, ?wxSTC_OSCRIPT_IDENTIFIER),
    t(wxSTC_OSCRIPT_CONSTANT, ?wxSTC_OSCRIPT_CONSTANT),
    t(wxSTC_OSCRIPT_DOUBLEQUOTE_STRING, ?wxSTC_OSCRIPT_DOUBLEQUOTE_STRING),
    t(wxSTC_OSCRIPT_SINGLEQUOTE_STRING, ?wxSTC_OSCRIPT_SINGLEQUOTE_STRING),
    t(wxSTC_OSCRIPT_NUMBER, ?wxSTC_OSCRIPT_NUMBER),
    t(wxSTC_OSCRIPT_PREPROCESSOR, ?wxSTC_OSCRIPT_PREPROCESSOR),
    t(wxSTC_OSCRIPT_DOC_COMMENT, ?wxSTC_OSCRIPT_DOC_COMMENT),
    t(wxSTC_OSCRIPT_BLOCK_COMMENT, ?wxSTC_OSCRIPT_BLOCK_COMMENT),
    t(wxSTC_OSCRIPT_LINE_COMMENT, ?wxSTC_OSCRIPT_LINE_COMMENT),
    t(wxSTC_OSCRIPT_DEFAULT, ?wxSTC_OSCRIPT_DEFAULT),
    t(wxSTC_ECL_MOVED, ?wxSTC_ECL_MOVED),
    t(wxSTC_ECL_CHANGED, ?wxSTC_ECL_CHANGED),
    t(wxSTC_ECL_DELETED, ?wxSTC_ECL_DELETED),
    t(wxSTC_ECL_ADDED, ?wxSTC_ECL_ADDED),
    t(wxSTC_ECL_COMMENTDOC, ?wxSTC_ECL_COMMENTDOC),
    t(wxSTC_ECL_WORD5, ?wxSTC_ECL_WORD5),
    t(wxSTC_ECL_WORD4, ?wxSTC_ECL_WORD4),
    t(wxSTC_ECL_WORD3, ?wxSTC_ECL_WORD3),
    t(wxSTC_ECL_WORD2, ?wxSTC_ECL_WORD2),
    t(wxSTC_ECL_COMMENTDOCKEYWORDERROR, ?wxSTC_ECL_COMMENTDOCKEYWORDERROR),
    t(wxSTC_ECL_COMMENTDOCKEYWORD, ?wxSTC_ECL_COMMENTDOCKEYWORD),
    t(wxSTC_ECL_WORD1, ?wxSTC_ECL_WORD1),
    t(wxSTC_ECL_COMMENTLINEDOC, ?wxSTC_ECL_COMMENTLINEDOC),
    t(wxSTC_ECL_REGEX, ?wxSTC_ECL_REGEX),
    t(wxSTC_ECL_VERBATIM, ?wxSTC_ECL_VERBATIM),
    t(wxSTC_ECL_STRINGEOL, ?wxSTC_ECL_STRINGEOL),
    t(wxSTC_ECL_IDENTIFIER, ?wxSTC_ECL_IDENTIFIER),
    t(wxSTC_ECL_UNKNOWN, ?wxSTC_ECL_UNKNOWN),
    t(wxSTC_ECL_PREPROCESSOR, ?wxSTC_ECL_PREPROCESSOR),
    t(wxSTC_ECL_UUID, ?wxSTC_ECL_UUID),
    t(wxSTC_ECL_CHARACTER, ?wxSTC_ECL_CHARACTER),
    t(wxSTC_ECL_OPERATOR, ?wxSTC_ECL_OPERATOR),
    t(wxSTC_ECL_WORD0, ?wxSTC_ECL_WORD0),
    t(wxSTC_ECL_STRING, ?wxSTC_ECL_STRING),
    t(wxSTC_ECL_NUMBER, ?wxSTC_ECL_NUMBER),
    t(wxSTC_ECL_COMMENTLINE, ?wxSTC_ECL_COMMENTLINE),
    t(wxSTC_ECL_COMMENT, ?wxSTC_ECL_COMMENT),
    t(wxSTC_ECL_DEFAULT, ?wxSTC_ECL_DEFAULT),
    t(wxSTC_AVS_USERDFN, ?wxSTC_AVS_USERDFN),
    t(wxSTC_AVS_CLIPPROP, ?wxSTC_AVS_CLIPPROP),
    t(wxSTC_AVS_FUNCTION, ?wxSTC_AVS_FUNCTION),
    t(wxSTC_AVS_PLUGIN, ?wxSTC_AVS_PLUGIN),
    t(wxSTC_AVS_FILTER, ?wxSTC_AVS_FILTER),
    t(wxSTC_AVS_KEYWORD, ?wxSTC_AVS_KEYWORD),
    t(wxSTC_AVS_TRIPLESTRING, ?wxSTC_AVS_TRIPLESTRING),
    t(wxSTC_AVS_STRING, ?wxSTC_AVS_STRING),
    t(wxSTC_AVS_IDENTIFIER, ?wxSTC_AVS_IDENTIFIER),
    t(wxSTC_AVS_OPERATOR, ?wxSTC_AVS_OPERATOR),
    t(wxSTC_AVS_NUMBER, ?wxSTC_AVS_NUMBER),
    t(wxSTC_AVS_COMMENTLINE, ?wxSTC_AVS_COMMENTLINE),
    t(wxSTC_AVS_COMMENTBLOCKN, ?wxSTC_AVS_COMMENTBLOCKN),
    t(wxSTC_AVS_COMMENTBLOCK, ?wxSTC_AVS_COMMENTBLOCK),
    t(wxSTC_AVS_DEFAULT, ?wxSTC_AVS_DEFAULT),
    t(wxSTC_COFFEESCRIPT_INSTANCEPROPERTY, ?wxSTC_COFFEESCRIPT_INSTANCEPROPERTY),
    t(wxSTC_COFFEESCRIPT_VERBOSE_REGEX_COMMENT, ?wxSTC_COFFEESCRIPT_VERBOSE_REGEX_COMMENT),
    t(wxSTC_COFFEESCRIPT_VERBOSE_REGEX, ?wxSTC_COFFEESCRIPT_VERBOSE_REGEX),
    t(wxSTC_COFFEESCRIPT_COMMENTBLOCK, ?wxSTC_COFFEESCRIPT_COMMENTBLOCK),
    t(wxSTC_COFFEESCRIPT_TRIPLEVERBATIM, ?wxSTC_COFFEESCRIPT_TRIPLEVERBATIM),
    t(wxSTC_COFFEESCRIPT_STRINGRAW, ?wxSTC_COFFEESCRIPT_STRINGRAW),
    t(wxSTC_COFFEESCRIPT_GLOBALCLASS, ?wxSTC_COFFEESCRIPT_GLOBALCLASS),
    t(wxSTC_COFFEESCRIPT_COMMENTDOCKEYWORDERROR, ?wxSTC_COFFEESCRIPT_COMMENTDOCKEYWORDERROR),
    t(wxSTC_COFFEESCRIPT_COMMENTDOCKEYWORD, ?wxSTC_COFFEESCRIPT_COMMENTDOCKEYWORD),
    t(wxSTC_COFFEESCRIPT_WORD2, ?wxSTC_COFFEESCRIPT_WORD2),
    t(wxSTC_COFFEESCRIPT_COMMENTLINEDOC, ?wxSTC_COFFEESCRIPT_COMMENTLINEDOC),
    t(wxSTC_COFFEESCRIPT_REGEX, ?wxSTC_COFFEESCRIPT_REGEX),
    t(wxSTC_COFFEESCRIPT_VERBATIM, ?wxSTC_COFFEESCRIPT_VERBATIM),
    t(wxSTC_COFFEESCRIPT_STRINGEOL, ?wxSTC_COFFEESCRIPT_STRINGEOL),
    t(wxSTC_COFFEESCRIPT_IDENTIFIER, ?wxSTC_COFFEESCRIPT_IDENTIFIER),
    t(wxSTC_COFFEESCRIPT_OPERATOR, ?wxSTC_COFFEESCRIPT_OPERATOR),
    t(wxSTC_COFFEESCRIPT_PREPROCESSOR, ?wxSTC_COFFEESCRIPT_PREPROCESSOR),
    t(wxSTC_COFFEESCRIPT_UUID, ?wxSTC_COFFEESCRIPT_UUID),
    t(wxSTC_COFFEESCRIPT_CHARACTER, ?wxSTC_COFFEESCRIPT_CHARACTER),
    t(wxSTC_COFFEESCRIPT_STRING, ?wxSTC_COFFEESCRIPT_STRING),
    t(wxSTC_COFFEESCRIPT_WORD, ?wxSTC_COFFEESCRIPT_WORD),
    t(wxSTC_COFFEESCRIPT_NUMBER, ?wxSTC_COFFEESCRIPT_NUMBER),
    t(wxSTC_COFFEESCRIPT_COMMENTDOC, ?wxSTC_COFFEESCRIPT_COMMENTDOC),
    t(wxSTC_COFFEESCRIPT_COMMENTLINE, ?wxSTC_COFFEESCRIPT_COMMENTLINE),
    t(wxSTC_COFFEESCRIPT_COMMENT, ?wxSTC_COFFEESCRIPT_COMMENT),
    t(wxSTC_COFFEESCRIPT_DEFAULT, ?wxSTC_COFFEESCRIPT_DEFAULT),
    t(wxSTC_MODULA_BADSTR, ?wxSTC_MODULA_BADSTR),
    t(wxSTC_MODULA_OPERATOR, ?wxSTC_MODULA_OPERATOR),
    t(wxSTC_MODULA_PRGKEY, ?wxSTC_MODULA_PRGKEY),
    t(wxSTC_MODULA_PRAGMA, ?wxSTC_MODULA_PRAGMA),
    t(wxSTC_MODULA_PROC, ?wxSTC_MODULA_PROC),
    t(wxSTC_MODULA_CHARSPEC, ?wxSTC_MODULA_CHARSPEC),
    t(wxSTC_MODULA_CHAR, ?wxSTC_MODULA_CHAR),
    t(wxSTC_MODULA_STRSPEC, ?wxSTC_MODULA_STRSPEC),
    t(wxSTC_MODULA_STRING, ?wxSTC_MODULA_STRING),
    t(wxSTC_MODULA_FLOAT, ?wxSTC_MODULA_FLOAT),
    t(wxSTC_MODULA_BASENUM, ?wxSTC_MODULA_BASENUM),
    t(wxSTC_MODULA_NUMBER, ?wxSTC_MODULA_NUMBER),
    t(wxSTC_MODULA_RESERVED, ?wxSTC_MODULA_RESERVED),
    t(wxSTC_MODULA_KEYWORD, ?wxSTC_MODULA_KEYWORD),
    t(wxSTC_MODULA_DOXYKEY, ?wxSTC_MODULA_DOXYKEY),
    t(wxSTC_MODULA_DOXYCOMM, ?wxSTC_MODULA_DOXYCOMM),
    t(wxSTC_MODULA_COMMENT, ?wxSTC_MODULA_COMMENT),
    t(wxSTC_MODULA_DEFAULT, ?wxSTC_MODULA_DEFAULT),
    t(wxSTC_A68K_COMMENT_DOXYGEN, ?wxSTC_A68K_COMMENT_DOXYGEN),
    t(wxSTC_A68K_COMMENT_SPECIAL, ?wxSTC_A68K_COMMENT_SPECIAL),
    t(wxSTC_A68K_COMMENT_WORD, ?wxSTC_A68K_COMMENT_WORD),
    t(wxSTC_A68K_MACRO_DECLARATION, ?wxSTC_A68K_MACRO_DECLARATION),
    t(wxSTC_A68K_IDENTIFIER, ?wxSTC_A68K_IDENTIFIER),
    t(wxSTC_A68K_STRING2, ?wxSTC_A68K_STRING2),
    t(wxSTC_A68K_LABEL, ?wxSTC_A68K_LABEL),
    t(wxSTC_A68K_MACRO_ARG, ?wxSTC_A68K_MACRO_ARG),
    t(wxSTC_A68K_DIRECTIVE, ?wxSTC_A68K_DIRECTIVE),
    t(wxSTC_A68K_REGISTER, ?wxSTC_A68K_REGISTER),
    t(wxSTC_A68K_EXTINSTRUCTION, ?wxSTC_A68K_EXTINSTRUCTION),
    t(wxSTC_A68K_CPUINSTRUCTION, ?wxSTC_A68K_CPUINSTRUCTION),
    t(wxSTC_A68K_OPERATOR, ?wxSTC_A68K_OPERATOR),
    t(wxSTC_A68K_STRING1, ?wxSTC_A68K_STRING1),
    t(wxSTC_A68K_NUMBER_HEX, ?wxSTC_A68K_NUMBER_HEX),
    t(wxSTC_A68K_NUMBER_BIN, ?wxSTC_A68K_NUMBER_BIN),
    t(wxSTC_A68K_NUMBER_DEC, ?wxSTC_A68K_NUMBER_DEC),
    t(wxSTC_A68K_COMMENT, ?wxSTC_A68K_COMMENT),
    t(wxSTC_A68K_DEFAULT, ?wxSTC_A68K_DEFAULT),
    t(wxSTC_TXT2TAGS_POSTPROC, ?wxSTC_TXT2TAGS_POSTPROC),
    t(wxSTC_TXT2TAGS_PREPROC, ?wxSTC_TXT2TAGS_PREPROC),
    t(wxSTC_TXT2TAGS_OPTION, ?wxSTC_TXT2TAGS_OPTION),
    t(wxSTC_TXT2TAGS_COMMENT, ?wxSTC_TXT2TAGS_COMMENT),
    t(wxSTC_TXT2TAGS_CODEBK, ?wxSTC_TXT2TAGS_CODEBK),
    t(wxSTC_TXT2TAGS_CODE2, ?wxSTC_TXT2TAGS_CODE2),
    t(wxSTC_TXT2TAGS_CODE, ?wxSTC_TXT2TAGS_CODE),
    t(wxSTC_TXT2TAGS_LINK, ?wxSTC_TXT2TAGS_LINK),
    t(wxSTC_TXT2TAGS_HRULE, ?wxSTC_TXT2TAGS_HRULE),
    t(wxSTC_TXT2TAGS_STRIKEOUT, ?wxSTC_TXT2TAGS_STRIKEOUT),
    t(wxSTC_TXT2TAGS_BLOCKQUOTE, ?wxSTC_TXT2TAGS_BLOCKQUOTE),
    t(wxSTC_TXT2TAGS_OLIST_ITEM, ?wxSTC_TXT2TAGS_OLIST_ITEM),
    t(wxSTC_TXT2TAGS_ULIST_ITEM, ?wxSTC_TXT2TAGS_ULIST_ITEM),
    t(wxSTC_TXT2TAGS_PRECHAR, ?wxSTC_TXT2TAGS_PRECHAR),
    t(wxSTC_TXT2TAGS_HEADER6, ?wxSTC_TXT2TAGS_HEADER6),
    t(wxSTC_TXT2TAGS_HEADER5, ?wxSTC_TXT2TAGS_HEADER5),
    t(wxSTC_TXT2TAGS_HEADER4, ?wxSTC_TXT2TAGS_HEADER4),
    t(wxSTC_TXT2TAGS_HEADER3, ?wxSTC_TXT2TAGS_HEADER3),
    t(wxSTC_TXT2TAGS_HEADER2, ?wxSTC_TXT2TAGS_HEADER2),
    t(wxSTC_TXT2TAGS_HEADER1, ?wxSTC_TXT2TAGS_HEADER1),
    t(wxSTC_TXT2TAGS_EM2, ?wxSTC_TXT2TAGS_EM2),
    t(wxSTC_TXT2TAGS_EM1, ?wxSTC_TXT2TAGS_EM1),
    t(wxSTC_TXT2TAGS_STRONG2, ?wxSTC_TXT2TAGS_STRONG2),
    t(wxSTC_TXT2TAGS_STRONG1, ?wxSTC_TXT2TAGS_STRONG1),
    t(wxSTC_TXT2TAGS_LINE_BEGIN, ?wxSTC_TXT2TAGS_LINE_BEGIN),
    t(wxSTC_TXT2TAGS_DEFAULT, ?wxSTC_TXT2TAGS_DEFAULT),
    t(wxSTC_MARKDOWN_CODEBK, ?wxSTC_MARKDOWN_CODEBK),
    t(wxSTC_MARKDOWN_CODE2, ?wxSTC_MARKDOWN_CODE2),
    t(wxSTC_MARKDOWN_CODE, ?wxSTC_MARKDOWN_CODE),
    t(wxSTC_MARKDOWN_LINK, ?wxSTC_MARKDOWN_LINK),
    t(wxSTC_MARKDOWN_HRULE, ?wxSTC_MARKDOWN_HRULE),
    t(wxSTC_MARKDOWN_STRIKEOUT, ?wxSTC_MARKDOWN_STRIKEOUT),
    t(wxSTC_MARKDOWN_BLOCKQUOTE, ?wxSTC_MARKDOWN_BLOCKQUOTE),
    t(wxSTC_MARKDOWN_OLIST_ITEM, ?wxSTC_MARKDOWN_OLIST_ITEM),
    t(wxSTC_MARKDOWN_ULIST_ITEM, ?wxSTC_MARKDOWN_ULIST_ITEM),
    t(wxSTC_MARKDOWN_PRECHAR, ?wxSTC_MARKDOWN_PRECHAR),
    t(wxSTC_MARKDOWN_HEADER6, ?wxSTC_MARKDOWN_HEADER6),
    t(wxSTC_MARKDOWN_HEADER5, ?wxSTC_MARKDOWN_HEADER5),
    t(wxSTC_MARKDOWN_HEADER4, ?wxSTC_MARKDOWN_HEADER4),
    t(wxSTC_MARKDOWN_HEADER3, ?wxSTC_MARKDOWN_HEADER3),
    t(wxSTC_MARKDOWN_HEADER2, ?wxSTC_MARKDOWN_HEADER2),
    t(wxSTC_MARKDOWN_HEADER1, ?wxSTC_MARKDOWN_HEADER1),
    t(wxSTC_MARKDOWN_EM2, ?wxSTC_MARKDOWN_EM2),
    t(wxSTC_MARKDOWN_EM1, ?wxSTC_MARKDOWN_EM1),
    t(wxSTC_MARKDOWN_STRONG2, ?wxSTC_MARKDOWN_STRONG2),
    t(wxSTC_MARKDOWN_STRONG1, ?wxSTC_MARKDOWN_STRONG1),
    t(wxSTC_MARKDOWN_LINE_BEGIN, ?wxSTC_MARKDOWN_LINE_BEGIN),
    t(wxSTC_MARKDOWN_DEFAULT, ?wxSTC_MARKDOWN_DEFAULT),
    t(wxSTC_SML_COMMENT3, ?wxSTC_SML_COMMENT3),
    t(wxSTC_SML_COMMENT2, ?wxSTC_SML_COMMENT2),
    t(wxSTC_SML_COMMENT1, ?wxSTC_SML_COMMENT1),
    t(wxSTC_SML_COMMENT, ?wxSTC_SML_COMMENT),
    t(wxSTC_SML_STRING, ?wxSTC_SML_STRING),
    t(wxSTC_SML_CHAR, ?wxSTC_SML_CHAR),
    t(wxSTC_SML_NUMBER, ?wxSTC_SML_NUMBER),
    t(wxSTC_SML_OPERATOR, ?wxSTC_SML_OPERATOR),
    t(wxSTC_SML_LINENUM, ?wxSTC_SML_LINENUM),
    t(wxSTC_SML_KEYWORD3, ?wxSTC_SML_KEYWORD3),
    t(wxSTC_SML_KEYWORD2, ?wxSTC_SML_KEYWORD2),
    t(wxSTC_SML_KEYWORD, ?wxSTC_SML_KEYWORD),
    t(wxSTC_SML_TAGNAME, ?wxSTC_SML_TAGNAME),
    t(wxSTC_SML_IDENTIFIER, ?wxSTC_SML_IDENTIFIER),
    t(wxSTC_SML_DEFAULT, ?wxSTC_SML_DEFAULT),
    t(wxSTC_POWERPRO_FUNCTION, ?wxSTC_POWERPRO_FUNCTION),
    t(wxSTC_POWERPRO_ALTQUOTE, ?wxSTC_POWERPRO_ALTQUOTE),
    t(wxSTC_POWERPRO_VERBATIM, ?wxSTC_POWERPRO_VERBATIM),
    t(wxSTC_POWERPRO_STRINGEOL, ?wxSTC_POWERPRO_STRINGEOL),
    t(wxSTC_POWERPRO_IDENTIFIER, ?wxSTC_POWERPRO_IDENTIFIER),
    t(wxSTC_POWERPRO_OPERATOR, ?wxSTC_POWERPRO_OPERATOR),
    t(wxSTC_POWERPRO_LINECONTINUE, ?wxSTC_POWERPRO_LINECONTINUE),
    t(wxSTC_POWERPRO_SINGLEQUOTEDSTRING, ?wxSTC_POWERPRO_SINGLEQUOTEDSTRING),
    t(wxSTC_POWERPRO_DOUBLEQUOTEDSTRING, ?wxSTC_POWERPRO_DOUBLEQUOTEDSTRING),
    t(wxSTC_POWERPRO_WORD4, ?wxSTC_POWERPRO_WORD4),
    t(wxSTC_POWERPRO_WORD3, ?wxSTC_POWERPRO_WORD3),
    t(wxSTC_POWERPRO_WORD2, ?wxSTC_POWERPRO_WORD2),
    t(wxSTC_POWERPRO_WORD, ?wxSTC_POWERPRO_WORD),
    t(wxSTC_POWERPRO_NUMBER, ?wxSTC_POWERPRO_NUMBER),
    t(wxSTC_POWERPRO_COMMENTLINE, ?wxSTC_POWERPRO_COMMENTLINE),
    t(wxSTC_POWERPRO_COMMENTBLOCK, ?wxSTC_POWERPRO_COMMENTBLOCK),
    t(wxSTC_POWERPRO_DEFAULT, ?wxSTC_POWERPRO_DEFAULT),
    t(wxSTC_SORCUS_CONSTANT, ?wxSTC_SORCUS_CONSTANT),
    t(wxSTC_SORCUS_NUMBER, ?wxSTC_SORCUS_NUMBER),
    t(wxSTC_SORCUS_OPERATOR, ?wxSTC_SORCUS_OPERATOR),
    t(wxSTC_SORCUS_IDENTIFIER, ?wxSTC_SORCUS_IDENTIFIER),
    t(wxSTC_SORCUS_STRINGEOL, ?wxSTC_SORCUS_STRINGEOL),
    t(wxSTC_SORCUS_STRING, ?wxSTC_SORCUS_STRING),
    t(wxSTC_SORCUS_COMMENTLINE, ?wxSTC_SORCUS_COMMENTLINE),
    t(wxSTC_SORCUS_PARAMETER, ?wxSTC_SORCUS_PARAMETER),
    t(wxSTC_SORCUS_COMMAND, ?wxSTC_SORCUS_COMMAND),
    t(wxSTC_SORCUS_DEFAULT, ?wxSTC_SORCUS_DEFAULT),
    t(wxSTC_PAS_ASM, ?wxSTC_PAS_ASM),
    t(wxSTC_PAS_OPERATOR, ?wxSTC_PAS_OPERATOR),
    t(wxSTC_PAS_CHARACTER, ?wxSTC_PAS_CHARACTER),
    t(wxSTC_PAS_STRINGEOL, ?wxSTC_PAS_STRINGEOL),
    t(wxSTC_PAS_STRING, ?wxSTC_PAS_STRING),
    t(wxSTC_PAS_WORD, ?wxSTC_PAS_WORD),
    t(wxSTC_PAS_HEXNUMBER, ?wxSTC_PAS_HEXNUMBER),
    t(wxSTC_PAS_NUMBER, ?wxSTC_PAS_NUMBER),
    t(wxSTC_PAS_PREPROCESSOR2, ?wxSTC_PAS_PREPROCESSOR2),
    t(wxSTC_PAS_PREPROCESSOR, ?wxSTC_PAS_PREPROCESSOR),
    t(wxSTC_PAS_COMMENTLINE, ?wxSTC_PAS_COMMENTLINE),
    t(wxSTC_PAS_COMMENT2, ?wxSTC_PAS_COMMENT2),
    t(wxSTC_PAS_COMMENT, ?wxSTC_PAS_COMMENT),
    t(wxSTC_PAS_IDENTIFIER, ?wxSTC_PAS_IDENTIFIER),
    t(wxSTC_PAS_DEFAULT, ?wxSTC_PAS_DEFAULT),
    t(wxSTC_PO_ERROR, ?wxSTC_PO_ERROR),
    t(wxSTC_PO_MSGCTXT_TEXT_EOL, ?wxSTC_PO_MSGCTXT_TEXT_EOL),
    t(wxSTC_PO_MSGSTR_TEXT_EOL, ?wxSTC_PO_MSGSTR_TEXT_EOL),
    t(wxSTC_PO_MSGID_TEXT_EOL, ?wxSTC_PO_MSGID_TEXT_EOL),
    t(wxSTC_PO_FLAGS, ?wxSTC_PO_FLAGS),
    t(wxSTC_PO_REFERENCE, ?wxSTC_PO_REFERENCE),
    t(wxSTC_PO_PROGRAMMER_COMMENT, ?wxSTC_PO_PROGRAMMER_COMMENT),
    t(wxSTC_PO_FUZZY, ?wxSTC_PO_FUZZY),
    t(wxSTC_PO_MSGCTXT_TEXT, ?wxSTC_PO_MSGCTXT_TEXT),
    t(wxSTC_PO_MSGCTXT, ?wxSTC_PO_MSGCTXT),
    t(wxSTC_PO_MSGSTR_TEXT, ?wxSTC_PO_MSGSTR_TEXT),
    t(wxSTC_PO_MSGSTR, ?wxSTC_PO_MSGSTR),
    t(wxSTC_PO_MSGID_TEXT, ?wxSTC_PO_MSGID_TEXT),
    t(wxSTC_PO_MSGID, ?wxSTC_PO_MSGID),
    t(wxSTC_PO_COMMENT, ?wxSTC_PO_COMMENT),
    t(wxSTC_PO_DEFAULT, ?wxSTC_PO_DEFAULT),
    t(wxSTC_MYSQL_PLACEHOLDER, ?wxSTC_MYSQL_PLACEHOLDER),
    t(wxSTC_MYSQL_HIDDENCOMMAND, ?wxSTC_MYSQL_HIDDENCOMMAND),
    t(wxSTC_MYSQL_USER3, ?wxSTC_MYSQL_USER3),
    t(wxSTC_MYSQL_USER2, ?wxSTC_MYSQL_USER2),
    t(wxSTC_MYSQL_USER1, ?wxSTC_MYSQL_USER1),
    t(wxSTC_MYSQL_QUOTEDIDENTIFIER, ?wxSTC_MYSQL_QUOTEDIDENTIFIER),
    t(wxSTC_MYSQL_IDENTIFIER, ?wxSTC_MYSQL_IDENTIFIER),
    t(wxSTC_MYSQL_FUNCTION, ?wxSTC_MYSQL_FUNCTION),
    t(wxSTC_MYSQL_OPERATOR, ?wxSTC_MYSQL_OPERATOR),
    t(wxSTC_MYSQL_DQSTRING, ?wxSTC_MYSQL_DQSTRING),
    t(wxSTC_MYSQL_SQSTRING, ?wxSTC_MYSQL_SQSTRING),
    t(wxSTC_MYSQL_STRING, ?wxSTC_MYSQL_STRING),
    t(wxSTC_MYSQL_PROCEDUREKEYWORD, ?wxSTC_MYSQL_PROCEDUREKEYWORD),
    t(wxSTC_MYSQL_DATABASEOBJECT, ?wxSTC_MYSQL_DATABASEOBJECT),
    t(wxSTC_MYSQL_KEYWORD, ?wxSTC_MYSQL_KEYWORD),
    t(wxSTC_MYSQL_MAJORKEYWORD, ?wxSTC_MYSQL_MAJORKEYWORD),
    t(wxSTC_MYSQL_NUMBER, ?wxSTC_MYSQL_NUMBER),
    t(wxSTC_MYSQL_KNOWNSYSTEMVARIABLE, ?wxSTC_MYSQL_KNOWNSYSTEMVARIABLE),
    t(wxSTC_MYSQL_SYSTEMVARIABLE, ?wxSTC_MYSQL_SYSTEMVARIABLE),
    t(wxSTC_MYSQL_VARIABLE, ?wxSTC_MYSQL_VARIABLE),
    t(wxSTC_MYSQL_COMMENTLINE, ?wxSTC_MYSQL_COMMENTLINE),
    t(wxSTC_MYSQL_COMMENT, ?wxSTC_MYSQL_COMMENT),
    t(wxSTC_MYSQL_DEFAULT, ?wxSTC_MYSQL_DEFAULT),
    t(wxSTC_POWERSHELL_COMMENTDOCKEYWORD, ?wxSTC_POWERSHELL_COMMENTDOCKEYWORD),
    t(wxSTC_POWERSHELL_HERE_CHARACTER, ?wxSTC_POWERSHELL_HERE_CHARACTER),
    t(wxSTC_POWERSHELL_HERE_STRING, ?wxSTC_POWERSHELL_HERE_STRING),
    t(wxSTC_POWERSHELL_COMMENTSTREAM, ?wxSTC_POWERSHELL_COMMENTSTREAM),
    t(wxSTC_POWERSHELL_USER1, ?wxSTC_POWERSHELL_USER1),
    t(wxSTC_POWERSHELL_FUNCTION, ?wxSTC_POWERSHELL_FUNCTION),
    t(wxSTC_POWERSHELL_ALIAS, ?wxSTC_POWERSHELL_ALIAS),
    t(wxSTC_POWERSHELL_CMDLET, ?wxSTC_POWERSHELL_CMDLET),
    t(wxSTC_POWERSHELL_KEYWORD, ?wxSTC_POWERSHELL_KEYWORD),
    t(wxSTC_POWERSHELL_IDENTIFIER, ?wxSTC_POWERSHELL_IDENTIFIER),
    t(wxSTC_POWERSHELL_OPERATOR, ?wxSTC_POWERSHELL_OPERATOR),
    t(wxSTC_POWERSHELL_VARIABLE, ?wxSTC_POWERSHELL_VARIABLE),
    t(wxSTC_POWERSHELL_NUMBER, ?wxSTC_POWERSHELL_NUMBER),
    t(wxSTC_POWERSHELL_CHARACTER, ?wxSTC_POWERSHELL_CHARACTER),
    t(wxSTC_POWERSHELL_STRING, ?wxSTC_POWERSHELL_STRING),
    t(wxSTC_POWERSHELL_COMMENT, ?wxSTC_POWERSHELL_COMMENT),
    t(wxSTC_POWERSHELL_DEFAULT, ?wxSTC_POWERSHELL_DEFAULT),
    t(wxSTC_MAGIK_SYMBOL, ?wxSTC_MAGIK_SYMBOL),
    t(wxSTC_MAGIK_PRAGMA, ?wxSTC_MAGIK_PRAGMA),
    t(wxSTC_MAGIK_KEYWORD, ?wxSTC_MAGIK_KEYWORD),
    t(wxSTC_MAGIK_UNKNOWN_KEYWORD, ?wxSTC_MAGIK_UNKNOWN_KEYWORD),
    t(wxSTC_MAGIK_SQBRACKET_BLOCK, ?wxSTC_MAGIK_SQBRACKET_BLOCK),
    t(wxSTC_MAGIK_BRACE_BLOCK, ?wxSTC_MAGIK_BRACE_BLOCK),
    t(wxSTC_MAGIK_BRACKET_BLOCK, ?wxSTC_MAGIK_BRACKET_BLOCK),
    t(wxSTC_MAGIK_CONTAINER, ?wxSTC_MAGIK_CONTAINER),
    t(wxSTC_MAGIK_FLOW, ?wxSTC_MAGIK_FLOW),
    t(wxSTC_MAGIK_OPERATOR, ?wxSTC_MAGIK_OPERATOR),
    t(wxSTC_MAGIK_IDENTIFIER, ?wxSTC_MAGIK_IDENTIFIER),
    t(wxSTC_MAGIK_NUMBER, ?wxSTC_MAGIK_NUMBER),
    t(wxSTC_MAGIK_CHARACTER, ?wxSTC_MAGIK_CHARACTER),
    t(wxSTC_MAGIK_STRING, ?wxSTC_MAGIK_STRING),
    t(wxSTC_MAGIK_HYPER_COMMENT, ?wxSTC_MAGIK_HYPER_COMMENT),
    t(wxSTC_MAGIK_COMMENT, ?wxSTC_MAGIK_COMMENT),
    t(wxSTC_MAGIK_DEFAULT, ?wxSTC_MAGIK_DEFAULT),
    t(wxSTC_R_INFIXEOL, ?wxSTC_R_INFIXEOL),
    t(wxSTC_R_INFIX, ?wxSTC_R_INFIX),
    t(wxSTC_R_IDENTIFIER, ?wxSTC_R_IDENTIFIER),
    t(wxSTC_R_OPERATOR, ?wxSTC_R_OPERATOR),
    t(wxSTC_R_STRING2, ?wxSTC_R_STRING2),
    t(wxSTC_R_STRING, ?wxSTC_R_STRING),
    t(wxSTC_R_NUMBER, ?wxSTC_R_NUMBER),
    t(wxSTC_R_OTHERKWORD, ?wxSTC_R_OTHERKWORD),
    t(wxSTC_R_BASEKWORD, ?wxSTC_R_BASEKWORD),
    t(wxSTC_R_KWORD, ?wxSTC_R_KWORD),
    t(wxSTC_R_COMMENT, ?wxSTC_R_COMMENT),
    t(wxSTC_R_DEFAULT, ?wxSTC_R_DEFAULT),
    t(wxSTC_ASY_WORD2, ?wxSTC_ASY_WORD2),
    t(wxSTC_ASY_COMMENTLINEDOC, ?wxSTC_ASY_COMMENTLINEDOC),
    t(wxSTC_ASY_STRINGEOL, ?wxSTC_ASY_STRINGEOL),
    t(wxSTC_ASY_IDENTIFIER, ?wxSTC_ASY_IDENTIFIER),
    t(wxSTC_ASY_OPERATOR, ?wxSTC_ASY_OPERATOR),
    t(wxSTC_ASY_CHARACTER, ?wxSTC_ASY_CHARACTER),
    t(wxSTC_ASY_STRING, ?wxSTC_ASY_STRING),
    t(wxSTC_ASY_WORD, ?wxSTC_ASY_WORD),
    t(wxSTC_ASY_NUMBER, ?wxSTC_ASY_NUMBER),
    t(wxSTC_ASY_COMMENTLINE, ?wxSTC_ASY_COMMENTLINE),
    t(wxSTC_ASY_COMMENT, ?wxSTC_ASY_COMMENT),
    t(wxSTC_ASY_DEFAULT, ?wxSTC_ASY_DEFAULT),
    t(wxSTC_ABAQUS_FUNCTION, ?wxSTC_ABAQUS_FUNCTION),
    t(wxSTC_ABAQUS_ARGUMENT, ?wxSTC_ABAQUS_ARGUMENT),
    t(wxSTC_ABAQUS_STARCOMMAND, ?wxSTC_ABAQUS_STARCOMMAND),
    t(wxSTC_ABAQUS_SLASHCOMMAND, ?wxSTC_ABAQUS_SLASHCOMMAND),
    t(wxSTC_ABAQUS_COMMAND, ?wxSTC_ABAQUS_COMMAND),
    t(wxSTC_ABAQUS_PROCESSOR, ?wxSTC_ABAQUS_PROCESSOR),
    t(wxSTC_ABAQUS_WORD, ?wxSTC_ABAQUS_WORD),
    t(wxSTC_ABAQUS_OPERATOR, ?wxSTC_ABAQUS_OPERATOR),
    t(wxSTC_ABAQUS_STRING, ?wxSTC_ABAQUS_STRING),
    t(wxSTC_ABAQUS_NUMBER, ?wxSTC_ABAQUS_NUMBER),
    t(wxSTC_ABAQUS_COMMENTBLOCK, ?wxSTC_ABAQUS_COMMENTBLOCK),
    t(wxSTC_ABAQUS_COMMENT, ?wxSTC_ABAQUS_COMMENT),
    t(wxSTC_ABAQUS_DEFAULT, ?wxSTC_ABAQUS_DEFAULT),
    t(wxSTC_ABL_LINECOMMENT, ?wxSTC_ABL_LINECOMMENT),
    t(wxSTC_ABL_TASKMARKER, ?wxSTC_ABL_TASKMARKER),
    t(wxSTC_ABL_COMMENT, ?wxSTC_ABL_COMMENT),
    t(wxSTC_ABL_END, ?wxSTC_ABL_END),
    t(wxSTC_ABL_BLOCK, ?wxSTC_ABL_BLOCK),
    t(wxSTC_ABL_IDENTIFIER, ?wxSTC_ABL_IDENTIFIER),
    t(wxSTC_ABL_OPERATOR, ?wxSTC_ABL_OPERATOR),
    t(wxSTC_ABL_PREPROCESSOR, ?wxSTC_ABL_PREPROCESSOR),
    t(wxSTC_ABL_CHARACTER, ?wxSTC_ABL_CHARACTER),
    t(wxSTC_ABL_STRING, ?wxSTC_ABL_STRING),
    t(wxSTC_ABL_WORD, ?wxSTC_ABL_WORD),
    t(wxSTC_ABL_NUMBER, ?wxSTC_ABL_NUMBER),
    t(wxSTC_ABL_DEFAULT, ?wxSTC_ABL_DEFAULT),
    t(wxSTC_PLM_KEYWORD, ?wxSTC_PLM_KEYWORD),
    t(wxSTC_PLM_CONTROL, ?wxSTC_PLM_CONTROL),
    t(wxSTC_PLM_OPERATOR, ?wxSTC_PLM_OPERATOR),
    t(wxSTC_PLM_IDENTIFIER, ?wxSTC_PLM_IDENTIFIER),
    t(wxSTC_PLM_NUMBER, ?wxSTC_PLM_NUMBER),
    t(wxSTC_PLM_STRING, ?wxSTC_PLM_STRING),
    t(wxSTC_PLM_COMMENT, ?wxSTC_PLM_COMMENT),
    t(wxSTC_PLM_DEFAULT, ?wxSTC_PLM_DEFAULT),
    t(wxSTC_GAP_STRINGEOL, ?wxSTC_GAP_STRINGEOL),
    t(wxSTC_GAP_NUMBER, ?wxSTC_GAP_NUMBER),
    t(wxSTC_GAP_COMMENT, ?wxSTC_GAP_COMMENT),
    t(wxSTC_GAP_OPERATOR, ?wxSTC_GAP_OPERATOR),
    t(wxSTC_GAP_CHAR, ?wxSTC_GAP_CHAR),
    t(wxSTC_GAP_STRING, ?wxSTC_GAP_STRING),
    t(wxSTC_GAP_KEYWORD4, ?wxSTC_GAP_KEYWORD4),
    t(wxSTC_GAP_KEYWORD3, ?wxSTC_GAP_KEYWORD3),
    t(wxSTC_GAP_KEYWORD2, ?wxSTC_GAP_KEYWORD2),
    t(wxSTC_GAP_KEYWORD, ?wxSTC_GAP_KEYWORD),
    t(wxSTC_GAP_IDENTIFIER, ?wxSTC_GAP_IDENTIFIER),
    t(wxSTC_GAP_DEFAULT, ?wxSTC_GAP_DEFAULT),
    t(wxSTC_CMAKE_NUMBER, ?wxSTC_CMAKE_NUMBER),
    t(wxSTC_CMAKE_STRINGVAR, ?wxSTC_CMAKE_STRINGVAR),
    t(wxSTC_CMAKE_MACRODEF, ?wxSTC_CMAKE_MACRODEF),
    t(wxSTC_CMAKE_IFDEFINEDEF, ?wxSTC_CMAKE_IFDEFINEDEF),
    t(wxSTC_CMAKE_FOREACHDEF, ?wxSTC_CMAKE_FOREACHDEF),
    t(wxSTC_CMAKE_WHILEDEF, ?wxSTC_CMAKE_WHILEDEF),
    t(wxSTC_CMAKE_USERDEFINED, ?wxSTC_CMAKE_USERDEFINED),
    t(wxSTC_CMAKE_VARIABLE, ?wxSTC_CMAKE_VARIABLE),
    t(wxSTC_CMAKE_PARAMETERS, ?wxSTC_CMAKE_PARAMETERS),
    t(wxSTC_CMAKE_COMMANDS, ?wxSTC_CMAKE_COMMANDS),
    t(wxSTC_CMAKE_STRINGRQ, ?wxSTC_CMAKE_STRINGRQ),
    t(wxSTC_CMAKE_STRINGLQ, ?wxSTC_CMAKE_STRINGLQ),
    t(wxSTC_CMAKE_STRINGDQ, ?wxSTC_CMAKE_STRINGDQ),
    t(wxSTC_CMAKE_COMMENT, ?wxSTC_CMAKE_COMMENT),
    t(wxSTC_CMAKE_DEFAULT, ?wxSTC_CMAKE_DEFAULT),
    t(wxSTC_SPICE_COMMENTLINE, ?wxSTC_SPICE_COMMENTLINE),
    t(wxSTC_SPICE_VALUE, ?wxSTC_SPICE_VALUE),
    t(wxSTC_SPICE_DELIMITER, ?wxSTC_SPICE_DELIMITER),
    t(wxSTC_SPICE_NUMBER, ?wxSTC_SPICE_NUMBER),
    t(wxSTC_SPICE_KEYWORD3, ?wxSTC_SPICE_KEYWORD3),
    t(wxSTC_SPICE_KEYWORD2, ?wxSTC_SPICE_KEYWORD2),
    t(wxSTC_SPICE_KEYWORD, ?wxSTC_SPICE_KEYWORD),
    t(wxSTC_SPICE_IDENTIFIER, ?wxSTC_SPICE_IDENTIFIER),
    t(wxSTC_SPICE_DEFAULT, ?wxSTC_SPICE_DEFAULT),
    t(wxSTC_OPAL_DEFAULT, ?wxSTC_OPAL_DEFAULT),
    t(wxSTC_OPAL_BOOL_CONST, ?wxSTC_OPAL_BOOL_CONST),
    t(wxSTC_OPAL_PAR, ?wxSTC_OPAL_PAR),
    t(wxSTC_OPAL_STRING, ?wxSTC_OPAL_STRING),
    t(wxSTC_OPAL_SORT, ?wxSTC_OPAL_SORT),
    t(wxSTC_OPAL_KEYWORD, ?wxSTC_OPAL_KEYWORD),
    t(wxSTC_OPAL_INTEGER, ?wxSTC_OPAL_INTEGER),
    t(wxSTC_OPAL_COMMENT_LINE, ?wxSTC_OPAL_COMMENT_LINE),
    t(wxSTC_OPAL_COMMENT_BLOCK, ?wxSTC_OPAL_COMMENT_BLOCK),
    t(wxSTC_OPAL_SPACE, ?wxSTC_OPAL_SPACE),
    t(wxSTC_INNO_IDENTIFIER, ?wxSTC_INNO_IDENTIFIER),
    t(wxSTC_INNO_STRING_SINGLE, ?wxSTC_INNO_STRING_SINGLE),
    t(wxSTC_INNO_STRING_DOUBLE, ?wxSTC_INNO_STRING_DOUBLE),
    t(wxSTC_INNO_KEYWORD_USER, ?wxSTC_INNO_KEYWORD_USER),
    t(wxSTC_INNO_KEYWORD_PASCAL, ?wxSTC_INNO_KEYWORD_PASCAL),
    t(wxSTC_INNO_COMMENT_PASCAL, ?wxSTC_INNO_COMMENT_PASCAL),
    t(wxSTC_INNO_INLINE_EXPANSION, ?wxSTC_INNO_INLINE_EXPANSION),
    t(wxSTC_INNO_SECTION, ?wxSTC_INNO_SECTION),
    t(wxSTC_INNO_PARAMETER, ?wxSTC_INNO_PARAMETER),
    t(wxSTC_INNO_KEYWORD, ?wxSTC_INNO_KEYWORD),
    t(wxSTC_INNO_COMMENT, ?wxSTC_INNO_COMMENT),
    t(wxSTC_INNO_DEFAULT, ?wxSTC_INNO_DEFAULT),
    t(wxSTC_CSOUND_STRINGEOL, ?wxSTC_CSOUND_STRINGEOL),
    t(wxSTC_CSOUND_GLOBAL_VAR, ?wxSTC_CSOUND_GLOBAL_VAR),
    t(wxSTC_CSOUND_IRATE_VAR, ?wxSTC_CSOUND_IRATE_VAR),
    t(wxSTC_CSOUND_KRATE_VAR, ?wxSTC_CSOUND_KRATE_VAR),
    t(wxSTC_CSOUND_ARATE_VAR, ?wxSTC_CSOUND_ARATE_VAR),
    t(wxSTC_CSOUND_PARAM, ?wxSTC_CSOUND_PARAM),
    t(wxSTC_CSOUND_COMMENTBLOCK, ?wxSTC_CSOUND_COMMENTBLOCK),
    t(wxSTC_CSOUND_USERKEYWORD, ?wxSTC_CSOUND_USERKEYWORD),
    t(wxSTC_CSOUND_HEADERSTMT, ?wxSTC_CSOUND_HEADERSTMT),
    t(wxSTC_CSOUND_OPCODE, ?wxSTC_CSOUND_OPCODE),
    t(wxSTC_CSOUND_IDENTIFIER, ?wxSTC_CSOUND_IDENTIFIER),
    t(wxSTC_CSOUND_INSTR, ?wxSTC_CSOUND_INSTR),
    t(wxSTC_CSOUND_OPERATOR, ?wxSTC_CSOUND_OPERATOR),
    t(wxSTC_CSOUND_NUMBER, ?wxSTC_CSOUND_NUMBER),
    t(wxSTC_CSOUND_COMMENT, ?wxSTC_CSOUND_COMMENT),
    t(wxSTC_CSOUND_DEFAULT, ?wxSTC_CSOUND_DEFAULT),
    t(wxSTC_FS_STRINGEOL_C, ?wxSTC_FS_STRINGEOL_C),
    t(wxSTC_FS_IDENTIFIER_C, ?wxSTC_FS_IDENTIFIER_C),
    t(wxSTC_FS_OPERATOR_C, ?wxSTC_FS_OPERATOR_C),
    t(wxSTC_FS_PREPROCESSOR_C, ?wxSTC_FS_PREPROCESSOR_C),
    t(wxSTC_FS_STRING_C, ?wxSTC_FS_STRING_C),
    t(wxSTC_FS_NUMBER_C, ?wxSTC_FS_NUMBER_C),
    t(wxSTC_FS_KEYWORD2_C, ?wxSTC_FS_KEYWORD2_C),
    t(wxSTC_FS_KEYWORD_C, ?wxSTC_FS_KEYWORD_C),
    t(wxSTC_FS_COMMENTLINEDOC_C, ?wxSTC_FS_COMMENTLINEDOC_C),
    t(wxSTC_FS_COMMENTDOC_C, ?wxSTC_FS_COMMENTDOC_C),
    t(wxSTC_FS_DEFAULT_C, ?wxSTC_FS_DEFAULT_C),
    t(wxSTC_FS_DISABLEDCODE, ?wxSTC_FS_DISABLEDCODE),
    t(wxSTC_FS_WORDOPERATOR, ?wxSTC_FS_WORDOPERATOR),
    t(wxSTC_FS_CONSTANT, ?wxSTC_FS_CONSTANT),
    t(wxSTC_FS_STRINGEOL, ?wxSTC_FS_STRINGEOL),
    t(wxSTC_FS_DATE, ?wxSTC_FS_DATE),
    t(wxSTC_FS_IDENTIFIER, ?wxSTC_FS_IDENTIFIER),
    t(wxSTC_FS_OPERATOR, ?wxSTC_FS_OPERATOR),
    t(wxSTC_FS_PREPROCESSOR, ?wxSTC_FS_PREPROCESSOR),
    t(wxSTC_FS_STRING, ?wxSTC_FS_STRING),
    t(wxSTC_FS_NUMBER, ?wxSTC_FS_NUMBER),
    t(wxSTC_FS_KEYWORD4, ?wxSTC_FS_KEYWORD4),
    t(wxSTC_FS_KEYWORD3, ?wxSTC_FS_KEYWORD3),
    t(wxSTC_FS_KEYWORD2, ?wxSTC_FS_KEYWORD2),
    t(wxSTC_FS_KEYWORD, ?wxSTC_FS_KEYWORD),
    t(wxSTC_FS_COMMENTDOCKEYWORDERROR, ?wxSTC_FS_COMMENTDOCKEYWORDERROR),
    t(wxSTC_FS_COMMENTDOCKEYWORD, ?wxSTC_FS_COMMENTDOCKEYWORD),
    t(wxSTC_FS_COMMENTLINEDOC, ?wxSTC_FS_COMMENTLINEDOC),
    t(wxSTC_FS_COMMENTDOC, ?wxSTC_FS_COMMENTDOC),
    t(wxSTC_FS_COMMENTLINE, ?wxSTC_FS_COMMENTLINE),
    t(wxSTC_FS_COMMENT, ?wxSTC_FS_COMMENT),
    t(wxSTC_FS_DEFAULT, ?wxSTC_FS_DEFAULT),
    t(wxSTC_ST_SPEC_SEL, ?wxSTC_ST_SPEC_SEL),
    t(wxSTC_ST_CHARACTER, ?wxSTC_ST_CHARACTER),
    t(wxSTC_ST_ASSIGN, ?wxSTC_ST_ASSIGN),
    t(wxSTC_ST_KWSEND, ?wxSTC_ST_KWSEND),
    t(wxSTC_ST_SPECIAL, ?wxSTC_ST_SPECIAL),
    t(wxSTC_ST_RETURN, ?wxSTC_ST_RETURN),
    t(wxSTC_ST_GLOBAL, ?wxSTC_ST_GLOBAL),
    t(wxSTC_ST_NIL, ?wxSTC_ST_NIL),
    t(wxSTC_ST_SUPER, ?wxSTC_ST_SUPER),
    t(wxSTC_ST_SELF, ?wxSTC_ST_SELF),
    t(wxSTC_ST_BOOL, ?wxSTC_ST_BOOL),
    t(wxSTC_ST_BINARY, ?wxSTC_ST_BINARY),
    t(wxSTC_ST_SYMBOL, ?wxSTC_ST_SYMBOL),
    t(wxSTC_ST_COMMENT, ?wxSTC_ST_COMMENT),
    t(wxSTC_ST_NUMBER, ?wxSTC_ST_NUMBER),
    t(wxSTC_ST_STRING, ?wxSTC_ST_STRING),
    t(wxSTC_ST_DEFAULT, ?wxSTC_ST_DEFAULT),
    t(wxSTC_SQL_QOPERATOR, ?wxSTC_SQL_QOPERATOR),
    t(wxSTC_SQL_QUOTEDIDENTIFIER, ?wxSTC_SQL_QUOTEDIDENTIFIER),
    t(wxSTC_SQL_USER4, ?wxSTC_SQL_USER4),
    t(wxSTC_SQL_USER3, ?wxSTC_SQL_USER3),
    t(wxSTC_SQL_USER2, ?wxSTC_SQL_USER2),
    t(wxSTC_SQL_USER1, ?wxSTC_SQL_USER1),
    t(wxSTC_SQL_COMMENTDOCKEYWORDERROR, ?wxSTC_SQL_COMMENTDOCKEYWORDERROR),
    t(wxSTC_SQL_COMMENTDOCKEYWORD, ?wxSTC_SQL_COMMENTDOCKEYWORD),
    t(wxSTC_SQL_WORD2, ?wxSTC_SQL_WORD2),
    t(wxSTC_SQL_COMMENTLINEDOC, ?wxSTC_SQL_COMMENTLINEDOC),
    t(wxSTC_SQL_SQLPLUS_COMMENT, ?wxSTC_SQL_SQLPLUS_COMMENT),
    t(wxSTC_SQL_IDENTIFIER, ?wxSTC_SQL_IDENTIFIER),
    t(wxSTC_SQL_OPERATOR, ?wxSTC_SQL_OPERATOR),
    t(wxSTC_SQL_SQLPLUS_PROMPT, ?wxSTC_SQL_SQLPLUS_PROMPT),
    t(wxSTC_SQL_SQLPLUS, ?wxSTC_SQL_SQLPLUS),
    t(wxSTC_SQL_CHARACTER, ?wxSTC_SQL_CHARACTER),
    t(wxSTC_SQL_STRING, ?wxSTC_SQL_STRING),
    t(wxSTC_SQL_WORD, ?wxSTC_SQL_WORD),
    t(wxSTC_SQL_NUMBER, ?wxSTC_SQL_NUMBER),
    t(wxSTC_SQL_COMMENTDOC, ?wxSTC_SQL_COMMENTDOC),
    t(wxSTC_SQL_COMMENTLINE, ?wxSTC_SQL_COMMENTLINE),
    t(wxSTC_SQL_COMMENT, ?wxSTC_SQL_COMMENT),
    t(wxSTC_SQL_DEFAULT, ?wxSTC_SQL_DEFAULT),
    t(wxSTC_REBOL_WORD8, ?wxSTC_REBOL_WORD8),
    t(wxSTC_REBOL_WORD7, ?wxSTC_REBOL_WORD7),
    t(wxSTC_REBOL_WORD6, ?wxSTC_REBOL_WORD6),
    t(wxSTC_REBOL_WORD5, ?wxSTC_REBOL_WORD5),
    t(wxSTC_REBOL_WORD4, ?wxSTC_REBOL_WORD4),
    t(wxSTC_REBOL_WORD3, ?wxSTC_REBOL_WORD3),
    t(wxSTC_REBOL_WORD2, ?wxSTC_REBOL_WORD2),
    t(wxSTC_REBOL_WORD, ?wxSTC_REBOL_WORD),
    t(wxSTC_REBOL_IDENTIFIER, ?wxSTC_REBOL_IDENTIFIER),
    t(wxSTC_REBOL_TIME, ?wxSTC_REBOL_TIME),
    t(wxSTC_REBOL_DATE, ?wxSTC_REBOL_DATE),
    t(wxSTC_REBOL_URL, ?wxSTC_REBOL_URL),
    t(wxSTC_REBOL_EMAIL, ?wxSTC_REBOL_EMAIL),
    t(wxSTC_REBOL_FILE, ?wxSTC_REBOL_FILE),
    t(wxSTC_REBOL_TAG, ?wxSTC_REBOL_TAG),
    t(wxSTC_REBOL_ISSUE, ?wxSTC_REBOL_ISSUE),
    t(wxSTC_REBOL_MONEY, ?wxSTC_REBOL_MONEY),
    t(wxSTC_REBOL_BINARY, ?wxSTC_REBOL_BINARY),
    t(wxSTC_REBOL_TUPLE, ?wxSTC_REBOL_TUPLE),
    t(wxSTC_REBOL_PAIR, ?wxSTC_REBOL_PAIR),
    t(wxSTC_REBOL_NUMBER, ?wxSTC_REBOL_NUMBER),
    t(wxSTC_REBOL_BRACEDSTRING, ?wxSTC_REBOL_BRACEDSTRING),
    t(wxSTC_REBOL_QUOTEDSTRING, ?wxSTC_REBOL_QUOTEDSTRING),
    t(wxSTC_REBOL_CHARACTER, ?wxSTC_REBOL_CHARACTER),
    t(wxSTC_REBOL_OPERATOR, ?wxSTC_REBOL_OPERATOR),
    t(wxSTC_REBOL_PREFACE, ?wxSTC_REBOL_PREFACE),
    t(wxSTC_REBOL_COMMENTBLOCK, ?wxSTC_REBOL_COMMENTBLOCK),
    t(wxSTC_REBOL_COMMENTLINE, ?wxSTC_REBOL_COMMENTLINE),
    t(wxSTC_REBOL_DEFAULT, ?wxSTC_REBOL_DEFAULT),
    t(wxSTC_T3_BRACE, ?wxSTC_T3_BRACE),
    t(wxSTC_T3_USER3, ?wxSTC_T3_USER3),
    t(wxSTC_T3_USER2, ?wxSTC_T3_USER2),
    t(wxSTC_T3_USER1, ?wxSTC_T3_USER1),
    t(wxSTC_T3_HTML_STRING, ?wxSTC_T3_HTML_STRING),
    t(wxSTC_T3_HTML_DEFAULT, ?wxSTC_T3_HTML_DEFAULT),
    t(wxSTC_T3_HTML_TAG, ?wxSTC_T3_HTML_TAG),
    t(wxSTC_T3_MSG_PARAM, ?wxSTC_T3_MSG_PARAM),
    t(wxSTC_T3_LIB_DIRECTIVE, ?wxSTC_T3_LIB_DIRECTIVE),
    t(wxSTC_T3_X_STRING, ?wxSTC_T3_X_STRING),
    t(wxSTC_T3_D_STRING, ?wxSTC_T3_D_STRING),
    t(wxSTC_T3_S_STRING, ?wxSTC_T3_S_STRING),
    t(wxSTC_T3_IDENTIFIER, ?wxSTC_T3_IDENTIFIER),
    t(wxSTC_T3_NUMBER, ?wxSTC_T3_NUMBER),
    t(wxSTC_T3_KEYWORD, ?wxSTC_T3_KEYWORD),
    t(wxSTC_T3_OPERATOR, ?wxSTC_T3_OPERATOR),
    t(wxSTC_T3_LINE_COMMENT, ?wxSTC_T3_LINE_COMMENT),
    t(wxSTC_T3_BLOCK_COMMENT, ?wxSTC_T3_BLOCK_COMMENT),
    t(wxSTC_T3_PREPROCESSOR, ?wxSTC_T3_PREPROCESSOR),
    t(wxSTC_T3_X_DEFAULT, ?wxSTC_T3_X_DEFAULT),
    t(wxSTC_T3_DEFAULT, ?wxSTC_T3_DEFAULT),
    t(wxSTC_HA_LITERATE_CODEDELIM, ?wxSTC_HA_LITERATE_CODEDELIM),
    t(wxSTC_HA_LITERATE_COMMENT, ?wxSTC_HA_LITERATE_COMMENT),
    t(wxSTC_HA_RESERVED_OPERATOR, ?wxSTC_HA_RESERVED_OPERATOR),
    t(wxSTC_HA_STRINGEOL, ?wxSTC_HA_STRINGEOL),
    t(wxSTC_HA_PREPROCESSOR, ?wxSTC_HA_PREPROCESSOR),
    t(wxSTC_HA_PRAGMA, ?wxSTC_HA_PRAGMA),
    t(wxSTC_HA_COMMENTBLOCK3, ?wxSTC_HA_COMMENTBLOCK3),
    t(wxSTC_HA_COMMENTBLOCK2, ?wxSTC_HA_COMMENTBLOCK2),
    t(wxSTC_HA_COMMENTBLOCK, ?wxSTC_HA_COMMENTBLOCK),
    t(wxSTC_HA_COMMENTLINE, ?wxSTC_HA_COMMENTLINE),
    t(wxSTC_HA_INSTANCE, ?wxSTC_HA_INSTANCE),
    t(wxSTC_HA_OPERATOR, ?wxSTC_HA_OPERATOR),
    t(wxSTC_HA_IMPORT, ?wxSTC_HA_IMPORT),
    t(wxSTC_HA_DATA, ?wxSTC_HA_DATA),
    t(wxSTC_HA_CAPITAL, ?wxSTC_HA_CAPITAL),
    t(wxSTC_HA_MODULE, ?wxSTC_HA_MODULE),
    t(wxSTC_HA_CLASS, ?wxSTC_HA_CLASS),
    t(wxSTC_HA_CHARACTER, ?wxSTC_HA_CHARACTER),
    t(wxSTC_HA_STRING, ?wxSTC_HA_STRING),
    t(wxSTC_HA_NUMBER, ?wxSTC_HA_NUMBER),
    t(wxSTC_HA_KEYWORD, ?wxSTC_HA_KEYWORD),
    t(wxSTC_HA_IDENTIFIER, ?wxSTC_HA_IDENTIFIER),
    t(wxSTC_HA_DEFAULT, ?wxSTC_HA_DEFAULT),
    t(wxSTC_CAML_COMMENT3, ?wxSTC_CAML_COMMENT3),
    t(wxSTC_CAML_COMMENT2, ?wxSTC_CAML_COMMENT2),
    t(wxSTC_CAML_COMMENT1, ?wxSTC_CAML_COMMENT1),
    t(wxSTC_CAML_COMMENT, ?wxSTC_CAML_COMMENT),
    t(wxSTC_CAML_STRING, ?wxSTC_CAML_STRING),
    t(wxSTC_CAML_WHITE, ?wxSTC_CAML_WHITE),
    t(wxSTC_CAML_CHAR, ?wxSTC_CAML_CHAR),
    t(wxSTC_CAML_NUMBER, ?wxSTC_CAML_NUMBER),
    t(wxSTC_CAML_OPERATOR, ?wxSTC_CAML_OPERATOR),
    t(wxSTC_CAML_LINENUM, ?wxSTC_CAML_LINENUM),
    t(wxSTC_CAML_KEYWORD3, ?wxSTC_CAML_KEYWORD3),
    t(wxSTC_CAML_KEYWORD2, ?wxSTC_CAML_KEYWORD2),
    t(wxSTC_CAML_KEYWORD, ?wxSTC_CAML_KEYWORD),
    t(wxSTC_CAML_TAGNAME, ?wxSTC_CAML_TAGNAME),
    t(wxSTC_CAML_IDENTIFIER, ?wxSTC_CAML_IDENTIFIER),
    t(wxSTC_CAML_DEFAULT, ?wxSTC_CAML_DEFAULT),
    t(wxSTC_VHDL_BLOCK_COMMENT, ?wxSTC_VHDL_BLOCK_COMMENT),
    t(wxSTC_VHDL_USERWORD, ?wxSTC_VHDL_USERWORD),
    t(wxSTC_VHDL_STDTYPE, ?wxSTC_VHDL_STDTYPE),
    t(wxSTC_VHDL_STDPACKAGE, ?wxSTC_VHDL_STDPACKAGE),
    t(wxSTC_VHDL_STDFUNCTION, ?wxSTC_VHDL_STDFUNCTION),
    t(wxSTC_VHDL_ATTRIBUTE, ?wxSTC_VHDL_ATTRIBUTE),
    t(wxSTC_VHDL_STDOPERATOR, ?wxSTC_VHDL_STDOPERATOR),
    t(wxSTC_VHDL_KEYWORD, ?wxSTC_VHDL_KEYWORD),
    t(wxSTC_VHDL_STRINGEOL, ?wxSTC_VHDL_STRINGEOL),
    t(wxSTC_VHDL_IDENTIFIER, ?wxSTC_VHDL_IDENTIFIER),
    t(wxSTC_VHDL_OPERATOR, ?wxSTC_VHDL_OPERATOR),
    t(wxSTC_VHDL_STRING, ?wxSTC_VHDL_STRING),
    t(wxSTC_VHDL_NUMBER, ?wxSTC_VHDL_NUMBER),
    t(wxSTC_VHDL_COMMENTLINEBANG, ?wxSTC_VHDL_COMMENTLINEBANG),
    t(wxSTC_VHDL_COMMENT, ?wxSTC_VHDL_COMMENT),
    t(wxSTC_VHDL_DEFAULT, ?wxSTC_VHDL_DEFAULT),
    t(wxSTC_ASN1_OPERATOR, ?wxSTC_ASN1_OPERATOR),
    t(wxSTC_ASN1_TYPE, ?wxSTC_ASN1_TYPE),
    t(wxSTC_ASN1_DESCRIPTOR, ?wxSTC_ASN1_DESCRIPTOR),
    t(wxSTC_ASN1_ATTRIBUTE, ?wxSTC_ASN1_ATTRIBUTE),
    t(wxSTC_ASN1_KEYWORD, ?wxSTC_ASN1_KEYWORD),
    t(wxSTC_ASN1_SCALAR, ?wxSTC_ASN1_SCALAR),
    t(wxSTC_ASN1_OID, ?wxSTC_ASN1_OID),
    t(wxSTC_ASN1_STRING, ?wxSTC_ASN1_STRING),
    t(wxSTC_ASN1_IDENTIFIER, ?wxSTC_ASN1_IDENTIFIER),
    t(wxSTC_ASN1_COMMENT, ?wxSTC_ASN1_COMMENT),
    t(wxSTC_ASN1_DEFAULT, ?wxSTC_ASN1_DEFAULT),
    t(wxSTC_SH_HERE_Q, ?wxSTC_SH_HERE_Q),
    t(wxSTC_SH_HERE_DELIM, ?wxSTC_SH_HERE_DELIM),
    t(wxSTC_SH_BACKTICKS, ?wxSTC_SH_BACKTICKS),
    t(wxSTC_SH_PARAM, ?wxSTC_SH_PARAM),
    t(wxSTC_SH_SCALAR, ?wxSTC_SH_SCALAR),
    t(wxSTC_SH_IDENTIFIER, ?wxSTC_SH_IDENTIFIER),
    t(wxSTC_SH_OPERATOR, ?wxSTC_SH_OPERATOR),
    t(wxSTC_SH_CHARACTER, ?wxSTC_SH_CHARACTER),
    t(wxSTC_SH_STRING, ?wxSTC_SH_STRING),
    t(wxSTC_SH_WORD, ?wxSTC_SH_WORD),
    t(wxSTC_SH_NUMBER, ?wxSTC_SH_NUMBER),
    t(wxSTC_SH_COMMENTLINE, ?wxSTC_SH_COMMENTLINE),
    t(wxSTC_SH_ERROR, ?wxSTC_SH_ERROR),
    t(wxSTC_SH_DEFAULT, ?wxSTC_SH_DEFAULT),
    t(wxSTC_APDL_FUNCTION, ?wxSTC_APDL_FUNCTION),
    t(wxSTC_APDL_ARGUMENT, ?wxSTC_APDL_ARGUMENT),
    t(wxSTC_APDL_STARCOMMAND, ?wxSTC_APDL_STARCOMMAND),
    t(wxSTC_APDL_SLASHCOMMAND, ?wxSTC_APDL_SLASHCOMMAND),
    t(wxSTC_APDL_COMMAND, ?wxSTC_APDL_COMMAND),
    t(wxSTC_APDL_PROCESSOR, ?wxSTC_APDL_PROCESSOR),
    t(wxSTC_APDL_WORD, ?wxSTC_APDL_WORD),
    t(wxSTC_APDL_OPERATOR, ?wxSTC_APDL_OPERATOR),
    t(wxSTC_APDL_STRING, ?wxSTC_APDL_STRING),
    t(wxSTC_APDL_NUMBER, ?wxSTC_APDL_NUMBER),
    t(wxSTC_APDL_COMMENTBLOCK, ?wxSTC_APDL_COMMENTBLOCK),
    t(wxSTC_APDL_COMMENT, ?wxSTC_APDL_COMMENT),
    t(wxSTC_APDL_DEFAULT, ?wxSTC_APDL_DEFAULT),
    t(wxSTC_AU3_UDF, ?wxSTC_AU3_UDF),
    t(wxSTC_AU3_COMOBJ, ?wxSTC_AU3_COMOBJ),
    t(wxSTC_AU3_EXPAND, ?wxSTC_AU3_EXPAND),
    t(wxSTC_AU3_SPECIAL, ?wxSTC_AU3_SPECIAL),
    t(wxSTC_AU3_PREPROCESSOR, ?wxSTC_AU3_PREPROCESSOR),
    t(wxSTC_AU3_SENT, ?wxSTC_AU3_SENT),
    t(wxSTC_AU3_VARIABLE, ?wxSTC_AU3_VARIABLE),
    t(wxSTC_AU3_OPERATOR, ?wxSTC_AU3_OPERATOR),
    t(wxSTC_AU3_STRING, ?wxSTC_AU3_STRING),
    t(wxSTC_AU3_MACRO, ?wxSTC_AU3_MACRO),
    t(wxSTC_AU3_KEYWORD, ?wxSTC_AU3_KEYWORD),
    t(wxSTC_AU3_FUNCTION, ?wxSTC_AU3_FUNCTION),
    t(wxSTC_AU3_NUMBER, ?wxSTC_AU3_NUMBER),
    t(wxSTC_AU3_COMMENTBLOCK, ?wxSTC_AU3_COMMENTBLOCK),
    t(wxSTC_AU3_COMMENT, ?wxSTC_AU3_COMMENT),
    t(wxSTC_AU3_DEFAULT, ?wxSTC_AU3_DEFAULT),
    t(wxSTC_SN_USER, ?wxSTC_SN_USER),
    t(wxSTC_SN_SIGNAL, ?wxSTC_SN_SIGNAL),
    t(wxSTC_SN_REGEXTAG, ?wxSTC_SN_REGEXTAG),
    t(wxSTC_SN_STRINGEOL, ?wxSTC_SN_STRINGEOL),
    t(wxSTC_SN_IDENTIFIER, ?wxSTC_SN_IDENTIFIER),
    t(wxSTC_SN_OPERATOR, ?wxSTC_SN_OPERATOR),
    t(wxSTC_SN_PREPROCESSOR, ?wxSTC_SN_PREPROCESSOR),
    t(wxSTC_SN_WORD3, ?wxSTC_SN_WORD3),
    t(wxSTC_SN_WORD2, ?wxSTC_SN_WORD2),
    t(wxSTC_SN_STRING, ?wxSTC_SN_STRING),
    t(wxSTC_SN_WORD, ?wxSTC_SN_WORD),
    t(wxSTC_SN_NUMBER, ?wxSTC_SN_NUMBER),
    t(wxSTC_SN_COMMENTLINEBANG, ?wxSTC_SN_COMMENTLINEBANG),
    t(wxSTC_SN_COMMENTLINE, ?wxSTC_SN_COMMENTLINE),
    t(wxSTC_SN_CODE, ?wxSTC_SN_CODE),
    t(wxSTC_SN_DEFAULT, ?wxSTC_SN_DEFAULT),
    t(wxSTC_GC_OPERATOR, ?wxSTC_GC_OPERATOR),
    t(wxSTC_GC_STRING, ?wxSTC_GC_STRING),
    t(wxSTC_GC_COMMAND, ?wxSTC_GC_COMMAND),
    t(wxSTC_GC_CONTROL, ?wxSTC_GC_CONTROL),
    t(wxSTC_GC_ATTRIBUTE, ?wxSTC_GC_ATTRIBUTE),
    t(wxSTC_GC_EVENT, ?wxSTC_GC_EVENT),
    t(wxSTC_GC_GLOBAL, ?wxSTC_GC_GLOBAL),
    t(wxSTC_GC_COMMENTBLOCK, ?wxSTC_GC_COMMENTBLOCK),
    t(wxSTC_GC_COMMENTLINE, ?wxSTC_GC_COMMENTLINE),
    t(wxSTC_GC_DEFAULT, ?wxSTC_GC_DEFAULT),
    t(wxSTC_KIX_IDENTIFIER, ?wxSTC_KIX_IDENTIFIER),
    t(wxSTC_KIX_COMMENTSTREAM, ?wxSTC_KIX_COMMENTSTREAM),
    t(wxSTC_KIX_OPERATOR, ?wxSTC_KIX_OPERATOR),
    t(wxSTC_KIX_FUNCTIONS, ?wxSTC_KIX_FUNCTIONS),
    t(wxSTC_KIX_KEYWORD, ?wxSTC_KIX_KEYWORD),
    t(wxSTC_KIX_MACRO, ?wxSTC_KIX_MACRO),
    t(wxSTC_KIX_VAR, ?wxSTC_KIX_VAR),
    t(wxSTC_KIX_NUMBER, ?wxSTC_KIX_NUMBER),
    t(wxSTC_KIX_STRING2, ?wxSTC_KIX_STRING2),
    t(wxSTC_KIX_STRING1, ?wxSTC_KIX_STRING1),
    t(wxSTC_KIX_COMMENT, ?wxSTC_KIX_COMMENT),
    t(wxSTC_KIX_DEFAULT, ?wxSTC_KIX_DEFAULT),
    t(wxSTC_V_PORT_CONNECT, ?wxSTC_V_PORT_CONNECT),
    t(wxSTC_V_INOUT, ?wxSTC_V_INOUT),
    t(wxSTC_V_OUTPUT, ?wxSTC_V_OUTPUT),
    t(wxSTC_V_INPUT, ?wxSTC_V_INPUT),
    t(wxSTC_V_COMMENT_WORD, ?wxSTC_V_COMMENT_WORD),
    t(wxSTC_V_USER, ?wxSTC_V_USER),
    t(wxSTC_V_STRINGEOL, ?wxSTC_V_STRINGEOL),
    t(wxSTC_V_IDENTIFIER, ?wxSTC_V_IDENTIFIER),
    t(wxSTC_V_OPERATOR, ?wxSTC_V_OPERATOR),
    t(wxSTC_V_PREPROCESSOR, ?wxSTC_V_PREPROCESSOR),
    t(wxSTC_V_WORD3, ?wxSTC_V_WORD3),
    t(wxSTC_V_WORD2, ?wxSTC_V_WORD2),
    t(wxSTC_V_STRING, ?wxSTC_V_STRING),
    t(wxSTC_V_WORD, ?wxSTC_V_WORD),
    t(wxSTC_V_NUMBER, ?wxSTC_V_NUMBER),
    t(wxSTC_V_COMMENTLINEBANG, ?wxSTC_V_COMMENTLINEBANG),
    t(wxSTC_V_COMMENTLINE, ?wxSTC_V_COMMENTLINE),
    t(wxSTC_V_COMMENT, ?wxSTC_V_COMMENT),
    t(wxSTC_V_DEFAULT, ?wxSTC_V_DEFAULT),
    t(wxSTC_MSSQL_COLUMN_NAME_2, ?wxSTC_MSSQL_COLUMN_NAME_2),
    t(wxSTC_MSSQL_DEFAULT_PREF_DATATYPE, ?wxSTC_MSSQL_DEFAULT_PREF_DATATYPE),
    t(wxSTC_MSSQL_STORED_PROCEDURE, ?wxSTC_MSSQL_STORED_PROCEDURE),
    t(wxSTC_MSSQL_FUNCTION, ?wxSTC_MSSQL_FUNCTION),
    t(wxSTC_MSSQL_GLOBAL_VARIABLE, ?wxSTC_MSSQL_GLOBAL_VARIABLE),
    t(wxSTC_MSSQL_SYSTABLE, ?wxSTC_MSSQL_SYSTABLE),
    t(wxSTC_MSSQL_DATATYPE, ?wxSTC_MSSQL_DATATYPE),
    t(wxSTC_MSSQL_STATEMENT, ?wxSTC_MSSQL_STATEMENT),
    t(wxSTC_MSSQL_COLUMN_NAME, ?wxSTC_MSSQL_COLUMN_NAME),
    t(wxSTC_MSSQL_VARIABLE, ?wxSTC_MSSQL_VARIABLE),
    t(wxSTC_MSSQL_IDENTIFIER, ?wxSTC_MSSQL_IDENTIFIER),
    t(wxSTC_MSSQL_OPERATOR, ?wxSTC_MSSQL_OPERATOR),
    t(wxSTC_MSSQL_STRING, ?wxSTC_MSSQL_STRING),
    t(wxSTC_MSSQL_NUMBER, ?wxSTC_MSSQL_NUMBER),
    t(wxSTC_MSSQL_LINE_COMMENT, ?wxSTC_MSSQL_LINE_COMMENT),
    t(wxSTC_MSSQL_COMMENT, ?wxSTC_MSSQL_COMMENT),
    t(wxSTC_MSSQL_DEFAULT, ?wxSTC_MSSQL_DEFAULT),
    t(wxSTC_ERLANG_UNKNOWN, ?wxSTC_ERLANG_UNKNOWN),
    t(wxSTC_ERLANG_MODULES_ATT, ?wxSTC_ERLANG_MODULES_ATT),
    t(wxSTC_ERLANG_MODULES, ?wxSTC_ERLANG_MODULES),
    t(wxSTC_ERLANG_BIFS, ?wxSTC_ERLANG_BIFS),
    t(wxSTC_ERLANG_NODE_NAME_QUOTED, ?wxSTC_ERLANG_NODE_NAME_QUOTED),
    t(wxSTC_ERLANG_RECORD_QUOTED, ?wxSTC_ERLANG_RECORD_QUOTED),
    t(wxSTC_ERLANG_MACRO_QUOTED, ?wxSTC_ERLANG_MACRO_QUOTED),
    t(wxSTC_ERLANG_ATOM_QUOTED, ?wxSTC_ERLANG_ATOM_QUOTED),
    t(wxSTC_ERLANG_COMMENT_DOC_MACRO, ?wxSTC_ERLANG_COMMENT_DOC_MACRO),
    t(wxSTC_ERLANG_COMMENT_DOC, ?wxSTC_ERLANG_COMMENT_DOC),
    t(wxSTC_ERLANG_COMMENT_MODULE, ?wxSTC_ERLANG_COMMENT_MODULE),
    t(wxSTC_ERLANG_COMMENT_FUNCTION, ?wxSTC_ERLANG_COMMENT_FUNCTION),
    t(wxSTC_ERLANG_NODE_NAME, ?wxSTC_ERLANG_NODE_NAME),
    t(wxSTC_ERLANG_PREPROC, ?wxSTC_ERLANG_PREPROC),
    t(wxSTC_ERLANG_RECORD, ?wxSTC_ERLANG_RECORD),
    t(wxSTC_ERLANG_MACRO, ?wxSTC_ERLANG_MACRO),
    t(wxSTC_ERLANG_CHARACTER, ?wxSTC_ERLANG_CHARACTER),
    t(wxSTC_ERLANG_FUNCTION_NAME, ?wxSTC_ERLANG_FUNCTION_NAME),
    t(wxSTC_ERLANG_ATOM, ?wxSTC_ERLANG_ATOM),
    t(wxSTC_ERLANG_OPERATOR, ?wxSTC_ERLANG_OPERATOR),
    t(wxSTC_ERLANG_STRING, ?wxSTC_ERLANG_STRING),
    t(wxSTC_ERLANG_KEYWORD, ?wxSTC_ERLANG_KEYWORD),
    t(wxSTC_ERLANG_NUMBER, ?wxSTC_ERLANG_NUMBER),
    t(wxSTC_ERLANG_VARIABLE, ?wxSTC_ERLANG_VARIABLE),
    t(wxSTC_ERLANG_COMMENT, ?wxSTC_ERLANG_COMMENT),
    t(wxSTC_ERLANG_DEFAULT, ?wxSTC_ERLANG_DEFAULT),
    t(wxSTC_METAPOST_EXTRA, ?wxSTC_METAPOST_EXTRA),
    t(wxSTC_METAPOST_TEXT, ?wxSTC_METAPOST_TEXT),
    t(wxSTC_METAPOST_COMMAND, ?wxSTC_METAPOST_COMMAND),
    t(wxSTC_METAPOST_SYMBOL, ?wxSTC_METAPOST_SYMBOL),
    t(wxSTC_METAPOST_GROUP, ?wxSTC_METAPOST_GROUP),
    t(wxSTC_METAPOST_SPECIAL, ?wxSTC_METAPOST_SPECIAL),
    t(wxSTC_METAPOST_DEFAULT, ?wxSTC_METAPOST_DEFAULT),
    t(wxSTC_TEX_TEXT, ?wxSTC_TEX_TEXT),
    t(wxSTC_TEX_COMMAND, ?wxSTC_TEX_COMMAND),
    t(wxSTC_TEX_SYMBOL, ?wxSTC_TEX_SYMBOL),
    t(wxSTC_TEX_GROUP, ?wxSTC_TEX_GROUP),
    t(wxSTC_TEX_SPECIAL, ?wxSTC_TEX_SPECIAL),
    t(wxSTC_TEX_DEFAULT, ?wxSTC_TEX_DEFAULT),
    t(wxSTC_YAML_OPERATOR, ?wxSTC_YAML_OPERATOR),
    t(wxSTC_YAML_ERROR, ?wxSTC_YAML_ERROR),
    t(wxSTC_YAML_TEXT, ?wxSTC_YAML_TEXT),
    t(wxSTC_YAML_DOCUMENT, ?wxSTC_YAML_DOCUMENT),
    t(wxSTC_YAML_REFERENCE, ?wxSTC_YAML_REFERENCE),
    t(wxSTC_YAML_NUMBER, ?wxSTC_YAML_NUMBER),
    t(wxSTC_YAML_KEYWORD, ?wxSTC_YAML_KEYWORD),
    t(wxSTC_YAML_IDENTIFIER, ?wxSTC_YAML_IDENTIFIER),
    t(wxSTC_YAML_COMMENT, ?wxSTC_YAML_COMMENT),
    t(wxSTC_YAML_DEFAULT, ?wxSTC_YAML_DEFAULT),
    t(wxSTC_LOT_ABORT, ?wxSTC_LOT_ABORT),
    t(wxSTC_LOT_FAIL, ?wxSTC_LOT_FAIL),
    t(wxSTC_LOT_PASS, ?wxSTC_LOT_PASS),
    t(wxSTC_LOT_SET, ?wxSTC_LOT_SET),
    t(wxSTC_LOT_BREAK, ?wxSTC_LOT_BREAK),
    t(wxSTC_LOT_HEADER, ?wxSTC_LOT_HEADER),
    t(wxSTC_LOT_DEFAULT, ?wxSTC_LOT_DEFAULT),
    t(wxSTC_CLW_DEPRECATED, ?wxSTC_CLW_DEPRECATED),
    t(wxSTC_CLW_ERROR, ?wxSTC_CLW_ERROR),
    t(wxSTC_CLW_STANDARD_EQUATE, ?wxSTC_CLW_STANDARD_EQUATE),
    t(wxSTC_CLW_ATTRIBUTE, ?wxSTC_CLW_ATTRIBUTE),
    t(wxSTC_CLW_STRUCTURE_DATA_TYPE, ?wxSTC_CLW_STRUCTURE_DATA_TYPE),
    t(wxSTC_CLW_BUILTIN_PROCEDURES_FUNCTION, ?wxSTC_CLW_BUILTIN_PROCEDURES_FUNCTION),
    t(wxSTC_CLW_RUNTIME_EXPRESSIONS, ?wxSTC_CLW_RUNTIME_EXPRESSIONS),
    t(wxSTC_CLW_COMPILER_DIRECTIVE, ?wxSTC_CLW_COMPILER_DIRECTIVE),
    t(wxSTC_CLW_KEYWORD, ?wxSTC_CLW_KEYWORD),
    t(wxSTC_CLW_PICTURE_STRING, ?wxSTC_CLW_PICTURE_STRING),
    t(wxSTC_CLW_REAL_CONSTANT, ?wxSTC_CLW_REAL_CONSTANT),
    t(wxSTC_CLW_INTEGER_CONSTANT, ?wxSTC_CLW_INTEGER_CONSTANT),
    t(wxSTC_CLW_USER_IDENTIFIER, ?wxSTC_CLW_USER_IDENTIFIER),
    t(wxSTC_CLW_STRING, ?wxSTC_CLW_STRING),
    t(wxSTC_CLW_COMMENT, ?wxSTC_CLW_COMMENT),
    t(wxSTC_CLW_LABEL, ?wxSTC_CLW_LABEL),
    t(wxSTC_CLW_DEFAULT, ?wxSTC_CLW_DEFAULT),
    t(wxSTC_MMIXAL_INCLUDE, ?wxSTC_MMIXAL_INCLUDE),
    t(wxSTC_MMIXAL_SYMBOL, ?wxSTC_MMIXAL_SYMBOL),
    t(wxSTC_MMIXAL_OPERATOR, ?wxSTC_MMIXAL_OPERATOR),
    t(wxSTC_MMIXAL_HEX, ?wxSTC_MMIXAL_HEX),
    t(wxSTC_MMIXAL_REGISTER, ?wxSTC_MMIXAL_REGISTER),
    t(wxSTC_MMIXAL_STRING, ?wxSTC_MMIXAL_STRING),
    t(wxSTC_MMIXAL_CHAR, ?wxSTC_MMIXAL_CHAR),
    t(wxSTC_MMIXAL_REF, ?wxSTC_MMIXAL_REF),
    t(wxSTC_MMIXAL_NUMBER, ?wxSTC_MMIXAL_NUMBER),
    t(wxSTC_MMIXAL_OPERANDS, ?wxSTC_MMIXAL_OPERANDS),
    t(wxSTC_MMIXAL_OPCODE_POST, ?wxSTC_MMIXAL_OPCODE_POST),
    t(wxSTC_MMIXAL_OPCODE_UNKNOWN, ?wxSTC_MMIXAL_OPCODE_UNKNOWN),
    t(wxSTC_MMIXAL_OPCODE_VALID, ?wxSTC_MMIXAL_OPCODE_VALID),
    t(wxSTC_MMIXAL_OPCODE_PRE, ?wxSTC_MMIXAL_OPCODE_PRE),
    t(wxSTC_MMIXAL_OPCODE, ?wxSTC_MMIXAL_OPCODE),
    t(wxSTC_MMIXAL_LABEL, ?wxSTC_MMIXAL_LABEL),
    t(wxSTC_MMIXAL_COMMENT, ?wxSTC_MMIXAL_COMMENT),
    t(wxSTC_MMIXAL_LEADWS, ?wxSTC_MMIXAL_LEADWS),
    t(wxSTC_NSIS_COMMENTBOX, ?wxSTC_NSIS_COMMENTBOX),
    t(wxSTC_NSIS_FUNCTIONDEF, ?wxSTC_NSIS_FUNCTIONDEF),
    t(wxSTC_NSIS_PAGEEX, ?wxSTC_NSIS_PAGEEX),
    t(wxSTC_NSIS_SECTIONGROUP, ?wxSTC_NSIS_SECTIONGROUP),
    t(wxSTC_NSIS_NUMBER, ?wxSTC_NSIS_NUMBER),
    t(wxSTC_NSIS_STRINGVAR, ?wxSTC_NSIS_STRINGVAR),
    t(wxSTC_NSIS_MACRODEF, ?wxSTC_NSIS_MACRODEF),
    t(wxSTC_NSIS_IFDEFINEDEF, ?wxSTC_NSIS_IFDEFINEDEF),
    t(wxSTC_NSIS_SUBSECTIONDEF, ?wxSTC_NSIS_SUBSECTIONDEF),
    t(wxSTC_NSIS_SECTIONDEF, ?wxSTC_NSIS_SECTIONDEF),
    t(wxSTC_NSIS_USERDEFINED, ?wxSTC_NSIS_USERDEFINED),
    t(wxSTC_NSIS_LABEL, ?wxSTC_NSIS_LABEL),
    t(wxSTC_NSIS_VARIABLE, ?wxSTC_NSIS_VARIABLE),
    t(wxSTC_NSIS_FUNCTION, ?wxSTC_NSIS_FUNCTION),
    t(wxSTC_NSIS_STRINGRQ, ?wxSTC_NSIS_STRINGRQ),
    t(wxSTC_NSIS_STRINGLQ, ?wxSTC_NSIS_STRINGLQ),
    t(wxSTC_NSIS_STRINGDQ, ?wxSTC_NSIS_STRINGDQ),
    t(wxSTC_NSIS_COMMENT, ?wxSTC_NSIS_COMMENT),
    t(wxSTC_NSIS_DEFAULT, ?wxSTC_NSIS_DEFAULT),
    t(wxSTC_PS_BADSTRINGCHAR, ?wxSTC_PS_BADSTRINGCHAR),
    t(wxSTC_PS_BASE85STRING, ?wxSTC_PS_BASE85STRING),
    t(wxSTC_PS_HEXSTRING, ?wxSTC_PS_HEXSTRING),
    t(wxSTC_PS_TEXT, ?wxSTC_PS_TEXT),
    t(wxSTC_PS_PAREN_PROC, ?wxSTC_PS_PAREN_PROC),
    t(wxSTC_PS_PAREN_DICT, ?wxSTC_PS_PAREN_DICT),
    t(wxSTC_PS_PAREN_ARRAY, ?wxSTC_PS_PAREN_ARRAY),
    t(wxSTC_PS_IMMEVAL, ?wxSTC_PS_IMMEVAL),
    t(wxSTC_PS_LITERAL, ?wxSTC_PS_LITERAL),
    t(wxSTC_PS_KEYWORD, ?wxSTC_PS_KEYWORD),
    t(wxSTC_PS_NAME, ?wxSTC_PS_NAME),
    t(wxSTC_PS_NUMBER, ?wxSTC_PS_NUMBER),
    t(wxSTC_PS_DSC_VALUE, ?wxSTC_PS_DSC_VALUE),
    t(wxSTC_PS_DSC_COMMENT, ?wxSTC_PS_DSC_COMMENT),
    t(wxSTC_PS_COMMENT, ?wxSTC_PS_COMMENT),
    t(wxSTC_PS_DEFAULT, ?wxSTC_PS_DEFAULT),
    t(wxSTC_ESCRIPT_WORD3, ?wxSTC_ESCRIPT_WORD3),
    t(wxSTC_ESCRIPT_WORD2, ?wxSTC_ESCRIPT_WORD2),
    t(wxSTC_ESCRIPT_BRACE, ?wxSTC_ESCRIPT_BRACE),
    t(wxSTC_ESCRIPT_IDENTIFIER, ?wxSTC_ESCRIPT_IDENTIFIER),
    t(wxSTC_ESCRIPT_OPERATOR, ?wxSTC_ESCRIPT_OPERATOR),
    t(wxSTC_ESCRIPT_STRING, ?wxSTC_ESCRIPT_STRING),
    t(wxSTC_ESCRIPT_WORD, ?wxSTC_ESCRIPT_WORD),
    t(wxSTC_ESCRIPT_NUMBER, ?wxSTC_ESCRIPT_NUMBER),
    t(wxSTC_ESCRIPT_COMMENTDOC, ?wxSTC_ESCRIPT_COMMENTDOC),
    t(wxSTC_ESCRIPT_COMMENTLINE, ?wxSTC_ESCRIPT_COMMENTLINE),
    t(wxSTC_ESCRIPT_COMMENT, ?wxSTC_ESCRIPT_COMMENT),
    t(wxSTC_ESCRIPT_DEFAULT, ?wxSTC_ESCRIPT_DEFAULT),
    t(wxSTC_LOUT_STRINGEOL, ?wxSTC_LOUT_STRINGEOL),
    t(wxSTC_LOUT_IDENTIFIER, ?wxSTC_LOUT_IDENTIFIER),
    t(wxSTC_LOUT_OPERATOR, ?wxSTC_LOUT_OPERATOR),
    t(wxSTC_LOUT_STRING, ?wxSTC_LOUT_STRING),
    t(wxSTC_LOUT_WORD4, ?wxSTC_LOUT_WORD4),
    t(wxSTC_LOUT_WORD3, ?wxSTC_LOUT_WORD3),
    t(wxSTC_LOUT_WORD2, ?wxSTC_LOUT_WORD2),
    t(wxSTC_LOUT_WORD, ?wxSTC_LOUT_WORD),
    t(wxSTC_LOUT_NUMBER, ?wxSTC_LOUT_NUMBER),
    t(wxSTC_LOUT_COMMENT, ?wxSTC_LOUT_COMMENT),
    t(wxSTC_LOUT_DEFAULT, ?wxSTC_LOUT_DEFAULT),
    t(wxSTC_POV_WORD8, ?wxSTC_POV_WORD8),
    t(wxSTC_POV_WORD7, ?wxSTC_POV_WORD7),
    t(wxSTC_POV_WORD6, ?wxSTC_POV_WORD6),
    t(wxSTC_POV_WORD5, ?wxSTC_POV_WORD5),
    t(wxSTC_POV_WORD4, ?wxSTC_POV_WORD4),
    t(wxSTC_POV_WORD3, ?wxSTC_POV_WORD3),
    t(wxSTC_POV_WORD2, ?wxSTC_POV_WORD2),
    t(wxSTC_POV_BADDIRECTIVE, ?wxSTC_POV_BADDIRECTIVE),
    t(wxSTC_POV_DIRECTIVE, ?wxSTC_POV_DIRECTIVE),
    t(wxSTC_POV_STRINGEOL, ?wxSTC_POV_STRINGEOL),
    t(wxSTC_POV_STRING, ?wxSTC_POV_STRING),
    t(wxSTC_POV_IDENTIFIER, ?wxSTC_POV_IDENTIFIER),
    t(wxSTC_POV_OPERATOR, ?wxSTC_POV_OPERATOR),
    t(wxSTC_POV_NUMBER, ?wxSTC_POV_NUMBER),
    t(wxSTC_POV_COMMENTLINE, ?wxSTC_POV_COMMENTLINE),
    t(wxSTC_POV_COMMENT, ?wxSTC_POV_COMMENT),
    t(wxSTC_POV_DEFAULT, ?wxSTC_POV_DEFAULT),
    t(wxSTC_CSS_VARIABLE, ?wxSTC_CSS_VARIABLE),
    t(wxSTC_CSS_MEDIA, ?wxSTC_CSS_MEDIA),
    t(wxSTC_CSS_EXTENDED_PSEUDOELEMENT, ?wxSTC_CSS_EXTENDED_PSEUDOELEMENT),
    t(wxSTC_CSS_EXTENDED_PSEUDOCLASS, ?wxSTC_CSS_EXTENDED_PSEUDOCLASS),
    t(wxSTC_CSS_EXTENDED_IDENTIFIER, ?wxSTC_CSS_EXTENDED_IDENTIFIER),
    t(wxSTC_CSS_PSEUDOELEMENT, ?wxSTC_CSS_PSEUDOELEMENT),
    t(wxSTC_CSS_IDENTIFIER3, ?wxSTC_CSS_IDENTIFIER3),
    t(wxSTC_CSS_ATTRIBUTE, ?wxSTC_CSS_ATTRIBUTE),
    t(wxSTC_CSS_IDENTIFIER2, ?wxSTC_CSS_IDENTIFIER2),
    t(wxSTC_CSS_SINGLESTRING, ?wxSTC_CSS_SINGLESTRING),
    t(wxSTC_CSS_DOUBLESTRING, ?wxSTC_CSS_DOUBLESTRING),
    t(wxSTC_CSS_DIRECTIVE, ?wxSTC_CSS_DIRECTIVE),
    t(wxSTC_CSS_IMPORTANT, ?wxSTC_CSS_IMPORTANT),
    t(wxSTC_CSS_ID, ?wxSTC_CSS_ID),
    t(wxSTC_CSS_COMMENT, ?wxSTC_CSS_COMMENT),
    t(wxSTC_CSS_VALUE, ?wxSTC_CSS_VALUE),
    t(wxSTC_CSS_UNKNOWN_IDENTIFIER, ?wxSTC_CSS_UNKNOWN_IDENTIFIER),
    t(wxSTC_CSS_IDENTIFIER, ?wxSTC_CSS_IDENTIFIER),
    t(wxSTC_CSS_OPERATOR, ?wxSTC_CSS_OPERATOR),
    t(wxSTC_CSS_UNKNOWN_PSEUDOCLASS, ?wxSTC_CSS_UNKNOWN_PSEUDOCLASS),
    t(wxSTC_CSS_PSEUDOCLASS, ?wxSTC_CSS_PSEUDOCLASS),
    t(wxSTC_CSS_CLASS, ?wxSTC_CSS_CLASS),
    t(wxSTC_CSS_TAG, ?wxSTC_CSS_TAG),
    t(wxSTC_CSS_DEFAULT, ?wxSTC_CSS_DEFAULT),
    t(wxSTC_F_CONTINUATION, ?wxSTC_F_CONTINUATION),
    t(wxSTC_F_LABEL, ?wxSTC_F_LABEL),
    t(wxSTC_F_OPERATOR2, ?wxSTC_F_OPERATOR2),
    t(wxSTC_F_PREPROCESSOR, ?wxSTC_F_PREPROCESSOR),
    t(wxSTC_F_WORD3, ?wxSTC_F_WORD3),
    t(wxSTC_F_WORD2, ?wxSTC_F_WORD2),
    t(wxSTC_F_WORD, ?wxSTC_F_WORD),
    t(wxSTC_F_IDENTIFIER, ?wxSTC_F_IDENTIFIER),
    t(wxSTC_F_OPERATOR, ?wxSTC_F_OPERATOR),
    t(wxSTC_F_STRINGEOL, ?wxSTC_F_STRINGEOL),
    t(wxSTC_F_STRING2, ?wxSTC_F_STRING2),
    t(wxSTC_F_STRING1, ?wxSTC_F_STRING1),
    t(wxSTC_F_NUMBER, ?wxSTC_F_NUMBER),
    t(wxSTC_F_COMMENT, ?wxSTC_F_COMMENT),
    t(wxSTC_F_DEFAULT, ?wxSTC_F_DEFAULT),
    t(wxSTC_ASM_COMMENTDIRECTIVE, ?wxSTC_ASM_COMMENTDIRECTIVE),
    t(wxSTC_ASM_EXTINSTRUCTION, ?wxSTC_ASM_EXTINSTRUCTION),
    t(wxSTC_ASM_STRINGEOL, ?wxSTC_ASM_STRINGEOL),
    t(wxSTC_ASM_CHARACTER, ?wxSTC_ASM_CHARACTER),
    t(wxSTC_ASM_COMMENTBLOCK, ?wxSTC_ASM_COMMENTBLOCK),
    t(wxSTC_ASM_DIRECTIVEOPERAND, ?wxSTC_ASM_DIRECTIVEOPERAND),
    t(wxSTC_ASM_DIRECTIVE, ?wxSTC_ASM_DIRECTIVE),
    t(wxSTC_ASM_REGISTER, ?wxSTC_ASM_REGISTER),
    t(wxSTC_ASM_MATHINSTRUCTION, ?wxSTC_ASM_MATHINSTRUCTION),
    t(wxSTC_ASM_CPUINSTRUCTION, ?wxSTC_ASM_CPUINSTRUCTION),
    t(wxSTC_ASM_IDENTIFIER, ?wxSTC_ASM_IDENTIFIER),
    t(wxSTC_ASM_OPERATOR, ?wxSTC_ASM_OPERATOR),
    t(wxSTC_ASM_STRING, ?wxSTC_ASM_STRING),
    t(wxSTC_ASM_NUMBER, ?wxSTC_ASM_NUMBER),
    t(wxSTC_ASM_COMMENT, ?wxSTC_ASM_COMMENT),
    t(wxSTC_ASM_DEFAULT, ?wxSTC_ASM_DEFAULT),
    t(wxSTC_SCRIPTOL_PREPROCESSOR, ?wxSTC_SCRIPTOL_PREPROCESSOR),
    t(wxSTC_SCRIPTOL_CLASSNAME, ?wxSTC_SCRIPTOL_CLASSNAME),
    t(wxSTC_SCRIPTOL_TRIPLE, ?wxSTC_SCRIPTOL_TRIPLE),
    t(wxSTC_SCRIPTOL_IDENTIFIER, ?wxSTC_SCRIPTOL_IDENTIFIER),
    t(wxSTC_SCRIPTOL_OPERATOR, ?wxSTC_SCRIPTOL_OPERATOR),
    t(wxSTC_SCRIPTOL_KEYWORD, ?wxSTC_SCRIPTOL_KEYWORD),
    t(wxSTC_SCRIPTOL_STRINGEOL, ?wxSTC_SCRIPTOL_STRINGEOL),
    t(wxSTC_SCRIPTOL_CHARACTER, ?wxSTC_SCRIPTOL_CHARACTER),
    t(wxSTC_SCRIPTOL_STRING, ?wxSTC_SCRIPTOL_STRING),
    t(wxSTC_SCRIPTOL_NUMBER, ?wxSTC_SCRIPTOL_NUMBER),
    t(wxSTC_SCRIPTOL_COMMENTBLOCK, ?wxSTC_SCRIPTOL_COMMENTBLOCK),
    t(wxSTC_SCRIPTOL_CSTYLE, ?wxSTC_SCRIPTOL_CSTYLE),
    t(wxSTC_SCRIPTOL_PERSISTENT, ?wxSTC_SCRIPTOL_PERSISTENT),
    t(wxSTC_SCRIPTOL_COMMENTLINE, ?wxSTC_SCRIPTOL_COMMENTLINE),
    t(wxSTC_SCRIPTOL_WHITE, ?wxSTC_SCRIPTOL_WHITE),
    t(wxSTC_SCRIPTOL_DEFAULT, ?wxSTC_SCRIPTOL_DEFAULT),
    t(wxSTC_MATLAB_DOUBLEQUOTESTRING, ?wxSTC_MATLAB_DOUBLEQUOTESTRING),
    t(wxSTC_MATLAB_IDENTIFIER, ?wxSTC_MATLAB_IDENTIFIER),
    t(wxSTC_MATLAB_OPERATOR, ?wxSTC_MATLAB_OPERATOR),
    t(wxSTC_MATLAB_STRING, ?wxSTC_MATLAB_STRING),
    t(wxSTC_MATLAB_KEYWORD, ?wxSTC_MATLAB_KEYWORD),
    t(wxSTC_MATLAB_NUMBER, ?wxSTC_MATLAB_NUMBER),
    t(wxSTC_MATLAB_COMMAND, ?wxSTC_MATLAB_COMMAND),
    t(wxSTC_MATLAB_COMMENT, ?wxSTC_MATLAB_COMMENT),
    t(wxSTC_MATLAB_DEFAULT, ?wxSTC_MATLAB_DEFAULT),
    t(wxSTC_FORTH_LOCALE, ?wxSTC_FORTH_LOCALE),
    t(wxSTC_FORTH_STRING, ?wxSTC_FORTH_STRING),
    t(wxSTC_FORTH_NUMBER, ?wxSTC_FORTH_NUMBER),
    t(wxSTC_FORTH_PREWORD2, ?wxSTC_FORTH_PREWORD2),
    t(wxSTC_FORTH_PREWORD1, ?wxSTC_FORTH_PREWORD1),
    t(wxSTC_FORTH_DEFWORD, ?wxSTC_FORTH_DEFWORD),
    t(wxSTC_FORTH_KEYWORD, ?wxSTC_FORTH_KEYWORD),
    t(wxSTC_FORTH_CONTROL, ?wxSTC_FORTH_CONTROL),
    t(wxSTC_FORTH_IDENTIFIER, ?wxSTC_FORTH_IDENTIFIER),
    t(wxSTC_FORTH_COMMENT_ML, ?wxSTC_FORTH_COMMENT_ML),
    t(wxSTC_FORTH_COMMENT, ?wxSTC_FORTH_COMMENT),
    t(wxSTC_FORTH_DEFAULT, ?wxSTC_FORTH_DEFAULT),
    t(wxSTC_NNCRONTAB_IDENTIFIER, ?wxSTC_NNCRONTAB_IDENTIFIER),
    t(wxSTC_NNCRONTAB_ENVIRONMENT, ?wxSTC_NNCRONTAB_ENVIRONMENT),
    t(wxSTC_NNCRONTAB_STRING, ?wxSTC_NNCRONTAB_STRING),
    t(wxSTC_NNCRONTAB_NUMBER, ?wxSTC_NNCRONTAB_NUMBER),
    t(wxSTC_NNCRONTAB_ASTERISK, ?wxSTC_NNCRONTAB_ASTERISK),
    t(wxSTC_NNCRONTAB_MODIFIER, ?wxSTC_NNCRONTAB_MODIFIER),
    t(wxSTC_NNCRONTAB_KEYWORD, ?wxSTC_NNCRONTAB_KEYWORD),
    t(wxSTC_NNCRONTAB_SECTION, ?wxSTC_NNCRONTAB_SECTION),
    t(wxSTC_NNCRONTAB_TASK, ?wxSTC_NNCRONTAB_TASK),
    t(wxSTC_NNCRONTAB_COMMENT, ?wxSTC_NNCRONTAB_COMMENT),
    t(wxSTC_NNCRONTAB_DEFAULT, ?wxSTC_NNCRONTAB_DEFAULT),
    t(wxSTC_EIFFEL_STRINGEOL, ?wxSTC_EIFFEL_STRINGEOL),
    t(wxSTC_EIFFEL_IDENTIFIER, ?wxSTC_EIFFEL_IDENTIFIER),
    t(wxSTC_EIFFEL_OPERATOR, ?wxSTC_EIFFEL_OPERATOR),
    t(wxSTC_EIFFEL_CHARACTER, ?wxSTC_EIFFEL_CHARACTER),
    t(wxSTC_EIFFEL_STRING, ?wxSTC_EIFFEL_STRING),
    t(wxSTC_EIFFEL_WORD, ?wxSTC_EIFFEL_WORD),
    t(wxSTC_EIFFEL_NUMBER, ?wxSTC_EIFFEL_NUMBER),
    t(wxSTC_EIFFEL_COMMENTLINE, ?wxSTC_EIFFEL_COMMENTLINE),
    t(wxSTC_EIFFEL_DEFAULT, ?wxSTC_EIFFEL_DEFAULT),
    t(wxSTC_LISP_MULTI_COMMENT, ?wxSTC_LISP_MULTI_COMMENT),
    t(wxSTC_LISP_SPECIAL, ?wxSTC_LISP_SPECIAL),
    t(wxSTC_LISP_OPERATOR, ?wxSTC_LISP_OPERATOR),
    t(wxSTC_LISP_IDENTIFIER, ?wxSTC_LISP_IDENTIFIER),
    t(wxSTC_LISP_STRINGEOL, ?wxSTC_LISP_STRINGEOL),
    t(wxSTC_LISP_STRING, ?wxSTC_LISP_STRING),
    t(wxSTC_LISP_SYMBOL, ?wxSTC_LISP_SYMBOL),
    t(wxSTC_LISP_KEYWORD_KW, ?wxSTC_LISP_KEYWORD_KW),
    t(wxSTC_LISP_KEYWORD, ?wxSTC_LISP_KEYWORD),
    t(wxSTC_LISP_NUMBER, ?wxSTC_LISP_NUMBER),
    t(wxSTC_LISP_COMMENT, ?wxSTC_LISP_COMMENT),
    t(wxSTC_LISP_DEFAULT, ?wxSTC_LISP_DEFAULT),
    t(wxSTC_BAAN_DEFINEDEF, ?wxSTC_BAAN_DEFINEDEF),
    t(wxSTC_BAAN_OBJECTDEF, ?wxSTC_BAAN_OBJECTDEF),
    t(wxSTC_BAAN_FUNCDEF, ?wxSTC_BAAN_FUNCDEF),
    t(wxSTC_BAAN_DOMDEF, ?wxSTC_BAAN_DOMDEF),
    t(wxSTC_BAAN_FUNCTION, ?wxSTC_BAAN_FUNCTION),
    t(wxSTC_BAAN_TABLESQL, ?wxSTC_BAAN_TABLESQL),
    t(wxSTC_BAAN_TABLEDEF, ?wxSTC_BAAN_TABLEDEF),
    t(wxSTC_BAAN_WORD9, ?wxSTC_BAAN_WORD9),
    t(wxSTC_BAAN_WORD8, ?wxSTC_BAAN_WORD8),
    t(wxSTC_BAAN_WORD7, ?wxSTC_BAAN_WORD7),
    t(wxSTC_BAAN_WORD6, ?wxSTC_BAAN_WORD6),
    t(wxSTC_BAAN_WORD5, ?wxSTC_BAAN_WORD5),
    t(wxSTC_BAAN_WORD4, ?wxSTC_BAAN_WORD4),
    t(wxSTC_BAAN_WORD3, ?wxSTC_BAAN_WORD3),
    t(wxSTC_BAAN_WORD2, ?wxSTC_BAAN_WORD2),
    t(wxSTC_BAAN_STRINGEOL, ?wxSTC_BAAN_STRINGEOL),
    t(wxSTC_BAAN_IDENTIFIER, ?wxSTC_BAAN_IDENTIFIER),
    t(wxSTC_BAAN_OPERATOR, ?wxSTC_BAAN_OPERATOR),
    t(wxSTC_BAAN_PREPROCESSOR, ?wxSTC_BAAN_PREPROCESSOR),
    t(wxSTC_BAAN_STRING, ?wxSTC_BAAN_STRING),
    t(wxSTC_BAAN_WORD, ?wxSTC_BAAN_WORD),
    t(wxSTC_BAAN_NUMBER, ?wxSTC_BAAN_NUMBER),
    t(wxSTC_BAAN_COMMENTDOC, ?wxSTC_BAAN_COMMENTDOC),
    t(wxSTC_BAAN_COMMENT, ?wxSTC_BAAN_COMMENT),
    t(wxSTC_BAAN_DEFAULT, ?wxSTC_BAAN_DEFAULT),
    t(wxSTC_ADA_ILLEGAL, ?wxSTC_ADA_ILLEGAL),
    t(wxSTC_ADA_COMMENTLINE, ?wxSTC_ADA_COMMENTLINE),
    t(wxSTC_ADA_LABEL, ?wxSTC_ADA_LABEL),
    t(wxSTC_ADA_STRINGEOL, ?wxSTC_ADA_STRINGEOL),
    t(wxSTC_ADA_STRING, ?wxSTC_ADA_STRING),
    t(wxSTC_ADA_CHARACTEREOL, ?wxSTC_ADA_CHARACTEREOL),
    t(wxSTC_ADA_CHARACTER, ?wxSTC_ADA_CHARACTER),
    t(wxSTC_ADA_DELIMITER, ?wxSTC_ADA_DELIMITER),
    t(wxSTC_ADA_NUMBER, ?wxSTC_ADA_NUMBER),
    t(wxSTC_ADA_IDENTIFIER, ?wxSTC_ADA_IDENTIFIER),
    t(wxSTC_ADA_WORD, ?wxSTC_ADA_WORD),
    t(wxSTC_ADA_DEFAULT, ?wxSTC_ADA_DEFAULT),
    t(wxSTC_AVE_WORD6, ?wxSTC_AVE_WORD6),
    t(wxSTC_AVE_WORD5, ?wxSTC_AVE_WORD5),
    t(wxSTC_AVE_WORD4, ?wxSTC_AVE_WORD4),
    t(wxSTC_AVE_WORD3, ?wxSTC_AVE_WORD3),
    t(wxSTC_AVE_WORD2, ?wxSTC_AVE_WORD2),
    t(wxSTC_AVE_WORD1, ?wxSTC_AVE_WORD1),
    t(wxSTC_AVE_OPERATOR, ?wxSTC_AVE_OPERATOR),
    t(wxSTC_AVE_IDENTIFIER, ?wxSTC_AVE_IDENTIFIER),
    t(wxSTC_AVE_STRINGEOL, ?wxSTC_AVE_STRINGEOL),
    t(wxSTC_AVE_ENUM, ?wxSTC_AVE_ENUM),
    t(wxSTC_AVE_STRING, ?wxSTC_AVE_STRING),
    t(wxSTC_AVE_WORD, ?wxSTC_AVE_WORD),
    t(wxSTC_AVE_NUMBER, ?wxSTC_AVE_NUMBER),
    t(wxSTC_AVE_COMMENT, ?wxSTC_AVE_COMMENT),
    t(wxSTC_AVE_DEFAULT, ?wxSTC_AVE_DEFAULT),
    t(wxSTC_CONF_DIRECTIVE, ?wxSTC_CONF_DIRECTIVE),
    t(wxSTC_CONF_IP, ?wxSTC_CONF_IP),
    t(wxSTC_CONF_OPERATOR, ?wxSTC_CONF_OPERATOR),
    t(wxSTC_CONF_STRING, ?wxSTC_CONF_STRING),
    t(wxSTC_CONF_PARAMETER, ?wxSTC_CONF_PARAMETER),
    t(wxSTC_CONF_EXTENSION, ?wxSTC_CONF_EXTENSION),
    t(wxSTC_CONF_IDENTIFIER, ?wxSTC_CONF_IDENTIFIER),
    t(wxSTC_CONF_NUMBER, ?wxSTC_CONF_NUMBER),
    t(wxSTC_CONF_COMMENT, ?wxSTC_CONF_COMMENT),
    t(wxSTC_CONF_DEFAULT, ?wxSTC_CONF_DEFAULT),
    t(wxSTC_DIFF_CHANGED, ?wxSTC_DIFF_CHANGED),
    t(wxSTC_DIFF_ADDED, ?wxSTC_DIFF_ADDED),
    t(wxSTC_DIFF_DELETED, ?wxSTC_DIFF_DELETED),
    t(wxSTC_DIFF_POSITION, ?wxSTC_DIFF_POSITION),
    t(wxSTC_DIFF_HEADER, ?wxSTC_DIFF_HEADER),
    t(wxSTC_DIFF_COMMAND, ?wxSTC_DIFF_COMMAND),
    t(wxSTC_DIFF_COMMENT, ?wxSTC_DIFF_COMMENT),
    t(wxSTC_DIFF_DEFAULT, ?wxSTC_DIFF_DEFAULT),
    t(wxSTC_MAKE_IDEOL, ?wxSTC_MAKE_IDEOL),
    t(wxSTC_MAKE_TARGET, ?wxSTC_MAKE_TARGET),
    t(wxSTC_MAKE_OPERATOR, ?wxSTC_MAKE_OPERATOR),
    t(wxSTC_MAKE_IDENTIFIER, ?wxSTC_MAKE_IDENTIFIER),
    t(wxSTC_MAKE_PREPROCESSOR, ?wxSTC_MAKE_PREPROCESSOR),
    t(wxSTC_MAKE_COMMENT, ?wxSTC_MAKE_COMMENT),
    t(wxSTC_MAKE_DEFAULT, ?wxSTC_MAKE_DEFAULT),
    t(wxSTC_TCMD_CLABEL, ?wxSTC_TCMD_CLABEL),
    t(wxSTC_TCMD_EXPANSION, ?wxSTC_TCMD_EXPANSION),
    t(wxSTC_TCMD_ENVIRONMENT, ?wxSTC_TCMD_ENVIRONMENT),
    t(wxSTC_TCMD_OPERATOR, ?wxSTC_TCMD_OPERATOR),
    t(wxSTC_TCMD_IDENTIFIER, ?wxSTC_TCMD_IDENTIFIER),
    t(wxSTC_TCMD_COMMAND, ?wxSTC_TCMD_COMMAND),
    t(wxSTC_TCMD_HIDE, ?wxSTC_TCMD_HIDE),
    t(wxSTC_TCMD_LABEL, ?wxSTC_TCMD_LABEL),
    t(wxSTC_TCMD_WORD, ?wxSTC_TCMD_WORD),
    t(wxSTC_TCMD_COMMENT, ?wxSTC_TCMD_COMMENT),
    t(wxSTC_TCMD_DEFAULT, ?wxSTC_TCMD_DEFAULT),
    t(wxSTC_BAT_OPERATOR, ?wxSTC_BAT_OPERATOR),
    t(wxSTC_BAT_IDENTIFIER, ?wxSTC_BAT_IDENTIFIER),
    t(wxSTC_BAT_COMMAND, ?wxSTC_BAT_COMMAND),
    t(wxSTC_BAT_HIDE, ?wxSTC_BAT_HIDE),
    t(wxSTC_BAT_LABEL, ?wxSTC_BAT_LABEL),
    t(wxSTC_BAT_WORD, ?wxSTC_BAT_WORD),
    t(wxSTC_BAT_COMMENT, ?wxSTC_BAT_COMMENT),
    t(wxSTC_BAT_DEFAULT, ?wxSTC_BAT_DEFAULT),
    t(wxSTC_ERR_ES_WHITE, ?wxSTC_ERR_ES_WHITE),
    t(wxSTC_ERR_ES_BRIGHT_CYAN, ?wxSTC_ERR_ES_BRIGHT_CYAN),
    t(wxSTC_ERR_ES_BRIGHT_MAGENTA, ?wxSTC_ERR_ES_BRIGHT_MAGENTA),
    t(wxSTC_ERR_ES_BRIGHT_BLUE, ?wxSTC_ERR_ES_BRIGHT_BLUE),
    t(wxSTC_ERR_ES_YELLOW, ?wxSTC_ERR_ES_YELLOW),
    t(wxSTC_ERR_ES_BRIGHT_GREEN, ?wxSTC_ERR_ES_BRIGHT_GREEN),
    t(wxSTC_ERR_ES_BRIGHT_RED, ?wxSTC_ERR_ES_BRIGHT_RED),
    t(wxSTC_ERR_ES_DARK_GRAY, ?wxSTC_ERR_ES_DARK_GRAY),
    t(wxSTC_ERR_ES_GRAY, ?wxSTC_ERR_ES_GRAY),
    t(wxSTC_ERR_ES_CYAN, ?wxSTC_ERR_ES_CYAN),
    t(wxSTC_ERR_ES_MAGENTA, ?wxSTC_ERR_ES_MAGENTA),
    t(wxSTC_ERR_ES_BLUE, ?wxSTC_ERR_ES_BLUE),
    t(wxSTC_ERR_ES_BROWN, ?wxSTC_ERR_ES_BROWN),
    t(wxSTC_ERR_ES_GREEN, ?wxSTC_ERR_ES_GREEN),
    t(wxSTC_ERR_ES_RED, ?wxSTC_ERR_ES_RED),
    t(wxSTC_ERR_ES_BLACK, ?wxSTC_ERR_ES_BLACK),
    t(wxSTC_ERR_ESCSEQ_UNKNOWN, ?wxSTC_ERR_ESCSEQ_UNKNOWN),
    t(wxSTC_ERR_ESCSEQ, ?wxSTC_ERR_ESCSEQ),
    t(wxSTC_ERR_GCC_INCLUDED_FROM, ?wxSTC_ERR_GCC_INCLUDED_FROM),
    t(wxSTC_ERR_VALUE, ?wxSTC_ERR_VALUE),
    t(wxSTC_ERR_JAVA_STACK, ?wxSTC_ERR_JAVA_STACK),
    t(wxSTC_ERR_TIDY, ?wxSTC_ERR_TIDY),
    t(wxSTC_ERR_ABSF, ?wxSTC_ERR_ABSF),
    t(wxSTC_ERR_IFORT, ?wxSTC_ERR_IFORT),
    t(wxSTC_ERR_IFC, ?wxSTC_ERR_IFC),
    t(wxSTC_ERR_ELF, ?wxSTC_ERR_ELF),
    t(wxSTC_ERR_PHP, ?wxSTC_ERR_PHP),
    t(wxSTC_ERR_DIFF_MESSAGE, ?wxSTC_ERR_DIFF_MESSAGE),
    t(wxSTC_ERR_DIFF_DELETION, ?wxSTC_ERR_DIFF_DELETION),
    t(wxSTC_ERR_DIFF_ADDITION, ?wxSTC_ERR_DIFF_ADDITION),
    t(wxSTC_ERR_DIFF_CHANGED, ?wxSTC_ERR_DIFF_CHANGED),
    t(wxSTC_ERR_CTAG, ?wxSTC_ERR_CTAG),
    t(wxSTC_ERR_LUA, ?wxSTC_ERR_LUA),
    t(wxSTC_ERR_NET, ?wxSTC_ERR_NET),
    t(wxSTC_ERR_PERL, ?wxSTC_ERR_PERL),
    t(wxSTC_ERR_BORLAND, ?wxSTC_ERR_BORLAND),
    t(wxSTC_ERR_CMD, ?wxSTC_ERR_CMD),
    t(wxSTC_ERR_MS, ?wxSTC_ERR_MS),
    t(wxSTC_ERR_GCC, ?wxSTC_ERR_GCC),
    t(wxSTC_ERR_PYTHON, ?wxSTC_ERR_PYTHON),
    t(wxSTC_ERR_DEFAULT, ?wxSTC_ERR_DEFAULT),
    t(wxSTC_LUA_LABEL, ?wxSTC_LUA_LABEL),
    t(wxSTC_LUA_WORD8, ?wxSTC_LUA_WORD8),
    t(wxSTC_LUA_WORD7, ?wxSTC_LUA_WORD7),
    t(wxSTC_LUA_WORD6, ?wxSTC_LUA_WORD6),
    t(wxSTC_LUA_WORD5, ?wxSTC_LUA_WORD5),
    t(wxSTC_LUA_WORD4, ?wxSTC_LUA_WORD4),
    t(wxSTC_LUA_WORD3, ?wxSTC_LUA_WORD3),
    t(wxSTC_LUA_WORD2, ?wxSTC_LUA_WORD2),
    t(wxSTC_LUA_STRINGEOL, ?wxSTC_LUA_STRINGEOL),
    t(wxSTC_LUA_IDENTIFIER, ?wxSTC_LUA_IDENTIFIER),
    t(wxSTC_LUA_OPERATOR, ?wxSTC_LUA_OPERATOR),
    t(wxSTC_LUA_PREPROCESSOR, ?wxSTC_LUA_PREPROCESSOR),
    t(wxSTC_LUA_LITERALSTRING, ?wxSTC_LUA_LITERALSTRING),
    t(wxSTC_LUA_CHARACTER, ?wxSTC_LUA_CHARACTER),
    t(wxSTC_LUA_STRING, ?wxSTC_LUA_STRING),
    t(wxSTC_LUA_WORD, ?wxSTC_LUA_WORD),
    t(wxSTC_LUA_NUMBER, ?wxSTC_LUA_NUMBER),
    t(wxSTC_LUA_COMMENTDOC, ?wxSTC_LUA_COMMENTDOC),
    t(wxSTC_LUA_COMMENTLINE, ?wxSTC_LUA_COMMENTLINE),
    t(wxSTC_LUA_COMMENT, ?wxSTC_LUA_COMMENT),
    t(wxSTC_LUA_DEFAULT, ?wxSTC_LUA_DEFAULT),
    t(wxSTC_L_ERROR, ?wxSTC_L_ERROR),
    t(wxSTC_L_CMDOPT, ?wxSTC_L_CMDOPT),
    t(wxSTC_L_SPECIAL, ?wxSTC_L_SPECIAL),
    t(wxSTC_L_SHORTCMD, ?wxSTC_L_SHORTCMD),
    t(wxSTC_L_VERBATIM, ?wxSTC_L_VERBATIM),
    t(wxSTC_L_COMMENT2, ?wxSTC_L_COMMENT2),
    t(wxSTC_L_MATH2, ?wxSTC_L_MATH2),
    t(wxSTC_L_TAG2, ?wxSTC_L_TAG2),
    t(wxSTC_L_COMMENT, ?wxSTC_L_COMMENT),
    t(wxSTC_L_MATH, ?wxSTC_L_MATH),
    t(wxSTC_L_TAG, ?wxSTC_L_TAG),
    t(wxSTC_L_COMMAND, ?wxSTC_L_COMMAND),
    t(wxSTC_L_DEFAULT, ?wxSTC_L_DEFAULT),
    t(wxSTC_PROPS_KEY, ?wxSTC_PROPS_KEY),
    t(wxSTC_PROPS_DEFVAL, ?wxSTC_PROPS_DEFVAL),
    t(wxSTC_PROPS_ASSIGNMENT, ?wxSTC_PROPS_ASSIGNMENT),
    t(wxSTC_PROPS_SECTION, ?wxSTC_PROPS_SECTION),
    t(wxSTC_PROPS_COMMENT, ?wxSTC_PROPS_COMMENT),
    t(wxSTC_PROPS_DEFAULT, ?wxSTC_PROPS_DEFAULT),
    t(wxSTC_B_DOCKEYWORD, ?wxSTC_B_DOCKEYWORD),
    t(wxSTC_B_DOCBLOCK, ?wxSTC_B_DOCBLOCK),
    t(wxSTC_B_DOCLINE, ?wxSTC_B_DOCLINE),
    t(wxSTC_B_COMMENTBLOCK, ?wxSTC_B_COMMENTBLOCK),
    t(wxSTC_B_BINNUMBER, ?wxSTC_B_BINNUMBER),
    t(wxSTC_B_HEXNUMBER, ?wxSTC_B_HEXNUMBER),
    t(wxSTC_B_ERROR, ?wxSTC_B_ERROR),
    t(wxSTC_B_LABEL, ?wxSTC_B_LABEL),
    t(wxSTC_B_ASM, ?wxSTC_B_ASM),
    t(wxSTC_B_CONSTANT, ?wxSTC_B_CONSTANT),
    t(wxSTC_B_KEYWORD4, ?wxSTC_B_KEYWORD4),
    t(wxSTC_B_KEYWORD3, ?wxSTC_B_KEYWORD3),
    t(wxSTC_B_KEYWORD2, ?wxSTC_B_KEYWORD2),
    t(wxSTC_B_STRINGEOL, ?wxSTC_B_STRINGEOL),
    t(wxSTC_B_DATE, ?wxSTC_B_DATE),
    t(wxSTC_B_IDENTIFIER, ?wxSTC_B_IDENTIFIER),
    t(wxSTC_B_OPERATOR, ?wxSTC_B_OPERATOR),
    t(wxSTC_B_PREPROCESSOR, ?wxSTC_B_PREPROCESSOR),
    t(wxSTC_B_STRING, ?wxSTC_B_STRING),
    t(wxSTC_B_KEYWORD, ?wxSTC_B_KEYWORD),
    t(wxSTC_B_NUMBER, ?wxSTC_B_NUMBER),
    t(wxSTC_B_COMMENT, ?wxSTC_B_COMMENT),
    t(wxSTC_B_DEFAULT, ?wxSTC_B_DEFAULT),
    t(wxSTC_RB_UPPER_BOUND, ?wxSTC_RB_UPPER_BOUND),
    t(wxSTC_RB_STDERR, ?wxSTC_RB_STDERR),
    t(wxSTC_RB_STDOUT, ?wxSTC_RB_STDOUT),
    t(wxSTC_RB_STDIN, ?wxSTC_RB_STDIN),
    t(wxSTC_RB_WORD_DEMOTED, ?wxSTC_RB_WORD_DEMOTED),
    t(wxSTC_RB_STRING_QW, ?wxSTC_RB_STRING_QW),
    t(wxSTC_RB_STRING_QR, ?wxSTC_RB_STRING_QR),
    t(wxSTC_RB_STRING_QX, ?wxSTC_RB_STRING_QX),
    t(wxSTC_RB_STRING_QQ, ?wxSTC_RB_STRING_QQ),
    t(wxSTC_RB_STRING_Q, ?wxSTC_RB_STRING_Q),
    t(wxSTC_RB_HERE_QX, ?wxSTC_RB_HERE_QX),
    t(wxSTC_RB_HERE_QQ, ?wxSTC_RB_HERE_QQ),
    t(wxSTC_RB_HERE_Q, ?wxSTC_RB_HERE_Q),
    t(wxSTC_RB_HERE_DELIM, ?wxSTC_RB_HERE_DELIM),
    t(wxSTC_RB_DATASECTION, ?wxSTC_RB_DATASECTION),
    t(wxSTC_RB_BACKTICKS, ?wxSTC_RB_BACKTICKS),
    t(wxSTC_RB_CLASS_VAR, ?wxSTC_RB_CLASS_VAR),
    t(wxSTC_RB_INSTANCE_VAR, ?wxSTC_RB_INSTANCE_VAR),
    t(wxSTC_RB_MODULE_NAME, ?wxSTC_RB_MODULE_NAME),
    t(wxSTC_RB_SYMBOL, ?wxSTC_RB_SYMBOL),
    t(wxSTC_RB_GLOBAL, ?wxSTC_RB_GLOBAL),
    t(wxSTC_RB_REGEX, ?wxSTC_RB_REGEX),
    t(wxSTC_RB_IDENTIFIER, ?wxSTC_RB_IDENTIFIER),
    t(wxSTC_RB_OPERATOR, ?wxSTC_RB_OPERATOR),
    t(wxSTC_RB_DEFNAME, ?wxSTC_RB_DEFNAME),
    t(wxSTC_RB_CLASSNAME, ?wxSTC_RB_CLASSNAME),
    t(wxSTC_RB_CHARACTER, ?wxSTC_RB_CHARACTER),
    t(wxSTC_RB_STRING, ?wxSTC_RB_STRING),
    t(wxSTC_RB_WORD, ?wxSTC_RB_WORD),
    t(wxSTC_RB_NUMBER, ?wxSTC_RB_NUMBER),
    t(wxSTC_RB_POD, ?wxSTC_RB_POD),
    t(wxSTC_RB_COMMENTLINE, ?wxSTC_RB_COMMENTLINE),
    t(wxSTC_RB_ERROR, ?wxSTC_RB_ERROR),
    t(wxSTC_RB_DEFAULT, ?wxSTC_RB_DEFAULT),
    t(wxSTC_PL_STRING_QR_VAR, ?wxSTC_PL_STRING_QR_VAR),
    t(wxSTC_PL_STRING_QX_VAR, ?wxSTC_PL_STRING_QX_VAR),
    t(wxSTC_PL_STRING_QQ_VAR, ?wxSTC_PL_STRING_QQ_VAR),
    t(wxSTC_PL_HERE_QX_VAR, ?wxSTC_PL_HERE_QX_VAR),
    t(wxSTC_PL_HERE_QQ_VAR, ?wxSTC_PL_HERE_QQ_VAR),
    t(wxSTC_PL_BACKTICKS_VAR, ?wxSTC_PL_BACKTICKS_VAR),
    t(wxSTC_PL_REGSUBST_VAR, ?wxSTC_PL_REGSUBST_VAR),
    t(wxSTC_PL_REGEX_VAR, ?wxSTC_PL_REGEX_VAR),
    t(wxSTC_PL_XLAT, ?wxSTC_PL_XLAT),
    t(wxSTC_PL_STRING_VAR, ?wxSTC_PL_STRING_VAR),
    t(wxSTC_PL_FORMAT, ?wxSTC_PL_FORMAT),
    t(wxSTC_PL_FORMAT_IDENT, ?wxSTC_PL_FORMAT_IDENT),
    t(wxSTC_PL_SUB_PROTOTYPE, ?wxSTC_PL_SUB_PROTOTYPE),
    t(wxSTC_PL_POD_VERB, ?wxSTC_PL_POD_VERB),
    t(wxSTC_PL_STRING_QW, ?wxSTC_PL_STRING_QW),
    t(wxSTC_PL_STRING_QR, ?wxSTC_PL_STRING_QR),
    t(wxSTC_PL_STRING_QX, ?wxSTC_PL_STRING_QX),
    t(wxSTC_PL_STRING_QQ, ?wxSTC_PL_STRING_QQ),
    t(wxSTC_PL_STRING_Q, ?wxSTC_PL_STRING_Q),
    t(wxSTC_PL_HERE_QX, ?wxSTC_PL_HERE_QX),
    t(wxSTC_PL_HERE_QQ, ?wxSTC_PL_HERE_QQ),
    t(wxSTC_PL_HERE_Q, ?wxSTC_PL_HERE_Q),
    t(wxSTC_PL_HERE_DELIM, ?wxSTC_PL_HERE_DELIM),
    t(wxSTC_PL_DATASECTION, ?wxSTC_PL_DATASECTION),
    t(wxSTC_PL_BACKTICKS, ?wxSTC_PL_BACKTICKS),
    t(wxSTC_PL_LONGQUOTE, ?wxSTC_PL_LONGQUOTE),
    t(wxSTC_PL_REGSUBST, ?wxSTC_PL_REGSUBST),
    t(wxSTC_PL_REGEX, ?wxSTC_PL_REGEX),
    t(wxSTC_PL_VARIABLE_INDEXER, ?wxSTC_PL_VARIABLE_INDEXER),
    t(wxSTC_PL_SYMBOLTABLE, ?wxSTC_PL_SYMBOLTABLE),
    t(wxSTC_PL_HASH, ?wxSTC_PL_HASH),
    t(wxSTC_PL_ARRAY, ?wxSTC_PL_ARRAY),
    t(wxSTC_PL_SCALAR, ?wxSTC_PL_SCALAR),
    t(wxSTC_PL_IDENTIFIER, ?wxSTC_PL_IDENTIFIER),
    t(wxSTC_PL_OPERATOR, ?wxSTC_PL_OPERATOR),
    t(wxSTC_PL_PREPROCESSOR, ?wxSTC_PL_PREPROCESSOR),
    t(wxSTC_PL_PUNCTUATION, ?wxSTC_PL_PUNCTUATION),
    t(wxSTC_PL_CHARACTER, ?wxSTC_PL_CHARACTER),
    t(wxSTC_PL_STRING, ?wxSTC_PL_STRING),
    t(wxSTC_PL_WORD, ?wxSTC_PL_WORD),
    t(wxSTC_PL_NUMBER, ?wxSTC_PL_NUMBER),
    t(wxSTC_PL_POD, ?wxSTC_PL_POD),
    t(wxSTC_PL_COMMENTLINE, ?wxSTC_PL_COMMENTLINE),
    t(wxSTC_PL_ERROR, ?wxSTC_PL_ERROR),
    t(wxSTC_PL_DEFAULT, ?wxSTC_PL_DEFAULT),
    t(wxSTC_HPHP_OPERATOR, ?wxSTC_HPHP_OPERATOR),
    t(wxSTC_HPHP_HSTRING_VARIABLE, ?wxSTC_HPHP_HSTRING_VARIABLE),
    t(wxSTC_HPHP_COMMENTLINE, ?wxSTC_HPHP_COMMENTLINE),
    t(wxSTC_HPHP_COMMENT, ?wxSTC_HPHP_COMMENT),
    t(wxSTC_HPHP_VARIABLE, ?wxSTC_HPHP_VARIABLE),
    t(wxSTC_HPHP_NUMBER, ?wxSTC_HPHP_NUMBER),
    t(wxSTC_HPHP_WORD, ?wxSTC_HPHP_WORD),
    t(wxSTC_HPHP_SIMPLESTRING, ?wxSTC_HPHP_SIMPLESTRING),
    t(wxSTC_HPHP_HSTRING, ?wxSTC_HPHP_HSTRING),
    t(wxSTC_HPHP_DEFAULT, ?wxSTC_HPHP_DEFAULT),
    t(wxSTC_HPA_IDENTIFIER, ?wxSTC_HPA_IDENTIFIER),
    t(wxSTC_HPA_OPERATOR, ?wxSTC_HPA_OPERATOR),
    t(wxSTC_HPA_DEFNAME, ?wxSTC_HPA_DEFNAME),
    t(wxSTC_HPA_CLASSNAME, ?wxSTC_HPA_CLASSNAME),
    t(wxSTC_HPA_TRIPLEDOUBLE, ?wxSTC_HPA_TRIPLEDOUBLE),
    t(wxSTC_HPA_TRIPLE, ?wxSTC_HPA_TRIPLE),
    t(wxSTC_HPA_WORD, ?wxSTC_HPA_WORD),
    t(wxSTC_HPA_CHARACTER, ?wxSTC_HPA_CHARACTER),
    t(wxSTC_HPA_STRING, ?wxSTC_HPA_STRING),
    t(wxSTC_HPA_NUMBER, ?wxSTC_HPA_NUMBER),
    t(wxSTC_HPA_COMMENTLINE, ?wxSTC_HPA_COMMENTLINE),
    t(wxSTC_HPA_DEFAULT, ?wxSTC_HPA_DEFAULT),
    t(wxSTC_HPA_START, ?wxSTC_HPA_START),
    t(wxSTC_HPHP_COMPLEX_VARIABLE, ?wxSTC_HPHP_COMPLEX_VARIABLE),
    t(wxSTC_HP_IDENTIFIER, ?wxSTC_HP_IDENTIFIER),
    t(wxSTC_HP_OPERATOR, ?wxSTC_HP_OPERATOR),
    t(wxSTC_HP_DEFNAME, ?wxSTC_HP_DEFNAME),
    t(wxSTC_HP_CLASSNAME, ?wxSTC_HP_CLASSNAME),
    t(wxSTC_HP_TRIPLEDOUBLE, ?wxSTC_HP_TRIPLEDOUBLE),
    t(wxSTC_HP_TRIPLE, ?wxSTC_HP_TRIPLE),
    t(wxSTC_HP_WORD, ?wxSTC_HP_WORD),
    t(wxSTC_HP_CHARACTER, ?wxSTC_HP_CHARACTER),
    t(wxSTC_HP_STRING, ?wxSTC_HP_STRING),
    t(wxSTC_HP_NUMBER, ?wxSTC_HP_NUMBER),
    t(wxSTC_HP_COMMENTLINE, ?wxSTC_HP_COMMENTLINE),
    t(wxSTC_HP_DEFAULT, ?wxSTC_HP_DEFAULT),
    t(wxSTC_HP_START, ?wxSTC_HP_START),
    t(wxSTC_HBA_STRINGEOL, ?wxSTC_HBA_STRINGEOL),
    t(wxSTC_HBA_IDENTIFIER, ?wxSTC_HBA_IDENTIFIER),
    t(wxSTC_HBA_STRING, ?wxSTC_HBA_STRING),
    t(wxSTC_HBA_WORD, ?wxSTC_HBA_WORD),
    t(wxSTC_HBA_NUMBER, ?wxSTC_HBA_NUMBER),
    t(wxSTC_HBA_COMMENTLINE, ?wxSTC_HBA_COMMENTLINE),
    t(wxSTC_HBA_DEFAULT, ?wxSTC_HBA_DEFAULT),
    t(wxSTC_HBA_START, ?wxSTC_HBA_START),
    t(wxSTC_HB_STRINGEOL, ?wxSTC_HB_STRINGEOL),
    t(wxSTC_HB_IDENTIFIER, ?wxSTC_HB_IDENTIFIER),
    t(wxSTC_HB_STRING, ?wxSTC_HB_STRING),
    t(wxSTC_HB_WORD, ?wxSTC_HB_WORD),
    t(wxSTC_HB_NUMBER, ?wxSTC_HB_NUMBER),
    t(wxSTC_HB_COMMENTLINE, ?wxSTC_HB_COMMENTLINE),
    t(wxSTC_HB_DEFAULT, ?wxSTC_HB_DEFAULT),
    t(wxSTC_HB_START, ?wxSTC_HB_START),
    t(wxSTC_HJA_REGEX, ?wxSTC_HJA_REGEX),
    t(wxSTC_HJA_STRINGEOL, ?wxSTC_HJA_STRINGEOL),
    t(wxSTC_HJA_SYMBOLS, ?wxSTC_HJA_SYMBOLS),
    t(wxSTC_HJA_SINGLESTRING, ?wxSTC_HJA_SINGLESTRING),
    t(wxSTC_HJA_DOUBLESTRING, ?wxSTC_HJA_DOUBLESTRING),
    t(wxSTC_HJA_KEYWORD, ?wxSTC_HJA_KEYWORD),
    t(wxSTC_HJA_WORD, ?wxSTC_HJA_WORD),
    t(wxSTC_HJA_NUMBER, ?wxSTC_HJA_NUMBER),
    t(wxSTC_HJA_COMMENTDOC, ?wxSTC_HJA_COMMENTDOC),
    t(wxSTC_HJA_COMMENTLINE, ?wxSTC_HJA_COMMENTLINE),
    t(wxSTC_HJA_COMMENT, ?wxSTC_HJA_COMMENT),
    t(wxSTC_HJA_DEFAULT, ?wxSTC_HJA_DEFAULT),
    t(wxSTC_HJA_START, ?wxSTC_HJA_START),
    t(wxSTC_HJ_REGEX, ?wxSTC_HJ_REGEX),
    t(wxSTC_HJ_STRINGEOL, ?wxSTC_HJ_STRINGEOL),
    t(wxSTC_HJ_SYMBOLS, ?wxSTC_HJ_SYMBOLS),
    t(wxSTC_HJ_SINGLESTRING, ?wxSTC_HJ_SINGLESTRING),
    t(wxSTC_HJ_DOUBLESTRING, ?wxSTC_HJ_DOUBLESTRING),
    t(wxSTC_HJ_KEYWORD, ?wxSTC_HJ_KEYWORD),
    t(wxSTC_HJ_WORD, ?wxSTC_HJ_WORD),
    t(wxSTC_HJ_NUMBER, ?wxSTC_HJ_NUMBER),
    t(wxSTC_HJ_COMMENTDOC, ?wxSTC_HJ_COMMENTDOC),
    t(wxSTC_HJ_COMMENTLINE, ?wxSTC_HJ_COMMENTLINE),
    t(wxSTC_HJ_COMMENT, ?wxSTC_HJ_COMMENT),
    t(wxSTC_HJ_DEFAULT, ?wxSTC_HJ_DEFAULT),
    t(wxSTC_HJ_START, ?wxSTC_HJ_START),
    t(wxSTC_H_SGML_BLOCK_DEFAULT, ?wxSTC_H_SGML_BLOCK_DEFAULT),
    t(wxSTC_H_SGML_1ST_PARAM_COMMENT, ?wxSTC_H_SGML_1ST_PARAM_COMMENT),
    t(wxSTC_H_SGML_COMMENT, ?wxSTC_H_SGML_COMMENT),
    t(wxSTC_H_SGML_ENTITY, ?wxSTC_H_SGML_ENTITY),
    t(wxSTC_H_SGML_SPECIAL, ?wxSTC_H_SGML_SPECIAL),
    t(wxSTC_H_SGML_ERROR, ?wxSTC_H_SGML_ERROR),
    t(wxSTC_H_SGML_SIMPLESTRING, ?wxSTC_H_SGML_SIMPLESTRING),
    t(wxSTC_H_SGML_DOUBLESTRING, ?wxSTC_H_SGML_DOUBLESTRING),
    t(wxSTC_H_SGML_1ST_PARAM, ?wxSTC_H_SGML_1ST_PARAM),
    t(wxSTC_H_SGML_COMMAND, ?wxSTC_H_SGML_COMMAND),
    t(wxSTC_H_SGML_DEFAULT, ?wxSTC_H_SGML_DEFAULT),
    t(wxSTC_H_XCCOMMENT, ?wxSTC_H_XCCOMMENT),
    t(wxSTC_H_VALUE, ?wxSTC_H_VALUE),
    t(wxSTC_H_QUESTION, ?wxSTC_H_QUESTION),
    t(wxSTC_H_CDATA, ?wxSTC_H_CDATA),
    t(wxSTC_H_ASPAT, ?wxSTC_H_ASPAT),
    t(wxSTC_H_ASP, ?wxSTC_H_ASP),
    t(wxSTC_H_SCRIPT, ?wxSTC_H_SCRIPT),
    t(wxSTC_H_XMLEND, ?wxSTC_H_XMLEND),
    t(wxSTC_H_XMLSTART, ?wxSTC_H_XMLSTART),
    t(wxSTC_H_TAGEND, ?wxSTC_H_TAGEND),
    t(wxSTC_H_ENTITY, ?wxSTC_H_ENTITY),
    t(wxSTC_H_COMMENT, ?wxSTC_H_COMMENT),
    t(wxSTC_H_OTHER, ?wxSTC_H_OTHER),
    t(wxSTC_H_SINGLESTRING, ?wxSTC_H_SINGLESTRING),
    t(wxSTC_H_DOUBLESTRING, ?wxSTC_H_DOUBLESTRING),
    t(wxSTC_H_NUMBER, ?wxSTC_H_NUMBER),
    t(wxSTC_H_ATTRIBUTEUNKNOWN, ?wxSTC_H_ATTRIBUTEUNKNOWN),
    t(wxSTC_H_ATTRIBUTE, ?wxSTC_H_ATTRIBUTE),
    t(wxSTC_H_TAGUNKNOWN, ?wxSTC_H_TAGUNKNOWN),
    t(wxSTC_H_TAG, ?wxSTC_H_TAG),
    t(wxSTC_H_DEFAULT, ?wxSTC_H_DEFAULT),
    t(wxSTC_TCL_BLOCK_COMMENT, ?wxSTC_TCL_BLOCK_COMMENT),
    t(wxSTC_TCL_COMMENT_BOX, ?wxSTC_TCL_COMMENT_BOX),
    t(wxSTC_TCL_WORD8, ?wxSTC_TCL_WORD8),
    t(wxSTC_TCL_WORD7, ?wxSTC_TCL_WORD7),
    t(wxSTC_TCL_WORD6, ?wxSTC_TCL_WORD6),
    t(wxSTC_TCL_WORD5, ?wxSTC_TCL_WORD5),
    t(wxSTC_TCL_WORD4, ?wxSTC_TCL_WORD4),
    t(wxSTC_TCL_WORD3, ?wxSTC_TCL_WORD3),
    t(wxSTC_TCL_WORD2, ?wxSTC_TCL_WORD2),
    t(wxSTC_TCL_WORD, ?wxSTC_TCL_WORD),
    t(wxSTC_TCL_EXPAND, ?wxSTC_TCL_EXPAND),
    t(wxSTC_TCL_MODIFIER, ?wxSTC_TCL_MODIFIER),
    t(wxSTC_TCL_SUB_BRACE, ?wxSTC_TCL_SUB_BRACE),
    t(wxSTC_TCL_SUBSTITUTION, ?wxSTC_TCL_SUBSTITUTION),
    t(wxSTC_TCL_IDENTIFIER, ?wxSTC_TCL_IDENTIFIER),
    t(wxSTC_TCL_OPERATOR, ?wxSTC_TCL_OPERATOR),
    t(wxSTC_TCL_IN_QUOTE, ?wxSTC_TCL_IN_QUOTE),
    t(wxSTC_TCL_WORD_IN_QUOTE, ?wxSTC_TCL_WORD_IN_QUOTE),
    t(wxSTC_TCL_NUMBER, ?wxSTC_TCL_NUMBER),
    t(wxSTC_TCL_COMMENTLINE, ?wxSTC_TCL_COMMENTLINE),
    t(wxSTC_TCL_COMMENT, ?wxSTC_TCL_COMMENT),
    t(wxSTC_TCL_DEFAULT, ?wxSTC_TCL_DEFAULT),
    t(wxSTC_D_WORD7, ?wxSTC_D_WORD7),
    t(wxSTC_D_WORD6, ?wxSTC_D_WORD6),
    t(wxSTC_D_WORD5, ?wxSTC_D_WORD5),
    t(wxSTC_D_STRINGR, ?wxSTC_D_STRINGR),
    t(wxSTC_D_STRINGB, ?wxSTC_D_STRINGB),
    t(wxSTC_D_COMMENTDOCKEYWORDERROR, ?wxSTC_D_COMMENTDOCKEYWORDERROR),
    t(wxSTC_D_COMMENTDOCKEYWORD, ?wxSTC_D_COMMENTDOCKEYWORD),
    t(wxSTC_D_COMMENTLINEDOC, ?wxSTC_D_COMMENTLINEDOC),
    t(wxSTC_D_IDENTIFIER, ?wxSTC_D_IDENTIFIER),
    t(wxSTC_D_OPERATOR, ?wxSTC_D_OPERATOR),
    t(wxSTC_D_CHARACTER, ?wxSTC_D_CHARACTER),
    t(wxSTC_D_STRINGEOL, ?wxSTC_D_STRINGEOL),
    t(wxSTC_D_STRING, ?wxSTC_D_STRING),
    t(wxSTC_D_TYPEDEF, ?wxSTC_D_TYPEDEF),
    t(wxSTC_D_WORD3, ?wxSTC_D_WORD3),
    t(wxSTC_D_WORD2, ?wxSTC_D_WORD2),
    t(wxSTC_D_WORD, ?wxSTC_D_WORD),
    t(wxSTC_D_NUMBER, ?wxSTC_D_NUMBER),
    t(wxSTC_D_COMMENTNESTED, ?wxSTC_D_COMMENTNESTED),
    t(wxSTC_D_COMMENTDOC, ?wxSTC_D_COMMENTDOC),
    t(wxSTC_D_COMMENTLINE, ?wxSTC_D_COMMENTLINE),
    t(wxSTC_D_COMMENT, ?wxSTC_D_COMMENT),
    t(wxSTC_D_DEFAULT, ?wxSTC_D_DEFAULT),
    t(wxSTC_C_ESCAPESEQUENCE, ?wxSTC_C_ESCAPESEQUENCE),
    t(wxSTC_C_TASKMARKER, ?wxSTC_C_TASKMARKER),
    t(wxSTC_C_USERLITERAL, ?wxSTC_C_USERLITERAL),
    t(wxSTC_C_PREPROCESSORCOMMENTDOC, ?wxSTC_C_PREPROCESSORCOMMENTDOC),
    t(wxSTC_C_PREPROCESSORCOMMENT, ?wxSTC_C_PREPROCESSORCOMMENT),
    t(wxSTC_C_HASHQUOTEDSTRING, ?wxSTC_C_HASHQUOTEDSTRING),
    t(wxSTC_C_TRIPLEVERBATIM, ?wxSTC_C_TRIPLEVERBATIM),
    t(wxSTC_C_STRINGRAW, ?wxSTC_C_STRINGRAW),
    t(wxSTC_C_GLOBALCLASS, ?wxSTC_C_GLOBALCLASS),
    t(wxSTC_C_COMMENTDOCKEYWORDERROR, ?wxSTC_C_COMMENTDOCKEYWORDERROR),
    t(wxSTC_C_COMMENTDOCKEYWORD, ?wxSTC_C_COMMENTDOCKEYWORD),
    t(wxSTC_C_WORD2, ?wxSTC_C_WORD2),
    t(wxSTC_C_COMMENTLINEDOC, ?wxSTC_C_COMMENTLINEDOC),
    t(wxSTC_C_REGEX, ?wxSTC_C_REGEX),
    t(wxSTC_C_VERBATIM, ?wxSTC_C_VERBATIM),
    t(wxSTC_C_STRINGEOL, ?wxSTC_C_STRINGEOL),
    t(wxSTC_C_IDENTIFIER, ?wxSTC_C_IDENTIFIER),
    t(wxSTC_C_OPERATOR, ?wxSTC_C_OPERATOR),
    t(wxSTC_C_PREPROCESSOR, ?wxSTC_C_PREPROCESSOR),
    t(wxSTC_C_UUID, ?wxSTC_C_UUID),
    t(wxSTC_C_CHARACTER, ?wxSTC_C_CHARACTER),
    t(wxSTC_C_STRING, ?wxSTC_C_STRING),
    t(wxSTC_C_WORD, ?wxSTC_C_WORD),
    t(wxSTC_C_NUMBER, ?wxSTC_C_NUMBER),
    t(wxSTC_C_COMMENTDOC, ?wxSTC_C_COMMENTDOC),
    t(wxSTC_C_COMMENTLINE, ?wxSTC_C_COMMENTLINE),
    t(wxSTC_C_COMMENT, ?wxSTC_C_COMMENT),
    t(wxSTC_C_DEFAULT, ?wxSTC_C_DEFAULT),
    t(wxSTC_P_DECORATOR, ?wxSTC_P_DECORATOR),
    t(wxSTC_P_WORD2, ?wxSTC_P_WORD2),
    t(wxSTC_P_STRINGEOL, ?wxSTC_P_STRINGEOL),
    t(wxSTC_P_COMMENTBLOCK, ?wxSTC_P_COMMENTBLOCK),
    t(wxSTC_P_IDENTIFIER, ?wxSTC_P_IDENTIFIER),
    t(wxSTC_P_OPERATOR, ?wxSTC_P_OPERATOR),
    t(wxSTC_P_DEFNAME, ?wxSTC_P_DEFNAME),
    t(wxSTC_P_CLASSNAME, ?wxSTC_P_CLASSNAME),
    t(wxSTC_P_TRIPLEDOUBLE, ?wxSTC_P_TRIPLEDOUBLE),
    t(wxSTC_P_TRIPLE, ?wxSTC_P_TRIPLE),
    t(wxSTC_P_WORD, ?wxSTC_P_WORD),
    t(wxSTC_P_CHARACTER, ?wxSTC_P_CHARACTER),
    t(wxSTC_P_STRING, ?wxSTC_P_STRING),
    t(wxSTC_P_NUMBER, ?wxSTC_P_NUMBER),
    t(wxSTC_P_COMMENTLINE, ?wxSTC_P_COMMENTLINE),
    t(wxSTC_P_DEFAULT, ?wxSTC_P_DEFAULT),
    t(wxSTC_LEX_AUTOMATIC, ?wxSTC_LEX_AUTOMATIC),
    t(wxSTC_LEX_EDIFACT, ?wxSTC_LEX_EDIFACT),
    t(wxSTC_LEX_JSON, ?wxSTC_LEX_JSON),
    t(wxSTC_LEX_TEHEX, ?wxSTC_LEX_TEHEX),
    t(wxSTC_LEX_IHEX, ?wxSTC_LEX_IHEX),
    t(wxSTC_LEX_SREC, ?wxSTC_LEX_SREC),
    t(wxSTC_LEX_BIBTEX, ?wxSTC_LEX_BIBTEX),
    t(wxSTC_LEX_REGISTRY, ?wxSTC_LEX_REGISTRY),
    t(wxSTC_LEX_DMIS, ?wxSTC_LEX_DMIS),
    t(wxSTC_LEX_AS, ?wxSTC_LEX_AS),
    t(wxSTC_LEX_DMAP, ?wxSTC_LEX_DMAP),
    t(wxSTC_LEX_RUST, ?wxSTC_LEX_RUST),
    t(wxSTC_LEX_KVIRC, ?wxSTC_LEX_KVIRC),
    t(wxSTC_LEX_STTXT, ?wxSTC_LEX_STTXT),
    t(wxSTC_LEX_LITERATEHASKELL, ?wxSTC_LEX_LITERATEHASKELL),
    t(wxSTC_LEX_VISUALPROLOG, ?wxSTC_LEX_VISUALPROLOG),
    t(wxSTC_LEX_OSCRIPT, ?wxSTC_LEX_OSCRIPT),
    t(wxSTC_LEX_ECL, ?wxSTC_LEX_ECL),
    t(wxSTC_LEX_AVS, ?wxSTC_LEX_AVS),
    t(wxSTC_LEX_TCMD, ?wxSTC_LEX_TCMD),
    t(wxSTC_LEX_COFFEESCRIPT, ?wxSTC_LEX_COFFEESCRIPT),
    t(wxSTC_LEX_MODULA, ?wxSTC_LEX_MODULA),
    t(wxSTC_LEX_A68K, ?wxSTC_LEX_A68K),
    t(wxSTC_LEX_TXT2TAGS, ?wxSTC_LEX_TXT2TAGS),
    t(wxSTC_LEX_MARKDOWN, ?wxSTC_LEX_MARKDOWN),
    t(wxSTC_LEX_SML, ?wxSTC_LEX_SML),
    t(wxSTC_LEX_NIMROD, ?wxSTC_LEX_NIMROD),
    t(wxSTC_LEX_POWERPRO, ?wxSTC_LEX_POWERPRO),
    t(wxSTC_LEX_SORCUS, ?wxSTC_LEX_SORCUS),
    t(wxSTC_LEX_TACL, ?wxSTC_LEX_TACL),
    t(wxSTC_LEX_COBOL, ?wxSTC_LEX_COBOL),
    t(wxSTC_LEX_TAL, ?wxSTC_LEX_TAL),
    t(wxSTC_LEX_PO, ?wxSTC_LEX_PO),
    t(wxSTC_LEX_MYSQL, ?wxSTC_LEX_MYSQL),
    t(wxSTC_LEX_POWERSHELL, ?wxSTC_LEX_POWERSHELL),
    t(wxSTC_LEX_MAGIK, ?wxSTC_LEX_MAGIK),
    t(wxSTC_LEX_R, ?wxSTC_LEX_R),
    t(wxSTC_LEX_ASYMPTOTE, ?wxSTC_LEX_ASYMPTOTE),
    t(wxSTC_LEX_ABAQUS, ?wxSTC_LEX_ABAQUS),
    t(wxSTC_LEX_PROGRESS, ?wxSTC_LEX_PROGRESS),
    t(wxSTC_LEX_PLM, ?wxSTC_LEX_PLM),
    t(wxSTC_LEX_GAP, ?wxSTC_LEX_GAP),
    t(wxSTC_LEX_CMAKE, ?wxSTC_LEX_CMAKE),
    t(wxSTC_LEX_D, ?wxSTC_LEX_D),
    t(wxSTC_LEX_SPICE, ?wxSTC_LEX_SPICE),
    t(wxSTC_LEX_OPAL, ?wxSTC_LEX_OPAL),
    t(wxSTC_LEX_INNOSETUP, ?wxSTC_LEX_INNOSETUP),
    t(wxSTC_LEX_FREEBASIC, ?wxSTC_LEX_FREEBASIC),
    t(wxSTC_LEX_CSOUND, ?wxSTC_LEX_CSOUND),
    t(wxSTC_LEX_FLAGSHIP, ?wxSTC_LEX_FLAGSHIP),
    t(wxSTC_LEX_SMALLTALK, ?wxSTC_LEX_SMALLTALK),
    t(wxSTC_LEX_REBOL, ?wxSTC_LEX_REBOL),
    t(wxSTC_LEX_TADS3, ?wxSTC_LEX_TADS3),
    t(wxSTC_LEX_PHPSCRIPT, ?wxSTC_LEX_PHPSCRIPT),
    t(wxSTC_LEX_HASKELL, ?wxSTC_LEX_HASKELL),
    t(wxSTC_LEX_PUREBASIC, ?wxSTC_LEX_PUREBASIC),
    t(wxSTC_LEX_BLITZBASIC, ?wxSTC_LEX_BLITZBASIC),
    t(wxSTC_LEX_CAML, ?wxSTC_LEX_CAML),
    t(wxSTC_LEX_VHDL, ?wxSTC_LEX_VHDL),
    t(wxSTC_LEX_ASN1, ?wxSTC_LEX_ASN1),
    t(wxSTC_LEX_BASH, ?wxSTC_LEX_BASH),
    t(wxSTC_LEX_APDL, ?wxSTC_LEX_APDL),
    t(wxSTC_LEX_AU3, ?wxSTC_LEX_AU3),
    t(wxSTC_LEX_SPECMAN, ?wxSTC_LEX_SPECMAN),
    t(wxSTC_LEX_GUI4CLI, ?wxSTC_LEX_GUI4CLI),
    t(wxSTC_LEX_KIX, ?wxSTC_LEX_KIX),
    t(wxSTC_LEX_VERILOG, ?wxSTC_LEX_VERILOG),
    t(wxSTC_LEX_MSSQL, ?wxSTC_LEX_MSSQL),
    t(wxSTC_LEX_OCTAVE, ?wxSTC_LEX_OCTAVE),
    t(wxSTC_LEX_ERLANG, ?wxSTC_LEX_ERLANG),
    t(wxSTC_LEX_FORTH, ?wxSTC_LEX_FORTH),
    t(wxSTC_LEX_POWERBASIC, ?wxSTC_LEX_POWERBASIC),
    t(wxSTC_LEX_METAPOST, ?wxSTC_LEX_METAPOST),
    t(wxSTC_LEX_TEX, ?wxSTC_LEX_TEX),
    t(wxSTC_LEX_YAML, ?wxSTC_LEX_YAML),
    t(wxSTC_LEX_LOT, ?wxSTC_LEX_LOT),
    t(wxSTC_LEX_CLWNOCASE, ?wxSTC_LEX_CLWNOCASE),
    t(wxSTC_LEX_CLW, ?wxSTC_LEX_CLW),
    t(wxSTC_LEX_MMIXAL, ?wxSTC_LEX_MMIXAL),
    t(wxSTC_LEX_NSIS, ?wxSTC_LEX_NSIS),
    t(wxSTC_LEX_PS, ?wxSTC_LEX_PS),
    t(wxSTC_LEX_ESCRIPT, ?wxSTC_LEX_ESCRIPT),
    t(wxSTC_LEX_LOUT, ?wxSTC_LEX_LOUT),
    t(wxSTC_LEX_POV, ?wxSTC_LEX_POV),
    t(wxSTC_LEX_CSS, ?wxSTC_LEX_CSS),
    t(wxSTC_LEX_F77, ?wxSTC_LEX_F77),
    t(wxSTC_LEX_FORTRAN, ?wxSTC_LEX_FORTRAN),
    t(wxSTC_LEX_CPPNOCASE, ?wxSTC_LEX_CPPNOCASE),
    t(wxSTC_LEX_ASM, ?wxSTC_LEX_ASM),
    t(wxSTC_LEX_SCRIPTOL, ?wxSTC_LEX_SCRIPTOL),
    t(wxSTC_LEX_MATLAB, ?wxSTC_LEX_MATLAB),
    t(wxSTC_LEX_BAAN, ?wxSTC_LEX_BAAN),
    t(wxSTC_LEX_VBSCRIPT, ?wxSTC_LEX_VBSCRIPT),
    t(wxSTC_LEX_BULLANT, ?wxSTC_LEX_BULLANT),
    t(wxSTC_LEX_NNCRONTAB, ?wxSTC_LEX_NNCRONTAB),
    t(wxSTC_LEX_TCL, ?wxSTC_LEX_TCL),
    t(wxSTC_LEX_EIFFELKW, ?wxSTC_LEX_EIFFELKW),
    t(wxSTC_LEX_EIFFEL, ?wxSTC_LEX_EIFFEL),
    t(wxSTC_LEX_RUBY, ?wxSTC_LEX_RUBY),
    t(wxSTC_LEX_LISP, ?wxSTC_LEX_LISP),
    t(wxSTC_LEX_ADA, ?wxSTC_LEX_ADA),
    t(wxSTC_LEX_AVE, ?wxSTC_LEX_AVE),
    t(wxSTC_LEX_PASCAL, ?wxSTC_LEX_PASCAL),
    t(wxSTC_LEX_CONF, ?wxSTC_LEX_CONF),
    t(wxSTC_LEX_DIFF, ?wxSTC_LEX_DIFF),
    t(wxSTC_LEX_LUA, ?wxSTC_LEX_LUA),
    t(wxSTC_LEX_LATEX, ?wxSTC_LEX_LATEX),
    t(wxSTC_LEX_XCODE, ?wxSTC_LEX_XCODE),
    t(wxSTC_LEX_BATCH, ?wxSTC_LEX_BATCH),
    t(wxSTC_LEX_MAKEFILE, ?wxSTC_LEX_MAKEFILE),
    t(wxSTC_LEX_ERRORLIST, ?wxSTC_LEX_ERRORLIST),
    t(wxSTC_LEX_PROPERTIES, ?wxSTC_LEX_PROPERTIES),
    t(wxSTC_LEX_VB, ?wxSTC_LEX_VB),
    t(wxSTC_LEX_SQL, ?wxSTC_LEX_SQL),
    t(wxSTC_LEX_PERL, ?wxSTC_LEX_PERL),
    t(wxSTC_LEX_XML, ?wxSTC_LEX_XML),
    t(wxSTC_LEX_HTML, ?wxSTC_LEX_HTML),
    t(wxSTC_LEX_CPP, ?wxSTC_LEX_CPP),
    t(wxSTC_LEX_PYTHON, ?wxSTC_LEX_PYTHON),
    t(wxSTC_LEX_NULL, ?wxSTC_LEX_NULL),
    t(wxSTC_LEX_CONTAINER, ?wxSTC_LEX_CONTAINER),
    t(wxSTC_AC_COMMAND, ?wxSTC_AC_COMMAND),
    t(wxSTC_AC_NEWLINE, ?wxSTC_AC_NEWLINE),
    t(wxSTC_AC_TAB, ?wxSTC_AC_TAB),
    t(wxSTC_AC_DOUBLECLICK, ?wxSTC_AC_DOUBLECLICK),
    t(wxSTC_AC_FILLUP, ?wxSTC_AC_FILLUP),
    t(wxSTC_KEYMOD_META, ?wxSTC_KEYMOD_META),
    t(wxSTC_KEYMOD_SUPER, ?wxSTC_KEYMOD_SUPER),
    t(wxSTC_KEYMOD_ALT, ?wxSTC_KEYMOD_ALT),
    t(wxSTC_KEYMOD_CTRL, ?wxSTC_KEYMOD_CTRL),
    t(wxSTC_KEYMOD_SHIFT, ?wxSTC_KEYMOD_SHIFT),
    t(wxSTC_KEYMOD_NORM, ?wxSTC_KEYMOD_NORM),
    t(wxSTC_KEY_MENU, ?wxSTC_KEY_MENU),
    t(wxSTC_KEY_RWIN, ?wxSTC_KEY_RWIN),
    t(wxSTC_KEY_WIN, ?wxSTC_KEY_WIN),
    t(wxSTC_KEY_DIVIDE, ?wxSTC_KEY_DIVIDE),
    t(wxSTC_KEY_SUBTRACT, ?wxSTC_KEY_SUBTRACT),
    t(wxSTC_KEY_ADD, ?wxSTC_KEY_ADD),
    t(wxSTC_KEY_RETURN, ?wxSTC_KEY_RETURN),
    t(wxSTC_KEY_TAB, ?wxSTC_KEY_TAB),
    t(wxSTC_KEY_BACK, ?wxSTC_KEY_BACK),
    t(wxSTC_KEY_ESCAPE, ?wxSTC_KEY_ESCAPE),
    t(wxSTC_KEY_INSERT, ?wxSTC_KEY_INSERT),
    t(wxSTC_KEY_DELETE, ?wxSTC_KEY_DELETE),
    t(wxSTC_KEY_NEXT, ?wxSTC_KEY_NEXT),
    t(wxSTC_KEY_PRIOR, ?wxSTC_KEY_PRIOR),
    t(wxSTC_KEY_END, ?wxSTC_KEY_END),
    t(wxSTC_KEY_HOME, ?wxSTC_KEY_HOME),
    t(wxSTC_KEY_RIGHT, ?wxSTC_KEY_RIGHT),
    t(wxSTC_KEY_LEFT, ?wxSTC_KEY_LEFT),
    t(wxSTC_KEY_UP, ?wxSTC_KEY_UP),
    t(wxSTC_KEY_DOWN, ?wxSTC_KEY_DOWN),
    t(wxSTC_UPDATE_H_SCROLL, ?wxSTC_UPDATE_H_SCROLL),
    t(wxSTC_UPDATE_V_SCROLL, ?wxSTC_UPDATE_V_SCROLL),
    t(wxSTC_UPDATE_SELECTION, ?wxSTC_UPDATE_SELECTION),
    t(wxSTC_UPDATE_CONTENT, ?wxSTC_UPDATE_CONTENT),
    t(wxSTC_MOD_CHANGETABSTOPS, ?wxSTC_MOD_CHANGETABSTOPS),
    t(wxSTC_MOD_INSERTCHECK, ?wxSTC_MOD_INSERTCHECK),
    t(wxSTC_MOD_LEXERSTATE, ?wxSTC_MOD_LEXERSTATE),
    t(wxSTC_MOD_CONTAINER, ?wxSTC_MOD_CONTAINER),
    t(wxSTC_MOD_CHANGEANNOTATION, ?wxSTC_MOD_CHANGEANNOTATION),
    t(wxSTC_MOD_CHANGEMARGIN, ?wxSTC_MOD_CHANGEMARGIN),
    t(wxSTC_MOD_CHANGELINESTATE, ?wxSTC_MOD_CHANGELINESTATE),
    t(wxSTC_MOD_CHANGEINDICATOR, ?wxSTC_MOD_CHANGEINDICATOR),
    t(wxSTC_STARTACTION, ?wxSTC_STARTACTION),
    t(wxSTC_MULTILINEUNDOREDO, ?wxSTC_MULTILINEUNDOREDO),
    t(wxSTC_MOD_BEFOREDELETE, ?wxSTC_MOD_BEFOREDELETE),
    t(wxSTC_MOD_BEFOREINSERT, ?wxSTC_MOD_BEFOREINSERT),
    t(wxSTC_MOD_CHANGEMARKER, ?wxSTC_MOD_CHANGEMARKER),
    t(wxSTC_LASTSTEPINUNDOREDO, ?wxSTC_LASTSTEPINUNDOREDO),
    t(wxSTC_MULTISTEPUNDOREDO, ?wxSTC_MULTISTEPUNDOREDO),
    t(wxSTC_PERFORMED_REDO, ?wxSTC_PERFORMED_REDO),
    t(wxSTC_PERFORMED_UNDO, ?wxSTC_PERFORMED_UNDO),
    t(wxSTC_PERFORMED_USER, ?wxSTC_PERFORMED_USER),
    t(wxSTC_MOD_CHANGEFOLD, ?wxSTC_MOD_CHANGEFOLD),
    t(wxSTC_MOD_CHANGESTYLE, ?wxSTC_MOD_CHANGESTYLE),
    t(wxSTC_MOD_DELETETEXT, ?wxSTC_MOD_DELETETEXT),
    t(wxSTC_MOD_INSERTTEXT, ?wxSTC_MOD_INSERTTEXT),
    t(wxSTC_TYPE_STRING, ?wxSTC_TYPE_STRING),
    t(wxSTC_TYPE_INTEGER, ?wxSTC_TYPE_INTEGER),
    t(wxSTC_TYPE_BOOLEAN, ?wxSTC_TYPE_BOOLEAN),
    t(wxSTC_KEYWORDSET_MAX, ?wxSTC_KEYWORDSET_MAX),
    t(wxSTC_LINE_END_TYPE_UNICODE, ?wxSTC_LINE_END_TYPE_UNICODE),
    t(wxSTC_LINE_END_TYPE_DEFAULT, ?wxSTC_LINE_END_TYPE_DEFAULT),
    t(wxSTC_TECHNOLOGY_DIRECTWRITE, ?wxSTC_TECHNOLOGY_DIRECTWRITE),
    t(wxSTC_TECHNOLOGY_DEFAULT, ?wxSTC_TECHNOLOGY_DEFAULT),
    t(wxSTC_VS_NOWRAPLINESTART, ?wxSTC_VS_NOWRAPLINESTART),
    t(wxSTC_VS_USERACCESSIBLE, ?wxSTC_VS_USERACCESSIBLE),
    t(wxSTC_VS_RECTANGULARSELECTION, ?wxSTC_VS_RECTANGULARSELECTION),
    t(wxSTC_VS_NONE, ?wxSTC_VS_NONE),
    t(wxSTC_UNDO_MAY_COALESCE, ?wxSTC_UNDO_MAY_COALESCE),
    t(wxSTC_ANNOTATION_INDENTED, ?wxSTC_ANNOTATION_INDENTED),
    t(wxSTC_ANNOTATION_BOXED, ?wxSTC_ANNOTATION_BOXED),
    t(wxSTC_ANNOTATION_STANDARD, ?wxSTC_ANNOTATION_STANDARD),
    t(wxSTC_ANNOTATION_HIDDEN, ?wxSTC_ANNOTATION_HIDDEN),
    t(wxSTC_MARGINOPTION_SUBLINESELECT, ?wxSTC_MARGINOPTION_SUBLINESELECT),
    t(wxSTC_MARGINOPTION_NONE, ?wxSTC_MARGINOPTION_NONE),
    t(wxSTC_CARETSTYLE_BLOCK, ?wxSTC_CARETSTYLE_BLOCK),
    t(wxSTC_CARETSTYLE_LINE, ?wxSTC_CARETSTYLE_LINE),
    t(wxSTC_CARETSTYLE_INVISIBLE, ?wxSTC_CARETSTYLE_INVISIBLE),
    t(wxSTC_ALPHA_NOALPHA, ?wxSTC_ALPHA_NOALPHA),
    t(wxSTC_ALPHA_OPAQUE, ?wxSTC_ALPHA_OPAQUE),
    t(wxSTC_ALPHA_TRANSPARENT, ?wxSTC_ALPHA_TRANSPARENT),
    t(wxSTC_CARETSTICKY_WHITESPACE, ?wxSTC_CARETSTICKY_WHITESPACE),
    t(wxSTC_CARETSTICKY_ON, ?wxSTC_CARETSTICKY_ON),
    t(wxSTC_CARETSTICKY_OFF, ?wxSTC_CARETSTICKY_OFF),
    t(wxSTC_ORDER_CUSTOM, ?wxSTC_ORDER_CUSTOM),
    t(wxSTC_ORDER_PERFORMSORT, ?wxSTC_ORDER_PERFORMSORT),
    t(wxSTC_ORDER_PRESORTED, ?wxSTC_ORDER_PRESORTED),
    t(wxSTC_MULTIAUTOC_EACH, ?wxSTC_MULTIAUTOC_EACH),
    t(wxSTC_MULTIAUTOC_ONCE, ?wxSTC_MULTIAUTOC_ONCE),
    t(wxSTC_CASEINSENSITIVEBEHAVIOUR_IGNORECASE, ?wxSTC_CASEINSENSITIVEBEHAVIOUR_IGNORECASE),
    t(wxSTC_CASEINSENSITIVEBEHAVIOUR_RESPECTCASE, ?wxSTC_CASEINSENSITIVEBEHAVIOUR_RESPECTCASE),
    t(wxSTC_SEL_THIN, ?wxSTC_SEL_THIN),
    t(wxSTC_SEL_LINES, ?wxSTC_SEL_LINES),
    t(wxSTC_SEL_RECTANGLE, ?wxSTC_SEL_RECTANGLE),
    t(wxSTC_SEL_STREAM, ?wxSTC_SEL_STREAM),
    t(wxSTC_CARET_EVEN, ?wxSTC_CARET_EVEN),
    t(wxSTC_CARET_JUMPS, ?wxSTC_CARET_JUMPS),
    t(wxSTC_CARET_STRICT, ?wxSTC_CARET_STRICT),
    t(wxSTC_CARET_SLOP, ?wxSTC_CARET_SLOP),
    t(wxSTC_VISIBLE_STRICT, ?wxSTC_VISIBLE_STRICT),
    t(wxSTC_VISIBLE_SLOP, ?wxSTC_VISIBLE_SLOP),
    t(wxSTC_CURSORREVERSEARROW, ?wxSTC_CURSORREVERSEARROW),
    t(wxSTC_CURSORWAIT, ?wxSTC_CURSORWAIT),
    t(wxSTC_CURSORARROW, ?wxSTC_CURSORARROW),
    t(wxSTC_CURSORNORMAL, ?wxSTC_CURSORNORMAL),
    t(wxSTC_STATUS_WARN_REGEX, ?wxSTC_STATUS_WARN_REGEX),
    t(wxSTC_STATUS_WARN_START, ?wxSTC_STATUS_WARN_START),
    t(wxSTC_STATUS_BADALLOC, ?wxSTC_STATUS_BADALLOC),
    t(wxSTC_STATUS_FAILURE, ?wxSTC_STATUS_FAILURE),
    t(wxSTC_STATUS_OK, ?wxSTC_STATUS_OK),
    t(wxSTC_POPUP_TEXT, ?wxSTC_POPUP_TEXT),
    t(wxSTC_POPUP_ALL, ?wxSTC_POPUP_ALL),
    t(wxSTC_POPUP_NEVER, ?wxSTC_POPUP_NEVER),
    t(wxSTC_EDGE_MULTILINE, ?wxSTC_EDGE_MULTILINE),
    t(wxSTC_EDGE_BACKGROUND, ?wxSTC_EDGE_BACKGROUND),
    t(wxSTC_EDGE_LINE, ?wxSTC_EDGE_LINE),
    t(wxSTC_EDGE_NONE, ?wxSTC_EDGE_NONE),
    t(wxSTC_MULTIPASTE_EACH, ?wxSTC_MULTIPASTE_EACH),
    t(wxSTC_MULTIPASTE_ONCE, ?wxSTC_MULTIPASTE_ONCE),
    t(wxSTC_EFF_QUALITY_LCD_OPTIMIZED, ?wxSTC_EFF_QUALITY_LCD_OPTIMIZED),
    t(wxSTC_EFF_QUALITY_ANTIALIASED, ?wxSTC_EFF_QUALITY_ANTIALIASED),
    t(wxSTC_EFF_QUALITY_NON_ANTIALIASED, ?wxSTC_EFF_QUALITY_NON_ANTIALIASED),
    t(wxSTC_EFF_QUALITY_DEFAULT, ?wxSTC_EFF_QUALITY_DEFAULT),
    t(wxSTC_EFF_QUALITY_MASK, ?wxSTC_EFF_QUALITY_MASK),
    t(wxSTC_PHASES_MULTIPLE, ?wxSTC_PHASES_MULTIPLE),
    t(wxSTC_PHASES_TWO, ?wxSTC_PHASES_TWO),
    t(wxSTC_PHASES_ONE, ?wxSTC_PHASES_ONE),
    t(wxSTC_CACHE_DOCUMENT, ?wxSTC_CACHE_DOCUMENT),
    t(wxSTC_CACHE_PAGE, ?wxSTC_CACHE_PAGE),
    t(wxSTC_CACHE_CARET, ?wxSTC_CACHE_CARET),
    t(wxSTC_CACHE_NONE, ?wxSTC_CACHE_NONE),
    t(wxSTC_WRAPINDENT_INDENT, ?wxSTC_WRAPINDENT_INDENT),
    t(wxSTC_WRAPINDENT_SAME, ?wxSTC_WRAPINDENT_SAME),
    t(wxSTC_WRAPINDENT_FIXED, ?wxSTC_WRAPINDENT_FIXED),
    t(wxSTC_WRAPVISUALFLAGLOC_START_BY_TEXT, ?wxSTC_WRAPVISUALFLAGLOC_START_BY_TEXT),
    t(wxSTC_WRAPVISUALFLAGLOC_END_BY_TEXT, ?wxSTC_WRAPVISUALFLAGLOC_END_BY_TEXT),
    t(wxSTC_WRAPVISUALFLAGLOC_DEFAULT, ?wxSTC_WRAPVISUALFLAGLOC_DEFAULT),
    t(wxSTC_WRAPVISUALFLAG_MARGIN, ?wxSTC_WRAPVISUALFLAG_MARGIN),
    t(wxSTC_WRAPVISUALFLAG_START, ?wxSTC_WRAPVISUALFLAG_START),
    t(wxSTC_WRAPVISUALFLAG_END, ?wxSTC_WRAPVISUALFLAG_END),
    t(wxSTC_WRAPVISUALFLAG_NONE, ?wxSTC_WRAPVISUALFLAG_NONE),
    t(wxSTC_WRAP_WHITESPACE, ?wxSTC_WRAP_WHITESPACE),
    t(wxSTC_WRAP_CHAR, ?wxSTC_WRAP_CHAR),
    t(wxSTC_WRAP_WORD, ?wxSTC_WRAP_WORD),
    t(wxSTC_WRAP_NONE, ?wxSTC_WRAP_NONE),
    t(wxSTC_IDLESTYLING_ALL, ?wxSTC_IDLESTYLING_ALL),
    t(wxSTC_IDLESTYLING_AFTERVISIBLE, ?wxSTC_IDLESTYLING_AFTERVISIBLE),
    t(wxSTC_IDLESTYLING_TOVISIBLE, ?wxSTC_IDLESTYLING_TOVISIBLE),
    t(wxSTC_IDLESTYLING_NONE, ?wxSTC_IDLESTYLING_NONE),
    t(wxSTC_TIME_FOREVER, ?wxSTC_TIME_FOREVER),
    t(wxSTC_AUTOMATICFOLD_CHANGE, ?wxSTC_AUTOMATICFOLD_CHANGE),
    t(wxSTC_AUTOMATICFOLD_CLICK, ?wxSTC_AUTOMATICFOLD_CLICK),
    t(wxSTC_AUTOMATICFOLD_SHOW, ?wxSTC_AUTOMATICFOLD_SHOW),
    t(wxSTC_FOLDACTION_TOGGLE, ?wxSTC_FOLDACTION_TOGGLE),
    t(wxSTC_FOLDACTION_EXPAND, ?wxSTC_FOLDACTION_EXPAND),
    t(wxSTC_FOLDACTION_CONTRACT, ?wxSTC_FOLDACTION_CONTRACT),
    t(wxSTC_FOLDDISPLAYTEXT_BOXED, ?wxSTC_FOLDDISPLAYTEXT_BOXED),
    t(wxSTC_FOLDDISPLAYTEXT_STANDARD, ?wxSTC_FOLDDISPLAYTEXT_STANDARD),
    t(wxSTC_FOLDDISPLAYTEXT_HIDDEN, ?wxSTC_FOLDDISPLAYTEXT_HIDDEN),
    t(wxSTC_FOLDLEVELNUMBERMASK, ?wxSTC_FOLDLEVELNUMBERMASK),
    t(wxSTC_FOLDLEVELHEADERFLAG, ?wxSTC_FOLDLEVELHEADERFLAG),
    t(wxSTC_FOLDLEVELWHITEFLAG, ?wxSTC_FOLDLEVELWHITEFLAG),
    t(wxSTC_FOLDLEVELBASE, ?wxSTC_FOLDLEVELBASE),
    t(wxSTC_FIND_POSIX, ?wxSTC_FIND_POSIX),
    t(wxSTC_FIND_REGEXP, ?wxSTC_FIND_REGEXP),
    t(wxSTC_FIND_WORDSTART, ?wxSTC_FIND_WORDSTART),
    t(wxSTC_FIND_MATCHCASE, ?wxSTC_FIND_MATCHCASE),
    t(wxSTC_FIND_WHOLEWORD, ?wxSTC_FIND_WHOLEWORD),
    t(wxSTC_PRINT_COLOURONWHITEDEFAULTBG, ?wxSTC_PRINT_COLOURONWHITEDEFAULTBG),
    t(wxSTC_PRINT_COLOURONWHITE, ?wxSTC_PRINT_COLOURONWHITE),
    t(wxSTC_PRINT_BLACKONWHITE, ?wxSTC_PRINT_BLACKONWHITE),
    t(wxSTC_PRINT_INVERTLIGHT, ?wxSTC_PRINT_INVERTLIGHT),
    t(wxSTC_PRINT_NORMAL, ?wxSTC_PRINT_NORMAL),
    t(wxSTC_IV_LOOKBOTH, ?wxSTC_IV_LOOKBOTH),
    t(wxSTC_IV_LOOKFORWARD, ?wxSTC_IV_LOOKFORWARD),
    t(wxSTC_IV_REAL, ?wxSTC_IV_REAL),
    t(wxSTC_IV_NONE, ?wxSTC_IV_NONE),
    t(wxSTC_INDICFLAG_VALUEFORE, ?wxSTC_INDICFLAG_VALUEFORE),
    t(wxSTC_INDICVALUEMASK, ?wxSTC_INDICVALUEMASK),
    t(wxSTC_INDICVALUEBIT, ?wxSTC_INDICVALUEBIT),
    t(wxSTC_INDIC_CONTAINER, ?wxSTC_INDIC_CONTAINER),
    t(wxSTC_INDIC_IME_MAX, ?wxSTC_INDIC_IME_MAX),
    t(wxSTC_INDIC_IME, ?wxSTC_INDIC_IME),
    t(wxSTC_INDIC_POINTCHARACTER, ?wxSTC_INDIC_POINTCHARACTER),
    t(wxSTC_INDIC_POINT, ?wxSTC_INDIC_POINT),
    t(wxSTC_INDIC_TEXTFORE, ?wxSTC_INDIC_TEXTFORE),
    t(wxSTC_INDIC_FULLBOX, ?wxSTC_INDIC_FULLBOX),
    t(wxSTC_INDIC_COMPOSITIONTHIN, ?wxSTC_INDIC_COMPOSITIONTHIN),
    t(wxSTC_INDIC_COMPOSITIONTHICK, ?wxSTC_INDIC_COMPOSITIONTHICK),
    t(wxSTC_INDIC_SQUIGGLEPIXMAP, ?wxSTC_INDIC_SQUIGGLEPIXMAP),
    t(wxSTC_INDIC_DOTBOX, ?wxSTC_INDIC_DOTBOX),
    t(wxSTC_INDIC_SQUIGGLELOW, ?wxSTC_INDIC_SQUIGGLELOW),
    t(wxSTC_INDIC_DOTS, ?wxSTC_INDIC_DOTS),
    t(wxSTC_INDIC_DASH, ?wxSTC_INDIC_DASH),
    t(wxSTC_INDIC_STRAIGHTBOX, ?wxSTC_INDIC_STRAIGHTBOX),
    t(wxSTC_INDIC_ROUNDBOX, ?wxSTC_INDIC_ROUNDBOX),
    t(wxSTC_INDIC_BOX, ?wxSTC_INDIC_BOX),
    t(wxSTC_INDIC_HIDDEN, ?wxSTC_INDIC_HIDDEN),
    t(wxSTC_INDIC_STRIKE, ?wxSTC_INDIC_STRIKE),
    t(wxSTC_INDIC_DIAGONAL, ?wxSTC_INDIC_DIAGONAL),
    t(wxSTC_INDIC_TT, ?wxSTC_INDIC_TT),
    t(wxSTC_INDIC_SQUIGGLE, ?wxSTC_INDIC_SQUIGGLE),
    t(wxSTC_INDIC_PLAIN, ?wxSTC_INDIC_PLAIN),
    t(wxSTC_WEIGHT_BOLD, ?wxSTC_WEIGHT_BOLD),
    t(wxSTC_WEIGHT_SEMIBOLD, ?wxSTC_WEIGHT_SEMIBOLD),
    t(wxSTC_WEIGHT_NORMAL, ?wxSTC_WEIGHT_NORMAL),
    t(wxSTC_FONT_SIZE_MULTIPLIER, ?wxSTC_FONT_SIZE_MULTIPLIER),
    t(wxSTC_CASE_CAMEL, ?wxSTC_CASE_CAMEL),
    t(wxSTC_CASE_LOWER, ?wxSTC_CASE_LOWER),
    t(wxSTC_CASE_UPPER, ?wxSTC_CASE_UPPER),
    t(wxSTC_CASE_MIXED, ?wxSTC_CASE_MIXED),
    t(wxSTC_CHARSET_8859_15, ?wxSTC_CHARSET_8859_15),
    t(wxSTC_CHARSET_THAI, ?wxSTC_CHARSET_THAI),
    t(wxSTC_CHARSET_VIETNAMESE, ?wxSTC_CHARSET_VIETNAMESE),
    t(wxSTC_CHARSET_ARABIC, ?wxSTC_CHARSET_ARABIC),
    t(wxSTC_CHARSET_HEBREW, ?wxSTC_CHARSET_HEBREW),
    t(wxSTC_CHARSET_JOHAB, ?wxSTC_CHARSET_JOHAB),
    t(wxSTC_CHARSET_TURKISH, ?wxSTC_CHARSET_TURKISH),
    t(wxSTC_CHARSET_SYMBOL, ?wxSTC_CHARSET_SYMBOL),
    t(wxSTC_CHARSET_SHIFTJIS, ?wxSTC_CHARSET_SHIFTJIS),
    t(wxSTC_CHARSET_CYRILLIC, ?wxSTC_CHARSET_CYRILLIC),
    t(wxSTC_CHARSET_OEM866, ?wxSTC_CHARSET_OEM866),
    t(wxSTC_CHARSET_RUSSIAN, ?wxSTC_CHARSET_RUSSIAN),
    t(wxSTC_CHARSET_OEM, ?wxSTC_CHARSET_OEM),
    t(wxSTC_CHARSET_MAC, ?wxSTC_CHARSET_MAC),
    t(wxSTC_CHARSET_HANGUL, ?wxSTC_CHARSET_HANGUL),
    t(wxSTC_CHARSET_GREEK, ?wxSTC_CHARSET_GREEK),
    t(wxSTC_CHARSET_GB2312, ?wxSTC_CHARSET_GB2312),
    t(wxSTC_CHARSET_EASTEUROPE, ?wxSTC_CHARSET_EASTEUROPE),
    t(wxSTC_CHARSET_CHINESEBIG5, ?wxSTC_CHARSET_CHINESEBIG5),
    t(wxSTC_CHARSET_BALTIC, ?wxSTC_CHARSET_BALTIC),
    t(wxSTC_CHARSET_DEFAULT, ?wxSTC_CHARSET_DEFAULT),
    t(wxSTC_CHARSET_ANSI, ?wxSTC_CHARSET_ANSI),
    t(wxSTC_STYLE_LASTPREDEFINED, ?wxSTC_STYLE_LASTPREDEFINED),
    t(wxSTC_STYLE_FOLDDISPLAYTEXT, ?wxSTC_STYLE_FOLDDISPLAYTEXT),
    t(wxSTC_STYLE_CALLTIP, ?wxSTC_STYLE_CALLTIP),
    t(wxSTC_STYLE_INDENTGUIDE, ?wxSTC_STYLE_INDENTGUIDE),
    t(wxSTC_STYLE_CONTROLCHAR, ?wxSTC_STYLE_CONTROLCHAR),
    t(wxSTC_STYLE_BRACEBAD, ?wxSTC_STYLE_BRACEBAD),
    t(wxSTC_STYLE_BRACELIGHT, ?wxSTC_STYLE_BRACELIGHT),
    t(wxSTC_STYLE_LINENUMBER, ?wxSTC_STYLE_LINENUMBER),
    t(wxSTC_STYLE_DEFAULT, ?wxSTC_STYLE_DEFAULT),
    t(wxSTC_MARGIN_COLOUR, ?wxSTC_MARGIN_COLOUR),
    t(wxSTC_MARGIN_RTEXT, ?wxSTC_MARGIN_RTEXT),
    t(wxSTC_MARGIN_TEXT, ?wxSTC_MARGIN_TEXT),
    t(wxSTC_MARGIN_FORE, ?wxSTC_MARGIN_FORE),
    t(wxSTC_MARGIN_BACK, ?wxSTC_MARGIN_BACK),
    t(wxSTC_MARGIN_NUMBER, ?wxSTC_MARGIN_NUMBER),
    t(wxSTC_MARGIN_SYMBOL, ?wxSTC_MARGIN_SYMBOL),
    t(wxSTC_MAX_MARGIN, ?wxSTC_MAX_MARGIN),
    t(wxSTC_MASK_FOLDERS, ?wxSTC_MASK_FOLDERS),
    t(wxSTC_MARKNUM_FOLDEROPEN, ?wxSTC_MARKNUM_FOLDEROPEN),
    t(wxSTC_MARKNUM_FOLDER, ?wxSTC_MARKNUM_FOLDER),
    t(wxSTC_MARKNUM_FOLDERSUB, ?wxSTC_MARKNUM_FOLDERSUB),
    t(wxSTC_MARKNUM_FOLDERTAIL, ?wxSTC_MARKNUM_FOLDERTAIL),
    t(wxSTC_MARKNUM_FOLDERMIDTAIL, ?wxSTC_MARKNUM_FOLDERMIDTAIL),
    t(wxSTC_MARKNUM_FOLDEROPENMID, ?wxSTC_MARKNUM_FOLDEROPENMID),
    t(wxSTC_MARKNUM_FOLDEREND, ?wxSTC_MARKNUM_FOLDEREND),
    t(wxSTC_MARK_CHARACTER, ?wxSTC_MARK_CHARACTER),
    t(wxSTC_MARK_BOOKMARK, ?wxSTC_MARK_BOOKMARK),
    t(wxSTC_MARK_RGBAIMAGE, ?wxSTC_MARK_RGBAIMAGE),
    t(wxSTC_MARK_UNDERLINE, ?wxSTC_MARK_UNDERLINE),
    t(wxSTC_MARK_AVAILABLE, ?wxSTC_MARK_AVAILABLE),
    t(wxSTC_MARK_LEFTRECT, ?wxSTC_MARK_LEFTRECT),
    t(wxSTC_MARK_FULLRECT, ?wxSTC_MARK_FULLRECT),
    t(wxSTC_MARK_PIXMAP, ?wxSTC_MARK_PIXMAP),
    t(wxSTC_MARK_ARROWS, ?wxSTC_MARK_ARROWS),
    t(wxSTC_MARK_DOTDOTDOT, ?wxSTC_MARK_DOTDOTDOT),
    t(wxSTC_MARK_BACKGROUND, ?wxSTC_MARK_BACKGROUND),
    t(wxSTC_MARK_CIRCLEMINUSCONNECTED, ?wxSTC_MARK_CIRCLEMINUSCONNECTED),
    t(wxSTC_MARK_CIRCLEMINUS, ?wxSTC_MARK_CIRCLEMINUS),
    t(wxSTC_MARK_CIRCLEPLUSCONNECTED, ?wxSTC_MARK_CIRCLEPLUSCONNECTED),
    t(wxSTC_MARK_CIRCLEPLUS, ?wxSTC_MARK_CIRCLEPLUS),
    t(wxSTC_MARK_TCORNERCURVE, ?wxSTC_MARK_TCORNERCURVE),
    t(wxSTC_MARK_LCORNERCURVE, ?wxSTC_MARK_LCORNERCURVE),
    t(wxSTC_MARK_BOXMINUSCONNECTED, ?wxSTC_MARK_BOXMINUSCONNECTED),
    t(wxSTC_MARK_BOXMINUS, ?wxSTC_MARK_BOXMINUS),
    t(wxSTC_MARK_BOXPLUSCONNECTED, ?wxSTC_MARK_BOXPLUSCONNECTED),
    t(wxSTC_MARK_BOXPLUS, ?wxSTC_MARK_BOXPLUS),
    t(wxSTC_MARK_TCORNER, ?wxSTC_MARK_TCORNER),
    t(wxSTC_MARK_LCORNER, ?wxSTC_MARK_LCORNER),
    t(wxSTC_MARK_VLINE, ?wxSTC_MARK_VLINE),
    t(wxSTC_MARK_PLUS, ?wxSTC_MARK_PLUS),
    t(wxSTC_MARK_MINUS, ?wxSTC_MARK_MINUS),
    t(wxSTC_MARK_ARROWDOWN, ?wxSTC_MARK_ARROWDOWN),
    t(wxSTC_MARK_EMPTY, ?wxSTC_MARK_EMPTY),
    t(wxSTC_MARK_SHORTARROW, ?wxSTC_MARK_SHORTARROW),
    t(wxSTC_MARK_SMALLRECT, ?wxSTC_MARK_SMALLRECT),
    t(wxSTC_MARK_ARROW, ?wxSTC_MARK_ARROW),
    t(wxSTC_MARK_ROUNDRECT, ?wxSTC_MARK_ROUNDRECT),
    t(wxSTC_MARK_CIRCLE, ?wxSTC_MARK_CIRCLE),
    t(wxSTC_MARKER_MAX, ?wxSTC_MARKER_MAX),
    t(wxSTC_IME_INLINE, ?wxSTC_IME_INLINE),
    t(wxSTC_IME_WINDOWED, ?wxSTC_IME_WINDOWED),
    t(wxSTC_CP_UTF8, ?wxSTC_CP_UTF8),
    t(wxSTC_EOL_LF, ?wxSTC_EOL_LF),
    t(wxSTC_EOL_CR, ?wxSTC_EOL_CR),
    t(wxSTC_EOL_CRLF, ?wxSTC_EOL_CRLF),
    t(wxSTC_TD_STRIKEOUT, ?wxSTC_TD_STRIKEOUT),
    t(wxSTC_TD_LONGARROW, ?wxSTC_TD_LONGARROW),
    t(wxSTC_WS_VISIBLEONLYININDENT, ?wxSTC_WS_VISIBLEONLYININDENT),
    t(wxSTC_WS_VISIBLEAFTERINDENT, ?wxSTC_WS_VISIBLEAFTERINDENT),
    t(wxSTC_WS_VISIBLEALWAYS, ?wxSTC_WS_VISIBLEALWAYS),
    t(wxSTC_WS_INVISIBLE, ?wxSTC_WS_INVISIBLE),
    t(wxSTC_LEXER_START, ?wxSTC_LEXER_START),
    t(wxSTC_OPTIONAL_START, ?wxSTC_OPTIONAL_START),
    t(wxSTC_START, ?wxSTC_START),
    t(wxSTC_INVALID_POSITION, ?wxSTC_INVALID_POSITION),
    t(wxTBI_DOCK, ?wxTBI_DOCK),
    t(wxTBI_CUSTOM_STATUSITEM, ?wxTBI_CUSTOM_STATUSITEM),
    t(wxTBI_DEFAULT_TYPE, {ignore, "wxTBI_DEFAULT_TYPE"}),
    t(wxTEXT_TYPE_ANY, ?wxTEXT_TYPE_ANY),
    t(wxTE_RICH2, ?wxTE_RICH2),
    t(wxTE_BESTWRAP, ?wxTE_BESTWRAP),
    t(wxTE_WORDWRAP, ?wxTE_WORDWRAP),
    t(wxTE_CHARWRAP, ?wxTE_CHARWRAP),
    t(wxTE_DONTWRAP, ?wxTE_DONTWRAP),
    t(wxTE_NOHIDESEL, ?wxTE_NOHIDESEL),
    t(wxTE_AUTO_URL, ?wxTE_AUTO_URL),
    t(wxTE_PASSWORD, ?wxTE_PASSWORD),
    t(wxTE_PROCESS_ENTER, ?wxTE_PROCESS_ENTER),
    t(wxTE_RICH, ?wxTE_RICH),
    t(wxTE_CENTRE, ?wxTE_CENTRE),
    t(wxTE_RIGHT, ?wxTE_RIGHT),
    t(wxTE_CENTER, ?wxTE_CENTER),
    t(wxTE_LEFT, ?wxTE_LEFT),
    t(wxTE_PROCESS_TAB, ?wxTE_PROCESS_TAB),
    t(wxTE_MULTILINE, ?wxTE_MULTILINE),
    t(wxTE_READONLY, ?wxTE_READONLY),
    t(wxTE_NO_VSCROLL, ?wxTE_NO_VSCROLL),
    t(wxTEXT_ALIGNMENT_DEFAULT, ?wxTEXT_ALIGNMENT_DEFAULT),
    t(wxTEXT_ALIGNMENT_LEFT, ?wxTEXT_ALIGNMENT_LEFT),
    t(wxTEXT_ALIGNMENT_CENTRE, ?wxTEXT_ALIGNMENT_CENTRE),
    t(wxTEXT_ALIGNMENT_CENTER, ?wxTEXT_ALIGNMENT_CENTER),
    t(wxTEXT_ALIGNMENT_RIGHT, ?wxTEXT_ALIGNMENT_RIGHT),
    t(wxTEXT_ALIGNMENT_JUSTIFIED, ?wxTEXT_ALIGNMENT_JUSTIFIED),
    t(wxTEXT_ATTR_BULLET_STYLE_NONE, ?wxTEXT_ATTR_BULLET_STYLE_NONE),
    t(wxTEXT_ATTR_BULLET_STYLE_ARABIC, ?wxTEXT_ATTR_BULLET_STYLE_ARABIC),
    t(wxTEXT_ATTR_BULLET_STYLE_LETTERS_UPPER, ?wxTEXT_ATTR_BULLET_STYLE_LETTERS_UPPER),
    t(wxTEXT_ATTR_BULLET_STYLE_LETTERS_LOWER, ?wxTEXT_ATTR_BULLET_STYLE_LETTERS_LOWER),
    t(wxTEXT_ATTR_BULLET_STYLE_ROMAN_UPPER, ?wxTEXT_ATTR_BULLET_STYLE_ROMAN_UPPER),
    t(wxTEXT_ATTR_BULLET_STYLE_ROMAN_LOWER, ?wxTEXT_ATTR_BULLET_STYLE_ROMAN_LOWER),
    t(wxTEXT_ATTR_BULLET_STYLE_SYMBOL, ?wxTEXT_ATTR_BULLET_STYLE_SYMBOL),
    t(wxTEXT_ATTR_BULLET_STYLE_BITMAP, ?wxTEXT_ATTR_BULLET_STYLE_BITMAP),
    t(wxTEXT_ATTR_BULLET_STYLE_PARENTHESES, ?wxTEXT_ATTR_BULLET_STYLE_PARENTHESES),
    t(wxTEXT_ATTR_BULLET_STYLE_PERIOD, ?wxTEXT_ATTR_BULLET_STYLE_PERIOD),
    t(wxTEXT_ATTR_BULLET_STYLE_STANDARD, ?wxTEXT_ATTR_BULLET_STYLE_STANDARD),
    t(wxTEXT_ATTR_BULLET_STYLE_RIGHT_PARENTHESIS, ?wxTEXT_ATTR_BULLET_STYLE_RIGHT_PARENTHESIS),
    t(wxTEXT_ATTR_BULLET_STYLE_OUTLINE, ?wxTEXT_ATTR_BULLET_STYLE_OUTLINE),
    t(wxTEXT_ATTR_BULLET_STYLE_ALIGN_LEFT, ?wxTEXT_ATTR_BULLET_STYLE_ALIGN_LEFT),
    t(wxTEXT_ATTR_BULLET_STYLE_ALIGN_RIGHT, ?wxTEXT_ATTR_BULLET_STYLE_ALIGN_RIGHT),
    t(wxTEXT_ATTR_BULLET_STYLE_ALIGN_CENTRE, ?wxTEXT_ATTR_BULLET_STYLE_ALIGN_CENTRE),
    t(wxTEXT_ATTR_BULLET_STYLE_CONTINUATION, ?wxTEXT_ATTR_BULLET_STYLE_CONTINUATION),
    t(wxTEXT_ATTR_EFFECT_NONE, ?wxTEXT_ATTR_EFFECT_NONE),
    t(wxTEXT_ATTR_EFFECT_CAPITALS, ?wxTEXT_ATTR_EFFECT_CAPITALS),
    t(wxTEXT_ATTR_EFFECT_SMALL_CAPITALS, ?wxTEXT_ATTR_EFFECT_SMALL_CAPITALS),
    t(wxTEXT_ATTR_EFFECT_STRIKETHROUGH, ?wxTEXT_ATTR_EFFECT_STRIKETHROUGH),
    t(wxTEXT_ATTR_EFFECT_DOUBLE_STRIKETHROUGH, ?wxTEXT_ATTR_EFFECT_DOUBLE_STRIKETHROUGH),
    t(wxTEXT_ATTR_EFFECT_SHADOW, ?wxTEXT_ATTR_EFFECT_SHADOW),
    t(wxTEXT_ATTR_EFFECT_EMBOSS, ?wxTEXT_ATTR_EFFECT_EMBOSS),
    t(wxTEXT_ATTR_EFFECT_OUTLINE, ?wxTEXT_ATTR_EFFECT_OUTLINE),
    t(wxTEXT_ATTR_EFFECT_ENGRAVE, ?wxTEXT_ATTR_EFFECT_ENGRAVE),
    t(wxTEXT_ATTR_EFFECT_SUPERSCRIPT, ?wxTEXT_ATTR_EFFECT_SUPERSCRIPT),
    t(wxTEXT_ATTR_EFFECT_SUBSCRIPT, ?wxTEXT_ATTR_EFFECT_SUBSCRIPT),
    t(wxTEXT_ATTR_EFFECT_RTL, ?wxTEXT_ATTR_EFFECT_RTL),
    t(wxTEXT_ATTR_EFFECT_SUPPRESS_HYPHENATION, ?wxTEXT_ATTR_EFFECT_SUPPRESS_HYPHENATION),
    t(wxTEXT_ATTR_TEXT_COLOUR, ?wxTEXT_ATTR_TEXT_COLOUR),
    t(wxTEXT_ATTR_BACKGROUND_COLOUR, ?wxTEXT_ATTR_BACKGROUND_COLOUR),
    t(wxTEXT_ATTR_FONT_FACE, ?wxTEXT_ATTR_FONT_FACE),
    t(wxTEXT_ATTR_FONT_POINT_SIZE, ?wxTEXT_ATTR_FONT_POINT_SIZE),
    t(wxTEXT_ATTR_FONT_PIXEL_SIZE, ?wxTEXT_ATTR_FONT_PIXEL_SIZE),
    t(wxTEXT_ATTR_FONT_WEIGHT, ?wxTEXT_ATTR_FONT_WEIGHT),
    t(wxTEXT_ATTR_FONT_ITALIC, ?wxTEXT_ATTR_FONT_ITALIC),
    t(wxTEXT_ATTR_FONT_UNDERLINE, ?wxTEXT_ATTR_FONT_UNDERLINE),
    t(wxTEXT_ATTR_FONT_STRIKETHROUGH, ?wxTEXT_ATTR_FONT_STRIKETHROUGH),
    t(wxTEXT_ATTR_FONT_ENCODING, ?wxTEXT_ATTR_FONT_ENCODING),
    t(wxTEXT_ATTR_FONT_FAMILY, ?wxTEXT_ATTR_FONT_FAMILY),
    t(wxTEXT_ATTR_FONT_SIZE, ?wxTEXT_ATTR_FONT_SIZE),
    t(wxTEXT_ATTR_FONT, ?wxTEXT_ATTR_FONT),
    t(wxTEXT_ATTR_ALIGNMENT, ?wxTEXT_ATTR_ALIGNMENT),
    t(wxTEXT_ATTR_LEFT_INDENT, ?wxTEXT_ATTR_LEFT_INDENT),
    t(wxTEXT_ATTR_RIGHT_INDENT, ?wxTEXT_ATTR_RIGHT_INDENT),
    t(wxTEXT_ATTR_TABS, ?wxTEXT_ATTR_TABS),
    t(wxTEXT_ATTR_PARA_SPACING_AFTER, ?wxTEXT_ATTR_PARA_SPACING_AFTER),
    t(wxTEXT_ATTR_PARA_SPACING_BEFORE, ?wxTEXT_ATTR_PARA_SPACING_BEFORE),
    t(wxTEXT_ATTR_LINE_SPACING, ?wxTEXT_ATTR_LINE_SPACING),
    t(wxTEXT_ATTR_CHARACTER_STYLE_NAME, ?wxTEXT_ATTR_CHARACTER_STYLE_NAME),
    t(wxTEXT_ATTR_PARAGRAPH_STYLE_NAME, ?wxTEXT_ATTR_PARAGRAPH_STYLE_NAME),
    t(wxTEXT_ATTR_LIST_STYLE_NAME, ?wxTEXT_ATTR_LIST_STYLE_NAME),
    t(wxTEXT_ATTR_BULLET_STYLE, ?wxTEXT_ATTR_BULLET_STYLE),
    t(wxTEXT_ATTR_BULLET_NUMBER, ?wxTEXT_ATTR_BULLET_NUMBER),
    t(wxTEXT_ATTR_BULLET_TEXT, ?wxTEXT_ATTR_BULLET_TEXT),
    t(wxTEXT_ATTR_BULLET_NAME, ?wxTEXT_ATTR_BULLET_NAME),
    t(wxTEXT_ATTR_BULLET, ?wxTEXT_ATTR_BULLET),
    t(wxTEXT_ATTR_URL, ?wxTEXT_ATTR_URL),
    t(wxTEXT_ATTR_PAGE_BREAK, ?wxTEXT_ATTR_PAGE_BREAK),
    t(wxTEXT_ATTR_EFFECTS, ?wxTEXT_ATTR_EFFECTS),
    t(wxTEXT_ATTR_OUTLINE_LEVEL, ?wxTEXT_ATTR_OUTLINE_LEVEL),
    t(wxTEXT_ATTR_AVOID_PAGE_BREAK_BEFORE, ?wxTEXT_ATTR_AVOID_PAGE_BREAK_BEFORE),
    t(wxTEXT_ATTR_AVOID_PAGE_BREAK_AFTER, ?wxTEXT_ATTR_AVOID_PAGE_BREAK_AFTER),
    t(wxTEXT_ATTR_CHARACTER, ?wxTEXT_ATTR_CHARACTER),
    t(wxTEXT_ATTR_PARAGRAPH, ?wxTEXT_ATTR_PARAGRAPH),
    t(wxTEXT_ATTR_ALL, ?wxTEXT_ATTR_ALL),
    t(wxTEXT_ATTR_LINE_SPACING_NORMAL, ?wxTEXT_ATTR_LINE_SPACING_NORMAL),
    t(wxTEXT_ATTR_LINE_SPACING_HALF, ?wxTEXT_ATTR_LINE_SPACING_HALF),
    t(wxTEXT_ATTR_LINE_SPACING_TWICE, ?wxTEXT_ATTR_LINE_SPACING_TWICE),
    t(wxTEXT_ATTR_UNDERLINE_NONE, ?wxTEXT_ATTR_UNDERLINE_NONE),
    t(wxTEXT_ATTR_UNDERLINE_SOLID, ?wxTEXT_ATTR_UNDERLINE_SOLID),
    t(wxTEXT_ATTR_UNDERLINE_DOUBLE, ?wxTEXT_ATTR_UNDERLINE_DOUBLE),
    t(wxTEXT_ATTR_UNDERLINE_SPECIAL, ?wxTEXT_ATTR_UNDERLINE_SPECIAL),
    t(wxTE_HT_UNKNOWN, ?wxTE_HT_UNKNOWN),
    t(wxTE_HT_BEFORE, ?wxTE_HT_BEFORE),
    t(wxTE_HT_ON_TEXT, ?wxTE_HT_ON_TEXT),
    t(wxTE_HT_BELOW, ?wxTE_HT_BELOW),
    t(wxTE_HT_BEYOND, ?wxTE_HT_BEYOND),
    t(wxTextEntryDialogStyle, ?wxTextEntryDialogStyle),
    t(wxTB_HORIZONTAL, ?wxTB_HORIZONTAL),
    t(wxTB_TOP, ?wxTB_TOP),
    t(wxTB_VERTICAL, ?wxTB_VERTICAL),
    t(wxTB_LEFT, ?wxTB_LEFT),
    t(wxTB_HORZ_TEXT, ?wxTB_HORZ_TEXT),
    t(wxTB_DEFAULT_STYLE, ?wxTB_DEFAULT_STYLE),
    t(wxTBK_HORZ_LAYOUT, ?wxTBK_HORZ_LAYOUT),
    t(wxTBK_BUTTONBAR, ?wxTBK_BUTTONBAR),
    t(wxUSER_ATTENTION_INFO, ?wxUSER_ATTENTION_INFO),
    t(wxUSER_ATTENTION_ERROR, ?wxUSER_ATTENTION_ERROR),
    t(wxFULLSCREEN_NOMENUBAR, ?wxFULLSCREEN_NOMENUBAR),
    t(wxFULLSCREEN_NOTOOLBAR, ?wxFULLSCREEN_NOTOOLBAR),
    t(wxFULLSCREEN_NOSTATUSBAR, ?wxFULLSCREEN_NOSTATUSBAR),
    t(wxFULLSCREEN_NOBORDER, ?wxFULLSCREEN_NOBORDER),
    t(wxFULLSCREEN_NOCAPTION, ?wxFULLSCREEN_NOCAPTION),
    t(wxFULLSCREEN_ALL, ?wxFULLSCREEN_ALL),
    t(wxDEFAULT_FRAME_STYLE, ?wxDEFAULT_FRAME_STYLE),
    t(wxTR_DEFAULT_STYLE, {ignore, "wxTR_DEFAULT_STYLE"}),
    t(wxTR_FULL_ROW_HIGHLIGHT, ?wxTR_FULL_ROW_HIGHLIGHT),
    t(wxTR_HIDE_ROOT, ?wxTR_HIDE_ROOT),
    t(wxTR_ROW_LINES, ?wxTR_ROW_LINES),
    t(wxTR_EDIT_LABELS, ?wxTR_EDIT_LABELS),
    t(wxTR_HAS_VARIABLE_ROW_HEIGHT, ?wxTR_HAS_VARIABLE_ROW_HEIGHT),
    t(wxTR_MULTIPLE, ?wxTR_MULTIPLE),
    t(wxTR_SINGLE, ?wxTR_SINGLE),
    t(wxTR_TWIST_BUTTONS, ?wxTR_TWIST_BUTTONS),
    t(wxTR_LINES_AT_ROOT, ?wxTR_LINES_AT_ROOT),
    t(wxTR_NO_LINES, ?wxTR_NO_LINES),
    t(wxTR_HAS_BUTTONS, ?wxTR_HAS_BUTTONS),
    t(wxTR_NO_BUTTONS, ?wxTR_NO_BUTTONS),
    t(wxTreeItemIcon_Normal, ?wxTreeItemIcon_Normal),
    t(wxTreeItemIcon_Selected, ?wxTreeItemIcon_Selected),
    t(wxTreeItemIcon_Expanded, ?wxTreeItemIcon_Expanded),
    t(wxTreeItemIcon_SelectedExpanded, ?wxTreeItemIcon_SelectedExpanded),
    t(wxTreeItemIcon_Max, ?wxTreeItemIcon_Max),
    t(wxStrip_Mnemonics, ?wxStrip_Mnemonics),
    t(wxStrip_Accel, ?wxStrip_Accel),
    t(wxStrip_CJKMnemonics, ?wxStrip_CJKMnemonics),
    t(wxStrip_All, ?wxStrip_All),
    t(wxStrip_Menu, ?wxStrip_Menu),
    t(wxKILL_OK, ?wxKILL_OK),
    t(wxKILL_BAD_SIGNAL, ?wxKILL_BAD_SIGNAL),
    t(wxKILL_ACCESS_DENIED, ?wxKILL_ACCESS_DENIED),
    t(wxKILL_NO_PROCESS, ?wxKILL_NO_PROCESS),
    t(wxKILL_ERROR, ?wxKILL_ERROR),
    t(wxKILL_NOCHILDREN, ?wxKILL_NOCHILDREN),
    t(wxKILL_CHILDREN, ?wxKILL_CHILDREN),
    t(wxSHUTDOWN_FORCE, ?wxSHUTDOWN_FORCE),
    t(wxSHUTDOWN_POWEROFF, ?wxSHUTDOWN_POWEROFF),
    t(wxSHUTDOWN_REBOOT, ?wxSHUTDOWN_REBOOT),
    t(wxSHUTDOWN_LOGOFF, ?wxSHUTDOWN_LOGOFF),
    t(wxTOUCH_NONE, ?wxTOUCH_NONE),
    t(wxTOUCH_VERTICAL_PAN_GESTURE, ?wxTOUCH_VERTICAL_PAN_GESTURE),
    t(wxTOUCH_HORIZONTAL_PAN_GESTURE, ?wxTOUCH_HORIZONTAL_PAN_GESTURE),
    t(wxTOUCH_PAN_GESTURES, ?wxTOUCH_PAN_GESTURES),
    t(wxTOUCH_ZOOM_GESTURE, ?wxTOUCH_ZOOM_GESTURE),
    t(wxTOUCH_ROTATE_GESTURE, ?wxTOUCH_ROTATE_GESTURE),
    t(wxTOUCH_PRESS_GESTURES, ?wxTOUCH_PRESS_GESTURES),
    t(wxTOUCH_ALL_GESTURES, ?wxTOUCH_ALL_GESTURES),
    t(wxSEND_EVENT_POST, ?wxSEND_EVENT_POST),
    t(wxSHOW_EFFECT_NONE, ?wxSHOW_EFFECT_NONE),
    t(wxSHOW_EFFECT_ROLL_TO_LEFT, ?wxSHOW_EFFECT_ROLL_TO_LEFT),
    t(wxSHOW_EFFECT_ROLL_TO_RIGHT, ?wxSHOW_EFFECT_ROLL_TO_RIGHT),
    t(wxSHOW_EFFECT_ROLL_TO_TOP, ?wxSHOW_EFFECT_ROLL_TO_TOP),
    t(wxSHOW_EFFECT_ROLL_TO_BOTTOM, ?wxSHOW_EFFECT_ROLL_TO_BOTTOM),
    t(wxSHOW_EFFECT_SLIDE_TO_LEFT, ?wxSHOW_EFFECT_SLIDE_TO_LEFT),
    t(wxSHOW_EFFECT_SLIDE_TO_RIGHT, ?wxSHOW_EFFECT_SLIDE_TO_RIGHT),
    t(wxSHOW_EFFECT_SLIDE_TO_TOP, ?wxSHOW_EFFECT_SLIDE_TO_TOP),
    t(wxSHOW_EFFECT_SLIDE_TO_BOTTOM, ?wxSHOW_EFFECT_SLIDE_TO_BOTTOM),
    t(wxSHOW_EFFECT_BLEND, ?wxSHOW_EFFECT_BLEND),
    t(wxSHOW_EFFECT_EXPAND, ?wxSHOW_EFFECT_EXPAND),
    t(wxSHOW_EFFECT_MAX, ?wxSHOW_EFFECT_MAX),
    t(wxWINDOW_VARIANT_NORMAL, ?wxWINDOW_VARIANT_NORMAL),
    t(wxWINDOW_VARIANT_SMALL, ?wxWINDOW_VARIANT_SMALL),
    t(wxWINDOW_VARIANT_MINI, ?wxWINDOW_VARIANT_MINI),
    t(wxWINDOW_VARIANT_LARGE, ?wxWINDOW_VARIANT_LARGE),
    t(wxWINDOW_VARIANT_MAX, ?wxWINDOW_VARIANT_MAX),
    t(wxXRC_USE_LOCALE, ?wxXRC_USE_LOCALE),
    t(wxXRC_NO_SUBCLASSING, ?wxXRC_NO_SUBCLASSING),
    t(wxXRC_NO_RELOADING, ?wxXRC_NO_RELOADING),
    t(wxXRC_USE_ENVVARS, ?wxXRC_USE_ENVVARS),
    timer:sleep(500),
    ok.

