
/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

#ifndef HYPRE_IJ_MV_MUP_HEADER
#define HYPRE_IJ_MV_MUP_HEADER

#ifdef __cplusplus
extern "C" {
#endif

#if defined (HYPRE_MIXED_PRECISION)

/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/



/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/


HYPRE_Int
HYPRE_IJMatrixAdd_flt( hypre_float alpha, HYPRE_IJMatrix matrix_A, hypre_float beta, HYPRE_IJMatrix matrix_B, HYPRE_IJMatrix *matrix_C );
HYPRE_Int
HYPRE_IJMatrixAdd_dbl( hypre_double alpha, HYPRE_IJMatrix matrix_A, hypre_double beta, HYPRE_IJMatrix matrix_B, HYPRE_IJMatrix *matrix_C );
HYPRE_Int
HYPRE_IJMatrixAdd_long_dbl( hypre_long_double alpha, HYPRE_IJMatrix matrix_A, hypre_long_double beta, HYPRE_IJMatrix matrix_B, HYPRE_IJMatrix *matrix_C );
HYPRE_Int
HYPRE_IJMatrixAdd( hypre_long_double alpha, HYPRE_IJMatrix matrix_A, hypre_long_double beta, HYPRE_IJMatrix matrix_B, HYPRE_IJMatrix *matrix_C );

HYPRE_Int
HYPRE_IJMatrixAddToValues_flt( HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_Int *ncols, const HYPRE_BigInt *rows, const HYPRE_BigInt *cols, const hypre_float *values );
HYPRE_Int
HYPRE_IJMatrixAddToValues_dbl( HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_Int *ncols, const HYPRE_BigInt *rows, const HYPRE_BigInt *cols, const hypre_double *values );
HYPRE_Int
HYPRE_IJMatrixAddToValues_long_dbl( HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_Int *ncols, const HYPRE_BigInt *rows, const HYPRE_BigInt *cols, const hypre_long_double *values );
HYPRE_Int
HYPRE_IJMatrixAddToValues( HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_Int *ncols, const HYPRE_BigInt *rows, const HYPRE_BigInt *cols, const void *values );

HYPRE_Int
HYPRE_IJMatrixAddToValues2_flt( HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_Int *ncols, const HYPRE_BigInt *rows, const HYPRE_Int *row_indexes, const HYPRE_BigInt *cols, const hypre_float *values );
HYPRE_Int
HYPRE_IJMatrixAddToValues2_dbl( HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_Int *ncols, const HYPRE_BigInt *rows, const HYPRE_Int *row_indexes, const HYPRE_BigInt *cols, const hypre_double *values );
HYPRE_Int
HYPRE_IJMatrixAddToValues2_long_dbl( HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_Int *ncols, const HYPRE_BigInt *rows, const HYPRE_Int *row_indexes, const HYPRE_BigInt *cols, const hypre_long_double *values );
HYPRE_Int
HYPRE_IJMatrixAddToValues2( HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_Int *ncols, const HYPRE_BigInt *rows, const HYPRE_Int *row_indexes, const HYPRE_BigInt *cols, const void *values );

HYPRE_Int
HYPRE_IJMatrixAssemble_flt( HYPRE_IJMatrix matrix );
HYPRE_Int
HYPRE_IJMatrixAssemble_dbl( HYPRE_IJMatrix matrix );
HYPRE_Int
HYPRE_IJMatrixAssemble_long_dbl( HYPRE_IJMatrix matrix );
HYPRE_Int
HYPRE_IJMatrixAssemble( HYPRE_IJMatrix matrix );

HYPRE_Int
HYPRE_IJMatrixCreate_flt( MPI_Comm comm, HYPRE_BigInt ilower, HYPRE_BigInt iupper, HYPRE_BigInt jlower, HYPRE_BigInt jupper, HYPRE_IJMatrix *matrix );
HYPRE_Int
HYPRE_IJMatrixCreate_dbl( MPI_Comm comm, HYPRE_BigInt ilower, HYPRE_BigInt iupper, HYPRE_BigInt jlower, HYPRE_BigInt jupper, HYPRE_IJMatrix *matrix );
HYPRE_Int
HYPRE_IJMatrixCreate_long_dbl( MPI_Comm comm, HYPRE_BigInt ilower, HYPRE_BigInt iupper, HYPRE_BigInt jlower, HYPRE_BigInt jupper, HYPRE_IJMatrix *matrix );
HYPRE_Int
HYPRE_IJMatrixCreate( MPI_Comm comm, HYPRE_BigInt ilower, HYPRE_BigInt iupper, HYPRE_BigInt jlower, HYPRE_BigInt jupper, HYPRE_IJMatrix *matrix );

HYPRE_Int
HYPRE_IJMatrixDestroy_flt( HYPRE_IJMatrix matrix );
HYPRE_Int
HYPRE_IJMatrixDestroy_dbl( HYPRE_IJMatrix matrix );
HYPRE_Int
HYPRE_IJMatrixDestroy_long_dbl( HYPRE_IJMatrix matrix );
HYPRE_Int
HYPRE_IJMatrixDestroy( HYPRE_IJMatrix matrix );

HYPRE_Int
HYPRE_IJMatrixGetGlobalInfo_flt( HYPRE_IJMatrix matrix, HYPRE_BigInt *global_num_rows, HYPRE_BigInt *global_num_cols, HYPRE_BigInt *global_num_nonzeros );
HYPRE_Int
HYPRE_IJMatrixGetGlobalInfo_dbl( HYPRE_IJMatrix matrix, HYPRE_BigInt *global_num_rows, HYPRE_BigInt *global_num_cols, HYPRE_BigInt *global_num_nonzeros );
HYPRE_Int
HYPRE_IJMatrixGetGlobalInfo_long_dbl( HYPRE_IJMatrix matrix, HYPRE_BigInt *global_num_rows, HYPRE_BigInt *global_num_cols, HYPRE_BigInt *global_num_nonzeros );
HYPRE_Int
HYPRE_IJMatrixGetGlobalInfo( HYPRE_IJMatrix matrix, HYPRE_BigInt *global_num_rows, HYPRE_BigInt *global_num_cols, HYPRE_BigInt *global_num_nonzeros );

HYPRE_Int
HYPRE_IJMatrixGetLocalRange_flt( HYPRE_IJMatrix matrix, HYPRE_BigInt *ilower, HYPRE_BigInt *iupper, HYPRE_BigInt *jlower, HYPRE_BigInt *jupper );
HYPRE_Int
HYPRE_IJMatrixGetLocalRange_dbl( HYPRE_IJMatrix matrix, HYPRE_BigInt *ilower, HYPRE_BigInt *iupper, HYPRE_BigInt *jlower, HYPRE_BigInt *jupper );
HYPRE_Int
HYPRE_IJMatrixGetLocalRange_long_dbl( HYPRE_IJMatrix matrix, HYPRE_BigInt *ilower, HYPRE_BigInt *iupper, HYPRE_BigInt *jlower, HYPRE_BigInt *jupper );
HYPRE_Int
HYPRE_IJMatrixGetLocalRange( HYPRE_IJMatrix matrix, HYPRE_BigInt *ilower, HYPRE_BigInt *iupper, HYPRE_BigInt *jlower, HYPRE_BigInt *jupper );

HYPRE_Int
HYPRE_IJMatrixGetObject_flt( HYPRE_IJMatrix matrix, void **object );
HYPRE_Int
HYPRE_IJMatrixGetObject_dbl( HYPRE_IJMatrix matrix, void **object );
HYPRE_Int
HYPRE_IJMatrixGetObject_long_dbl( HYPRE_IJMatrix matrix, void **object );
HYPRE_Int
HYPRE_IJMatrixGetObject( HYPRE_IJMatrix matrix, void **object );

HYPRE_Int
HYPRE_IJMatrixGetObjectType_flt( HYPRE_IJMatrix matrix, HYPRE_Int *type );
HYPRE_Int
HYPRE_IJMatrixGetObjectType_dbl( HYPRE_IJMatrix matrix, HYPRE_Int *type );
HYPRE_Int
HYPRE_IJMatrixGetObjectType_long_dbl( HYPRE_IJMatrix matrix, HYPRE_Int *type );
HYPRE_Int
HYPRE_IJMatrixGetObjectType( HYPRE_IJMatrix matrix, HYPRE_Int *type );

HYPRE_Int
HYPRE_IJMatrixGetRowCounts_flt( HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_BigInt *rows, HYPRE_Int *ncols );
HYPRE_Int
HYPRE_IJMatrixGetRowCounts_dbl( HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_BigInt *rows, HYPRE_Int *ncols );
HYPRE_Int
HYPRE_IJMatrixGetRowCounts_long_dbl( HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_BigInt *rows, HYPRE_Int *ncols );
HYPRE_Int
HYPRE_IJMatrixGetRowCounts( HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_BigInt *rows, HYPRE_Int *ncols );

HYPRE_Int
HYPRE_IJMatrixGetValues_flt( HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_Int *ncols, HYPRE_BigInt *rows, HYPRE_BigInt *cols, hypre_float *values );
HYPRE_Int
HYPRE_IJMatrixGetValues_dbl( HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_Int *ncols, HYPRE_BigInt *rows, HYPRE_BigInt *cols, hypre_double *values );
HYPRE_Int
HYPRE_IJMatrixGetValues_long_dbl( HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_Int *ncols, HYPRE_BigInt *rows, HYPRE_BigInt *cols, hypre_long_double *values );
HYPRE_Int
HYPRE_IJMatrixGetValues( HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_Int *ncols, HYPRE_BigInt *rows, HYPRE_BigInt *cols, void *values );

HYPRE_Int
HYPRE_IJMatrixGetValues2_flt( HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_Int *ncols, HYPRE_BigInt *rows, HYPRE_Int *row_indexes, HYPRE_BigInt *cols, hypre_float *values );
HYPRE_Int
HYPRE_IJMatrixGetValues2_dbl( HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_Int *ncols, HYPRE_BigInt *rows, HYPRE_Int *row_indexes, HYPRE_BigInt *cols, hypre_double *values );
HYPRE_Int
HYPRE_IJMatrixGetValues2_long_dbl( HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_Int *ncols, HYPRE_BigInt *rows, HYPRE_Int *row_indexes, HYPRE_BigInt *cols, hypre_long_double *values );
HYPRE_Int
HYPRE_IJMatrixGetValues2( HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_Int *ncols, HYPRE_BigInt *rows, HYPRE_Int *row_indexes, HYPRE_BigInt *cols, void *values );

HYPRE_Int
HYPRE_IJMatrixGetValuesAndZeroOut_flt( HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_Int *ncols, HYPRE_BigInt *rows, HYPRE_Int *row_indexes, HYPRE_BigInt *cols, hypre_float *values );
HYPRE_Int
HYPRE_IJMatrixGetValuesAndZeroOut_dbl( HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_Int *ncols, HYPRE_BigInt *rows, HYPRE_Int *row_indexes, HYPRE_BigInt *cols, hypre_double *values );
HYPRE_Int
HYPRE_IJMatrixGetValuesAndZeroOut_long_dbl( HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_Int *ncols, HYPRE_BigInt *rows, HYPRE_Int *row_indexes, HYPRE_BigInt *cols, hypre_long_double *values );
HYPRE_Int
HYPRE_IJMatrixGetValuesAndZeroOut( HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_Int *ncols, HYPRE_BigInt *rows, HYPRE_Int *row_indexes, HYPRE_BigInt *cols, void *values );

HYPRE_Int
HYPRE_IJMatrixInitialize_flt( HYPRE_IJMatrix matrix );
HYPRE_Int
HYPRE_IJMatrixInitialize_dbl( HYPRE_IJMatrix matrix );
HYPRE_Int
HYPRE_IJMatrixInitialize_long_dbl( HYPRE_IJMatrix matrix );
HYPRE_Int
HYPRE_IJMatrixInitialize( HYPRE_IJMatrix matrix );

HYPRE_Int
HYPRE_IJMatrixInitialize_v2_flt( HYPRE_IJMatrix matrix, HYPRE_MemoryLocation memory_location );
HYPRE_Int
HYPRE_IJMatrixInitialize_v2_dbl( HYPRE_IJMatrix matrix, HYPRE_MemoryLocation memory_location );
HYPRE_Int
HYPRE_IJMatrixInitialize_v2_long_dbl( HYPRE_IJMatrix matrix, HYPRE_MemoryLocation memory_location );
HYPRE_Int
HYPRE_IJMatrixInitialize_v2( HYPRE_IJMatrix matrix, HYPRE_MemoryLocation memory_location );

HYPRE_Int
HYPRE_IJMatrixMigrate_flt( HYPRE_IJMatrix matrix, HYPRE_MemoryLocation memory_location );
HYPRE_Int
HYPRE_IJMatrixMigrate_dbl( HYPRE_IJMatrix matrix, HYPRE_MemoryLocation memory_location );
HYPRE_Int
HYPRE_IJMatrixMigrate_long_dbl( HYPRE_IJMatrix matrix, HYPRE_MemoryLocation memory_location );
HYPRE_Int
HYPRE_IJMatrixMigrate( HYPRE_IJMatrix matrix, HYPRE_MemoryLocation memory_location );

HYPRE_Int
HYPRE_IJMatrixNorm_flt( HYPRE_IJMatrix matrix, hypre_float *norm );
HYPRE_Int
HYPRE_IJMatrixNorm_dbl( HYPRE_IJMatrix matrix, hypre_double *norm );
HYPRE_Int
HYPRE_IJMatrixNorm_long_dbl( HYPRE_IJMatrix matrix, hypre_long_double *norm );
HYPRE_Int
HYPRE_IJMatrixNorm( HYPRE_IJMatrix matrix, void *norm );

HYPRE_Int
HYPRE_IJMatrixPartialClone_flt( HYPRE_IJMatrix matrix_in, HYPRE_IJMatrix *matrix_out );
HYPRE_Int
HYPRE_IJMatrixPartialClone_dbl( HYPRE_IJMatrix matrix_in, HYPRE_IJMatrix *matrix_out );
HYPRE_Int
HYPRE_IJMatrixPartialClone_long_dbl( HYPRE_IJMatrix matrix_in, HYPRE_IJMatrix *matrix_out );
HYPRE_Int
HYPRE_IJMatrixPartialClone( HYPRE_IJMatrix matrix_in, HYPRE_IJMatrix *matrix_out );

HYPRE_Int
HYPRE_IJMatrixPrint_flt( HYPRE_IJMatrix matrix, const char *filename );
HYPRE_Int
HYPRE_IJMatrixPrint_dbl( HYPRE_IJMatrix matrix, const char *filename );
HYPRE_Int
HYPRE_IJMatrixPrint_long_dbl( HYPRE_IJMatrix matrix, const char *filename );
HYPRE_Int
HYPRE_IJMatrixPrint( HYPRE_IJMatrix matrix, const char *filename );

HYPRE_Int
HYPRE_IJMatrixPrintBinary_flt( HYPRE_IJMatrix matrix, const char *filename );
HYPRE_Int
HYPRE_IJMatrixPrintBinary_dbl( HYPRE_IJMatrix matrix, const char *filename );
HYPRE_Int
HYPRE_IJMatrixPrintBinary_long_dbl( HYPRE_IJMatrix matrix, const char *filename );
HYPRE_Int
HYPRE_IJMatrixPrintBinary( HYPRE_IJMatrix matrix, const char *filename );

HYPRE_Int
HYPRE_IJMatrixRead_flt( const char *filename, MPI_Comm comm, HYPRE_Int type, HYPRE_IJMatrix *matrix );
HYPRE_Int
HYPRE_IJMatrixRead_dbl( const char *filename, MPI_Comm comm, HYPRE_Int type, HYPRE_IJMatrix *matrix );
HYPRE_Int
HYPRE_IJMatrixRead_long_dbl( const char *filename, MPI_Comm comm, HYPRE_Int type, HYPRE_IJMatrix *matrix );
HYPRE_Int
HYPRE_IJMatrixRead( const char *filename, MPI_Comm comm, HYPRE_Int type, HYPRE_IJMatrix *matrix );

HYPRE_Int
HYPRE_IJMatrixReadBinary_flt( const char *filename, MPI_Comm comm, HYPRE_Int type, HYPRE_IJMatrix *matrix_ptr );
HYPRE_Int
HYPRE_IJMatrixReadBinary_dbl( const char *filename, MPI_Comm comm, HYPRE_Int type, HYPRE_IJMatrix *matrix_ptr );
HYPRE_Int
HYPRE_IJMatrixReadBinary_long_dbl( const char *filename, MPI_Comm comm, HYPRE_Int type, HYPRE_IJMatrix *matrix_ptr );
HYPRE_Int
HYPRE_IJMatrixReadBinary( const char *filename, MPI_Comm comm, HYPRE_Int type, HYPRE_IJMatrix *matrix_ptr );

HYPRE_Int
HYPRE_IJMatrixReadMM_flt( const char *filename, MPI_Comm comm, HYPRE_Int type, HYPRE_IJMatrix *matrix );
HYPRE_Int
HYPRE_IJMatrixReadMM_dbl( const char *filename, MPI_Comm comm, HYPRE_Int type, HYPRE_IJMatrix *matrix );
HYPRE_Int
HYPRE_IJMatrixReadMM_long_dbl( const char *filename, MPI_Comm comm, HYPRE_Int type, HYPRE_IJMatrix *matrix );
HYPRE_Int
HYPRE_IJMatrixReadMM( const char *filename, MPI_Comm comm, HYPRE_Int type, HYPRE_IJMatrix *matrix );

HYPRE_Int
HYPRE_IJMatrixSetConstantValues_flt( HYPRE_IJMatrix matrix, hypre_float value );
HYPRE_Int
HYPRE_IJMatrixSetConstantValues_dbl( HYPRE_IJMatrix matrix, hypre_double value );
HYPRE_Int
HYPRE_IJMatrixSetConstantValues_long_dbl( HYPRE_IJMatrix matrix, hypre_long_double value );
HYPRE_Int
HYPRE_IJMatrixSetConstantValues( HYPRE_IJMatrix matrix, hypre_long_double value );

HYPRE_Int
HYPRE_IJMatrixSetDiagOffdSizes_flt( HYPRE_IJMatrix matrix, const HYPRE_Int *diag_sizes, const HYPRE_Int *offdiag_sizes );
HYPRE_Int
HYPRE_IJMatrixSetDiagOffdSizes_dbl( HYPRE_IJMatrix matrix, const HYPRE_Int *diag_sizes, const HYPRE_Int *offdiag_sizes );
HYPRE_Int
HYPRE_IJMatrixSetDiagOffdSizes_long_dbl( HYPRE_IJMatrix matrix, const HYPRE_Int *diag_sizes, const HYPRE_Int *offdiag_sizes );
HYPRE_Int
HYPRE_IJMatrixSetDiagOffdSizes( HYPRE_IJMatrix matrix, const HYPRE_Int *diag_sizes, const HYPRE_Int *offdiag_sizes );

HYPRE_Int
HYPRE_IJMatrixSetEarlyAssemble_flt( HYPRE_IJMatrix matrix, HYPRE_Int early_assemble );
HYPRE_Int
HYPRE_IJMatrixSetEarlyAssemble_dbl( HYPRE_IJMatrix matrix, HYPRE_Int early_assemble );
HYPRE_Int
HYPRE_IJMatrixSetEarlyAssemble_long_dbl( HYPRE_IJMatrix matrix, HYPRE_Int early_assemble );
HYPRE_Int
HYPRE_IJMatrixSetEarlyAssemble( HYPRE_IJMatrix matrix, HYPRE_Int early_assemble );

HYPRE_Int
HYPRE_IJMatrixSetGrowFactor_flt( HYPRE_IJMatrix matrix, hypre_float factor );
HYPRE_Int
HYPRE_IJMatrixSetGrowFactor_dbl( HYPRE_IJMatrix matrix, hypre_double factor );
HYPRE_Int
HYPRE_IJMatrixSetGrowFactor_long_dbl( HYPRE_IJMatrix matrix, hypre_long_double factor );
HYPRE_Int
HYPRE_IJMatrixSetGrowFactor( HYPRE_IJMatrix matrix, hypre_long_double factor );

HYPRE_Int
HYPRE_IJMatrixSetInitAllocation_flt( HYPRE_IJMatrix matrix, HYPRE_Int factor );
HYPRE_Int
HYPRE_IJMatrixSetInitAllocation_dbl( HYPRE_IJMatrix matrix, HYPRE_Int factor );
HYPRE_Int
HYPRE_IJMatrixSetInitAllocation_long_dbl( HYPRE_IJMatrix matrix, HYPRE_Int factor );
HYPRE_Int
HYPRE_IJMatrixSetInitAllocation( HYPRE_IJMatrix matrix, HYPRE_Int factor );

HYPRE_Int
HYPRE_IJMatrixSetMaxOffProcElmts_flt( HYPRE_IJMatrix matrix, HYPRE_Int max_off_proc_elmts );
HYPRE_Int
HYPRE_IJMatrixSetMaxOffProcElmts_dbl( HYPRE_IJMatrix matrix, HYPRE_Int max_off_proc_elmts );
HYPRE_Int
HYPRE_IJMatrixSetMaxOffProcElmts_long_dbl( HYPRE_IJMatrix matrix, HYPRE_Int max_off_proc_elmts );
HYPRE_Int
HYPRE_IJMatrixSetMaxOffProcElmts( HYPRE_IJMatrix matrix, HYPRE_Int max_off_proc_elmts );

HYPRE_Int
HYPRE_IJMatrixSetOMPFlag_flt( HYPRE_IJMatrix matrix, HYPRE_Int omp_flag );
HYPRE_Int
HYPRE_IJMatrixSetOMPFlag_dbl( HYPRE_IJMatrix matrix, HYPRE_Int omp_flag );
HYPRE_Int
HYPRE_IJMatrixSetOMPFlag_long_dbl( HYPRE_IJMatrix matrix, HYPRE_Int omp_flag );
HYPRE_Int
HYPRE_IJMatrixSetOMPFlag( HYPRE_IJMatrix matrix, HYPRE_Int omp_flag );

HYPRE_Int
HYPRE_IJMatrixSetObjectType_flt( HYPRE_IJMatrix matrix, HYPRE_Int type );
HYPRE_Int
HYPRE_IJMatrixSetObjectType_dbl( HYPRE_IJMatrix matrix, HYPRE_Int type );
HYPRE_Int
HYPRE_IJMatrixSetObjectType_long_dbl( HYPRE_IJMatrix matrix, HYPRE_Int type );
HYPRE_Int
HYPRE_IJMatrixSetObjectType( HYPRE_IJMatrix matrix, HYPRE_Int type );

HYPRE_Int
HYPRE_IJMatrixSetPrintLevel_flt( HYPRE_IJMatrix matrix, HYPRE_Int print_level );
HYPRE_Int
HYPRE_IJMatrixSetPrintLevel_dbl( HYPRE_IJMatrix matrix, HYPRE_Int print_level );
HYPRE_Int
HYPRE_IJMatrixSetPrintLevel_long_dbl( HYPRE_IJMatrix matrix, HYPRE_Int print_level );
HYPRE_Int
HYPRE_IJMatrixSetPrintLevel( HYPRE_IJMatrix matrix, HYPRE_Int print_level );

HYPRE_Int
HYPRE_IJMatrixSetRowSizes_flt( HYPRE_IJMatrix matrix, const HYPRE_Int *sizes );
HYPRE_Int
HYPRE_IJMatrixSetRowSizes_dbl( HYPRE_IJMatrix matrix, const HYPRE_Int *sizes );
HYPRE_Int
HYPRE_IJMatrixSetRowSizes_long_dbl( HYPRE_IJMatrix matrix, const HYPRE_Int *sizes );
HYPRE_Int
HYPRE_IJMatrixSetRowSizes( HYPRE_IJMatrix matrix, const HYPRE_Int *sizes );

HYPRE_Int
HYPRE_IJMatrixSetValues_flt( HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_Int *ncols, const HYPRE_BigInt *rows, const HYPRE_BigInt *cols, const hypre_float *values );
HYPRE_Int
HYPRE_IJMatrixSetValues_dbl( HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_Int *ncols, const HYPRE_BigInt *rows, const HYPRE_BigInt *cols, const hypre_double *values );
HYPRE_Int
HYPRE_IJMatrixSetValues_long_dbl( HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_Int *ncols, const HYPRE_BigInt *rows, const HYPRE_BigInt *cols, const hypre_long_double *values );
HYPRE_Int
HYPRE_IJMatrixSetValues( HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_Int *ncols, const HYPRE_BigInt *rows, const HYPRE_BigInt *cols, const void *values );

HYPRE_Int
HYPRE_IJMatrixSetValues2_flt( HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_Int *ncols, const HYPRE_BigInt *rows, const HYPRE_Int *row_indexes, const HYPRE_BigInt *cols, const hypre_float *values );
HYPRE_Int
HYPRE_IJMatrixSetValues2_dbl( HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_Int *ncols, const HYPRE_BigInt *rows, const HYPRE_Int *row_indexes, const HYPRE_BigInt *cols, const hypre_double *values );
HYPRE_Int
HYPRE_IJMatrixSetValues2_long_dbl( HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_Int *ncols, const HYPRE_BigInt *rows, const HYPRE_Int *row_indexes, const HYPRE_BigInt *cols, const hypre_long_double *values );
HYPRE_Int
HYPRE_IJMatrixSetValues2( HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_Int *ncols, const HYPRE_BigInt *rows, const HYPRE_Int *row_indexes, const HYPRE_BigInt *cols, const void *values );

HYPRE_Int
HYPRE_IJMatrixTranspose_flt( HYPRE_IJMatrix matrix_A, HYPRE_IJMatrix *matrix_AT );
HYPRE_Int
HYPRE_IJMatrixTranspose_dbl( HYPRE_IJMatrix matrix_A, HYPRE_IJMatrix *matrix_AT );
HYPRE_Int
HYPRE_IJMatrixTranspose_long_dbl( HYPRE_IJMatrix matrix_A, HYPRE_IJMatrix *matrix_AT );
HYPRE_Int
HYPRE_IJMatrixTranspose( HYPRE_IJMatrix matrix_A, HYPRE_IJMatrix *matrix_AT );

HYPRE_Int
HYPRE_IJVectorAddToValues_flt( HYPRE_IJVector vector, HYPRE_Int nvalues, const HYPRE_BigInt *indices, const hypre_float *values );
HYPRE_Int
HYPRE_IJVectorAddToValues_dbl( HYPRE_IJVector vector, HYPRE_Int nvalues, const HYPRE_BigInt *indices, const hypre_double *values );
HYPRE_Int
HYPRE_IJVectorAddToValues_long_dbl( HYPRE_IJVector vector, HYPRE_Int nvalues, const HYPRE_BigInt *indices, const hypre_long_double *values );
HYPRE_Int
HYPRE_IJVectorAddToValues( HYPRE_IJVector vector, HYPRE_Int nvalues, const HYPRE_BigInt *indices, const void *values );

HYPRE_Int
HYPRE_IJVectorAssemble_flt( HYPRE_IJVector vector );
HYPRE_Int
HYPRE_IJVectorAssemble_dbl( HYPRE_IJVector vector );
HYPRE_Int
HYPRE_IJVectorAssemble_long_dbl( HYPRE_IJVector vector );
HYPRE_Int
HYPRE_IJVectorAssemble( HYPRE_IJVector vector );

HYPRE_Int
HYPRE_IJVectorCreate_flt( MPI_Comm comm, HYPRE_BigInt jlower, HYPRE_BigInt jupper, HYPRE_IJVector *vector );
HYPRE_Int
HYPRE_IJVectorCreate_dbl( MPI_Comm comm, HYPRE_BigInt jlower, HYPRE_BigInt jupper, HYPRE_IJVector *vector );
HYPRE_Int
HYPRE_IJVectorCreate_long_dbl( MPI_Comm comm, HYPRE_BigInt jlower, HYPRE_BigInt jupper, HYPRE_IJVector *vector );
HYPRE_Int
HYPRE_IJVectorCreate( MPI_Comm comm, HYPRE_BigInt jlower, HYPRE_BigInt jupper, HYPRE_IJVector *vector );

HYPRE_Int
HYPRE_IJVectorDestroy_flt( HYPRE_IJVector vector );
HYPRE_Int
HYPRE_IJVectorDestroy_dbl( HYPRE_IJVector vector );
HYPRE_Int
HYPRE_IJVectorDestroy_long_dbl( HYPRE_IJVector vector );
HYPRE_Int
HYPRE_IJVectorDestroy( HYPRE_IJVector vector );

HYPRE_Int
HYPRE_IJVectorGetLocalRange_flt( HYPRE_IJVector vector, HYPRE_BigInt *jlower, HYPRE_BigInt *jupper );
HYPRE_Int
HYPRE_IJVectorGetLocalRange_dbl( HYPRE_IJVector vector, HYPRE_BigInt *jlower, HYPRE_BigInt *jupper );
HYPRE_Int
HYPRE_IJVectorGetLocalRange_long_dbl( HYPRE_IJVector vector, HYPRE_BigInt *jlower, HYPRE_BigInt *jupper );
HYPRE_Int
HYPRE_IJVectorGetLocalRange( HYPRE_IJVector vector, HYPRE_BigInt *jlower, HYPRE_BigInt *jupper );

HYPRE_Int
HYPRE_IJVectorGetObject_flt( HYPRE_IJVector vector, void **object );
HYPRE_Int
HYPRE_IJVectorGetObject_dbl( HYPRE_IJVector vector, void **object );
HYPRE_Int
HYPRE_IJVectorGetObject_long_dbl( HYPRE_IJVector vector, void **object );
HYPRE_Int
HYPRE_IJVectorGetObject( HYPRE_IJVector vector, void **object );

HYPRE_Int
HYPRE_IJVectorGetObjectType_flt( HYPRE_IJVector vector, HYPRE_Int *type );
HYPRE_Int
HYPRE_IJVectorGetObjectType_dbl( HYPRE_IJVector vector, HYPRE_Int *type );
HYPRE_Int
HYPRE_IJVectorGetObjectType_long_dbl( HYPRE_IJVector vector, HYPRE_Int *type );
HYPRE_Int
HYPRE_IJVectorGetObjectType( HYPRE_IJVector vector, HYPRE_Int *type );

HYPRE_Int
HYPRE_IJVectorGetValues_flt( HYPRE_IJVector vector, HYPRE_Int nvalues, const HYPRE_BigInt *indices, hypre_float *values );
HYPRE_Int
HYPRE_IJVectorGetValues_dbl( HYPRE_IJVector vector, HYPRE_Int nvalues, const HYPRE_BigInt *indices, hypre_double *values );
HYPRE_Int
HYPRE_IJVectorGetValues_long_dbl( HYPRE_IJVector vector, HYPRE_Int nvalues, const HYPRE_BigInt *indices, hypre_long_double *values );
HYPRE_Int
HYPRE_IJVectorGetValues( HYPRE_IJVector vector, HYPRE_Int nvalues, const HYPRE_BigInt *indices, void *values );

HYPRE_Int
HYPRE_IJVectorInitialize_flt( HYPRE_IJVector vector );
HYPRE_Int
HYPRE_IJVectorInitialize_dbl( HYPRE_IJVector vector );
HYPRE_Int
HYPRE_IJVectorInitialize_long_dbl( HYPRE_IJVector vector );
HYPRE_Int
HYPRE_IJVectorInitialize( HYPRE_IJVector vector );

HYPRE_Int
HYPRE_IJVectorInitializeShell_flt( HYPRE_IJVector vector );
HYPRE_Int
HYPRE_IJVectorInitializeShell_dbl( HYPRE_IJVector vector );
HYPRE_Int
HYPRE_IJVectorInitializeShell_long_dbl( HYPRE_IJVector vector );
HYPRE_Int
HYPRE_IJVectorInitializeShell( HYPRE_IJVector vector );

HYPRE_Int
HYPRE_IJVectorInitialize_v2_flt( HYPRE_IJVector vector, HYPRE_MemoryLocation memory_location );
HYPRE_Int
HYPRE_IJVectorInitialize_v2_dbl( HYPRE_IJVector vector, HYPRE_MemoryLocation memory_location );
HYPRE_Int
HYPRE_IJVectorInitialize_v2_long_dbl( HYPRE_IJVector vector, HYPRE_MemoryLocation memory_location );
HYPRE_Int
HYPRE_IJVectorInitialize_v2( HYPRE_IJVector vector, HYPRE_MemoryLocation memory_location );

HYPRE_Int
HYPRE_IJVectorInnerProd_flt( HYPRE_IJVector x, HYPRE_IJVector y, hypre_float *prod );
HYPRE_Int
HYPRE_IJVectorInnerProd_dbl( HYPRE_IJVector x, HYPRE_IJVector y, hypre_double *prod );
HYPRE_Int
HYPRE_IJVectorInnerProd_long_dbl( HYPRE_IJVector x, HYPRE_IJVector y, hypre_long_double *prod );
HYPRE_Int
HYPRE_IJVectorInnerProd( HYPRE_IJVector x, HYPRE_IJVector y, void *prod );

HYPRE_Int
HYPRE_IJVectorMigrate_flt( HYPRE_IJVector vector, HYPRE_MemoryLocation memory_location );
HYPRE_Int
HYPRE_IJVectorMigrate_dbl( HYPRE_IJVector vector, HYPRE_MemoryLocation memory_location );
HYPRE_Int
HYPRE_IJVectorMigrate_long_dbl( HYPRE_IJVector vector, HYPRE_MemoryLocation memory_location );
HYPRE_Int
HYPRE_IJVectorMigrate( HYPRE_IJVector vector, HYPRE_MemoryLocation memory_location );

HYPRE_Int
HYPRE_IJVectorPrint_flt( HYPRE_IJVector vector, const char *filename );
HYPRE_Int
HYPRE_IJVectorPrint_dbl( HYPRE_IJVector vector, const char *filename );
HYPRE_Int
HYPRE_IJVectorPrint_long_dbl( HYPRE_IJVector vector, const char *filename );
HYPRE_Int
HYPRE_IJVectorPrint( HYPRE_IJVector vector, const char *filename );

HYPRE_Int
HYPRE_IJVectorPrintBinary_flt( HYPRE_IJVector vector, const char *filename );
HYPRE_Int
HYPRE_IJVectorPrintBinary_dbl( HYPRE_IJVector vector, const char *filename );
HYPRE_Int
HYPRE_IJVectorPrintBinary_long_dbl( HYPRE_IJVector vector, const char *filename );
HYPRE_Int
HYPRE_IJVectorPrintBinary( HYPRE_IJVector vector, const char *filename );

HYPRE_Int
HYPRE_IJVectorRead_flt( const char *filename, MPI_Comm comm, HYPRE_Int type, HYPRE_IJVector *vector );
HYPRE_Int
HYPRE_IJVectorRead_dbl( const char *filename, MPI_Comm comm, HYPRE_Int type, HYPRE_IJVector *vector );
HYPRE_Int
HYPRE_IJVectorRead_long_dbl( const char *filename, MPI_Comm comm, HYPRE_Int type, HYPRE_IJVector *vector );
HYPRE_Int
HYPRE_IJVectorRead( const char *filename, MPI_Comm comm, HYPRE_Int type, HYPRE_IJVector *vector );

HYPRE_Int
HYPRE_IJVectorReadBinary_flt( const char *filename, MPI_Comm comm, HYPRE_Int type, HYPRE_IJVector *vector );
HYPRE_Int
HYPRE_IJVectorReadBinary_dbl( const char *filename, MPI_Comm comm, HYPRE_Int type, HYPRE_IJVector *vector );
HYPRE_Int
HYPRE_IJVectorReadBinary_long_dbl( const char *filename, MPI_Comm comm, HYPRE_Int type, HYPRE_IJVector *vector );
HYPRE_Int
HYPRE_IJVectorReadBinary( const char *filename, MPI_Comm comm, HYPRE_Int type, HYPRE_IJVector *vector );

HYPRE_Int
HYPRE_IJVectorSetComponent_flt( HYPRE_IJVector vector, HYPRE_Int component );
HYPRE_Int
HYPRE_IJVectorSetComponent_dbl( HYPRE_IJVector vector, HYPRE_Int component );
HYPRE_Int
HYPRE_IJVectorSetComponent_long_dbl( HYPRE_IJVector vector, HYPRE_Int component );
HYPRE_Int
HYPRE_IJVectorSetComponent( HYPRE_IJVector vector, HYPRE_Int component );

HYPRE_Int
HYPRE_IJVectorSetConstantValues_flt( HYPRE_IJVector vector, hypre_float value );
HYPRE_Int
HYPRE_IJVectorSetConstantValues_dbl( HYPRE_IJVector vector, hypre_double value );
HYPRE_Int
HYPRE_IJVectorSetConstantValues_long_dbl( HYPRE_IJVector vector, hypre_long_double value );
HYPRE_Int
HYPRE_IJVectorSetConstantValues( HYPRE_IJVector vector, hypre_long_double value );

HYPRE_Int
HYPRE_IJVectorSetData_flt( HYPRE_IJVector vector, hypre_float *data );
HYPRE_Int
HYPRE_IJVectorSetData_dbl( HYPRE_IJVector vector, hypre_double *data );
HYPRE_Int
HYPRE_IJVectorSetData_long_dbl( HYPRE_IJVector vector, hypre_long_double *data );
HYPRE_Int
HYPRE_IJVectorSetData( HYPRE_IJVector vector, void *data );

HYPRE_Int
HYPRE_IJVectorSetMaxOffProcElmts_flt( HYPRE_IJVector vector, HYPRE_Int max_off_proc_elmts );
HYPRE_Int
HYPRE_IJVectorSetMaxOffProcElmts_dbl( HYPRE_IJVector vector, HYPRE_Int max_off_proc_elmts );
HYPRE_Int
HYPRE_IJVectorSetMaxOffProcElmts_long_dbl( HYPRE_IJVector vector, HYPRE_Int max_off_proc_elmts );
HYPRE_Int
HYPRE_IJVectorSetMaxOffProcElmts( HYPRE_IJVector vector, HYPRE_Int max_off_proc_elmts );

HYPRE_Int
HYPRE_IJVectorSetNumComponents_flt( HYPRE_IJVector vector, HYPRE_Int num_components );
HYPRE_Int
HYPRE_IJVectorSetNumComponents_dbl( HYPRE_IJVector vector, HYPRE_Int num_components );
HYPRE_Int
HYPRE_IJVectorSetNumComponents_long_dbl( HYPRE_IJVector vector, HYPRE_Int num_components );
HYPRE_Int
HYPRE_IJVectorSetNumComponents( HYPRE_IJVector vector, HYPRE_Int num_components );

HYPRE_Int
HYPRE_IJVectorSetObjectType_flt( HYPRE_IJVector vector, HYPRE_Int type );
HYPRE_Int
HYPRE_IJVectorSetObjectType_dbl( HYPRE_IJVector vector, HYPRE_Int type );
HYPRE_Int
HYPRE_IJVectorSetObjectType_long_dbl( HYPRE_IJVector vector, HYPRE_Int type );
HYPRE_Int
HYPRE_IJVectorSetObjectType( HYPRE_IJVector vector, HYPRE_Int type );

HYPRE_Int
HYPRE_IJVectorSetPrintLevel_flt( HYPRE_IJVector vector, HYPRE_Int print_level );
HYPRE_Int
HYPRE_IJVectorSetPrintLevel_dbl( HYPRE_IJVector vector, HYPRE_Int print_level );
HYPRE_Int
HYPRE_IJVectorSetPrintLevel_long_dbl( HYPRE_IJVector vector, HYPRE_Int print_level );
HYPRE_Int
HYPRE_IJVectorSetPrintLevel( HYPRE_IJVector vector, HYPRE_Int print_level );

HYPRE_Int
HYPRE_IJVectorSetTags_flt( HYPRE_IJVector vector, HYPRE_Int owns_tags, HYPRE_Int num_tags, HYPRE_Int *tags );
HYPRE_Int
HYPRE_IJVectorSetTags_dbl( HYPRE_IJVector vector, HYPRE_Int owns_tags, HYPRE_Int num_tags, HYPRE_Int *tags );
HYPRE_Int
HYPRE_IJVectorSetTags_long_dbl( HYPRE_IJVector vector, HYPRE_Int owns_tags, HYPRE_Int num_tags, HYPRE_Int *tags );
HYPRE_Int
HYPRE_IJVectorSetTags( HYPRE_IJVector vector, HYPRE_Int owns_tags, HYPRE_Int num_tags, HYPRE_Int *tags );

HYPRE_Int
HYPRE_IJVectorSetValues_flt( HYPRE_IJVector vector, HYPRE_Int nvalues, const HYPRE_BigInt *indices, const hypre_float *values );
HYPRE_Int
HYPRE_IJVectorSetValues_dbl( HYPRE_IJVector vector, HYPRE_Int nvalues, const HYPRE_BigInt *indices, const hypre_double *values );
HYPRE_Int
HYPRE_IJVectorSetValues_long_dbl( HYPRE_IJVector vector, HYPRE_Int nvalues, const HYPRE_BigInt *indices, const hypre_long_double *values );
HYPRE_Int
HYPRE_IJVectorSetValues( HYPRE_IJVector vector, HYPRE_Int nvalues, const HYPRE_BigInt *indices, const void *values );

HYPRE_Int
HYPRE_IJVectorUpdateValues_flt( HYPRE_IJVector vector, HYPRE_Int nvalues, const HYPRE_BigInt *indices, const hypre_float *values, HYPRE_Int action );
HYPRE_Int
HYPRE_IJVectorUpdateValues_dbl( HYPRE_IJVector vector, HYPRE_Int nvalues, const HYPRE_BigInt *indices, const hypre_double *values, HYPRE_Int action );
HYPRE_Int
HYPRE_IJVectorUpdateValues_long_dbl( HYPRE_IJVector vector, HYPRE_Int nvalues, const HYPRE_BigInt *indices, const hypre_long_double *values, HYPRE_Int action );
HYPRE_Int
HYPRE_IJVectorUpdateValues( HYPRE_IJVector vector, HYPRE_Int nvalues, const HYPRE_BigInt *indices, const void *values, HYPRE_Int action );


/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/


HYPRE_Int
HYPRE_IJMatrixAdd_pre( HYPRE_Precision precision, hypre_long_double alpha, HYPRE_IJMatrix matrix_A, hypre_long_double beta, HYPRE_IJMatrix matrix_B, HYPRE_IJMatrix *matrix_C );

HYPRE_Int
HYPRE_IJMatrixAddToValues_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_Int *ncols, const HYPRE_BigInt *rows, const HYPRE_BigInt *cols, const void *values );

HYPRE_Int
HYPRE_IJMatrixAddToValues2_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_Int *ncols, const HYPRE_BigInt *rows, const HYPRE_Int *row_indexes, const HYPRE_BigInt *cols, const void *values );

HYPRE_Int
HYPRE_IJMatrixAssemble_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix );

HYPRE_Int
HYPRE_IJMatrixCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_BigInt ilower, HYPRE_BigInt iupper, HYPRE_BigInt jlower, HYPRE_BigInt jupper, HYPRE_IJMatrix *matrix );

HYPRE_Int
HYPRE_IJMatrixDestroy_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix );

HYPRE_Int
HYPRE_IJMatrixGetGlobalInfo_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, HYPRE_BigInt *global_num_rows, HYPRE_BigInt *global_num_cols, HYPRE_BigInt *global_num_nonzeros );

HYPRE_Int
HYPRE_IJMatrixGetLocalRange_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, HYPRE_BigInt *ilower, HYPRE_BigInt *iupper, HYPRE_BigInt *jlower, HYPRE_BigInt *jupper );

HYPRE_Int
HYPRE_IJMatrixGetObject_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, void **object );

HYPRE_Int
HYPRE_IJMatrixGetObjectType_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, HYPRE_Int *type );

HYPRE_Int
HYPRE_IJMatrixGetRowCounts_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_BigInt *rows, HYPRE_Int *ncols );

HYPRE_Int
HYPRE_IJMatrixGetValues_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_Int *ncols, HYPRE_BigInt *rows, HYPRE_BigInt *cols, void *values );

HYPRE_Int
HYPRE_IJMatrixGetValues2_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_Int *ncols, HYPRE_BigInt *rows, HYPRE_Int *row_indexes, HYPRE_BigInt *cols, void *values );

HYPRE_Int
HYPRE_IJMatrixGetValuesAndZeroOut_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_Int *ncols, HYPRE_BigInt *rows, HYPRE_Int *row_indexes, HYPRE_BigInt *cols, void *values );

HYPRE_Int
HYPRE_IJMatrixInitialize_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix );

HYPRE_Int
HYPRE_IJMatrixInitialize_v2_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, HYPRE_MemoryLocation memory_location );

HYPRE_Int
HYPRE_IJMatrixMigrate_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, HYPRE_MemoryLocation memory_location );

HYPRE_Int
HYPRE_IJMatrixNorm_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, void *norm );

HYPRE_Int
HYPRE_IJMatrixPartialClone_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix_in, HYPRE_IJMatrix *matrix_out );

HYPRE_Int
HYPRE_IJMatrixPrint_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, const char *filename );

HYPRE_Int
HYPRE_IJMatrixPrintBinary_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, const char *filename );

HYPRE_Int
HYPRE_IJMatrixRead_pre( HYPRE_Precision precision, const char *filename, MPI_Comm comm, HYPRE_Int type, HYPRE_IJMatrix *matrix );

HYPRE_Int
HYPRE_IJMatrixReadBinary_pre( HYPRE_Precision precision, const char *filename, MPI_Comm comm, HYPRE_Int type, HYPRE_IJMatrix *matrix_ptr );

HYPRE_Int
HYPRE_IJMatrixReadMM_pre( HYPRE_Precision precision, const char *filename, MPI_Comm comm, HYPRE_Int type, HYPRE_IJMatrix *matrix );

HYPRE_Int
HYPRE_IJMatrixSetConstantValues_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, hypre_long_double value );

HYPRE_Int
HYPRE_IJMatrixSetDiagOffdSizes_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, const HYPRE_Int *diag_sizes, const HYPRE_Int *offdiag_sizes );

HYPRE_Int
HYPRE_IJMatrixSetEarlyAssemble_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, HYPRE_Int early_assemble );

HYPRE_Int
HYPRE_IJMatrixSetGrowFactor_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, hypre_long_double factor );

HYPRE_Int
HYPRE_IJMatrixSetInitAllocation_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, HYPRE_Int factor );

HYPRE_Int
HYPRE_IJMatrixSetMaxOffProcElmts_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, HYPRE_Int max_off_proc_elmts );

HYPRE_Int
HYPRE_IJMatrixSetOMPFlag_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, HYPRE_Int omp_flag );

HYPRE_Int
HYPRE_IJMatrixSetObjectType_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, HYPRE_Int type );

HYPRE_Int
HYPRE_IJMatrixSetPrintLevel_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, HYPRE_Int print_level );

HYPRE_Int
HYPRE_IJMatrixSetRowSizes_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, const HYPRE_Int *sizes );

HYPRE_Int
HYPRE_IJMatrixSetValues_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_Int *ncols, const HYPRE_BigInt *rows, const HYPRE_BigInt *cols, const void *values );

HYPRE_Int
HYPRE_IJMatrixSetValues2_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_Int *ncols, const HYPRE_BigInt *rows, const HYPRE_Int *row_indexes, const HYPRE_BigInt *cols, const void *values );

HYPRE_Int
HYPRE_IJMatrixTranspose_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix_A, HYPRE_IJMatrix *matrix_AT );

HYPRE_Int
HYPRE_IJVectorAddToValues_pre( HYPRE_Precision precision, HYPRE_IJVector vector, HYPRE_Int nvalues, const HYPRE_BigInt *indices, const void *values );

HYPRE_Int
HYPRE_IJVectorAssemble_pre( HYPRE_Precision precision, HYPRE_IJVector vector );

HYPRE_Int
HYPRE_IJVectorCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_BigInt jlower, HYPRE_BigInt jupper, HYPRE_IJVector *vector );

HYPRE_Int
HYPRE_IJVectorDestroy_pre( HYPRE_Precision precision, HYPRE_IJVector vector );

HYPRE_Int
HYPRE_IJVectorGetLocalRange_pre( HYPRE_Precision precision, HYPRE_IJVector vector, HYPRE_BigInt *jlower, HYPRE_BigInt *jupper );

HYPRE_Int
HYPRE_IJVectorGetObject_pre( HYPRE_Precision precision, HYPRE_IJVector vector, void **object );

HYPRE_Int
HYPRE_IJVectorGetObjectType_pre( HYPRE_Precision precision, HYPRE_IJVector vector, HYPRE_Int *type );

HYPRE_Int
HYPRE_IJVectorGetValues_pre( HYPRE_Precision precision, HYPRE_IJVector vector, HYPRE_Int nvalues, const HYPRE_BigInt *indices, void *values );

HYPRE_Int
HYPRE_IJVectorInitialize_pre( HYPRE_Precision precision, HYPRE_IJVector vector );

HYPRE_Int
HYPRE_IJVectorInitializeShell_pre( HYPRE_Precision precision, HYPRE_IJVector vector );

HYPRE_Int
HYPRE_IJVectorInitialize_v2_pre( HYPRE_Precision precision, HYPRE_IJVector vector, HYPRE_MemoryLocation memory_location );

HYPRE_Int
HYPRE_IJVectorInnerProd_pre( HYPRE_Precision precision, HYPRE_IJVector x, HYPRE_IJVector y, void *prod );

HYPRE_Int
HYPRE_IJVectorMigrate_pre( HYPRE_Precision precision, HYPRE_IJVector vector, HYPRE_MemoryLocation memory_location );

HYPRE_Int
HYPRE_IJVectorPrint_pre( HYPRE_Precision precision, HYPRE_IJVector vector, const char *filename );

HYPRE_Int
HYPRE_IJVectorPrintBinary_pre( HYPRE_Precision precision, HYPRE_IJVector vector, const char *filename );

HYPRE_Int
HYPRE_IJVectorRead_pre( HYPRE_Precision precision, const char *filename, MPI_Comm comm, HYPRE_Int type, HYPRE_IJVector *vector );

HYPRE_Int
HYPRE_IJVectorReadBinary_pre( HYPRE_Precision precision, const char *filename, MPI_Comm comm, HYPRE_Int type, HYPRE_IJVector *vector );

HYPRE_Int
HYPRE_IJVectorSetComponent_pre( HYPRE_Precision precision, HYPRE_IJVector vector, HYPRE_Int component );

HYPRE_Int
HYPRE_IJVectorSetConstantValues_pre( HYPRE_Precision precision, HYPRE_IJVector vector, hypre_long_double value );

HYPRE_Int
HYPRE_IJVectorSetData_pre( HYPRE_Precision precision, HYPRE_IJVector vector, void *data );

HYPRE_Int
HYPRE_IJVectorSetMaxOffProcElmts_pre( HYPRE_Precision precision, HYPRE_IJVector vector, HYPRE_Int max_off_proc_elmts );

HYPRE_Int
HYPRE_IJVectorSetNumComponents_pre( HYPRE_Precision precision, HYPRE_IJVector vector, HYPRE_Int num_components );

HYPRE_Int
HYPRE_IJVectorSetObjectType_pre( HYPRE_Precision precision, HYPRE_IJVector vector, HYPRE_Int type );

HYPRE_Int
HYPRE_IJVectorSetPrintLevel_pre( HYPRE_Precision precision, HYPRE_IJVector vector, HYPRE_Int print_level );

HYPRE_Int
HYPRE_IJVectorSetTags_pre( HYPRE_Precision precision, HYPRE_IJVector vector, HYPRE_Int owns_tags, HYPRE_Int num_tags, HYPRE_Int *tags );

HYPRE_Int
HYPRE_IJVectorSetValues_pre( HYPRE_Precision precision, HYPRE_IJVector vector, HYPRE_Int nvalues, const HYPRE_BigInt *indices, const void *values );

HYPRE_Int
HYPRE_IJVectorUpdateValues_pre( HYPRE_Precision precision, HYPRE_IJVector vector, HYPRE_Int nvalues, const HYPRE_BigInt *indices, const void *values, HYPRE_Int action );


#endif

#ifdef __cplusplus
}
#endif

#endif

