# Copyright 2018-2020 by Christopher C. Little.
# This file is part of Abydos.
#
# Abydos is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Abydos is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Abydos. If not, see <http://www.gnu.org/licenses/>.

"""abydos.tests.phonetic.test_phonetic_nrl.

This module contains unit tests for abydos.phonetic.NRL
"""

import unittest

from abydos.phonetic import NRL


class NRLTestCases(unittest.TestCase):
    """Test Naval Research Laboratory phonetic encoding functions.

    test cases for abydos.phonetic.NRL
    """

    pa = NRL()

    def test_nrl(self):
        """Test abydos.phonetic.NRL."""
        # Base case
        self.assertEqual(self.pa.encode(''), '')

        # common English words
        self.assertEqual(self.pa.encode('the'), 'DHAX')
        self.assertEqual(self.pa.encode('of'), 'AXv')
        self.assertEqual(self.pa.encode('and'), 'AEnd')
        self.assertEqual(self.pa.encode('a'), 'AX')
        self.assertEqual(self.pa.encode('to'), 'tUW')
        self.assertEqual(self.pa.encode('in'), 'IHn')
        self.assertEqual(self.pa.encode('is'), 'IHz')
        self.assertEqual(self.pa.encode('you'), 'yUW')
        self.assertEqual(self.pa.encode('that'), 'DHAEt')
        self.assertEqual(self.pa.encode('it'), 'IHt')
        self.assertEqual(self.pa.encode('he'), 'hIY')
        self.assertEqual(self.pa.encode('was'), 'wAAz')
        self.assertEqual(self.pa.encode('for'), 'fAOr')
        self.assertEqual(self.pa.encode('on'), 'AAn')
        self.assertEqual(self.pa.encode('are'), 'AAr')
        self.assertEqual(self.pa.encode('as'), 'AEz')
        self.assertEqual(self.pa.encode('with'), 'wIHTH')
        self.assertEqual(self.pa.encode('his'), 'hIHz')
        self.assertEqual(self.pa.encode('they'), 'DHEY')
        self.assertEqual(self.pa.encode('I'), 'AY')
        self.assertEqual(self.pa.encode('at'), 'AEt')
        self.assertEqual(self.pa.encode('be'), 'bIY')
        self.assertEqual(self.pa.encode('this'), 'DHIHs')
        self.assertEqual(self.pa.encode('have'), 'hAEv')
        self.assertEqual(self.pa.encode('from'), 'frAAm')
        self.assertEqual(self.pa.encode('or'), 'AOr')
        self.assertEqual(self.pa.encode('one'), 'wAHn')
        self.assertEqual(self.pa.encode('had'), 'hAEd')
        self.assertEqual(self.pa.encode('by'), 'bAY')
        self.assertEqual(self.pa.encode('word'), 'wERd')
        self.assertEqual(self.pa.encode('but'), 'bAHt')
        self.assertEqual(self.pa.encode('not'), 'nAAt')
        self.assertEqual(self.pa.encode('what'), 'WHAAt')
        self.assertEqual(self.pa.encode('all'), 'AOl')
        self.assertEqual(self.pa.encode('were'), 'wER')
        self.assertEqual(self.pa.encode('we'), 'wIY')
        self.assertEqual(self.pa.encode('when'), 'WHEHn')
        self.assertEqual(self.pa.encode('your'), 'yUWr')
        self.assertEqual(self.pa.encode('can'), 'kAEn')
        self.assertEqual(self.pa.encode('said'), 'sEHd')
        self.assertEqual(self.pa.encode('there'), 'DHEHr')
        self.assertEqual(self.pa.encode('use'), 'yUWz')
        self.assertEqual(self.pa.encode('an'), 'AEn')
        self.assertEqual(self.pa.encode('each'), 'IYCH')
        self.assertEqual(self.pa.encode('which'), 'WHIHCH')
        self.assertEqual(self.pa.encode('she'), 'SHIY')
        self.assertEqual(self.pa.encode('do'), 'dUW')
        self.assertEqual(self.pa.encode('how'), 'hAW')
        self.assertEqual(self.pa.encode('their'), 'DHEHr')
        self.assertEqual(self.pa.encode('if'), 'IHf')
        self.assertEqual(self.pa.encode('will'), 'wIHl')
        self.assertEqual(self.pa.encode('up'), 'AHp')
        self.assertEqual(self.pa.encode('other'), 'AHDHER')
        self.assertEqual(self.pa.encode('about'), 'AEbAWt')
        self.assertEqual(self.pa.encode('out'), 'AWt')
        self.assertEqual(self.pa.encode('many'), 'mEHnIY')
        self.assertEqual(self.pa.encode('then'), 'DHEHn')
        self.assertEqual(self.pa.encode('them'), 'DHEHm')
        self.assertEqual(self.pa.encode('these'), 'DHIYz')
        self.assertEqual(self.pa.encode('so'), 'sOW')
        self.assertEqual(self.pa.encode('some'), 'sAHm')
        self.assertEqual(self.pa.encode('her'), 'hER')
        self.assertEqual(self.pa.encode('would'), 'wUHd')
        self.assertEqual(self.pa.encode('make'), 'mEYk')
        self.assertEqual(self.pa.encode('like'), 'lAYk')
        self.assertEqual(self.pa.encode('him'), 'hIHm')
        self.assertEqual(self.pa.encode('into'), 'IHntUW')
        self.assertEqual(self.pa.encode('time'), 'tAYm')
        self.assertEqual(self.pa.encode('has'), 'hAEz')
        self.assertEqual(self.pa.encode('look'), 'lUHk')
        self.assertEqual(self.pa.encode('two'), 'tUW')
        self.assertEqual(self.pa.encode('more'), 'mAOr')
        self.assertEqual(self.pa.encode('write'), 'rAYt')
        self.assertEqual(self.pa.encode('go'), 'gOW')
        self.assertEqual(self.pa.encode('see'), 'sIY')
        self.assertEqual(self.pa.encode('number'), 'nAHmbER')
        self.assertEqual(self.pa.encode('no'), 'nOW')
        self.assertEqual(self.pa.encode('way'), 'wEY')
        self.assertEqual(self.pa.encode('could'), 'kUHd')
        self.assertEqual(self.pa.encode('people'), 'pIYpl')
        self.assertEqual(self.pa.encode('my'), 'mAY')
        self.assertEqual(self.pa.encode('than'), 'DHAEn')
        self.assertEqual(self.pa.encode('first'), 'fERst')
        self.assertEqual(self.pa.encode('water'), 'wAAtER')
        self.assertEqual(self.pa.encode('been'), 'bIYn')
        self.assertEqual(self.pa.encode('call'), 'kAOl')
        self.assertEqual(self.pa.encode('who'), 'hUW')
        self.assertEqual(self.pa.encode('oil'), 'OYl')
        self.assertEqual(self.pa.encode('its'), 'IHtz')
        self.assertEqual(self.pa.encode('now'), 'nAW')
        self.assertEqual(self.pa.encode('find'), 'fAYnd')
        self.assertEqual(self.pa.encode('long'), 'lAONG')
        self.assertEqual(self.pa.encode('down'), 'dAWn')
        self.assertEqual(self.pa.encode('day'), 'dEY')
        self.assertEqual(self.pa.encode('did'), 'dIHd')
        self.assertEqual(self.pa.encode('get'), 'gEHt')
        self.assertEqual(self.pa.encode('come'), 'kAHm')
        self.assertEqual(self.pa.encode('made'), 'mEYd')
        self.assertEqual(self.pa.encode('may'), 'mEY')
        self.assertEqual(self.pa.encode('part'), 'pAArt')
        self.assertEqual(self.pa.encode('supply'), 'sAHpplIH')
        self.assertEqual(self.pa.encode('corner'), 'kAOrnER')
        self.assertEqual(self.pa.encode('electric'), 'IYlEHktrIHk')
        self.assertEqual(self.pa.encode('insects'), 'IHnsEHktz')
        self.assertEqual(self.pa.encode('crops'), 'krAAps')
        self.assertEqual(self.pa.encode('tone'), 'tOWn')
        self.assertEqual(self.pa.encode('hit'), 'hIHt')
        self.assertEqual(self.pa.encode('sand'), 'sAEnd')
        self.assertEqual(self.pa.encode('doctor'), 'dAAktER')
        self.assertEqual(self.pa.encode('provide'), 'prAHvAYd')
        self.assertEqual(self.pa.encode('thus'), 'DHAHs')
        self.assertEqual(self.pa.encode("won't"), 'wOWnt')
        self.assertEqual(self.pa.encode('cook'), 'kUHk')
        self.assertEqual(self.pa.encode('bones'), 'bOWnz')
        self.assertEqual(self.pa.encode('tail'), 'tEYl')
        self.assertEqual(self.pa.encode('board'), 'bOWrd')
        self.assertEqual(self.pa.encode('modern'), 'mOWdERn')
        self.assertEqual(self.pa.encode('compound'), 'kAAmpAWnd')
        self.assertEqual(self.pa.encode('mine'), 'mAYn')
        self.assertEqual(self.pa.encode("wasn't"), 'wAAzAXnt')
        self.assertEqual(self.pa.encode('fit'), 'fIHt')
        self.assertEqual(self.pa.encode('addition'), 'AEddIHSHAXn')
        self.assertEqual(self.pa.encode('belong'), 'bIHlAONG')
        self.assertEqual(self.pa.encode('safe'), 'sEYf')
        self.assertEqual(self.pa.encode('soldiers'), 'sOWldIYERs')
        self.assertEqual(self.pa.encode('guess'), 'gEHs')
        self.assertEqual(self.pa.encode('silent'), 'sAYlEHnt')
        self.assertEqual(self.pa.encode('trade'), 'trEYd')
        self.assertEqual(self.pa.encode('rather'), 'rAEDHER')
        self.assertEqual(self.pa.encode('compare'), 'kAAmpEHr')
        self.assertEqual(self.pa.encode('crowd'), 'krOWd')
        self.assertEqual(self.pa.encode('poem'), 'pOWEHm')
        self.assertEqual(self.pa.encode('enjoy'), 'EHnjOY')
        self.assertEqual(self.pa.encode('elements'), 'IYlIYmEHntz')
        self.assertEqual(self.pa.encode('indicate'), 'IHndIHkEYt')
        self.assertEqual(self.pa.encode('except'), 'EHkssEHpt')
        self.assertEqual(self.pa.encode('expect'), 'EHkspEHkt')
        self.assertEqual(self.pa.encode('flat'), 'flAEt')
        self.assertEqual(self.pa.encode('seven'), 'sIYvEHn')
        self.assertEqual(self.pa.encode('interest'), 'IHntIYrEHst')
        self.assertEqual(self.pa.encode('sense'), 'sEHns')
        self.assertEqual(self.pa.encode('string'), 'strIHNG')
        self.assertEqual(self.pa.encode('blow'), 'blOW')
        self.assertEqual(self.pa.encode('famous'), 'fAEmAXs')
        self.assertEqual(self.pa.encode('value'), 'vAElUW')
        self.assertEqual(self.pa.encode('wings'), 'wIHNGz')
        self.assertEqual(self.pa.encode('movement'), 'mUWvIYmEHnt')
        self.assertEqual(self.pa.encode('pole'), 'pOWl')
        self.assertEqual(self.pa.encode('exciting'), 'EHkssAYtIHNG')
        self.assertEqual(self.pa.encode('branches'), 'brAEnCHIHz')
        self.assertEqual(self.pa.encode('thick'), 'THIHk')
        self.assertEqual(self.pa.encode('blood'), 'blUHd')
        self.assertEqual(self.pa.encode('lie'), 'lAY')
        self.assertEqual(self.pa.encode('spot'), 'spAAt')
        self.assertEqual(self.pa.encode('bell'), 'bEHl')
        self.assertEqual(self.pa.encode('fun'), 'fAHn')
        self.assertEqual(self.pa.encode('loud'), 'lAWd')
        self.assertEqual(self.pa.encode('consider'), 'kAAnsAYdER')
        self.assertEqual(self.pa.encode('suggested'), 'sAHgjEHstIHd')
        self.assertEqual(self.pa.encode('thin'), 'THIHn')
        self.assertEqual(self.pa.encode('position'), 'pAAzIHSHAXn')
        self.assertEqual(self.pa.encode('entered'), 'EHntIYrd')
        self.assertEqual(self.pa.encode('fruit'), 'frUWIHt')
        self.assertEqual(self.pa.encode('tied'), 'tAYd')
        self.assertEqual(self.pa.encode('rich'), 'rIHCH')
        self.assertEqual(self.pa.encode('dollars'), 'dAAlAArs')
        self.assertEqual(self.pa.encode('send'), 'sEHnd')
        self.assertEqual(self.pa.encode('sight'), 'sAYt')
        self.assertEqual(self.pa.encode('chief'), 'CHAYEHf')
        self.assertEqual(self.pa.encode('Japanese'), 'jAEpAEnIYz')
        self.assertEqual(self.pa.encode('stream'), 'strIYm')
        self.assertEqual(self.pa.encode('plants'), 'plAEntz')
        self.assertEqual(self.pa.encode('rhythm'), 'rIHTHm')
        self.assertEqual(self.pa.encode('eight'), 'EYt')
        self.assertEqual(self.pa.encode('science'), 'sAYEHns')
        self.assertEqual(self.pa.encode('major'), 'mAEjER')
        self.assertEqual(self.pa.encode('observe'), 'AAbsERv')
        self.assertEqual(self.pa.encode('tube'), 'tUWb')
        self.assertEqual(self.pa.encode('necessary'), 'nIYsEHsAArIH')
        self.assertEqual(self.pa.encode('weight'), 'wEYt')
        self.assertEqual(self.pa.encode('meat'), 'mIYt')
        self.assertEqual(self.pa.encode('lifted'), 'lIHftIHd')
        self.assertEqual(self.pa.encode('process'), 'prOWsEHs')
        self.assertEqual(self.pa.encode('army'), 'AArmIY')
        self.assertEqual(self.pa.encode('hat'), 'hAEt')
        self.assertEqual(self.pa.encode('property'), 'prOWpERtIH')
        self.assertEqual(self.pa.encode('particular'), 'pAArtIHkyUWlER')
        self.assertEqual(self.pa.encode('swim'), 'swIHm')
        self.assertEqual(self.pa.encode('terms'), 'tERmz')
        self.assertEqual(self.pa.encode('current'), 'kERrEHnt')
        self.assertEqual(self.pa.encode('park'), 'pAArk')
        self.assertEqual(self.pa.encode('sell'), 'sEHl')
        self.assertEqual(self.pa.encode('shoulder'), 'SHUHdER')
        self.assertEqual(self.pa.encode('industry'), 'IHndAHstrIH')
        self.assertEqual(self.pa.encode('wash'), 'wAASH')
        self.assertEqual(self.pa.encode('block'), 'blAAk')
        self.assertEqual(self.pa.encode('spread'), 'sprEHd')
        self.assertEqual(self.pa.encode('cattle'), 'kAEttl')
        self.assertEqual(self.pa.encode('wife'), 'wAYf')
        self.assertEqual(self.pa.encode('sharp'), 'SHAArp')
        self.assertEqual(self.pa.encode('company'), 'kAAmpAEnIH')
        self.assertEqual(self.pa.encode('radio'), 'rEYdIHOW')
        self.assertEqual(self.pa.encode("we'll"), 'wEHl')
        self.assertEqual(self.pa.encode('action'), 'AEkSHAXn')
        self.assertEqual(self.pa.encode('capital'), 'kAEpIHtAXl')
        self.assertEqual(self.pa.encode('factories'), 'fAEktAOrIYs')
        self.assertEqual(self.pa.encode('settled'), 'sEHttld')
        self.assertEqual(self.pa.encode('yellow'), 'yEHlOW')
        self.assertEqual(self.pa.encode("isn't"), 'IHzAXnt')
        self.assertEqual(self.pa.encode('southern'), 'sAWDHERn')
        self.assertEqual(self.pa.encode('truck'), 'trAHk')
        self.assertEqual(self.pa.encode('train'), 'trEYn')
        self.assertEqual(self.pa.encode('printed'), 'prIHntIHd')
        self.assertEqual(self.pa.encode("wouldn't"), 'wUHdnt')
        self.assertEqual(self.pa.encode('ahead'), 'EYhEHd')
        self.assertEqual(self.pa.encode('chance'), 'CHAEns')
        self.assertEqual(self.pa.encode('born'), 'bAOrn')
        self.assertEqual(self.pa.encode('level'), 'lIYvEHl')
        self.assertEqual(self.pa.encode('triangle'), 'trIHAENGgAXl')
        self.assertEqual(self.pa.encode('molecules'), 'mOWlEHkyUWlz')
        self.assertEqual(self.pa.encode('France'), 'frAEns')
        self.assertEqual(self.pa.encode('repeated'), 'rIYpIYtIHd')
        self.assertEqual(self.pa.encode('column'), 'kAAlAHmn')
        self.assertEqual(self.pa.encode('western'), 'wEHstERn')
        self.assertEqual(self.pa.encode('church'), 'CHERCH')
        self.assertEqual(self.pa.encode('sister'), 'sIHstER')
        self.assertEqual(self.pa.encode('oxygen'), 'AAksIHjEHn')
        self.assertEqual(self.pa.encode('plural'), 'plUHrAXl')
        self.assertEqual(self.pa.encode('various'), 'vEHrIHAXs')
        self.assertEqual(self.pa.encode('agreed'), 'AEgrIYd')
        self.assertEqual(self.pa.encode('opposite'), 'AAppAAzAYt')
        self.assertEqual(self.pa.encode('wrong'), 'rAONG')
        self.assertEqual(self.pa.encode('chart'), 'CHAArt')
        self.assertEqual(self.pa.encode('prepared'), 'prEHpEHrd')
        self.assertEqual(self.pa.encode('pretty'), 'prEHttIH')
        self.assertEqual(self.pa.encode('solution'), 'sAAlUWSHAXn')
        self.assertEqual(self.pa.encode('fresh'), 'frEHSH')
        self.assertEqual(self.pa.encode('shop'), 'SHAAp')
        self.assertEqual(self.pa.encode('suffix'), 'sAHffIHks')
        self.assertEqual(self.pa.encode('especially'), 'EHspEHSHAXlIY')
        self.assertEqual(self.pa.encode('shoes'), 'SHOWz')
        self.assertEqual(self.pa.encode('actually'), 'AEkCHUWAXlIY')
        self.assertEqual(self.pa.encode('nose'), 'nOWz')
        self.assertEqual(self.pa.encode('afraid'), 'AEfrEYd')
        self.assertEqual(self.pa.encode('dead'), 'dEHd')
        self.assertEqual(self.pa.encode('sugar'), 'sUWgER')
        self.assertEqual(self.pa.encode('adjective'), 'AEdjEHktAYv')
        self.assertEqual(self.pa.encode('fig'), 'fIHg')
        self.assertEqual(self.pa.encode('office'), 'AOffIHs')
        self.assertEqual(self.pa.encode('huge'), 'hyUWj')
        self.assertEqual(self.pa.encode('gun'), 'gAHn')
        self.assertEqual(self.pa.encode('similar'), 'sIHmIHlER')
        self.assertEqual(self.pa.encode('death'), 'dIYTH')
        self.assertEqual(self.pa.encode('score'), 'skAOr')
        self.assertEqual(self.pa.encode('forward'), 'fAOrwAOrd')
        self.assertEqual(self.pa.encode('stretched'), 'strEHtCHd')
        self.assertEqual(self.pa.encode('experience'), 'EHkspIYrIYEHns')
        self.assertEqual(self.pa.encode('rose'), 'rOWz')
        self.assertEqual(self.pa.encode('allow'), 'AOlOW')
        self.assertEqual(self.pa.encode('fear'), 'fIYr')
        self.assertEqual(self.pa.encode('workers'), 'wERkERs')
        self.assertEqual(self.pa.encode('Washington'), 'wAASHIHNGtAXn')
        self.assertEqual(self.pa.encode('Greek'), 'grIYk')
        self.assertEqual(self.pa.encode('women'), 'wOWmEHn')
        self.assertEqual(self.pa.encode('brought'), 'brAOt')
        self.assertEqual(self.pa.encode('led'), 'lEHd')
        self.assertEqual(self.pa.encode('march'), 'mAArCH')
        self.assertEqual(self.pa.encode('northern'), 'nAOrDHERn')
        self.assertEqual(self.pa.encode('create'), 'krIYt')
        self.assertEqual(self.pa.encode('British'), 'brAYtIHSH')
        self.assertEqual(self.pa.encode('difficult'), 'dIHffIHkAHlt')
        self.assertEqual(self.pa.encode('match'), 'mAEtCH')
        self.assertEqual(self.pa.encode('win'), 'wIHn')
        self.assertEqual(self.pa.encode("doesn't"), 'dAHznt')
        self.assertEqual(self.pa.encode('steel'), 'stIYl')
        self.assertEqual(self.pa.encode('total'), 'tAAtAXl')
        self.assertEqual(self.pa.encode('deal'), 'dIYl')
        self.assertEqual(self.pa.encode('determine'), 'dIHtERmAYn')
        self.assertEqual(self.pa.encode('evening'), 'IYvIYnIHNG')
        self.assertEqual(self.pa.encode('nor'), 'nAOr')
        self.assertEqual(self.pa.encode('rope'), 'rOWp')
        self.assertEqual(self.pa.encode('cotton'), 'kAAttAXn')
        self.assertEqual(self.pa.encode('apple'), 'AEppAXl')
        self.assertEqual(self.pa.encode('details'), 'dIHtEYlz')
        self.assertEqual(self.pa.encode('entire'), 'EHntAYr')
        self.assertEqual(self.pa.encode('corn'), 'kAOrn')
        self.assertEqual(self.pa.encode('substances'), 'sAHbstAEnsIHz')
        self.assertEqual(self.pa.encode('smell'), 'smEHl')
        self.assertEqual(self.pa.encode('tools'), 'tUWlz')
        self.assertEqual(self.pa.encode('conditions'), 'kAAndIHSHAXnz')
        self.assertEqual(self.pa.encode('cows'), 'kOWz')
        self.assertEqual(self.pa.encode('track'), 'trAEk')
        self.assertEqual(self.pa.encode('arrived'), 'AXrIHvd')
        self.assertEqual(self.pa.encode('located'), 'lOWkEYtIHd')
        self.assertEqual(self.pa.encode('sir'), 'sER')
        self.assertEqual(self.pa.encode('seat'), 'sIYt')
        self.assertEqual(self.pa.encode('division'), 'dIHvIHZHAXn')
        self.assertEqual(self.pa.encode('effect'), 'EHffEHkt')
        self.assertEqual(self.pa.encode('underline'), 'AHndERlAYn')
        self.assertEqual(self.pa.encode('view'), 'vyUW')

        # non-English words (with letters not used in English)
        self.assertEqual(self.pa.encode('garçon'), 'gAArÇAAn')
        self.assertEqual(self.pa.encode('ðæt'), 'ÐÆt')
        self.assertEqual(self.pa.encode('wünschen'), 'wÜnsCHEHn')
        self.assertEqual(self.pa.encode('øl'), 'Øl')


if __name__ == '__main__':
    unittest.main()
