French and Arpitan: `apertium-fra-frp`
===============================================================================

This is an Apertium language pair for translating between French and
Arpitan. What you can use this language package for:

* Translating between French and Arpitan
* Morphological analysis of French and Arpitan
* Part-of-speech tagging of French and Arpitan

For information on the latter two points, see subheading "For more
information" below.

Requirements
-------------------------------------------------------------------------------

You will need the following software installed:

* lttoolbox (>= 3.3.0)
* apertium (>= 3.3.0)
* vislcg3 (>= 0.9.9.10297)
* apertium-fra
* apertium-frp

If this does not make any sense, we recommend you look at: apertium.org.

Compiling
-------------------------------------------------------------------------------

Given the requirements being installed, you should be able to just run:

```console
$ ./configure
$ make
# make install
```

You can use `./autogen.sh` instead of `./configure` in case you're compiling
from source. If you installed any prerequisite language packages using a
`--prefix` with `./configure`, make sure to use the same `--prefix` when running
`./configure` here.

Testing
-------------------------------------------------------------------------------

If you are in the source directory after running make, the following
commands should work:

```console
echo "Apertium est un logiciel de traduction automatique" | apertium -d . fra-oci
Apertium est una programerie de traduccion ôtomatica

$ echo "Apertium est una programerie de traduccion ôtomatica" | apertium -d . frp-fra
Apertium est un logiciel de traduction automatique
```

After installing somewhere in `$PATH`, you should be able to do e.g.

```console
$ echo "Apertium est un logiciel de traduction automatique" | apertium fra-frp
Apertium est una programerie de traduccion ôtomatica
```

Files and data
-------------------------------------------------------------------------------

* [`apertium-fra-frp.fra-frp.dix`](apertium-fra-frp.fra-frp.dix) - Bilingual dictionary
* [`apertium-fra-frp.fra-frp.t1x`](apertium-fra-frp.fra-frp.t1x) - Chunking rules for translating into Arpitan
* [`apertium-fra-frp.frp-fra.t1x`](apertium-fra-frp.frp-fra.t1x) - Chunking rules for translating into French
* [`apertium-fra-frp.fra-frp.t2x`](apertium-fra-frp.fra-frp.t2x) - Interchunk rules for translating into Arpitan
* [`apertium-fra-frp.frp-fra.t2ax`](apertium-fra-frp.frp-fra.t2ax) - Interchunk rules for translating into French (step 1)
* [`apertium-fra-frp.frp-fra.t2bx`](apertium-fra-frp.frp-fra.t2bx) - Interchunk rules for translating into French (step 2)
* [`apertium-fra-frp.frp-fra.t2cx`](apertium-fra-frp.frp-fra.t2cx) - Interchunk rules for translating into French (step 3)
* [`apertium-fra-frp.fra-frp.t3x`](apertium-fra-frp.fra-frp.t3x) - Postchunk rules for translating into Arpitan
* [`apertium-fra-frp.frp-fra.t3x`](apertium-fra-frp.frp-fra.t3x) - Postchunk rules for translating into French
* [`apertium-fra-frp.fra-frp.lrx`](apertium-fra-frp.fra-frp.lrx) - Lexical selection rules for translating into Arpitan
* [`apertium-fra-frp.frp-fra.lrx`](apertium-fra-frp.frp-fra.lrx) - Lexical selection rules for translating into French
* [`apertium-fra-frp.fra-frp.l1x`](apertium-fra-frp.fra-frp.l1x) - Rules for recognising expressions with discontiguous words for translating into Arpitan
* [`apertium-fra-frp.fra-frp.l2x`](apertium-fra-frp.fra-frp.l2x) - Rules for reordering words in discontiguous expressions for translating into Arpitan
* [`apertium-fra-frp.frp-fra.l1x`](apertium-fra-frp.frp-fra.l1x) - Rules for recognising expressions with discontiguous words for translating into French
* [`apertium-fra-frp.frp-fra.l2x`](apertium-fra-frp.frp-fra.l2x) - Rules for reordering words in discontiguous expressions for translating into French
* [`modes.xml`](modes.xml) - Translation modes

For more information
-------------------------------------------------------------------------------

* https://wiki.apertium.org/wiki/Installation
* https://wiki.apertium.org/wiki/apertium-fra-frp
* https://wiki.apertium.org/wiki/Using_an_lttoolbox_dictionary

Help and support
-------------------------------------------------------------------------------

If you need help using this language pair or data, you can contact:

* Mailing list: apertium-stuff@lists.sourceforge.net
* IRC: `#apertium` on irc.oftc.net (irc://irc.oftc.net/#apertium)

See also the file [`AUTHORS`](AUTHORS), included in this distribution.
