;; Scheduling description for zEC12 (cpu 2827).
;;   Copyright (C) 2012-2015 Free Software Foundation, Inc.
;;   Contributed by Andreas Krebbel (Andreas.Krebbel@de.ibm.com)

;; This file is part of GCC.

;; GCC is free software; you can redistribute it and/or modify it under
;; the terms of the GNU General Public License as published by the Free
;; Software Foundation; either version 3, or (at your option) any later
;; version.

;; GCC is distributed in the hope that it will be useful, but WITHOUT ANY
;; WARRANTY; without even the implied warranty of MERCHANTABILITY or
;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;; for more details.

;; You should have received a copy of the GNU General Public License
;; along with GCC; see the file COPYING3.  If not see
;; <http://www.gnu.org/licenses/>.

(define_attr "zEC12_cracked" ""
  (cond [(eq_attr "mnemonic" "cgdbr,clfxtr,cdgtr,celfbr,cxgtr,clfebr,clc,lngfr,cs,cfxbr,xc,clfdbr,basr,ex,cxlgtr,clfdtr,srdl,lpgfr,cdlgbr,cgxtr,cxlftr,nc,cxftr,cdfbr,clfxbr,cdftr,clgxbr,cgdtr,cxlgbr,mvc,clgdtr,cegbr,cfebr,cdlftr,sldl,cdlgtr,csg,chhsi,clgebr,cxgbr,cxfbr,cdlfbr,cgebr,lzxr,oc,cdgbr,brasl,cgxbr,cxlfbr,clgxtr,exrl,cfdbr,celgbr,clgdbr,lxr,cpsdr,lcgfr,bras,srda,cefbr") (const_int 1)]
        (const_int 0)))

(define_attr "zEC12_expanded" ""
  (cond [(eq_attr "mnemonic" "dlr,dsgr,d,dsgf,stam,dsgfr,dlgr,dsg,cds,dr,stm,mvc,dl,cdsg,stmy,dlg,stmg,lam") (const_int 1)]
        (const_int 0)))

(define_attr "zEC12_endgroup" ""
  (cond [(eq_attr "mnemonic" "ipm") (const_int 1)]
        (const_int 0)))

(define_attr "zEC12_groupalone" ""
  (cond [(eq_attr "mnemonic" "lnxbr,madb,ltxtr,clc,axtr,msebr,slbgr,xc,alcr,lpxbr,slbr,maebr,mlg,mfy,lxdtr,maeb,lxeb,nc,mxtr,sxtr,dxbr,alc,msdbr,ltxbr,lxdb,madbr,lxdbr,lxebr,mvc,m,mseb,mlr,mlgr,slb,tcxb,msdb,sqxbr,alcgr,oc,flogr,alcg,mxbr,dxtr,axbr,mr,sxbr,slbg,ml,lcxbr,bcr_flush") (const_int 1)]
        (const_int 0)))

(define_insn_reservation "zEC12_simple_int" 0
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "ltg,ogrk,lr,lghrl,x,asi,lhr,ar,lhrl,llgfr,clghrl,cgr,cli,agrk,ic,lrv,clg,cy,cghi,sy,clgfr,al,tm,lang,lghr,laa,ark,lh,or,icy,xi,n,llihl,afi,cs,nrk,sth,lgr,l,lcr,stey,xg,crt,slgfr,ny,ld,j,llihh,slgr,clfhsi,slg,lb,lgrl,lrl,llihf,llcr,laxg,mvghi,rllg,xrk,laag,alhsik,algfi,algr,aly,agfi,lrvr,d,crl,llgc,tmhl,algsi,lgh,icmh,clhrl,xgrk,icm,iilf,ork,cg,ldgr,lgf,iihf,llghr,sg,stam,tmhh,slgf,basr,lgb,cgfi,lax,clfit,lrvgr,nihl,ni,srdl,srk,xihf,stgrl,sthrl,algf,cgit,ng,lat,llghrl,ltgr,nihh,clgfrl,srlk,agr,ler,bcr_flush,stcy,cds,clfi,nihf,ly,clt,lgat,alg,lhy,lgfrl,clghsi,clrt,tmll,srlg,ay,sty,clr,lgfi,lan,clgt,ahik,sra,algrk,clgr,tmy,tmlh,alghsik,lcgr,mvi,ltgf,xr,larl,ldr,llgcr,clgrt,clrl,cghsi,cliy,oy,ogr,llgt,slr,chi,s,icmy,llc,ngr,clhhsi,ltgfr,llill,lhi,o,sll,clgrl,clgf,mviy,algfr,rll,sldl,lg,niy,st,sgr,ag,le,xgr,cr,stg,llilh,sr,cdsg,sllk,stoc,csg,clgit,chhsi,strl,llilf,lndfr,ngrk,clgfi,llgh,oill,la,llhrl,stc,lghi,oihl,xiy,sllg,llgf,cgrt,cl,sl,oi,oilh,nr,srak,oihh,ear,slgrk,og,c,slgfi,sthy,oilf,oiy,oihf,a,cfi,srag,brasl,alr,cgrl,llgfrl,cit,ley,exrl,lcdfr,lay,xilf,alsi,mvhhi,srl,chsi,lgfr,lrvg,cly,sgrk,ahi,nill,jg,slrk,lxr,sar,slfi,cpsdr,lcgfr,aghik,nilh,mvhi,lpdfr,xy,alrk,lao,agsi,ldy,nilf,llhr,alfi,laog,sly,aghi,bras,srda,lt,lbr,lzxr,lzdr,lzer")) "nothing")

(define_insn_reservation "zEC12_simple_fp" 1
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "lnebr,sdbr,sebr,clfxtr,adbr,aebr,celfbr,clfebr,lpebr,msebr,lndbr,clfdbr,llgtr,cebr,lgbr,maebr,ltebr,clfdtr,ltr,cdlgbr,cxlftr,lpdbr,cdfbr,lcebr,clfxbr,msdbr,cdbr,madbr,meebr,clgxbr,clgdtr,ledbr,cegbr,cdlftr,cdlgtr,mdbr,clgebr,ltdbr,cdlfbr,cdgbr,clgxtr,lcdbr,celgbr,clgdbr,ldebr,cefbr,fidtr,fixtr,madb,msdb,mseb,fiebra,fidbra,fixbra,aeb,mdb,seb,cdb,tcdb,sdb,adb,tceb,maeb,ceb,meeb,ldeb")) "nothing")

(define_insn_reservation "zEC12_cgdbr" 2
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "cgdbr")) "nothing")

(define_insn_reservation "zEC12_clm" 2
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "clm")) "nothing")

(define_insn_reservation "zEC12_lnxbr" 2
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "lnxbr")) "nothing")

(define_insn_reservation "zEC12_lngr" 2
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "lngr")) "nothing")

(define_insn_reservation "zEC12_cdgtr" 45
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "cdgtr")) "nothing")

(define_insn_reservation "zEC12_ddtr" 37
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "ddtr")) "nothing")

(define_insn_reservation "zEC12_mhy" 5
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "mhy")) "nothing")

(define_insn_reservation "zEC12_dlr" 25
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "dlr")) "nothing")

(define_insn_reservation "zEC12_ltxtr" 18
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "ltxtr")) "nothing")

(define_insn_reservation "zEC12_cxgtr" 32
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "cxgtr")) "nothing")

(define_insn_reservation "zEC12_lgdr" 3
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "lgdr")) "nothing")

(define_insn_reservation "zEC12_clc" 5
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "clc")) "nothing")

(define_insn_reservation "zEC12_dsgr" 25
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "dsgr")) "nothing")

(define_insn_reservation "zEC12_axtr" 27
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "axtr")) "nothing")

(define_insn_reservation "zEC12_lngfr" 2
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "lngfr")) "nothing")

(define_insn_reservation "zEC12_cghrl" 2
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "cghrl")) "nothing")

(define_insn_reservation "zEC12_ah" 2
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "ah")) "nothing")

(define_insn_reservation "zEC12_cgh" 2
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "cgh")) "nothing")

(define_insn_reservation "zEC12_locg" 2
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "locg")) "nothing")

(define_insn_reservation "zEC12_msgfi" 6
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "msgfi")) "nothing")

(define_insn_reservation "zEC12_slbgr" 3
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "slbgr")) "nothing")

(define_insn_reservation "zEC12_lpgr" 2
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "lpgr")) "nothing")

(define_insn_reservation "zEC12_loc" 2
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "loc")) "nothing")

(define_insn_reservation "zEC12_cgf" 2
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "cgf")) "nothing")

(define_insn_reservation "zEC12_lmy" 0
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "lmy")) "nothing")

(define_insn_reservation "zEC12_std" 3
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "std")) "nothing")

(define_insn_reservation "zEC12_xc" 4
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "xc")) "nothing")

(define_insn_reservation "zEC12_msy" 6
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "msy")) "nothing")

(define_insn_reservation "zEC12_sqebr" 29
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "sqebr")) "nothing")

(define_insn_reservation "zEC12_alcr" 3
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "alcr")) "nothing")

(define_insn_reservation "zEC12_msgr" 8
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "msgr")) "nothing")

(define_insn_reservation "zEC12_mhi" 5
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "mhi")) "nothing")

(define_insn_reservation "zEC12_mdtr" 0
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "mdtr")) "nothing")

(define_insn_reservation "zEC12_dsgf" 25
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "dsgf")) "nothing")

(define_insn_reservation "zEC12_lpxbr" 2
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "lpxbr")) "nothing")

(define_insn_reservation "zEC12_stdy" 3
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "stdy")) "nothing")

(define_insn_reservation "zEC12_deb" 23
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "deb")) "nothing")

(define_insn_reservation "zEC12_ltdtr" 17
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "ltdtr")) "nothing")

(define_insn_reservation "zEC12_dsgfr" 25
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "dsgfr")) "nothing")

(define_insn_reservation "zEC12_slbr" 3
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "slbr")) "nothing")

(define_insn_reservation "zEC12_dlgr" 27
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "dlgr")) "nothing")

(define_insn_reservation "zEC12_dsg" 25
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "dsg")) "nothing")

(define_insn_reservation "zEC12_mlg" 9
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "mlg")) "nothing")

(define_insn_reservation "zEC12_ex" 16
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "ex")) "nothing")

(define_insn_reservation "zEC12_mfy" 7
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "mfy")) "nothing")

(define_insn_reservation "zEC12_cxlgtr" 4
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "cxlgtr")) "nothing")

(define_insn_reservation "zEC12_lxdtr" 15
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "lxdtr")) "nothing")

(define_insn_reservation "zEC12_mghi" 5
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "mghi")) "nothing")

(define_insn_reservation "zEC12_lpgfr" 2
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "lpgfr")) "nothing")

(define_insn_reservation "zEC12_ledtr" 34
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "ledtr")) "nothing")

(define_insn_reservation "zEC12_ms" 6
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "ms")) "nothing")

(define_insn_reservation "zEC12_ldetr" 17
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "ldetr")) "nothing")

(define_insn_reservation "zEC12_tdcxt" 12
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "tdcxt")) "nothing")

(define_insn_reservation "zEC12_lpr" 2
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "lpr")) "nothing")

(define_insn_reservation "zEC12_msgf" 6
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "msgf")) "nothing")

(define_insn_reservation "zEC12_chy" 2
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "chy")) "nothing")

(define_insn_reservation "zEC12_cgxtr" 30
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "cgxtr")) "nothing")

(define_insn_reservation "zEC12_lmg" 0
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "lmg")) "nothing")

(define_insn_reservation "zEC12_tdcet" 14
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "tdcet")) "nothing")

(define_insn_reservation "zEC12_lxeb" 3
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "lxeb")) "nothing")

(define_insn_reservation "zEC12_msg" 8
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "msg")) "nothing")

(define_insn_reservation "zEC12_nc" 4
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "nc")) "nothing")

(define_insn_reservation "zEC12_locgr" 2
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "locgr")) "nothing")

(define_insn_reservation "zEC12_debr" 23
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "debr")) "nothing")

(define_insn_reservation "zEC12_chrl" 2
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "chrl")) "nothing")

(define_insn_reservation "zEC12_mxtr" 37
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "mxtr")) "nothing")

(define_insn_reservation "zEC12_sgfr" 2
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "sgfr")) "nothing")

(define_insn_reservation "zEC12_cxftr" 4
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "cxftr")) "nothing")

(define_insn_reservation "zEC12_sxtr" 27
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "sxtr")) "nothing")

(define_insn_reservation "zEC12_dxbr" 50
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "dxbr")) "nothing")

(define_insn_reservation "zEC12_alc" 3
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "alc")) "nothing")

(define_insn_reservation "zEC12_cgfrl" 2
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "cgfrl")) "nothing")

(define_insn_reservation "zEC12_ltxbr" 2
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "ltxbr")) "nothing")

(define_insn_reservation "zEC12_dr" 16
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "dr")) "nothing")

(define_insn_reservation "zEC12_lxdb" 3
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "lxdb")) "nothing")

(define_insn_reservation "zEC12_tdcdt" 11
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "tdcdt")) "nothing")

(define_insn_reservation "zEC12_clmy" 2
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "clmy")) "nothing")

(define_insn_reservation "zEC12_locr" 2
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "locr")) "nothing")

(define_insn_reservation "zEC12_agf" 2
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "agf")) "nothing")

(define_insn_reservation "zEC12_lm" 0
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "lm")) "nothing")

(define_insn_reservation "zEC12_msgfr" 6
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "msgfr")) "nothing")

(define_insn_reservation "zEC12_lxdbr" 3
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "lxdbr")) "nothing")

(define_insn_reservation "zEC12_stm" 0
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "stm")) "nothing")

(define_insn_reservation "zEC12_cgdtr" 2
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "cgdtr")) "nothing")

(define_insn_reservation "zEC12_lxebr" 3
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "lxebr")) "nothing")

(define_insn_reservation "zEC12_cxlgbr" 3
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "cxlgbr")) "nothing")

(define_insn_reservation "zEC12_mvc" 4
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "mvc")) "nothing")

(define_insn_reservation "zEC12_sqdbr" 43
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "sqdbr")) "nothing")

(define_insn_reservation "zEC12_dl" 25
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "dl")) "nothing")

(define_insn_reservation "zEC12_cfebr" 2
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "cfebr")) "nothing")

(define_insn_reservation "zEC12_agfr" 2
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "agfr")) "nothing")

(define_insn_reservation "zEC12_lnr" 2
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "lnr")) "nothing")

(define_insn_reservation "zEC12_m" 7
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "m")) "nothing")

(define_insn_reservation "zEC12_ipm" 3
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "ipm")) "nothing")

(define_insn_reservation "zEC12_cxbr" 18
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "cxbr")) "nothing")

(define_insn_reservation "zEC12_ddbr" 30
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "ddbr")) "nothing")

(define_insn_reservation "zEC12_stmy" 0
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "stmy")) "nothing")

(define_insn_reservation "zEC12_ste" 3
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "ste")) "nothing")

(define_insn_reservation "zEC12_ahy" 2
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "ahy")) "nothing")

(define_insn_reservation "zEC12_mlr" 7
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "mlr")) "nothing")

(define_insn_reservation "zEC12_sqeb" 29
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "sqeb")) "nothing")

(define_insn_reservation "zEC12_dlg" 27
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "dlg")) "nothing")

(define_insn_reservation "zEC12_cxgbr" 3
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "cxgbr")) "nothing")

(define_insn_reservation "zEC12_cxfbr" 3
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "cxfbr")) "nothing")

(define_insn_reservation "zEC12_mlgr" 9
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "mlgr")) "nothing")

(define_insn_reservation "zEC12_cgfr" 2
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "cgfr")) "nothing")

(define_insn_reservation "zEC12_slb" 3
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "slb")) "nothing")

(define_insn_reservation "zEC12_sdtr" 12
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "sdtr")) "nothing")

(define_insn_reservation "zEC12_tcxb" 2
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "tcxb")) "nothing")

(define_insn_reservation "zEC12_cgebr" 2
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "cgebr")) "nothing")

(define_insn_reservation "zEC12_ch" 2
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "ch")) "nothing")

(define_insn_reservation "zEC12_sh" 2
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "sh")) "nothing")

(define_insn_reservation "zEC12_sgf" 2
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "sgf")) "nothing")

(define_insn_reservation "zEC12_msr" 6
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "msr")) "nothing")

(define_insn_reservation "zEC12_sqxbr" 50
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "sqxbr")) "nothing")

(define_insn_reservation "zEC12_alcgr" 3
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "alcgr")) "nothing")

(define_insn_reservation "zEC12_oc" 4
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "oc")) "nothing")

(define_insn_reservation "zEC12_adtr" 24
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "adtr")) "nothing")

(define_insn_reservation "zEC12_cgxbr" 2
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "cgxbr")) "nothing")

(define_insn_reservation "zEC12_cxlfbr" 3
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "cxlfbr")) "nothing")

(define_insn_reservation "zEC12_sqdb" 43
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "sqdb")) "nothing")

(define_insn_reservation "zEC12_flogr" 7
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "flogr")) "nothing")

(define_insn_reservation "zEC12_popcnt" 3
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "popcnt")) "nothing")

(define_insn_reservation "zEC12_cfdbr" 2
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "cfdbr")) "nothing")

(define_insn_reservation "zEC12_alcg" 3
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "alcg")) "nothing")

(define_insn_reservation "zEC12_mxbr" 41
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "mxbr")) "nothing")

(define_insn_reservation "zEC12_dxtr" 45
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "dxtr")) "nothing")

(define_insn_reservation "zEC12_axbr" 12
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "axbr")) "nothing")

(define_insn_reservation "zEC12_mr" 7
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "mr")) "nothing")

(define_insn_reservation "zEC12_stmg" 0
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "stmg")) "nothing")

(define_insn_reservation "zEC12_sxbr" 12
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "sxbr")) "nothing")

(define_insn_reservation "zEC12_ddb" 30
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "ddb")) "nothing")

(define_insn_reservation "zEC12_cdtr" 11
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "cdtr")) "nothing")

(define_insn_reservation "zEC12_cxtr" 14
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "cxtr")) "nothing")

(define_insn_reservation "zEC12_slbg" 3
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "slbg")) "nothing")

(define_insn_reservation "zEC12_ml" 7
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "ml")) "nothing")

(define_insn_reservation "zEC12_lam" 0
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "lam")) "nothing")

(define_insn_reservation "zEC12_lcxbr" 2
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "lcxbr")) "nothing")

(define_insn_reservation "zEC12_msfi" 6
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "msfi")) "nothing")

(define_insn_reservation "zEC12_shy" 2
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "shy")) "nothing")

(define_insn_reservation "zEC12_mh" 5
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "mh")) "nothing")

(define_insn_reservation "zEC12_fiebra" 6
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "fiebra")) "nothing")

(define_insn_reservation "zEC12_fidbra" 6
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "fidbra")) "nothing")

(define_insn_reservation "zEC12_fixbra" 10
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "fixbra")) "nothing")

(define_insn_reservation "zEC12_fidtr" 6
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "fidtr")) "nothing")

(define_insn_reservation "zEC12_fixtr" 10
  (and (eq_attr "cpu" "zEC12")
       (eq_attr "mnemonic" "fixtr")) "nothing")
