// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Access log settings, including the access log format and access log destination
// ARN.
type AccessLogSettings struct {

	// The Amazon Resource Name (ARN) of the CloudWatch Logs log group or Kinesis Data
	// Firehose delivery stream to receive access logs. If you specify a Kinesis Data
	// Firehose delivery stream, the stream name must begin with amazon-apigateway- .
	DestinationArn *string

	// A single line format of the access logs of data, as specified by selected
	// $context variables. The format must include at least $context.requestId .
	Format *string

	noSmithyDocumentSerde
}

// A resource that can be distributed to callers for executing Method resources
// that require an API key. API keys can be mapped to any Stage on any RestApi,
// which indicates that the callers with the API key can make requests to that
// stage.
type ApiKey struct {

	// The timestamp when the API Key was created.
	CreatedDate *time.Time

	// An Amazon Web Services Marketplace customer identifier, when integrating with
	// the Amazon Web Services SaaS Marketplace.
	CustomerId *string

	// The description of the API Key.
	Description *string

	// Specifies whether the API Key can be used by callers.
	Enabled bool

	// The identifier of the API Key.
	Id *string

	// The timestamp when the API Key was last updated.
	LastUpdatedDate *time.Time

	// The name of the API Key.
	Name *string

	// A list of Stage resources that are associated with the ApiKey resource.
	StageKeys []string

	// The collection of tags. Each tag element is associated with a given resource.
	Tags map[string]string

	// The value of the API Key.
	Value *string

	noSmithyDocumentSerde
}

// API stage name of the associated API stage in a usage plan.
type ApiStage struct {

	// API Id of the associated API stage in a usage plan.
	ApiId *string

	// API stage name of the associated API stage in a usage plan.
	Stage *string

	// Map containing method level throttling information for API stage in a usage
	// plan.
	Throttle map[string]ThrottleSettings

	noSmithyDocumentSerde
}

// Represents an authorization layer for methods. If enabled on a method, API
// Gateway will activate the authorizer when a client calls the method.
type Authorizer struct {

	// Optional customer-defined field, used in OpenAPI imports and exports without
	// functional impact.
	AuthType *string

	// Specifies the required credentials as an IAM role for API Gateway to invoke the
	// authorizer. To specify an IAM role for API Gateway to assume, use the role's
	// Amazon Resource Name (ARN). To use resource-based permissions on the Lambda
	// function, specify null.
	AuthorizerCredentials *string

	// The TTL in seconds of cached authorizer results. If it equals 0, authorization
	// caching is disabled. If it is greater than 0, API Gateway will cache authorizer
	// responses. If this field is not set, the default value is 300. The maximum value
	// is 3600, or 1 hour.
	AuthorizerResultTtlInSeconds *int32

	// Specifies the authorizer's Uniform Resource Identifier (URI). For TOKEN or
	// REQUEST authorizers, this must be a well-formed Lambda function URI, for
	// example,
	// arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:{account_id}:function:{lambda_function_name}/invocations
	// . In general, the URI has this form
	// arn:aws:apigateway:{region}:lambda:path/{service_api} , where {region} is the
	// same as the region hosting the Lambda function, path indicates that the
	// remaining substring in the URI should be treated as the path to the resource,
	// including the initial / . For Lambda functions, this is usually of the form
	// /2015-03-31/functions/[FunctionARN]/invocations .
	AuthorizerUri *string

	// The identifier for the authorizer resource.
	Id *string

	// The identity source for which authorization is requested. For a TOKEN or
	// COGNITO_USER_POOLS authorizer, this is required and specifies the request header
	// mapping expression for the custom header holding the authorization token
	// submitted by the client. For example, if the token header name is Auth , the
	// header mapping expression is method.request.header.Auth . For the REQUEST
	// authorizer, this is required when authorization caching is enabled. The value is
	// a comma-separated string of one or more mapping expressions of the specified
	// request parameters. For example, if an Auth header, a Name query string
	// parameter are defined as identity sources, this value is
	// method.request.header.Auth , method.request.querystring.Name . These parameters
	// will be used to derive the authorization caching key and to perform runtime
	// validation of the REQUEST authorizer by verifying all of the identity-related
	// request parameters are present, not null and non-empty. Only when this is true
	// does the authorizer invoke the authorizer Lambda function, otherwise, it returns
	// a 401 Unauthorized response without calling the Lambda function. The valid value
	// is a string of comma-separated mapping expressions of the specified request
	// parameters. When the authorization caching is not enabled, this property is
	// optional.
	IdentitySource *string

	// A validation expression for the incoming identity token. For TOKEN authorizers,
	// this value is a regular expression. For COGNITO_USER_POOLS authorizers, API
	// Gateway will match the aud field of the incoming token from the client against
	// the specified regular expression. It will invoke the authorizer's Lambda
	// function when there is a match. Otherwise, it will return a 401 Unauthorized
	// response without calling the Lambda function. The validation expression does not
	// apply to the REQUEST authorizer.
	IdentityValidationExpression *string

	// The name of the authorizer.
	Name *string

	// A list of the Amazon Cognito user pool ARNs for the COGNITO_USER_POOLS
	// authorizer. Each element is of this format:
	// arn:aws:cognito-idp:{region}:{account_id}:userpool/{user_pool_id} . For a TOKEN
	// or REQUEST authorizer, this is not defined.
	ProviderARNs []string

	// The authorizer type. Valid values are TOKEN for a Lambda function using a
	// single authorization token submitted in a custom header, REQUEST for a Lambda
	// function using incoming request parameters, and COGNITO_USER_POOLS for using an
	// Amazon Cognito user pool.
	Type AuthorizerType

	noSmithyDocumentSerde
}

// Represents the base path that callers of the API must provide as part of the
// URL after the domain name.
type BasePathMapping struct {

	// The base path name that callers of the API must provide as part of the URL
	// after the domain name.
	BasePath *string

	// The string identifier of the associated RestApi.
	RestApiId *string

	// The name of the associated stage.
	Stage *string

	noSmithyDocumentSerde
}

// Configuration settings of a canary deployment.
type CanarySettings struct {

	// The ID of the canary deployment.
	DeploymentId *string

	// The percent (0-100) of traffic diverted to a canary deployment.
	PercentTraffic float64

	// Stage variables overridden for a canary release deployment, including new stage
	// variables introduced in the canary. These stage variables are represented as a
	// string-to-string map between stage variable names and their values.
	StageVariableOverrides map[string]string

	// A Boolean flag to indicate whether the canary deployment uses the stage cache
	// or not.
	UseStageCache bool

	noSmithyDocumentSerde
}

// Represents a client certificate used to configure client-side SSL
// authentication while sending requests to the integration endpoint.
type ClientCertificate struct {

	// The identifier of the client certificate.
	ClientCertificateId *string

	// The timestamp when the client certificate was created.
	CreatedDate *time.Time

	// The description of the client certificate.
	Description *string

	// The timestamp when the client certificate will expire.
	ExpirationDate *time.Time

	// The PEM-encoded public key of the client certificate, which can be used to
	// configure certificate authentication in the integration endpoint .
	PemEncodedCertificate *string

	// The collection of tags. Each tag element is associated with a given resource.
	Tags map[string]string

	noSmithyDocumentSerde
}

// An immutable representation of a RestApi resource that can be called by users
// using Stages. A deployment must be associated with a Stage for it to be callable
// over the Internet.
type Deployment struct {

	// A summary of the RestApi at the date and time that the deployment resource was
	// created.
	ApiSummary map[string]map[string]MethodSnapshot

	// The date and time that the deployment resource was created.
	CreatedDate *time.Time

	// The description for the deployment resource.
	Description *string

	// The identifier for the deployment resource.
	Id *string

	noSmithyDocumentSerde
}

// The input configuration for a canary deployment.
type DeploymentCanarySettings struct {

	// The percentage (0.0-100.0) of traffic routed to the canary deployment.
	PercentTraffic float64

	// A stage variable overrides used for the canary release deployment. They can
	// override existing stage variables or add new stage variables for the canary
	// release deployment. These stage variables are represented as a string-to-string
	// map between stage variable names and their values.
	StageVariableOverrides map[string]string

	// A Boolean flag to indicate whether the canary release deployment uses the stage
	// cache or not.
	UseStageCache bool

	noSmithyDocumentSerde
}

// A documentation part for a targeted API entity.
type DocumentationPart struct {

	// The DocumentationPart identifier, generated by API Gateway when the
	// DocumentationPart is created.
	Id *string

	// The location of the API entity to which the documentation applies. Valid fields
	// depend on the targeted API entity type. All the valid location fields are not
	// required. If not explicitly specified, a valid location field is treated as a
	// wildcard and associated documentation content may be inherited by matching
	// entities, unless overridden.
	Location *DocumentationPartLocation

	// A content map of API-specific key-value pairs describing the targeted API
	// entity. The map must be encoded as a JSON string, e.g., "{ \"description\":
	// \"The API does ...\" }" . Only OpenAPI-compliant documentation-related fields
	// from the properties map are exported and, hence, published as part of the API
	// entity definitions, while the original documentation parts are exported in a
	// OpenAPI extension of x-amazon-apigateway-documentation .
	Properties *string

	noSmithyDocumentSerde
}

// Specifies the target API entity to which the documentation applies.
type DocumentationPartLocation struct {

	// The type of API entity to which the documentation content applies. Valid values
	// are API , AUTHORIZER , MODEL , RESOURCE , METHOD , PATH_PARAMETER ,
	// QUERY_PARAMETER , REQUEST_HEADER , REQUEST_BODY , RESPONSE , RESPONSE_HEADER ,
	// and RESPONSE_BODY . Content inheritance does not apply to any entity of the API
	// , AUTHORIZER , METHOD , MODEL , REQUEST_BODY , or RESOURCE type.
	//
	// This member is required.
	Type DocumentationPartType

	// The HTTP verb of a method. It is a valid field for the API entity types of
	// METHOD , PATH_PARAMETER , QUERY_PARAMETER , REQUEST_HEADER , REQUEST_BODY ,
	// RESPONSE , RESPONSE_HEADER , and RESPONSE_BODY . The default value is * for any
	// method. When an applicable child entity inherits the content of an entity of the
	// same type with more general specifications of the other location attributes,
	// the child entity's method attribute must match that of the parent entity
	// exactly.
	Method *string

	// The name of the targeted API entity. It is a valid and required field for the
	// API entity types of AUTHORIZER , MODEL , PATH_PARAMETER , QUERY_PARAMETER ,
	// REQUEST_HEADER , REQUEST_BODY and RESPONSE_HEADER . It is an invalid field for
	// any other entity type.
	Name *string

	// The URL path of the target. It is a valid field for the API entity types of
	// RESOURCE , METHOD , PATH_PARAMETER , QUERY_PARAMETER , REQUEST_HEADER ,
	// REQUEST_BODY , RESPONSE , RESPONSE_HEADER , and RESPONSE_BODY . The default
	// value is / for the root resource. When an applicable child entity inherits the
	// content of another entity of the same type with more general specifications of
	// the other location attributes, the child entity's path attribute must match
	// that of the parent entity as a prefix.
	Path *string

	// The HTTP status code of a response. It is a valid field for the API entity
	// types of RESPONSE , RESPONSE_HEADER , and RESPONSE_BODY . The default value is *
	// for any status code. When an applicable child entity inherits the content of an
	// entity of the same type with more general specifications of the other location
	// attributes, the child entity's statusCode attribute must match that of the
	// parent entity exactly.
	StatusCode *string

	noSmithyDocumentSerde
}

// A snapshot of the documentation of an API.
type DocumentationVersion struct {

	// The date when the API documentation snapshot is created.
	CreatedDate *time.Time

	// The description of the API documentation snapshot.
	Description *string

	// The version identifier of the API documentation snapshot.
	Version *string

	noSmithyDocumentSerde
}

// Represents a custom domain name as a user-friendly host name of an API
// (RestApi).
type DomainName struct {

	// The reference to an Amazon Web Services-managed certificate that will be used
	// by edge-optimized endpoint for this domain name. Certificate Manager is the only
	// supported source.
	CertificateArn *string

	// The name of the certificate that will be used by edge-optimized endpoint for
	// this domain name.
	CertificateName *string

	// The timestamp when the certificate that was used by edge-optimized endpoint for
	// this domain name was uploaded.
	CertificateUploadDate *time.Time

	// The domain name of the Amazon CloudFront distribution associated with this
	// custom domain name for an edge-optimized endpoint. You set up this association
	// when adding a DNS record pointing the custom domain name to this distribution
	// name. For more information about CloudFront distributions, see the Amazon
	// CloudFront documentation.
	DistributionDomainName *string

	// The region-agnostic Amazon Route 53 Hosted Zone ID of the edge-optimized
	// endpoint. The valid value is Z2FDTNDATAQYW2 for all the regions. For more
	// information, see Set up a Regional Custom Domain Name and AWS Regions and
	// Endpoints for API Gateway.
	DistributionHostedZoneId *string

	// The custom domain name as an API host name, for example, my-api.example.com .
	DomainName *string

	// The status of the DomainName migration. The valid values are AVAILABLE and
	// UPDATING . If the status is UPDATING , the domain cannot be modified further
	// until the existing operation is complete. If it is AVAILABLE , the domain can be
	// updated.
	DomainNameStatus DomainNameStatus

	// An optional text message containing detailed information about status of the
	// DomainName migration.
	DomainNameStatusMessage *string

	// The endpoint configuration of this DomainName showing the endpoint types of the
	// domain name.
	EndpointConfiguration *EndpointConfiguration

	// The mutual TLS authentication configuration for a custom domain name. If
	// specified, API Gateway performs two-way authentication between the client and
	// the server. Clients must present a trusted certificate to access your API.
	MutualTlsAuthentication *MutualTlsAuthentication

	// The ARN of the public certificate issued by ACM to validate ownership of your
	// custom domain. Only required when configuring mutual TLS and using an ACM
	// imported or private CA certificate ARN as the regionalCertificateArn.
	OwnershipVerificationCertificateArn *string

	// The reference to an Amazon Web Services-managed certificate that will be used
	// for validating the regional domain name. Certificate Manager is the only
	// supported source.
	RegionalCertificateArn *string

	// The name of the certificate that will be used for validating the regional
	// domain name.
	RegionalCertificateName *string

	// The domain name associated with the regional endpoint for this custom domain
	// name. You set up this association by adding a DNS record that points the custom
	// domain name to this regional domain name. The regional domain name is returned
	// by API Gateway when you create a regional endpoint.
	RegionalDomainName *string

	// The region-specific Amazon Route 53 Hosted Zone ID of the regional endpoint.
	// For more information, see Set up a Regional Custom Domain Name and AWS Regions
	// and Endpoints for API Gateway.
	RegionalHostedZoneId *string

	// The Transport Layer Security (TLS) version + cipher suite for this DomainName.
	// The valid values are TLS_1_0 and TLS_1_2 .
	SecurityPolicy SecurityPolicy

	// The collection of tags. Each tag element is associated with a given resource.
	Tags map[string]string

	noSmithyDocumentSerde
}

// The endpoint configuration to indicate the types of endpoints an API (RestApi)
// or its custom domain name (DomainName) has.
type EndpointConfiguration struct {

	// A list of endpoint types of an API (RestApi) or its custom domain name
	// (DomainName). For an edge-optimized API and its custom domain name, the endpoint
	// type is "EDGE" . For a regional API and its custom domain name, the endpoint
	// type is REGIONAL . For a private API, the endpoint type is PRIVATE .
	Types []EndpointType

	// A list of VpcEndpointIds of an API (RestApi) against which to create Route53
	// ALIASes. It is only supported for PRIVATE endpoint type.
	VpcEndpointIds []string

	noSmithyDocumentSerde
}

// A gateway response of a given response type and status code, with optional
// response parameters and mapping templates.
type GatewayResponse struct {

	// A Boolean flag to indicate whether this GatewayResponse is the default gateway
	// response ( true ) or not ( false ). A default gateway response is one generated
	// by API Gateway without any customization by an API developer.
	DefaultResponse bool

	// Response parameters (paths, query strings and headers) of the GatewayResponse
	// as a string-to-string map of key-value pairs.
	ResponseParameters map[string]string

	// Response templates of the GatewayResponse as a string-to-string map of
	// key-value pairs.
	ResponseTemplates map[string]string

	// The response type of the associated GatewayResponse.
	ResponseType GatewayResponseType

	// The HTTP status code for this GatewayResponse.
	StatusCode *string

	noSmithyDocumentSerde
}

// Represents an HTTP , HTTP_PROXY , AWS , AWS_PROXY , or Mock integration.
type Integration struct {

	// A list of request parameters whose values API Gateway caches. To be valid
	// values for cacheKeyParameters , these parameters must also be specified for
	// Method requestParameters .
	CacheKeyParameters []string

	// Specifies a group of related cached parameters. By default, API Gateway uses
	// the resource ID as the cacheNamespace . You can specify the same cacheNamespace
	// across resources to return the same cached data for requests to different
	// resources.
	CacheNamespace *string

	// The ID of the VpcLink used for the integration when connectionType=VPC_LINK and
	// undefined, otherwise.
	ConnectionId *string

	// The type of the network connection to the integration endpoint. The valid value
	// is INTERNET for connections through the public routable internet or VPC_LINK
	// for private connections between API Gateway and a network load balancer in a
	// VPC. The default value is INTERNET .
	ConnectionType ConnectionType

	// Specifies how to handle request payload content type conversions. Supported
	// values are CONVERT_TO_BINARY and CONVERT_TO_TEXT , with the following behaviors:
	//
	// If this property is not defined, the request payload will be passed through
	// from the method request to integration request without modification, provided
	// that the passthroughBehavior is configured to support payload pass-through.
	ContentHandling ContentHandlingStrategy

	// Specifies the credentials required for the integration, if any. For AWS
	// integrations, three options are available. To specify an IAM Role for API
	// Gateway to assume, use the role's Amazon Resource Name (ARN). To require that
	// the caller's identity be passed through from the request, specify the string
	// arn:aws:iam::\*:user/\* . To use resource-based permissions on supported Amazon
	// Web Services services, specify null.
	Credentials *string

	// Specifies the integration's HTTP method type. For the Type property, if you
	// specify MOCK , this property is optional. For Lambda integrations, you must set
	// the integration method to POST . For all other types, you must specify this
	// property.
	HttpMethod *string

	// Specifies the integration's responses.
	IntegrationResponses map[string]IntegrationResponse

	// Specifies how the method request body of an unmapped content type will be
	// passed through the integration request to the back end without transformation. A
	// content type is unmapped if no mapping template is defined in the integration or
	// the content type does not match any of the mapped content types, as specified in
	// requestTemplates . The valid value is one of the following: WHEN_NO_MATCH :
	// passes the method request body through the integration request to the back end
	// without transformation when the method request content type does not match any
	// content type associated with the mapping templates defined in the integration
	// request. WHEN_NO_TEMPLATES : passes the method request body through the
	// integration request to the back end without transformation when no mapping
	// template is defined in the integration request. If a template is defined when
	// this option is selected, the method request of an unmapped content-type will be
	// rejected with an HTTP 415 Unsupported Media Type response. NEVER : rejects the
	// method request with an HTTP 415 Unsupported Media Type response when either the
	// method request content type does not match any content type associated with the
	// mapping templates defined in the integration request or no mapping template is
	// defined in the integration request.
	PassthroughBehavior *string

	// A key-value map specifying request parameters that are passed from the method
	// request to the back end. The key is an integration request parameter name and
	// the associated value is a method request parameter value or static value that
	// must be enclosed within single quotes and pre-encoded as required by the back
	// end. The method request parameter value must match the pattern of
	// method.request.{location}.{name} , where location is querystring , path , or
	// header and name must be a valid and unique method request parameter name.
	RequestParameters map[string]string

	// Represents a map of Velocity templates that are applied on the request payload
	// based on the value of the Content-Type header sent by the client. The content
	// type value is the key in this map, and the template (as a String) is the value.
	RequestTemplates map[string]string

	// Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000
	// milliseconds or 29 seconds.
	TimeoutInMillis int32

	// Specifies the TLS configuration for an integration.
	TlsConfig *TlsConfig

	// Specifies an API method integration type. The valid value is one of the
	// following:
	//
	// For the HTTP and HTTP proxy integrations, each integration can specify a
	// protocol ( http/https ), port and path. Standard 80 and 443 ports are supported
	// as well as custom ports above 1024. An HTTP or HTTP proxy integration with a
	// connectionType of VPC_LINK is referred to as a private integration and uses a
	// VpcLink to connect API Gateway to a network load balancer of a VPC.
	Type IntegrationType

	// Specifies Uniform Resource Identifier (URI) of the integration endpoint.
	//
	// For HTTP or HTTP_PROXY integrations, the URI must be a fully formed, encoded
	// HTTP(S) URL according to the RFC-3986 specification for standard integrations.
	// If connectionType is VPC_LINK specify the Network Load Balancer DNS name. For
	// AWS or AWS_PROXY integrations, the URI is of the form
	// arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}
	// . Here, {Region} is the API Gateway region (e.g., us-east-1); {service} is the
	// name of the integrated Amazon Web Services service (e.g., s3); and {subdomain}
	// is a designated subdomain supported by certain Amazon Web Services service for
	// fast host-name lookup. action can be used for an Amazon Web Services service
	// action-based API, using an Action={name}&{p1}={v1}&p2={v2}... query string. The
	// ensuing {service_api} refers to a supported action {name} plus any required
	// input parameters. Alternatively, path can be used for an Amazon Web Services
	// service path-based API. The ensuing service_api refers to the path to an Amazon
	// Web Services service resource, including the region of the integrated Amazon Web
	// Services service, if applicable. For example, for integration with the S3 API of
	// GetObject, the uri can be either
	// arn:aws:apigateway:us-west-2:s3:action/GetObject&Bucket={bucket}&Key={key} or
	// arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}
	Uri *string

	noSmithyDocumentSerde
}

// Represents an integration response. The status code must map to an existing
// MethodResponse, and parameters and templates can be used to transform the
// back-end response.
type IntegrationResponse struct {

	// Specifies how to handle response payload content type conversions. Supported
	// values are CONVERT_TO_BINARY and CONVERT_TO_TEXT , with the following behaviors:
	//
	// If this property is not defined, the response payload will be passed through
	// from the integration response to the method response without modification.
	ContentHandling ContentHandlingStrategy

	// A key-value map specifying response parameters that are passed to the method
	// response from the back end. The key is a method response header parameter name
	// and the mapped value is an integration response header value, a static value
	// enclosed within a pair of single quotes, or a JSON expression from the
	// integration response body. The mapping key must match the pattern of
	// method.response.header.{name} , where name is a valid and unique header name.
	// The mapped non-static value must match the pattern of
	// integration.response.header.{name} or
	// integration.response.body.{JSON-expression} , where name is a valid and unique
	// response header name and JSON-expression is a valid JSON expression without the
	// $ prefix.
	ResponseParameters map[string]string

	// Specifies the templates used to transform the integration response body.
	// Response templates are represented as a key/value map, with a content-type as
	// the key and a template as the value.
	ResponseTemplates map[string]string

	// Specifies the regular expression (regex) pattern used to choose an integration
	// response based on the response from the back end. For example, if the success
	// response returns nothing and the error response returns some string, you could
	// use the .+ regex to match error response. However, make sure that the error
	// response does not contain any newline ( \n ) character in such cases. If the
	// back end is an Lambda function, the Lambda function error header is matched. For
	// all other HTTP and Amazon Web Services back ends, the HTTP status code is
	// matched.
	SelectionPattern *string

	// Specifies the status code that is used to map the integration response to an
	// existing MethodResponse.
	StatusCode *string

	noSmithyDocumentSerde
}

//	Represents a client-facing interface by which the client calls the API to
//
// access back-end resources. A Method resource is integrated with an Integration
// resource. Both consist of a request and one or more responses. The method
// request takes the client input that is passed to the back end through the
// integration request. A method response returns the output from the back end to
// the client through an integration response. A method request is embodied in a
// Method resource, whereas an integration request is embodied in an Integration
// resource. On the other hand, a method response is represented by a
// MethodResponse resource, whereas an integration response is represented by an
// IntegrationResponse resource.
type Method struct {

	// A boolean flag specifying whether a valid ApiKey is required to invoke this
	// method.
	ApiKeyRequired *bool

	// A list of authorization scopes configured on the method. The scopes are used
	// with a COGNITO_USER_POOLS authorizer to authorize the method invocation. The
	// authorization works by matching the method scopes against the scopes parsed from
	// the access token in the incoming request. The method invocation is authorized if
	// any method scopes matches a claimed scope in the access token. Otherwise, the
	// invocation is not authorized. When the method scope is configured, the client
	// must provide an access token instead of an identity token for authorization
	// purposes.
	AuthorizationScopes []string

	// The method's authorization type. Valid values are NONE for open access, AWS_IAM
	// for using AWS IAM permissions, CUSTOM for using a custom authorizer, or
	// COGNITO_USER_POOLS for using a Cognito user pool.
	AuthorizationType *string

	// The identifier of an Authorizer to use on this method. The authorizationType
	// must be CUSTOM .
	AuthorizerId *string

	// The method's HTTP verb.
	HttpMethod *string

	// Gets the method's integration responsible for passing the client-submitted
	// request to the back end and performing necessary transformations to make the
	// request compliant with the back end.
	MethodIntegration *Integration

	// Gets a method response associated with a given HTTP status code.
	MethodResponses map[string]MethodResponse

	// A human-friendly operation identifier for the method. For example, you can
	// assign the operationName of ListPets for the GET /pets method in the PetStore
	// example.
	OperationName *string

	// A key-value map specifying data schemas, represented by Model resources, (as
	// the mapped value) of the request payloads of given content types (as the mapping
	// key).
	RequestModels map[string]string

	// A key-value map defining required or optional method request parameters that
	// can be accepted by API Gateway. A key is a method request parameter name
	// matching the pattern of method.request.{location}.{name} , where location is
	// querystring , path , or header and name is a valid and unique parameter name.
	// The value associated with the key is a Boolean flag indicating whether the
	// parameter is required ( true ) or optional ( false ). The method request
	// parameter names defined here are available in Integration to be mapped to
	// integration request parameters or templates.
	RequestParameters map[string]bool

	// The identifier of a RequestValidator for request validation.
	RequestValidatorId *string

	noSmithyDocumentSerde
}

// Represents a method response of a given HTTP status code returned to the
// client. The method response is passed from the back end through the associated
// integration response that can be transformed using a mapping template.
type MethodResponse struct {

	// Specifies the Model resources used for the response's content-type. Response
	// models are represented as a key/value map, with a content-type as the key and a
	// Model name as the value.
	ResponseModels map[string]string

	// A key-value map specifying required or optional response parameters that API
	// Gateway can send back to the caller. A key defines a method response header and
	// the value specifies whether the associated method response header is required or
	// not. The expression of the key must match the pattern
	// method.response.header.{name} , where name is a valid and unique header name.
	// API Gateway passes certain integration response data to the method response
	// headers specified here according to the mapping you prescribe in the API's
	// IntegrationResponse. The integration response data that can be mapped include an
	// integration response header expressed in integration.response.header.{name} , a
	// static value enclosed within a pair of single quotes (e.g., 'application/json'
	// ), or a JSON expression from the back-end response payload in the form of
	// integration.response.body.{JSON-expression} , where JSON-expression is a valid
	// JSON expression without the $ prefix.)
	ResponseParameters map[string]bool

	// The method response's status code.
	StatusCode *string

	noSmithyDocumentSerde
}

// Specifies the method setting properties.
type MethodSetting struct {

	// Specifies whether the cached responses are encrypted.
	CacheDataEncrypted bool

	// Specifies the time to live (TTL), in seconds, for cached responses. The higher
	// the TTL, the longer the response will be cached.
	CacheTtlInSeconds int32

	// Specifies whether responses should be cached and returned for requests. A cache
	// cluster must be enabled on the stage for responses to be cached.
	CachingEnabled bool

	// Specifies whether data trace logging is enabled for this method, which affects
	// the log entries pushed to Amazon CloudWatch Logs. This can be useful to
	// troubleshoot APIs, but can result in logging sensitive data. We recommend that
	// you don't enable this option for production APIs.
	DataTraceEnabled bool

	// Specifies the logging level for this method, which affects the log entries
	// pushed to Amazon CloudWatch Logs. Valid values are OFF , ERROR , and INFO .
	// Choose ERROR to write only error-level entries to CloudWatch Logs, or choose
	// INFO to include all ERROR events as well as extra informational events.
	LoggingLevel *string

	// Specifies whether Amazon CloudWatch metrics are enabled for this method.
	MetricsEnabled bool

	// Specifies whether authorization is required for a cache invalidation request.
	RequireAuthorizationForCacheControl bool

	// Specifies the throttling burst limit.
	ThrottlingBurstLimit int32

	// Specifies the throttling rate limit.
	ThrottlingRateLimit float64

	// Specifies how to handle unauthorized requests for cache invalidation.
	UnauthorizedCacheControlHeaderStrategy UnauthorizedCacheControlHeaderStrategy

	noSmithyDocumentSerde
}

// Represents a summary of a Method resource, given a particular date and time.
type MethodSnapshot struct {

	// Specifies whether the method requires a valid ApiKey.
	ApiKeyRequired bool

	// The method's authorization type. Valid values are NONE for open access, AWS_IAM
	// for using AWS IAM permissions, CUSTOM for using a custom authorizer, or
	// COGNITO_USER_POOLS for using a Cognito user pool.
	AuthorizationType *string

	noSmithyDocumentSerde
}

// Represents the data structure of a method's request or response payload.
type Model struct {

	// The content-type for the model.
	ContentType *string

	// The description of the model.
	Description *string

	// The identifier for the model resource.
	Id *string

	// The name of the model. Must be an alphanumeric string.
	Name *string

	// The schema for the model. For application/json models, this should be JSON
	// schema draft 4 model. Do not include "\*/" characters in the description of any
	// properties because such "\*/" characters may be interpreted as the closing
	// marker for comments in some languages, such as Java or JavaScript, causing the
	// installation of your API's SDK generated by API Gateway to fail.
	Schema *string

	noSmithyDocumentSerde
}

// The mutual TLS authentication configuration for a custom domain name. If
// specified, API Gateway performs two-way authentication between the client and
// the server. Clients must present a trusted certificate to access your API.
type MutualTlsAuthentication struct {

	// An Amazon S3 URL that specifies the truststore for mutual TLS authentication,
	// for example s3://bucket-name/key-name . The truststore can contain certificates
	// from public or private certificate authorities. To update the truststore, upload
	// a new version to S3, and then update your custom domain name to use the new
	// version. To update the truststore, you must have permissions to access the S3
	// object.
	TruststoreUri *string

	// The version of the S3 object that contains your truststore. To specify a
	// version, you must have versioning enabled for the S3 bucket.
	TruststoreVersion *string

	// A list of warnings that API Gateway returns while processing your truststore.
	// Invalid certificates produce warnings. Mutual TLS is still enabled, but some
	// clients might not be able to access your API. To resolve warnings, upload a new
	// truststore to S3, and then update you domain name to use the new version.
	TruststoreWarnings []string

	noSmithyDocumentSerde
}

// The mutual TLS authentication configuration for a custom domain name. If
// specified, API Gateway performs two-way authentication between the client and
// the server. Clients must present a trusted certificate to access your API.
type MutualTlsAuthenticationInput struct {

	// An Amazon S3 URL that specifies the truststore for mutual TLS authentication,
	// for example s3://bucket-name/key-name . The truststore can contain certificates
	// from public or private certificate authorities. To update the truststore, upload
	// a new version to S3, and then update your custom domain name to use the new
	// version. To update the truststore, you must have permissions to access the S3
	// object.
	TruststoreUri *string

	// The version of the S3 object that contains your truststore. To specify a
	// version, you must have versioning enabled for the S3 bucket
	TruststoreVersion *string

	noSmithyDocumentSerde
}

// For more information about supported patch operations, see [Patch Operations].
//
// [Patch Operations]: https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html
type PatchOperation struct {

	// The copy update operation's source as identified by a JSON-Pointer value
	// referencing the location within the targeted resource to copy the value from.
	// For example, to promote a canary deployment, you copy the canary deployment ID
	// to the affiliated deployment ID by calling a PATCH request on a Stage resource
	// with "op":"copy", "from":"/canarySettings/deploymentId" and
	// "path":"/deploymentId".
	From *string

	// An update operation to be performed with this PATCH request. The valid value
	// can be add, remove, replace or copy. Not all valid operations are supported for
	// a given resource. Support of the operations depends on specific operational
	// contexts. Attempts to apply an unsupported operation on a resource will return
	// an error message..
	Op Op

	// The op operation's target, as identified by a JSON Pointer value that
	// references a location within the targeted resource. For example, if the target
	// resource has an updateable property of {"name":"value"}, the path for this
	// property is /name. If the name property value is a JSON object (e.g., {"name":
	// {"child/name": "child-value"}}), the path for the child/name property will be
	// /name/child~1name. Any slash ("/") character appearing in path names must be
	// escaped with "~1", as shown in the example above. Each op operation can have
	// only one path associated with it.
	Path *string

	// The new target value of the update operation. It is applicable for the add or
	// replace operation. When using AWS CLI to update a property of a JSON value,
	// enclose the JSON object with a pair of single quotes in a Linux shell, e.g.,
	// '{"a": ...}'.
	Value *string

	noSmithyDocumentSerde
}

// Quotas configured for a usage plan.
type QuotaSettings struct {

	// The target maximum number of requests that can be made in a given time period.
	Limit int32

	// The number of requests subtracted from the given limit in the initial time
	// period.
	Offset int32

	// The time period in which the limit applies. Valid values are "DAY", "WEEK" or
	// "MONTH".
	Period QuotaPeriodType

	noSmithyDocumentSerde
}

// A set of validation rules for incoming Method requests.
type RequestValidator struct {

	// The identifier of this RequestValidator.
	Id *string

	// The name of this RequestValidator
	Name *string

	// A Boolean flag to indicate whether to validate a request body according to the
	// configured Model schema.
	ValidateRequestBody bool

	// A Boolean flag to indicate whether to validate request parameters ( true ) or
	// not ( false ).
	ValidateRequestParameters bool

	noSmithyDocumentSerde
}

// Represents an API resource.
type Resource struct {

	// The resource's identifier.
	Id *string

	// The parent resource's identifier.
	ParentId *string

	// The full path for this resource.
	Path *string

	// The last path segment for this resource.
	PathPart *string

	// Gets an API resource's method of a given HTTP verb.
	ResourceMethods map[string]Method

	noSmithyDocumentSerde
}

// Represents a REST API.
type RestApi struct {

	// The source of the API key for metering requests according to a usage plan.
	// Valid values are: > HEADER to read the API key from the X-API-Key header of a
	// request. AUTHORIZER to read the API key from the UsageIdentifierKey from a
	// custom authorizer.
	ApiKeySource ApiKeySourceType

	// The list of binary media types supported by the RestApi. By default, the
	// RestApi supports only UTF-8-encoded text payloads.
	BinaryMediaTypes []string

	// The timestamp when the API was created.
	CreatedDate *time.Time

	// The API's description.
	Description *string

	// Specifies whether clients can invoke your API by using the default execute-api
	// endpoint. By default, clients can invoke your API with the default
	// https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that
	// clients use a custom domain name to invoke your API, disable the default
	// endpoint.
	DisableExecuteApiEndpoint bool

	// The endpoint configuration of this RestApi showing the endpoint types of the
	// API.
	EndpointConfiguration *EndpointConfiguration

	// The API's identifier. This identifier is unique across all of your APIs in API
	// Gateway.
	Id *string

	// A nullable integer that is used to enable compression (with non-negative
	// between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a
	// null value) on an API. When compression is enabled, compression or decompression
	// is not applied on the payload if the payload size is smaller than this value.
	// Setting it to zero allows compression for any payload size.
	MinimumCompressionSize *int32

	// The API's name.
	Name *string

	// A stringified JSON policy document that applies to this RestApi regardless of
	// the caller and Method configuration.
	Policy *string

	// The API's root resource ID.
	RootResourceId *string

	// The collection of tags. Each tag element is associated with a given resource.
	Tags map[string]string

	// A version identifier for the API.
	Version *string

	// The warning messages reported when failonwarnings is turned on during API
	// import.
	Warnings []string

	noSmithyDocumentSerde
}

// A configuration property of an SDK type.
type SdkConfigurationProperty struct {

	// The default value of an SdkType configuration property.
	DefaultValue *string

	// The description of an SdkType configuration property.
	Description *string

	// The user-friendly name of an SdkType configuration property.
	FriendlyName *string

	// The name of a an SdkType configuration property.
	Name *string

	// A boolean flag of an SdkType configuration property to indicate if the
	// associated SDK configuration property is required ( true ) or not ( false ).
	Required bool

	noSmithyDocumentSerde
}

// A type of SDK that API Gateway can generate.
type SdkType struct {

	// A list of configuration properties of an SdkType.
	ConfigurationProperties []SdkConfigurationProperty

	// The description of an SdkType.
	Description *string

	// The user-friendly name of an SdkType instance.
	FriendlyName *string

	// The identifier of an SdkType instance.
	Id *string

	noSmithyDocumentSerde
}

// Represents a unique identifier for a version of a deployed RestApi that is
// callable by users.
type Stage struct {

	// Settings for logging access in this stage.
	AccessLogSettings *AccessLogSettings

	// Specifies whether a cache cluster is enabled for the stage. To activate a
	// method-level cache, set CachingEnabled to true for a method.
	CacheClusterEnabled bool

	// The stage's cache capacity in GB. For more information about choosing a cache
	// size, see [Enabling API caching to enhance responsiveness].
	//
	// [Enabling API caching to enhance responsiveness]: https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-caching.html
	CacheClusterSize CacheClusterSize

	// The status of the cache cluster for the stage, if enabled.
	CacheClusterStatus CacheClusterStatus

	// Settings for the canary deployment in this stage.
	CanarySettings *CanarySettings

	// The identifier of a client certificate for an API stage.
	ClientCertificateId *string

	// The timestamp when the stage was created.
	CreatedDate *time.Time

	// The identifier of the Deployment that the stage points to.
	DeploymentId *string

	// The stage's description.
	Description *string

	// The version of the associated API documentation.
	DocumentationVersion *string

	// The timestamp when the stage last updated.
	LastUpdatedDate *time.Time

	// A map that defines the method settings for a Stage resource. Keys (designated
	// as /{method_setting_key below) are method paths defined as
	// {resource_path}/{http_method} for an individual method override, or /\*/\* for
	// overriding all methods in the stage.
	MethodSettings map[string]MethodSetting

	// The name of the stage is the first path segment in the Uniform Resource
	// Identifier (URI) of a call to API Gateway. Stage names can only contain
	// alphanumeric characters, hyphens, and underscores. Maximum length is 128
	// characters.
	StageName *string

	// The collection of tags. Each tag element is associated with a given resource.
	Tags map[string]string

	// Specifies whether active tracing with X-ray is enabled for the Stage.
	TracingEnabled bool

	// A map that defines the stage variables for a Stage resource. Variable names can
	// have alphanumeric and underscore characters, and the values must match
	// [A-Za-z0-9-._~:/?#&=,]+ .
	Variables map[string]string

	// The ARN of the WebAcl associated with the Stage.
	WebAclArn *string

	noSmithyDocumentSerde
}

// A reference to a unique stage identified in the format {restApiId}/{stage} .
type StageKey struct {

	// The string identifier of the associated RestApi.
	RestApiId *string

	// The stage name associated with the stage key.
	StageName *string

	noSmithyDocumentSerde
}

// The API request rate limits.
type ThrottleSettings struct {

	// The API target request burst rate limit. This allows more requests through for
	// a period of time than the target rate limit.
	BurstLimit int32

	// The API target request rate limit.
	RateLimit float64

	noSmithyDocumentSerde
}

// Specifies the TLS configuration for an integration.
type TlsConfig struct {

	// Specifies whether or not API Gateway skips verification that the certificate
	// for an integration endpoint is issued by a supported certificate authority. This
	// isn’t recommended, but it enables you to use certificates that are signed by
	// private certificate authorities, or certificates that are self-signed. If
	// enabled, API Gateway still performs basic certificate validation, which includes
	// checking the certificate's expiration date, hostname, and presence of a root
	// certificate authority. Supported only for HTTP and HTTP_PROXY integrations.
	//
	// Enabling insecureSkipVerification isn't recommended, especially for
	// integrations with public HTTPS endpoints. If you enable insecureSkipVerification
	// , you increase the risk of man-in-the-middle attacks.
	InsecureSkipVerification bool

	noSmithyDocumentSerde
}

// Represents a usage plan used to specify who can assess associated API stages.
// Optionally, target request rate and quota limits can be set. In some cases
// clients can exceed the targets that you set. Don’t rely on usage plans to
// control costs. Consider using [Amazon Web Services Budgets]to monitor costs and [WAF] to manage API requests.
//
// [Amazon Web Services Budgets]: https://docs.aws.amazon.com/cost-management/latest/userguide/budgets-managing-costs.html
// [WAF]: https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html
type UsagePlan struct {

	// The associated API stages of a usage plan.
	ApiStages []ApiStage

	// The description of a usage plan.
	Description *string

	// The identifier of a UsagePlan resource.
	Id *string

	// The name of a usage plan.
	Name *string

	// The Amazon Web Services Marketplace product identifier to associate with the
	// usage plan as a SaaS product on the Amazon Web Services Marketplace.
	ProductCode *string

	// The target maximum number of permitted requests per a given unit time interval.
	Quota *QuotaSettings

	// The collection of tags. Each tag element is associated with a given resource.
	Tags map[string]string

	// A map containing method level throttling information for API stage in a usage
	// plan.
	Throttle *ThrottleSettings

	noSmithyDocumentSerde
}

// Represents a usage plan key to identify a plan customer.
type UsagePlanKey struct {

	// The Id of a usage plan key.
	Id *string

	// The name of a usage plan key.
	Name *string

	// The type of a usage plan key. Currently, the valid key type is API_KEY .
	Type *string

	// The value of a usage plan key.
	Value *string

	noSmithyDocumentSerde
}

// An API Gateway VPC link for a RestApi to access resources in an Amazon Virtual
// Private Cloud (VPC).
type VpcLink struct {

	// The description of the VPC link.
	Description *string

	// The identifier of the VpcLink. It is used in an Integration to reference this
	// VpcLink.
	Id *string

	// The name used to label and identify the VPC link.
	Name *string

	// The status of the VPC link. The valid values are AVAILABLE , PENDING , DELETING
	// , or FAILED . Deploying an API will wait if the status is PENDING and will fail
	// if the status is DELETING .
	Status VpcLinkStatus

	// A description about the VPC link status.
	StatusMessage *string

	// The collection of tags. Each tag element is associated with a given resource.
	Tags map[string]string

	// The ARN of the network load balancer of the VPC targeted by the VPC link. The
	// network load balancer must be owned by the same Amazon Web Services account of
	// the API owner.
	TargetArns []string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
