// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Specifies the minimum and maximum for the AcceleratorCount object when you
// specify InstanceRequirementsfor an Auto Scaling group.
type AcceleratorCountRequest struct {

	// The maximum value.
	Max *int32

	// The minimum value.
	Min *int32

	noSmithyDocumentSerde
}

// Specifies the minimum and maximum for the AcceleratorTotalMemoryMiB object when
// you specify InstanceRequirementsfor an Auto Scaling group.
type AcceleratorTotalMemoryMiBRequest struct {

	// The memory maximum in MiB.
	Max *int32

	// The memory minimum in MiB.
	Min *int32

	noSmithyDocumentSerde
}

// Describes scaling activity, which is a long-running process that represents a
// change to your Auto Scaling group, such as changing its size or replacing an
// instance.
type Activity struct {

	// The ID of the activity.
	//
	// This member is required.
	ActivityId *string

	// The name of the Auto Scaling group.
	//
	// This member is required.
	AutoScalingGroupName *string

	// The reason the activity began.
	//
	// This member is required.
	Cause *string

	// The start time of the activity.
	//
	// This member is required.
	StartTime *time.Time

	// The current status of the activity.
	//
	// This member is required.
	StatusCode ScalingActivityStatusCode

	// The Amazon Resource Name (ARN) of the Auto Scaling group.
	AutoScalingGroupARN *string

	// The state of the Auto Scaling group, which is either InService or Deleted .
	AutoScalingGroupState *string

	// A friendly, more verbose description of the activity.
	Description *string

	// The details about the activity.
	Details *string

	// The end time of the activity.
	EndTime *time.Time

	// A value between 0 and 100 that indicates the progress of the activity.
	Progress *int32

	// A friendly, more verbose description of the activity status.
	StatusMessage *string

	noSmithyDocumentSerde
}

// Describes a policy adjustment type.
type AdjustmentType struct {

	// The policy adjustment type. The valid values are ChangeInCapacity ,
	// ExactCapacity , and PercentChangeInCapacity .
	AdjustmentType *string

	noSmithyDocumentSerde
}

// Describes an alarm.
type Alarm struct {

	// The Amazon Resource Name (ARN) of the alarm.
	AlarmARN *string

	// The name of the alarm.
	AlarmName *string

	noSmithyDocumentSerde
}

// Specifies the CloudWatch alarm specification to use in an instance refresh.
type AlarmSpecification struct {

	// The names of one or more CloudWatch alarms to monitor for the instance refresh.
	// You can specify up to 10 alarms.
	Alarms []string

	noSmithyDocumentSerde
}

// Describes an Auto Scaling group.
type AutoScalingGroup struct {

	// The name of the Auto Scaling group.
	//
	// This member is required.
	AutoScalingGroupName *string

	// One or more Availability Zones for the group.
	//
	// This member is required.
	AvailabilityZones []string

	// The date and time the group was created.
	//
	// This member is required.
	CreatedTime *time.Time

	// The duration of the default cooldown period, in seconds.
	//
	// This member is required.
	DefaultCooldown *int32

	// The desired size of the group.
	//
	// This member is required.
	DesiredCapacity *int32

	// A comma-separated value string of one or more health check types.
	//
	// This member is required.
	HealthCheckType *string

	// The maximum size of the group.
	//
	// This member is required.
	MaxSize *int32

	// The minimum size of the group.
	//
	// This member is required.
	MinSize *int32

	// The Amazon Resource Name (ARN) of the Auto Scaling group.
	AutoScalingGroupARN *string

	// Indicates whether Capacity Rebalancing is enabled.
	CapacityRebalance *bool

	// Reserved.
	Context *string

	// The duration of the default instance warmup, in seconds.
	DefaultInstanceWarmup *int32

	// The unit of measurement for the value specified for desired capacity. Amazon
	// EC2 Auto Scaling supports DesiredCapacityType for attribute-based instance type
	// selection only.
	DesiredCapacityType *string

	// The metrics enabled for the group.
	EnabledMetrics []EnabledMetric

	// The duration of the health check grace period, in seconds.
	HealthCheckGracePeriod *int32

	// An instance maintenance policy.
	InstanceMaintenancePolicy *InstanceMaintenancePolicy

	// The EC2 instances associated with the group.
	Instances []Instance

	// The name of the associated launch configuration.
	LaunchConfigurationName *string

	// The launch template for the group.
	LaunchTemplate *LaunchTemplateSpecification

	// One or more load balancers associated with the group.
	LoadBalancerNames []string

	// The maximum amount of time, in seconds, that an instance can be in service.
	//
	// Valid Range: Minimum value of 0.
	MaxInstanceLifetime *int32

	// The mixed instances policy for the group.
	MixedInstancesPolicy *MixedInstancesPolicy

	// Indicates whether newly launched instances are protected from termination by
	// Amazon EC2 Auto Scaling when scaling in.
	NewInstancesProtectedFromScaleIn *bool

	// The name of the placement group into which to launch your instances, if any.
	PlacementGroup *string

	// The predicted capacity of the group when it has a predictive scaling policy.
	PredictedCapacity *int32

	// The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling
	// group uses to call other Amazon Web Services on your behalf.
	ServiceLinkedRoleARN *string

	// The current state of the group when the DeleteAutoScalingGroup operation is in progress.
	Status *string

	// The suspended processes associated with the group.
	SuspendedProcesses []SuspendedProcess

	// The tags for the group.
	Tags []TagDescription

	// The Amazon Resource Names (ARN) of the target groups for your load balancer.
	TargetGroupARNs []string

	// The termination policies for the group.
	TerminationPolicies []string

	// The traffic sources associated with this Auto Scaling group.
	TrafficSources []TrafficSourceIdentifier

	// One or more subnet IDs, if applicable, separated by commas.
	VPCZoneIdentifier *string

	// The warm pool for the group.
	WarmPoolConfiguration *WarmPoolConfiguration

	// The current size of the warm pool.
	WarmPoolSize *int32

	noSmithyDocumentSerde
}

// Describes an EC2 instance associated with an Auto Scaling group.
type AutoScalingInstanceDetails struct {

	// The name of the Auto Scaling group for the instance.
	//
	// This member is required.
	AutoScalingGroupName *string

	// The Availability Zone for the instance.
	//
	// This member is required.
	AvailabilityZone *string

	// The last reported health status of this instance. Healthy means that the
	// instance is healthy and should remain in service. Unhealthy means that the
	// instance is unhealthy and Amazon EC2 Auto Scaling should terminate and replace
	// it.
	//
	// This member is required.
	HealthStatus *string

	// The ID of the instance.
	//
	// This member is required.
	InstanceId *string

	// The lifecycle state for the instance. The Quarantined state is not used. For
	// information about lifecycle states, see [Instance lifecycle]in the Amazon EC2 Auto Scaling User
	// Guide.
	//
	// Valid values: Pending | Pending:Wait | Pending:Proceed | Quarantined | InService
	// | Terminating | Terminating:Wait | Terminating:Proceed | Terminated | Detaching
	// | Detached | EnteringStandby | Standby | Warmed:Pending | Warmed:Pending:Wait |
	// Warmed:Pending:Proceed | Warmed:Terminating | Warmed:Terminating:Wait |
	// Warmed:Terminating:Proceed | Warmed:Terminated | Warmed:Stopped | Warmed:Running
	//
	// [Instance lifecycle]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/AutoScalingGroupLifecycle.html
	//
	// This member is required.
	LifecycleState *string

	// Indicates whether the instance is protected from termination by Amazon EC2 Auto
	// Scaling when scaling in.
	//
	// This member is required.
	ProtectedFromScaleIn *bool

	// The instance type of the EC2 instance.
	InstanceType *string

	// The launch configuration used to launch the instance. This value is not
	// available if you attached the instance to the Auto Scaling group.
	LaunchConfigurationName *string

	// The launch template for the instance.
	LaunchTemplate *LaunchTemplateSpecification

	// The number of capacity units contributed by the instance based on its instance
	// type.
	//
	// Valid Range: Minimum value of 1. Maximum value of 999.
	WeightedCapacity *string

	noSmithyDocumentSerde
}

// Specifies the minimum and maximum for the BaselineEbsBandwidthMbps object when
// you specify InstanceRequirementsfor an Auto Scaling group.
type BaselineEbsBandwidthMbpsRequest struct {

	// The maximum value in Mbps.
	Max *int32

	// The minimum value in Mbps.
	Min *int32

	noSmithyDocumentSerde
}

// Describes a block device mapping.
type BlockDeviceMapping struct {

	// The device name assigned to the volume (for example, /dev/sdh or xvdh ). For
	// more information, see [Device naming on Linux instances]in the Amazon EC2 User Guide for Linux Instances.
	//
	// To define a block device mapping, set the device name and exactly one of the
	// following properties: Ebs , NoDevice , or VirtualName .
	//
	// [Device naming on Linux instances]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/device_naming.html
	//
	// This member is required.
	DeviceName *string

	// Information to attach an EBS volume to an instance at launch.
	Ebs *Ebs

	// Setting this value to true prevents a volume that is included in the block
	// device mapping of the AMI from being mapped to the specified device name at
	// launch.
	//
	// If NoDevice is true for the root device, instances might fail the EC2 health
	// check. In that case, Amazon EC2 Auto Scaling launches replacement instances.
	NoDevice *bool

	// The name of the instance store volume (virtual device) to attach to an instance
	// at launch. The name must be in the form ephemeralX where X is a number starting
	// from zero (0), for example, ephemeral0 .
	VirtualName *string

	noSmithyDocumentSerde
}

// A GetPredictiveScalingForecast call returns the capacity forecast for a
// predictive scaling policy. This structure includes the data points for that
// capacity forecast, along with the timestamps of those data points.
type CapacityForecast struct {

	// The timestamps for the data points, in UTC format.
	//
	// This member is required.
	Timestamps []time.Time

	// The values of the data points.
	//
	// This member is required.
	Values []float64

	noSmithyDocumentSerde
}

// Represents a CloudWatch metric of your choosing for a target tracking scaling
// policy to use with Amazon EC2 Auto Scaling.
//
// To create your customized metric specification:
//
//   - Add values for each required property from CloudWatch. You can use an
//     existing metric, or a new metric that you create. To use your own metric, you
//     must first publish the metric to CloudWatch. For more information, see [Publish custom metrics]in the
//     Amazon CloudWatch User Guide.
//
//   - Choose a metric that changes proportionally with capacity. The value of the
//     metric should increase or decrease in inverse proportion to the number of
//     capacity units. That is, the value of the metric should decrease when capacity
//     increases.
//
// For more information about the CloudWatch terminology below, see [Amazon CloudWatch concepts].
//
// Each individual service provides information about the metrics, namespace, and
// dimensions they use. For more information, see [Amazon Web Services services that publish CloudWatch metrics]in the Amazon CloudWatch User
// Guide.
//
// [Amazon Web Services services that publish CloudWatch metrics]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/aws-services-cloudwatch-metrics.html
// [Amazon CloudWatch concepts]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html
// [Publish custom metrics]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html
type CustomizedMetricSpecification struct {

	// The dimensions of the metric.
	//
	// Conditional: If you published your metric with dimensions, you must specify the
	// same dimensions in your scaling policy.
	Dimensions []MetricDimension

	// The name of the metric. To get the exact metric name, namespace, and
	// dimensions, inspect the [Metric]object that is returned by a call to [ListMetrics].
	//
	// [ListMetrics]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListMetrics.html
	// [Metric]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_Metric.html
	MetricName *string

	// The metrics to include in the target tracking scaling policy, as a metric data
	// query. This can include both raw metric and metric math expressions.
	Metrics []TargetTrackingMetricDataQuery

	// The namespace of the metric.
	Namespace *string

	// The statistic of the metric.
	Statistic MetricStatistic

	// The unit of the metric. For a complete list of the units that CloudWatch
	// supports, see the [MetricDatum]data type in the Amazon CloudWatch API Reference.
	//
	// [MetricDatum]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html
	Unit *string

	noSmithyDocumentSerde
}

// Describes the desired configuration for an instance refresh.
//
// If you specify a desired configuration, you must specify either a LaunchTemplate
// or a MixedInstancesPolicy .
type DesiredConfiguration struct {

	// Describes the launch template and the version of the launch template that
	// Amazon EC2 Auto Scaling uses to launch Amazon EC2 instances. For more
	// information about launch templates, see [Launch templates]in the Amazon EC2 Auto Scaling User
	// Guide.
	//
	// [Launch templates]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/LaunchTemplates.html
	LaunchTemplate *LaunchTemplateSpecification

	// Use this structure to launch multiple instance types and On-Demand Instances
	// and Spot Instances within a single Auto Scaling group.
	//
	// A mixed instances policy contains information that Amazon EC2 Auto Scaling can
	// use to launch instances and help optimize your costs. For more information, see [Auto Scaling groups with multiple instance types and purchase options]
	// in the Amazon EC2 Auto Scaling User Guide.
	//
	// [Auto Scaling groups with multiple instance types and purchase options]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html
	MixedInstancesPolicy *MixedInstancesPolicy

	noSmithyDocumentSerde
}

// Describes information used to set up an Amazon EBS volume specified in a block
// device mapping.
type Ebs struct {

	// Indicates whether the volume is deleted on instance termination. For Amazon EC2
	// Auto Scaling, the default value is true .
	DeleteOnTermination *bool

	// Specifies whether the volume should be encrypted. Encrypted EBS volumes can
	// only be attached to instances that support Amazon EBS encryption. For more
	// information, see [Supported instance types]. If your AMI uses encrypted volumes, you can also only launch
	// it on supported instance types.
	//
	// If you are creating a volume from a snapshot, you cannot create an unencrypted
	// volume from an encrypted snapshot. Also, you cannot specify a KMS key ID when
	// using a launch configuration.
	//
	// If you enable encryption by default, the EBS volumes that you create are always
	// encrypted, either using the Amazon Web Services managed KMS key or a
	// customer-managed KMS key, regardless of whether the snapshot was encrypted.
	//
	// For more information, see [Use Amazon Web Services KMS keys to encrypt Amazon EBS volumes] in the Amazon EC2 Auto Scaling User Guide.
	//
	// [Use Amazon Web Services KMS keys to encrypt Amazon EBS volumes]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-data-protection.html#encryption
	// [Supported instance types]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#EBSEncryption_supported_instances
	Encrypted *bool

	// The number of input/output (I/O) operations per second (IOPS) to provision for
	// the volume. For gp3 and io1 volumes, this represents the number of IOPS that
	// are provisioned for the volume. For gp2 volumes, this represents the baseline
	// performance of the volume and the rate at which the volume accumulates I/O
	// credits for bursting.
	//
	// The following are the supported values for each volume type:
	//
	//   - gp3 : 3,000-16,000 IOPS
	//
	//   - io1 : 100-64,000 IOPS
	//
	// For io1 volumes, we guarantee 64,000 IOPS only for [Instances built on the Nitro System]. Other instance families
	// guarantee performance up to 32,000 IOPS.
	//
	// Iops is supported when the volume type is gp3 or io1 and required only when the
	// volume type is io1 . (Not used with standard , gp2 , st1 , or sc1 volumes.)
	//
	// [Instances built on the Nitro System]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances
	Iops *int32

	// The snapshot ID of the volume to use.
	//
	// You must specify either a VolumeSize or a SnapshotId .
	SnapshotId *string

	// The throughput (MiBps) to provision for a gp3 volume.
	Throughput *int32

	// The volume size, in GiBs. The following are the supported volumes sizes for
	// each volume type:
	//
	//   - gp2 and gp3 : 1-16,384
	//
	//   - io1 : 4-16,384
	//
	//   - st1 and sc1 : 125-16,384
	//
	//   - standard : 1-1,024
	//
	// You must specify either a SnapshotId or a VolumeSize . If you specify both
	// SnapshotId and VolumeSize , the volume size must be equal or greater than the
	// size of the snapshot.
	VolumeSize *int32

	// The volume type. For more information, see [Amazon EBS volume types] in the Amazon EC2 User Guide for
	// Linux Instances.
	//
	// Valid values: standard | io1 | gp2 | st1 | sc1 | gp3
	//
	// [Amazon EBS volume types]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html
	VolumeType *string

	noSmithyDocumentSerde
}

// Describes an enabled Auto Scaling group metric.
type EnabledMetric struct {

	// The granularity of the metric. The only valid value is 1Minute .
	Granularity *string

	// One of the following metrics:
	//
	//   - GroupMinSize
	//
	//   - GroupMaxSize
	//
	//   - GroupDesiredCapacity
	//
	//   - GroupInServiceInstances
	//
	//   - GroupPendingInstances
	//
	//   - GroupStandbyInstances
	//
	//   - GroupTerminatingInstances
	//
	//   - GroupTotalInstances
	//
	//   - GroupInServiceCapacity
	//
	//   - GroupPendingCapacity
	//
	//   - GroupStandbyCapacity
	//
	//   - GroupTerminatingCapacity
	//
	//   - GroupTotalCapacity
	//
	//   - WarmPoolDesiredCapacity
	//
	//   - WarmPoolWarmedCapacity
	//
	//   - WarmPoolPendingCapacity
	//
	//   - WarmPoolTerminatingCapacity
	//
	//   - WarmPoolTotalCapacity
	//
	//   - GroupAndWarmPoolDesiredCapacity
	//
	//   - GroupAndWarmPoolTotalCapacity
	//
	// For more information, see [Auto Scaling group metrics] in the Amazon EC2 Auto Scaling User Guide.
	//
	// [Auto Scaling group metrics]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-cloudwatch-monitoring.html#as-group-metrics
	Metric *string

	noSmithyDocumentSerde
}

// Describes a scheduled action that could not be created, updated, or deleted.
type FailedScheduledUpdateGroupActionRequest struct {

	// The name of the scheduled action.
	//
	// This member is required.
	ScheduledActionName *string

	// The error code.
	ErrorCode *string

	// The error message accompanying the error code.
	ErrorMessage *string

	noSmithyDocumentSerde
}

// Describes a filter that is used to return a more specific list of results from
// a describe operation.
//
// If you specify multiple filters, the filters are automatically logically joined
// with an AND , and the request returns only the results that match all of the
// specified filters.
//
// For more information, see [Tag Auto Scaling groups and instances] in the Amazon EC2 Auto Scaling User Guide.
//
// [Tag Auto Scaling groups and instances]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-tagging.html
type Filter struct {

	// The name of the filter.
	//
	// The valid values for Name depend on which API operation you're using with the
	// filter (DescribeAutoScalingGroups or DescribeTags).
	//
	// DescribeAutoScalingGroups
	//
	// Valid values for Name include the following:
	//
	//   - tag-key - Accepts tag keys. The results only include information about the
	//   Auto Scaling groups associated with these tag keys.
	//
	//   - tag-value - Accepts tag values. The results only include information about
	//   the Auto Scaling groups associated with these tag values.
	//
	//   - tag: - Accepts the key/value combination of the tag. Use the tag key in the
	//   filter name and the tag value as the filter value. The results only include
	//   information about the Auto Scaling groups associated with the specified
	//   key/value combination.
	//
	// DescribeTags
	//
	// Valid values for Name include the following:
	//
	//   - auto-scaling-group - Accepts the names of Auto Scaling groups. The results
	//   only include information about the tags associated with these Auto Scaling
	//   groups.
	//
	//   - key - Accepts tag keys. The results only include information about the tags
	//   associated with these tag keys.
	//
	//   - value - Accepts tag values. The results only include information about the
	//   tags associated with these tag values.
	//
	//   - propagate-at-launch - Accepts a Boolean value, which specifies whether tags
	//   propagate to instances at launch. The results only include information about the
	//   tags associated with the specified Boolean value.
	Name *string

	// One or more filter values. Filter values are case-sensitive.
	//
	// If you specify multiple values for a filter, the values are automatically
	// logically joined with an OR , and the request returns all results that match any
	// of the specified values. For example, specify "tag:environment" for the filter
	// name and "production,development" for the filter values to find Auto Scaling
	// groups with the tag "environment=production" or "environment=development".
	Values []string

	noSmithyDocumentSerde
}

// Describes an EC2 instance.
type Instance struct {

	// The Availability Zone in which the instance is running.
	//
	// This member is required.
	AvailabilityZone *string

	// The last reported health status of the instance. Healthy means that the
	// instance is healthy and should remain in service. Unhealthy means that the
	// instance is unhealthy and that Amazon EC2 Auto Scaling should terminate and
	// replace it.
	//
	// This member is required.
	HealthStatus *string

	// The ID of the instance.
	//
	// This member is required.
	InstanceId *string

	// A description of the current lifecycle state. The Quarantined state is not
	// used. For information about lifecycle states, see [Instance lifecycle]in the Amazon EC2 Auto
	// Scaling User Guide.
	//
	// [Instance lifecycle]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/AutoScalingGroupLifecycle.html
	//
	// This member is required.
	LifecycleState LifecycleState

	// Indicates whether the instance is protected from termination by Amazon EC2 Auto
	// Scaling when scaling in.
	//
	// This member is required.
	ProtectedFromScaleIn *bool

	// The instance type of the EC2 instance.
	InstanceType *string

	// The launch configuration associated with the instance.
	LaunchConfigurationName *string

	// The launch template for the instance.
	LaunchTemplate *LaunchTemplateSpecification

	// The number of capacity units contributed by the instance based on its instance
	// type.
	//
	// Valid Range: Minimum value of 1. Maximum value of 999.
	WeightedCapacity *string

	noSmithyDocumentSerde
}

// Describes an instance maintenance policy.
//
// For more information, see [Set instance maintenance policy] in the Amazon EC2 Auto Scaling User Guide.
//
// [Set instance maintenance policy]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-maintenance-policy.html
type InstanceMaintenancePolicy struct {

	// Specifies the upper threshold as a percentage of the desired capacity of the
	// Auto Scaling group. It represents the maximum percentage of the group that can
	// be in service and healthy, or pending, to support your workload when replacing
	// instances. Value range is 100 to 200. To clear a previously set value, specify a
	// value of -1 .
	//
	// Both MinHealthyPercentage and MaxHealthyPercentage must be specified, and the
	// difference between them cannot be greater than 100. A large range increases the
	// number of instances that can be replaced at the same time.
	MaxHealthyPercentage *int32

	// Specifies the lower threshold as a percentage of the desired capacity of the
	// Auto Scaling group. It represents the minimum percentage of the group to keep in
	// service, healthy, and ready to use to support your workload when replacing
	// instances. Value range is 0 to 100. To clear a previously set value, specify a
	// value of -1 .
	MinHealthyPercentage *int32

	noSmithyDocumentSerde
}

// The metadata options for the instances. For more information, see [Configuring the Instance Metadata Options] in the
// Amazon EC2 Auto Scaling User Guide.
//
// [Configuring the Instance Metadata Options]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-config.html#launch-configurations-imds
type InstanceMetadataOptions struct {

	// This parameter enables or disables the HTTP metadata endpoint on your
	// instances. If the parameter is not specified, the default state is enabled .
	//
	// If you specify a value of disabled , you will not be able to access your
	// instance metadata.
	HttpEndpoint InstanceMetadataEndpointState

	// The desired HTTP PUT response hop limit for instance metadata requests. The
	// larger the number, the further instance metadata requests can travel.
	//
	// Default: 1
	HttpPutResponseHopLimit *int32

	// The state of token usage for your instance metadata requests. If the parameter
	// is not specified in the request, the default state is optional .
	//
	// If the state is optional , you can choose to retrieve instance metadata with or
	// without a signed token header on your request. If you retrieve the IAM role
	// credentials without a token, the version 1.0 role credentials are returned. If
	// you retrieve the IAM role credentials using a valid signed token, the version
	// 2.0 role credentials are returned.
	//
	// If the state is required , you must send a signed token header with any instance
	// metadata retrieval requests. In this state, retrieving the IAM role credentials
	// always returns the version 2.0 credentials; the version 1.0 credentials are not
	// available.
	HttpTokens InstanceMetadataHttpTokensState

	noSmithyDocumentSerde
}

// Describes whether detailed monitoring is enabled for the Auto Scaling instances.
type InstanceMonitoring struct {

	// If true , detailed monitoring is enabled. Otherwise, basic monitoring is enabled.
	Enabled *bool

	noSmithyDocumentSerde
}

// Describes an instance refresh for an Auto Scaling group.
type InstanceRefresh struct {

	// The name of the Auto Scaling group.
	AutoScalingGroupName *string

	// Describes the desired configuration for the instance refresh.
	DesiredConfiguration *DesiredConfiguration

	// The date and time at which the instance refresh ended.
	EndTime *time.Time

	// The instance refresh ID.
	InstanceRefreshId *string

	// The number of instances remaining to update before the instance refresh is
	// complete.
	//
	// If you roll back the instance refresh, InstancesToUpdate shows you the number
	// of instances that were not yet updated by the instance refresh. Therefore, these
	// instances don't need to be replaced as part of the rollback.
	InstancesToUpdate *int32

	// The percentage of the instance refresh that is complete. For each instance
	// replacement, Amazon EC2 Auto Scaling tracks the instance's health status and
	// warm-up time. When the instance's health status changes to healthy and the
	// specified warm-up time passes, the instance is considered updated and is added
	// to the percentage complete.
	//
	// PercentageComplete does not include instances that are replaced during a
	// rollback. This value gradually goes back down to zero during a rollback.
	PercentageComplete *int32

	// The preferences for an instance refresh.
	Preferences *RefreshPreferences

	// Additional progress details for an Auto Scaling group that has a warm pool.
	ProgressDetails *InstanceRefreshProgressDetails

	// The rollback details.
	RollbackDetails *RollbackDetails

	// The date and time at which the instance refresh began.
	StartTime *time.Time

	// The current status for the instance refresh operation:
	//
	//   - Pending - The request was created, but the instance refresh has not started.
	//
	//   - InProgress - An instance refresh is in progress.
	//
	//   - Successful - An instance refresh completed successfully.
	//
	//   - Failed - An instance refresh failed to complete. You can troubleshoot using
	//   the status reason and the scaling activities.
	//
	//   - Cancelling - An ongoing instance refresh is being cancelled.
	//
	//   - Cancelled - The instance refresh is cancelled.
	//
	//   - RollbackInProgress - An instance refresh is being rolled back.
	//
	//   - RollbackFailed - The rollback failed to complete. You can troubleshoot using
	//   the status reason and the scaling activities.
	//
	//   - RollbackSuccessful - The rollback completed successfully.
	Status InstanceRefreshStatus

	// The explanation for the specific status assigned to this operation.
	StatusReason *string

	noSmithyDocumentSerde
}

// Reports progress on replacing instances that are in the Auto Scaling group.
type InstanceRefreshLivePoolProgress struct {

	// The number of instances remaining to update.
	InstancesToUpdate *int32

	// The percentage of instances in the Auto Scaling group that have been replaced.
	// For each instance replacement, Amazon EC2 Auto Scaling tracks the instance's
	// health status and warm-up time. When the instance's health status changes to
	// healthy and the specified warm-up time passes, the instance is considered
	// updated and is added to the percentage complete.
	PercentageComplete *int32

	noSmithyDocumentSerde
}

// Reports progress on replacing instances in an Auto Scaling group that has a
// warm pool. This includes separate details for instances in the warm pool and
// instances in the Auto Scaling group (the live pool).
type InstanceRefreshProgressDetails struct {

	// Reports progress on replacing instances that are in the Auto Scaling group.
	LivePoolProgress *InstanceRefreshLivePoolProgress

	// Reports progress on replacing instances that are in the warm pool.
	WarmPoolProgress *InstanceRefreshWarmPoolProgress

	noSmithyDocumentSerde
}

// Reports progress on replacing instances that are in the warm pool.
type InstanceRefreshWarmPoolProgress struct {

	// The number of instances remaining to update.
	InstancesToUpdate *int32

	// The percentage of instances in the warm pool that have been replaced. For each
	// instance replacement, Amazon EC2 Auto Scaling tracks the instance's health
	// status and warm-up time. When the instance's health status changes to healthy
	// and the specified warm-up time passes, the instance is considered updated and is
	// added to the percentage complete.
	PercentageComplete *int32

	noSmithyDocumentSerde
}

// The attributes for the instance types for a mixed instances policy. Amazon EC2
// Auto Scaling uses your specified requirements to identify instance types. Then,
// it uses your On-Demand and Spot allocation strategies to launch instances from
// these instance types.
//
// When you specify multiple attributes, you get instance types that satisfy all
// of the specified attributes. If you specify multiple values for an attribute,
// you get instance types that satisfy any of the specified values.
//
// To limit the list of instance types from which Amazon EC2 Auto Scaling can
// identify matching instance types, you can use one of the following parameters,
// but not both in the same request:
//
//   - AllowedInstanceTypes - The instance types to include in the list. All other
//     instance types are ignored, even if they match your specified attributes.
//
//   - ExcludedInstanceTypes - The instance types to exclude from the list, even if
//     they match your specified attributes.
//
// You must specify VCpuCount and MemoryMiB . All other attributes are optional.
// Any unspecified optional attribute is set to its default.
//
// For more information, see [Creating an Auto Scaling group using attribute-based instance type selection] in the Amazon EC2 Auto Scaling User Guide. For help
// determining which instance types match your attributes before you apply them to
// your Auto Scaling group, see [Preview instance types with specified attributes]in the Amazon EC2 User Guide for Linux Instances.
//
// [Preview instance types with specified attributes]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-attribute-based-instance-type-selection.html#ec2fleet-get-instance-types-from-instance-requirements
// [Creating an Auto Scaling group using attribute-based instance type selection]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-instance-type-requirements.html
type InstanceRequirements struct {

	// The minimum and maximum instance memory size for an instance type, in MiB.
	//
	// This member is required.
	MemoryMiB *MemoryMiBRequest

	// The minimum and maximum number of vCPUs for an instance type.
	//
	// This member is required.
	VCpuCount *VCpuCountRequest

	// The minimum and maximum number of accelerators (GPUs, FPGAs, or Amazon Web
	// Services Inferentia chips) for an instance type.
	//
	// To exclude accelerator-enabled instance types, set Max to 0 .
	//
	// Default: No minimum or maximum limits
	AcceleratorCount *AcceleratorCountRequest

	// Indicates whether instance types must have accelerators by specific
	// manufacturers.
	//
	//   - For instance types with NVIDIA devices, specify nvidia .
	//
	//   - For instance types with AMD devices, specify amd .
	//
	//   - For instance types with Amazon Web Services devices, specify
	//   amazon-web-services .
	//
	//   - For instance types with Xilinx devices, specify xilinx .
	//
	// Default: Any manufacturer
	AcceleratorManufacturers []AcceleratorManufacturer

	// Lists the accelerators that must be on an instance type.
	//
	//   - For instance types with NVIDIA A100 GPUs, specify a100 .
	//
	//   - For instance types with NVIDIA V100 GPUs, specify v100 .
	//
	//   - For instance types with NVIDIA K80 GPUs, specify k80 .
	//
	//   - For instance types with NVIDIA T4 GPUs, specify t4 .
	//
	//   - For instance types with NVIDIA M60 GPUs, specify m60 .
	//
	//   - For instance types with AMD Radeon Pro V520 GPUs, specify radeon-pro-v520 .
	//
	//   - For instance types with Xilinx VU9P FPGAs, specify vu9p .
	//
	// Default: Any accelerator
	AcceleratorNames []AcceleratorName

	// The minimum and maximum total memory size for the accelerators on an instance
	// type, in MiB.
	//
	// Default: No minimum or maximum limits
	AcceleratorTotalMemoryMiB *AcceleratorTotalMemoryMiBRequest

	// Lists the accelerator types that must be on an instance type.
	//
	//   - For instance types with GPU accelerators, specify gpu .
	//
	//   - For instance types with FPGA accelerators, specify fpga .
	//
	//   - For instance types with inference accelerators, specify inference .
	//
	// Default: Any accelerator type
	AcceleratorTypes []AcceleratorType

	// The instance types to apply your specified attributes against. All other
	// instance types are ignored, even if they match your specified attributes.
	//
	// You can use strings with one or more wild cards, represented by an asterisk ( *
	// ), to allow an instance type, size, or generation. The following are examples:
	// m5.8xlarge , c5*.* , m5a.* , r* , *3* .
	//
	// For example, if you specify c5* , Amazon EC2 Auto Scaling will allow the entire
	// C5 instance family, which includes all C5a and C5n instance types. If you
	// specify m5a.* , Amazon EC2 Auto Scaling will allow all the M5a instance types,
	// but not the M5n instance types.
	//
	// If you specify AllowedInstanceTypes , you can't specify ExcludedInstanceTypes .
	//
	// Default: All instance types
	AllowedInstanceTypes []string

	// Indicates whether bare metal instance types are included, excluded, or required.
	//
	// Default: excluded
	BareMetal BareMetal

	// The minimum and maximum baseline bandwidth performance for an instance type, in
	// Mbps. For more information, see [Amazon EBS–optimized instances]in the Amazon EC2 User Guide for Linux
	// Instances.
	//
	// Default: No minimum or maximum limits
	//
	// [Amazon EBS–optimized instances]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html
	BaselineEbsBandwidthMbps *BaselineEbsBandwidthMbpsRequest

	// Indicates whether burstable performance instance types are included, excluded,
	// or required. For more information, see [Burstable performance instances]in the Amazon EC2 User Guide for Linux
	// Instances.
	//
	// Default: excluded
	//
	// [Burstable performance instances]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html
	BurstablePerformance BurstablePerformance

	// Lists which specific CPU manufacturers to include.
	//
	//   - For instance types with Intel CPUs, specify intel .
	//
	//   - For instance types with AMD CPUs, specify amd .
	//
	//   - For instance types with Amazon Web Services CPUs, specify
	//   amazon-web-services .
	//
	// Don't confuse the CPU hardware manufacturer with the CPU hardware architecture.
	// Instances will be launched with a compatible CPU architecture based on the
	// Amazon Machine Image (AMI) that you specify in your launch template.
	//
	// Default: Any manufacturer
	CpuManufacturers []CpuManufacturer

	// The instance types to exclude. You can use strings with one or more wild cards,
	// represented by an asterisk ( * ), to exclude an instance family, type, size, or
	// generation. The following are examples: m5.8xlarge , c5*.* , m5a.* , r* , *3* .
	//
	// For example, if you specify c5* , you are excluding the entire C5 instance
	// family, which includes all C5a and C5n instance types. If you specify m5a.* ,
	// Amazon EC2 Auto Scaling will exclude all the M5a instance types, but not the M5n
	// instance types.
	//
	// If you specify ExcludedInstanceTypes , you can't specify AllowedInstanceTypes .
	//
	// Default: No excluded instance types
	ExcludedInstanceTypes []string

	// Indicates whether current or previous generation instance types are included.
	//
	//   - For current generation instance types, specify current . The current
	//   generation includes EC2 instance types currently recommended for use. This
	//   typically includes the latest two to three generations in each instance family.
	//   For more information, see [Instance types]in the Amazon EC2 User Guide for Linux Instances.
	//
	//   - For previous generation instance types, specify previous .
	//
	// Default: Any current or previous generation
	//
	// [Instance types]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html
	InstanceGenerations []InstanceGeneration

	// Indicates whether instance types with instance store volumes are included,
	// excluded, or required. For more information, see [Amazon EC2 instance store]in the Amazon EC2 User Guide
	// for Linux Instances.
	//
	// Default: included
	//
	// [Amazon EC2 instance store]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html
	LocalStorage LocalStorage

	// Indicates the type of local storage that is required.
	//
	//   - For instance types with hard disk drive (HDD) storage, specify hdd .
	//
	//   - For instance types with solid state drive (SSD) storage, specify ssd .
	//
	// Default: Any local storage type
	LocalStorageTypes []LocalStorageType

	// [Price protection] The price protection threshold for Spot Instances, as a
	// percentage of an identified On-Demand price. The identified On-Demand price is
	// the price of the lowest priced current generation C, M, or R instance type with
	// your specified attributes. If no current generation C, M, or R instance type
	// matches your attributes, then the identified price is from either the lowest
	// priced current generation instance types or, failing that, the lowest priced
	// previous generation instance types that match your attributes. When Amazon EC2
	// Auto Scaling selects instance types with your attributes, we will exclude
	// instance types whose price exceeds your specified threshold.
	//
	// The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a
	// percentage.
	//
	// If you set DesiredCapacityType to vcpu or memory-mib , the price protection
	// threshold is based on the per-vCPU or per-memory price instead of the per
	// instance price.
	//
	// Only one of SpotMaxPricePercentageOverLowestPrice or
	// MaxSpotPriceAsPercentageOfOptimalOnDemandPrice can be specified. If you don't
	// specify either, Amazon EC2 Auto Scaling will automatically apply optimal price
	// protection to consistently select from a wide range of instance types. To
	// indicate no price protection threshold for Spot Instances, meaning you want to
	// consider all instance types that match your attributes, include one of these
	// parameters and specify a high value, such as 999999 .
	MaxSpotPriceAsPercentageOfOptimalOnDemandPrice *int32

	// The minimum and maximum amount of memory per vCPU for an instance type, in GiB.
	//
	// Default: No minimum or maximum limits
	MemoryGiBPerVCpu *MemoryGiBPerVCpuRequest

	// The minimum and maximum amount of network bandwidth, in gigabits per second
	// (Gbps).
	//
	// Default: No minimum or maximum limits
	NetworkBandwidthGbps *NetworkBandwidthGbpsRequest

	// The minimum and maximum number of network interfaces for an instance type.
	//
	// Default: No minimum or maximum limits
	NetworkInterfaceCount *NetworkInterfaceCountRequest

	// [Price protection] The price protection threshold for On-Demand Instances, as a
	// percentage higher than an identified On-Demand price. The identified On-Demand
	// price is the price of the lowest priced current generation C, M, or R instance
	// type with your specified attributes. If no current generation C, M, or R
	// instance type matches your attributes, then the identified price is from either
	// the lowest priced current generation instance types or, failing that, the lowest
	// priced previous generation instance types that match your attributes. When
	// Amazon EC2 Auto Scaling selects instance types with your attributes, we will
	// exclude instance types whose price exceeds your specified threshold.
	//
	// The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a
	// percentage.
	//
	// To turn off price protection, specify a high value, such as 999999 .
	//
	// If you set DesiredCapacityType to vcpu or memory-mib , the price protection
	// threshold is applied based on the per-vCPU or per-memory price instead of the
	// per instance price.
	//
	// Default: 20
	OnDemandMaxPricePercentageOverLowestPrice *int32

	// Indicates whether instance types must provide On-Demand Instance hibernation
	// support.
	//
	// Default: false
	RequireHibernateSupport *bool

	// [Price protection] The price protection threshold for Spot Instances, as a
	// percentage higher than an identified Spot price. The identified Spot price is
	// the price of the lowest priced current generation C, M, or R instance type with
	// your specified attributes. If no current generation C, M, or R instance type
	// matches your attributes, then the identified price is from either the lowest
	// priced current generation instance types or, failing that, the lowest priced
	// previous generation instance types that match your attributes. When Amazon EC2
	// Auto Scaling selects instance types with your attributes, we will exclude
	// instance types whose price exceeds your specified threshold.
	//
	// The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a
	// percentage.
	//
	// If you set DesiredCapacityType to vcpu or memory-mib , the price protection
	// threshold is based on the per-vCPU or per-memory price instead of the per
	// instance price.
	//
	// Only one of SpotMaxPricePercentageOverLowestPrice or
	// MaxSpotPriceAsPercentageOfOptimalOnDemandPrice can be specified. If you don't
	// specify either, Amazon EC2 Auto Scaling will automatically apply optimal price
	// protection to consistently select from a wide range of instance types. To
	// indicate no price protection threshold for Spot Instances, meaning you want to
	// consider all instance types that match your attributes, include one of these
	// parameters and specify a high value, such as 999999 .
	SpotMaxPricePercentageOverLowestPrice *int32

	// The minimum and maximum total local storage size for an instance type, in GB.
	//
	// Default: No minimum or maximum limits
	TotalLocalStorageGB *TotalLocalStorageGBRequest

	noSmithyDocumentSerde
}

// Describes an instance reuse policy for a warm pool.
//
// For more information, see [Warm pools for Amazon EC2 Auto Scaling] in the Amazon EC2 Auto Scaling User Guide.
//
// [Warm pools for Amazon EC2 Auto Scaling]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html
type InstanceReusePolicy struct {

	// Specifies whether instances in the Auto Scaling group can be returned to the
	// warm pool on scale in.
	ReuseOnScaleIn *bool

	noSmithyDocumentSerde
}

// Use this structure to specify the distribution of On-Demand Instances and Spot
// Instances and the allocation strategies used to fulfill On-Demand and Spot
// capacities for a mixed instances policy.
type InstancesDistribution struct {

	// The allocation strategy to apply to your On-Demand Instances when they are
	// launched. Possible instance types are determined by the launch template
	// overrides that you specify.
	//
	// The following lists the valid values:
	//
	// lowest-price Uses price to determine which instance types are the highest
	// priority, launching the lowest priced instance types within an Availability Zone
	// first. This is the default value for Auto Scaling groups that specify InstanceRequirements.
	//
	// prioritized You set the order of instance types for the launch template
	// overrides from highest to lowest priority (from first to last in the list).
	// Amazon EC2 Auto Scaling launches your highest priority instance types first. If
	// all your On-Demand capacity cannot be fulfilled using your highest priority
	// instance type, then Amazon EC2 Auto Scaling launches the remaining capacity
	// using the second priority instance type, and so on. This is the default value
	// for Auto Scaling groups that don't specify InstanceRequirementsand cannot be used for groups that
	// do.
	OnDemandAllocationStrategy *string

	// The minimum amount of the Auto Scaling group's capacity that must be fulfilled
	// by On-Demand Instances. This base portion is launched first as your group
	// scales.
	//
	// This number has the same unit of measurement as the group's desired capacity.
	// If you change the default unit of measurement (number of instances) by
	// specifying weighted capacity values in your launch template overrides list, or
	// by changing the default desired capacity type setting of the group, you must
	// specify this number using the same unit of measurement.
	//
	// Default: 0
	OnDemandBaseCapacity *int32

	// Controls the percentages of On-Demand Instances and Spot Instances for your
	// additional capacity beyond OnDemandBaseCapacity . Expressed as a number (for
	// example, 20 specifies 20% On-Demand Instances, 80% Spot Instances). If set to
	// 100, only On-Demand Instances are used.
	//
	// Default: 100
	OnDemandPercentageAboveBaseCapacity *int32

	// The allocation strategy to apply to your Spot Instances when they are launched.
	// Possible instance types are determined by the launch template overrides that you
	// specify.
	//
	// The following lists the valid values:
	//
	// capacity-optimized Requests Spot Instances using pools that are optimally
	// chosen based on the available Spot capacity. This strategy has the lowest risk
	// of interruption. To give certain instance types a higher chance of launching
	// first, use capacity-optimized-prioritized .
	//
	// capacity-optimized-prioritized You set the order of instance types for the
	// launch template overrides from highest to lowest priority (from first to last in
	// the list). Amazon EC2 Auto Scaling honors the instance type priorities on a best
	// effort basis but optimizes for capacity first. Note that if the On-Demand
	// allocation strategy is set to prioritized , the same priority is applied when
	// fulfilling On-Demand capacity. This is not a valid value for Auto Scaling groups
	// that specify InstanceRequirements.
	//
	// lowest-price Requests Spot Instances using the lowest priced pools within an
	// Availability Zone, across the number of Spot pools that you specify for the
	// SpotInstancePools property. To ensure that your desired capacity is met, you
	// might receive Spot Instances from several pools. This is the default value, but
	// it might lead to high interruption rates because this strategy only considers
	// instance price and not available capacity.
	//
	// price-capacity-optimized (recommended) The price and capacity optimized
	// allocation strategy looks at both price and capacity to select the Spot Instance
	// pools that are the least likely to be interrupted and have the lowest possible
	// price.
	SpotAllocationStrategy *string

	// The number of Spot Instance pools across which to allocate your Spot Instances.
	// The Spot pools are determined from the different instance types in the
	// overrides. Valid only when the SpotAllocationStrategy is lowest-price . Value
	// must be in the range of 1–20.
	//
	// Default: 2
	SpotInstancePools *int32

	// The maximum price per unit hour that you are willing to pay for a Spot
	// Instance. If your maximum price is lower than the Spot price for the instance
	// types that you selected, your Spot Instances are not launched. We do not
	// recommend specifying a maximum price because it can lead to increased
	// interruptions. When Spot Instances launch, you pay the current Spot price. To
	// remove a maximum price that you previously set, include the property but specify
	// an empty string ("") for the value.
	//
	// If you specify a maximum price, your instances will be interrupted more
	// frequently than if you do not specify one.
	//
	// Valid Range: Minimum value of 0.001
	SpotMaxPrice *string

	noSmithyDocumentSerde
}

// Describes a launch configuration.
type LaunchConfiguration struct {

	// The creation date and time for the launch configuration.
	//
	// This member is required.
	CreatedTime *time.Time

	// The ID of the Amazon Machine Image (AMI) to use to launch your EC2 instances.
	// For more information, see [Find a Linux AMI]in the Amazon EC2 User Guide for Linux Instances.
	//
	// [Find a Linux AMI]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html
	//
	// This member is required.
	ImageId *string

	// The instance type for the instances. For information about available instance
	// types, see [Available instance types]in the Amazon EC2 User Guide for Linux Instances.
	//
	// [Available instance types]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes
	//
	// This member is required.
	InstanceType *string

	// The name of the launch configuration.
	//
	// This member is required.
	LaunchConfigurationName *string

	// Specifies whether to assign a public IPv4 address to the group's instances. If
	// the instance is launched into a default subnet, the default is to assign a
	// public IPv4 address, unless you disabled the option to assign a public IPv4
	// address on the subnet. If the instance is launched into a nondefault subnet, the
	// default is not to assign a public IPv4 address, unless you enabled the option to
	// assign a public IPv4 address on the subnet. For more information, see [Launching Auto Scaling instances in a VPC]in the
	// Amazon EC2 Auto Scaling User Guide.
	//
	// [Launching Auto Scaling instances in a VPC]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html
	AssociatePublicIpAddress *bool

	// The block device mapping entries that define the block devices to attach to the
	// instances at launch. By default, the block devices specified in the block device
	// mapping for the AMI are used. For more information, see [Block Device Mapping]in the Amazon EC2 User
	// Guide for Linux Instances.
	//
	// [Block Device Mapping]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html
	BlockDeviceMappings []BlockDeviceMapping

	// Available for backward compatibility.
	ClassicLinkVPCId *string

	// Available for backward compatibility.
	ClassicLinkVPCSecurityGroups []string

	// Specifies whether the launch configuration is optimized for EBS I/O ( true ) or
	// not ( false ). For more information, see [Amazon EBS-Optimized Instances] in the Amazon EC2 User Guide for
	// Linux Instances.
	//
	// [Amazon EBS-Optimized Instances]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html
	EbsOptimized *bool

	// The name or the Amazon Resource Name (ARN) of the instance profile associated
	// with the IAM role for the instance. The instance profile contains the IAM role.
	// For more information, see [IAM role for applications that run on Amazon EC2 instances]in the Amazon EC2 Auto Scaling User Guide.
	//
	// [IAM role for applications that run on Amazon EC2 instances]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/us-iam-role.html
	IamInstanceProfile *string

	// Controls whether instances in this group are launched with detailed ( true ) or
	// basic ( false ) monitoring.
	//
	// For more information, see [Configure Monitoring for Auto Scaling Instances] in the Amazon EC2 Auto Scaling User Guide.
	//
	// [Configure Monitoring for Auto Scaling Instances]: https://docs.aws.amazon.com/autoscaling/latest/userguide/enable-as-instance-metrics.html
	InstanceMonitoring *InstanceMonitoring

	// The ID of the kernel associated with the AMI.
	KernelId *string

	// The name of the key pair.
	//
	// For more information, see [Amazon EC2 Key Pairs] in the Amazon EC2 User Guide for Linux Instances.
	//
	// [Amazon EC2 Key Pairs]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html
	KeyName *string

	// The Amazon Resource Name (ARN) of the launch configuration.
	LaunchConfigurationARN *string

	// The metadata options for the instances. For more information, see [Configuring the Instance Metadata Options] in the
	// Amazon EC2 Auto Scaling User Guide.
	//
	// [Configuring the Instance Metadata Options]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-config.html#launch-configurations-imds
	MetadataOptions *InstanceMetadataOptions

	// The tenancy of the instance, either default or dedicated . An instance with
	// dedicated tenancy runs on isolated, single-tenant hardware and can only be
	// launched into a VPC.
	//
	// For more information, see [Configuring instance tenancy with Amazon EC2 Auto Scaling] in the Amazon EC2 Auto Scaling User Guide.
	//
	// [Configuring instance tenancy with Amazon EC2 Auto Scaling]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/auto-scaling-dedicated-instances.html
	PlacementTenancy *string

	// The ID of the RAM disk associated with the AMI.
	RamdiskId *string

	// A list that contains the security groups to assign to the instances in the Auto
	// Scaling group. For more information, see [Security Groups for Your VPC]in the Amazon Virtual Private Cloud
	// User Guide.
	//
	// [Security Groups for Your VPC]: https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html
	SecurityGroups []string

	// The maximum hourly price to be paid for any Spot Instance launched to fulfill
	// the request. Spot Instances are launched when the price you specify exceeds the
	// current Spot price. For more information, see [Requesting Spot Instances]in the Amazon EC2 Auto Scaling
	// User Guide.
	//
	// [Requesting Spot Instances]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-launch-spot-instances.html
	SpotPrice *string

	// The user data to make available to the launched EC2 instances. For more
	// information, see [Instance metadata and user data](Linux) and [Instance metadata and user data] (Windows). If you are using a command line tool,
	// base64-encoding is performed for you, and you can load the text from a file.
	// Otherwise, you must provide base64-encoded text. User data is limited to 16 KB.
	//
	// [Instance metadata and user data]: https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-instance-metadata.html
	UserData *string

	noSmithyDocumentSerde
}

// Use this structure to specify the launch templates and instance types
// (overrides) for a mixed instances policy.
type LaunchTemplate struct {

	// The launch template.
	LaunchTemplateSpecification *LaunchTemplateSpecification

	// Any properties that you specify override the same properties in the launch
	// template.
	Overrides []LaunchTemplateOverrides

	noSmithyDocumentSerde
}

// Use this structure to let Amazon EC2 Auto Scaling do the following when the
// Auto Scaling group has a mixed instances policy:
//
//   - Override the instance type that is specified in the launch template.
//
//   - Use multiple instance types.
//
// Specify the instance types that you want, or define your instance requirements
// instead and let Amazon EC2 Auto Scaling provision the available instance types
// that meet your requirements. This can provide Amazon EC2 Auto Scaling with a
// larger selection of instance types to choose from when fulfilling Spot and
// On-Demand capacities. You can view which instance types are matched before you
// apply the instance requirements to your Auto Scaling group.
//
// After you define your instance requirements, you don't have to keep updating
// these settings to get new EC2 instance types automatically. Amazon EC2 Auto
// Scaling uses the instance requirements of the Auto Scaling group to determine
// whether a new EC2 instance type can be used.
type LaunchTemplateOverrides struct {

	// The instance requirements. Amazon EC2 Auto Scaling uses your specified
	// requirements to identify instance types. Then, it uses your On-Demand and Spot
	// allocation strategies to launch instances from these instance types.
	//
	// You can specify up to four separate sets of instance requirements per Auto
	// Scaling group. This is useful for provisioning instances from different Amazon
	// Machine Images (AMIs) in the same Auto Scaling group. To do this, create the
	// AMIs and create a new launch template for each AMI. Then, create a compatible
	// set of instance requirements for each launch template.
	//
	// If you specify InstanceRequirements , you can't specify InstanceType .
	InstanceRequirements *InstanceRequirements

	// The instance type, such as m3.xlarge . You must specify an instance type that is
	// supported in your requested Region and Availability Zones. For more information,
	// see [Instance types]in the Amazon Elastic Compute Cloud User Guide.
	//
	// You can specify up to 40 instance types per Auto Scaling group.
	//
	// [Instance types]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html
	InstanceType *string

	// Provides a launch template for the specified instance type or set of instance
	// requirements. For example, some instance types might require a launch template
	// with a different AMI. If not provided, Amazon EC2 Auto Scaling uses the launch
	// template that's specified in the LaunchTemplate definition. For more
	// information, see [Specifying a different launch template for an instance type]in the Amazon EC2 Auto Scaling User Guide.
	//
	// You can specify up to 20 launch templates per Auto Scaling group. The launch
	// templates specified in the overrides and in the LaunchTemplate definition count
	// towards this limit.
	//
	// [Specifying a different launch template for an instance type]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups-launch-template-overrides.html
	LaunchTemplateSpecification *LaunchTemplateSpecification

	// If you provide a list of instance types to use, you can specify the number of
	// capacity units provided by each instance type in terms of virtual CPUs, memory,
	// storage, throughput, or other relative performance characteristic. When a Spot
	// or On-Demand Instance is launched, the capacity units count toward the desired
	// capacity. Amazon EC2 Auto Scaling launches instances until the desired capacity
	// is totally fulfilled, even if this results in an overage. For example, if there
	// are two units remaining to fulfill capacity, and Amazon EC2 Auto Scaling can
	// only launch an instance with a WeightedCapacity of five units, the instance is
	// launched, and the desired capacity is exceeded by three units. For more
	// information, see [Configuring instance weighting for Amazon EC2 Auto Scaling]in the Amazon EC2 Auto Scaling User Guide. Value must be in
	// the range of 1–999.
	//
	// If you specify a value for WeightedCapacity for one instance type, you must
	// specify a value for WeightedCapacity for all of them.
	//
	// Every Auto Scaling group has three size parameters ( DesiredCapacity , MaxSize ,
	// and MinSize ). Usually, you set these sizes based on a specific number of
	// instances. However, if you configure a mixed instances policy that defines
	// weights for the instance types, you must specify these sizes with the same units
	// that you use for weighting instances.
	//
	// [Configuring instance weighting for Amazon EC2 Auto Scaling]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups-instance-weighting.html
	WeightedCapacity *string

	noSmithyDocumentSerde
}

// Describes the launch template and the version of the launch template that
// Amazon EC2 Auto Scaling uses to launch Amazon EC2 instances. For more
// information about launch templates, see [Launch templates]in the Amazon EC2 Auto Scaling User
// Guide.
//
// [Launch templates]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/LaunchTemplates.html
type LaunchTemplateSpecification struct {

	// The ID of the launch template. To get the template ID, use the Amazon EC2 [DescribeLaunchTemplates] API
	// operation. New launch templates can be created using the Amazon EC2 [CreateLaunchTemplate]API.
	//
	// Conditional: You must specify either a LaunchTemplateId or a LaunchTemplateName .
	//
	// [CreateLaunchTemplate]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLaunchTemplate.html
	// [DescribeLaunchTemplates]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLaunchTemplates.html
	LaunchTemplateId *string

	// The name of the launch template. To get the template name, use the Amazon EC2 [DescribeLaunchTemplates]
	// API operation. New launch templates can be created using the Amazon EC2 [CreateLaunchTemplate]API.
	//
	// Conditional: You must specify either a LaunchTemplateId or a LaunchTemplateName .
	//
	// [CreateLaunchTemplate]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLaunchTemplate.html
	// [DescribeLaunchTemplates]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLaunchTemplates.html
	LaunchTemplateName *string

	// The version number, $Latest , or $Default . To get the version number, use the
	// Amazon EC2 [DescribeLaunchTemplateVersions]API operation. New launch template versions can be created using the
	// Amazon EC2 [CreateLaunchTemplateVersion]API. If the value is $Latest , Amazon EC2 Auto Scaling selects the
	// latest version of the launch template when launching instances. If the value is
	// $Default , Amazon EC2 Auto Scaling selects the default version of the launch
	// template when launching instances. The default value is $Default .
	//
	// [CreateLaunchTemplateVersion]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLaunchTemplateVersion.html
	// [DescribeLaunchTemplateVersions]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLaunchTemplateVersions.html
	Version *string

	noSmithyDocumentSerde
}

// Describes a lifecycle hook. A lifecycle hook lets you create solutions that are
// aware of events in the Auto Scaling instance lifecycle, and then perform a
// custom action on instances when the corresponding lifecycle event occurs.
type LifecycleHook struct {

	// The name of the Auto Scaling group for the lifecycle hook.
	AutoScalingGroupName *string

	// The action the Auto Scaling group takes when the lifecycle hook timeout elapses
	// or if an unexpected failure occurs.
	//
	// Valid values: CONTINUE | ABANDON
	DefaultResult *string

	// The maximum time, in seconds, that an instance can remain in a wait state. The
	// maximum is 172800 seconds (48 hours) or 100 times HeartbeatTimeout , whichever
	// is smaller.
	GlobalTimeout *int32

	// The maximum time, in seconds, that can elapse before the lifecycle hook times
	// out. If the lifecycle hook times out, Amazon EC2 Auto Scaling performs the
	// action that you specified in the DefaultResult property.
	HeartbeatTimeout *int32

	// The name of the lifecycle hook.
	LifecycleHookName *string

	// The lifecycle transition.
	//
	// Valid values: autoscaling:EC2_INSTANCE_LAUNCHING |
	// autoscaling:EC2_INSTANCE_TERMINATING
	LifecycleTransition *string

	// Additional information that is included any time Amazon EC2 Auto Scaling sends
	// a message to the notification target.
	NotificationMetadata *string

	// The ARN of the target that Amazon EC2 Auto Scaling sends notifications to when
	// an instance is in a wait state for the lifecycle hook.
	NotificationTargetARN *string

	// The ARN of the IAM role that allows the Auto Scaling group to publish to the
	// specified notification target (an Amazon SNS topic or an Amazon SQS queue).
	RoleARN *string

	noSmithyDocumentSerde
}

// Describes information used to specify a lifecycle hook for an Auto Scaling
// group.
//
// For more information, see [Amazon EC2 Auto Scaling lifecycle hooks] in the Amazon EC2 Auto Scaling User Guide.
//
// [Amazon EC2 Auto Scaling lifecycle hooks]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/lifecycle-hooks.html
type LifecycleHookSpecification struct {

	// The name of the lifecycle hook.
	//
	// This member is required.
	LifecycleHookName *string

	// The lifecycle transition. For Auto Scaling groups, there are two major
	// lifecycle transitions.
	//
	//   - To create a lifecycle hook for scale-out events, specify
	//   autoscaling:EC2_INSTANCE_LAUNCHING .
	//
	//   - To create a lifecycle hook for scale-in events, specify
	//   autoscaling:EC2_INSTANCE_TERMINATING .
	//
	// This member is required.
	LifecycleTransition *string

	// The action the Auto Scaling group takes when the lifecycle hook timeout elapses
	// or if an unexpected failure occurs. The default value is ABANDON .
	//
	// Valid values: CONTINUE | ABANDON
	DefaultResult *string

	// The maximum time, in seconds, that can elapse before the lifecycle hook times
	// out. The range is from 30 to 7200 seconds. The default value is 3600 seconds (1
	// hour).
	HeartbeatTimeout *int32

	// Additional information that you want to include any time Amazon EC2 Auto
	// Scaling sends a message to the notification target.
	NotificationMetadata *string

	// The Amazon Resource Name (ARN) of the notification target that Amazon EC2 Auto
	// Scaling sends notifications to when an instance is in a wait state for the
	// lifecycle hook. You can specify an Amazon SNS topic or an Amazon SQS queue.
	NotificationTargetARN *string

	// The ARN of the IAM role that allows the Auto Scaling group to publish to the
	// specified notification target. For information about creating this role, see [Configure a notification target for a lifecycle hook]in
	// the Amazon EC2 Auto Scaling User Guide.
	//
	// Valid only if the notification target is an Amazon SNS topic or an Amazon SQS
	// queue.
	//
	// [Configure a notification target for a lifecycle hook]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/prepare-for-lifecycle-notifications.html#lifecycle-hook-notification-target
	RoleARN *string

	noSmithyDocumentSerde
}

// Describes the state of a Classic Load Balancer.
type LoadBalancerState struct {

	// The name of the load balancer.
	LoadBalancerName *string

	// One of the following load balancer states:
	//
	//   - Adding - The Auto Scaling instances are being registered with the load
	//   balancer.
	//
	//   - Added - All Auto Scaling instances are registered with the load balancer.
	//
	//   - InService - At least one Auto Scaling instance passed an ELB health check.
	//
	//   - Removing - The Auto Scaling instances are being deregistered from the load
	//   balancer. If connection draining is enabled, Elastic Load Balancing waits for
	//   in-flight requests to complete before deregistering the instances.
	//
	//   - Removed - All Auto Scaling instances are deregistered from the load balancer.
	State *string

	noSmithyDocumentSerde
}

// Describes the state of a target group.
type LoadBalancerTargetGroupState struct {

	// The Amazon Resource Name (ARN) of the target group.
	LoadBalancerTargetGroupARN *string

	// The state of the target group.
	//
	//   - Adding - The Auto Scaling instances are being registered with the target
	//   group.
	//
	//   - Added - All Auto Scaling instances are registered with the target group.
	//
	//   - InService - At least one Auto Scaling instance passed an ELB health check.
	//
	//   - Removing - The Auto Scaling instances are being deregistered from the target
	//   group. If connection draining is enabled, Elastic Load Balancing waits for
	//   in-flight requests to complete before deregistering the instances.
	//
	//   - Removed - All Auto Scaling instances are deregistered from the target group.
	State *string

	noSmithyDocumentSerde
}

// A GetPredictiveScalingForecast call returns the load forecast for a predictive
// scaling policy. This structure includes the data points for that load forecast,
// along with the timestamps of those data points and the metric specification.
type LoadForecast struct {

	// The metric specification for the load forecast.
	//
	// This member is required.
	MetricSpecification *PredictiveScalingMetricSpecification

	// The timestamps for the data points, in UTC format.
	//
	// This member is required.
	Timestamps []time.Time

	// The values of the data points.
	//
	// This member is required.
	Values []float64

	noSmithyDocumentSerde
}

// Specifies the minimum and maximum for the MemoryGiBPerVCpu object when you
// specify InstanceRequirementsfor an Auto Scaling group.
type MemoryGiBPerVCpuRequest struct {

	// The memory maximum in GiB.
	Max *float64

	// The memory minimum in GiB.
	Min *float64

	noSmithyDocumentSerde
}

// Specifies the minimum and maximum for the MemoryMiB object when you specify InstanceRequirements
// for an Auto Scaling group.
type MemoryMiBRequest struct {

	// The memory minimum in MiB.
	//
	// This member is required.
	Min *int32

	// The memory maximum in MiB.
	Max *int32

	noSmithyDocumentSerde
}

// Represents a specific metric.
type Metric struct {

	// The name of the metric.
	//
	// This member is required.
	MetricName *string

	// The namespace of the metric. For more information, see the table in [Amazon Web Services services that publish CloudWatch metrics] in the
	// Amazon CloudWatch User Guide.
	//
	// [Amazon Web Services services that publish CloudWatch metrics]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/aws-services-cloudwatch-metrics.html
	//
	// This member is required.
	Namespace *string

	// The dimensions for the metric. For the list of available dimensions, see the
	// Amazon Web Services documentation available from the table in [Amazon Web Services services that publish CloudWatch metrics]in the Amazon
	// CloudWatch User Guide.
	//
	// Conditional: If you published your metric with dimensions, you must specify the
	// same dimensions in your scaling policy.
	//
	// [Amazon Web Services services that publish CloudWatch metrics]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/aws-services-cloudwatch-metrics.html
	Dimensions []MetricDimension

	noSmithyDocumentSerde
}

// Describes a metric.
type MetricCollectionType struct {

	// One of the following metrics:
	//
	//   - GroupMinSize
	//
	//   - GroupMaxSize
	//
	//   - GroupDesiredCapacity
	//
	//   - GroupInServiceInstances
	//
	//   - GroupPendingInstances
	//
	//   - GroupStandbyInstances
	//
	//   - GroupTerminatingInstances
	//
	//   - GroupTotalInstances
	//
	//   - GroupInServiceCapacity
	//
	//   - GroupPendingCapacity
	//
	//   - GroupStandbyCapacity
	//
	//   - GroupTerminatingCapacity
	//
	//   - GroupTotalCapacity
	//
	//   - WarmPoolDesiredCapacity
	//
	//   - WarmPoolWarmedCapacity
	//
	//   - WarmPoolPendingCapacity
	//
	//   - WarmPoolTerminatingCapacity
	//
	//   - WarmPoolTotalCapacity
	//
	//   - GroupAndWarmPoolDesiredCapacity
	//
	//   - GroupAndWarmPoolTotalCapacity
	Metric *string

	noSmithyDocumentSerde
}

// The metric data to return. Also defines whether this call is returning data for
// one metric only, or whether it is performing a math expression on the values of
// returned metric statistics to create a new time series. A time series is a
// series of data points, each of which is associated with a timestamp.
//
// For more information and examples, see [Advanced predictive scaling policy configurations using custom metrics] in the Amazon EC2 Auto Scaling User
// Guide.
//
// [Advanced predictive scaling policy configurations using custom metrics]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/predictive-scaling-customized-metric-specification.html
type MetricDataQuery struct {

	// A short name that identifies the object's results in the response. This name
	// must be unique among all MetricDataQuery objects specified for a single scaling
	// policy. If you are performing math expressions on this set of data, this name
	// represents that data and can serve as a variable in the mathematical expression.
	// The valid characters are letters, numbers, and underscores. The first character
	// must be a lowercase letter.
	//
	// This member is required.
	Id *string

	// The math expression to perform on the returned data, if this object is
	// performing a math expression. This expression can use the Id of the other
	// metrics to refer to those metrics, and can also use the Id of other expressions
	// to use the result of those expressions.
	//
	// Conditional: Within each MetricDataQuery object, you must specify either
	// Expression or MetricStat , but not both.
	Expression *string

	// A human-readable label for this metric or expression. This is especially useful
	// if this is a math expression, so that you know what the value represents.
	Label *string

	// Information about the metric data to return.
	//
	// Conditional: Within each MetricDataQuery object, you must specify either
	// Expression or MetricStat , but not both.
	MetricStat *MetricStat

	// Indicates whether to return the timestamps and raw data values of this metric.
	//
	// If you use any math expressions, specify true for this value for only the final
	// math expression that the metric specification is based on. You must specify
	// false for ReturnData for all the other metrics and expressions used in the
	// metric specification.
	//
	// If you are only retrieving metrics and not performing any math expressions, do
	// not specify anything for ReturnData . This sets it to its default ( true ).
	ReturnData *bool

	noSmithyDocumentSerde
}

// Describes the dimension of a metric.
type MetricDimension struct {

	// The name of the dimension.
	//
	// This member is required.
	Name *string

	// The value of the dimension.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Describes a granularity of a metric.
type MetricGranularityType struct {

	// The granularity. The only valid value is 1Minute .
	Granularity *string

	noSmithyDocumentSerde
}

// This structure defines the CloudWatch metric to return, along with the
// statistic and unit.
//
// For more information about the CloudWatch terminology below, see [Amazon CloudWatch concepts] in the Amazon
// CloudWatch User Guide.
//
// [Amazon CloudWatch concepts]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html
type MetricStat struct {

	// The CloudWatch metric to return, including the metric name, namespace, and
	// dimensions. To get the exact metric name, namespace, and dimensions, inspect the
	// [Metric]object that is returned by a call to [ListMetrics].
	//
	// [ListMetrics]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListMetrics.html
	// [Metric]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_Metric.html
	//
	// This member is required.
	Metric *Metric

	// The statistic to return. It can include any CloudWatch statistic or extended
	// statistic. For a list of valid values, see the table in [Statistics]in the Amazon
	// CloudWatch User Guide.
	//
	// The most commonly used metrics for predictive scaling are Average and Sum .
	//
	// [Statistics]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic
	//
	// This member is required.
	Stat *string

	// The unit to use for the returned data points. For a complete list of the units
	// that CloudWatch supports, see the [MetricDatum]data type in the Amazon CloudWatch API
	// Reference.
	//
	// [MetricDatum]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html
	Unit *string

	noSmithyDocumentSerde
}

// Use this structure to launch multiple instance types and On-Demand Instances
// and Spot Instances within a single Auto Scaling group.
//
// A mixed instances policy contains information that Amazon EC2 Auto Scaling can
// use to launch instances and help optimize your costs. For more information, see [Auto Scaling groups with multiple instance types and purchase options]
// in the Amazon EC2 Auto Scaling User Guide.
//
// [Auto Scaling groups with multiple instance types and purchase options]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html
type MixedInstancesPolicy struct {

	// The instances distribution.
	InstancesDistribution *InstancesDistribution

	// One or more launch templates and the instance types (overrides) that are used
	// to launch EC2 instances to fulfill On-Demand and Spot capacities.
	LaunchTemplate *LaunchTemplate

	noSmithyDocumentSerde
}

// Specifies the minimum and maximum for the NetworkBandwidthGbps object when you
// specify InstanceRequirementsfor an Auto Scaling group.
//
// Setting the minimum bandwidth does not guarantee that your instance will
// achieve the minimum bandwidth. Amazon EC2 will identify instance types that
// support the specified minimum bandwidth, but the actual bandwidth of your
// instance might go below the specified minimum at times. For more information,
// see [Available instance bandwidth]in the Amazon EC2 User Guide for Linux Instances.
//
// [Available instance bandwidth]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-network-bandwidth.html#available-instance-bandwidth
type NetworkBandwidthGbpsRequest struct {

	// The maximum amount of network bandwidth, in gigabits per second (Gbps).
	Max *float64

	// The minimum amount of network bandwidth, in gigabits per second (Gbps).
	Min *float64

	noSmithyDocumentSerde
}

// Specifies the minimum and maximum for the NetworkInterfaceCount object when you
// specify InstanceRequirementsfor an Auto Scaling group.
type NetworkInterfaceCountRequest struct {

	// The maximum number of network interfaces.
	Max *int32

	// The minimum number of network interfaces.
	Min *int32

	noSmithyDocumentSerde
}

// Describes a notification.
type NotificationConfiguration struct {

	// The name of the Auto Scaling group.
	AutoScalingGroupName *string

	// One of the following event notification types:
	//
	//   - autoscaling:EC2_INSTANCE_LAUNCH
	//
	//   - autoscaling:EC2_INSTANCE_LAUNCH_ERROR
	//
	//   - autoscaling:EC2_INSTANCE_TERMINATE
	//
	//   - autoscaling:EC2_INSTANCE_TERMINATE_ERROR
	//
	//   - autoscaling:TEST_NOTIFICATION
	NotificationType *string

	// The Amazon Resource Name (ARN) of the Amazon SNS topic.
	TopicARN *string

	noSmithyDocumentSerde
}

// Represents a predefined metric for a target tracking scaling policy to use with
// Amazon EC2 Auto Scaling.
type PredefinedMetricSpecification struct {

	// The metric type. The following predefined metrics are available:
	//
	//   - ASGAverageCPUUtilization - Average CPU utilization of the Auto Scaling group.
	//
	//   - ASGAverageNetworkIn - Average number of bytes received on all network
	//   interfaces by the Auto Scaling group.
	//
	//   - ASGAverageNetworkOut - Average number of bytes sent out on all network
	//   interfaces by the Auto Scaling group.
	//
	//   - ALBRequestCountPerTarget - Average Application Load Balancer request count
	//   per target for your Auto Scaling group.
	//
	// This member is required.
	PredefinedMetricType MetricType

	// A label that uniquely identifies a specific Application Load Balancer target
	// group from which to determine the average request count served by your Auto
	// Scaling group. You can't specify a resource label unless the target group is
	// attached to the Auto Scaling group.
	//
	// You create the resource label by appending the final portion of the load
	// balancer ARN and the final portion of the target group ARN into a single value,
	// separated by a forward slash (/). The format of the resource label is:
	//
	// app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff .
	//
	// Where:
	//
	//   - app// is the final portion of the load balancer ARN
	//
	//   - targetgroup// is the final portion of the target group ARN.
	//
	// To find the ARN for an Application Load Balancer, use the [DescribeLoadBalancers] API operation. To
	// find the ARN for the target group, use the [DescribeTargetGroups]API operation.
	//
	// [DescribeTargetGroups]: https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html
	// [DescribeLoadBalancers]: https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html
	ResourceLabel *string

	noSmithyDocumentSerde
}

// Represents a predictive scaling policy configuration to use with Amazon EC2
// Auto Scaling.
type PredictiveScalingConfiguration struct {

	// This structure includes the metrics and target utilization to use for
	// predictive scaling.
	//
	// This is an array, but we currently only support a single metric specification.
	// That is, you can specify a target value and a single metric pair, or a target
	// value and one scaling metric and one load metric.
	//
	// This member is required.
	MetricSpecifications []PredictiveScalingMetricSpecification

	// Defines the behavior that should be applied if the forecast capacity approaches
	// or exceeds the maximum capacity of the Auto Scaling group. Defaults to
	// HonorMaxCapacity if not specified.
	//
	// The following are possible values:
	//
	//   - HonorMaxCapacity - Amazon EC2 Auto Scaling cannot scale out capacity higher
	//   than the maximum capacity. The maximum capacity is enforced as a hard limit.
	//
	//   - IncreaseMaxCapacity - Amazon EC2 Auto Scaling can scale out capacity higher
	//   than the maximum capacity when the forecast capacity is close to or exceeds the
	//   maximum capacity. The upper limit is determined by the forecasted capacity and
	//   the value for MaxCapacityBuffer .
	MaxCapacityBreachBehavior PredictiveScalingMaxCapacityBreachBehavior

	// The size of the capacity buffer to use when the forecast capacity is close to
	// or exceeds the maximum capacity. The value is specified as a percentage relative
	// to the forecast capacity. For example, if the buffer is 10, this means a 10
	// percent buffer, such that if the forecast capacity is 50, and the maximum
	// capacity is 40, then the effective maximum capacity is 55.
	//
	// If set to 0, Amazon EC2 Auto Scaling may scale capacity higher than the maximum
	// capacity to equal but not exceed forecast capacity.
	//
	// Required if the MaxCapacityBreachBehavior property is set to IncreaseMaxCapacity
	// , and cannot be used otherwise.
	MaxCapacityBuffer *int32

	// The predictive scaling mode. Defaults to ForecastOnly if not specified.
	Mode PredictiveScalingMode

	// The amount of time, in seconds, by which the instance launch time can be
	// advanced. For example, the forecast says to add capacity at 10:00 AM, and you
	// choose to pre-launch instances by 5 minutes. In that case, the instances will be
	// launched at 9:55 AM. The intention is to give resources time to be provisioned.
	// It can take a few minutes to launch an EC2 instance. The actual amount of time
	// required depends on several factors, such as the size of the instance and
	// whether there are startup scripts to complete.
	//
	// The value must be less than the forecast interval duration of 3600 seconds (60
	// minutes). Defaults to 300 seconds if not specified.
	SchedulingBufferTime *int32

	noSmithyDocumentSerde
}

// Describes a customized capacity metric for a predictive scaling policy.
type PredictiveScalingCustomizedCapacityMetric struct {

	// One or more metric data queries to provide the data points for a capacity
	// metric. Use multiple metric data queries only if you are performing a math
	// expression on returned data.
	//
	// This member is required.
	MetricDataQueries []MetricDataQuery

	noSmithyDocumentSerde
}

// Describes a custom load metric for a predictive scaling policy.
type PredictiveScalingCustomizedLoadMetric struct {

	// One or more metric data queries to provide the data points for a load metric.
	// Use multiple metric data queries only if you are performing a math expression on
	// returned data.
	//
	// This member is required.
	MetricDataQueries []MetricDataQuery

	noSmithyDocumentSerde
}

// Describes a custom scaling metric for a predictive scaling policy.
type PredictiveScalingCustomizedScalingMetric struct {

	// One or more metric data queries to provide the data points for a scaling
	// metric. Use multiple metric data queries only if you are performing a math
	// expression on returned data.
	//
	// This member is required.
	MetricDataQueries []MetricDataQuery

	noSmithyDocumentSerde
}

// This structure specifies the metrics and target utilization settings for a
// predictive scaling policy.
//
// You must specify either a metric pair, or a load metric and a scaling metric
// individually. Specifying a metric pair instead of individual metrics provides a
// simpler way to configure metrics for a scaling policy. You choose the metric
// pair, and the policy automatically knows the correct sum and average statistics
// to use for the load metric and the scaling metric.
//
// Example
//
//   - You create a predictive scaling policy and specify ALBRequestCount as the
//     value for the metric pair and 1000.0 as the target value. For this type of
//     metric, you must provide the metric dimension for the corresponding target
//     group, so you also provide a resource label for the Application Load Balancer
//     target group that is attached to your Auto Scaling group.
//
//   - The number of requests the target group receives per minute provides the
//     load metric, and the request count averaged between the members of the target
//     group provides the scaling metric. In CloudWatch, this refers to the
//     RequestCount and RequestCountPerTarget metrics, respectively.
//
//   - For optimal use of predictive scaling, you adhere to the best practice of
//     using a dynamic scaling policy to automatically scale between the minimum
//     capacity and maximum capacity in response to real-time changes in resource
//     utilization.
//
//   - Amazon EC2 Auto Scaling consumes data points for the load metric over the
//     last 14 days and creates an hourly load forecast for predictive scaling. (A
//     minimum of 24 hours of data is required.)
//
//   - After creating the load forecast, Amazon EC2 Auto Scaling determines when
//     to reduce or increase the capacity of your Auto Scaling group in each hour of
//     the forecast period so that the average number of requests received by each
//     instance is as close to 1000 requests per minute as possible at all times.
//
// For information about using custom metrics with predictive scaling, see [Advanced predictive scaling policy configurations using custom metrics] in the
// Amazon EC2 Auto Scaling User Guide.
//
// [Advanced predictive scaling policy configurations using custom metrics]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/predictive-scaling-customized-metric-specification.html
type PredictiveScalingMetricSpecification struct {

	// Specifies the target utilization.
	//
	// Some metrics are based on a count instead of a percentage, such as the request
	// count for an Application Load Balancer or the number of messages in an SQS
	// queue. If the scaling policy specifies one of these metrics, specify the target
	// utilization as the optimal average request or message count per instance during
	// any one-minute interval.
	//
	// This member is required.
	TargetValue *float64

	// The customized capacity metric specification.
	CustomizedCapacityMetricSpecification *PredictiveScalingCustomizedCapacityMetric

	// The customized load metric specification.
	CustomizedLoadMetricSpecification *PredictiveScalingCustomizedLoadMetric

	// The customized scaling metric specification.
	CustomizedScalingMetricSpecification *PredictiveScalingCustomizedScalingMetric

	// The predefined load metric specification.
	PredefinedLoadMetricSpecification *PredictiveScalingPredefinedLoadMetric

	// The predefined metric pair specification from which Amazon EC2 Auto Scaling
	// determines the appropriate scaling metric and load metric to use.
	PredefinedMetricPairSpecification *PredictiveScalingPredefinedMetricPair

	// The predefined scaling metric specification.
	PredefinedScalingMetricSpecification *PredictiveScalingPredefinedScalingMetric

	noSmithyDocumentSerde
}

// Describes a load metric for a predictive scaling policy.
//
// When returned in the output of DescribePolicies , it indicates that a predictive
// scaling policy uses individually specified load and scaling metrics instead of a
// metric pair.
type PredictiveScalingPredefinedLoadMetric struct {

	// The metric type.
	//
	// This member is required.
	PredefinedMetricType PredefinedLoadMetricType

	// A label that uniquely identifies a specific Application Load Balancer target
	// group from which to determine the request count served by your Auto Scaling
	// group. You can't specify a resource label unless the target group is attached to
	// the Auto Scaling group.
	//
	// You create the resource label by appending the final portion of the load
	// balancer ARN and the final portion of the target group ARN into a single value,
	// separated by a forward slash (/). The format of the resource label is:
	//
	// app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff .
	//
	// Where:
	//
	//   - app// is the final portion of the load balancer ARN
	//
	//   - targetgroup// is the final portion of the target group ARN.
	//
	// To find the ARN for an Application Load Balancer, use the [DescribeLoadBalancers] API operation. To
	// find the ARN for the target group, use the [DescribeTargetGroups]API operation.
	//
	// [DescribeTargetGroups]: https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html
	// [DescribeLoadBalancers]: https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html
	ResourceLabel *string

	noSmithyDocumentSerde
}

// Represents a metric pair for a predictive scaling policy.
type PredictiveScalingPredefinedMetricPair struct {

	// Indicates which metrics to use. There are two different types of metrics for
	// each metric type: one is a load metric and one is a scaling metric. For example,
	// if the metric type is ASGCPUUtilization , the Auto Scaling group's total CPU
	// metric is used as the load metric, and the average CPU metric is used for the
	// scaling metric.
	//
	// This member is required.
	PredefinedMetricType PredefinedMetricPairType

	// A label that uniquely identifies a specific Application Load Balancer target
	// group from which to determine the total and average request count served by your
	// Auto Scaling group. You can't specify a resource label unless the target group
	// is attached to the Auto Scaling group.
	//
	// You create the resource label by appending the final portion of the load
	// balancer ARN and the final portion of the target group ARN into a single value,
	// separated by a forward slash (/). The format of the resource label is:
	//
	// app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff .
	//
	// Where:
	//
	//   - app// is the final portion of the load balancer ARN
	//
	//   - targetgroup// is the final portion of the target group ARN.
	//
	// To find the ARN for an Application Load Balancer, use the [DescribeLoadBalancers] API operation. To
	// find the ARN for the target group, use the [DescribeTargetGroups]API operation.
	//
	// [DescribeTargetGroups]: https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html
	// [DescribeLoadBalancers]: https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html
	ResourceLabel *string

	noSmithyDocumentSerde
}

// Describes a scaling metric for a predictive scaling policy.
//
// When returned in the output of DescribePolicies , it indicates that a predictive
// scaling policy uses individually specified load and scaling metrics instead of a
// metric pair.
type PredictiveScalingPredefinedScalingMetric struct {

	// The metric type.
	//
	// This member is required.
	PredefinedMetricType PredefinedScalingMetricType

	// A label that uniquely identifies a specific Application Load Balancer target
	// group from which to determine the average request count served by your Auto
	// Scaling group. You can't specify a resource label unless the target group is
	// attached to the Auto Scaling group.
	//
	// You create the resource label by appending the final portion of the load
	// balancer ARN and the final portion of the target group ARN into a single value,
	// separated by a forward slash (/). The format of the resource label is:
	//
	// app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff .
	//
	// Where:
	//
	//   - app// is the final portion of the load balancer ARN
	//
	//   - targetgroup// is the final portion of the target group ARN.
	//
	// To find the ARN for an Application Load Balancer, use the [DescribeLoadBalancers] API operation. To
	// find the ARN for the target group, use the [DescribeTargetGroups]API operation.
	//
	// [DescribeTargetGroups]: https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html
	// [DescribeLoadBalancers]: https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html
	ResourceLabel *string

	noSmithyDocumentSerde
}

// Describes a process type.
//
// For more information, see [Scaling processes] in the Amazon EC2 Auto Scaling User Guide.
//
// [Scaling processes]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-suspend-resume-processes.html#process-types
type ProcessType struct {

	// One of the following processes:
	//
	//   - Launch
	//
	//   - Terminate
	//
	//   - AddToLoadBalancer
	//
	//   - AlarmNotification
	//
	//   - AZRebalance
	//
	//   - HealthCheck
	//
	//   - InstanceRefresh
	//
	//   - ReplaceUnhealthy
	//
	//   - ScheduledActions
	//
	// This member is required.
	ProcessName *string

	noSmithyDocumentSerde
}

// Describes the preferences for an instance refresh.
type RefreshPreferences struct {

	// (Optional) The CloudWatch alarm specification. CloudWatch alarms can be used to
	// identify any issues and fail the operation if an alarm threshold is met.
	AlarmSpecification *AlarmSpecification

	// (Optional) Indicates whether to roll back the Auto Scaling group to its
	// previous configuration if the instance refresh fails or a CloudWatch alarm
	// threshold is met. The default is false .
	//
	// A rollback is not supported in the following situations:
	//
	//   - There is no desired configuration specified for the instance refresh.
	//
	//   - The Auto Scaling group has a launch template that uses an Amazon Web
	//   Services Systems Manager parameter instead of an AMI ID for the ImageId
	//   property.
	//
	//   - The Auto Scaling group uses the launch template's $Latest or $Default
	//   version.
	//
	// For more information, see [Undo changes with a rollback] in the Amazon EC2 Auto Scaling User Guide.
	//
	// [Undo changes with a rollback]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/instance-refresh-rollback.html
	AutoRollback *bool

	// (Optional) The amount of time, in seconds, to wait after a checkpoint before
	// continuing. This property is optional, but if you specify a value for it, you
	// must also specify a value for CheckpointPercentages . If you specify a value for
	// CheckpointPercentages and not for CheckpointDelay , the CheckpointDelay
	// defaults to 3600 (1 hour).
	CheckpointDelay *int32

	// (Optional) Threshold values for each checkpoint in ascending order. Each number
	// must be unique. To replace all instances in the Auto Scaling group, the last
	// number in the array must be 100 .
	//
	// For usage examples, see [Adding checkpoints to an instance refresh] in the Amazon EC2 Auto Scaling User Guide.
	//
	// [Adding checkpoints to an instance refresh]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-adding-checkpoints-instance-refresh.html
	CheckpointPercentages []int32

	// A time period, in seconds, during which an instance refresh waits before moving
	// on to replacing the next instance after a new instance enters the InService
	// state.
	//
	// This property is not required for normal usage. Instead, use the
	// DefaultInstanceWarmup property of the Auto Scaling group. The InstanceWarmup
	// and DefaultInstanceWarmup properties work the same way. Only specify this
	// property if you must override the DefaultInstanceWarmup property.
	//
	// If you do not specify this property, the instance warmup by default is the
	// value of the DefaultInstanceWarmup property, if defined (which is recommended
	// in all cases), or the HealthCheckGracePeriod property otherwise.
	InstanceWarmup *int32

	// Specifies the maximum percentage of the group that can be in service and
	// healthy, or pending, to support your workload when replacing instances. The
	// value is expressed as a percentage of the desired capacity of the Auto Scaling
	// group. Value range is 100 to 200.
	//
	// If you specify MaxHealthyPercentage , you must also specify MinHealthyPercentage
	// , and the difference between them cannot be greater than 100. A larger range
	// increases the number of instances that can be replaced at the same time.
	//
	// If you do not specify this property, the default is 100 percent, or the
	// percentage set in the instance maintenance policy for the Auto Scaling group, if
	// defined.
	MaxHealthyPercentage *int32

	// Specifies the minimum percentage of the group to keep in service, healthy, and
	// ready to use to support your workload to allow the operation to continue. The
	// value is expressed as a percentage of the desired capacity of the Auto Scaling
	// group. Value range is 0 to 100.
	//
	// If you do not specify this property, the default is 90 percent, or the
	// percentage set in the instance maintenance policy for the Auto Scaling group, if
	// defined.
	MinHealthyPercentage *int32

	// Choose the behavior that you want Amazon EC2 Auto Scaling to use if instances
	// protected from scale in are found.
	//
	// The following lists the valid values:
	//
	// Refresh Amazon EC2 Auto Scaling replaces instances that are protected from
	// scale in.
	//
	// Ignore Amazon EC2 Auto Scaling ignores instances that are protected from scale
	// in and continues to replace instances that are not protected.
	//
	// Wait (default) Amazon EC2 Auto Scaling waits one hour for you to remove
	// scale-in protection. Otherwise, the instance refresh will fail.
	ScaleInProtectedInstances ScaleInProtectedInstances

	// (Optional) Indicates whether skip matching is enabled. If enabled ( true ), then
	// Amazon EC2 Auto Scaling skips replacing instances that match the desired
	// configuration. If no desired configuration is specified, then it skips replacing
	// instances that have the same launch template and instance types that the Auto
	// Scaling group was using before the start of the instance refresh. The default is
	// false .
	//
	// For more information, see [Use an instance refresh with skip matching] in the Amazon EC2 Auto Scaling User Guide.
	//
	// [Use an instance refresh with skip matching]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh-skip-matching.html
	SkipMatching *bool

	// Choose the behavior that you want Amazon EC2 Auto Scaling to use if instances
	// in Standby state are found.
	//
	// The following lists the valid values:
	//
	// Terminate Amazon EC2 Auto Scaling terminates instances that are in Standby .
	//
	// Ignore Amazon EC2 Auto Scaling ignores instances that are in Standby and
	// continues to replace instances that are in the InService state.
	//
	// Wait (default) Amazon EC2 Auto Scaling waits one hour for you to return the
	// instances to service. Otherwise, the instance refresh will fail.
	StandbyInstances StandbyInstances

	noSmithyDocumentSerde
}

// Details about an instance refresh rollback.
type RollbackDetails struct {

	// Indicates the value of InstancesToUpdate at the time the rollback started.
	InstancesToUpdateOnRollback *int32

	// Indicates the value of PercentageComplete at the time the rollback started.
	PercentageCompleteOnRollback *int32

	// Reports progress on replacing instances in an Auto Scaling group that has a
	// warm pool. This includes separate details for instances in the warm pool and
	// instances in the Auto Scaling group (the live pool).
	ProgressDetailsOnRollback *InstanceRefreshProgressDetails

	// The reason for this instance refresh rollback (for example, whether a manual or
	// automatic rollback was initiated).
	RollbackReason *string

	// The date and time at which the rollback began.
	RollbackStartTime *time.Time

	noSmithyDocumentSerde
}

// Describes a scaling policy.
type ScalingPolicy struct {

	// Specifies how the scaling adjustment is interpreted (for example, an absolute
	// number or a percentage). The valid values are ChangeInCapacity , ExactCapacity ,
	// and PercentChangeInCapacity .
	AdjustmentType *string

	// The CloudWatch alarms related to the policy.
	Alarms []Alarm

	// The name of the Auto Scaling group.
	AutoScalingGroupName *string

	// The duration of the policy's cooldown period, in seconds.
	Cooldown *int32

	// Indicates whether the policy is enabled ( true ) or disabled ( false ).
	Enabled *bool

	// The estimated time, in seconds, until a newly launched instance can contribute
	// to the CloudWatch metrics.
	EstimatedInstanceWarmup *int32

	// The aggregation type for the CloudWatch metrics. The valid values are Minimum ,
	// Maximum , and Average .
	MetricAggregationType *string

	// The minimum value to scale by when the adjustment type is
	// PercentChangeInCapacity .
	MinAdjustmentMagnitude *int32

	// Available for backward compatibility. Use MinAdjustmentMagnitude instead.
	//
	// Deprecated: This member has been deprecated.
	MinAdjustmentStep *int32

	// The Amazon Resource Name (ARN) of the policy.
	PolicyARN *string

	// The name of the scaling policy.
	PolicyName *string

	// One of the following policy types:
	//
	//   - TargetTrackingScaling
	//
	//   - StepScaling
	//
	//   - SimpleScaling (default)
	//
	//   - PredictiveScaling
	//
	// For more information, see [Target tracking scaling policies] and [Step and simple scaling policies] in the Amazon EC2 Auto Scaling User Guide.
	//
	// [Step and simple scaling policies]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html
	// [Target tracking scaling policies]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-target-tracking.html
	PolicyType *string

	// A predictive scaling policy.
	PredictiveScalingConfiguration *PredictiveScalingConfiguration

	// The amount by which to scale, based on the specified adjustment type. A
	// positive value adds to the current capacity while a negative number removes from
	// the current capacity.
	ScalingAdjustment *int32

	// A set of adjustments that enable you to scale based on the size of the alarm
	// breach.
	StepAdjustments []StepAdjustment

	// A target tracking scaling policy.
	TargetTrackingConfiguration *TargetTrackingConfiguration

	noSmithyDocumentSerde
}

// Describes a scheduled scaling action.
type ScheduledUpdateGroupAction struct {

	// The name of the Auto Scaling group.
	AutoScalingGroupName *string

	// The desired capacity is the initial capacity of the Auto Scaling group after
	// the scheduled action runs and the capacity it attempts to maintain.
	DesiredCapacity *int32

	// The date and time in UTC for the recurring schedule to end. For example,
	// "2019-06-01T00:00:00Z" .
	EndTime *time.Time

	// The maximum size of the Auto Scaling group.
	MaxSize *int32

	// The minimum size of the Auto Scaling group.
	MinSize *int32

	// The recurring schedule for the action, in Unix cron syntax format.
	//
	// When StartTime and EndTime are specified with Recurrence , they form the
	// boundaries of when the recurring action starts and stops.
	Recurrence *string

	// The Amazon Resource Name (ARN) of the scheduled action.
	ScheduledActionARN *string

	// The name of the scheduled action.
	ScheduledActionName *string

	// The date and time in UTC for this action to start. For example,
	// "2019-06-01T00:00:00Z" .
	StartTime *time.Time

	// This property is no longer used.
	Time *time.Time

	// The time zone for the cron expression.
	TimeZone *string

	noSmithyDocumentSerde
}

// Describes information used for one or more scheduled scaling action updates in
// a BatchPutScheduledUpdateGroupActionoperation.
type ScheduledUpdateGroupActionRequest struct {

	// The name of the scaling action.
	//
	// This member is required.
	ScheduledActionName *string

	// The desired capacity is the initial capacity of the Auto Scaling group after
	// the scheduled action runs and the capacity it attempts to maintain.
	DesiredCapacity *int32

	// The date and time for the recurring schedule to end, in UTC.
	EndTime *time.Time

	// The maximum size of the Auto Scaling group.
	MaxSize *int32

	// The minimum size of the Auto Scaling group.
	MinSize *int32

	// The recurring schedule for the action, in Unix cron syntax format. This format
	// consists of five fields separated by white spaces: [Minute] [Hour]
	// [Day_of_Month] [Month_of_Year] [Day_of_Week]. The value must be in quotes (for
	// example, "30 0 1 1,6,12 *" ). For more information about this format, see [Crontab].
	//
	// When StartTime and EndTime are specified with Recurrence , they form the
	// boundaries of when the recurring action starts and stops.
	//
	// Cron expressions use Universal Coordinated Time (UTC) by default.
	//
	// [Crontab]: http://crontab.org
	Recurrence *string

	// The date and time for the action to start, in YYYY-MM-DDThh:mm:ssZ format in
	// UTC/GMT only and in quotes (for example, "2019-06-01T00:00:00Z" ).
	//
	// If you specify Recurrence and StartTime , Amazon EC2 Auto Scaling performs the
	// action at this time, and then performs the action based on the specified
	// recurrence.
	//
	// If you try to schedule the action in the past, Amazon EC2 Auto Scaling returns
	// an error message.
	StartTime *time.Time

	// Specifies the time zone for a cron expression. If a time zone is not provided,
	// UTC is used by default.
	//
	// Valid values are the canonical names of the IANA time zones, derived from the
	// IANA Time Zone Database (such as Etc/GMT+9 or Pacific/Tahiti ). For more
	// information, see [https://en.wikipedia.org/wiki/List_of_tz_database_time_zones].
	//
	// [https://en.wikipedia.org/wiki/List_of_tz_database_time_zones]: https://en.wikipedia.org/wiki/List_of_tz_database_time_zones
	TimeZone *string

	noSmithyDocumentSerde
}

// Describes information used to create a step adjustment for a step scaling
// policy.
//
// For the following examples, suppose that you have an alarm with a breach
// threshold of 50:
//
//   - To trigger the adjustment when the metric is greater than or equal to 50
//     and less than 60, specify a lower bound of 0 and an upper bound of 10.
//
//   - To trigger the adjustment when the metric is greater than 40 and less than
//     or equal to 50, specify a lower bound of -10 and an upper bound of 0.
//
// There are a few rules for the step adjustments for your step policy:
//
//   - The ranges of your step adjustments can't overlap or have a gap.
//
//   - At most, one step adjustment can have a null lower bound. If one step
//     adjustment has a negative lower bound, then there must be a step adjustment with
//     a null lower bound.
//
//   - At most, one step adjustment can have a null upper bound. If one step
//     adjustment has a positive upper bound, then there must be a step adjustment with
//     a null upper bound.
//
//   - The upper and lower bound can't be null in the same step adjustment.
//
// For more information, see [Step adjustments] in the Amazon EC2 Auto Scaling User Guide.
//
// [Step adjustments]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-steps
type StepAdjustment struct {

	// The amount by which to scale, based on the specified adjustment type. A
	// positive value adds to the current capacity while a negative number removes from
	// the current capacity. For exact capacity, you must specify a non-negative value.
	//
	// This member is required.
	ScalingAdjustment *int32

	// The lower bound for the difference between the alarm threshold and the
	// CloudWatch metric. If the metric value is above the breach threshold, the lower
	// bound is inclusive (the metric must be greater than or equal to the threshold
	// plus the lower bound). Otherwise, it is exclusive (the metric must be greater
	// than the threshold plus the lower bound). A null value indicates negative
	// infinity.
	MetricIntervalLowerBound *float64

	// The upper bound for the difference between the alarm threshold and the
	// CloudWatch metric. If the metric value is above the breach threshold, the upper
	// bound is exclusive (the metric must be less than the threshold plus the upper
	// bound). Otherwise, it is inclusive (the metric must be less than or equal to the
	// threshold plus the upper bound). A null value indicates positive infinity.
	//
	// The upper bound must be greater than the lower bound.
	MetricIntervalUpperBound *float64

	noSmithyDocumentSerde
}

// Describes an auto scaling process that has been suspended.
//
// For more information, see [Scaling processes] in the Amazon EC2 Auto Scaling User Guide.
//
// [Scaling processes]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-suspend-resume-processes.html#process-types
type SuspendedProcess struct {

	// The name of the suspended process.
	ProcessName *string

	// The reason that the process was suspended.
	SuspensionReason *string

	noSmithyDocumentSerde
}

// Describes a tag for an Auto Scaling group.
type Tag struct {

	// The tag key.
	//
	// This member is required.
	Key *string

	// Determines whether the tag is added to new instances as they are launched in
	// the group.
	PropagateAtLaunch *bool

	// The name of the Auto Scaling group.
	ResourceId *string

	// The type of resource. The only supported value is auto-scaling-group .
	ResourceType *string

	// The tag value.
	Value *string

	noSmithyDocumentSerde
}

// Describes a tag for an Auto Scaling group.
type TagDescription struct {

	// The tag key.
	Key *string

	// Determines whether the tag is added to new instances as they are launched in
	// the group.
	PropagateAtLaunch *bool

	// The name of the group.
	ResourceId *string

	// The type of resource. The only supported value is auto-scaling-group .
	ResourceType *string

	// The tag value.
	Value *string

	noSmithyDocumentSerde
}

// Represents a target tracking scaling policy configuration to use with Amazon
// EC2 Auto Scaling.
type TargetTrackingConfiguration struct {

	// The target value for the metric.
	//
	// Some metrics are based on a count instead of a percentage, such as the request
	// count for an Application Load Balancer or the number of messages in an SQS
	// queue. If the scaling policy specifies one of these metrics, specify the target
	// utilization as the optimal average request or message count per instance during
	// any one-minute interval.
	//
	// This member is required.
	TargetValue *float64

	// A customized metric. You must specify either a predefined metric or a
	// customized metric.
	CustomizedMetricSpecification *CustomizedMetricSpecification

	// Indicates whether scaling in by the target tracking scaling policy is disabled.
	// If scaling in is disabled, the target tracking scaling policy doesn't remove
	// instances from the Auto Scaling group. Otherwise, the target tracking scaling
	// policy can remove instances from the Auto Scaling group. The default is false .
	DisableScaleIn *bool

	// A predefined metric. You must specify either a predefined metric or a
	// customized metric.
	PredefinedMetricSpecification *PredefinedMetricSpecification

	noSmithyDocumentSerde
}

// The metric data to return. Also defines whether this call is returning data for
// one metric only, or whether it is performing a math expression on the values of
// returned metric statistics to create a new time series. A time series is a
// series of data points, each of which is associated with a timestamp.
type TargetTrackingMetricDataQuery struct {

	// A short name that identifies the object's results in the response. This name
	// must be unique among all TargetTrackingMetricDataQuery objects specified for a
	// single scaling policy. If you are performing math expressions on this set of
	// data, this name represents that data and can serve as a variable in the
	// mathematical expression. The valid characters are letters, numbers, and
	// underscores. The first character must be a lowercase letter.
	//
	// This member is required.
	Id *string

	// The math expression to perform on the returned data, if this object is
	// performing a math expression. This expression can use the Id of the other
	// metrics to refer to those metrics, and can also use the Id of other expressions
	// to use the result of those expressions.
	//
	// Conditional: Within each TargetTrackingMetricDataQuery object, you must specify
	// either Expression or MetricStat , but not both.
	Expression *string

	// A human-readable label for this metric or expression. This is especially useful
	// if this is a math expression, so that you know what the value represents.
	Label *string

	// Information about the metric data to return.
	//
	// Conditional: Within each TargetTrackingMetricDataQuery object, you must specify
	// either Expression or MetricStat , but not both.
	MetricStat *TargetTrackingMetricStat

	// Indicates whether to return the timestamps and raw data values of this metric.
	//
	// If you use any math expressions, specify true for this value for only the final
	// math expression that the metric specification is based on. You must specify
	// false for ReturnData for all the other metrics and expressions used in the
	// metric specification.
	//
	// If you are only retrieving metrics and not performing any math expressions, do
	// not specify anything for ReturnData . This sets it to its default ( true ).
	ReturnData *bool

	noSmithyDocumentSerde
}

// This structure defines the CloudWatch metric to return, along with the
// statistic and unit.
//
// For more information about the CloudWatch terminology below, see [Amazon CloudWatch concepts] in the Amazon
// CloudWatch User Guide.
//
// [Amazon CloudWatch concepts]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html
type TargetTrackingMetricStat struct {

	// The metric to use.
	//
	// This member is required.
	Metric *Metric

	// The statistic to return. It can include any CloudWatch statistic or extended
	// statistic. For a list of valid values, see the table in [Statistics]in the Amazon
	// CloudWatch User Guide.
	//
	// The most commonly used metric for scaling is Average .
	//
	// [Statistics]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic
	//
	// This member is required.
	Stat *string

	// The unit to use for the returned data points. For a complete list of the units
	// that CloudWatch supports, see the [MetricDatum]data type in the Amazon CloudWatch API
	// Reference.
	//
	// [MetricDatum]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html
	Unit *string

	noSmithyDocumentSerde
}

// Specifies the minimum and maximum for the TotalLocalStorageGB object when you
// specify InstanceRequirementsfor an Auto Scaling group.
type TotalLocalStorageGBRequest struct {

	// The storage maximum in GB.
	Max *float64

	// The storage minimum in GB.
	Min *float64

	noSmithyDocumentSerde
}

// Identifying information for a traffic source.
type TrafficSourceIdentifier struct {

	// Identifies the traffic source.
	//
	// For Application Load Balancers, Gateway Load Balancers, Network Load Balancers,
	// and VPC Lattice, this will be the Amazon Resource Name (ARN) for a target group
	// in this account and Region. For Classic Load Balancers, this will be the name of
	// the Classic Load Balancer in this account and Region.
	//
	// For example:
	//
	//   - Application Load Balancer ARN:
	//   arn:aws:elasticloadbalancing:us-west-2:123456789012:targetgroup/my-targets/1234567890123456
	//
	//   - Classic Load Balancer name: my-classic-load-balancer
	//
	//   - VPC Lattice ARN:
	//   arn:aws:vpc-lattice:us-west-2:123456789012:targetgroup/tg-1234567890123456
	//
	// To get the ARN of a target group for a Application Load Balancer, Gateway Load
	// Balancer, or Network Load Balancer, or the name of a Classic Load Balancer, use
	// the Elastic Load Balancing [DescribeTargetGroups]and [DescribeLoadBalancers] API operations.
	//
	// To get the ARN of a target group for VPC Lattice, use the VPC Lattice [GetTargetGroup] API
	// operation.
	//
	// [GetTargetGroup]: https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_GetTargetGroup.html
	// [DescribeTargetGroups]: https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html
	// [DescribeLoadBalancers]: https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html
	//
	// This member is required.
	Identifier *string

	// Provides additional context for the value of Identifier .
	//
	// The following lists the valid values:
	//
	//   - elb if Identifier is the name of a Classic Load Balancer.
	//
	//   - elbv2 if Identifier is the ARN of an Application Load Balancer, Gateway Load
	//   Balancer, or Network Load Balancer target group.
	//
	//   - vpc-lattice if Identifier is the ARN of a VPC Lattice target group.
	//
	// Required if the identifier is the name of a Classic Load Balancer.
	Type *string

	noSmithyDocumentSerde
}

// Describes the state of a traffic source.
type TrafficSourceState struct {

	// The unique identifier of the traffic source.
	Identifier *string

	// Describes the current state of a traffic source.
	//
	// The state values are as follows:
	//
	//   - Adding - The Auto Scaling instances are being registered with the load
	//   balancer or target group.
	//
	//   - Added - All Auto Scaling instances are registered with the load balancer or
	//   target group.
	//
	//   - InService - For an Elastic Load Balancing load balancer or target group, at
	//   least one Auto Scaling instance passed an ELB health check. For VPC Lattice,
	//   at least one Auto Scaling instance passed an VPC_LATTICE health check.
	//
	//   - Removing - The Auto Scaling instances are being deregistered from the load
	//   balancer or target group. If connection draining (deregistration delay) is
	//   enabled, Elastic Load Balancing or VPC Lattice waits for in-flight requests to
	//   complete before deregistering the instances.
	//
	//   - Removed - All Auto Scaling instances are deregistered from the load balancer
	//   or target group.
	State *string

	// This is replaced by Identifier .
	//
	// Deprecated: TrafficSource has been replaced by Identifier
	TrafficSource *string

	// Provides additional context for the value of Identifier .
	//
	// The following lists the valid values:
	//
	//   - elb if Identifier is the name of a Classic Load Balancer.
	//
	//   - elbv2 if Identifier is the ARN of an Application Load Balancer, Gateway Load
	//   Balancer, or Network Load Balancer target group.
	//
	//   - vpc-lattice if Identifier is the ARN of a VPC Lattice target group.
	//
	// Required if the identifier is the name of a Classic Load Balancer.
	Type *string

	noSmithyDocumentSerde
}

// Specifies the minimum and maximum for the VCpuCount object when you specify InstanceRequirements
// for an Auto Scaling group.
type VCpuCountRequest struct {

	// The minimum number of vCPUs.
	//
	// This member is required.
	Min *int32

	// The maximum number of vCPUs.
	Max *int32

	noSmithyDocumentSerde
}

// Describes a warm pool configuration.
type WarmPoolConfiguration struct {

	// The instance reuse policy.
	InstanceReusePolicy *InstanceReusePolicy

	// The maximum number of instances that are allowed to be in the warm pool or in
	// any state except Terminated for the Auto Scaling group.
	MaxGroupPreparedCapacity *int32

	// The minimum number of instances to maintain in the warm pool.
	MinSize *int32

	// The instance state to transition to after the lifecycle actions are complete.
	PoolState WarmPoolState

	// The status of a warm pool that is marked for deletion.
	Status WarmPoolStatus

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
