// Code generated by smithy-go-codegen DO NOT EDIT.

package datasync

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/datasync/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a transfer location for an Amazon FSx for NetApp ONTAP file system.
// DataSync can use this location as a source or destination for transferring data.
//
// Before you begin, make sure that you understand how DataSync [accesses FSx for ONTAP file systems].
//
// [accesses FSx for ONTAP file systems]: https://docs.aws.amazon.com/datasync/latest/userguide/create-ontap-location.html#create-ontap-location-access
func (c *Client) CreateLocationFsxOntap(ctx context.Context, params *CreateLocationFsxOntapInput, optFns ...func(*Options)) (*CreateLocationFsxOntapOutput, error) {
	if params == nil {
		params = &CreateLocationFsxOntapInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateLocationFsxOntap", params, optFns, c.addOperationCreateLocationFsxOntapMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateLocationFsxOntapOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateLocationFsxOntapInput struct {

	// Specifies the data transfer protocol that DataSync uses to access your Amazon
	// FSx file system.
	//
	// This member is required.
	Protocol *types.FsxProtocol

	// Specifies the Amazon EC2 security groups that provide access to your file
	// system's preferred subnet.
	//
	// The security groups must allow outbound traffic on the following ports
	// (depending on the protocol you use):
	//
	//   - Network File System (NFS): TCP ports 111, 635, and 2049
	//
	//   - Server Message Block (SMB): TCP port 445
	//
	// Your file system's security groups must also allow inbound traffic on the same
	// ports.
	//
	// This member is required.
	SecurityGroupArns []string

	// Specifies the ARN of the storage virtual machine (SVM) in your file system
	// where you want to copy data to or from.
	//
	// This member is required.
	StorageVirtualMachineArn *string

	// Specifies a path to the file share in the SVM where you'll copy your data.
	//
	// You can specify a junction path (also known as a mount point), qtree path (for
	// NFS file shares), or share name (for SMB file shares). For example, your mount
	// path might be /vol1 , /vol1/tree1 , or /share1 .
	//
	// Don't specify a junction path in the SVM's root volume. For more information,
	// see [Managing FSx for ONTAP storage virtual machines]in the Amazon FSx for NetApp ONTAP User Guide.
	//
	// [Managing FSx for ONTAP storage virtual machines]: https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-svms.html
	Subdirectory *string

	// Specifies labels that help you categorize, filter, and search for your Amazon
	// Web Services resources. We recommend creating at least a name tag for your
	// location.
	Tags []types.TagListEntry

	noSmithyDocumentSerde
}

type CreateLocationFsxOntapOutput struct {

	// Specifies the ARN of the FSx for ONTAP file system location that you create.
	LocationArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateLocationFsxOntapMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateLocationFsxOntap{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateLocationFsxOntap{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateLocationFsxOntap"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCreateLocationFsxOntapValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateLocationFsxOntap(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateLocationFsxOntap(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateLocationFsxOntap",
	}
}
