// Code generated by smithy-go-codegen DO NOT EDIT.

package gamelift

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/gamelift/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates the configuration of a game session queue, which determines how the
// queue processes new game session requests. To update settings, specify the queue
// name to be updated and provide the new settings. When updating destinations,
// provide a complete list of destinations.
//
// # Learn more
//
// [Using Multi-Region Queues]
//
// [Using Multi-Region Queues]: https://docs.aws.amazon.com/gamelift/latest/developerguide/queues-intro.html
func (c *Client) UpdateGameSessionQueue(ctx context.Context, params *UpdateGameSessionQueueInput, optFns ...func(*Options)) (*UpdateGameSessionQueueOutput, error) {
	if params == nil {
		params = &UpdateGameSessionQueueInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateGameSessionQueue", params, optFns, c.addOperationUpdateGameSessionQueueMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateGameSessionQueueOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateGameSessionQueueInput struct {

	// A descriptive label that is associated with game session queue. Queue names
	// must be unique within each Region. You can use either the queue ID or ARN value.
	//
	// This member is required.
	Name *string

	// Information to be added to all events that are related to this game session
	// queue.
	CustomEventData *string

	// A list of fleets and/or fleet aliases that can be used to fulfill game session
	// placement requests in the queue. Destinations are identified by either a fleet
	// ARN or a fleet alias ARN, and are listed in order of placement preference. When
	// updating this list, provide a complete list of destinations.
	Destinations []types.GameSessionQueueDestination

	// A list of locations where a queue is allowed to place new game sessions.
	// Locations are specified in the form of Amazon Web Services Region codes, such as
	// us-west-2 . If this parameter is not set, game sessions can be placed in any
	// queue location. To remove an existing filter configuration, pass in an empty
	// set.
	FilterConfiguration *types.FilterConfiguration

	// An SNS topic ARN that is set up to receive game session placement
	// notifications. See [Setting up notifications for game session placement].
	//
	// [Setting up notifications for game session placement]: https://docs.aws.amazon.com/gamelift/latest/developerguide/queue-notification.html
	NotificationTarget *string

	// A set of policies that act as a sliding cap on player latency. FleetIQ works to
	// deliver low latency for most players in a game session. These policies ensure
	// that no individual player can be placed into a game with unreasonably high
	// latency. Use multiple policies to gradually relax latency requirements a step at
	// a time. Multiple policies are applied based on their maximum allowed latency,
	// starting with the lowest value. When updating policies, provide a complete
	// collection of policies.
	PlayerLatencyPolicies []types.PlayerLatencyPolicy

	// Custom settings to use when prioritizing destinations and locations for game
	// session placements. This configuration replaces the FleetIQ default
	// prioritization process. Priority types that are not explicitly named will be
	// automatically applied at the end of the prioritization process. To remove an
	// existing priority configuration, pass in an empty set.
	PriorityConfiguration *types.PriorityConfiguration

	// The maximum time, in seconds, that a new game session placement request remains
	// in the queue. When a request exceeds this time, the game session placement
	// changes to a TIMED_OUT status. By default, this property is set to 600 .
	TimeoutInSeconds *int32

	noSmithyDocumentSerde
}

type UpdateGameSessionQueueOutput struct {

	// An object that describes the newly updated game session queue.
	GameSessionQueue *types.GameSessionQueue

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateGameSessionQueueMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpUpdateGameSessionQueue{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpUpdateGameSessionQueue{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateGameSessionQueue"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpUpdateGameSessionQueueValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateGameSessionQueue(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateGameSessionQueue(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateGameSessionQueue",
	}
}
