// Code generated by smithy-go-codegen DO NOT EDIT.

package inspector2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/inspector2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves CIS scan result details.
func (c *Client) GetCisScanResultDetails(ctx context.Context, params *GetCisScanResultDetailsInput, optFns ...func(*Options)) (*GetCisScanResultDetailsOutput, error) {
	if params == nil {
		params = &GetCisScanResultDetailsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetCisScanResultDetails", params, optFns, c.addOperationGetCisScanResultDetailsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetCisScanResultDetailsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetCisScanResultDetailsInput struct {

	// The account ID.
	//
	// This member is required.
	AccountId *string

	// The scan ARN.
	//
	// This member is required.
	ScanArn *string

	// The target resource ID.
	//
	// This member is required.
	TargetResourceId *string

	// The filter criteria.
	FilterCriteria *types.CisScanResultDetailsFilterCriteria

	// The maximum number of CIS scan result details to be returned in a single page
	// of results.
	MaxResults *int32

	// The pagination token from a previous request that's used to retrieve the next
	// page of results.
	NextToken *string

	// The sort by order.
	SortBy types.CisScanResultDetailsSortBy

	// The sort order.
	SortOrder types.CisSortOrder

	noSmithyDocumentSerde
}

type GetCisScanResultDetailsOutput struct {

	// The pagination token from a previous request that's used to retrieve the next
	// page of results.
	NextToken *string

	// The scan result details.
	ScanResultDetails []types.CisScanResultDetails

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetCisScanResultDetailsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetCisScanResultDetails{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetCisScanResultDetails{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetCisScanResultDetails"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetCisScanResultDetailsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetCisScanResultDetails(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// GetCisScanResultDetailsAPIClient is a client that implements the
// GetCisScanResultDetails operation.
type GetCisScanResultDetailsAPIClient interface {
	GetCisScanResultDetails(context.Context, *GetCisScanResultDetailsInput, ...func(*Options)) (*GetCisScanResultDetailsOutput, error)
}

var _ GetCisScanResultDetailsAPIClient = (*Client)(nil)

// GetCisScanResultDetailsPaginatorOptions is the paginator options for
// GetCisScanResultDetails
type GetCisScanResultDetailsPaginatorOptions struct {
	// The maximum number of CIS scan result details to be returned in a single page
	// of results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// GetCisScanResultDetailsPaginator is a paginator for GetCisScanResultDetails
type GetCisScanResultDetailsPaginator struct {
	options   GetCisScanResultDetailsPaginatorOptions
	client    GetCisScanResultDetailsAPIClient
	params    *GetCisScanResultDetailsInput
	nextToken *string
	firstPage bool
}

// NewGetCisScanResultDetailsPaginator returns a new
// GetCisScanResultDetailsPaginator
func NewGetCisScanResultDetailsPaginator(client GetCisScanResultDetailsAPIClient, params *GetCisScanResultDetailsInput, optFns ...func(*GetCisScanResultDetailsPaginatorOptions)) *GetCisScanResultDetailsPaginator {
	if params == nil {
		params = &GetCisScanResultDetailsInput{}
	}

	options := GetCisScanResultDetailsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &GetCisScanResultDetailsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *GetCisScanResultDetailsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next GetCisScanResultDetails page.
func (p *GetCisScanResultDetailsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*GetCisScanResultDetailsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.GetCisScanResultDetails(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opGetCisScanResultDetails(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetCisScanResultDetails",
	}
}
