// Code generated by smithy-go-codegen DO NOT EDIT.

package networkmanager

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/networkmanager/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Describes the network resources for the specified global network.
//
// The results include information from the corresponding Describe call for the
// resource, minus any sensitive information such as pre-shared keys.
func (c *Client) GetNetworkResources(ctx context.Context, params *GetNetworkResourcesInput, optFns ...func(*Options)) (*GetNetworkResourcesOutput, error) {
	if params == nil {
		params = &GetNetworkResourcesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetNetworkResources", params, optFns, c.addOperationGetNetworkResourcesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetNetworkResourcesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetNetworkResourcesInput struct {

	// The ID of the global network.
	//
	// This member is required.
	GlobalNetworkId *string

	// The Amazon Web Services account ID.
	AccountId *string

	// The Amazon Web Services Region.
	AwsRegion *string

	// The ID of a core network.
	CoreNetworkId *string

	// The maximum number of results to return.
	MaxResults *int32

	// The token for the next page of results.
	NextToken *string

	// The ARN of the gateway.
	RegisteredGatewayArn *string

	// The ARN of the resource.
	ResourceArn *string

	// The resource type.
	//
	// The following are the supported resource types for Direct Connect:
	//
	//   - dxcon - The definition model is [Connection].
	//
	//   - dx-gateway - The definition model is [DirectConnectGateway].
	//
	//   - dx-vif - The definition model is [VirtualInterface].
	//
	// The following are the supported resource types for Network Manager:
	//
	//   - connection - The definition model is [Connection].
	//
	//   - device - The definition model is [Device].
	//
	//   - link - The definition model is [Link].
	//
	//   - site - The definition model is [Site].
	//
	// The following are the supported resource types for Amazon VPC:
	//
	//   - customer-gateway - The definition model is [CustomerGateway].
	//
	//   - transit-gateway - The definition model is [TransitGateway].
	//
	//   - transit-gateway-attachment - The definition model is [TransitGatewayAttachment].
	//
	//   - transit-gateway-connect-peer - The definition model is [TransitGatewayConnectPeer].
	//
	//   - transit-gateway-route-table - The definition model is [TransitGatewayRouteTable].
	//
	//   - vpn-connection - The definition model is [VpnConnection].
	//
	// [Site]: https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_Site.html
	// [TransitGatewayAttachment]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TransitGatewayAttachment.html
	// [DirectConnectGateway]: https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DirectConnectGateway.html
	// [VirtualInterface]: https://docs.aws.amazon.com/directconnect/latest/APIReference/API_VirtualInterface.html
	// [TransitGatewayRouteTable]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TransitGatewayRouteTable.html
	// [VpnConnection]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_VpnConnection.html
	// [Device]: https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_Device.html
	// [Connection]: https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_Connection.html
	// [TransitGatewayConnectPeer]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TransitGatewayConnectPeer.html
	// [CustomerGateway]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CustomerGateway.html
	// [Link]: https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_Link.html
	// [TransitGateway]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TransitGateway.html
	ResourceType *string

	noSmithyDocumentSerde
}

type GetNetworkResourcesOutput struct {

	// The network resources.
	NetworkResources []types.NetworkResource

	// The token for the next page of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetNetworkResourcesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetNetworkResources{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetNetworkResources{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetNetworkResources"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetNetworkResourcesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetNetworkResources(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// GetNetworkResourcesAPIClient is a client that implements the
// GetNetworkResources operation.
type GetNetworkResourcesAPIClient interface {
	GetNetworkResources(context.Context, *GetNetworkResourcesInput, ...func(*Options)) (*GetNetworkResourcesOutput, error)
}

var _ GetNetworkResourcesAPIClient = (*Client)(nil)

// GetNetworkResourcesPaginatorOptions is the paginator options for
// GetNetworkResources
type GetNetworkResourcesPaginatorOptions struct {
	// The maximum number of results to return.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// GetNetworkResourcesPaginator is a paginator for GetNetworkResources
type GetNetworkResourcesPaginator struct {
	options   GetNetworkResourcesPaginatorOptions
	client    GetNetworkResourcesAPIClient
	params    *GetNetworkResourcesInput
	nextToken *string
	firstPage bool
}

// NewGetNetworkResourcesPaginator returns a new GetNetworkResourcesPaginator
func NewGetNetworkResourcesPaginator(client GetNetworkResourcesAPIClient, params *GetNetworkResourcesInput, optFns ...func(*GetNetworkResourcesPaginatorOptions)) *GetNetworkResourcesPaginator {
	if params == nil {
		params = &GetNetworkResourcesInput{}
	}

	options := GetNetworkResourcesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &GetNetworkResourcesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *GetNetworkResourcesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next GetNetworkResources page.
func (p *GetNetworkResourcesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*GetNetworkResourcesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.GetNetworkResources(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opGetNetworkResources(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetNetworkResources",
	}
}
