// Code generated by smithy-go-codegen DO NOT EDIT.

package personalize

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/personalize/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a batch job that deletes all references to specific users from an
// Amazon Personalize dataset group in batches. You specify the users to delete in
// a CSV file of userIds in an Amazon S3 bucket. After a job completes, Amazon
// Personalize no longer trains on the users’ data and no longer considers the
// users when generating user segments. For more information about creating a data
// deletion job, see [Deleting users].
//
//   - Your input file must be a CSV file with a single USER_ID column that lists
//     the users IDs. For more information about preparing the CSV file, see [Preparing your data deletion file and uploading it to Amazon S3].
//
//   - To give Amazon Personalize permission to access your input CSV file of
//     userIds, you must specify an IAM service role that has permission to read from
//     the data source. This role needs GetObject and ListBucket permissions for the
//     bucket and its content. These permissions are the same as importing data. For
//     information on granting access to your Amazon S3 bucket, see [Giving Amazon Personalize Access to Amazon S3 Resources].
//
// After you create a job, it can take up to a day to delete all references to the
// users from datasets and models. Until the job completes, Amazon Personalize
// continues to use the data when training. And if you use a User Segmentation
// recipe, the users might appear in user segments.
//
// # Status
//
// A data deletion job can have one of the following statuses:
//
//   - PENDING > IN_PROGRESS > COMPLETED -or- FAILED
//
// To get the status of the data deletion job, call [DescribeDataDeletionJob] API operation and specify the
// Amazon Resource Name (ARN) of the job. If the status is FAILED, the response
// includes a failureReason key, which describes why the job failed.
//
// # Related APIs
//
// [ListDataDeletionJobs]
//
// [DescribeDataDeletionJob]
//
// [ListDataDeletionJobs]: https://docs.aws.amazon.com/personalize/latest/dg/API_ListDataDeletionJobs.html
// [Giving Amazon Personalize Access to Amazon S3 Resources]: https://docs.aws.amazon.com/personalize/latest/dg/granting-personalize-s3-access.html
// [Deleting users]: https://docs.aws.amazon.com/personalize/latest/dg/delete-records.html
// [Preparing your data deletion file and uploading it to Amazon S3]: https://docs.aws.amazon.com/personalize/latest/dg/prepare-deletion-input-file.html
// [DescribeDataDeletionJob]: https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDataDeletionJob.html
func (c *Client) CreateDataDeletionJob(ctx context.Context, params *CreateDataDeletionJobInput, optFns ...func(*Options)) (*CreateDataDeletionJobOutput, error) {
	if params == nil {
		params = &CreateDataDeletionJobInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateDataDeletionJob", params, optFns, c.addOperationCreateDataDeletionJobMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateDataDeletionJobOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateDataDeletionJobInput struct {

	// The Amazon S3 bucket that contains the list of userIds of the users to delete.
	//
	// This member is required.
	DataSource *types.DataSource

	// The Amazon Resource Name (ARN) of the dataset group that has the datasets you
	// want to delete records from.
	//
	// This member is required.
	DatasetGroupArn *string

	// The name for the data deletion job.
	//
	// This member is required.
	JobName *string

	// The Amazon Resource Name (ARN) of the IAM role that has permissions to read
	// from the Amazon S3 data source.
	//
	// This member is required.
	RoleArn *string

	// A list of [tags] to apply to the data deletion job.
	//
	// [tags]: https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html
	Tags []types.Tag

	noSmithyDocumentSerde
}

type CreateDataDeletionJobOutput struct {

	// The Amazon Resource Name (ARN) of the data deletion job.
	DataDeletionJobArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateDataDeletionJobMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateDataDeletionJob{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateDataDeletionJob{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateDataDeletionJob"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCreateDataDeletionJobValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateDataDeletionJob(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateDataDeletionJob(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateDataDeletionJob",
	}
}
