// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Information about the contact channel that Incident Manager uses to engage the
// contact.
type ChannelTargetInfo struct {

	// The Amazon Resource Name (ARN) of the contact channel.
	//
	// This member is required.
	ContactChannelId *string

	// The number of minutes to wait to retry sending engagement in the case the
	// engagement initially fails.
	RetryIntervalInMinutes *int32

	noSmithyDocumentSerde
}

// A personal contact or escalation plan that Incident Manager engages during an
// incident.
type Contact struct {

	// The unique and identifiable alias of the contact or escalation plan.
	//
	// This member is required.
	Alias *string

	// The Amazon Resource Name (ARN) of the contact or escalation plan.
	//
	// This member is required.
	ContactArn *string

	// Refers to the type of contact. A single contact is type PERSONAL and an
	// escalation plan is type ESCALATION .
	//
	// This member is required.
	Type ContactType

	// The full name of the contact or escalation plan.
	DisplayName *string

	noSmithyDocumentSerde
}

// The method that Incident Manager uses to engage a contact.
type ContactChannel struct {

	// A Boolean value describing if the contact channel has been activated or not. If
	// the contact channel isn't activated, Incident Manager can't engage the contact
	// through it.
	//
	// This member is required.
	ActivationStatus ActivationStatus

	// The ARN of the contact that contains the contact channel.
	//
	// This member is required.
	ContactArn *string

	// The Amazon Resource Name (ARN) of the contact channel.
	//
	// This member is required.
	ContactChannelArn *string

	// The details that Incident Manager uses when trying to engage the contact
	// channel.
	//
	// This member is required.
	DeliveryAddress *ContactChannelAddress

	// The name of the contact channel.
	//
	// This member is required.
	Name *string

	// The type of the contact channel. Incident Manager supports three contact
	// methods:
	//
	//   - SMS
	//
	//   - VOICE
	//
	//   - EMAIL
	Type ChannelType

	noSmithyDocumentSerde
}

// The details that Incident Manager uses when trying to engage the contact
// channel.
type ContactChannelAddress struct {

	// The format is dependent on the type of the contact channel. The following are
	// the expected formats:
	//
	//   - SMS - '+' followed by the country code and phone number
	//
	//   - VOICE - '+' followed by the country code and phone number
	//
	//   - EMAIL - any standard email format
	SimpleAddress *string

	noSmithyDocumentSerde
}

// The contact that Incident Manager is engaging during an incident.
type ContactTargetInfo struct {

	// A Boolean value determining if the contact's acknowledgement stops the progress
	// of stages in the plan.
	//
	// This member is required.
	IsEssential *bool

	// The Amazon Resource Name (ARN) of the contact.
	ContactId *string

	noSmithyDocumentSerde
}

// Information about when an on-call shift begins and ends.
type CoverageTime struct {

	// Information about when the on-call rotation shift ends.
	End *HandOffTime

	// Information about when the on-call rotation shift begins.
	Start *HandOffTime

	noSmithyDocumentSerde
}

// Information about a resource that another resource is related to or depends on.
//
// For example, if a contact is a member of a rotation, the rotation is a
// dependent entity of the contact.
type DependentEntity struct {

	// The Amazon Resource Names (ARNs) of the dependent resources.
	//
	// This member is required.
	DependentResourceIds []string

	// The type of relationship between one resource and the other resource that it is
	// related to or depends on.
	//
	// This member is required.
	RelationType *string

	noSmithyDocumentSerde
}

// Incident Manager reaching out to a contact or escalation plan to engage contact
// during an incident.
type Engagement struct {

	// The ARN of the escalation plan or contact that Incident Manager is engaging.
	//
	// This member is required.
	ContactArn *string

	// The Amazon Resource Name (ARN) of the engagement.
	//
	// This member is required.
	EngagementArn *string

	// The user that started the engagement.
	//
	// This member is required.
	Sender *string

	// The ARN of the incident that's engaging the contact.
	IncidentId *string

	// The time that the engagement began.
	StartTime *time.Time

	// The time that the engagement ended.
	StopTime *time.Time

	noSmithyDocumentSerde
}

// Details about when an on-call rotation shift begins or ends.
type HandOffTime struct {

	// The hour when an on-call rotation shift begins or ends.
	//
	// This member is required.
	HourOfDay int32

	// The minute when an on-call rotation shift begins or ends.
	//
	// This member is required.
	MinuteOfHour int32

	noSmithyDocumentSerde
}

// Information about on-call rotations that recur monthly.
type MonthlySetting struct {

	// The day of the month when monthly recurring on-call rotations begin.
	//
	// This member is required.
	DayOfMonth *int32

	// The time of day when a monthly recurring on-call shift rotation begins.
	//
	// This member is required.
	HandOffTime *HandOffTime

	noSmithyDocumentSerde
}

// Incident Manager engaging a contact's contact channel.
type Page struct {

	// The ARN of the contact that Incident Manager is engaging.
	//
	// This member is required.
	ContactArn *string

	// The ARN of the engagement that this page is part of.
	//
	// This member is required.
	EngagementArn *string

	// The Amazon Resource Name (ARN) of the page to the contact channel.
	//
	// This member is required.
	PageArn *string

	// The user that started the engagement.
	//
	// This member is required.
	Sender *string

	// The time the message was delivered to the contact channel.
	DeliveryTime *time.Time

	// The ARN of the incident that's engaging the contact channel.
	IncidentId *string

	// The time that the contact channel acknowledged engagement.
	ReadTime *time.Time

	// The time that Incident Manager engaged the contact channel.
	SentTime *time.Time

	noSmithyDocumentSerde
}

// Information about the stages and on-call rotation teams associated with an
// escalation plan or engagement plan.
type Plan struct {

	// The Amazon Resource Names (ARNs) of the on-call rotations associated with the
	// plan.
	RotationIds []string

	// A list of stages that the escalation plan or engagement plan uses to engage
	// contacts and contact methods.
	Stages []Stage

	noSmithyDocumentSerde
}

// Information about contacts and times that an on-call override replaces.
type PreviewOverride struct {

	// Information about the time a rotation override would end.
	EndTime *time.Time

	// Information about contacts to add to an on-call rotation override.
	NewMembers []string

	// Information about the time a rotation override would begin.
	StartTime *time.Time

	noSmithyDocumentSerde
}

// Records events during an engagement.
type Receipt struct {

	// The time receipt was SENT , DELIVERED , or READ .
	//
	// This member is required.
	ReceiptTime *time.Time

	// The type follows the engagement cycle, SENT , DELIVERED , and READ .
	//
	// This member is required.
	ReceiptType ReceiptType

	// The Amazon Resource Name (ARN) of the contact channel Incident Manager engaged.
	ContactChannelArn *string

	// Information provided during the page acknowledgement.
	ReceiptInfo *string

	noSmithyDocumentSerde
}

// Information about when an on-call rotation is in effect and how long the
// rotation period lasts.
type RecurrenceSettings struct {

	// The number of contacts, or shift team members designated to be on call
	// concurrently during a shift. For example, in an on-call schedule containing ten
	// contacts, a value of 2 designates that two of them are on call at any given
	// time.
	//
	// This member is required.
	NumberOfOnCalls *int32

	// The number of days, weeks, or months a single rotation lasts.
	//
	// This member is required.
	RecurrenceMultiplier *int32

	// Information about on-call rotations that recur daily.
	DailySettings []HandOffTime

	// Information about on-call rotations that recur monthly.
	MonthlySettings []MonthlySetting

	// Information about the days of the week included in on-call rotation coverage.
	ShiftCoverages map[string][]CoverageTime

	// Information about on-call rotations that recur weekly.
	WeeklySettings []WeeklySetting

	noSmithyDocumentSerde
}

// Information about the engagement resolution steps. The resolution starts from
// the first contact, which can be an escalation plan, then resolves to an on-call
// rotation, and finally to a personal contact.
//
// The ResolutionContact structure describes the information for each node or step
// in that process. It contains information about different contact types, such as
// the escalation, rotation, and personal contacts.
type ResolutionContact struct {

	// The Amazon Resource Name (ARN) of a contact in the engagement resolution
	// process.
	//
	// This member is required.
	ContactArn *string

	// The type of contact for a resolution step.
	//
	// This member is required.
	Type ContactType

	// The stage in the escalation plan that resolves to this contact.
	StageIndex *int32

	noSmithyDocumentSerde
}

// Information about a rotation in an on-call schedule.
type Rotation struct {

	// The name of the rotation.
	//
	// This member is required.
	Name *string

	// The Amazon Resource Name (ARN) of the rotation.
	//
	// This member is required.
	RotationArn *string

	// The Amazon Resource Names (ARNs) of the contacts assigned to the rotation team.
	ContactIds []string

	// Information about when an on-call rotation is in effect and how long the
	// rotation period lasts.
	Recurrence *RecurrenceSettings

	// The date and time the rotation becomes active.
	StartTime *time.Time

	// The time zone the rotation’s activity is based on, in Internet Assigned Numbers
	// Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or
	// "Asia/Seoul".
	TimeZoneId *string

	noSmithyDocumentSerde
}

// Information about an override specified for an on-call rotation.
type RotationOverride struct {

	// The time a rotation override was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The time a rotation override ends.
	//
	// This member is required.
	EndTime *time.Time

	// The Amazon Resource Names (ARNs) of the contacts assigned to the override of
	// the on-call rotation.
	//
	// This member is required.
	NewContactIds []string

	// The Amazon Resource Name (ARN) of the override to an on-call rotation.
	//
	// This member is required.
	RotationOverrideId *string

	// The time a rotation override begins.
	//
	// This member is required.
	StartTime *time.Time

	noSmithyDocumentSerde
}

// Information about a shift that belongs to an on-call rotation.
type RotationShift struct {

	// The time a shift rotation ends.
	//
	// This member is required.
	EndTime *time.Time

	// The time a shift rotation begins.
	//
	// This member is required.
	StartTime *time.Time

	// The Amazon Resource Names (ARNs) of the contacts who are part of the shift
	// rotation.
	ContactIds []string

	// Additional information about an on-call rotation shift.
	ShiftDetails *ShiftDetails

	// The type of shift rotation.
	Type ShiftType

	noSmithyDocumentSerde
}

// Information about overrides to an on-call rotation shift.
type ShiftDetails struct {

	// The Amazon Resources Names (ARNs) of the contacts who were replaced in a shift
	// when an override was created. If the override is deleted, these contacts are
	// restored to the shift.
	//
	// This member is required.
	OverriddenContactIds []string

	noSmithyDocumentSerde
}

// A set amount of time that an escalation plan or engagement plan engages the
// specified contacts or contact methods.
type Stage struct {

	// The time to wait until beginning the next stage. The duration can only be set
	// to 0 if a target is specified.
	//
	// This member is required.
	DurationInMinutes *int32

	// The contacts or contact methods that the escalation plan or engagement plan is
	// engaging.
	//
	// This member is required.
	Targets []Target

	noSmithyDocumentSerde
}

// A container of a key-value name pair.
type Tag struct {

	// Name of the object key.
	Key *string

	// Value of the tag.
	Value *string

	noSmithyDocumentSerde
}

// The contact or contact channel that's being engaged.
type Target struct {

	// Information about the contact channel Incident Manager is engaging.
	ChannelTargetInfo *ChannelTargetInfo

	// Information about the contact that Incident Manager is engaging.
	ContactTargetInfo *ContactTargetInfo

	noSmithyDocumentSerde
}

// A range of between two set times
type TimeRange struct {

	// The end of the time range.
	EndTime *time.Time

	// The start of the time range.
	StartTime *time.Time

	noSmithyDocumentSerde
}

// Provides information about which field caused the exception.
type ValidationExceptionField struct {

	// Information about what caused the field to cause an exception.
	//
	// This member is required.
	Message *string

	// The name of the field that caused the exception.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Information about rotations that recur weekly.
type WeeklySetting struct {

	// The day of the week when weekly recurring on-call shift rotations begins.
	//
	// This member is required.
	DayOfWeek DayOfWeek

	// The time of day when a weekly recurring on-call shift rotation begins.
	//
	// This member is required.
	HandOffTime *HandOffTime

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
