# frozen_string_literal: true

class RemoveIndexVulnerabilityReadsOnNamespaceTypeSeverityId < Gitlab::Database::Migration[2.2]
  milestone '17.4'

  disable_ddl_transaction!

  TABLE_NAME = :vulnerability_reads
  COLUMNS = %i[namespace_id report_type severity vulnerability_id]
  INDEX_NAME = 'index_vulnerability_reads_on_namespace_type_severity_id'

  def up
    remove_concurrent_index_by_name TABLE_NAME, INDEX_NAME
  end

  def down
    add_concurrent_index TABLE_NAME, COLUMNS, name: INDEX_NAME
  end
end
