/* gmpc-progress.c generated by valac 0.12.0, the Vala compiler
 * generated from gmpc-progress.vala, do not modify */

/* Gnome Music Player Client (GMPC)
 * Copyright (C) 2004-2011 Qball Cow <qball@gmpclient.org>
 * Project homepage: http://gmpclient.org/
 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gtktransition.h>
#include "gmpc-extras.h"
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GmpcProgressPrivate {
	guint total;
	guint current;
	gboolean do_countdown;
	GtkScale* scale;
	GtkLabel* label;
	gulong set_value_handler;
	GtkWindow* tooltip;
	GtkLabel* tooltip_label;
	gint press;
};


static gpointer gmpc_progress_parent_class = NULL;

#define use_transition TRUE
#define GMPC_PROGRESS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GMPC_TYPE_PROGRESS, GmpcProgressPrivate))
enum  {
	GMPC_PROGRESS_DUMMY_PROPERTY,
	GMPC_PROGRESS_HIDE_TEXT
};
static gboolean gmpc_progress_tooltip_expose_event_callback (GmpcProgress* self, GtkWidget* tooltip, GdkEventExpose* event);
static gboolean gmpc_progress_enter_notify_event_callback (GmpcProgress* self, GtkWidget* scale, GdkEventCrossing* event);
static gboolean _gmpc_progress_tooltip_expose_event_callback_gtk_widget_expose_event (GtkWidget* _sender, GdkEventExpose* event, gpointer self);
static gboolean gmpc_progress_motion_notify_event_callback (GmpcProgress* self, GtkWidget* scale, GdkEventMotion* event);
static void gmpc_progress_value_changed (GmpcProgress* self, GtkScale* range);
static gboolean gmpc_progress_button_release_event_callback (GmpcProgress* self, GtkWidget* scale, GdkEventButton* event);
static gboolean gmpc_progress_button_press_event_callback (GmpcProgress* self, GdkEventButton* event, GtkScale* scale);
static gboolean gmpc_progress_scroll_event_callback (GmpcProgress* self, GtkWidget* scale, GdkEventScroll* event);
static GObject * gmpc_progress_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gboolean _gmpc_progress_scroll_event_callback_gtk_widget_scroll_event (GtkWidget* _sender, GdkEventScroll* event, gpointer self);
static gboolean _gmpc_progress_button_release_event_callback_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean _gmpc_progress_motion_notify_event_callback_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self);
static gboolean _gmpc_progress_enter_notify_event_callback_gtk_widget_enter_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self);
static gboolean _gmpc_progress_enter_notify_event_callback_gtk_widget_leave_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self);
static void gmpc_progress_finalize (GObject* obj);
static void _vala_gmpc_progress_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gmpc_progress_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
     * Paint a nice box around it
     */
static gboolean gmpc_progress_tooltip_expose_event_callback (GmpcProgress* self, GtkWidget* tooltip, GdkEventExpose* event) {
	gboolean result = FALSE;
	GtkStyle* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tooltip != NULL, FALSE);
	_tmp0_ = gtk_widget_get_style (tooltip);
	gtk_paint_box (_tmp0_, (*event).window, GTK_STATE_NORMAL, GTK_SHADOW_OUT, NULL, tooltip, "tooltip", 0, 0, tooltip->allocation.width, tooltip->allocation.height);
	result = FALSE;
	return result;
}


static gboolean _gmpc_progress_tooltip_expose_event_callback_gtk_widget_expose_event (GtkWidget* _sender, GdkEventExpose* event, gpointer self) {
	gboolean result;
	result = gmpc_progress_tooltip_expose_event_callback (self, _sender, event);
	return result;
}


static gboolean gmpc_progress_enter_notify_event_callback (GmpcProgress* self, GtkWidget* scale, GdkEventCrossing* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (scale != NULL, FALSE);
	if ((*event).type == GDK_ENTER_NOTIFY) {
		GtkWindow* _tmp0_ = NULL;
		GtkLabel* _tmp1_ = NULL;
		if (self->priv->tooltip != NULL) {
			gtk_object_destroy ((GtkObject*) self->priv->tooltip);
		}
		_tmp0_ = (GtkWindow*) gtk_window_new (GTK_WINDOW_POPUP);
		_g_object_unref0 (self->priv->tooltip);
		self->priv->tooltip = g_object_ref_sink (_tmp0_);
		_tmp1_ = (GtkLabel*) gtk_label_new ("test");
		_g_object_unref0 (self->priv->tooltip_label);
		self->priv->tooltip_label = g_object_ref_sink (_tmp1_);
		gtk_container_add ((GtkContainer*) self->priv->tooltip, (GtkWidget*) self->priv->tooltip_label);
		gtk_container_set_border_width ((GtkContainer*) self->priv->tooltip, (guint) 4);
		gtk_widget_set_app_paintable ((GtkWidget*) self->priv->tooltip, TRUE);
		g_signal_connect_object ((GtkWidget*) self->priv->tooltip, "expose-event", (GCallback) _gmpc_progress_tooltip_expose_event_callback_gtk_widget_expose_event, self, 0);
	}
	if ((*event).type == GDK_LEAVE_NOTIFY) {
		if (self->priv->tooltip != NULL) {
			gtk_object_destroy ((GtkObject*) self->priv->tooltip);
			_g_object_unref0 (self->priv->tooltip);
			self->priv->tooltip = NULL;
		}
	}
	result = FALSE;
	return result;
}


static gboolean gmpc_progress_motion_notify_event_callback (GmpcProgress* self, GtkWidget* scale, GdkEventMotion* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (scale != NULL, FALSE);
	if ((*event).type == GDK_MOTION_NOTIFY) {
		if (self->priv->tooltip != NULL) {
			gint e_hour = 0;
			gint e_minutes = 0;
			gint e_seconds = 0;
			gint t_hour;
			gint t_minutes;
			gint t_seconds;
			gchar* _tmp0_;
			gchar* a;
			GtkStyle* _tmp1_ = NULL;
			guint p;
			guint _tmp2_ = 0U;
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_;
			gchar* _tmp9_;
			t_hour = ((gint) self->priv->total) / 3600;
			t_minutes = (((gint) self->priv->total) % 3600) / 60;
			t_seconds = ((gint) self->priv->total) % 60;
			_tmp0_ = g_strdup ("");
			a = _tmp0_;
			_tmp1_ = gtk_widget_get_style (scale);
			p = (guint) (self->priv->total * ((*event).x / ((gdouble) (scale->allocation.width - _tmp1_->xthickness))));
			if (p > self->priv->total) {
				_tmp2_ = self->priv->total;
			} else {
				_tmp2_ = p;
			}
			p = _tmp2_;
			if (self->priv->do_countdown) {
				gchar* _tmp3_;
				_tmp3_ = g_strconcat (a, "-", NULL);
				_g_free0 (a);
				a = _tmp3_;
				p = self->priv->total - p;
			}
			e_hour = ((gint) p) / 3600;
			e_minutes = ((gint) (p % 3600)) / 60;
			e_seconds = (gint) (p % 60);
			if (e_hour > 0) {
				gchar* _tmp4_ = NULL;
				gchar* _tmp5_;
				gchar* _tmp6_;
				_tmp4_ = g_strdup_printf ("%02i:", e_hour);
				_tmp5_ = _tmp4_;
				_tmp6_ = g_strconcat (a, _tmp5_, NULL);
				_g_free0 (a);
				a = _tmp6_;
				_g_free0 (_tmp5_);
			}
			_tmp7_ = g_strdup_printf ("%02i:%02i", e_minutes, e_seconds);
			_tmp8_ = _tmp7_;
			_tmp9_ = g_strconcat (a, _tmp8_, NULL);
			_g_free0 (a);
			a = _tmp9_;
			_g_free0 (_tmp8_);
			if (self->priv->total > 0) {
				gchar* _tmp10_;
				gchar* _tmp14_ = NULL;
				gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp10_ = g_strconcat (a, " - ", NULL);
				_g_free0 (a);
				a = _tmp10_;
				if (t_hour > 0) {
					gchar* _tmp11_ = NULL;
					gchar* _tmp12_;
					gchar* _tmp13_;
					_tmp11_ = g_strdup_printf ("%02i:", t_hour);
					_tmp12_ = _tmp11_;
					_tmp13_ = g_strconcat (a, _tmp12_, NULL);
					_g_free0 (a);
					a = _tmp13_;
					_g_free0 (_tmp12_);
				}
				_tmp14_ = g_strdup_printf ("%02i:%02i", t_minutes, t_seconds);
				_tmp15_ = _tmp14_;
				_tmp16_ = g_strconcat (a, _tmp15_, NULL);
				_g_free0 (a);
				a = _tmp16_;
				_g_free0 (_tmp15_);
			}
			if (self->priv->do_countdown) {
				gint _tmp17_;
				_tmp17_ = strlen (a);
				gtk_label_set_width_chars (self->priv->tooltip_label, (gint) _tmp17_);
			} else {
				gint _tmp18_;
				_tmp18_ = strlen (a);
				gtk_label_set_width_chars (self->priv->tooltip_label, ((gint) _tmp18_) + 1);
			}
			gtk_label_set_text (self->priv->tooltip_label, a);
			gtk_widget_show_all ((GtkWidget*) self->priv->tooltip);
			gtk_widget_realize ((GtkWidget*) self->priv->tooltip);
			gtk_window_move (self->priv->tooltip, ((gint) (*event).x_root) - (((GtkWidget*) self->priv->tooltip)->allocation.width / 2), ((gint) (*event).y_root) + ((GtkWidget*) self->priv->tooltip)->allocation.height);
			_g_free0 (a);
		}
	}
	result = FALSE;
	return result;
}


static void gmpc_progress_value_changed (GmpcProgress* self, GtkScale* range) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (range != NULL);
	if (self->priv->total > 0) {
		gdouble _tmp0_;
		guint seconds;
		_tmp0_ = gtk_range_get_value ((GtkRange*) range);
		seconds = (guint) (self->priv->total * _tmp0_);
		if (seconds != self->priv->current) {
			g_signal_emit_by_name (self, "seek-event", seconds);
		}
	}
}


static gboolean gmpc_progress_button_release_event_callback (GmpcProgress* self, GtkWidget* scale, GdkEventButton* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (scale != NULL, FALSE);
	self->priv->press--;
	result = FALSE;
	return result;
}


static gboolean gmpc_progress_button_press_event_callback (GmpcProgress* self, GdkEventButton* event, GtkScale* scale) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (scale != NULL, FALSE);
	self->priv->press++;
	if ((*event).type == GDK_BUTTON_PRESS) {
		gboolean _tmp0_ = FALSE;
		if ((*event).button == 3) {
			guint cur;
			guint tot;
			self->priv->do_countdown = !self->priv->do_countdown;
			cur = self->priv->current;
			tot = self->priv->total;
			self->priv->current = (guint) 0;
			self->priv->total = self->priv->current;
			gmpc_progress_set_time (self, tot, cur);
		}
		if ((*event).button == 2) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = (*event).button == 1;
		}
		if (_tmp0_) {
			GtkStyle* _tmp1_ = NULL;
			guint p;
			guint _tmp2_ = 0U;
			_tmp1_ = gtk_widget_get_style ((GtkWidget*) scale);
			p = (guint) (self->priv->total * ((*event).x / ((gdouble) (((GtkWidget*) scale)->allocation.width - _tmp1_->xthickness))));
			if (p > self->priv->total) {
				_tmp2_ = self->priv->total;
			} else {
				_tmp2_ = p;
			}
			p = _tmp2_;
			g_signal_emit_by_name (self, "seek-event", p);
			result = TRUE;
			return result;
		}
	} else {
		if ((*event).type == GDK_2BUTTON_PRESS) {
			gboolean _tmp3_ = FALSE;
			if ((*event).button == 2) {
				_tmp3_ = TRUE;
			} else {
				_tmp3_ = (*event).button == 1;
			}
			if (_tmp3_) {
				GtkStyle* _tmp4_ = NULL;
				guint p;
				guint _tmp5_ = 0U;
				_tmp4_ = gtk_widget_get_style ((GtkWidget*) scale);
				p = (guint) (self->priv->total * ((*event).x / ((gdouble) (((GtkWidget*) scale)->allocation.width - _tmp4_->xthickness))));
				if (p > self->priv->total) {
					_tmp5_ = self->priv->total;
				} else {
					_tmp5_ = p;
				}
				p = _tmp5_;
				g_signal_emit_by_name (self, "seek-event", p);
				result = TRUE;
				return result;
			}
		}
	}
	result = FALSE;
	return result;
}


static gboolean gmpc_progress_scroll_event_callback (GmpcProgress* self, GtkWidget* scale, GdkEventScroll* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (scale != NULL, FALSE);
	if ((*event).direction == GDK_SCROLL_UP) {
		g_signal_emit_by_name (self, "seek-event", self->priv->current + 5);
	} else {
		if ((*event).direction == GDK_SCROLL_DOWN) {
			g_signal_emit_by_name (self, "seek-event", self->priv->current - 5);
		}
	}
	result = FALSE;
	return result;
}


void gmpc_progress_set_time (GmpcProgress* self, guint total, guint current) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->press > 0) {
		return;
	}
	if (self->priv->total != total) {
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->scale, total > 0);
	}
	if (self->priv->total != total) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->current != current;
	}
	if (_tmp0_) {
		gboolean _tmp1_;
		self->priv->total = total;
		self->priv->current = current;
		g_signal_handler_block (self->priv->scale, self->priv->set_value_handler);
		if (self->priv->total > 0) {
			gtk_range_set_value ((GtkRange*) self->priv->scale, self->priv->current / ((gdouble) self->priv->total));
		} else {
			gtk_range_set_value ((GtkRange*) self->priv->scale, 0.0);
		}
		g_signal_handler_unblock (self->priv->scale, self->priv->set_value_handler);
		_tmp1_ = gmpc_progress_get_hide_text (self);
		if (_tmp1_ == FALSE) {
			gint e_hour = 0;
			gint e_minutes = 0;
			gint e_seconds = 0;
			gint t_hour;
			gint t_minutes;
			gint t_seconds;
			gchar* _tmp2_;
			gchar* a;
			guint p;
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_;
			gchar* _tmp9_;
			t_hour = ((gint) self->priv->total) / 3600;
			t_minutes = (((gint) self->priv->total) % 3600) / 60;
			t_seconds = ((gint) self->priv->total) % 60;
			_tmp2_ = g_strdup ("");
			a = _tmp2_;
			p = self->priv->current;
			if (self->priv->do_countdown) {
				gchar* _tmp3_;
				p = self->priv->total - self->priv->current;
				_tmp3_ = g_strconcat (a, "-", NULL);
				_g_free0 (a);
				a = _tmp3_;
			}
			e_hour = ((gint) p) / 3600;
			e_minutes = ((gint) (p % 3600)) / 60;
			e_seconds = (gint) (p % 60);
			if (e_hour > 0) {
				gchar* _tmp4_ = NULL;
				gchar* _tmp5_;
				gchar* _tmp6_;
				_tmp4_ = g_strdup_printf ("%02i:", e_hour);
				_tmp5_ = _tmp4_;
				_tmp6_ = g_strconcat (a, _tmp5_, NULL);
				_g_free0 (a);
				a = _tmp6_;
				_g_free0 (_tmp5_);
			}
			_tmp7_ = g_strdup_printf ("%02i:%02i", e_minutes, e_seconds);
			_tmp8_ = _tmp7_;
			_tmp9_ = g_strconcat (a, _tmp8_, NULL);
			_g_free0 (a);
			a = _tmp9_;
			_g_free0 (_tmp8_);
			if (self->priv->total > 0) {
				gchar* _tmp10_;
				gchar* _tmp14_ = NULL;
				gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp10_ = g_strconcat (a, " - ", NULL);
				_g_free0 (a);
				a = _tmp10_;
				if (t_hour > 0) {
					gchar* _tmp11_ = NULL;
					gchar* _tmp12_;
					gchar* _tmp13_;
					_tmp11_ = g_strdup_printf ("%02i:", t_hour);
					_tmp12_ = _tmp11_;
					_tmp13_ = g_strconcat (a, _tmp12_, NULL);
					_g_free0 (a);
					a = _tmp13_;
					_g_free0 (_tmp12_);
				}
				_tmp14_ = g_strdup_printf ("%02i:%02i", t_minutes, t_seconds);
				_tmp15_ = _tmp14_;
				_tmp16_ = g_strconcat (a, _tmp15_, NULL);
				_g_free0 (a);
				a = _tmp16_;
				_g_free0 (_tmp15_);
			}
			if (self->priv->do_countdown) {
				gint _tmp17_;
				_tmp17_ = strlen (a);
				gtk_label_set_width_chars (self->priv->label, (gint) _tmp17_);
			} else {
				gint _tmp18_;
				_tmp18_ = strlen (a);
				gtk_label_set_width_chars (self->priv->label, ((gint) _tmp18_) + 1);
			}
			gtk_label_set_text (self->priv->label, a);
			_g_free0 (a);
		}
	}
}


GmpcProgress* gmpc_progress_construct (GType object_type) {
	GmpcProgress * self = NULL;
	self = (GmpcProgress*) g_object_new (object_type, NULL);
	return self;
}


GmpcProgress* gmpc_progress_new (void) {
	return gmpc_progress_construct (GMPC_TYPE_PROGRESS);
}


gboolean gmpc_progress_get_hide_text (GmpcProgress* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->_hide_text;
	return result;
}


void gmpc_progress_set_hide_text (GmpcProgress* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->_hide_text = value;
	if (self->_hide_text) {
		gtk_widget_hide ((GtkWidget*) self->priv->label);
	} else {
		gtk_widget_show ((GtkWidget*) self->priv->label);
	}
	g_object_notify ((GObject *) self, "hide-text");
}


static gboolean _gmpc_progress_scroll_event_callback_gtk_widget_scroll_event (GtkWidget* _sender, GdkEventScroll* event, gpointer self) {
	gboolean result;
	result = gmpc_progress_scroll_event_callback (self, _sender, event);
	return result;
}


static gboolean _gmpc_progress_button_release_event_callback_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = gmpc_progress_button_release_event_callback (self, _sender, event);
	return result;
}


static gboolean _gmpc_progress_motion_notify_event_callback_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self) {
	gboolean result;
	result = gmpc_progress_motion_notify_event_callback (self, _sender, event);
	return result;
}


static gboolean _gmpc_progress_enter_notify_event_callback_gtk_widget_enter_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self) {
	gboolean result;
	result = gmpc_progress_enter_notify_event_callback (self, _sender, event);
	return result;
}


static gboolean _gmpc_progress_enter_notify_event_callback_gtk_widget_leave_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self) {
	gboolean result;
	result = gmpc_progress_enter_notify_event_callback (self, _sender, event);
	return result;
}


static GObject * gmpc_progress_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GmpcProgress * self;
	GtkHScale* _tmp0_ = NULL;
	gulong _tmp1_;
	GtkLabel* _tmp2_ = NULL;
	parent_class = G_OBJECT_CLASS (gmpc_progress_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GMPC_PROGRESS (obj);
	_tmp0_ = (GtkHScale*) gtk_hscale_new (NULL);
	_g_object_unref0 (self->priv->scale);
	self->priv->scale = (GtkScale*) g_object_ref_sink (_tmp0_);
	gtk_range_set_range ((GtkRange*) self->priv->scale, 0.0, 1.0);
	gtk_scale_set_draw_value (self->priv->scale, FALSE);
	_tmp1_ = g_signal_connect_swapped (self->priv->scale, "value_changed", (GCallback) gmpc_progress_value_changed, self);
	self->priv->set_value_handler = _tmp1_;
	gtk_range_set_update_policy ((GtkRange*) self->priv->scale, GTK_UPDATE_DISCONTINUOUS);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->scale, FALSE);
	gtk_box_set_spacing ((GtkBox*) self, 0);
	gtk_widget_add_events ((GtkWidget*) self->priv->scale, (gint) GDK_SCROLL_MASK);
	gtk_widget_add_events ((GtkWidget*) self->priv->scale, (gint) GDK_POINTER_MOTION_MASK);
	gtk_widget_add_events ((GtkWidget*) self->priv->scale, (gint) GDK_ENTER_NOTIFY_MASK);
	gtk_widget_add_events ((GtkWidget*) self->priv->scale, (gint) GDK_LEAVE_NOTIFY_MASK);
	g_signal_connect_object ((GtkWidget*) self->priv->scale, "scroll-event", (GCallback) _gmpc_progress_scroll_event_callback_gtk_widget_scroll_event, self, 0);
	g_signal_connect_object (self->priv->scale, "button-press-event", (GCallback) gmpc_progress_button_press_event_callback, (GObject*) self, G_CONNECT_SWAPPED | G_CONNECT_AFTER);
	g_signal_connect_object ((GtkWidget*) self->priv->scale, "button-release-event", (GCallback) _gmpc_progress_button_release_event_callback_gtk_widget_button_release_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self->priv->scale, "motion-notify-event", (GCallback) _gmpc_progress_motion_notify_event_callback_gtk_widget_motion_notify_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self->priv->scale, "enter-notify-event", (GCallback) _gmpc_progress_enter_notify_event_callback_gtk_widget_enter_notify_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self->priv->scale, "leave-notify-event", (GCallback) _gmpc_progress_enter_notify_event_callback_gtk_widget_leave_notify_event, self, 0);
	_tmp2_ = (GtkLabel*) gtk_label_new ("");
	_g_object_unref0 (self->priv->label);
	self->priv->label = g_object_ref_sink (_tmp2_);
	gtk_misc_set_alignment ((GtkMisc*) self->priv->label, 0.5f, 0.5f);
	gtk_widget_set_no_show_all ((GtkWidget*) self->priv->label, TRUE);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) self->priv->scale, TRUE, TRUE, (guint) 0);
	gtk_box_pack_end ((GtkBox*) self, (GtkWidget*) self->priv->label, FALSE, FALSE, (guint) 0);
	gtk_widget_show ((GtkWidget*) self->priv->scale);
	gtk_widget_show ((GtkWidget*) self->priv->label);
	gtk_widget_show ((GtkWidget*) self);
	return obj;
}


static void gmpc_progress_class_init (GmpcProgressClass * klass) {
	gmpc_progress_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GmpcProgressPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_gmpc_progress_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gmpc_progress_set_property;
	G_OBJECT_CLASS (klass)->constructor = gmpc_progress_constructor;
	G_OBJECT_CLASS (klass)->finalize = gmpc_progress_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GMPC_PROGRESS_HIDE_TEXT, g_param_spec_boolean ("hide-text", "hide-text", "hide-text", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("seek_event", GMPC_TYPE_PROGRESS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
}


static void gmpc_progress_instance_init (GmpcProgress * self) {
	self->priv = GMPC_PROGRESS_GET_PRIVATE (self);
	self->priv->total = (guint) 0;
	self->priv->current = (guint) 0;
	self->priv->do_countdown = FALSE;
	self->_hide_text = FALSE;
	self->priv->scale = NULL;
	self->priv->label = NULL;
	self->priv->set_value_handler = (gulong) 0;
	self->priv->tooltip = NULL;
	self->priv->tooltip_label = NULL;
	self->priv->press = 0;
}


static void gmpc_progress_finalize (GObject* obj) {
	GmpcProgress * self;
	self = GMPC_PROGRESS (obj);
	if (self->priv->tooltip != NULL) {
		gtk_object_destroy ((GtkObject*) self->priv->tooltip);
		_g_object_unref0 (self->priv->tooltip);
		self->priv->tooltip = NULL;
	}
	_g_object_unref0 (self->priv->scale);
	_g_object_unref0 (self->priv->label);
	_g_object_unref0 (self->priv->tooltip);
	_g_object_unref0 (self->priv->tooltip_label);
	G_OBJECT_CLASS (gmpc_progress_parent_class)->finalize (obj);
}


GType gmpc_progress_get_type (void) {
	static volatile gsize gmpc_progress_type_id__volatile = 0;
	if (g_once_init_enter (&gmpc_progress_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GmpcProgressClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gmpc_progress_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GmpcProgress), 0, (GInstanceInitFunc) gmpc_progress_instance_init, NULL };
		GType gmpc_progress_type_id;
		gmpc_progress_type_id = g_type_register_static (GTK_TYPE_VBOX, "GmpcProgress", &g_define_type_info, 0);
		g_once_init_leave (&gmpc_progress_type_id__volatile, gmpc_progress_type_id);
	}
	return gmpc_progress_type_id__volatile;
}


static void _vala_gmpc_progress_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GmpcProgress * self;
	self = GMPC_PROGRESS (object);
	switch (property_id) {
		case GMPC_PROGRESS_HIDE_TEXT:
		g_value_set_boolean (value, gmpc_progress_get_hide_text (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gmpc_progress_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GmpcProgress * self;
	self = GMPC_PROGRESS (object);
	switch (property_id) {
		case GMPC_PROGRESS_HIDE_TEXT:
		gmpc_progress_set_hide_text (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



