/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "gf-nautilus2-gen.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.Nautilus.FileOperations2
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:GfNautilus2Gen
 * @title: GfNautilus2Gen
 * @short_description: Generated C code for the org.gnome.Nautilus.FileOperations2 D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-Nautilus-FileOperations2.top_of_page">org.gnome.Nautilus.FileOperations2</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.gnome.Nautilus.FileOperations2 ---- */

static const _ExtendedGDBusArgInfo _gf_nautilus2_gen_method_info_copy_uris_IN_ARG_sources =
{
  {
    -1,
    (gchar *) "sources",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gf_nautilus2_gen_method_info_copy_uris_IN_ARG_destination =
{
  {
    -1,
    (gchar *) "destination",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gf_nautilus2_gen_method_info_copy_uris_IN_ARG_platform_data =
{
  {
    -1,
    (gchar *) "platform_data",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gf_nautilus2_gen_method_info_copy_uris_IN_ARG_pointers[] =
{
  &_gf_nautilus2_gen_method_info_copy_uris_IN_ARG_sources.parent_struct,
  &_gf_nautilus2_gen_method_info_copy_uris_IN_ARG_destination.parent_struct,
  &_gf_nautilus2_gen_method_info_copy_uris_IN_ARG_platform_data.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gf_nautilus2_gen_method_info_copy_uris =
{
  {
    -1,
    (gchar *) "CopyURIs",
    (GDBusArgInfo **) &_gf_nautilus2_gen_method_info_copy_uris_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-copy-uris",
  FALSE
};

static const _ExtendedGDBusArgInfo _gf_nautilus2_gen_method_info_move_uris_IN_ARG_sources =
{
  {
    -1,
    (gchar *) "sources",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gf_nautilus2_gen_method_info_move_uris_IN_ARG_destination =
{
  {
    -1,
    (gchar *) "destination",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gf_nautilus2_gen_method_info_move_uris_IN_ARG_platform_data =
{
  {
    -1,
    (gchar *) "platform_data",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gf_nautilus2_gen_method_info_move_uris_IN_ARG_pointers[] =
{
  &_gf_nautilus2_gen_method_info_move_uris_IN_ARG_sources.parent_struct,
  &_gf_nautilus2_gen_method_info_move_uris_IN_ARG_destination.parent_struct,
  &_gf_nautilus2_gen_method_info_move_uris_IN_ARG_platform_data.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gf_nautilus2_gen_method_info_move_uris =
{
  {
    -1,
    (gchar *) "MoveURIs",
    (GDBusArgInfo **) &_gf_nautilus2_gen_method_info_move_uris_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-move-uris",
  FALSE
};

static const _ExtendedGDBusArgInfo _gf_nautilus2_gen_method_info_empty_trash_IN_ARG_ask_confirmation =
{
  {
    -1,
    (gchar *) "ask_confirmation",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gf_nautilus2_gen_method_info_empty_trash_IN_ARG_platform_data =
{
  {
    -1,
    (gchar *) "platform_data",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gf_nautilus2_gen_method_info_empty_trash_IN_ARG_pointers[] =
{
  &_gf_nautilus2_gen_method_info_empty_trash_IN_ARG_ask_confirmation.parent_struct,
  &_gf_nautilus2_gen_method_info_empty_trash_IN_ARG_platform_data.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gf_nautilus2_gen_method_info_empty_trash =
{
  {
    -1,
    (gchar *) "EmptyTrash",
    (GDBusArgInfo **) &_gf_nautilus2_gen_method_info_empty_trash_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-empty-trash",
  FALSE
};

static const _ExtendedGDBusArgInfo _gf_nautilus2_gen_method_info_trash_uris_IN_ARG_uris =
{
  {
    -1,
    (gchar *) "uris",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gf_nautilus2_gen_method_info_trash_uris_IN_ARG_platform_data =
{
  {
    -1,
    (gchar *) "platform_data",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gf_nautilus2_gen_method_info_trash_uris_IN_ARG_pointers[] =
{
  &_gf_nautilus2_gen_method_info_trash_uris_IN_ARG_uris.parent_struct,
  &_gf_nautilus2_gen_method_info_trash_uris_IN_ARG_platform_data.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gf_nautilus2_gen_method_info_trash_uris =
{
  {
    -1,
    (gchar *) "TrashURIs",
    (GDBusArgInfo **) &_gf_nautilus2_gen_method_info_trash_uris_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-trash-uris",
  FALSE
};

static const _ExtendedGDBusArgInfo _gf_nautilus2_gen_method_info_delete_uris_IN_ARG_uris =
{
  {
    -1,
    (gchar *) "uris",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gf_nautilus2_gen_method_info_delete_uris_IN_ARG_platform_data =
{
  {
    -1,
    (gchar *) "platform_data",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gf_nautilus2_gen_method_info_delete_uris_IN_ARG_pointers[] =
{
  &_gf_nautilus2_gen_method_info_delete_uris_IN_ARG_uris.parent_struct,
  &_gf_nautilus2_gen_method_info_delete_uris_IN_ARG_platform_data.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gf_nautilus2_gen_method_info_delete_uris =
{
  {
    -1,
    (gchar *) "DeleteURIs",
    (GDBusArgInfo **) &_gf_nautilus2_gen_method_info_delete_uris_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-delete-uris",
  FALSE
};

static const _ExtendedGDBusArgInfo _gf_nautilus2_gen_method_info_create_folder_IN_ARG_parent_uri =
{
  {
    -1,
    (gchar *) "parent_uri",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gf_nautilus2_gen_method_info_create_folder_IN_ARG_new_folder_name =
{
  {
    -1,
    (gchar *) "new_folder_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gf_nautilus2_gen_method_info_create_folder_IN_ARG_platform_data =
{
  {
    -1,
    (gchar *) "platform_data",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gf_nautilus2_gen_method_info_create_folder_IN_ARG_pointers[] =
{
  &_gf_nautilus2_gen_method_info_create_folder_IN_ARG_parent_uri.parent_struct,
  &_gf_nautilus2_gen_method_info_create_folder_IN_ARG_new_folder_name.parent_struct,
  &_gf_nautilus2_gen_method_info_create_folder_IN_ARG_platform_data.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gf_nautilus2_gen_method_info_create_folder =
{
  {
    -1,
    (gchar *) "CreateFolder",
    (GDBusArgInfo **) &_gf_nautilus2_gen_method_info_create_folder_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-create-folder",
  FALSE
};

static const _ExtendedGDBusArgInfo _gf_nautilus2_gen_method_info_rename_uri_IN_ARG_uri =
{
  {
    -1,
    (gchar *) "uri",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gf_nautilus2_gen_method_info_rename_uri_IN_ARG_new_name =
{
  {
    -1,
    (gchar *) "new_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gf_nautilus2_gen_method_info_rename_uri_IN_ARG_platform_data =
{
  {
    -1,
    (gchar *) "platform_data",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gf_nautilus2_gen_method_info_rename_uri_IN_ARG_pointers[] =
{
  &_gf_nautilus2_gen_method_info_rename_uri_IN_ARG_uri.parent_struct,
  &_gf_nautilus2_gen_method_info_rename_uri_IN_ARG_new_name.parent_struct,
  &_gf_nautilus2_gen_method_info_rename_uri_IN_ARG_platform_data.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gf_nautilus2_gen_method_info_rename_uri =
{
  {
    -1,
    (gchar *) "RenameURI",
    (GDBusArgInfo **) &_gf_nautilus2_gen_method_info_rename_uri_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-rename-uri",
  FALSE
};

static const _ExtendedGDBusArgInfo _gf_nautilus2_gen_method_info_undo_IN_ARG_platform_data =
{
  {
    -1,
    (gchar *) "platform_data",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gf_nautilus2_gen_method_info_undo_IN_ARG_pointers[] =
{
  &_gf_nautilus2_gen_method_info_undo_IN_ARG_platform_data.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gf_nautilus2_gen_method_info_undo =
{
  {
    -1,
    (gchar *) "Undo",
    (GDBusArgInfo **) &_gf_nautilus2_gen_method_info_undo_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-undo",
  FALSE
};

static const _ExtendedGDBusArgInfo _gf_nautilus2_gen_method_info_redo_IN_ARG_platform_data =
{
  {
    -1,
    (gchar *) "platform_data",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gf_nautilus2_gen_method_info_redo_IN_ARG_pointers[] =
{
  &_gf_nautilus2_gen_method_info_redo_IN_ARG_platform_data.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gf_nautilus2_gen_method_info_redo =
{
  {
    -1,
    (gchar *) "Redo",
    (GDBusArgInfo **) &_gf_nautilus2_gen_method_info_redo_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-redo",
  FALSE
};

static const GDBusMethodInfo * const _gf_nautilus2_gen_method_info_pointers[] =
{
  &_gf_nautilus2_gen_method_info_copy_uris.parent_struct,
  &_gf_nautilus2_gen_method_info_move_uris.parent_struct,
  &_gf_nautilus2_gen_method_info_empty_trash.parent_struct,
  &_gf_nautilus2_gen_method_info_trash_uris.parent_struct,
  &_gf_nautilus2_gen_method_info_delete_uris.parent_struct,
  &_gf_nautilus2_gen_method_info_create_folder.parent_struct,
  &_gf_nautilus2_gen_method_info_rename_uri.parent_struct,
  &_gf_nautilus2_gen_method_info_undo.parent_struct,
  &_gf_nautilus2_gen_method_info_redo.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _gf_nautilus2_gen_property_info_undo_status =
{
  {
    -1,
    (gchar *) "UndoStatus",
    (gchar *) "i",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "undo-status",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _gf_nautilus2_gen_property_info_pointers[] =
{
  &_gf_nautilus2_gen_property_info_undo_status.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _gf_nautilus2_gen_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.Nautilus.FileOperations2",
    (GDBusMethodInfo **) &_gf_nautilus2_gen_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_gf_nautilus2_gen_property_info_pointers,
    NULL
  },
  "nautilus2-gen",
};


/**
 * gf_nautilus2_gen_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-Nautilus-FileOperations2.top_of_page">org.gnome.Nautilus.FileOperations2</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
gf_nautilus2_gen_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_gf_nautilus2_gen_interface_info.parent_struct;
}

/**
 * gf_nautilus2_gen_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #GfNautilus2Gen interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
gf_nautilus2_gen_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "undo-status");
  return property_id_begin - 1;
}



/**
 * GfNautilus2Gen:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Nautilus-FileOperations2.top_of_page">org.gnome.Nautilus.FileOperations2</link>.
 */

/**
 * GfNautilus2GenIface:
 * @parent_iface: The parent interface.
 * @handle_copy_uris: Handler for the #GfNautilus2Gen::handle-copy-uris signal.
 * @handle_create_folder: Handler for the #GfNautilus2Gen::handle-create-folder signal.
 * @handle_delete_uris: Handler for the #GfNautilus2Gen::handle-delete-uris signal.
 * @handle_empty_trash: Handler for the #GfNautilus2Gen::handle-empty-trash signal.
 * @handle_move_uris: Handler for the #GfNautilus2Gen::handle-move-uris signal.
 * @handle_redo: Handler for the #GfNautilus2Gen::handle-redo signal.
 * @handle_rename_uri: Handler for the #GfNautilus2Gen::handle-rename-uri signal.
 * @handle_trash_uris: Handler for the #GfNautilus2Gen::handle-trash-uris signal.
 * @handle_undo: Handler for the #GfNautilus2Gen::handle-undo signal.
 * @get_undo_status: Getter for the #GfNautilus2Gen:undo-status property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Nautilus-FileOperations2.top_of_page">org.gnome.Nautilus.FileOperations2</link>.
 */

typedef GfNautilus2GenIface GfNautilus2GenInterface;
G_DEFINE_INTERFACE (GfNautilus2Gen, gf_nautilus2_gen, G_TYPE_OBJECT)

static void
gf_nautilus2_gen_default_init (GfNautilus2GenIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * GfNautilus2Gen::handle-copy-uris:
   * @object: A #GfNautilus2Gen.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_sources: Argument passed by remote caller.
   * @arg_destination: Argument passed by remote caller.
   * @arg_platform_data: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Nautilus-FileOperations2.CopyURIs">CopyURIs()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gf_nautilus2_gen_complete_copy_uris() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-copy-uris",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GfNautilus2GenIface, handle_copy_uris),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRV, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * GfNautilus2Gen::handle-move-uris:
   * @object: A #GfNautilus2Gen.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_sources: Argument passed by remote caller.
   * @arg_destination: Argument passed by remote caller.
   * @arg_platform_data: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Nautilus-FileOperations2.MoveURIs">MoveURIs()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gf_nautilus2_gen_complete_move_uris() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-move-uris",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GfNautilus2GenIface, handle_move_uris),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRV, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * GfNautilus2Gen::handle-empty-trash:
   * @object: A #GfNautilus2Gen.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_ask_confirmation: Argument passed by remote caller.
   * @arg_platform_data: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Nautilus-FileOperations2.EmptyTrash">EmptyTrash()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gf_nautilus2_gen_complete_empty_trash() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-empty-trash",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GfNautilus2GenIface, handle_empty_trash),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_BOOLEAN, G_TYPE_VARIANT);

  /**
   * GfNautilus2Gen::handle-trash-uris:
   * @object: A #GfNautilus2Gen.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_uris: Argument passed by remote caller.
   * @arg_platform_data: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Nautilus-FileOperations2.TrashURIs">TrashURIs()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gf_nautilus2_gen_complete_trash_uris() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-trash-uris",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GfNautilus2GenIface, handle_trash_uris),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRV, G_TYPE_VARIANT);

  /**
   * GfNautilus2Gen::handle-delete-uris:
   * @object: A #GfNautilus2Gen.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_uris: Argument passed by remote caller.
   * @arg_platform_data: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Nautilus-FileOperations2.DeleteURIs">DeleteURIs()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gf_nautilus2_gen_complete_delete_uris() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-delete-uris",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GfNautilus2GenIface, handle_delete_uris),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRV, G_TYPE_VARIANT);

  /**
   * GfNautilus2Gen::handle-create-folder:
   * @object: A #GfNautilus2Gen.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_parent_uri: Argument passed by remote caller.
   * @arg_new_folder_name: Argument passed by remote caller.
   * @arg_platform_data: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Nautilus-FileOperations2.CreateFolder">CreateFolder()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gf_nautilus2_gen_complete_create_folder() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-create-folder",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GfNautilus2GenIface, handle_create_folder),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * GfNautilus2Gen::handle-rename-uri:
   * @object: A #GfNautilus2Gen.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_uri: Argument passed by remote caller.
   * @arg_new_name: Argument passed by remote caller.
   * @arg_platform_data: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Nautilus-FileOperations2.RenameURI">RenameURI()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gf_nautilus2_gen_complete_rename_uri() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-rename-uri",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GfNautilus2GenIface, handle_rename_uri),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * GfNautilus2Gen::handle-undo:
   * @object: A #GfNautilus2Gen.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_platform_data: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Nautilus-FileOperations2.Undo">Undo()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gf_nautilus2_gen_complete_undo() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-undo",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GfNautilus2GenIface, handle_undo),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * GfNautilus2Gen::handle-redo:
   * @object: A #GfNautilus2Gen.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_platform_data: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Nautilus-FileOperations2.Redo">Redo()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gf_nautilus2_gen_complete_redo() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-redo",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GfNautilus2GenIface, handle_redo),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * GfNautilus2Gen:undo-status:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Nautilus-FileOperations2.UndoStatus">"UndoStatus"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_int ("undo-status", "UndoStatus", "UndoStatus", G_MININT32, G_MAXINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * gf_nautilus2_gen_get_undo_status: (skip)
 * @object: A #GfNautilus2Gen.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Nautilus-FileOperations2.UndoStatus">"UndoStatus"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gint 
gf_nautilus2_gen_get_undo_status (GfNautilus2Gen *object)
{
  return GF_NAUTILUS2_GEN_GET_IFACE (object)->get_undo_status (object);
}

/**
 * gf_nautilus2_gen_set_undo_status: (skip)
 * @object: A #GfNautilus2Gen.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Nautilus-FileOperations2.UndoStatus">"UndoStatus"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
gf_nautilus2_gen_set_undo_status (GfNautilus2Gen *object, gint value)
{
  g_object_set (G_OBJECT (object), "undo-status", value, NULL);
}

/**
 * gf_nautilus2_gen_call_copy_uris:
 * @proxy: A #GfNautilus2GenProxy.
 * @arg_sources: Argument to pass with the method invocation.
 * @arg_destination: Argument to pass with the method invocation.
 * @arg_platform_data: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Nautilus-FileOperations2.CopyURIs">CopyURIs()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gf_nautilus2_gen_call_copy_uris_finish() to get the result of the operation.
 *
 * See gf_nautilus2_gen_call_copy_uris_sync() for the synchronous, blocking version of this method.
 */
void
gf_nautilus2_gen_call_copy_uris (
    GfNautilus2Gen *proxy,
    const gchar *const *arg_sources,
    const gchar *arg_destination,
    GVariant *arg_platform_data,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CopyURIs",
    g_variant_new ("(^ass@a{sv})",
                   arg_sources,
                   arg_destination,
                   arg_platform_data),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gf_nautilus2_gen_call_copy_uris_finish:
 * @proxy: A #GfNautilus2GenProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gf_nautilus2_gen_call_copy_uris().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gf_nautilus2_gen_call_copy_uris().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_nautilus2_gen_call_copy_uris_finish (
    GfNautilus2Gen *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_nautilus2_gen_call_copy_uris_sync:
 * @proxy: A #GfNautilus2GenProxy.
 * @arg_sources: Argument to pass with the method invocation.
 * @arg_destination: Argument to pass with the method invocation.
 * @arg_platform_data: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Nautilus-FileOperations2.CopyURIs">CopyURIs()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gf_nautilus2_gen_call_copy_uris() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_nautilus2_gen_call_copy_uris_sync (
    GfNautilus2Gen *proxy,
    const gchar *const *arg_sources,
    const gchar *arg_destination,
    GVariant *arg_platform_data,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CopyURIs",
    g_variant_new ("(^ass@a{sv})",
                   arg_sources,
                   arg_destination,
                   arg_platform_data),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_nautilus2_gen_call_move_uris:
 * @proxy: A #GfNautilus2GenProxy.
 * @arg_sources: Argument to pass with the method invocation.
 * @arg_destination: Argument to pass with the method invocation.
 * @arg_platform_data: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Nautilus-FileOperations2.MoveURIs">MoveURIs()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gf_nautilus2_gen_call_move_uris_finish() to get the result of the operation.
 *
 * See gf_nautilus2_gen_call_move_uris_sync() for the synchronous, blocking version of this method.
 */
void
gf_nautilus2_gen_call_move_uris (
    GfNautilus2Gen *proxy,
    const gchar *const *arg_sources,
    const gchar *arg_destination,
    GVariant *arg_platform_data,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "MoveURIs",
    g_variant_new ("(^ass@a{sv})",
                   arg_sources,
                   arg_destination,
                   arg_platform_data),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gf_nautilus2_gen_call_move_uris_finish:
 * @proxy: A #GfNautilus2GenProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gf_nautilus2_gen_call_move_uris().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gf_nautilus2_gen_call_move_uris().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_nautilus2_gen_call_move_uris_finish (
    GfNautilus2Gen *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_nautilus2_gen_call_move_uris_sync:
 * @proxy: A #GfNautilus2GenProxy.
 * @arg_sources: Argument to pass with the method invocation.
 * @arg_destination: Argument to pass with the method invocation.
 * @arg_platform_data: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Nautilus-FileOperations2.MoveURIs">MoveURIs()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gf_nautilus2_gen_call_move_uris() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_nautilus2_gen_call_move_uris_sync (
    GfNautilus2Gen *proxy,
    const gchar *const *arg_sources,
    const gchar *arg_destination,
    GVariant *arg_platform_data,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "MoveURIs",
    g_variant_new ("(^ass@a{sv})",
                   arg_sources,
                   arg_destination,
                   arg_platform_data),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_nautilus2_gen_call_empty_trash:
 * @proxy: A #GfNautilus2GenProxy.
 * @arg_ask_confirmation: Argument to pass with the method invocation.
 * @arg_platform_data: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Nautilus-FileOperations2.EmptyTrash">EmptyTrash()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gf_nautilus2_gen_call_empty_trash_finish() to get the result of the operation.
 *
 * See gf_nautilus2_gen_call_empty_trash_sync() for the synchronous, blocking version of this method.
 */
void
gf_nautilus2_gen_call_empty_trash (
    GfNautilus2Gen *proxy,
    gboolean arg_ask_confirmation,
    GVariant *arg_platform_data,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "EmptyTrash",
    g_variant_new ("(b@a{sv})",
                   arg_ask_confirmation,
                   arg_platform_data),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gf_nautilus2_gen_call_empty_trash_finish:
 * @proxy: A #GfNautilus2GenProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gf_nautilus2_gen_call_empty_trash().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gf_nautilus2_gen_call_empty_trash().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_nautilus2_gen_call_empty_trash_finish (
    GfNautilus2Gen *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_nautilus2_gen_call_empty_trash_sync:
 * @proxy: A #GfNautilus2GenProxy.
 * @arg_ask_confirmation: Argument to pass with the method invocation.
 * @arg_platform_data: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Nautilus-FileOperations2.EmptyTrash">EmptyTrash()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gf_nautilus2_gen_call_empty_trash() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_nautilus2_gen_call_empty_trash_sync (
    GfNautilus2Gen *proxy,
    gboolean arg_ask_confirmation,
    GVariant *arg_platform_data,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "EmptyTrash",
    g_variant_new ("(b@a{sv})",
                   arg_ask_confirmation,
                   arg_platform_data),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_nautilus2_gen_call_trash_uris:
 * @proxy: A #GfNautilus2GenProxy.
 * @arg_uris: Argument to pass with the method invocation.
 * @arg_platform_data: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Nautilus-FileOperations2.TrashURIs">TrashURIs()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gf_nautilus2_gen_call_trash_uris_finish() to get the result of the operation.
 *
 * See gf_nautilus2_gen_call_trash_uris_sync() for the synchronous, blocking version of this method.
 */
void
gf_nautilus2_gen_call_trash_uris (
    GfNautilus2Gen *proxy,
    const gchar *const *arg_uris,
    GVariant *arg_platform_data,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "TrashURIs",
    g_variant_new ("(^as@a{sv})",
                   arg_uris,
                   arg_platform_data),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gf_nautilus2_gen_call_trash_uris_finish:
 * @proxy: A #GfNautilus2GenProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gf_nautilus2_gen_call_trash_uris().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gf_nautilus2_gen_call_trash_uris().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_nautilus2_gen_call_trash_uris_finish (
    GfNautilus2Gen *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_nautilus2_gen_call_trash_uris_sync:
 * @proxy: A #GfNautilus2GenProxy.
 * @arg_uris: Argument to pass with the method invocation.
 * @arg_platform_data: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Nautilus-FileOperations2.TrashURIs">TrashURIs()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gf_nautilus2_gen_call_trash_uris() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_nautilus2_gen_call_trash_uris_sync (
    GfNautilus2Gen *proxy,
    const gchar *const *arg_uris,
    GVariant *arg_platform_data,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "TrashURIs",
    g_variant_new ("(^as@a{sv})",
                   arg_uris,
                   arg_platform_data),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_nautilus2_gen_call_delete_uris:
 * @proxy: A #GfNautilus2GenProxy.
 * @arg_uris: Argument to pass with the method invocation.
 * @arg_platform_data: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Nautilus-FileOperations2.DeleteURIs">DeleteURIs()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gf_nautilus2_gen_call_delete_uris_finish() to get the result of the operation.
 *
 * See gf_nautilus2_gen_call_delete_uris_sync() for the synchronous, blocking version of this method.
 */
void
gf_nautilus2_gen_call_delete_uris (
    GfNautilus2Gen *proxy,
    const gchar *const *arg_uris,
    GVariant *arg_platform_data,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "DeleteURIs",
    g_variant_new ("(^as@a{sv})",
                   arg_uris,
                   arg_platform_data),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gf_nautilus2_gen_call_delete_uris_finish:
 * @proxy: A #GfNautilus2GenProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gf_nautilus2_gen_call_delete_uris().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gf_nautilus2_gen_call_delete_uris().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_nautilus2_gen_call_delete_uris_finish (
    GfNautilus2Gen *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_nautilus2_gen_call_delete_uris_sync:
 * @proxy: A #GfNautilus2GenProxy.
 * @arg_uris: Argument to pass with the method invocation.
 * @arg_platform_data: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Nautilus-FileOperations2.DeleteURIs">DeleteURIs()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gf_nautilus2_gen_call_delete_uris() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_nautilus2_gen_call_delete_uris_sync (
    GfNautilus2Gen *proxy,
    const gchar *const *arg_uris,
    GVariant *arg_platform_data,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "DeleteURIs",
    g_variant_new ("(^as@a{sv})",
                   arg_uris,
                   arg_platform_data),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_nautilus2_gen_call_create_folder:
 * @proxy: A #GfNautilus2GenProxy.
 * @arg_parent_uri: Argument to pass with the method invocation.
 * @arg_new_folder_name: Argument to pass with the method invocation.
 * @arg_platform_data: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Nautilus-FileOperations2.CreateFolder">CreateFolder()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gf_nautilus2_gen_call_create_folder_finish() to get the result of the operation.
 *
 * See gf_nautilus2_gen_call_create_folder_sync() for the synchronous, blocking version of this method.
 */
void
gf_nautilus2_gen_call_create_folder (
    GfNautilus2Gen *proxy,
    const gchar *arg_parent_uri,
    const gchar *arg_new_folder_name,
    GVariant *arg_platform_data,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CreateFolder",
    g_variant_new ("(ss@a{sv})",
                   arg_parent_uri,
                   arg_new_folder_name,
                   arg_platform_data),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gf_nautilus2_gen_call_create_folder_finish:
 * @proxy: A #GfNautilus2GenProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gf_nautilus2_gen_call_create_folder().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gf_nautilus2_gen_call_create_folder().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_nautilus2_gen_call_create_folder_finish (
    GfNautilus2Gen *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_nautilus2_gen_call_create_folder_sync:
 * @proxy: A #GfNautilus2GenProxy.
 * @arg_parent_uri: Argument to pass with the method invocation.
 * @arg_new_folder_name: Argument to pass with the method invocation.
 * @arg_platform_data: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Nautilus-FileOperations2.CreateFolder">CreateFolder()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gf_nautilus2_gen_call_create_folder() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_nautilus2_gen_call_create_folder_sync (
    GfNautilus2Gen *proxy,
    const gchar *arg_parent_uri,
    const gchar *arg_new_folder_name,
    GVariant *arg_platform_data,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CreateFolder",
    g_variant_new ("(ss@a{sv})",
                   arg_parent_uri,
                   arg_new_folder_name,
                   arg_platform_data),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_nautilus2_gen_call_rename_uri:
 * @proxy: A #GfNautilus2GenProxy.
 * @arg_uri: Argument to pass with the method invocation.
 * @arg_new_name: Argument to pass with the method invocation.
 * @arg_platform_data: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Nautilus-FileOperations2.RenameURI">RenameURI()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gf_nautilus2_gen_call_rename_uri_finish() to get the result of the operation.
 *
 * See gf_nautilus2_gen_call_rename_uri_sync() for the synchronous, blocking version of this method.
 */
void
gf_nautilus2_gen_call_rename_uri (
    GfNautilus2Gen *proxy,
    const gchar *arg_uri,
    const gchar *arg_new_name,
    GVariant *arg_platform_data,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RenameURI",
    g_variant_new ("(ss@a{sv})",
                   arg_uri,
                   arg_new_name,
                   arg_platform_data),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gf_nautilus2_gen_call_rename_uri_finish:
 * @proxy: A #GfNautilus2GenProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gf_nautilus2_gen_call_rename_uri().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gf_nautilus2_gen_call_rename_uri().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_nautilus2_gen_call_rename_uri_finish (
    GfNautilus2Gen *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_nautilus2_gen_call_rename_uri_sync:
 * @proxy: A #GfNautilus2GenProxy.
 * @arg_uri: Argument to pass with the method invocation.
 * @arg_new_name: Argument to pass with the method invocation.
 * @arg_platform_data: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Nautilus-FileOperations2.RenameURI">RenameURI()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gf_nautilus2_gen_call_rename_uri() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_nautilus2_gen_call_rename_uri_sync (
    GfNautilus2Gen *proxy,
    const gchar *arg_uri,
    const gchar *arg_new_name,
    GVariant *arg_platform_data,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RenameURI",
    g_variant_new ("(ss@a{sv})",
                   arg_uri,
                   arg_new_name,
                   arg_platform_data),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_nautilus2_gen_call_undo:
 * @proxy: A #GfNautilus2GenProxy.
 * @arg_platform_data: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Nautilus-FileOperations2.Undo">Undo()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gf_nautilus2_gen_call_undo_finish() to get the result of the operation.
 *
 * See gf_nautilus2_gen_call_undo_sync() for the synchronous, blocking version of this method.
 */
void
gf_nautilus2_gen_call_undo (
    GfNautilus2Gen *proxy,
    GVariant *arg_platform_data,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Undo",
    g_variant_new ("(@a{sv})",
                   arg_platform_data),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gf_nautilus2_gen_call_undo_finish:
 * @proxy: A #GfNautilus2GenProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gf_nautilus2_gen_call_undo().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gf_nautilus2_gen_call_undo().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_nautilus2_gen_call_undo_finish (
    GfNautilus2Gen *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_nautilus2_gen_call_undo_sync:
 * @proxy: A #GfNautilus2GenProxy.
 * @arg_platform_data: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Nautilus-FileOperations2.Undo">Undo()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gf_nautilus2_gen_call_undo() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_nautilus2_gen_call_undo_sync (
    GfNautilus2Gen *proxy,
    GVariant *arg_platform_data,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Undo",
    g_variant_new ("(@a{sv})",
                   arg_platform_data),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_nautilus2_gen_call_redo:
 * @proxy: A #GfNautilus2GenProxy.
 * @arg_platform_data: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Nautilus-FileOperations2.Redo">Redo()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gf_nautilus2_gen_call_redo_finish() to get the result of the operation.
 *
 * See gf_nautilus2_gen_call_redo_sync() for the synchronous, blocking version of this method.
 */
void
gf_nautilus2_gen_call_redo (
    GfNautilus2Gen *proxy,
    GVariant *arg_platform_data,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Redo",
    g_variant_new ("(@a{sv})",
                   arg_platform_data),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gf_nautilus2_gen_call_redo_finish:
 * @proxy: A #GfNautilus2GenProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gf_nautilus2_gen_call_redo().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gf_nautilus2_gen_call_redo().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_nautilus2_gen_call_redo_finish (
    GfNautilus2Gen *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_nautilus2_gen_call_redo_sync:
 * @proxy: A #GfNautilus2GenProxy.
 * @arg_platform_data: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Nautilus-FileOperations2.Redo">Redo()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gf_nautilus2_gen_call_redo() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_nautilus2_gen_call_redo_sync (
    GfNautilus2Gen *proxy,
    GVariant *arg_platform_data,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Redo",
    g_variant_new ("(@a{sv})",
                   arg_platform_data),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_nautilus2_gen_complete_copy_uris:
 * @object: A #GfNautilus2Gen.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Nautilus-FileOperations2.CopyURIs">CopyURIs()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gf_nautilus2_gen_complete_copy_uris (
    GfNautilus2Gen *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gf_nautilus2_gen_complete_move_uris:
 * @object: A #GfNautilus2Gen.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Nautilus-FileOperations2.MoveURIs">MoveURIs()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gf_nautilus2_gen_complete_move_uris (
    GfNautilus2Gen *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gf_nautilus2_gen_complete_empty_trash:
 * @object: A #GfNautilus2Gen.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Nautilus-FileOperations2.EmptyTrash">EmptyTrash()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gf_nautilus2_gen_complete_empty_trash (
    GfNautilus2Gen *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gf_nautilus2_gen_complete_trash_uris:
 * @object: A #GfNautilus2Gen.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Nautilus-FileOperations2.TrashURIs">TrashURIs()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gf_nautilus2_gen_complete_trash_uris (
    GfNautilus2Gen *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gf_nautilus2_gen_complete_delete_uris:
 * @object: A #GfNautilus2Gen.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Nautilus-FileOperations2.DeleteURIs">DeleteURIs()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gf_nautilus2_gen_complete_delete_uris (
    GfNautilus2Gen *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gf_nautilus2_gen_complete_create_folder:
 * @object: A #GfNautilus2Gen.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Nautilus-FileOperations2.CreateFolder">CreateFolder()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gf_nautilus2_gen_complete_create_folder (
    GfNautilus2Gen *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gf_nautilus2_gen_complete_rename_uri:
 * @object: A #GfNautilus2Gen.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Nautilus-FileOperations2.RenameURI">RenameURI()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gf_nautilus2_gen_complete_rename_uri (
    GfNautilus2Gen *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gf_nautilus2_gen_complete_undo:
 * @object: A #GfNautilus2Gen.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Nautilus-FileOperations2.Undo">Undo()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gf_nautilus2_gen_complete_undo (
    GfNautilus2Gen *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gf_nautilus2_gen_complete_redo:
 * @object: A #GfNautilus2Gen.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Nautilus-FileOperations2.Redo">Redo()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gf_nautilus2_gen_complete_redo (
    GfNautilus2Gen *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * GfNautilus2GenProxy:
 *
 * The #GfNautilus2GenProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GfNautilus2GenProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GfNautilus2GenProxy.
 */

struct _GfNautilus2GenProxyPrivate
{
  GData *qdata;
};

static void gf_nautilus2_gen_proxy_iface_init (GfNautilus2GenIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GfNautilus2GenProxy, gf_nautilus2_gen_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (GfNautilus2GenProxy)
                         G_IMPLEMENT_INTERFACE (GF_TYPE_NAUTILUS2_GEN, gf_nautilus2_gen_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GfNautilus2GenProxy, gf_nautilus2_gen_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (GF_TYPE_NAUTILUS2_GEN, gf_nautilus2_gen_proxy_iface_init))

#endif
static void
gf_nautilus2_gen_proxy_finalize (GObject *object)
{
  GfNautilus2GenProxy *proxy = GF_NAUTILUS2_GEN_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (gf_nautilus2_gen_proxy_parent_class)->finalize (object);
}

static void
gf_nautilus2_gen_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _gf_nautilus2_gen_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
gf_nautilus2_gen_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.gnome.Nautilus.FileOperations2: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
gf_nautilus2_gen_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _gf_nautilus2_gen_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.gnome.Nautilus.FileOperations2", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) gf_nautilus2_gen_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
gf_nautilus2_gen_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_gf_nautilus2_gen_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], GF_TYPE_NAUTILUS2_GEN);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GF_TYPE_NAUTILUS2_GEN);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
gf_nautilus2_gen_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  GfNautilus2GenProxy *proxy = GF_NAUTILUS2_GEN_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gf_nautilus2_gen_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gf_nautilus2_gen_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static gint 
gf_nautilus2_gen_proxy_get_undo_status (GfNautilus2Gen *object)
{
  GfNautilus2GenProxy *proxy = GF_NAUTILUS2_GEN_PROXY (object);
  GVariant *variant;
  gint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "UndoStatus");
  if (variant != NULL)
    {
      value = g_variant_get_int32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
gf_nautilus2_gen_proxy_init (GfNautilus2GenProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = gf_nautilus2_gen_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, GF_TYPE_NAUTILUS2_GEN_PROXY, GfNautilus2GenProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), gf_nautilus2_gen_interface_info ());
}

static void
gf_nautilus2_gen_proxy_class_init (GfNautilus2GenProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = gf_nautilus2_gen_proxy_finalize;
  gobject_class->get_property = gf_nautilus2_gen_proxy_get_property;
  gobject_class->set_property = gf_nautilus2_gen_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = gf_nautilus2_gen_proxy_g_signal;
  proxy_class->g_properties_changed = gf_nautilus2_gen_proxy_g_properties_changed;

  gf_nautilus2_gen_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GfNautilus2GenProxyPrivate));
#endif
}

static void
gf_nautilus2_gen_proxy_iface_init (GfNautilus2GenIface *iface)
{
  iface->get_undo_status = gf_nautilus2_gen_proxy_get_undo_status;
}

/**
 * gf_nautilus2_gen_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Nautilus-FileOperations2.top_of_page">org.gnome.Nautilus.FileOperations2</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gf_nautilus2_gen_proxy_new_finish() to get the result of the operation.
 *
 * See gf_nautilus2_gen_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
gf_nautilus2_gen_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GF_TYPE_NAUTILUS2_GEN_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Nautilus.FileOperations2", NULL);
}

/**
 * gf_nautilus2_gen_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gf_nautilus2_gen_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gf_nautilus2_gen_proxy_new().
 *
 * Returns: (transfer full) (type GfNautilus2GenProxy): The constructed proxy object or %NULL if @error is set.
 */
GfNautilus2Gen *
gf_nautilus2_gen_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GF_NAUTILUS2_GEN (ret);
  else
    return NULL;
}

/**
 * gf_nautilus2_gen_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Nautilus-FileOperations2.top_of_page">org.gnome.Nautilus.FileOperations2</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gf_nautilus2_gen_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GfNautilus2GenProxy): The constructed proxy object or %NULL if @error is set.
 */
GfNautilus2Gen *
gf_nautilus2_gen_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GF_TYPE_NAUTILUS2_GEN_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Nautilus.FileOperations2", NULL);
  if (ret != NULL)
    return GF_NAUTILUS2_GEN (ret);
  else
    return NULL;
}


/**
 * gf_nautilus2_gen_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like gf_nautilus2_gen_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gf_nautilus2_gen_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See gf_nautilus2_gen_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
gf_nautilus2_gen_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GF_TYPE_NAUTILUS2_GEN_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Nautilus.FileOperations2", NULL);
}

/**
 * gf_nautilus2_gen_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gf_nautilus2_gen_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gf_nautilus2_gen_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type GfNautilus2GenProxy): The constructed proxy object or %NULL if @error is set.
 */
GfNautilus2Gen *
gf_nautilus2_gen_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GF_NAUTILUS2_GEN (ret);
  else
    return NULL;
}

/**
 * gf_nautilus2_gen_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like gf_nautilus2_gen_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gf_nautilus2_gen_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GfNautilus2GenProxy): The constructed proxy object or %NULL if @error is set.
 */
GfNautilus2Gen *
gf_nautilus2_gen_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GF_TYPE_NAUTILUS2_GEN_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Nautilus.FileOperations2", NULL);
  if (ret != NULL)
    return GF_NAUTILUS2_GEN (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * GfNautilus2GenSkeleton:
 *
 * The #GfNautilus2GenSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GfNautilus2GenSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GfNautilus2GenSkeleton.
 */

struct _GfNautilus2GenSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_gf_nautilus2_gen_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  GfNautilus2GenSkeleton *skeleton = GF_NAUTILUS2_GEN_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], GF_TYPE_NAUTILUS2_GEN);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GF_TYPE_NAUTILUS2_GEN);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_gf_nautilus2_gen_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  GfNautilus2GenSkeleton *skeleton = GF_NAUTILUS2_GEN_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gf_nautilus2_gen_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_gf_nautilus2_gen_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  GfNautilus2GenSkeleton *skeleton = GF_NAUTILUS2_GEN_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gf_nautilus2_gen_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _gf_nautilus2_gen_skeleton_vtable =
{
  _gf_nautilus2_gen_skeleton_handle_method_call,
  _gf_nautilus2_gen_skeleton_handle_get_property,
  _gf_nautilus2_gen_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
gf_nautilus2_gen_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return gf_nautilus2_gen_interface_info ();
}

static GDBusInterfaceVTable *
gf_nautilus2_gen_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_gf_nautilus2_gen_skeleton_vtable;
}

static GVariant *
gf_nautilus2_gen_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  GfNautilus2GenSkeleton *skeleton = GF_NAUTILUS2_GEN_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_gf_nautilus2_gen_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _gf_nautilus2_gen_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _gf_nautilus2_gen_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _gf_nautilus2_gen_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Nautilus.FileOperations2", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _gf_nautilus2_gen_emit_changed (gpointer user_data);

static void
gf_nautilus2_gen_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  GfNautilus2GenSkeleton *skeleton = GF_NAUTILUS2_GEN_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _gf_nautilus2_gen_emit_changed (skeleton);
}

static void gf_nautilus2_gen_skeleton_iface_init (GfNautilus2GenIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GfNautilus2GenSkeleton, gf_nautilus2_gen_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (GfNautilus2GenSkeleton)
                         G_IMPLEMENT_INTERFACE (GF_TYPE_NAUTILUS2_GEN, gf_nautilus2_gen_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GfNautilus2GenSkeleton, gf_nautilus2_gen_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (GF_TYPE_NAUTILUS2_GEN, gf_nautilus2_gen_skeleton_iface_init))

#endif
static void
gf_nautilus2_gen_skeleton_finalize (GObject *object)
{
  GfNautilus2GenSkeleton *skeleton = GF_NAUTILUS2_GEN_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (gf_nautilus2_gen_skeleton_parent_class)->finalize (object);
}

static void
gf_nautilus2_gen_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  GfNautilus2GenSkeleton *skeleton = GF_NAUTILUS2_GEN_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_gf_nautilus2_gen_emit_changed (gpointer user_data)
{
  GfNautilus2GenSkeleton *skeleton = GF_NAUTILUS2_GEN_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.gnome.Nautilus.FileOperations2",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_gf_nautilus2_gen_schedule_emit_changed (GfNautilus2GenSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
gf_nautilus2_gen_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  GfNautilus2GenSkeleton *skeleton = GF_NAUTILUS2_GEN_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _gf_nautilus2_gen_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _gf_nautilus2_gen_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
gf_nautilus2_gen_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  GfNautilus2GenSkeleton *skeleton = GF_NAUTILUS2_GEN_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _gf_nautilus2_gen_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _gf_nautilus2_gen_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
gf_nautilus2_gen_skeleton_init (GfNautilus2GenSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = gf_nautilus2_gen_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, GF_TYPE_NAUTILUS2_GEN_SKELETON, GfNautilus2GenSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_INT);
}

static gint 
gf_nautilus2_gen_skeleton_get_undo_status (GfNautilus2Gen *object)
{
  GfNautilus2GenSkeleton *skeleton = GF_NAUTILUS2_GEN_SKELETON (object);
  gint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_int (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
gf_nautilus2_gen_skeleton_class_init (GfNautilus2GenSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = gf_nautilus2_gen_skeleton_finalize;
  gobject_class->get_property = gf_nautilus2_gen_skeleton_get_property;
  gobject_class->set_property = gf_nautilus2_gen_skeleton_set_property;
  gobject_class->notify       = gf_nautilus2_gen_skeleton_notify;


  gf_nautilus2_gen_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = gf_nautilus2_gen_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = gf_nautilus2_gen_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = gf_nautilus2_gen_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = gf_nautilus2_gen_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GfNautilus2GenSkeletonPrivate));
#endif
}

static void
gf_nautilus2_gen_skeleton_iface_init (GfNautilus2GenIface *iface)
{
  iface->get_undo_status = gf_nautilus2_gen_skeleton_get_undo_status;
}

/**
 * gf_nautilus2_gen_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Nautilus-FileOperations2.top_of_page">org.gnome.Nautilus.FileOperations2</link>.
 *
 * Returns: (transfer full) (type GfNautilus2GenSkeleton): The skeleton object.
 */
GfNautilus2Gen *
gf_nautilus2_gen_skeleton_new (void)
{
  return GF_NAUTILUS2_GEN (g_object_new (GF_TYPE_NAUTILUS2_GEN_SKELETON, NULL));
}

