# Progress Linux: gnome-shell-extensions-extra

# Copyright (C) 2010-2024 Daniel Baumann <daniel.baumann@progress-linux.org>
#
# SPDX-License-Identifier: GPL-3.0+
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.

# Build-Depends:
# libglib2.0-bin

SHELL := sh -e

EXTENSION := hibernate-status
UUID := $(shell awk -F\" '/"uuid": / { print $$4 }' $(EXTENSION)/metadata.json)

all:

test:

build:

install:
	$(MAKE) -C $(EXTENSION) DESTDIR=$(DESTDIR) install

	# removing unused files
	rm -f $(DESTDIR)/usr/share/gnome-shell/extensions/$(UUID)/LICENSE
	rm -f $(DESTDIR)/usr/share/gnome-shell/extensions/$(UUID)/README.md

uninstall:
	rm -rf $(DESTDIR)/usr/share/gnome-shell/extensions/$(UUID)
	rmdir --ignore-fail-on-non-empty --parents $(DESTDIR) || true

clean:
	$(MAKE) -C $(EXTENSION) clean

distclean:

reinstall: uninstall install

upstream:
	rm -rf $(EXTENSION)
	git clone https://github.com/arelange/gnome-shell-extension-$(EXTENSION) $(EXTENSION)
	rm -rf $(EXTENSION)/.git
