// This file was generated by the Gtk# code generator.
// Any changes made will be lost if regenerated.

namespace Gst.Audio {

	using System;
	using System.Collections;
	using System.Collections.Generic;
	using System.Runtime.InteropServices;

#region Autogenerated code
	public partial class Global {

		[DllImport("gstaudio-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_audio_buffer_clip(IntPtr buffer, IntPtr segment, int rate, int bpf);

		public static Gst.Buffer AudioBufferClip(Gst.Buffer buffer, Gst.Segment segment, int rate, int bpf) {
			buffer.Owned = false;
			IntPtr native_segment = GLib.Marshaller.StructureToPtrAlloc (segment);
			IntPtr raw_ret = gst_audio_buffer_clip(buffer == null ? IntPtr.Zero : buffer.Handle, native_segment, rate, bpf);
			Gst.Buffer ret = raw_ret == IntPtr.Zero ? null : (Gst.Buffer) GLib.Opaque.GetOpaque (raw_ret, typeof (Gst.Buffer), true);
			Marshal.FreeHGlobal (native_segment);
			return ret;
		}

		[DllImport("gstaudio-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gst_audio_buffer_reorder_channels(IntPtr buffer, int format, int channels, int[] from, int[] to);

		public static bool AudioBufferReorderChannels(Gst.Buffer buffer, Gst.Audio.AudioFormat format, int channels, Gst.Audio.AudioChannelPosition[] from, Gst.Audio.AudioChannelPosition[] to) {
			int cnt_from = from == null ? 0 : from.Length;
			int[] native_from = new int [cnt_from];
			for (int i = 0; i < cnt_from; i++)
				native_from [i] = (int) from[i];
			int cnt_to = to == null ? 0 : to.Length;
			int[] native_to = new int [cnt_to];
			for (int i = 0; i < cnt_to; i++)
				native_to [i] = (int) to[i];
			bool raw_ret = gst_audio_buffer_reorder_channels(buffer == null ? IntPtr.Zero : buffer.Handle, (int) format, channels, native_from, native_to);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("gstaudio-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_audio_buffer_truncate(IntPtr buffer, int bpf, UIntPtr trim, UIntPtr samples);

		public static Gst.Buffer AudioBufferTruncate(Gst.Buffer buffer, int bpf, ulong trim, ulong samples) {
			buffer.Owned = false;
			IntPtr raw_ret = gst_audio_buffer_truncate(buffer == null ? IntPtr.Zero : buffer.Handle, bpf, new UIntPtr (trim), new UIntPtr (samples));
			Gst.Buffer ret = raw_ret == IntPtr.Zero ? null : (Gst.Buffer) GLib.Opaque.GetOpaque (raw_ret, typeof (Gst.Buffer), true);
			return ret;
		}

		[DllImport("gstaudio-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern ulong gst_audio_channel_get_fallback_mask(int channels);

		public static ulong AudioChannelGetFallbackMask(int channels) {
			ulong raw_ret = gst_audio_channel_get_fallback_mask(channels);
			ulong ret = raw_ret;
			return ret;
		}

		[DllImport("gstaudio-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gst_audio_channel_positions_from_mask(int channels, ulong channel_mask, int[] position);

		public static bool AudioChannelPositionsFromMask(int channels, ulong channel_mask, Gst.Audio.AudioChannelPosition[] position) {
			int cnt_position = position == null ? 0 : position.Length;
			int[] native_position = new int [cnt_position];
			for (int i = 0; i < cnt_position; i++)
				native_position [i] = (int) position[i];
			bool raw_ret = gst_audio_channel_positions_from_mask(channels, channel_mask, native_position);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("gstaudio-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gst_audio_channel_positions_to_mask(int[] position, int channels, bool force_order, out ulong channel_mask);

		public static bool AudioChannelPositionsToMask(Gst.Audio.AudioChannelPosition[] position, int channels, bool force_order, out ulong channel_mask) {
			int cnt_position = position == null ? 0 : position.Length;
			int[] native_position = new int [cnt_position];
			for (int i = 0; i < cnt_position; i++)
				native_position [i] = (int) position[i];
			bool raw_ret = gst_audio_channel_positions_to_mask(native_position, channels, force_order, out channel_mask);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("gstaudio-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_audio_channel_positions_to_string(int[] position, int channels);

		public static string AudioChannelPositionsToString(Gst.Audio.AudioChannelPosition[] position, int channels) {
			int cnt_position = position == null ? 0 : position.Length;
			int[] native_position = new int [cnt_position];
			for (int i = 0; i < cnt_position; i++)
				native_position [i] = (int) position[i];
			IntPtr raw_ret = gst_audio_channel_positions_to_string(native_position, channels);
			string ret = GLib.Marshaller.PtrToStringGFree(raw_ret);
			return ret;
		}

		[DllImport("gstaudio-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gst_audio_channel_positions_to_valid_order(int[] position, int channels);

		public static bool AudioChannelPositionsToValidOrder(Gst.Audio.AudioChannelPosition[] position, int channels) {
			int cnt_position = position == null ? 0 : position.Length;
			int[] native_position = new int [cnt_position];
			for (int i = 0; i < cnt_position; i++)
				native_position [i] = (int) position[i];
			bool raw_ret = gst_audio_channel_positions_to_valid_order(native_position, channels);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("gstaudio-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gst_audio_check_valid_channel_positions(int[] position, int channels, bool force_order);

		public static bool AudioCheckValidChannelPositions(Gst.Audio.AudioChannelPosition[] position, int channels, bool force_order) {
			int cnt_position = position == null ? 0 : position.Length;
			int[] native_position = new int [cnt_position];
			for (int i = 0; i < cnt_position; i++)
				native_position [i] = (int) position[i];
			bool raw_ret = gst_audio_check_valid_channel_positions(native_position, channels, force_order);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("gstaudio-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_audio_clipping_meta_api_get_type();

		public static GLib.GType AudioClippingMetaApiGetType() {
			IntPtr raw_ret = gst_audio_clipping_meta_api_get_type();
			GLib.GType ret = new GLib.GType(raw_ret);
			return ret;
		}

		[DllImport("gstaudio-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_audio_clipping_meta_get_info();

		public static Gst.MetaInfo AudioClippingMetaGetInfo() {
			IntPtr raw_ret = gst_audio_clipping_meta_get_info();
			Gst.MetaInfo ret = Gst.MetaInfo.New (raw_ret);
			return ret;
		}

		[DllImport("gstaudio-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_audio_downmix_meta_api_get_type();

		public static GLib.GType AudioDownmixMetaApiGetType() {
			IntPtr raw_ret = gst_audio_downmix_meta_api_get_type();
			GLib.GType ret = new GLib.GType(raw_ret);
			return ret;
		}

		[DllImport("gstaudio-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_audio_downmix_meta_get_info();

		public static Gst.MetaInfo AudioDownmixMetaGetInfo() {
			IntPtr raw_ret = gst_audio_downmix_meta_get_info();
			Gst.MetaInfo ret = Gst.MetaInfo.New (raw_ret);
			return ret;
		}

		[DllImport("gstaudio-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gst_audio_format_build_integer(bool sign, int endianness, int width, int depth);

		public static Gst.Audio.AudioFormat AudioFormatBuildInteger(bool sign, int endianness, int width, int depth) {
			int raw_ret = gst_audio_format_build_integer(sign, endianness, width, depth);
			Gst.Audio.AudioFormat ret = (Gst.Audio.AudioFormat) raw_ret;
			return ret;
		}

		[DllImport("gstaudio-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gst_audio_format_fill_silence(IntPtr info, byte[] dest, UIntPtr n_length);

		public static void AudioFormatFillSilence(Gst.Audio.AudioFormatInfo info, byte[] dest) {
			IntPtr native_info = GLib.Marshaller.StructureToPtrAlloc (info);
			gst_audio_format_fill_silence(native_info, dest, new UIntPtr ((ulong) (dest == null ? 0 : dest.Length)));
			Marshal.FreeHGlobal (native_info);
		}

		[DllImport("gstaudio-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gst_audio_format_from_string(IntPtr format);

		public static Gst.Audio.AudioFormat AudioFormatFromString(string format) {
			IntPtr native_format = GLib.Marshaller.StringToPtrGStrdup (format);
			int raw_ret = gst_audio_format_from_string(native_format);
			Gst.Audio.AudioFormat ret = (Gst.Audio.AudioFormat) raw_ret;
			GLib.Marshaller.Free (native_format);
			return ret;
		}

		[DllImport("gstaudio-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_audio_format_get_info(int format);

		public static Gst.Audio.AudioFormatInfo AudioFormatGetInfo(Gst.Audio.AudioFormat format) {
			IntPtr raw_ret = gst_audio_format_get_info((int) format);
			Gst.Audio.AudioFormatInfo ret = Gst.Audio.AudioFormatInfo.New (raw_ret);
			return ret;
		}

		[DllImport("gstaudio-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_audio_format_info_get_type();

		public static GLib.GType AudioFormatInfoGetType() {
			IntPtr raw_ret = gst_audio_format_info_get_type();
			GLib.GType ret = new GLib.GType(raw_ret);
			return ret;
		}

		[DllImport("gstaudio-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_audio_format_to_string(int format);

		public static string AudioFormatToString(Gst.Audio.AudioFormat format) {
			IntPtr raw_ret = gst_audio_format_to_string((int) format);
			string ret = GLib.Marshaller.Utf8PtrToString (raw_ret);
			return ret;
		}

		[DllImport("gstaudio-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gst_audio_get_channel_reorder_map(int channels, int[] from, int[] to, int[] reorder_map);

		public static bool AudioGetChannelReorderMap(int channels, Gst.Audio.AudioChannelPosition[] from, Gst.Audio.AudioChannelPosition[] to, int[] reorder_map) {
			int cnt_from = from == null ? 0 : from.Length;
			int[] native_from = new int [cnt_from];
			for (int i = 0; i < cnt_from; i++)
				native_from [i] = (int) from[i];
			int cnt_to = to == null ? 0 : to.Length;
			int[] native_to = new int [cnt_to];
			for (int i = 0; i < cnt_to; i++)
				native_to [i] = (int) to[i];
			bool raw_ret = gst_audio_get_channel_reorder_map(channels, native_from, native_to, reorder_map);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("gstaudio-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern uint gst_audio_iec61937_frame_size(IntPtr spec);

		public static uint AudioIec61937FrameSize(Gst.Audio.AudioRingBufferSpec spec) {
			uint raw_ret = gst_audio_iec61937_frame_size(spec == null ? IntPtr.Zero : spec.Handle);
			uint ret = raw_ret;
			return ret;
		}

		[DllImport("gstaudio-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gst_audio_iec61937_payload(byte[] src, uint src_n, byte[] dst, uint dst_n, IntPtr spec, int endianness);

		public static bool AudioIec61937Payload(byte[] src, uint src_n, byte[] dst, uint dst_n, Gst.Audio.AudioRingBufferSpec spec, int endianness) {
			bool raw_ret = gst_audio_iec61937_payload(src, src_n, dst, dst_n, spec == null ? IntPtr.Zero : spec.Handle, endianness);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("gstaudio-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_audio_make_raw_caps(int[] formats, uint len, int layout);

		public static Gst.Caps AudioMakeRawCaps(Gst.Audio.AudioFormat[] formats, uint len, Gst.Audio.AudioLayout layout) {
			int cnt_formats = formats == null ? 0 : formats.Length;
			int[] native_formats = new int [cnt_formats];
			for (int i = 0; i < cnt_formats; i++)
				native_formats [i] = (int) formats[i];
			IntPtr raw_ret = gst_audio_make_raw_caps(native_formats, len, (int) layout);
			Gst.Caps ret = raw_ret == IntPtr.Zero ? null : (Gst.Caps) GLib.Opaque.GetOpaque (raw_ret, typeof (Gst.Caps), true);
			return ret;
		}

		public static Gst.Caps AudioMakeRawCaps(uint len, Gst.Audio.AudioLayout layout) {
			return AudioMakeRawCaps (null, len, layout);
		}

		[DllImport("gstaudio-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_audio_meta_api_get_type();

		public static GLib.GType AudioMetaApiGetType() {
			IntPtr raw_ret = gst_audio_meta_api_get_type();
			GLib.GType ret = new GLib.GType(raw_ret);
			return ret;
		}

		[DllImport("gstaudio-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_audio_meta_get_info();

		public static Gst.MetaInfo AudioMetaGetInfo() {
			IntPtr raw_ret = gst_audio_meta_get_info();
			Gst.MetaInfo ret = Gst.MetaInfo.New (raw_ret);
			return ret;
		}

		[DllImport("gstaudio-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gst_audio_reorder_channels(byte[] data, UIntPtr n_length, int format, int channels, int[] from, int[] to);

		public static bool AudioReorderChannels(byte[] data, Gst.Audio.AudioFormat format, int channels, Gst.Audio.AudioChannelPosition[] from, Gst.Audio.AudioChannelPosition[] to) {
			int cnt_from = from == null ? 0 : from.Length;
			int[] native_from = new int [cnt_from];
			for (int i = 0; i < cnt_from; i++)
				native_from [i] = (int) from[i];
			int cnt_to = to == null ? 0 : to.Length;
			int[] native_to = new int [cnt_to];
			for (int i = 0; i < cnt_to; i++)
				native_to [i] = (int) to[i];
			bool raw_ret = gst_audio_reorder_channels(data, new UIntPtr ((ulong) (data == null ? 0 : data.Length)), (int) format, channels, native_from, native_to);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("gstaudio-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_audio_resampler_new(int method, int flags, int format, int channels, int in_rate, int out_rate, IntPtr options);

		public static Gst.Audio.AudioResampler AudioResamplerNew(Gst.Audio.AudioResamplerMethod method, Gst.Audio.AudioResamplerFlags flags, Gst.Audio.AudioFormat format, int channels, int in_rate, int out_rate, Gst.Structure options) {
			IntPtr raw_ret = gst_audio_resampler_new((int) method, (int) flags, (int) format, channels, in_rate, out_rate, options == null ? IntPtr.Zero : options.Handle);
			Gst.Audio.AudioResampler ret = raw_ret == IntPtr.Zero ? null : (Gst.Audio.AudioResampler) GLib.Opaque.GetOpaque (raw_ret, typeof (Gst.Audio.AudioResampler), true);
			return ret;
		}

		[DllImport("gstaudio-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gst_audio_resampler_options_set_quality(int method, uint quality, int in_rate, int out_rate, IntPtr options);

		public static void AudioResamplerOptionsSetQuality(Gst.Audio.AudioResamplerMethod method, uint quality, int in_rate, int out_rate, Gst.Structure options) {
			gst_audio_resampler_options_set_quality((int) method, quality, in_rate, out_rate, options == null ? IntPtr.Zero : options.Handle);
		}

		[DllImport("gstaudio-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_buffer_add_audio_clipping_meta(IntPtr buffer, int format, ulong start, ulong end);

		public static Gst.Audio.AudioClippingMeta BufferAddAudioClippingMeta(Gst.Buffer buffer, Gst.Format format, ulong start, ulong end) {
			IntPtr raw_ret = gst_buffer_add_audio_clipping_meta(buffer == null ? IntPtr.Zero : buffer.Handle, (int) format, start, end);
			Gst.Audio.AudioClippingMeta ret = Gst.Audio.AudioClippingMeta.New (raw_ret);
			return ret;
		}

		[DllImport("gstaudio-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_buffer_add_audio_downmix_meta(IntPtr buffer, int[] from_position, int from_channels, int[] to_position, int to_channels, float matrix);

		public static Gst.Audio.AudioDownmixMeta BufferAddAudioDownmixMeta(Gst.Buffer buffer, Gst.Audio.AudioChannelPosition[] from_position, int from_channels, Gst.Audio.AudioChannelPosition[] to_position, int to_channels, float matrix) {
			int cnt_from_position = from_position == null ? 0 : from_position.Length;
			int[] native_from_position = new int [cnt_from_position];
			for (int i = 0; i < cnt_from_position; i++)
				native_from_position [i] = (int) from_position[i];
			int cnt_to_position = to_position == null ? 0 : to_position.Length;
			int[] native_to_position = new int [cnt_to_position];
			for (int i = 0; i < cnt_to_position; i++)
				native_to_position [i] = (int) to_position[i];
			IntPtr raw_ret = gst_buffer_add_audio_downmix_meta(buffer == null ? IntPtr.Zero : buffer.Handle, native_from_position, from_channels, native_to_position, to_channels, matrix);
			Gst.Audio.AudioDownmixMeta ret = Gst.Audio.AudioDownmixMeta.New (raw_ret);
			return ret;
		}

		[DllImport("gstaudio-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_buffer_add_audio_meta(IntPtr buffer, IntPtr info, UIntPtr samples, UIntPtr offsets);

		public static Gst.Audio.AudioMeta BufferAddAudioMeta(Gst.Buffer buffer, Gst.Audio.AudioInfo info, ulong samples, ulong offsets) {
			IntPtr raw_ret = gst_buffer_add_audio_meta(buffer == null ? IntPtr.Zero : buffer.Handle, info == null ? IntPtr.Zero : info.Handle, new UIntPtr (samples), new UIntPtr (offsets));
			Gst.Audio.AudioMeta ret = Gst.Audio.AudioMeta.New (raw_ret);
			return ret;
		}

		public static Gst.Audio.AudioMeta BufferAddAudioMeta(Gst.Buffer buffer, Gst.Audio.AudioInfo info, ulong samples) {
			return BufferAddAudioMeta (buffer, info, samples, 0);
		}

		[DllImport("gstaudio-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_buffer_get_audio_downmix_meta_for_channels(IntPtr buffer, int[] to_position, int to_channels);

		public static Gst.Audio.AudioDownmixMeta BufferGetAudioDownmixMetaForChannels(Gst.Buffer buffer, Gst.Audio.AudioChannelPosition[] to_position, int to_channels) {
			int cnt_to_position = to_position == null ? 0 : to_position.Length;
			int[] native_to_position = new int [cnt_to_position];
			for (int i = 0; i < cnt_to_position; i++)
				native_to_position [i] = (int) to_position[i];
			IntPtr raw_ret = gst_buffer_get_audio_downmix_meta_for_channels(buffer == null ? IntPtr.Zero : buffer.Handle, native_to_position, to_channels);
			Gst.Audio.AudioDownmixMeta ret = Gst.Audio.AudioDownmixMeta.New (raw_ret);
			return ret;
		}

		[DllImport("gstaudio-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern double gst_stream_volume_convert_volume(int from, int to, double val);

		public static double StreamVolumeConvertVolume(Gst.Audio.StreamVolumeFormat from, Gst.Audio.StreamVolumeFormat to, double val) {
			double raw_ret = gst_stream_volume_convert_volume((int) from, (int) to, val);
			double ret = raw_ret;
			return ret;
		}

#endregion
	}
}
