// This file was generated by the Gtk# code generator.
// Any changes made will be lost if regenerated.

namespace Gtk {

	using System;
	using System.Collections;
	using System.Collections.Generic;
	using System.Runtime.InteropServices;

#region Autogenerated code
	public partial class TextBuffer : GLib.Object {

		public TextBuffer (IntPtr raw) : base(raw) {}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gtk_text_buffer_new(IntPtr table);

		public TextBuffer (Gtk.TextTagTable table) : base (IntPtr.Zero)
		{
			if (GetType () != typeof (TextBuffer)) {
				var vals = new List<GLib.Value> ();
				var names = new List<string> ();
				if (table != null) {
					names.Add ("tag_table");
					vals.Add (new GLib.Value (table));
				}
				CreateNativeObject (names.ToArray (), vals.ToArray ());
				return;
			}
			Raw = gtk_text_buffer_new(table == null ? IntPtr.Zero : table.Handle);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gtk_text_buffer_get_tag_table(IntPtr raw);

		[GLib.Property ("tag-table")]
		public Gtk.TextTagTable TagTable {
			get  {
				IntPtr raw_ret = gtk_text_buffer_get_tag_table(Handle);
				Gtk.TextTagTable ret = GLib.Object.GetObject(raw_ret) as Gtk.TextTagTable;
				return ret;
			}
		}

		[GLib.Property ("text")]
		public string Text {
			get {
				GLib.Value val = GetProperty ("text");
				string ret = (string) val;
				val.Dispose ();
				return ret;
			}
			set {
				GLib.Value val = new GLib.Value(value);
				SetProperty("text", val);
				val.Dispose ();
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gtk_text_buffer_get_has_selection(IntPtr raw);

		[GLib.Property ("has-selection")]
		public bool HasSelection {
			get  {
				bool raw_ret = gtk_text_buffer_get_has_selection(Handle);
				bool ret = raw_ret;
				return ret;
			}
		}

		[GLib.Property ("cursor-position")]
		public int CursorPosition {
			get {
				GLib.Value val = GetProperty ("cursor-position");
				int ret = (int) val;
				val.Dispose ();
				return ret;
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gtk_text_buffer_get_copy_target_list(IntPtr raw);

		[GLib.Property ("copy-target-list")]
		public Gtk.TargetList CopyTargetList {
			get  {
				IntPtr raw_ret = gtk_text_buffer_get_copy_target_list(Handle);
				Gtk.TargetList ret = raw_ret == IntPtr.Zero ? null : (Gtk.TargetList) GLib.Opaque.GetOpaque (raw_ret, typeof (Gtk.TargetList), false);
				return ret;
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gtk_text_buffer_get_paste_target_list(IntPtr raw);

		[GLib.Property ("paste-target-list")]
		public Gtk.TargetList PasteTargetList {
			get  {
				IntPtr raw_ret = gtk_text_buffer_get_paste_target_list(Handle);
				Gtk.TargetList ret = raw_ret == IntPtr.Zero ? null : (Gtk.TargetList) GLib.Opaque.GetOpaque (raw_ret, typeof (Gtk.TargetList), false);
				return ret;
			}
		}

		[GLib.Signal("changed")]
		public event System.EventHandler Changed {
			add {
				this.AddSignalHandler ("changed", value);
			}
			remove {
				this.RemoveSignalHandler ("changed", value);
			}
		}

		[GLib.Signal("delete-range")]
		public event Gtk.DeleteRangeHandler DeleteRange {
			add {
				this.AddSignalHandler ("delete-range", value, typeof (Gtk.DeleteRangeArgs));
			}
			remove {
				this.RemoveSignalHandler ("delete-range", value);
			}
		}

		[GLib.Signal("end-user-action")]
		public event System.EventHandler UserActionEnded {
			add {
				this.AddSignalHandler ("end-user-action", value);
			}
			remove {
				this.RemoveSignalHandler ("end-user-action", value);
			}
		}

		[GLib.Signal("modified-changed")]
		public event System.EventHandler ModifiedChanged {
			add {
				this.AddSignalHandler ("modified-changed", value);
			}
			remove {
				this.RemoveSignalHandler ("modified-changed", value);
			}
		}

		[GLib.Signal("mark-set")]
		public event Gtk.MarkSetHandler MarkSet {
			add {
				this.AddSignalHandler ("mark-set", value, typeof (Gtk.MarkSetArgs));
			}
			remove {
				this.RemoveSignalHandler ("mark-set", value);
			}
		}

		[GLib.Signal("insert-child-anchor")]
		public event Gtk.ChildAnchorInsertedHandler ChildAnchorInserted {
			add {
				this.AddSignalHandler ("insert-child-anchor", value, typeof (Gtk.ChildAnchorInsertedArgs));
			}
			remove {
				this.RemoveSignalHandler ("insert-child-anchor", value);
			}
		}

		[GLib.Signal("remove-tag")]
		public event Gtk.TagRemovedHandler TagRemoved {
			add {
				this.AddSignalHandler ("remove-tag", value, typeof (Gtk.TagRemovedArgs));
			}
			remove {
				this.RemoveSignalHandler ("remove-tag", value);
			}
		}

		[GLib.Signal("apply-tag")]
		public event Gtk.TagAppliedHandler TagApplied {
			add {
				this.AddSignalHandler ("apply-tag", value, typeof (Gtk.TagAppliedArgs));
			}
			remove {
				this.RemoveSignalHandler ("apply-tag", value);
			}
		}

		[GLib.Signal("paste-done")]
		public event Gtk.PasteDoneHandler PasteDone {
			add {
				this.AddSignalHandler ("paste-done", value, typeof (Gtk.PasteDoneArgs));
			}
			remove {
				this.RemoveSignalHandler ("paste-done", value);
			}
		}

		[GLib.Signal("insert-pixbuf")]
		public event Gtk.PixbufInsertedHandler PixbufInserted {
			add {
				this.AddSignalHandler ("insert-pixbuf", value, typeof (Gtk.PixbufInsertedArgs));
			}
			remove {
				this.RemoveSignalHandler ("insert-pixbuf", value);
			}
		}

		[GLib.Signal("mark-deleted")]
		public event Gtk.MarkDeletedHandler MarkDeleted {
			add {
				this.AddSignalHandler ("mark-deleted", value, typeof (Gtk.MarkDeletedArgs));
			}
			remove {
				this.RemoveSignalHandler ("mark-deleted", value);
			}
		}

		[GLib.Signal("begin-user-action")]
		public event System.EventHandler UserActionBegun {
			add {
				this.AddSignalHandler ("begin-user-action", value);
			}
			remove {
				this.RemoveSignalHandler ("begin-user-action", value);
			}
		}

		[GLib.Signal("insert-text")]
		public event Gtk.InsertTextHandler InsertText {
			add {
				this.AddSignalHandler ("insert-text", value, typeof (Gtk.InsertTextArgs));
			}
			remove {
				this.RemoveSignalHandler ("insert-text", value);
			}
		}

		static InsertTextNativeDelegate InsertText_cb_delegate;
		static InsertTextNativeDelegate InsertTextVMCallback {
			get {
				if (InsertText_cb_delegate == null)
					InsertText_cb_delegate = new InsertTextNativeDelegate (InsertText_cb);
				return InsertText_cb_delegate;
			}
		}

		static void OverrideInsertText (GLib.GType gtype)
		{
			OverrideInsertText (gtype, InsertTextVMCallback);
		}

		static void OverrideInsertText (GLib.GType gtype, InsertTextNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("insert_text"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void InsertTextNativeDelegate (IntPtr inst, IntPtr pos, IntPtr new_text, int new_text_length);

		static void InsertText_cb (IntPtr inst, IntPtr pos, IntPtr new_text, int new_text_length)
		{
			try {
				TextBuffer __obj = GLib.Object.GetObject (inst, false) as TextBuffer;
				__obj.OnInsertText (Gtk.TextIter.New (pos), GLib.Marshaller.Utf8PtrToString (new_text));
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gtk.TextBuffer), ConnectionMethod="OverrideInsertText")]
		protected virtual void OnInsertText (Gtk.TextIter pos, string new_text)
		{
			InternalInsertText (pos, new_text);
		}

		private void InternalInsertText (Gtk.TextIter pos, string new_text)
		{
			InsertTextNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("insert_text"));
				unmanaged = (InsertTextNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(InsertTextNativeDelegate));
			}
			if (unmanaged == null) return;

			IntPtr native_pos = GLib.Marshaller.StructureToPtrAlloc (pos);
			IntPtr native_new_text = GLib.Marshaller.StringToPtrGStrdup (new_text);
			unmanaged (this.Handle, native_pos, native_new_text, System.Text.Encoding.UTF8.GetByteCount (new_text));
			Marshal.FreeHGlobal (native_pos);
			GLib.Marshaller.Free (native_new_text);
		}

		static PixbufInsertedNativeDelegate PixbufInserted_cb_delegate;
		static PixbufInsertedNativeDelegate PixbufInsertedVMCallback {
			get {
				if (PixbufInserted_cb_delegate == null)
					PixbufInserted_cb_delegate = new PixbufInsertedNativeDelegate (PixbufInserted_cb);
				return PixbufInserted_cb_delegate;
			}
		}

		static void OverridePixbufInserted (GLib.GType gtype)
		{
			OverridePixbufInserted (gtype, PixbufInsertedVMCallback);
		}

		static void OverridePixbufInserted (GLib.GType gtype, PixbufInsertedNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("insert_pixbuf"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void PixbufInsertedNativeDelegate (IntPtr inst, IntPtr iter, IntPtr pixbuf);

		static void PixbufInserted_cb (IntPtr inst, IntPtr iter, IntPtr pixbuf)
		{
			try {
				TextBuffer __obj = GLib.Object.GetObject (inst, false) as TextBuffer;
				__obj.OnPixbufInserted (Gtk.TextIter.New (iter), GLib.Object.GetObject(pixbuf) as Gdk.Pixbuf);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gtk.TextBuffer), ConnectionMethod="OverridePixbufInserted")]
		protected virtual void OnPixbufInserted (Gtk.TextIter iter, Gdk.Pixbuf pixbuf)
		{
			InternalPixbufInserted (iter, pixbuf);
		}

		private void InternalPixbufInserted (Gtk.TextIter iter, Gdk.Pixbuf pixbuf)
		{
			PixbufInsertedNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("insert_pixbuf"));
				unmanaged = (PixbufInsertedNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(PixbufInsertedNativeDelegate));
			}
			if (unmanaged == null) return;

			IntPtr native_iter = GLib.Marshaller.StructureToPtrAlloc (iter);
			unmanaged (this.Handle, native_iter, pixbuf == null ? IntPtr.Zero : pixbuf.Handle);
			Marshal.FreeHGlobal (native_iter);
		}

		static ChildAnchorInsertedNativeDelegate ChildAnchorInserted_cb_delegate;
		static ChildAnchorInsertedNativeDelegate ChildAnchorInsertedVMCallback {
			get {
				if (ChildAnchorInserted_cb_delegate == null)
					ChildAnchorInserted_cb_delegate = new ChildAnchorInsertedNativeDelegate (ChildAnchorInserted_cb);
				return ChildAnchorInserted_cb_delegate;
			}
		}

		static void OverrideChildAnchorInserted (GLib.GType gtype)
		{
			OverrideChildAnchorInserted (gtype, ChildAnchorInsertedVMCallback);
		}

		static void OverrideChildAnchorInserted (GLib.GType gtype, ChildAnchorInsertedNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("insert_child_anchor"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void ChildAnchorInsertedNativeDelegate (IntPtr inst, IntPtr iter, IntPtr anchor);

		static void ChildAnchorInserted_cb (IntPtr inst, IntPtr iter, IntPtr anchor)
		{
			try {
				TextBuffer __obj = GLib.Object.GetObject (inst, false) as TextBuffer;
				__obj.OnChildAnchorInserted (Gtk.TextIter.New (iter), GLib.Object.GetObject(anchor) as Gtk.TextChildAnchor);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gtk.TextBuffer), ConnectionMethod="OverrideChildAnchorInserted")]
		protected virtual void OnChildAnchorInserted (Gtk.TextIter iter, Gtk.TextChildAnchor anchor)
		{
			InternalChildAnchorInserted (iter, anchor);
		}

		private void InternalChildAnchorInserted (Gtk.TextIter iter, Gtk.TextChildAnchor anchor)
		{
			ChildAnchorInsertedNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("insert_child_anchor"));
				unmanaged = (ChildAnchorInsertedNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(ChildAnchorInsertedNativeDelegate));
			}
			if (unmanaged == null) return;

			IntPtr native_iter = GLib.Marshaller.StructureToPtrAlloc (iter);
			unmanaged (this.Handle, native_iter, anchor == null ? IntPtr.Zero : anchor.Handle);
			Marshal.FreeHGlobal (native_iter);
		}

		static DeleteRangeNativeDelegate DeleteRange_cb_delegate;
		static DeleteRangeNativeDelegate DeleteRangeVMCallback {
			get {
				if (DeleteRange_cb_delegate == null)
					DeleteRange_cb_delegate = new DeleteRangeNativeDelegate (DeleteRange_cb);
				return DeleteRange_cb_delegate;
			}
		}

		static void OverrideDeleteRange (GLib.GType gtype)
		{
			OverrideDeleteRange (gtype, DeleteRangeVMCallback);
		}

		static void OverrideDeleteRange (GLib.GType gtype, DeleteRangeNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("delete_range"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void DeleteRangeNativeDelegate (IntPtr inst, IntPtr start, IntPtr end);

		static void DeleteRange_cb (IntPtr inst, IntPtr start, IntPtr end)
		{
			try {
				TextBuffer __obj = GLib.Object.GetObject (inst, false) as TextBuffer;
				__obj.OnDeleteRange (Gtk.TextIter.New (start), Gtk.TextIter.New (end));
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gtk.TextBuffer), ConnectionMethod="OverrideDeleteRange")]
		protected virtual void OnDeleteRange (Gtk.TextIter start, Gtk.TextIter end)
		{
			InternalDeleteRange (start, end);
		}

		private void InternalDeleteRange (Gtk.TextIter start, Gtk.TextIter end)
		{
			DeleteRangeNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("delete_range"));
				unmanaged = (DeleteRangeNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(DeleteRangeNativeDelegate));
			}
			if (unmanaged == null) return;

			IntPtr native_start = GLib.Marshaller.StructureToPtrAlloc (start);
			IntPtr native_end = GLib.Marshaller.StructureToPtrAlloc (end);
			unmanaged (this.Handle, native_start, native_end);
			Marshal.FreeHGlobal (native_start);
			Marshal.FreeHGlobal (native_end);
		}

		static ChangedNativeDelegate Changed_cb_delegate;
		static ChangedNativeDelegate ChangedVMCallback {
			get {
				if (Changed_cb_delegate == null)
					Changed_cb_delegate = new ChangedNativeDelegate (Changed_cb);
				return Changed_cb_delegate;
			}
		}

		static void OverrideChanged (GLib.GType gtype)
		{
			OverrideChanged (gtype, ChangedVMCallback);
		}

		static void OverrideChanged (GLib.GType gtype, ChangedNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("changed"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void ChangedNativeDelegate (IntPtr inst);

		static void Changed_cb (IntPtr inst)
		{
			try {
				TextBuffer __obj = GLib.Object.GetObject (inst, false) as TextBuffer;
				__obj.OnChanged ();
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gtk.TextBuffer), ConnectionMethod="OverrideChanged")]
		protected virtual void OnChanged ()
		{
			InternalChanged ();
		}

		private void InternalChanged ()
		{
			ChangedNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("changed"));
				unmanaged = (ChangedNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(ChangedNativeDelegate));
			}
			if (unmanaged == null) return;

			unmanaged (this.Handle);
		}

		static ModifiedChangedNativeDelegate ModifiedChanged_cb_delegate;
		static ModifiedChangedNativeDelegate ModifiedChangedVMCallback {
			get {
				if (ModifiedChanged_cb_delegate == null)
					ModifiedChanged_cb_delegate = new ModifiedChangedNativeDelegate (ModifiedChanged_cb);
				return ModifiedChanged_cb_delegate;
			}
		}

		static void OverrideModifiedChanged (GLib.GType gtype)
		{
			OverrideModifiedChanged (gtype, ModifiedChangedVMCallback);
		}

		static void OverrideModifiedChanged (GLib.GType gtype, ModifiedChangedNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("modified_changed"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void ModifiedChangedNativeDelegate (IntPtr inst);

		static void ModifiedChanged_cb (IntPtr inst)
		{
			try {
				TextBuffer __obj = GLib.Object.GetObject (inst, false) as TextBuffer;
				__obj.OnModifiedChanged ();
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gtk.TextBuffer), ConnectionMethod="OverrideModifiedChanged")]
		protected virtual void OnModifiedChanged ()
		{
			InternalModifiedChanged ();
		}

		private void InternalModifiedChanged ()
		{
			ModifiedChangedNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("modified_changed"));
				unmanaged = (ModifiedChangedNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(ModifiedChangedNativeDelegate));
			}
			if (unmanaged == null) return;

			unmanaged (this.Handle);
		}

		static MarkSetNativeDelegate MarkSet_cb_delegate;
		static MarkSetNativeDelegate MarkSetVMCallback {
			get {
				if (MarkSet_cb_delegate == null)
					MarkSet_cb_delegate = new MarkSetNativeDelegate (MarkSet_cb);
				return MarkSet_cb_delegate;
			}
		}

		static void OverrideMarkSet (GLib.GType gtype)
		{
			OverrideMarkSet (gtype, MarkSetVMCallback);
		}

		static void OverrideMarkSet (GLib.GType gtype, MarkSetNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("mark_set"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void MarkSetNativeDelegate (IntPtr inst, IntPtr location, IntPtr mark);

		static void MarkSet_cb (IntPtr inst, IntPtr location, IntPtr mark)
		{
			try {
				TextBuffer __obj = GLib.Object.GetObject (inst, false) as TextBuffer;
				__obj.OnMarkSet (Gtk.TextIter.New (location), GLib.Object.GetObject(mark) as Gtk.TextMark);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gtk.TextBuffer), ConnectionMethod="OverrideMarkSet")]
		protected virtual void OnMarkSet (Gtk.TextIter location, Gtk.TextMark mark)
		{
			InternalMarkSet (location, mark);
		}

		private void InternalMarkSet (Gtk.TextIter location, Gtk.TextMark mark)
		{
			MarkSetNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("mark_set"));
				unmanaged = (MarkSetNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(MarkSetNativeDelegate));
			}
			if (unmanaged == null) return;

			IntPtr native_location = GLib.Marshaller.StructureToPtrAlloc (location);
			unmanaged (this.Handle, native_location, mark == null ? IntPtr.Zero : mark.Handle);
			Marshal.FreeHGlobal (native_location);
		}

		static MarkDeletedNativeDelegate MarkDeleted_cb_delegate;
		static MarkDeletedNativeDelegate MarkDeletedVMCallback {
			get {
				if (MarkDeleted_cb_delegate == null)
					MarkDeleted_cb_delegate = new MarkDeletedNativeDelegate (MarkDeleted_cb);
				return MarkDeleted_cb_delegate;
			}
		}

		static void OverrideMarkDeleted (GLib.GType gtype)
		{
			OverrideMarkDeleted (gtype, MarkDeletedVMCallback);
		}

		static void OverrideMarkDeleted (GLib.GType gtype, MarkDeletedNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("mark_deleted"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void MarkDeletedNativeDelegate (IntPtr inst, IntPtr mark);

		static void MarkDeleted_cb (IntPtr inst, IntPtr mark)
		{
			try {
				TextBuffer __obj = GLib.Object.GetObject (inst, false) as TextBuffer;
				__obj.OnMarkDeleted (GLib.Object.GetObject(mark) as Gtk.TextMark);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gtk.TextBuffer), ConnectionMethod="OverrideMarkDeleted")]
		protected virtual void OnMarkDeleted (Gtk.TextMark mark)
		{
			InternalMarkDeleted (mark);
		}

		private void InternalMarkDeleted (Gtk.TextMark mark)
		{
			MarkDeletedNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("mark_deleted"));
				unmanaged = (MarkDeletedNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(MarkDeletedNativeDelegate));
			}
			if (unmanaged == null) return;

			unmanaged (this.Handle, mark == null ? IntPtr.Zero : mark.Handle);
		}

		static TagAppliedNativeDelegate TagApplied_cb_delegate;
		static TagAppliedNativeDelegate TagAppliedVMCallback {
			get {
				if (TagApplied_cb_delegate == null)
					TagApplied_cb_delegate = new TagAppliedNativeDelegate (TagApplied_cb);
				return TagApplied_cb_delegate;
			}
		}

		static void OverrideTagApplied (GLib.GType gtype)
		{
			OverrideTagApplied (gtype, TagAppliedVMCallback);
		}

		static void OverrideTagApplied (GLib.GType gtype, TagAppliedNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("apply_tag"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void TagAppliedNativeDelegate (IntPtr inst, IntPtr tag, IntPtr start, IntPtr end);

		static void TagApplied_cb (IntPtr inst, IntPtr tag, IntPtr start, IntPtr end)
		{
			try {
				TextBuffer __obj = GLib.Object.GetObject (inst, false) as TextBuffer;
				__obj.OnTagApplied (GLib.Object.GetObject(tag) as Gtk.TextTag, Gtk.TextIter.New (start), Gtk.TextIter.New (end));
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gtk.TextBuffer), ConnectionMethod="OverrideTagApplied")]
		protected virtual void OnTagApplied (Gtk.TextTag tag, Gtk.TextIter start, Gtk.TextIter end)
		{
			InternalTagApplied (tag, start, end);
		}

		private void InternalTagApplied (Gtk.TextTag tag, Gtk.TextIter start, Gtk.TextIter end)
		{
			TagAppliedNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("apply_tag"));
				unmanaged = (TagAppliedNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(TagAppliedNativeDelegate));
			}
			if (unmanaged == null) return;

			IntPtr native_start = GLib.Marshaller.StructureToPtrAlloc (start);
			IntPtr native_end = GLib.Marshaller.StructureToPtrAlloc (end);
			unmanaged (this.Handle, tag == null ? IntPtr.Zero : tag.Handle, native_start, native_end);
			Marshal.FreeHGlobal (native_start);
			Marshal.FreeHGlobal (native_end);
		}

		static TagRemovedNativeDelegate TagRemoved_cb_delegate;
		static TagRemovedNativeDelegate TagRemovedVMCallback {
			get {
				if (TagRemoved_cb_delegate == null)
					TagRemoved_cb_delegate = new TagRemovedNativeDelegate (TagRemoved_cb);
				return TagRemoved_cb_delegate;
			}
		}

		static void OverrideTagRemoved (GLib.GType gtype)
		{
			OverrideTagRemoved (gtype, TagRemovedVMCallback);
		}

		static void OverrideTagRemoved (GLib.GType gtype, TagRemovedNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("remove_tag"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void TagRemovedNativeDelegate (IntPtr inst, IntPtr tag, IntPtr start, IntPtr end);

		static void TagRemoved_cb (IntPtr inst, IntPtr tag, IntPtr start, IntPtr end)
		{
			try {
				TextBuffer __obj = GLib.Object.GetObject (inst, false) as TextBuffer;
				__obj.OnTagRemoved (GLib.Object.GetObject(tag) as Gtk.TextTag, Gtk.TextIter.New (start), Gtk.TextIter.New (end));
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gtk.TextBuffer), ConnectionMethod="OverrideTagRemoved")]
		protected virtual void OnTagRemoved (Gtk.TextTag tag, Gtk.TextIter start, Gtk.TextIter end)
		{
			InternalTagRemoved (tag, start, end);
		}

		private void InternalTagRemoved (Gtk.TextTag tag, Gtk.TextIter start, Gtk.TextIter end)
		{
			TagRemovedNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("remove_tag"));
				unmanaged = (TagRemovedNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(TagRemovedNativeDelegate));
			}
			if (unmanaged == null) return;

			IntPtr native_start = GLib.Marshaller.StructureToPtrAlloc (start);
			IntPtr native_end = GLib.Marshaller.StructureToPtrAlloc (end);
			unmanaged (this.Handle, tag == null ? IntPtr.Zero : tag.Handle, native_start, native_end);
			Marshal.FreeHGlobal (native_start);
			Marshal.FreeHGlobal (native_end);
		}

		static UserActionBegunNativeDelegate UserActionBegun_cb_delegate;
		static UserActionBegunNativeDelegate UserActionBegunVMCallback {
			get {
				if (UserActionBegun_cb_delegate == null)
					UserActionBegun_cb_delegate = new UserActionBegunNativeDelegate (UserActionBegun_cb);
				return UserActionBegun_cb_delegate;
			}
		}

		static void OverrideUserActionBegun (GLib.GType gtype)
		{
			OverrideUserActionBegun (gtype, UserActionBegunVMCallback);
		}

		static void OverrideUserActionBegun (GLib.GType gtype, UserActionBegunNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("begin_user_action"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void UserActionBegunNativeDelegate (IntPtr inst);

		static void UserActionBegun_cb (IntPtr inst)
		{
			try {
				TextBuffer __obj = GLib.Object.GetObject (inst, false) as TextBuffer;
				__obj.OnUserActionBegun ();
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gtk.TextBuffer), ConnectionMethod="OverrideUserActionBegun")]
		protected virtual void OnUserActionBegun ()
		{
			InternalUserActionBegun ();
		}

		private void InternalUserActionBegun ()
		{
			UserActionBegunNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("begin_user_action"));
				unmanaged = (UserActionBegunNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(UserActionBegunNativeDelegate));
			}
			if (unmanaged == null) return;

			unmanaged (this.Handle);
		}

		static UserActionEndedNativeDelegate UserActionEnded_cb_delegate;
		static UserActionEndedNativeDelegate UserActionEndedVMCallback {
			get {
				if (UserActionEnded_cb_delegate == null)
					UserActionEnded_cb_delegate = new UserActionEndedNativeDelegate (UserActionEnded_cb);
				return UserActionEnded_cb_delegate;
			}
		}

		static void OverrideUserActionEnded (GLib.GType gtype)
		{
			OverrideUserActionEnded (gtype, UserActionEndedVMCallback);
		}

		static void OverrideUserActionEnded (GLib.GType gtype, UserActionEndedNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("end_user_action"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void UserActionEndedNativeDelegate (IntPtr inst);

		static void UserActionEnded_cb (IntPtr inst)
		{
			try {
				TextBuffer __obj = GLib.Object.GetObject (inst, false) as TextBuffer;
				__obj.OnUserActionEnded ();
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gtk.TextBuffer), ConnectionMethod="OverrideUserActionEnded")]
		protected virtual void OnUserActionEnded ()
		{
			InternalUserActionEnded ();
		}

		private void InternalUserActionEnded ()
		{
			UserActionEndedNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("end_user_action"));
				unmanaged = (UserActionEndedNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(UserActionEndedNativeDelegate));
			}
			if (unmanaged == null) return;

			unmanaged (this.Handle);
		}

		static PasteDoneNativeDelegate PasteDone_cb_delegate;
		static PasteDoneNativeDelegate PasteDoneVMCallback {
			get {
				if (PasteDone_cb_delegate == null)
					PasteDone_cb_delegate = new PasteDoneNativeDelegate (PasteDone_cb);
				return PasteDone_cb_delegate;
			}
		}

		static void OverridePasteDone (GLib.GType gtype)
		{
			OverridePasteDone (gtype, PasteDoneVMCallback);
		}

		static void OverridePasteDone (GLib.GType gtype, PasteDoneNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("paste_done"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void PasteDoneNativeDelegate (IntPtr inst, IntPtr clipboard);

		static void PasteDone_cb (IntPtr inst, IntPtr clipboard)
		{
			try {
				TextBuffer __obj = GLib.Object.GetObject (inst, false) as TextBuffer;
				__obj.OnPasteDone (GLib.Object.GetObject(clipboard) as Gtk.Clipboard);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gtk.TextBuffer), ConnectionMethod="OverridePasteDone")]
		protected virtual void OnPasteDone (Gtk.Clipboard clipboard)
		{
			InternalPasteDone (clipboard);
		}

		private void InternalPasteDone (Gtk.Clipboard clipboard)
		{
			PasteDoneNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("paste_done"));
				unmanaged = (PasteDoneNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(PasteDoneNativeDelegate));
			}
			if (unmanaged == null) return;

			unmanaged (this.Handle, clipboard == null ? IntPtr.Zero : clipboard.Handle);
		}


		// Internal representation of the wrapped structure ABI.
		static GLib.AbiStruct _class_abi = null;
		static public new GLib.AbiStruct class_abi {
			get {
				if (_class_abi == null)
					_class_abi = new GLib.AbiStruct (new List<GLib.AbiField>{ 
						new GLib.AbiField("insert_text"
							, GLib.Object.class_abi.Fields
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // insert_text
							, null
							, "insert_pixbuf"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("insert_pixbuf"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // insert_pixbuf
							, "insert_text"
							, "insert_child_anchor"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("insert_child_anchor"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // insert_child_anchor
							, "insert_pixbuf"
							, "delete_range"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("delete_range"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // delete_range
							, "insert_child_anchor"
							, "changed"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("changed"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // changed
							, "delete_range"
							, "modified_changed"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("modified_changed"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // modified_changed
							, "changed"
							, "mark_set"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("mark_set"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // mark_set
							, "modified_changed"
							, "mark_deleted"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("mark_deleted"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // mark_deleted
							, "mark_set"
							, "apply_tag"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("apply_tag"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // apply_tag
							, "mark_deleted"
							, "remove_tag"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("remove_tag"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // remove_tag
							, "apply_tag"
							, "begin_user_action"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("begin_user_action"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // begin_user_action
							, "remove_tag"
							, "end_user_action"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("end_user_action"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // end_user_action
							, "begin_user_action"
							, "paste_done"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("paste_done"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // paste_done
							, "end_user_action"
							, "_gtk_reserved1"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("_gtk_reserved1"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // _gtk_reserved1
							, "paste_done"
							, "_gtk_reserved2"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("_gtk_reserved2"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // _gtk_reserved2
							, "_gtk_reserved1"
							, "_gtk_reserved3"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("_gtk_reserved3"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // _gtk_reserved3
							, "_gtk_reserved2"
							, "_gtk_reserved4"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("_gtk_reserved4"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // _gtk_reserved4
							, "_gtk_reserved3"
							, null
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
					});

				return _class_abi;
			}
		}


		// End of the ABI representation.

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_text_buffer_add_mark(IntPtr raw, IntPtr mark, IntPtr wh3r3);

		public void AddMark(Gtk.TextMark mark, Gtk.TextIter wh3r3) {
			IntPtr native_wh3r3 = GLib.Marshaller.StructureToPtrAlloc (wh3r3);
			gtk_text_buffer_add_mark(Handle, mark == null ? IntPtr.Zero : mark.Handle, native_wh3r3);
			Marshal.FreeHGlobal (native_wh3r3);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_text_buffer_add_selection_clipboard(IntPtr raw, IntPtr clipboard);

		public void AddSelectionClipboard(Gtk.Clipboard clipboard) {
			gtk_text_buffer_add_selection_clipboard(Handle, clipboard == null ? IntPtr.Zero : clipboard.Handle);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_text_buffer_apply_tag(IntPtr raw, IntPtr tag, IntPtr start, IntPtr end);

		public void ApplyTag(Gtk.TextTag tag, Gtk.TextIter start, Gtk.TextIter end) {
			IntPtr native_start = GLib.Marshaller.StructureToPtrAlloc (start);
			IntPtr native_end = GLib.Marshaller.StructureToPtrAlloc (end);
			gtk_text_buffer_apply_tag(Handle, tag == null ? IntPtr.Zero : tag.Handle, native_start, native_end);
			Marshal.FreeHGlobal (native_start);
			Marshal.FreeHGlobal (native_end);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_text_buffer_apply_tag_by_name(IntPtr raw, IntPtr name, IntPtr start, IntPtr end);

		public void ApplyTag(string name, Gtk.TextIter start, Gtk.TextIter end) {
			IntPtr native_name = GLib.Marshaller.StringToPtrGStrdup (name);
			IntPtr native_start = GLib.Marshaller.StructureToPtrAlloc (start);
			IntPtr native_end = GLib.Marshaller.StructureToPtrAlloc (end);
			gtk_text_buffer_apply_tag_by_name(Handle, native_name, native_start, native_end);
			GLib.Marshaller.Free (native_name);
			Marshal.FreeHGlobal (native_start);
			Marshal.FreeHGlobal (native_end);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gtk_text_buffer_backspace(IntPtr raw, IntPtr iter, bool interactive, bool default_editable);

		public bool Backspace(ref Gtk.TextIter iter, bool interactive, bool default_editable) {
			IntPtr native_iter = GLib.Marshaller.StructureToPtrAlloc (iter);
			bool raw_ret = gtk_text_buffer_backspace(Handle, native_iter, interactive, default_editable);
			bool ret = raw_ret;
			iter = Gtk.TextIter.New (native_iter);
			Marshal.FreeHGlobal (native_iter);
			return ret;
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_text_buffer_begin_user_action(IntPtr raw);

		public void BeginUserAction() {
			gtk_text_buffer_begin_user_action(Handle);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_text_buffer_copy_clipboard(IntPtr raw, IntPtr clipboard);

		public void CopyClipboard(Gtk.Clipboard clipboard) {
			gtk_text_buffer_copy_clipboard(Handle, clipboard == null ? IntPtr.Zero : clipboard.Handle);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gtk_text_buffer_create_child_anchor(IntPtr raw, IntPtr iter);

		public Gtk.TextChildAnchor CreateChildAnchor(ref Gtk.TextIter iter) {
			IntPtr native_iter = GLib.Marshaller.StructureToPtrAlloc (iter);
			IntPtr raw_ret = gtk_text_buffer_create_child_anchor(Handle, native_iter);
			Gtk.TextChildAnchor ret = GLib.Object.GetObject(raw_ret) as Gtk.TextChildAnchor;
			iter = Gtk.TextIter.New (native_iter);
			Marshal.FreeHGlobal (native_iter);
			return ret;
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gtk_text_buffer_create_mark(IntPtr raw, IntPtr mark_name, IntPtr wh3r3, bool left_gravity);

		public Gtk.TextMark CreateMark(string mark_name, Gtk.TextIter wh3r3, bool left_gravity) {
			IntPtr native_mark_name = GLib.Marshaller.StringToPtrGStrdup (mark_name);
			IntPtr native_wh3r3 = GLib.Marshaller.StructureToPtrAlloc (wh3r3);
			IntPtr raw_ret = gtk_text_buffer_create_mark(Handle, native_mark_name, native_wh3r3, left_gravity);
			Gtk.TextMark ret = GLib.Object.GetObject(raw_ret) as Gtk.TextMark;
			GLib.Marshaller.Free (native_mark_name);
			Marshal.FreeHGlobal (native_wh3r3);
			return ret;
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_text_buffer_cut_clipboard(IntPtr raw, IntPtr clipboard, bool default_editable);

		public void CutClipboard(Gtk.Clipboard clipboard, bool default_editable) {
			gtk_text_buffer_cut_clipboard(Handle, clipboard == null ? IntPtr.Zero : clipboard.Handle, default_editable);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_text_buffer_delete(IntPtr raw, IntPtr start, IntPtr end);

		public void Delete(ref Gtk.TextIter start, ref Gtk.TextIter end) {
			IntPtr native_start = GLib.Marshaller.StructureToPtrAlloc (start);
			IntPtr native_end = GLib.Marshaller.StructureToPtrAlloc (end);
			gtk_text_buffer_delete(Handle, native_start, native_end);
			start = Gtk.TextIter.New (native_start);
			Marshal.FreeHGlobal (native_start);
			end = Gtk.TextIter.New (native_end);
			Marshal.FreeHGlobal (native_end);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gtk_text_buffer_delete_interactive(IntPtr raw, IntPtr start_iter, IntPtr end_iter, bool default_editable);

		public bool DeleteInteractive(ref Gtk.TextIter start_iter, ref Gtk.TextIter end_iter, bool default_editable) {
			IntPtr native_start_iter = GLib.Marshaller.StructureToPtrAlloc (start_iter);
			IntPtr native_end_iter = GLib.Marshaller.StructureToPtrAlloc (end_iter);
			bool raw_ret = gtk_text_buffer_delete_interactive(Handle, native_start_iter, native_end_iter, default_editable);
			bool ret = raw_ret;
			start_iter = Gtk.TextIter.New (native_start_iter);
			Marshal.FreeHGlobal (native_start_iter);
			end_iter = Gtk.TextIter.New (native_end_iter);
			Marshal.FreeHGlobal (native_end_iter);
			return ret;
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_text_buffer_delete_mark(IntPtr raw, IntPtr mark);

		public void DeleteMark(Gtk.TextMark mark) {
			gtk_text_buffer_delete_mark(Handle, mark == null ? IntPtr.Zero : mark.Handle);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_text_buffer_delete_mark_by_name(IntPtr raw, IntPtr name);

		public void DeleteMark(string name) {
			IntPtr native_name = GLib.Marshaller.StringToPtrGStrdup (name);
			gtk_text_buffer_delete_mark_by_name(Handle, native_name);
			GLib.Marshaller.Free (native_name);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gtk_text_buffer_delete_selection(IntPtr raw, bool interactive, bool default_editable);

		public bool DeleteSelection(bool interactive, bool default_editable) {
			bool raw_ret = gtk_text_buffer_delete_selection(Handle, interactive, default_editable);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern unsafe bool gtk_text_buffer_deserialize(IntPtr raw, IntPtr content_buffer, IntPtr format, IntPtr iter, byte[] data, UIntPtr length, out IntPtr error);

		public unsafe bool Deserialize(Gtk.TextBuffer content_buffer, Gdk.Atom format, ref Gtk.TextIter iter, byte[] data, ulong length) {
			IntPtr native_iter = GLib.Marshaller.StructureToPtrAlloc (iter);
			IntPtr error = IntPtr.Zero;
			bool raw_ret = gtk_text_buffer_deserialize(Handle, content_buffer == null ? IntPtr.Zero : content_buffer.Handle, format == null ? IntPtr.Zero : format.Handle, native_iter, data, new UIntPtr (length), out error);
			bool ret = raw_ret;
			iter = Gtk.TextIter.New (native_iter);
			Marshal.FreeHGlobal (native_iter);
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gtk_text_buffer_deserialize_get_can_create_tags(IntPtr raw, IntPtr format);

		public bool DeserializeGetCanCreateTags(Gdk.Atom format) {
			bool raw_ret = gtk_text_buffer_deserialize_get_can_create_tags(Handle, format == null ? IntPtr.Zero : format.Handle);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_text_buffer_deserialize_set_can_create_tags(IntPtr raw, IntPtr format, bool can_create_tags);

		public void DeserializeSetCanCreateTags(Gdk.Atom format, bool can_create_tags) {
			gtk_text_buffer_deserialize_set_can_create_tags(Handle, format == null ? IntPtr.Zero : format.Handle, can_create_tags);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_text_buffer_end_user_action(IntPtr raw);

		public void EndUserAction() {
			gtk_text_buffer_end_user_action(Handle);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_text_buffer_get_bounds(IntPtr raw, IntPtr start, IntPtr end);

		public void GetBounds(out Gtk.TextIter start, out Gtk.TextIter end) {
			IntPtr native_start = Marshal.AllocHGlobal (Marshal.SizeOf (typeof (Gtk.TextIter)));
			IntPtr native_end = Marshal.AllocHGlobal (Marshal.SizeOf (typeof (Gtk.TextIter)));
			gtk_text_buffer_get_bounds(Handle, native_start, native_end);
			start = Gtk.TextIter.New (native_start);
			Marshal.FreeHGlobal (native_start);
			end = Gtk.TextIter.New (native_end);
			Marshal.FreeHGlobal (native_end);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gtk_text_buffer_get_char_count(IntPtr raw);

		public int CharCount { 
			get {
				int raw_ret = gtk_text_buffer_get_char_count(Handle);
				int ret = raw_ret;
				return ret;
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_text_buffer_get_end_iter(IntPtr raw, IntPtr iter);

		public Gtk.TextIter EndIter { 
			get {
				Gtk.TextIter iter;
				IntPtr native_iter = Marshal.AllocHGlobal (Marshal.SizeOf (typeof (Gtk.TextIter)));
				gtk_text_buffer_get_end_iter(Handle, native_iter);
				iter = Gtk.TextIter.New (native_iter);
				Marshal.FreeHGlobal (native_iter);
				return iter;
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gtk_text_buffer_get_insert(IntPtr raw);

		public Gtk.TextMark InsertMark { 
			get {
				IntPtr raw_ret = gtk_text_buffer_get_insert(Handle);
				Gtk.TextMark ret = GLib.Object.GetObject(raw_ret) as Gtk.TextMark;
				return ret;
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_text_buffer_get_iter_at_child_anchor(IntPtr raw, IntPtr iter, IntPtr anchor);

		public Gtk.TextIter GetIterAtChildAnchor(Gtk.TextChildAnchor anchor) {
			Gtk.TextIter iter;
			IntPtr native_iter = Marshal.AllocHGlobal (Marshal.SizeOf (typeof (Gtk.TextIter)));
			gtk_text_buffer_get_iter_at_child_anchor(Handle, native_iter, anchor == null ? IntPtr.Zero : anchor.Handle);
			iter = Gtk.TextIter.New (native_iter);
			Marshal.FreeHGlobal (native_iter);
			return iter;
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_text_buffer_get_iter_at_line(IntPtr raw, IntPtr iter, int line_number);

		public Gtk.TextIter GetIterAtLine(int line_number) {
			Gtk.TextIter iter;
			IntPtr native_iter = Marshal.AllocHGlobal (Marshal.SizeOf (typeof (Gtk.TextIter)));
			gtk_text_buffer_get_iter_at_line(Handle, native_iter, line_number);
			iter = Gtk.TextIter.New (native_iter);
			Marshal.FreeHGlobal (native_iter);
			return iter;
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_text_buffer_get_iter_at_line_index(IntPtr raw, IntPtr iter, int line_number, int byte_index);

		public Gtk.TextIter GetIterAtLineIndex(int line_number, int byte_index) {
			Gtk.TextIter iter;
			IntPtr native_iter = Marshal.AllocHGlobal (Marshal.SizeOf (typeof (Gtk.TextIter)));
			gtk_text_buffer_get_iter_at_line_index(Handle, native_iter, line_number, byte_index);
			iter = Gtk.TextIter.New (native_iter);
			Marshal.FreeHGlobal (native_iter);
			return iter;
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_text_buffer_get_iter_at_line_offset(IntPtr raw, IntPtr iter, int line_number, int char_offset);

		public Gtk.TextIter GetIterAtLineOffset(int line_number, int char_offset) {
			Gtk.TextIter iter;
			IntPtr native_iter = Marshal.AllocHGlobal (Marshal.SizeOf (typeof (Gtk.TextIter)));
			gtk_text_buffer_get_iter_at_line_offset(Handle, native_iter, line_number, char_offset);
			iter = Gtk.TextIter.New (native_iter);
			Marshal.FreeHGlobal (native_iter);
			return iter;
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_text_buffer_get_iter_at_mark(IntPtr raw, IntPtr iter, IntPtr mark);

		public Gtk.TextIter GetIterAtMark(Gtk.TextMark mark) {
			Gtk.TextIter iter;
			IntPtr native_iter = Marshal.AllocHGlobal (Marshal.SizeOf (typeof (Gtk.TextIter)));
			gtk_text_buffer_get_iter_at_mark(Handle, native_iter, mark == null ? IntPtr.Zero : mark.Handle);
			iter = Gtk.TextIter.New (native_iter);
			Marshal.FreeHGlobal (native_iter);
			return iter;
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_text_buffer_get_iter_at_offset(IntPtr raw, IntPtr iter, int char_offset);

		public Gtk.TextIter GetIterAtOffset(int char_offset) {
			Gtk.TextIter iter;
			IntPtr native_iter = Marshal.AllocHGlobal (Marshal.SizeOf (typeof (Gtk.TextIter)));
			gtk_text_buffer_get_iter_at_offset(Handle, native_iter, char_offset);
			iter = Gtk.TextIter.New (native_iter);
			Marshal.FreeHGlobal (native_iter);
			return iter;
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gtk_text_buffer_get_line_count(IntPtr raw);

		public int LineCount { 
			get {
				int raw_ret = gtk_text_buffer_get_line_count(Handle);
				int ret = raw_ret;
				return ret;
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gtk_text_buffer_get_mark(IntPtr raw, IntPtr name);

		public Gtk.TextMark GetMark(string name) {
			IntPtr native_name = GLib.Marshaller.StringToPtrGStrdup (name);
			IntPtr raw_ret = gtk_text_buffer_get_mark(Handle, native_name);
			Gtk.TextMark ret = GLib.Object.GetObject(raw_ret) as Gtk.TextMark;
			GLib.Marshaller.Free (native_name);
			return ret;
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gtk_text_buffer_get_modified(IntPtr raw);

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_text_buffer_set_modified(IntPtr raw, bool setting);

		public bool Modified { 
			get {
				bool raw_ret = gtk_text_buffer_get_modified(Handle);
				bool ret = raw_ret;
				return ret;
			}
			set {
				gtk_text_buffer_set_modified(Handle, value);
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gtk_text_buffer_get_selection_bound(IntPtr raw);

		public Gtk.TextMark SelectionBound { 
			get {
				IntPtr raw_ret = gtk_text_buffer_get_selection_bound(Handle);
				Gtk.TextMark ret = GLib.Object.GetObject(raw_ret) as Gtk.TextMark;
				return ret;
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gtk_text_buffer_get_selection_bounds(IntPtr raw, IntPtr start, IntPtr end);

		public bool GetSelectionBounds(out Gtk.TextIter start, out Gtk.TextIter end) {
			IntPtr native_start = Marshal.AllocHGlobal (Marshal.SizeOf (typeof (Gtk.TextIter)));
			IntPtr native_end = Marshal.AllocHGlobal (Marshal.SizeOf (typeof (Gtk.TextIter)));
			bool raw_ret = gtk_text_buffer_get_selection_bounds(Handle, native_start, native_end);
			bool ret = raw_ret;
			start = Gtk.TextIter.New (native_start);
			Marshal.FreeHGlobal (native_start);
			end = Gtk.TextIter.New (native_end);
			Marshal.FreeHGlobal (native_end);
			return ret;
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gtk_text_buffer_get_slice(IntPtr raw, IntPtr start, IntPtr end, bool include_hidden_chars);

		public string GetSlice(Gtk.TextIter start, Gtk.TextIter end, bool include_hidden_chars) {
			IntPtr native_start = GLib.Marshaller.StructureToPtrAlloc (start);
			IntPtr native_end = GLib.Marshaller.StructureToPtrAlloc (end);
			IntPtr raw_ret = gtk_text_buffer_get_slice(Handle, native_start, native_end, include_hidden_chars);
			string ret = GLib.Marshaller.PtrToStringGFree(raw_ret);
			Marshal.FreeHGlobal (native_start);
			Marshal.FreeHGlobal (native_end);
			return ret;
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_text_buffer_get_start_iter(IntPtr raw, IntPtr iter);

		public Gtk.TextIter StartIter { 
			get {
				Gtk.TextIter iter;
				IntPtr native_iter = Marshal.AllocHGlobal (Marshal.SizeOf (typeof (Gtk.TextIter)));
				gtk_text_buffer_get_start_iter(Handle, native_iter);
				iter = Gtk.TextIter.New (native_iter);
				Marshal.FreeHGlobal (native_iter);
				return iter;
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gtk_text_buffer_get_text(IntPtr raw, IntPtr start, IntPtr end, bool include_hidden_chars);

		public string GetText(Gtk.TextIter start, Gtk.TextIter end, bool include_hidden_chars) {
			IntPtr native_start = GLib.Marshaller.StructureToPtrAlloc (start);
			IntPtr native_end = GLib.Marshaller.StructureToPtrAlloc (end);
			IntPtr raw_ret = gtk_text_buffer_get_text(Handle, native_start, native_end, include_hidden_chars);
			string ret = GLib.Marshaller.PtrToStringGFree(raw_ret);
			Marshal.FreeHGlobal (native_start);
			Marshal.FreeHGlobal (native_end);
			return ret;
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gtk_text_buffer_get_type();

		public static new GLib.GType GType { 
			get {
				IntPtr raw_ret = gtk_text_buffer_get_type();
				GLib.GType ret = new GLib.GType(raw_ret);
				return ret;
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_text_buffer_insert_child_anchor(IntPtr raw, IntPtr iter, IntPtr anchor);

		public void InsertChildAnchor(ref Gtk.TextIter iter, Gtk.TextChildAnchor anchor) {
			IntPtr native_iter = GLib.Marshaller.StructureToPtrAlloc (iter);
			gtk_text_buffer_insert_child_anchor(Handle, native_iter, anchor == null ? IntPtr.Zero : anchor.Handle);
			iter = Gtk.TextIter.New (native_iter);
			Marshal.FreeHGlobal (native_iter);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_text_buffer_insert_markup(IntPtr raw, IntPtr iter, IntPtr markup, int len);

		public void InsertMarkup(ref Gtk.TextIter iter, string markup) {
			IntPtr native_iter = GLib.Marshaller.StructureToPtrAlloc (iter);
			IntPtr native_markup = GLib.Marshaller.StringToPtrGStrdup (markup);
			gtk_text_buffer_insert_markup(Handle, native_iter, native_markup, System.Text.Encoding.UTF8.GetByteCount (markup));
			iter = Gtk.TextIter.New (native_iter);
			Marshal.FreeHGlobal (native_iter);
			GLib.Marshaller.Free (native_markup);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_text_buffer_insert_pixbuf(IntPtr raw, IntPtr iter, IntPtr pixbuf);

		public void InsertPixbuf(ref Gtk.TextIter iter, Gdk.Pixbuf pixbuf) {
			IntPtr native_iter = GLib.Marshaller.StructureToPtrAlloc (iter);
			gtk_text_buffer_insert_pixbuf(Handle, native_iter, pixbuf == null ? IntPtr.Zero : pixbuf.Handle);
			iter = Gtk.TextIter.New (native_iter);
			Marshal.FreeHGlobal (native_iter);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_text_buffer_insert_range(IntPtr raw, IntPtr iter, IntPtr start, IntPtr end);

		public void InsertRange(ref Gtk.TextIter iter, Gtk.TextIter start, Gtk.TextIter end) {
			IntPtr native_iter = GLib.Marshaller.StructureToPtrAlloc (iter);
			IntPtr native_start = GLib.Marshaller.StructureToPtrAlloc (start);
			IntPtr native_end = GLib.Marshaller.StructureToPtrAlloc (end);
			gtk_text_buffer_insert_range(Handle, native_iter, native_start, native_end);
			iter = Gtk.TextIter.New (native_iter);
			Marshal.FreeHGlobal (native_iter);
			Marshal.FreeHGlobal (native_start);
			Marshal.FreeHGlobal (native_end);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gtk_text_buffer_insert_range_interactive(IntPtr raw, IntPtr iter, IntPtr start, IntPtr end, bool default_editable);

		public bool InsertRangeInteractive(ref Gtk.TextIter iter, Gtk.TextIter start, Gtk.TextIter end, bool default_editable) {
			IntPtr native_iter = GLib.Marshaller.StructureToPtrAlloc (iter);
			IntPtr native_start = GLib.Marshaller.StructureToPtrAlloc (start);
			IntPtr native_end = GLib.Marshaller.StructureToPtrAlloc (end);
			bool raw_ret = gtk_text_buffer_insert_range_interactive(Handle, native_iter, native_start, native_end, default_editable);
			bool ret = raw_ret;
			iter = Gtk.TextIter.New (native_iter);
			Marshal.FreeHGlobal (native_iter);
			Marshal.FreeHGlobal (native_start);
			Marshal.FreeHGlobal (native_end);
			return ret;
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_text_buffer_move_mark(IntPtr raw, IntPtr mark, IntPtr wh3r3);

		public void MoveMark(Gtk.TextMark mark, Gtk.TextIter wh3r3) {
			IntPtr native_wh3r3 = GLib.Marshaller.StructureToPtrAlloc (wh3r3);
			gtk_text_buffer_move_mark(Handle, mark == null ? IntPtr.Zero : mark.Handle, native_wh3r3);
			Marshal.FreeHGlobal (native_wh3r3);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_text_buffer_move_mark_by_name(IntPtr raw, IntPtr name, IntPtr wh3r3);

		public void MoveMark(string name, Gtk.TextIter wh3r3) {
			IntPtr native_name = GLib.Marshaller.StringToPtrGStrdup (name);
			IntPtr native_wh3r3 = GLib.Marshaller.StructureToPtrAlloc (wh3r3);
			gtk_text_buffer_move_mark_by_name(Handle, native_name, native_wh3r3);
			GLib.Marshaller.Free (native_name);
			Marshal.FreeHGlobal (native_wh3r3);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_text_buffer_paste_clipboard(IntPtr raw, IntPtr clipboard, IntPtr override_location, bool default_editable);

		public void PasteClipboard(Gtk.Clipboard clipboard, ref Gtk.TextIter override_location, bool default_editable) {
			IntPtr native_override_location = GLib.Marshaller.StructureToPtrAlloc (override_location);
			gtk_text_buffer_paste_clipboard(Handle, clipboard == null ? IntPtr.Zero : clipboard.Handle, native_override_location, default_editable);
			override_location = Gtk.TextIter.New (native_override_location);
			Marshal.FreeHGlobal (native_override_location);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_text_buffer_place_cursor(IntPtr raw, IntPtr wh3r3);

		public void PlaceCursor(Gtk.TextIter wh3r3) {
			IntPtr native_wh3r3 = GLib.Marshaller.StructureToPtrAlloc (wh3r3);
			gtk_text_buffer_place_cursor(Handle, native_wh3r3);
			Marshal.FreeHGlobal (native_wh3r3);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gtk_text_buffer_register_deserialize_format(IntPtr raw, IntPtr mime_type, GtkSharp.TextBufferDeserializeFuncNative function, IntPtr user_data, GLib.DestroyNotify user_data_destroy);

		public Gdk.Atom RegisterDeserializeFormat(string mime_type, Gtk.TextBufferDeserializeFunc function) {
			IntPtr native_mime_type = GLib.Marshaller.StringToPtrGStrdup (mime_type);
			GtkSharp.TextBufferDeserializeFuncWrapper function_wrapper = new GtkSharp.TextBufferDeserializeFuncWrapper (function);
			IntPtr user_data;
			GLib.DestroyNotify user_data_destroy;
			if (function == null) {
				user_data = IntPtr.Zero;
				user_data_destroy = null;
			} else {
				user_data = (IntPtr) GCHandle.Alloc (function_wrapper);
				user_data_destroy = GLib.DestroyHelper.NotifyHandler;
			}
			IntPtr raw_ret = gtk_text_buffer_register_deserialize_format(Handle, native_mime_type, function_wrapper.NativeDelegate, user_data, user_data_destroy);
			Gdk.Atom ret = raw_ret == IntPtr.Zero ? null : (Gdk.Atom) GLib.Opaque.GetOpaque (raw_ret, typeof (Gdk.Atom), false);
			GLib.Marshaller.Free (native_mime_type);
			return ret;
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gtk_text_buffer_register_deserialize_tagset(IntPtr raw, IntPtr tagset_name);

		public Gdk.Atom RegisterDeserializeTagset(string tagset_name) {
			IntPtr native_tagset_name = GLib.Marshaller.StringToPtrGStrdup (tagset_name);
			IntPtr raw_ret = gtk_text_buffer_register_deserialize_tagset(Handle, native_tagset_name);
			Gdk.Atom ret = raw_ret == IntPtr.Zero ? null : (Gdk.Atom) GLib.Opaque.GetOpaque (raw_ret, typeof (Gdk.Atom), false);
			GLib.Marshaller.Free (native_tagset_name);
			return ret;
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gtk_text_buffer_register_serialize_format(IntPtr raw, IntPtr mime_type, GtkSharp.TextBufferSerializeFuncNative function, IntPtr user_data, GLib.DestroyNotify user_data_destroy);

		public Gdk.Atom RegisterSerializeFormat(string mime_type, Gtk.TextBufferSerializeFunc function) {
			IntPtr native_mime_type = GLib.Marshaller.StringToPtrGStrdup (mime_type);
			GtkSharp.TextBufferSerializeFuncWrapper function_wrapper = new GtkSharp.TextBufferSerializeFuncWrapper (function);
			IntPtr user_data;
			GLib.DestroyNotify user_data_destroy;
			if (function == null) {
				user_data = IntPtr.Zero;
				user_data_destroy = null;
			} else {
				user_data = (IntPtr) GCHandle.Alloc (function_wrapper);
				user_data_destroy = GLib.DestroyHelper.NotifyHandler;
			}
			IntPtr raw_ret = gtk_text_buffer_register_serialize_format(Handle, native_mime_type, function_wrapper.NativeDelegate, user_data, user_data_destroy);
			Gdk.Atom ret = raw_ret == IntPtr.Zero ? null : (Gdk.Atom) GLib.Opaque.GetOpaque (raw_ret, typeof (Gdk.Atom), false);
			GLib.Marshaller.Free (native_mime_type);
			return ret;
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gtk_text_buffer_register_serialize_tagset(IntPtr raw, IntPtr tagset_name);

		public Gdk.Atom RegisterSerializeTagset(string tagset_name) {
			IntPtr native_tagset_name = GLib.Marshaller.StringToPtrGStrdup (tagset_name);
			IntPtr raw_ret = gtk_text_buffer_register_serialize_tagset(Handle, native_tagset_name);
			Gdk.Atom ret = raw_ret == IntPtr.Zero ? null : (Gdk.Atom) GLib.Opaque.GetOpaque (raw_ret, typeof (Gdk.Atom), false);
			GLib.Marshaller.Free (native_tagset_name);
			return ret;
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_text_buffer_remove_all_tags(IntPtr raw, IntPtr start, IntPtr end);

		public void RemoveAllTags(Gtk.TextIter start, Gtk.TextIter end) {
			IntPtr native_start = GLib.Marshaller.StructureToPtrAlloc (start);
			IntPtr native_end = GLib.Marshaller.StructureToPtrAlloc (end);
			gtk_text_buffer_remove_all_tags(Handle, native_start, native_end);
			Marshal.FreeHGlobal (native_start);
			Marshal.FreeHGlobal (native_end);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_text_buffer_remove_selection_clipboard(IntPtr raw, IntPtr clipboard);

		public void RemoveSelectionClipboard(Gtk.Clipboard clipboard) {
			gtk_text_buffer_remove_selection_clipboard(Handle, clipboard == null ? IntPtr.Zero : clipboard.Handle);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_text_buffer_remove_tag(IntPtr raw, IntPtr tag, IntPtr start, IntPtr end);

		public void RemoveTag(Gtk.TextTag tag, Gtk.TextIter start, Gtk.TextIter end) {
			IntPtr native_start = GLib.Marshaller.StructureToPtrAlloc (start);
			IntPtr native_end = GLib.Marshaller.StructureToPtrAlloc (end);
			gtk_text_buffer_remove_tag(Handle, tag == null ? IntPtr.Zero : tag.Handle, native_start, native_end);
			Marshal.FreeHGlobal (native_start);
			Marshal.FreeHGlobal (native_end);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_text_buffer_remove_tag_by_name(IntPtr raw, IntPtr name, IntPtr start, IntPtr end);

		public void RemoveTag(string name, Gtk.TextIter start, Gtk.TextIter end) {
			IntPtr native_name = GLib.Marshaller.StringToPtrGStrdup (name);
			IntPtr native_start = GLib.Marshaller.StructureToPtrAlloc (start);
			IntPtr native_end = GLib.Marshaller.StructureToPtrAlloc (end);
			gtk_text_buffer_remove_tag_by_name(Handle, native_name, native_start, native_end);
			GLib.Marshaller.Free (native_name);
			Marshal.FreeHGlobal (native_start);
			Marshal.FreeHGlobal (native_end);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_text_buffer_select_range(IntPtr raw, IntPtr ins, IntPtr bound);

		public void SelectRange(Gtk.TextIter ins, Gtk.TextIter bound) {
			IntPtr native_ins = GLib.Marshaller.StructureToPtrAlloc (ins);
			IntPtr native_bound = GLib.Marshaller.StructureToPtrAlloc (bound);
			gtk_text_buffer_select_range(Handle, native_ins, native_bound);
			Marshal.FreeHGlobal (native_ins);
			Marshal.FreeHGlobal (native_bound);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_text_buffer_unregister_deserialize_format(IntPtr raw, IntPtr format);

		public void UnregisterDeserializeFormat(Gdk.Atom format) {
			gtk_text_buffer_unregister_deserialize_format(Handle, format == null ? IntPtr.Zero : format.Handle);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_text_buffer_unregister_serialize_format(IntPtr raw, IntPtr format);

		public void UnregisterSerializeFormat(Gdk.Atom format) {
			gtk_text_buffer_unregister_serialize_format(Handle, format == null ? IntPtr.Zero : format.Handle);
		}


		// Internal representation of the wrapped structure ABI.
		static GLib.AbiStruct _abi_info = null;
		static public new GLib.AbiStruct abi_info {
			get {
				if (_abi_info == null)
					_abi_info = new GLib.AbiStruct (new List<GLib.AbiField>{ 
						new GLib.AbiField("priv"
							, GLib.Object.abi_info.Fields
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // priv
							, null
							, null
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
					});

				return _abi_info;
			}
		}


		// End of the ABI representation.

#endregion
	}
}
