Title: Random Numbers
SPDX-License-Identifier: LGPL-2.1-or-later
SPDX-FileCopyrightText: 2000, 2002 Sebastian Wilhelmi
SPDX-FileCopyrightText: 2013 Colin Walters

# Random Numbers

The following functions allow you to use a portable, fast and good
pseudo-random number generator (PRNG).

Do not use this API for cryptographic purposes such as key
generation, nonces, salts or one-time pads.

This PRNG is suitable for non-cryptographic use such as in games
(shuffling a card deck, generating levels), generating data for
a test suite, etc. If you need random data for cryptographic
purposes, it is recommended to use platform-specific APIs such
as `/dev/random` on UNIX, or
[`CryptGenRandom()`](https://learn.microsoft.com/en-us/windows/win32/api/wincrypt/nf-wincrypt-cryptgenrandom)
on Windows.

[type@GLib.Rand] uses the Mersenne Twister PRNG, which was originally
developed by Makoto Matsumoto and Takuji Nishimura. Further
information can be found at
[this page](http://www.math.sci.hiroshima-u.ac.jp/~m-mat/MT/emt.html).

If you just need a random number, you simply call the `g_random_*()`
functions, which will create a globally used [type@GLib.Rand] and use the
according `g_rand_*()` functions internally:

 * [func@GLib.random_int]
 * [func@GLib.random_int_range]
 * [func@GLib.random_double]
 * [func@GLib.random_double_range]
 * [func@GLib.random_set_seed]

Whenever you need a stream of reproducible random numbers, you better create a
[type@GLib.Rand] yourself and use the `g_rand_*()` functions directly, which
will also be slightly faster. Initializing a [type@GLib.Rand] with a
certain seed will produce exactly the same series of random
numbers on all platforms. This can thus be used as a seed for
e.g. games.

The `g_rand*_range()` functions will return high quality equally
distributed random numbers, whereas for example the
`(g_random_int () % max)` approach often
doesn’t yield equally distributed numbers.

GLib changed the seeding algorithm for the pseudo-random number
generator Mersenne Twister, as used by [type@GLib.Rand]. This was necessary,
because some seeds would yield very bad pseudo-random streams.
Also the pseudo-random integers generated by `g_rand*_int_range()`
will have a slightly better equal distribution with the new
version of GLib.

The original seeding and generation algorithms, as found in
GLib 2.0.x, can be used instead of the new ones by setting the
environment variable `G_RANDOM_VERSION` to the value of `2.0`.
Use the GLib-2.0 algorithms only if you have sequences of numbers
generated with Glib-2.0 that you need to reproduce exactly.

