// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package f3

type Reaction struct {
	Common
	UserID  *Reference `json:"user_id"`
	Content string     `json:"content"`
}

func (o Reaction) Equal(other Reaction) bool {
	return o.Common.Equal(other.Common) &&
		nilOrEqual(o.UserID, other.UserID) &&
		o.Content == other.Content
}

func (o *Reaction) GetReferences() References {
	references := o.Common.GetReferences()
	if !o.UserID.IsNil() {
		references = append(references, o.UserID)
	}
	return references
}

func (o *Reaction) Clone() Interface {
	clone := &Reaction{}
	*clone = *o
	return clone
}
