// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package f3

import "time"

const (
	ReviewStatePending          = "PENDING"
	ReviewStateApproved         = "APPROVED"
	ReviewStateChangesRequested = "CHANGES_REQUESTED"
	ReviewStateCommented        = "COMMENTED"
	ReviewStateRequestReview    = "REQUEST_REVIEW"
	ReviewStateUnknown          = ""
)

type Review struct {
	Common
	ReviewerID *Reference `json:"reviewer_id"`
	Official   bool       `json:"official"`
	CommitID   string     `json:"commit_id"`
	Content    string     `json:"content"`
	CreatedAt  time.Time  `json:"created_at"`
	State      string     `json:"state"`
}

func (o Review) Equal(other Review) bool {
	return o.Common.Equal(other.Common) &&
		nilOrEqual(o.ReviewerID, other.ReviewerID) &&
		o.CommitID == other.CommitID &&
		o.Content == other.Content &&
		o.State == other.State
}

func (o *Review) GetReferences() References {
	references := o.Common.GetReferences()
	if !o.ReviewerID.IsNil() {
		references = append(references, o.ReviewerID)
	}
	return references
}

func (o *Review) Clone() Interface {
	clone := &Review{}
	*clone = *o
	return clone
}
