// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package forgejo

import (
	"context"
	"fmt"

	f3_tree "code.forgejo.org/f3/gof3/v3/tree/f3"
	"code.forgejo.org/f3/gof3/v3/tree/generic"

	forgejo_sdk "code.forgejo.org/f3/gof3/v3/forges/forgejo/sdk"
)

type pullRequests struct {
	container
}

func (o *pullRequests) ListPage(ctx context.Context, page int) generic.ChildrenSlice {
	pageSize := o.getPageSize()

	var err error
	var forgejoPullRequests []*forgejo_sdk.PullRequest

	owner := f3_tree.GetOwnerName(o.GetNode())
	project := f3_tree.GetProjectName(o.GetNode())

	forgejoPullRequests, resp, err := o.getClient().ListRepoPullRequests(owner, project, forgejo_sdk.ListPullRequestsOptions{
		ListOptions: forgejo_sdk.ListOptions{Page: page, PageSize: pageSize},
		State:       forgejo_sdk.StateAll,
	})
	// When there are not pull requests it returns 404 instead of an empty list
	if resp.StatusCode == 404 {
		return generic.NewChildrenSlice(0)
	}
	if err != nil {
		panic(fmt.Errorf("error while listing pullRequests: %v", err))
	}

	return f3_tree.ConvertListed(ctx, o.GetNode(), f3_tree.ConvertToAny(forgejoPullRequests...)...)
}

func newPullRequests() generic.NodeDriverInterface {
	return &pullRequests{}
}
