// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package f3

import (
	"context"

	"code.forgejo.org/f3/gof3/v3/id"
	"code.forgejo.org/f3/gof3/v3/kind"
	"code.forgejo.org/f3/gof3/v3/tree/generic"
)

type fixedChildrenNode struct {
	generic.Node

	kinds []kind.Kind
}

func (o *fixedChildrenNode) GetChildren() generic.ChildrenSlice {
	children := generic.NewChildrenSlice(len(o.kinds))
	for _, kind := range o.kinds {
		child := o.GetChild(id.NewNodeID(kind))
		children = append(children, child)
	}
	return children
}

func (o *fixedChildrenNode) ListPage(ctx context.Context, page int) generic.ChildrenSlice {
	if page > 1 {
		return generic.NewChildrenSlice(0)
	}
	return o.GetChildren()
}

func newFixedChildrenNode(ctx context.Context, tree generic.TreeInterface, kinds []kind.Kind) generic.NodeInterface {
	node := &fixedChildrenNode{}
	node.Init(node)
	node.kinds = kinds
	for _, kind := range kinds {
		id := id.NewNodeID(kind)
		child := tree.Factory(ctx, kind)
		child.SetID(id)
		child.SetParent(node)
		node.SetChild(child)
	}
	return node
}
