// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package objects

import (
	"io"
	"strings"
	"testing"

	"github.com/stretchr/testify/require"
)

type sha string

func (o *sha) SetSHA(s string) {
	*o = sha(s)
}

func (o *sha) GetSHA() string {
	return string(*o)
}

func Test_FuncReadAndSetSHA(t *testing.T) {
	content := "CONTENT"
	r := strings.NewReader(content)
	s := new(sha)
	f := FuncReadAndSetSHA(io.NopCloser(r), s)()
	c, err := io.ReadAll(f)
	require.NoError(t, err)
	require.NoError(t, f.Close())
	require.Equal(t, "65f23e22a9bfedda96929b3cfcb8b6d2fdd34a2e877ddb81f45d79ab05710e12", s.GetSHA())
	require.Equal(t, content, string(c))
}
