// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"github.com/aws/aws-sdk-go-v2/service/gamesparks/document"
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Details about a WebSocket connection.
type Connection struct {

	// The date and time when the connection was created.
	Created *time.Time

	// The identifier used to indicate a specific WebSocket connection.
	Id *string

	noSmithyDocumentSerde
}

// The result of the deployment.
type DeploymentResult struct {

	// Details about the deployment result.
	Message *string

	// The type of deployment result.
	ResultCode ResultCode

	noSmithyDocumentSerde
}

// Details about the extension.
type ExtensionDetails struct {

	// The description of the extension.
	Description *string

	// The name of the extension.
	Name *string

	// The namespace (qualifier) of the extension.
	Namespace *string

	noSmithyDocumentSerde
}

// Details about the extension version.
type ExtensionVersionDetails struct {

	// The name of the extension.
	Name *string

	// The namespace (qualifier) of the extension.
	Namespace *string

	// The model that defines the interface for this extension version.
	Schema *string

	// The version of the extension.
	Version *string

	noSmithyDocumentSerde
}

// Details about the game configuration. The game configuration is organized into
// named sections, where the schema of each section is defined by an extension. The
// schema for these sections can be retrieved using the GetExtensionVersion
// operation.
type GameConfigurationDetails struct {

	// The date when the game was created.
	Created *time.Time

	// The date when the game was last modified.
	LastUpdated *time.Time

	// Configuration data, organized by section name.
	Sections map[string]Section

	noSmithyDocumentSerde
}

// Details about a game.
type GameDetails struct {

	// The Amazon Resource Name (ARN) of this game.
	Arn *string

	// The date when the game was created.
	Created *time.Time

	// The description of the game.
	Description *string

	// Determines if the game can be deleted.
	EnableTerminationProtection bool

	// The date when the game was last modified.
	LastUpdated *time.Time

	// The name of the game.
	Name *string

	// The state of the game.
	State GameState

	// The tags associated with the game.
	Tags map[string]string

	noSmithyDocumentSerde
}

// The summary of the properties of a game.
type GameSummary struct {

	// The description of the game.
	Description *string

	// The name of the game.
	Name *string

	// The state of the game.
	State GameState

	// The tags associated with the game.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Details about a generated code job.
type GeneratedCodeJobDetails struct {

	// The description of the generated code job.
	Description *string

	// The expiration date and time for the download URL. The download URL us
	// guaranteed to be available until at least this time.
	ExpirationTime *time.Time

	// The identifier for the generated code job.
	GeneratedCodeJobId *string

	// A presigned URL that can be used to download the generated code.
	S3Url *string

	// The status of the generated code job
	Status GeneratedCodeJobState

	noSmithyDocumentSerde
}

// Properties that specify the code generator for a generated code job.
type Generator struct {

	// The target version of the GameSparks Game SDK.
	GameSdkVersion *string

	// The programming language for the generated code. Not all languages are supported
	// for each platform. For cases where multiple languages are supported, this
	// parameter specifies the language to be used. If this value is omitted, the
	// default language for the target platform will be used.
	Language *string

	// The platform that will be used to run the generated code.
	TargetPlatform *string

	noSmithyDocumentSerde
}

// The source used to import configuration sections.
type ImportGameConfigurationSource struct {

	// The JSON string containing the configuration sections.
	//
	// This member is required.
	File []byte

	noSmithyDocumentSerde
}

// The configuration section.
type Section struct {

	// The content of a configuration section.
	Attributes document.Interface

	// The name of the section.
	Name *string

	// The size, in bytes, of the section contents.
	Size int32

	noSmithyDocumentSerde
}

// A single modification to the configuration section.
type SectionModification struct {

	// The operation to be performed on a configuration section. Content can be added,
	// deleted, or replaced within a section.
	//
	// This member is required.
	Operation Operation

	// The path within the section content to be modified.
	//
	// This member is required.
	Path *string

	// The name of the section to be modified.
	//
	// This member is required.
	Section *string

	// For add and replace operations, this is the value that will be used. This field
	// should be omitted for delete operations.
	Value document.Interface

	noSmithyDocumentSerde
}

// Properties that provide details of a snapshot.
type SnapshotDetails struct {

	// The timestamp of when the snapshot was created.
	Created *time.Time

	// The description of the snapshot.
	Description *string

	// The identifier of the snapshot.
	Id *string

	// The timestamp of when the snapshot was last updated.
	LastUpdated *time.Time

	// The sections in the snapshot.
	Sections map[string]Section

	noSmithyDocumentSerde
}

// The summary of the properties of a snapshot.
type SnapshotSummary struct {

	// The timestamp of when the snapshot was created.
	Created *time.Time

	// The description of the snapshot.
	Description *string

	// The identifier of the snapshot.
	Id *string

	// Then timestamp of when the snapshot was last updated.
	LastUpdated *time.Time

	noSmithyDocumentSerde
}

// Properties that provide details of a stage deployment.
type StageDeploymentDetails struct {

	// The timestamp of when the stage deployment was created.
	Created *time.Time

	// The type of action of the stage deployment.
	DeploymentAction DeploymentAction

	// The identifier of the deployment.
	DeploymentId *string

	// The result of the deployment.
	DeploymentResult *DeploymentResult

	// The state of the deployment.
	DeploymentState DeploymentState

	// The timestamp of when the deployment was last updated.
	LastUpdated *time.Time

	// The identifier of the snapshot associated with the stage deployment.
	SnapshotId *string

	noSmithyDocumentSerde
}

// The summary of the properties of a stage deployment.
type StageDeploymentSummary struct {

	// The type of action of the deployment.
	DeploymentAction DeploymentAction

	// The identifier of the deployment.
	DeploymentId *string

	// The result of the deployment.
	DeploymentResult *DeploymentResult

	// The state of the deployment.
	DeploymentState DeploymentState

	// The timestamp of when the deployment was last updated.
	LastUpdated *time.Time

	// The identifier of the snapshot associated with the stage deployment.
	SnapshotId *string

	noSmithyDocumentSerde
}

// Properties that provide details of a stage.
type StageDetails struct {

	// The Amazon Resource Name (ARN) of the stage.
	Arn *string

	// The timestamp of when the stage was created.
	Created *time.Time

	// The description of the stage.
	Description *string

	// The game key associated with the stage. The game key is a unique identifier that
	// the game client uses to connect to the GameSparks backend.
	GameKey *string

	// The timestamp of when the stage was last updated.
	LastUpdated *time.Time

	// The Amazon CloudWatch log group for game runtimes deployed to the stage.
	LogGroup *string

	// The name of the stage.
	Name *string

	// The Amazon Resource Name (ARN) of the role used to run the game runtimes
	// deployed to the stage.
	Role *string

	// The state of the stage.
	State StageState

	// The tags associated with the stage.
	Tags map[string]string

	noSmithyDocumentSerde
}

// The summary of the properties of a stage.
type StageSummary struct {

	// The description of the stage.
	Description *string

	// The game key associated with the stage. The game key is a unique identifier that
	// the game client uses to connect to the GameSparks backend.
	GameKey *string

	// The name of the stage.
	Name *string

	// The state of the stage.
	State StageState

	// The tags associated with the stage.
	Tags map[string]string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
