package udnssdk

import (
	"testing"
)

func Test_ListNotifications(t *testing.T) {
	if !enableIntegrationTests {
		t.SkipNow()
	}
	if !enableProbeTests {
		t.SkipNow()
	}

	testClient, err := NewClient(testUsername, testPassword, testBaseURL)
	if err != nil {
		t.Fatal(err)
	}

	r := RRSetKey{
		Zone: testProbeDomain,
		Type: testProbeType,
		Name: testProbeName,
	}
	events, resp, err := testClient.Notifications.Select(r, "")

	if err != nil {
		if resp != nil && resp.StatusCode == 404 {
			t.Logf("ERROR - %+v", err)
			t.SkipNow()
		}
		t.Fatal(err)
	}
	t.Logf("Notifications: %+v \n", events)
	t.Logf("Response: %+v\n", resp)
}

// TODO: Write a full Notification test suite.  We do use these.
