// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v2/resources/ad_group_criterion.proto

package resources

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	common "google.golang.org/genproto/googleapis/ads/googleads/v2/common"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v2/enums"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// An ad group criterion.
type AdGroupCriterion struct {
	// Immutable. The resource name of the ad group criterion.
	// Ad group criterion resource names have the form:
	//
	// `customers/{customer_id}/adGroupCriteria/{ad_group_id}~{criterion_id}`
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// Output only. The ID of the criterion.
	//
	// This field is ignored for mutates.
	CriterionId *wrappers.Int64Value `protobuf:"bytes,26,opt,name=criterion_id,json=criterionId,proto3" json:"criterion_id,omitempty"`
	// The status of the criterion.
	Status enums.AdGroupCriterionStatusEnum_AdGroupCriterionStatus `protobuf:"varint,3,opt,name=status,proto3,enum=google.ads.googleads.v2.enums.AdGroupCriterionStatusEnum_AdGroupCriterionStatus" json:"status,omitempty"`
	// Output only. Information regarding the quality of the criterion.
	QualityInfo *AdGroupCriterion_QualityInfo `protobuf:"bytes,4,opt,name=quality_info,json=qualityInfo,proto3" json:"quality_info,omitempty"`
	// Immutable. The ad group to which the criterion belongs.
	AdGroup *wrappers.StringValue `protobuf:"bytes,5,opt,name=ad_group,json=adGroup,proto3" json:"ad_group,omitempty"`
	// Output only. The type of the criterion.
	Type enums.CriterionTypeEnum_CriterionType `protobuf:"varint,25,opt,name=type,proto3,enum=google.ads.googleads.v2.enums.CriterionTypeEnum_CriterionType" json:"type,omitempty"`
	// Immutable. Whether to target (`false`) or exclude (`true`) the criterion.
	//
	// This field is immutable. To switch a criterion from positive to negative,
	// remove then re-add it.
	Negative *wrappers.BoolValue `protobuf:"bytes,31,opt,name=negative,proto3" json:"negative,omitempty"`
	// Output only. Serving status of the criterion.
	SystemServingStatus enums.CriterionSystemServingStatusEnum_CriterionSystemServingStatus `protobuf:"varint,52,opt,name=system_serving_status,json=systemServingStatus,proto3,enum=google.ads.googleads.v2.enums.CriterionSystemServingStatusEnum_CriterionSystemServingStatus" json:"system_serving_status,omitempty"`
	// Output only. Approval status of the criterion.
	ApprovalStatus enums.AdGroupCriterionApprovalStatusEnum_AdGroupCriterionApprovalStatus `protobuf:"varint,53,opt,name=approval_status,json=approvalStatus,proto3,enum=google.ads.googleads.v2.enums.AdGroupCriterionApprovalStatusEnum_AdGroupCriterionApprovalStatus" json:"approval_status,omitempty"`
	// The modifier for the bid when the criterion matches. The modifier must be
	// in the range: 0.1 - 10.0. Most targetable criteria types support modifiers.
	BidModifier *wrappers.DoubleValue `protobuf:"bytes,44,opt,name=bid_modifier,json=bidModifier,proto3" json:"bid_modifier,omitempty"`
	// The CPC (cost-per-click) bid.
	CpcBidMicros *wrappers.Int64Value `protobuf:"bytes,16,opt,name=cpc_bid_micros,json=cpcBidMicros,proto3" json:"cpc_bid_micros,omitempty"`
	// The CPM (cost-per-thousand viewable impressions) bid.
	CpmBidMicros *wrappers.Int64Value `protobuf:"bytes,17,opt,name=cpm_bid_micros,json=cpmBidMicros,proto3" json:"cpm_bid_micros,omitempty"`
	// The CPV (cost-per-view) bid.
	CpvBidMicros *wrappers.Int64Value `protobuf:"bytes,24,opt,name=cpv_bid_micros,json=cpvBidMicros,proto3" json:"cpv_bid_micros,omitempty"`
	// The CPC bid amount, expressed as a fraction of the advertised price
	// for some good or service. The valid range for the fraction is [0,1) and the
	// value stored here is 1,000,000 * [fraction].
	PercentCpcBidMicros *wrappers.Int64Value `protobuf:"bytes,33,opt,name=percent_cpc_bid_micros,json=percentCpcBidMicros,proto3" json:"percent_cpc_bid_micros,omitempty"`
	// Output only. The effective CPC (cost-per-click) bid.
	EffectiveCpcBidMicros *wrappers.Int64Value `protobuf:"bytes,18,opt,name=effective_cpc_bid_micros,json=effectiveCpcBidMicros,proto3" json:"effective_cpc_bid_micros,omitempty"`
	// Output only. The effective CPM (cost-per-thousand viewable impressions) bid.
	EffectiveCpmBidMicros *wrappers.Int64Value `protobuf:"bytes,19,opt,name=effective_cpm_bid_micros,json=effectiveCpmBidMicros,proto3" json:"effective_cpm_bid_micros,omitempty"`
	// Output only. The effective CPV (cost-per-view) bid.
	EffectiveCpvBidMicros *wrappers.Int64Value `protobuf:"bytes,20,opt,name=effective_cpv_bid_micros,json=effectiveCpvBidMicros,proto3" json:"effective_cpv_bid_micros,omitempty"`
	// Output only. The effective Percent CPC bid amount.
	EffectivePercentCpcBidMicros *wrappers.Int64Value `protobuf:"bytes,34,opt,name=effective_percent_cpc_bid_micros,json=effectivePercentCpcBidMicros,proto3" json:"effective_percent_cpc_bid_micros,omitempty"`
	// Output only. Source of the effective CPC bid.
	EffectiveCpcBidSource enums.BiddingSourceEnum_BiddingSource `protobuf:"varint,21,opt,name=effective_cpc_bid_source,json=effectiveCpcBidSource,proto3,enum=google.ads.googleads.v2.enums.BiddingSourceEnum_BiddingSource" json:"effective_cpc_bid_source,omitempty"`
	// Output only. Source of the effective CPM bid.
	EffectiveCpmBidSource enums.BiddingSourceEnum_BiddingSource `protobuf:"varint,22,opt,name=effective_cpm_bid_source,json=effectiveCpmBidSource,proto3,enum=google.ads.googleads.v2.enums.BiddingSourceEnum_BiddingSource" json:"effective_cpm_bid_source,omitempty"`
	// Output only. Source of the effective CPV bid.
	EffectiveCpvBidSource enums.BiddingSourceEnum_BiddingSource `protobuf:"varint,23,opt,name=effective_cpv_bid_source,json=effectiveCpvBidSource,proto3,enum=google.ads.googleads.v2.enums.BiddingSourceEnum_BiddingSource" json:"effective_cpv_bid_source,omitempty"`
	// Output only. Source of the effective Percent CPC bid.
	EffectivePercentCpcBidSource enums.BiddingSourceEnum_BiddingSource `protobuf:"varint,35,opt,name=effective_percent_cpc_bid_source,json=effectivePercentCpcBidSource,proto3,enum=google.ads.googleads.v2.enums.BiddingSourceEnum_BiddingSource" json:"effective_percent_cpc_bid_source,omitempty"`
	// Output only. Estimates for criterion bids at various positions.
	PositionEstimates *AdGroupCriterion_PositionEstimates `protobuf:"bytes,10,opt,name=position_estimates,json=positionEstimates,proto3" json:"position_estimates,omitempty"`
	// The list of possible final URLs after all cross-domain redirects for the
	// ad.
	FinalUrls []*wrappers.StringValue `protobuf:"bytes,11,rep,name=final_urls,json=finalUrls,proto3" json:"final_urls,omitempty"`
	// The list of possible final mobile URLs after all cross-domain redirects.
	FinalMobileUrls []*wrappers.StringValue `protobuf:"bytes,51,rep,name=final_mobile_urls,json=finalMobileUrls,proto3" json:"final_mobile_urls,omitempty"`
	// URL template for appending params to final URL.
	FinalUrlSuffix *wrappers.StringValue `protobuf:"bytes,50,opt,name=final_url_suffix,json=finalUrlSuffix,proto3" json:"final_url_suffix,omitempty"`
	// The URL template for constructing a tracking URL.
	TrackingUrlTemplate *wrappers.StringValue `protobuf:"bytes,13,opt,name=tracking_url_template,json=trackingUrlTemplate,proto3" json:"tracking_url_template,omitempty"`
	// The list of mappings used to substitute custom parameter tags in a
	// `tracking_url_template`, `final_urls`, or `mobile_final_urls`.
	UrlCustomParameters []*common.CustomParameter `protobuf:"bytes,14,rep,name=url_custom_parameters,json=urlCustomParameters,proto3" json:"url_custom_parameters,omitempty"`
	// The ad group criterion.
	//
	// Exactly one must be set.
	//
	// Types that are valid to be assigned to Criterion:
	//	*AdGroupCriterion_Keyword
	//	*AdGroupCriterion_Placement
	//	*AdGroupCriterion_MobileAppCategory
	//	*AdGroupCriterion_MobileApplication
	//	*AdGroupCriterion_ListingGroup
	//	*AdGroupCriterion_AgeRange
	//	*AdGroupCriterion_Gender
	//	*AdGroupCriterion_IncomeRange
	//	*AdGroupCriterion_ParentalStatus
	//	*AdGroupCriterion_UserList
	//	*AdGroupCriterion_YoutubeVideo
	//	*AdGroupCriterion_YoutubeChannel
	//	*AdGroupCriterion_Topic
	//	*AdGroupCriterion_UserInterest
	//	*AdGroupCriterion_Webpage
	//	*AdGroupCriterion_AppPaymentModel
	//	*AdGroupCriterion_CustomAffinity
	//	*AdGroupCriterion_CustomIntent
	Criterion            isAdGroupCriterion_Criterion `protobuf_oneof:"criterion"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *AdGroupCriterion) Reset()         { *m = AdGroupCriterion{} }
func (m *AdGroupCriterion) String() string { return proto.CompactTextString(m) }
func (*AdGroupCriterion) ProtoMessage()    {}
func (*AdGroupCriterion) Descriptor() ([]byte, []int) {
	return fileDescriptor_9b297e97332d2125, []int{0}
}

func (m *AdGroupCriterion) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AdGroupCriterion.Unmarshal(m, b)
}
func (m *AdGroupCriterion) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AdGroupCriterion.Marshal(b, m, deterministic)
}
func (m *AdGroupCriterion) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdGroupCriterion.Merge(m, src)
}
func (m *AdGroupCriterion) XXX_Size() int {
	return xxx_messageInfo_AdGroupCriterion.Size(m)
}
func (m *AdGroupCriterion) XXX_DiscardUnknown() {
	xxx_messageInfo_AdGroupCriterion.DiscardUnknown(m)
}

var xxx_messageInfo_AdGroupCriterion proto.InternalMessageInfo

func (m *AdGroupCriterion) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *AdGroupCriterion) GetCriterionId() *wrappers.Int64Value {
	if m != nil {
		return m.CriterionId
	}
	return nil
}

func (m *AdGroupCriterion) GetStatus() enums.AdGroupCriterionStatusEnum_AdGroupCriterionStatus {
	if m != nil {
		return m.Status
	}
	return enums.AdGroupCriterionStatusEnum_UNSPECIFIED
}

func (m *AdGroupCriterion) GetQualityInfo() *AdGroupCriterion_QualityInfo {
	if m != nil {
		return m.QualityInfo
	}
	return nil
}

func (m *AdGroupCriterion) GetAdGroup() *wrappers.StringValue {
	if m != nil {
		return m.AdGroup
	}
	return nil
}

func (m *AdGroupCriterion) GetType() enums.CriterionTypeEnum_CriterionType {
	if m != nil {
		return m.Type
	}
	return enums.CriterionTypeEnum_UNSPECIFIED
}

func (m *AdGroupCriterion) GetNegative() *wrappers.BoolValue {
	if m != nil {
		return m.Negative
	}
	return nil
}

func (m *AdGroupCriterion) GetSystemServingStatus() enums.CriterionSystemServingStatusEnum_CriterionSystemServingStatus {
	if m != nil {
		return m.SystemServingStatus
	}
	return enums.CriterionSystemServingStatusEnum_UNSPECIFIED
}

func (m *AdGroupCriterion) GetApprovalStatus() enums.AdGroupCriterionApprovalStatusEnum_AdGroupCriterionApprovalStatus {
	if m != nil {
		return m.ApprovalStatus
	}
	return enums.AdGroupCriterionApprovalStatusEnum_UNSPECIFIED
}

func (m *AdGroupCriterion) GetBidModifier() *wrappers.DoubleValue {
	if m != nil {
		return m.BidModifier
	}
	return nil
}

func (m *AdGroupCriterion) GetCpcBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.CpcBidMicros
	}
	return nil
}

func (m *AdGroupCriterion) GetCpmBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.CpmBidMicros
	}
	return nil
}

func (m *AdGroupCriterion) GetCpvBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.CpvBidMicros
	}
	return nil
}

func (m *AdGroupCriterion) GetPercentCpcBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.PercentCpcBidMicros
	}
	return nil
}

func (m *AdGroupCriterion) GetEffectiveCpcBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.EffectiveCpcBidMicros
	}
	return nil
}

func (m *AdGroupCriterion) GetEffectiveCpmBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.EffectiveCpmBidMicros
	}
	return nil
}

func (m *AdGroupCriterion) GetEffectiveCpvBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.EffectiveCpvBidMicros
	}
	return nil
}

func (m *AdGroupCriterion) GetEffectivePercentCpcBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.EffectivePercentCpcBidMicros
	}
	return nil
}

func (m *AdGroupCriterion) GetEffectiveCpcBidSource() enums.BiddingSourceEnum_BiddingSource {
	if m != nil {
		return m.EffectiveCpcBidSource
	}
	return enums.BiddingSourceEnum_UNSPECIFIED
}

func (m *AdGroupCriterion) GetEffectiveCpmBidSource() enums.BiddingSourceEnum_BiddingSource {
	if m != nil {
		return m.EffectiveCpmBidSource
	}
	return enums.BiddingSourceEnum_UNSPECIFIED
}

func (m *AdGroupCriterion) GetEffectiveCpvBidSource() enums.BiddingSourceEnum_BiddingSource {
	if m != nil {
		return m.EffectiveCpvBidSource
	}
	return enums.BiddingSourceEnum_UNSPECIFIED
}

func (m *AdGroupCriterion) GetEffectivePercentCpcBidSource() enums.BiddingSourceEnum_BiddingSource {
	if m != nil {
		return m.EffectivePercentCpcBidSource
	}
	return enums.BiddingSourceEnum_UNSPECIFIED
}

func (m *AdGroupCriterion) GetPositionEstimates() *AdGroupCriterion_PositionEstimates {
	if m != nil {
		return m.PositionEstimates
	}
	return nil
}

func (m *AdGroupCriterion) GetFinalUrls() []*wrappers.StringValue {
	if m != nil {
		return m.FinalUrls
	}
	return nil
}

func (m *AdGroupCriterion) GetFinalMobileUrls() []*wrappers.StringValue {
	if m != nil {
		return m.FinalMobileUrls
	}
	return nil
}

func (m *AdGroupCriterion) GetFinalUrlSuffix() *wrappers.StringValue {
	if m != nil {
		return m.FinalUrlSuffix
	}
	return nil
}

func (m *AdGroupCriterion) GetTrackingUrlTemplate() *wrappers.StringValue {
	if m != nil {
		return m.TrackingUrlTemplate
	}
	return nil
}

func (m *AdGroupCriterion) GetUrlCustomParameters() []*common.CustomParameter {
	if m != nil {
		return m.UrlCustomParameters
	}
	return nil
}

type isAdGroupCriterion_Criterion interface {
	isAdGroupCriterion_Criterion()
}

type AdGroupCriterion_Keyword struct {
	Keyword *common.KeywordInfo `protobuf:"bytes,27,opt,name=keyword,proto3,oneof"`
}

type AdGroupCriterion_Placement struct {
	Placement *common.PlacementInfo `protobuf:"bytes,28,opt,name=placement,proto3,oneof"`
}

type AdGroupCriterion_MobileAppCategory struct {
	MobileAppCategory *common.MobileAppCategoryInfo `protobuf:"bytes,29,opt,name=mobile_app_category,json=mobileAppCategory,proto3,oneof"`
}

type AdGroupCriterion_MobileApplication struct {
	MobileApplication *common.MobileApplicationInfo `protobuf:"bytes,30,opt,name=mobile_application,json=mobileApplication,proto3,oneof"`
}

type AdGroupCriterion_ListingGroup struct {
	ListingGroup *common.ListingGroupInfo `protobuf:"bytes,32,opt,name=listing_group,json=listingGroup,proto3,oneof"`
}

type AdGroupCriterion_AgeRange struct {
	AgeRange *common.AgeRangeInfo `protobuf:"bytes,36,opt,name=age_range,json=ageRange,proto3,oneof"`
}

type AdGroupCriterion_Gender struct {
	Gender *common.GenderInfo `protobuf:"bytes,37,opt,name=gender,proto3,oneof"`
}

type AdGroupCriterion_IncomeRange struct {
	IncomeRange *common.IncomeRangeInfo `protobuf:"bytes,38,opt,name=income_range,json=incomeRange,proto3,oneof"`
}

type AdGroupCriterion_ParentalStatus struct {
	ParentalStatus *common.ParentalStatusInfo `protobuf:"bytes,39,opt,name=parental_status,json=parentalStatus,proto3,oneof"`
}

type AdGroupCriterion_UserList struct {
	UserList *common.UserListInfo `protobuf:"bytes,42,opt,name=user_list,json=userList,proto3,oneof"`
}

type AdGroupCriterion_YoutubeVideo struct {
	YoutubeVideo *common.YouTubeVideoInfo `protobuf:"bytes,40,opt,name=youtube_video,json=youtubeVideo,proto3,oneof"`
}

type AdGroupCriterion_YoutubeChannel struct {
	YoutubeChannel *common.YouTubeChannelInfo `protobuf:"bytes,41,opt,name=youtube_channel,json=youtubeChannel,proto3,oneof"`
}

type AdGroupCriterion_Topic struct {
	Topic *common.TopicInfo `protobuf:"bytes,43,opt,name=topic,proto3,oneof"`
}

type AdGroupCriterion_UserInterest struct {
	UserInterest *common.UserInterestInfo `protobuf:"bytes,45,opt,name=user_interest,json=userInterest,proto3,oneof"`
}

type AdGroupCriterion_Webpage struct {
	Webpage *common.WebpageInfo `protobuf:"bytes,46,opt,name=webpage,proto3,oneof"`
}

type AdGroupCriterion_AppPaymentModel struct {
	AppPaymentModel *common.AppPaymentModelInfo `protobuf:"bytes,47,opt,name=app_payment_model,json=appPaymentModel,proto3,oneof"`
}

type AdGroupCriterion_CustomAffinity struct {
	CustomAffinity *common.CustomAffinityInfo `protobuf:"bytes,48,opt,name=custom_affinity,json=customAffinity,proto3,oneof"`
}

type AdGroupCriterion_CustomIntent struct {
	CustomIntent *common.CustomIntentInfo `protobuf:"bytes,49,opt,name=custom_intent,json=customIntent,proto3,oneof"`
}

func (*AdGroupCriterion_Keyword) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_Placement) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_MobileAppCategory) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_MobileApplication) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_ListingGroup) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_AgeRange) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_Gender) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_IncomeRange) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_ParentalStatus) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_UserList) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_YoutubeVideo) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_YoutubeChannel) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_Topic) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_UserInterest) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_Webpage) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_AppPaymentModel) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_CustomAffinity) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_CustomIntent) isAdGroupCriterion_Criterion() {}

func (m *AdGroupCriterion) GetCriterion() isAdGroupCriterion_Criterion {
	if m != nil {
		return m.Criterion
	}
	return nil
}

func (m *AdGroupCriterion) GetKeyword() *common.KeywordInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_Keyword); ok {
		return x.Keyword
	}
	return nil
}

func (m *AdGroupCriterion) GetPlacement() *common.PlacementInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_Placement); ok {
		return x.Placement
	}
	return nil
}

func (m *AdGroupCriterion) GetMobileAppCategory() *common.MobileAppCategoryInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_MobileAppCategory); ok {
		return x.MobileAppCategory
	}
	return nil
}

func (m *AdGroupCriterion) GetMobileApplication() *common.MobileApplicationInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_MobileApplication); ok {
		return x.MobileApplication
	}
	return nil
}

func (m *AdGroupCriterion) GetListingGroup() *common.ListingGroupInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_ListingGroup); ok {
		return x.ListingGroup
	}
	return nil
}

func (m *AdGroupCriterion) GetAgeRange() *common.AgeRangeInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_AgeRange); ok {
		return x.AgeRange
	}
	return nil
}

func (m *AdGroupCriterion) GetGender() *common.GenderInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_Gender); ok {
		return x.Gender
	}
	return nil
}

func (m *AdGroupCriterion) GetIncomeRange() *common.IncomeRangeInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_IncomeRange); ok {
		return x.IncomeRange
	}
	return nil
}

func (m *AdGroupCriterion) GetParentalStatus() *common.ParentalStatusInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_ParentalStatus); ok {
		return x.ParentalStatus
	}
	return nil
}

func (m *AdGroupCriterion) GetUserList() *common.UserListInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_UserList); ok {
		return x.UserList
	}
	return nil
}

func (m *AdGroupCriterion) GetYoutubeVideo() *common.YouTubeVideoInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_YoutubeVideo); ok {
		return x.YoutubeVideo
	}
	return nil
}

func (m *AdGroupCriterion) GetYoutubeChannel() *common.YouTubeChannelInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_YoutubeChannel); ok {
		return x.YoutubeChannel
	}
	return nil
}

func (m *AdGroupCriterion) GetTopic() *common.TopicInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_Topic); ok {
		return x.Topic
	}
	return nil
}

func (m *AdGroupCriterion) GetUserInterest() *common.UserInterestInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_UserInterest); ok {
		return x.UserInterest
	}
	return nil
}

func (m *AdGroupCriterion) GetWebpage() *common.WebpageInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_Webpage); ok {
		return x.Webpage
	}
	return nil
}

func (m *AdGroupCriterion) GetAppPaymentModel() *common.AppPaymentModelInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_AppPaymentModel); ok {
		return x.AppPaymentModel
	}
	return nil
}

func (m *AdGroupCriterion) GetCustomAffinity() *common.CustomAffinityInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_CustomAffinity); ok {
		return x.CustomAffinity
	}
	return nil
}

func (m *AdGroupCriterion) GetCustomIntent() *common.CustomIntentInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_CustomIntent); ok {
		return x.CustomIntent
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*AdGroupCriterion) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*AdGroupCriterion_Keyword)(nil),
		(*AdGroupCriterion_Placement)(nil),
		(*AdGroupCriterion_MobileAppCategory)(nil),
		(*AdGroupCriterion_MobileApplication)(nil),
		(*AdGroupCriterion_ListingGroup)(nil),
		(*AdGroupCriterion_AgeRange)(nil),
		(*AdGroupCriterion_Gender)(nil),
		(*AdGroupCriterion_IncomeRange)(nil),
		(*AdGroupCriterion_ParentalStatus)(nil),
		(*AdGroupCriterion_UserList)(nil),
		(*AdGroupCriterion_YoutubeVideo)(nil),
		(*AdGroupCriterion_YoutubeChannel)(nil),
		(*AdGroupCriterion_Topic)(nil),
		(*AdGroupCriterion_UserInterest)(nil),
		(*AdGroupCriterion_Webpage)(nil),
		(*AdGroupCriterion_AppPaymentModel)(nil),
		(*AdGroupCriterion_CustomAffinity)(nil),
		(*AdGroupCriterion_CustomIntent)(nil),
	}
}

// A container for ad group criterion quality information.
type AdGroupCriterion_QualityInfo struct {
	// Output only. The quality score.
	//
	// This field may not be populated if Google does not have enough
	// information to determine a value.
	QualityScore *wrappers.Int32Value `protobuf:"bytes,1,opt,name=quality_score,json=qualityScore,proto3" json:"quality_score,omitempty"`
	// Output only. The performance of the ad compared to other advertisers.
	CreativeQualityScore enums.QualityScoreBucketEnum_QualityScoreBucket `protobuf:"varint,2,opt,name=creative_quality_score,json=creativeQualityScore,proto3,enum=google.ads.googleads.v2.enums.QualityScoreBucketEnum_QualityScoreBucket" json:"creative_quality_score,omitempty"`
	// Output only. The quality score of the landing page.
	PostClickQualityScore enums.QualityScoreBucketEnum_QualityScoreBucket `protobuf:"varint,3,opt,name=post_click_quality_score,json=postClickQualityScore,proto3,enum=google.ads.googleads.v2.enums.QualityScoreBucketEnum_QualityScoreBucket" json:"post_click_quality_score,omitempty"`
	// Output only. The click-through rate compared to that of other advertisers.
	SearchPredictedCtr   enums.QualityScoreBucketEnum_QualityScoreBucket `protobuf:"varint,4,opt,name=search_predicted_ctr,json=searchPredictedCtr,proto3,enum=google.ads.googleads.v2.enums.QualityScoreBucketEnum_QualityScoreBucket" json:"search_predicted_ctr,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                        `json:"-"`
	XXX_unrecognized     []byte                                          `json:"-"`
	XXX_sizecache        int32                                           `json:"-"`
}

func (m *AdGroupCriterion_QualityInfo) Reset()         { *m = AdGroupCriterion_QualityInfo{} }
func (m *AdGroupCriterion_QualityInfo) String() string { return proto.CompactTextString(m) }
func (*AdGroupCriterion_QualityInfo) ProtoMessage()    {}
func (*AdGroupCriterion_QualityInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_9b297e97332d2125, []int{0, 0}
}

func (m *AdGroupCriterion_QualityInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AdGroupCriterion_QualityInfo.Unmarshal(m, b)
}
func (m *AdGroupCriterion_QualityInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AdGroupCriterion_QualityInfo.Marshal(b, m, deterministic)
}
func (m *AdGroupCriterion_QualityInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdGroupCriterion_QualityInfo.Merge(m, src)
}
func (m *AdGroupCriterion_QualityInfo) XXX_Size() int {
	return xxx_messageInfo_AdGroupCriterion_QualityInfo.Size(m)
}
func (m *AdGroupCriterion_QualityInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_AdGroupCriterion_QualityInfo.DiscardUnknown(m)
}

var xxx_messageInfo_AdGroupCriterion_QualityInfo proto.InternalMessageInfo

func (m *AdGroupCriterion_QualityInfo) GetQualityScore() *wrappers.Int32Value {
	if m != nil {
		return m.QualityScore
	}
	return nil
}

func (m *AdGroupCriterion_QualityInfo) GetCreativeQualityScore() enums.QualityScoreBucketEnum_QualityScoreBucket {
	if m != nil {
		return m.CreativeQualityScore
	}
	return enums.QualityScoreBucketEnum_UNSPECIFIED
}

func (m *AdGroupCriterion_QualityInfo) GetPostClickQualityScore() enums.QualityScoreBucketEnum_QualityScoreBucket {
	if m != nil {
		return m.PostClickQualityScore
	}
	return enums.QualityScoreBucketEnum_UNSPECIFIED
}

func (m *AdGroupCriterion_QualityInfo) GetSearchPredictedCtr() enums.QualityScoreBucketEnum_QualityScoreBucket {
	if m != nil {
		return m.SearchPredictedCtr
	}
	return enums.QualityScoreBucketEnum_UNSPECIFIED
}

// Estimates for criterion bids at various positions.
type AdGroupCriterion_PositionEstimates struct {
	// Output only. The estimate of the CPC bid required for ad to be shown on first
	// page of search results.
	FirstPageCpcMicros *wrappers.Int64Value `protobuf:"bytes,1,opt,name=first_page_cpc_micros,json=firstPageCpcMicros,proto3" json:"first_page_cpc_micros,omitempty"`
	// Output only. The estimate of the CPC bid required for ad to be displayed in first
	// position, at the top of the first page of search results.
	FirstPositionCpcMicros *wrappers.Int64Value `protobuf:"bytes,2,opt,name=first_position_cpc_micros,json=firstPositionCpcMicros,proto3" json:"first_position_cpc_micros,omitempty"`
	// Output only. The estimate of the CPC bid required for ad to be displayed at the top
	// of the first page of search results.
	TopOfPageCpcMicros *wrappers.Int64Value `protobuf:"bytes,3,opt,name=top_of_page_cpc_micros,json=topOfPageCpcMicros,proto3" json:"top_of_page_cpc_micros,omitempty"`
	// Output only. Estimate of how many clicks per week you might get by changing your
	// keyword bid to the value in first_position_cpc_micros.
	EstimatedAddClicksAtFirstPositionCpc *wrappers.Int64Value `protobuf:"bytes,4,opt,name=estimated_add_clicks_at_first_position_cpc,json=estimatedAddClicksAtFirstPositionCpc,proto3" json:"estimated_add_clicks_at_first_position_cpc,omitempty"`
	// Output only. Estimate of how your cost per week might change when changing your
	// keyword bid to the value in first_position_cpc_micros.
	EstimatedAddCostAtFirstPositionCpc *wrappers.Int64Value `protobuf:"bytes,5,opt,name=estimated_add_cost_at_first_position_cpc,json=estimatedAddCostAtFirstPositionCpc,proto3" json:"estimated_add_cost_at_first_position_cpc,omitempty"`
	XXX_NoUnkeyedLiteral               struct{}             `json:"-"`
	XXX_unrecognized                   []byte               `json:"-"`
	XXX_sizecache                      int32                `json:"-"`
}

func (m *AdGroupCriterion_PositionEstimates) Reset()         { *m = AdGroupCriterion_PositionEstimates{} }
func (m *AdGroupCriterion_PositionEstimates) String() string { return proto.CompactTextString(m) }
func (*AdGroupCriterion_PositionEstimates) ProtoMessage()    {}
func (*AdGroupCriterion_PositionEstimates) Descriptor() ([]byte, []int) {
	return fileDescriptor_9b297e97332d2125, []int{0, 1}
}

func (m *AdGroupCriterion_PositionEstimates) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AdGroupCriterion_PositionEstimates.Unmarshal(m, b)
}
func (m *AdGroupCriterion_PositionEstimates) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AdGroupCriterion_PositionEstimates.Marshal(b, m, deterministic)
}
func (m *AdGroupCriterion_PositionEstimates) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdGroupCriterion_PositionEstimates.Merge(m, src)
}
func (m *AdGroupCriterion_PositionEstimates) XXX_Size() int {
	return xxx_messageInfo_AdGroupCriterion_PositionEstimates.Size(m)
}
func (m *AdGroupCriterion_PositionEstimates) XXX_DiscardUnknown() {
	xxx_messageInfo_AdGroupCriterion_PositionEstimates.DiscardUnknown(m)
}

var xxx_messageInfo_AdGroupCriterion_PositionEstimates proto.InternalMessageInfo

func (m *AdGroupCriterion_PositionEstimates) GetFirstPageCpcMicros() *wrappers.Int64Value {
	if m != nil {
		return m.FirstPageCpcMicros
	}
	return nil
}

func (m *AdGroupCriterion_PositionEstimates) GetFirstPositionCpcMicros() *wrappers.Int64Value {
	if m != nil {
		return m.FirstPositionCpcMicros
	}
	return nil
}

func (m *AdGroupCriterion_PositionEstimates) GetTopOfPageCpcMicros() *wrappers.Int64Value {
	if m != nil {
		return m.TopOfPageCpcMicros
	}
	return nil
}

func (m *AdGroupCriterion_PositionEstimates) GetEstimatedAddClicksAtFirstPositionCpc() *wrappers.Int64Value {
	if m != nil {
		return m.EstimatedAddClicksAtFirstPositionCpc
	}
	return nil
}

func (m *AdGroupCriterion_PositionEstimates) GetEstimatedAddCostAtFirstPositionCpc() *wrappers.Int64Value {
	if m != nil {
		return m.EstimatedAddCostAtFirstPositionCpc
	}
	return nil
}

func init() {
	proto.RegisterType((*AdGroupCriterion)(nil), "google.ads.googleads.v2.resources.AdGroupCriterion")
	proto.RegisterType((*AdGroupCriterion_QualityInfo)(nil), "google.ads.googleads.v2.resources.AdGroupCriterion.QualityInfo")
	proto.RegisterType((*AdGroupCriterion_PositionEstimates)(nil), "google.ads.googleads.v2.resources.AdGroupCriterion.PositionEstimates")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v2/resources/ad_group_criterion.proto", fileDescriptor_9b297e97332d2125)
}

var fileDescriptor_9b297e97332d2125 = []byte{
	// 1820 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x99, 0x4d, 0x73, 0x1b, 0xb7,
	0x19, 0xc7, 0x4b, 0xc9, 0x72, 0x2c, 0x48, 0x96, 0x2d, 0xc8, 0x52, 0x61, 0xc5, 0x4d, 0x64, 0x37,
	0x6e, 0x65, 0x3b, 0x26, 0x13, 0x3a, 0xee, 0xb4, 0xf4, 0xb4, 0x19, 0x92, 0xf5, 0x8b, 0xda, 0xb8,
	0x65, 0x28, 0x59, 0x19, 0xb7, 0x9a, 0xd9, 0x82, 0xbb, 0xd8, 0x15, 0x46, 0xbb, 0x8b, 0x0d, 0x80,
	0xa5, 0xcb, 0xa6, 0x99, 0xce, 0xb4, 0x33, 0xbd, 0x74, 0xa6, 0x3d, 0xf5, 0x0b, 0xf4, 0xd8, 0x8f,
	0xd2, 0x0f, 0xd1, 0xc9, 0xa1, 0xa7, 0x7c, 0x84, 0x9e, 0x32, 0x78, 0x59, 0x72, 0x97, 0x14, 0xb5,
	0x2b, 0x4f, 0x7c, 0x5b, 0x01, 0xf8, 0xff, 0xfe, 0x0f, 0x1e, 0x3c, 0x0b, 0x02, 0x2b, 0xd0, 0x0a,
	0x18, 0x0b, 0x42, 0xd2, 0xc0, 0x9e, 0x68, 0x98, 0x47, 0xf5, 0x34, 0x6c, 0x36, 0x38, 0x11, 0x2c,
	0xe5, 0x2e, 0x11, 0x0d, 0xec, 0x39, 0x01, 0x67, 0x69, 0xe2, 0xb8, 0x9c, 0x4a, 0xc2, 0x29, 0x8b,
	0xeb, 0x09, 0x67, 0x92, 0xc1, 0x9b, 0x46, 0x50, 0xc7, 0x9e, 0xa8, 0x8f, 0xb5, 0xf5, 0x61, 0xb3,
	0x3e, 0xd6, 0x6e, 0xdf, 0x9f, 0x87, 0x77, 0x59, 0x14, 0xb1, 0xb8, 0x61, 0x91, 0xd8, 0x10, 0xb7,
	0x1f, 0x96, 0x0d, 0x4f, 0x85, 0x64, 0x91, 0x93, 0x60, 0x8e, 0x23, 0x22, 0x09, 0xb7, 0xb2, 0x27,
	0xf3, 0x64, 0x24, 0x4e, 0xa3, 0xd3, 0x26, 0xe0, 0xe0, 0x24, 0xe1, 0x6c, 0x88, 0x43, 0x47, 0x48,
	0x2c, 0x53, 0x61, 0x39, 0x3f, 0x3d, 0x37, 0xa7, 0x20, 0x6f, 0x9e, 0x2d, 0x1f, 0x50, 0xcf, 0xa3,
	0x71, 0xe0, 0x98, 0xdc, 0x58, 0x4d, 0xf7, 0x6c, 0x4d, 0xce, 0x69, 0x24, 0x24, 0x89, 0x1c, 0x41,
	0xf8, 0x50, 0x43, 0xce, 0x61, 0x3c, 0x81, 0xc8, 0x51, 0x92, 0x19, 0xff, 0xf8, 0x6c, 0xcd, 0xe7,
	0x29, 0x0e, 0xa9, 0x1c, 0x39, 0xc2, 0x65, 0x9c, 0x38, 0x83, 0xd4, 0x3d, 0x21, 0xd2, 0x2a, 0xdf,
	0xcd, 0x94, 0x09, 0x6d, 0xf8, 0x94, 0x84, 0x9e, 0x33, 0x20, 0xc7, 0x78, 0x48, 0x59, 0xb6, 0x1c,
	0xd7, 0x73, 0x03, 0xb2, 0x52, 0xb0, 0x5d, 0xef, 0xd8, 0x2e, 0xfd, 0xd7, 0x20, 0xf5, 0x1b, 0xaf,
	0x38, 0x4e, 0x12, 0xc2, 0xb3, 0x99, 0xdc, 0xc8, 0x49, 0x71, 0x1c, 0x33, 0x89, 0x25, 0x65, 0xb1,
	0xed, 0xbd, 0xf5, 0xdf, 0xbb, 0xe0, 0x6a, 0xdb, 0x7b, 0xaa, 0xd6, 0xa0, 0x9b, 0xcd, 0x09, 0x1e,
	0x82, 0xcb, 0x99, 0x89, 0x13, 0xe3, 0x88, 0xa0, 0xda, 0x4e, 0x6d, 0x77, 0xb9, 0xf3, 0xe1, 0x57,
	0xed, 0xa5, 0xff, 0xb7, 0xef, 0x81, 0x3b, 0x93, 0xca, 0xb4, 0x4f, 0x09, 0x15, 0x75, 0x97, 0x45,
	0x8d, 0x69, 0x52, 0x7f, 0x35, 0xe3, 0xfc, 0x0a, 0x47, 0x04, 0x76, 0xc1, 0xea, 0x24, 0x71, 0xd4,
	0x43, 0xdb, 0x3b, 0xb5, 0xdd, 0x95, 0xe6, 0xdb, 0x96, 0x52, 0xcf, 0x66, 0x50, 0xdf, 0x8b, 0xe5,
	0x8f, 0x3e, 0x3a, 0xc4, 0x61, 0x4a, 0x3a, 0x8b, 0x5f, 0xb5, 0x17, 0xfb, 0x2b, 0x63, 0xd5, 0x9e,
	0x07, 0x8f, 0xc1, 0x45, 0xb3, 0x52, 0x68, 0x71, 0xa7, 0xb6, 0xbb, 0xd6, 0xec, 0xd5, 0xe7, 0xbd,
	0x33, 0x3a, 0xed, 0xf5, 0xe9, 0x98, 0xf6, 0xb5, 0xf8, 0x71, 0x9c, 0x46, 0x73, 0xba, 0xfa, 0x96,
	0x0f, 0x03, 0xb0, 0x9a, 0xad, 0x19, 0x8d, 0x7d, 0x86, 0x2e, 0xe8, 0x70, 0x3f, 0xae, 0x97, 0xbe,
	0xa3, 0x33, 0xe0, 0xfa, 0xa7, 0x86, 0xb3, 0x17, 0xfb, 0xcc, 0x4e, 0xe9, 0xf3, 0x49, 0x0b, 0xc4,
	0xe0, 0x52, 0xf6, 0x22, 0xa0, 0x25, 0x6d, 0x72, 0x63, 0x26, 0x27, 0xfb, 0x92, 0xd3, 0x38, 0x30,
	0x49, 0xd9, 0xd5, 0x0b, 0x71, 0x0b, 0xec, 0x94, 0x2d, 0x44, 0xff, 0x2d, 0x6c, 0x1e, 0xe0, 0x67,
	0xe0, 0x82, 0xaa, 0x54, 0x74, 0x5d, 0xe7, 0xec, 0x67, 0x25, 0x39, 0x1b, 0x07, 0x7e, 0x30, 0x4a,
	0x88, 0x4e, 0x55, 0xa1, 0xc5, 0x4c, 0x41, 0x03, 0xe1, 0x23, 0x70, 0x29, 0x26, 0x01, 0x96, 0x74,
	0x48, 0xd0, 0xbb, 0x3a, 0xf6, 0xed, 0x99, 0xd8, 0x3b, 0x8c, 0x85, 0xe3, 0xe5, 0x5c, 0xea, 0x8f,
	0x05, 0xf0, 0x9f, 0x35, 0xb0, 0x79, 0xea, 0x5b, 0x88, 0x3e, 0xd2, 0x71, 0x1e, 0x55, 0x8d, 0x73,
	0x5f, 0x43, 0xf6, 0x0d, 0x23, 0xb7, 0xc2, 0x67, 0x0d, 0x30, 0xb3, 0xd8, 0x10, 0xb3, 0x3d, 0xf0,
	0xef, 0x35, 0x70, 0x65, 0x6a, 0x3f, 0x43, 0x0f, 0x75, 0x44, 0xbf, 0x3b, 0x67, 0xb5, 0xb5, 0x2d,
	0xe5, 0x8c, 0xaa, 0x2b, 0x0e, 0x31, 0x51, 0xad, 0xe1, 0x42, 0x23, 0xfc, 0x18, 0xac, 0x0e, 0xa8,
	0xe7, 0x44, 0xcc, 0xa3, 0x3e, 0x25, 0x1c, 0xbd, 0x3f, 0xa7, 0x4a, 0x7e, 0xce, 0xd2, 0x41, 0x48,
	0x74, 0xae, 0xfb, 0x2b, 0x03, 0xea, 0x3d, 0xb7, 0x02, 0xd8, 0x06, 0x6b, 0x6e, 0xe2, 0x3a, 0x1a,
	0x42, 0x5d, 0xce, 0x04, 0xba, 0x5a, 0xfa, 0xf2, 0xf5, 0x57, 0xdd, 0xc4, 0xed, 0x50, 0xef, 0xb9,
	0x16, 0x18, 0x44, 0x94, 0x47, 0xac, 0x57, 0x42, 0x44, 0x53, 0x88, 0x61, 0x1e, 0x81, 0x2a, 0x21,
	0x86, 0x13, 0x44, 0x0f, 0x6c, 0x25, 0x84, 0xbb, 0x24, 0x96, 0xce, 0xd4, 0x84, 0x6e, 0x96, 0xa3,
	0x36, 0xac, 0xb4, 0x9b, 0x9f, 0xd7, 0x4b, 0x80, 0x88, 0xef, 0x13, 0x57, 0x55, 0xe4, 0x34, 0x13,
	0x56, 0xdc, 0xa1, 0x36, 0xc7, 0x84, 0xb3, 0xd0, 0x85, 0xe4, 0x6d, 0xbc, 0x06, 0x3a, 0x9a, 0x8b,
	0x2e, 0x24, 0xf5, 0xda, 0x6b, 0xa0, 0x73, 0x29, 0x3e, 0x06, 0x3b, 0x13, 0xf4, 0x9c, 0x64, 0xdf,
	0xaa, 0x68, 0x71, 0x63, 0x4c, 0xea, 0x9d, 0x92, 0xfa, 0x3f, 0x9e, 0x96, 0x7a, 0xb3, 0x89, 0xa2,
	0xcd, 0x4a, 0x3b, 0x55, 0xc7, 0x9c, 0x00, 0xf6, 0xb5, 0x46, 0xbf, 0x5e, 0x85, 0x96, 0xd3, 0x57,
	0xc7, 0xf4, 0x4d, 0xbb, 0x47, 0x79, 0xf7, 0xad, 0x37, 0xe3, 0x1e, 0xcd, 0x75, 0x1f, 0xe6, 0xdd,
	0xbf, 0xfb, 0x66, 0xdc, 0x87, 0x13, 0xf7, 0xbf, 0xd5, 0xce, 0x5a, 0x64, 0x1b, 0xc6, 0xf7, 0xbf,
	0xbd, 0x30, 0xe6, 0xd4, 0x81, 0x8d, 0x66, 0x04, 0x60, 0xc2, 0x04, 0x55, 0x07, 0x13, 0x87, 0x08,
	0x49, 0x23, 0x2c, 0x89, 0x40, 0x40, 0xd7, 0xd8, 0xe3, 0xd7, 0xf9, 0xbd, 0xed, 0x59, 0xda, 0xe3,
	0x0c, 0x66, 0xa2, 0x58, 0x4f, 0xa6, 0xdb, 0xe1, 0x23, 0x00, 0x7c, 0x1a, 0xe3, 0xd0, 0x49, 0x79,
	0x28, 0xd0, 0xca, 0xce, 0x62, 0xd9, 0xaf, 0x6f, 0x7f, 0x59, 0x8f, 0x7f, 0xc1, 0x43, 0x01, 0x9f,
	0x81, 0x75, 0x23, 0x8e, 0xd8, 0x80, 0x86, 0xc4, 0x30, 0x1e, 0x54, 0x60, 0x5c, 0xd1, 0xb2, 0xe7,
	0x5a, 0xa5, 0x49, 0x4f, 0xc0, 0xd5, 0x71, 0x18, 0x8e, 0x48, 0x7d, 0x9f, 0xfe, 0x1e, 0x35, 0xcb,
	0x8f, 0x02, 0xfd, 0xb5, 0x2c, 0x98, 0x7d, 0xad, 0x81, 0x3d, 0xb0, 0x29, 0x39, 0x76, 0x4f, 0xd4,
	0x4f, 0xa9, 0x42, 0x49, 0x12, 0x25, 0x21, 0x96, 0x04, 0x5d, 0xae, 0x00, 0xdb, 0xc8, 0xa4, 0x2f,
	0x78, 0x78, 0x60, 0x85, 0xd0, 0x05, 0x9b, 0x0a, 0x34, 0x7d, 0x4f, 0x10, 0x68, 0x4d, 0xcf, 0xb3,
	0x31, 0x77, 0x79, 0xcc, 0x05, 0xa3, 0xde, 0xd5, 0xc2, 0x5e, 0xa6, 0xeb, 0x6f, 0xa4, 0x3c, 0x9c,
	0x6a, 0x13, 0xf0, 0x13, 0xf0, 0xd6, 0x09, 0x19, 0xbd, 0x62, 0xdc, 0x43, 0x6f, 0xeb, 0x40, 0xef,
	0x95, 0x61, 0x7f, 0x69, 0x86, 0x67, 0x27, 0xaa, 0xa5, 0x67, 0xdf, 0xe9, 0x67, 0x08, 0xd8, 0x07,
	0xcb, 0x49, 0x88, 0x5d, 0x12, 0x91, 0x58, 0xa2, 0x1b, 0x9a, 0x77, 0xbf, 0x8c, 0xd7, 0xcb, 0x04,
	0x79, 0xe2, 0x04, 0x03, 0x43, 0xb0, 0x61, 0x17, 0x19, 0x27, 0x89, 0xe3, 0x62, 0x49, 0x02, 0xc6,
	0x47, 0xe8, 0x7b, 0x9a, 0xfe, 0xb0, 0x8c, 0x6e, 0x56, 0xba, 0x9d, 0x24, 0x5d, 0x2b, 0xcc, 0xbb,
	0xac, 0x47, 0xd3, 0xbd, 0xf0, 0x04, 0xc0, 0x89, 0x5b, 0x48, 0x5d, 0x7d, 0x66, 0x47, 0xef, 0x9c,
	0xd3, 0x2c, 0x13, 0x9e, 0x6e, 0x96, 0xf5, 0xc2, 0x23, 0x70, 0x39, 0xa4, 0x42, 0xaa, 0x92, 0x31,
	0x67, 0xd0, 0x1d, 0xed, 0xf3, 0x41, 0x99, 0xcf, 0x27, 0x46, 0xa4, 0x5f, 0xbd, 0xbc, 0xc5, 0x6a,
	0x98, 0xeb, 0x80, 0x3d, 0xb0, 0x8c, 0x03, 0xe2, 0x70, 0x1c, 0x07, 0x04, 0xbd, 0xa7, 0xc9, 0xef,
	0x97, 0x91, 0xdb, 0x01, 0xe9, 0xab, 0xf1, 0x79, 0xea, 0x25, 0x6c, 0x1b, 0xe1, 0x1e, 0xb8, 0x18,
	0x90, 0xd8, 0x23, 0x1c, 0xdd, 0xd6, 0xb8, 0xbb, 0x65, 0xb8, 0xa7, 0x7a, 0x74, 0x1e, 0x66, 0x01,
	0xf0, 0x25, 0x58, 0xa5, 0xb1, 0xcb, 0xa2, 0x2c, 0xbe, 0x1f, 0x68, 0x60, 0x69, 0x4d, 0xef, 0x69,
	0xcd, 0x4c, 0x88, 0x2b, 0x74, 0xd2, 0x0e, 0x07, 0xe0, 0x4a, 0x82, 0x39, 0x89, 0xe5, 0xe4, 0x08,
	0xf9, 0x43, 0x4d, 0x6f, 0x96, 0x96, 0xa2, 0x95, 0x99, 0xb3, 0x5f, 0xde, 0x60, 0x2d, 0x29, 0x74,
	0xa9, 0xdc, 0xa6, 0x82, 0x70, 0x47, 0x25, 0x1c, 0xdd, 0xad, 0x96, 0xdb, 0x17, 0x82, 0x70, 0xb5,
	0x72, 0x85, 0xdc, 0xa6, 0xb6, 0x51, 0xd5, 0xc2, 0x88, 0xa5, 0x32, 0x1d, 0x10, 0x67, 0x48, 0x3d,
	0xc2, 0xd0, 0x6e, 0xb5, 0x5a, 0x78, 0xc9, 0xd2, 0x83, 0x74, 0x40, 0x0e, 0x95, 0xa6, 0x50, 0x0b,
	0x96, 0xa6, 0x3b, 0x54, 0x4e, 0x32, 0xba, 0x7b, 0x8c, 0xe3, 0x98, 0x84, 0xe8, 0x4e, 0xb5, 0x9c,
	0x58, 0x7e, 0xd7, 0xa8, 0x0a, 0x39, 0xb1, 0x44, 0xdb, 0x05, 0x9f, 0x80, 0x25, 0xc9, 0x12, 0xea,
	0xa2, 0x7b, 0x9a, 0x7c, 0xa7, 0x8c, 0x7c, 0xa0, 0x06, 0xe7, 0x81, 0x46, 0xae, 0x32, 0xa1, 0x73,
	0x4b, 0x63, 0x49, 0x38, 0x11, 0x12, 0xdd, 0xaf, 0x96, 0x09, 0x95, 0xdf, 0x3d, 0xab, 0x29, 0x64,
	0x22, 0xcd, 0x75, 0xa8, 0x0d, 0xef, 0x15, 0x19, 0x24, 0x38, 0x20, 0xa8, 0x5e, 0x6d, 0xc3, 0xfb,
	0xcc, 0x0c, 0x2f, 0x6c, 0x78, 0x16, 0x01, 0x7d, 0xb0, 0xae, 0x76, 0xa5, 0x04, 0x8f, 0xd4, 0x5e,
	0xa5, 0xae, 0x09, 0x24, 0x44, 0x0d, 0xcd, 0x7d, 0x50, 0xfa, 0xae, 0x25, 0x49, 0xcf, 0xe8, 0x9e,
	0x2b, 0x59, 0x9e, 0xaf, 0xee, 0x40, 0xf9, 0x3e, 0xb5, 0x7e, 0xf6, 0x77, 0x00, 0xfb, 0x3e, 0x8d,
	0xa9, 0x1c, 0xa1, 0x0f, 0xaa, 0xad, 0x9f, 0xd9, 0xf1, 0xdb, 0x56, 0x55, 0x58, 0x3f, 0xb7, 0xd0,
	0xa5, 0xf2, 0x6e, 0x3d, 0x54, 0xe6, 0x63, 0x89, 0x3e, 0xac, 0x96, 0x77, 0xe3, 0xb0, 0xa7, 0x35,
	0x85, 0xbc, 0xbb, 0xb9, 0x8e, 0xed, 0xff, 0x2d, 0x82, 0x95, 0xdc, 0x65, 0x1c, 0x3e, 0x06, 0x97,
	0x0b, 0xdf, 0x65, 0xf4, 0xa7, 0x8e, 0x39, 0x07, 0xdb, 0x07, 0xcd, 0xdc, 0xc1, 0x36, 0xfb, 0x34,
	0xb0, 0xaf, 0x54, 0xf0, 0x2f, 0x35, 0xb0, 0xe5, 0x72, 0xa2, 0x6f, 0xb5, 0x4e, 0x11, 0xb8, 0xa0,
	0x0f, 0x51, 0xcf, 0x4a, 0x0e, 0x51, 0x9f, 0xe6, 0x68, 0x1d, 0xfd, 0x69, 0x48, 0x9f, 0xa4, 0x66,
	0x9b, 0x8d, 0xfb, 0xb5, 0xcc, 0x2c, 0x3f, 0x00, 0xfe, 0xb5, 0x06, 0x50, 0xc2, 0x84, 0x74, 0xdc,
	0x90, 0xba, 0x27, 0x53, 0x71, 0x2c, 0xbe, 0x89, 0x38, 0x36, 0x95, 0x5d, 0x57, 0xb9, 0x15, 0x02,
	0xf9, 0x13, 0xb8, 0x26, 0x08, 0xe6, 0xee, 0xb1, 0x93, 0x70, 0xe2, 0x51, 0x57, 0x12, 0xcf, 0x71,
	0x25, 0xd7, 0x5f, 0x50, 0xbe, 0xf5, 0x18, 0xa0, 0xb1, 0xea, 0x65, 0x4e, 0x5d, 0xc9, 0xb7, 0xff,
	0x71, 0x01, 0xac, 0xcf, 0x9c, 0x01, 0xe1, 0x3e, 0xd8, 0xf4, 0x29, 0x17, 0xd2, 0x51, 0x2f, 0x8d,
	0x3e, 0xec, 0xda, 0xdb, 0x4c, 0xad, 0xe2, 0x6d, 0x06, 0x6a, 0x79, 0x0f, 0x07, 0xea, 0x22, 0x61,
	0xef, 0x30, 0xbf, 0x05, 0xd7, 0x2d, 0x34, 0x3b, 0xc1, 0xe6, 0xc0, 0x0b, 0x15, 0xc1, 0x5b, 0x06,
	0x6c, 0x09, 0x13, 0xf8, 0x01, 0xd8, 0x92, 0x2c, 0x71, 0x98, 0x3f, 0x13, 0xf2, 0x62, 0xd5, 0x90,
	0x25, 0x4b, 0x7e, 0xed, 0x17, 0x43, 0xfe, 0x03, 0xb8, 0x9b, 0x9d, 0xb2, 0x3d, 0x07, 0x7b, 0x9e,
	0xa9, 0x17, 0xe1, 0x60, 0xe9, 0xcc, 0x4e, 0xc5, 0x7e, 0xf6, 0x2a, 0x77, 0x7a, 0x6f, 0xcc, 0x6c,
	0x7b, 0x9e, 0xae, 0x09, 0xd1, 0x96, 0x4f, 0xa6, 0xe6, 0x05, 0x87, 0x60, 0x77, 0xca, 0x5b, 0x15,
	0xec, 0xe9, 0xce, 0x4b, 0x15, 0x9d, 0x6f, 0x15, 0x9c, 0x99, 0x90, 0xb3, 0xbe, 0x2d, 0xfa, 0x75,
	0xdb, 0x3f, 0xc7, 0x97, 0x4b, 0xf8, 0x13, 0xb3, 0x6d, 0x10, 0x2e, 0x1a, 0x5f, 0x64, 0x8f, 0x5f,
	0x36, 0x70, 0x61, 0x18, 0x6e, 0x7c, 0x31, 0xfb, 0x01, 0xfb, 0xcb, 0xce, 0x0a, 0x58, 0x1e, 0xff,
	0xd5, 0xf9, 0xf3, 0x02, 0xb8, 0xed, 0xb2, 0xa8, 0xfc, 0x12, 0xd3, 0xd9, 0x9c, 0x8e, 0xa1, 0xa7,
	0xe6, 0xdb, 0xab, 0xfd, 0xe6, 0x17, 0x56, 0x1b, 0xb0, 0x10, 0xc7, 0x41, 0x9d, 0xf1, 0xa0, 0x11,
	0x90, 0x58, 0x67, 0xa3, 0x31, 0x99, 0xc6, 0x19, 0xff, 0x6f, 0x78, 0x34, 0x7e, 0xfa, 0xd7, 0xc2,
	0xe2, 0xd3, 0x76, 0xfb, 0xdf, 0x0b, 0x37, 0x9f, 0x1a, 0x64, 0xdb, 0x13, 0x75, 0xf3, 0xa8, 0x9e,
	0x0e, 0x9b, 0xf5, 0x7e, 0x36, 0xf2, 0x3f, 0xd9, 0x98, 0xa3, 0xb6, 0x27, 0x8e, 0xc6, 0x63, 0x8e,
	0x0e, 0x9b, 0x47, 0xe3, 0x31, 0x5f, 0x2f, 0xdc, 0x36, 0x1d, 0xad, 0x56, 0xdb, 0x13, 0xad, 0xd6,
	0x78, 0x54, 0xab, 0x75, 0xd8, 0x6c, 0xb5, 0xc6, 0xe3, 0x06, 0x17, 0x75, 0xb0, 0x0f, 0xbe, 0x09,
	0x00, 0x00, 0xff, 0xff, 0x1f, 0x92, 0xfc, 0x35, 0x1b, 0x19, 0x00, 0x00,
}
