// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v3/services/custom_interest_service.proto

package services

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	resources "google.golang.org/genproto/googleapis/ads/googleads/v3/resources"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for [CustomInterestService.GetCustomInterest][google.ads.googleads.v3.services.CustomInterestService.GetCustomInterest].
type GetCustomInterestRequest struct {
	// Required. The resource name of the custom interest to fetch.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetCustomInterestRequest) Reset()         { *m = GetCustomInterestRequest{} }
func (m *GetCustomInterestRequest) String() string { return proto.CompactTextString(m) }
func (*GetCustomInterestRequest) ProtoMessage()    {}
func (*GetCustomInterestRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_ca8c67676123c2d0, []int{0}
}

func (m *GetCustomInterestRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetCustomInterestRequest.Unmarshal(m, b)
}
func (m *GetCustomInterestRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetCustomInterestRequest.Marshal(b, m, deterministic)
}
func (m *GetCustomInterestRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetCustomInterestRequest.Merge(m, src)
}
func (m *GetCustomInterestRequest) XXX_Size() int {
	return xxx_messageInfo_GetCustomInterestRequest.Size(m)
}
func (m *GetCustomInterestRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetCustomInterestRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetCustomInterestRequest proto.InternalMessageInfo

func (m *GetCustomInterestRequest) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Request message for [CustomInterestService.MutateCustomInterests][google.ads.googleads.v3.services.CustomInterestService.MutateCustomInterests].
type MutateCustomInterestsRequest struct {
	// Required. The ID of the customer whose custom interests are being modified.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Required. The list of operations to perform on individual custom interests.
	Operations []*CustomInterestOperation `protobuf:"bytes,2,rep,name=operations,proto3" json:"operations,omitempty"`
	// If true, the request is validated but not executed. Only errors are
	// returned, not results.
	ValidateOnly         bool     `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateCustomInterestsRequest) Reset()         { *m = MutateCustomInterestsRequest{} }
func (m *MutateCustomInterestsRequest) String() string { return proto.CompactTextString(m) }
func (*MutateCustomInterestsRequest) ProtoMessage()    {}
func (*MutateCustomInterestsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_ca8c67676123c2d0, []int{1}
}

func (m *MutateCustomInterestsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateCustomInterestsRequest.Unmarshal(m, b)
}
func (m *MutateCustomInterestsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateCustomInterestsRequest.Marshal(b, m, deterministic)
}
func (m *MutateCustomInterestsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateCustomInterestsRequest.Merge(m, src)
}
func (m *MutateCustomInterestsRequest) XXX_Size() int {
	return xxx_messageInfo_MutateCustomInterestsRequest.Size(m)
}
func (m *MutateCustomInterestsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateCustomInterestsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MutateCustomInterestsRequest proto.InternalMessageInfo

func (m *MutateCustomInterestsRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *MutateCustomInterestsRequest) GetOperations() []*CustomInterestOperation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *MutateCustomInterestsRequest) GetValidateOnly() bool {
	if m != nil {
		return m.ValidateOnly
	}
	return false
}

// A single operation (create, update) on a custom interest.
type CustomInterestOperation struct {
	// FieldMask that determines which resource fields are modified in an update.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// The mutate operation.
	//
	// Types that are valid to be assigned to Operation:
	//	*CustomInterestOperation_Create
	//	*CustomInterestOperation_Update
	Operation            isCustomInterestOperation_Operation `protobuf_oneof:"operation"`
	XXX_NoUnkeyedLiteral struct{}                            `json:"-"`
	XXX_unrecognized     []byte                              `json:"-"`
	XXX_sizecache        int32                               `json:"-"`
}

func (m *CustomInterestOperation) Reset()         { *m = CustomInterestOperation{} }
func (m *CustomInterestOperation) String() string { return proto.CompactTextString(m) }
func (*CustomInterestOperation) ProtoMessage()    {}
func (*CustomInterestOperation) Descriptor() ([]byte, []int) {
	return fileDescriptor_ca8c67676123c2d0, []int{2}
}

func (m *CustomInterestOperation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CustomInterestOperation.Unmarshal(m, b)
}
func (m *CustomInterestOperation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CustomInterestOperation.Marshal(b, m, deterministic)
}
func (m *CustomInterestOperation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CustomInterestOperation.Merge(m, src)
}
func (m *CustomInterestOperation) XXX_Size() int {
	return xxx_messageInfo_CustomInterestOperation.Size(m)
}
func (m *CustomInterestOperation) XXX_DiscardUnknown() {
	xxx_messageInfo_CustomInterestOperation.DiscardUnknown(m)
}

var xxx_messageInfo_CustomInterestOperation proto.InternalMessageInfo

func (m *CustomInterestOperation) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

type isCustomInterestOperation_Operation interface {
	isCustomInterestOperation_Operation()
}

type CustomInterestOperation_Create struct {
	Create *resources.CustomInterest `protobuf:"bytes,1,opt,name=create,proto3,oneof"`
}

type CustomInterestOperation_Update struct {
	Update *resources.CustomInterest `protobuf:"bytes,2,opt,name=update,proto3,oneof"`
}

func (*CustomInterestOperation_Create) isCustomInterestOperation_Operation() {}

func (*CustomInterestOperation_Update) isCustomInterestOperation_Operation() {}

func (m *CustomInterestOperation) GetOperation() isCustomInterestOperation_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (m *CustomInterestOperation) GetCreate() *resources.CustomInterest {
	if x, ok := m.GetOperation().(*CustomInterestOperation_Create); ok {
		return x.Create
	}
	return nil
}

func (m *CustomInterestOperation) GetUpdate() *resources.CustomInterest {
	if x, ok := m.GetOperation().(*CustomInterestOperation_Update); ok {
		return x.Update
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*CustomInterestOperation) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*CustomInterestOperation_Create)(nil),
		(*CustomInterestOperation_Update)(nil),
	}
}

// Response message for custom interest mutate.
type MutateCustomInterestsResponse struct {
	// All results for the mutate.
	Results              []*MutateCustomInterestResult `protobuf:"bytes,2,rep,name=results,proto3" json:"results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *MutateCustomInterestsResponse) Reset()         { *m = MutateCustomInterestsResponse{} }
func (m *MutateCustomInterestsResponse) String() string { return proto.CompactTextString(m) }
func (*MutateCustomInterestsResponse) ProtoMessage()    {}
func (*MutateCustomInterestsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_ca8c67676123c2d0, []int{3}
}

func (m *MutateCustomInterestsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateCustomInterestsResponse.Unmarshal(m, b)
}
func (m *MutateCustomInterestsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateCustomInterestsResponse.Marshal(b, m, deterministic)
}
func (m *MutateCustomInterestsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateCustomInterestsResponse.Merge(m, src)
}
func (m *MutateCustomInterestsResponse) XXX_Size() int {
	return xxx_messageInfo_MutateCustomInterestsResponse.Size(m)
}
func (m *MutateCustomInterestsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateCustomInterestsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MutateCustomInterestsResponse proto.InternalMessageInfo

func (m *MutateCustomInterestsResponse) GetResults() []*MutateCustomInterestResult {
	if m != nil {
		return m.Results
	}
	return nil
}

// The result for the custom interest mutate.
type MutateCustomInterestResult struct {
	// Returned for successful operations.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateCustomInterestResult) Reset()         { *m = MutateCustomInterestResult{} }
func (m *MutateCustomInterestResult) String() string { return proto.CompactTextString(m) }
func (*MutateCustomInterestResult) ProtoMessage()    {}
func (*MutateCustomInterestResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_ca8c67676123c2d0, []int{4}
}

func (m *MutateCustomInterestResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateCustomInterestResult.Unmarshal(m, b)
}
func (m *MutateCustomInterestResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateCustomInterestResult.Marshal(b, m, deterministic)
}
func (m *MutateCustomInterestResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateCustomInterestResult.Merge(m, src)
}
func (m *MutateCustomInterestResult) XXX_Size() int {
	return xxx_messageInfo_MutateCustomInterestResult.Size(m)
}
func (m *MutateCustomInterestResult) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateCustomInterestResult.DiscardUnknown(m)
}

var xxx_messageInfo_MutateCustomInterestResult proto.InternalMessageInfo

func (m *MutateCustomInterestResult) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func init() {
	proto.RegisterType((*GetCustomInterestRequest)(nil), "google.ads.googleads.v3.services.GetCustomInterestRequest")
	proto.RegisterType((*MutateCustomInterestsRequest)(nil), "google.ads.googleads.v3.services.MutateCustomInterestsRequest")
	proto.RegisterType((*CustomInterestOperation)(nil), "google.ads.googleads.v3.services.CustomInterestOperation")
	proto.RegisterType((*MutateCustomInterestsResponse)(nil), "google.ads.googleads.v3.services.MutateCustomInterestsResponse")
	proto.RegisterType((*MutateCustomInterestResult)(nil), "google.ads.googleads.v3.services.MutateCustomInterestResult")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v3/services/custom_interest_service.proto", fileDescriptor_ca8c67676123c2d0)
}

var fileDescriptor_ca8c67676123c2d0 = []byte{
	// 704 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x55, 0x5f, 0x6b, 0xd3, 0x50,
	0x14, 0x37, 0xa9, 0x4c, 0x77, 0xbb, 0x3d, 0x18, 0x98, 0xab, 0x71, 0x62, 0x89, 0x03, 0x67, 0x91,
	0x84, 0x35, 0x82, 0x2c, 0x73, 0x93, 0x54, 0x70, 0x1b, 0x32, 0x37, 0xa2, 0x14, 0x91, 0x62, 0xb9,
	0x6b, 0xee, 0x6a, 0x58, 0x92, 0x1b, 0x73, 0x6f, 0x2a, 0x63, 0xec, 0x41, 0xbf, 0x82, 0xdf, 0xc0,
	0x47, 0xbf, 0x89, 0x03, 0x9f, 0x7c, 0xdb, 0xd3, 0x1e, 0x7c, 0xf2, 0xd1, 0x37, 0x05, 0x41, 0x92,
	0x7b, 0x6f, 0xdb, 0xd4, 0x86, 0xe2, 0x7c, 0x3b, 0xcd, 0xf9, 0x9d, 0xdf, 0xf9, 0xf3, 0x3b, 0xe7,
	0x16, 0xac, 0x77, 0x31, 0xee, 0xfa, 0xc8, 0x80, 0x2e, 0x31, 0x98, 0x99, 0x5a, 0x3d, 0xd3, 0x20,
	0x28, 0xee, 0x79, 0x1d, 0x44, 0x8c, 0x4e, 0x42, 0x28, 0x0e, 0xda, 0x5e, 0x48, 0x51, 0x8c, 0x08,
	0x6d, 0x73, 0x87, 0x1e, 0xc5, 0x98, 0x62, 0xa5, 0xca, 0x82, 0x74, 0xe8, 0x12, 0xbd, 0x1f, 0xaf,
	0xf7, 0x4c, 0x5d, 0xc4, 0xab, 0xf7, 0x8b, 0x32, 0xc4, 0x88, 0xe0, 0x24, 0x1e, 0x93, 0x82, 0x51,
	0xab, 0x0b, 0x22, 0x30, 0xf2, 0x0c, 0x18, 0x86, 0x98, 0x42, 0xea, 0xe1, 0x90, 0x70, 0xef, 0xfc,
	0x90, 0xb7, 0xe3, 0x7b, 0x28, 0x14, 0x61, 0x37, 0x87, 0x1c, 0xfb, 0x1e, 0xf2, 0xdd, 0xf6, 0x1e,
	0x7a, 0x0d, 0x7b, 0x1e, 0x8e, 0x39, 0xe0, 0xda, 0x10, 0x40, 0xd4, 0xc0, 0x5d, 0xbc, 0x1b, 0x23,
	0xfb, 0xb5, 0x97, 0xec, 0x73, 0x82, 0x00, 0x92, 0x03, 0x86, 0xd0, 0x22, 0x50, 0xd9, 0x40, 0xf4,
	0x51, 0x56, 0xf0, 0x16, 0xaf, 0xd7, 0x41, 0x6f, 0x12, 0x44, 0xa8, 0xf2, 0x1c, 0xcc, 0x0a, 0xbe,
	0x76, 0x08, 0x03, 0x54, 0x91, 0xaa, 0xd2, 0xd2, 0x74, 0xc3, 0x38, 0xb3, 0xe5, 0x5f, 0xf6, 0x1d,
	0x70, 0x7b, 0x30, 0x1f, 0x6e, 0x45, 0x1e, 0xd1, 0x3b, 0x38, 0x30, 0x46, 0xe8, 0x66, 0x04, 0xcb,
	0x53, 0x18, 0x20, 0xed, 0xb3, 0x04, 0x16, 0xb6, 0x13, 0x0a, 0x29, 0xca, 0xc3, 0x88, 0x48, 0xbb,
	0x08, 0xca, 0x6c, 0x80, 0x28, 0x6e, 0x7b, 0x2e, 0x4f, 0x5a, 0x3a, 0xb3, 0x65, 0x07, 0x88, 0xef,
	0x5b, 0xae, 0xf2, 0x0a, 0x00, 0x1c, 0xa1, 0x98, 0xcd, 0xb0, 0x22, 0x57, 0x4b, 0x4b, 0xe5, 0xfa,
	0x8a, 0x3e, 0x49, 0x3d, 0x3d, 0x9f, 0x73, 0x47, 0x30, 0x70, 0xfe, 0x01, 0xa3, 0x72, 0x0b, 0xcc,
	0xf6, 0xa0, 0xef, 0xb9, 0x90, 0xa2, 0x36, 0x0e, 0xfd, 0xc3, 0xca, 0xc5, 0xaa, 0xb4, 0x74, 0xd9,
	0x99, 0x11, 0x1f, 0x77, 0x42, 0xff, 0x50, 0xfb, 0x2d, 0x81, 0xf9, 0x02, 0x46, 0x65, 0x15, 0x94,
	0x93, 0x28, 0x0b, 0x4f, 0xc7, 0x9d, 0x85, 0x97, 0xeb, 0xaa, 0xa8, 0x50, 0x28, 0xa2, 0x3f, 0x4e,
	0x15, 0xd9, 0x86, 0xe4, 0xc0, 0x01, 0x0c, 0x9e, 0xda, 0xca, 0x13, 0x30, 0xd5, 0x89, 0x11, 0xa4,
	0x6c, 0xe6, 0xe5, 0xfa, 0x72, 0x61, 0x67, 0xfd, 0xad, 0x1b, 0x69, 0x6d, 0xf3, 0x82, 0xc3, 0x29,
	0x52, 0x32, 0x46, 0x5d, 0x91, 0xff, 0x83, 0x8c, 0x51, 0x34, 0xca, 0x60, 0xba, 0x3f, 0x25, 0xed,
	0x2d, 0xb8, 0x51, 0x20, 0x25, 0x89, 0x70, 0x48, 0x90, 0xd2, 0x04, 0x97, 0x62, 0x44, 0x12, 0x9f,
	0x0a, 0x89, 0x1e, 0x4c, 0x96, 0x68, 0x1c, 0xa3, 0x93, 0x91, 0x38, 0x82, 0x4c, 0xb3, 0x81, 0x5a,
	0x0c, 0x4b, 0xb5, 0x1b, 0xb3, 0xb8, 0xf9, 0x3d, 0xac, 0xff, 0x2c, 0x81, 0xb9, 0x7c, 0xf4, 0x33,
	0x56, 0x81, 0xf2, 0x45, 0x02, 0x57, 0xfe, 0x3a, 0x0a, 0xc5, 0x9a, 0x5c, 0x79, 0xd1, 0x25, 0xa9,
	0xff, 0x3e, 0x71, 0x6d, 0xeb, 0xd4, 0xce, 0x37, 0xf1, 0xfe, 0xeb, 0xb7, 0x0f, 0xb2, 0xa9, 0x2c,
	0xa7, 0x4f, 0xcd, 0x51, 0xce, 0xb3, 0x26, 0xce, 0x82, 0x18, 0x35, 0xfe, 0xf6, 0xf4, 0x95, 0x30,
	0x6a, 0xc7, 0xca, 0x0f, 0x09, 0xcc, 0x8d, 0x95, 0x49, 0x59, 0x3f, 0x9f, 0x1a, 0xe2, 0x54, 0xd5,
	0x87, 0xe7, 0x8e, 0x67, 0xfb, 0xa1, 0xbd, 0x38, 0xb5, 0xaf, 0x0e, 0x1d, 0xfb, 0xdd, 0xc1, 0x01,
	0x66, 0xed, 0xae, 0x68, 0xf7, 0xd2, 0x76, 0x07, 0xfd, 0x1d, 0x0d, 0x81, 0xd7, 0x6a, 0xc7, 0xa3,
	0xdd, 0x5a, 0x41, 0x96, 0xcd, 0x92, 0x6a, 0xea, 0xf5, 0x13, 0xbb, 0x52, 0xf4, 0x40, 0x35, 0xde,
	0xc9, 0x60, 0xb1, 0x83, 0x83, 0x89, 0xd5, 0x37, 0xd4, 0xb1, 0x1b, 0xb2, 0x9b, 0x1e, 0xef, 0xae,
	0xf4, 0x72, 0x93, 0xc7, 0x77, 0xb1, 0x0f, 0xc3, 0xae, 0x8e, 0xe3, 0xae, 0xd1, 0x45, 0x61, 0x76,
	0xda, 0xc6, 0x20, 0x63, 0xf1, 0x7f, 0xd1, 0xaa, 0x30, 0x3e, 0xca, 0xa5, 0x0d, 0xdb, 0xfe, 0x24,
	0x57, 0x37, 0x18, 0xa1, 0xed, 0x12, 0x9d, 0x99, 0xa9, 0xd5, 0x34, 0x75, 0x9e, 0x98, 0x9c, 0x08,
	0x48, 0xcb, 0x76, 0x49, 0xab, 0x0f, 0x69, 0x35, 0xcd, 0x96, 0x80, 0x7c, 0x97, 0x17, 0xd9, 0x77,
	0xcb, 0xb2, 0x5d, 0x62, 0x59, 0x7d, 0x90, 0x65, 0x35, 0x4d, 0xcb, 0x12, 0xb0, 0xbd, 0xa9, 0xac,
	0x4e, 0xf3, 0x4f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x9f, 0xaa, 0x72, 0xab, 0x32, 0x07, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// CustomInterestServiceClient is the client API for CustomInterestService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CustomInterestServiceClient interface {
	// Returns the requested custom interest in full detail.
	GetCustomInterest(ctx context.Context, in *GetCustomInterestRequest, opts ...grpc.CallOption) (*resources.CustomInterest, error)
	// Creates or updates custom interests. Operation statuses are returned.
	MutateCustomInterests(ctx context.Context, in *MutateCustomInterestsRequest, opts ...grpc.CallOption) (*MutateCustomInterestsResponse, error)
}

type customInterestServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewCustomInterestServiceClient(cc grpc.ClientConnInterface) CustomInterestServiceClient {
	return &customInterestServiceClient{cc}
}

func (c *customInterestServiceClient) GetCustomInterest(ctx context.Context, in *GetCustomInterestRequest, opts ...grpc.CallOption) (*resources.CustomInterest, error) {
	out := new(resources.CustomInterest)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v3.services.CustomInterestService/GetCustomInterest", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *customInterestServiceClient) MutateCustomInterests(ctx context.Context, in *MutateCustomInterestsRequest, opts ...grpc.CallOption) (*MutateCustomInterestsResponse, error) {
	out := new(MutateCustomInterestsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v3.services.CustomInterestService/MutateCustomInterests", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CustomInterestServiceServer is the server API for CustomInterestService service.
type CustomInterestServiceServer interface {
	// Returns the requested custom interest in full detail.
	GetCustomInterest(context.Context, *GetCustomInterestRequest) (*resources.CustomInterest, error)
	// Creates or updates custom interests. Operation statuses are returned.
	MutateCustomInterests(context.Context, *MutateCustomInterestsRequest) (*MutateCustomInterestsResponse, error)
}

// UnimplementedCustomInterestServiceServer can be embedded to have forward compatible implementations.
type UnimplementedCustomInterestServiceServer struct {
}

func (*UnimplementedCustomInterestServiceServer) GetCustomInterest(ctx context.Context, req *GetCustomInterestRequest) (*resources.CustomInterest, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCustomInterest not implemented")
}
func (*UnimplementedCustomInterestServiceServer) MutateCustomInterests(ctx context.Context, req *MutateCustomInterestsRequest) (*MutateCustomInterestsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MutateCustomInterests not implemented")
}

func RegisterCustomInterestServiceServer(s *grpc.Server, srv CustomInterestServiceServer) {
	s.RegisterService(&_CustomInterestService_serviceDesc, srv)
}

func _CustomInterestService_GetCustomInterest_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCustomInterestRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CustomInterestServiceServer).GetCustomInterest(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v3.services.CustomInterestService/GetCustomInterest",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CustomInterestServiceServer).GetCustomInterest(ctx, req.(*GetCustomInterestRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CustomInterestService_MutateCustomInterests_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MutateCustomInterestsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CustomInterestServiceServer).MutateCustomInterests(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v3.services.CustomInterestService/MutateCustomInterests",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CustomInterestServiceServer).MutateCustomInterests(ctx, req.(*MutateCustomInterestsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CustomInterestService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v3.services.CustomInterestService",
	HandlerType: (*CustomInterestServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetCustomInterest",
			Handler:    _CustomInterestService_GetCustomInterest_Handler,
		},
		{
			MethodName: "MutateCustomInterests",
			Handler:    _CustomInterestService_MutateCustomInterests_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v3/services/custom_interest_service.proto",
}
