#ifndef INC_Parser_hpp__
#define INC_Parser_hpp__

/**
 * <b>SOFTWARE RIGHTS</b>
 * <p>
 * ANTLR 2.6.0 MageLang Insitute, 1999
 * <p>
 * We reserve no legal rights to the ANTLR--it is fully in the
 * public domain. An individual or company may do whatever
 * they wish with source code distributed with ANTLR or the
 * code generated by ANTLR, including the incorporation of
 * ANTLR, or its output, into commerical software.
 * <p>
 * We encourage users to develop software with ANTLR. However,
 * we do ask that credit is given to us for developing
 * ANTLR. By "credit", we mean that if you use ANTLR or
 * incorporate any source code into one of your programs
 * (commercial product, research project, or otherwise) that
 * you acknowledge this fact somewhere in the documentation,
 * research report, etc... If you like ANTLR and have
 * developed a nice tool with the output, please mention that
 * you developed it using ANTLR. In addition, we ask that the
 * headers remain intact in our source code. As long as these
 * guidelines are kept, we expect to continue enhancing this
 * system and expect to make other tools available as they are
 * completed.
 * <p>
 * The ANTLR gang:
 * @version ANTLR 2.6.0 MageLang Insitute, 1999
 * @author Terence Parr, <a href=http://www.MageLang.com>MageLang Institute</a>
 * @author <br>John Lilley, <a href=http://www.Empathy.com>Empathy Software</a>
 * @author <br><a href="mailto:pete@yamuna.demon.co.uk">Pete Wells</a>
 */

#include "Antlr/config.hpp"
#include "Antlr/BitSet.hpp"
#include "Antlr/TokenBuffer.hpp"
#include "Antlr/ParserException.hpp"
#include "Antlr/ASTFactory.hpp"
#include "Antlr/ParserSharedInputState.hpp"

/**A generic ANTLR parser (LL(k) for k>=1) containing a bunch of
 * utility routines useful at any lookahead depth.  We distinguish between
 * the LL(1) and LL(k) parsers because of efficiency.  This may not be
 * necessary in the near future.
 *
 * Each parser object contains the state of the parse including a lookahead
 * cache (the form of which is determined by the subclass), whether or
 * not the parser is in guess mode, where tokens come from, etc...
 *
 * <p>
 * During <b>guess</b> mode, the current lookahead token(s) and token type(s)
 * cache must be saved because the token stream may not have been informed
 * to save the token (via <tt>mark</tt>) before the <tt>try</tt> block.
 * Guessing is started by:
 * <ol>
 * <li>saving the lookahead cache.
 * <li>marking the current position in the TokenBuffer.
 * <li>increasing the guessing level.
 * </ol>
 *
 * After guessing, the parser state is restored by:
 * <ol>
 * <li>restoring the lookahead cache.
 * <li>rewinding the TokenBuffer.
 * <li>decreasing the guessing level.
 * </ol>
 *
 * @see antlr.Token
 * @see antlr.TokenBuffer
 * @see antlr.TokenStream
 * @see antlr.LL1Parser
 * @see antlr.LLkParser
 */

extern bool DEBUG_PARSER;

class Parser {
protected:
	ParserSharedInputState inputState;

	/** Nesting level of registered handlers */
	// int exceptionLevel;

	/** Table of token type to token names */
	std::vector<std::string> tokenNames;
	/** AST return value for a rule is squirreled away here */
	RefAST returnAST;
	/** AST support code; parser and treeparser delegate to this object */
	ASTFactory astFactory;

//	Parser();

	Parser(TokenBuffer& input_);
	Parser(TokenBuffer* input_);

	Parser(const ParserSharedInputState& state);

public:
	virtual ~Parser();

protected:
	void setTokenNames(const char** tokenNames_);

public:
	/**Get another token object from the token stream */
	virtual void consume()=0;

	/** Consume tokens until one matches the given token */
	void consumeUntil(int tokenType);

	/** Consume tokens until one matches the given token set */
	void consumeUntil(const BitSet& set);

	/** Get the AST return value squirreled away in the parser */
	RefAST getAST();

	ASTFactory& getASTFactory();

	std::string getFilename() const;

	virtual ParserSharedInputState getInputState() const;

	std::string getTokenName(int num) const;
	std::vector<std::string> getTokenNames() const;

	/** Return the token type of the ith token of lookahead where i=1
	 * is the current token being examined by the parser (i.e., it
	 * has not been matched yet).
	 */
	virtual int LA(int i)=0;

	/**Return the ith token of lookahead */
	virtual RefToken LT(int i)=0;

	// Forwarded to TokenBuffer
	virtual int mark();

	/**Make sure current lookahead symbol matches token type <tt>t</tt>.
	 * Throw an exception upon mismatch, which is catch by either the
	 * error handler or by the syntactic predicate.
	 */
	void match(int t);

	/**Make sure current lookahead symbol matches the given set
	 * Throw an exception upon mismatch, which is catch by either the
	 * error handler or by the syntactic predicate.
	 */
	void match(const BitSet& b);

	void matchNot(int t);

	static void panic();

	/** Parser error-reporting function can be overridden in subclass */
	virtual void reportError(const ParserException& ex);

	/** Parser error-reporting function can be overridden in subclass */
	virtual void reportError(const std::string& s);

	/** Parser warning-reporting function can be overridden in subclass */
	virtual void reportWarning(const std::string& s);

	virtual void rewind(int pos);

	/** Set the object used to generate ASTs */
//	void setASTFactory(ASTFactory astFactory_);

	/** Specify the type of node to create during tree building */
	void setASTNodeFactory(ASTFactory::factory_type factory);

	void setFilename(const std::string& f);

	/** Set or change the input token buffer */
//	void setTokenBuffer(TokenBuffer<Token>* t);

	virtual void traceIn(const std::string& rname);
	virtual void traceOut(const std::string& rname);

protected:
	class Tracer {
	private:
		Parser* parser;
		std::string text;
	public:
		Tracer(Parser* p,const std::string& t)
			: parser(p), text(t) { parser->traceIn(text); }
		~Tracer()
			{ parser->traceOut(text); }
	};

private:
	Parser(const Parser&);
	const Parser& operator=(const Parser&);
};

#endif //INC_Parser_hpp__

