// generated by ../../../../tools/tube_transfer.py
// tube: JJECC99
// plate current function: pentode
// mu: 23.1
// kx: 1.46
// kg1: 455.3
// kg2: 0
// kp: 191.9
// kvb: 300
// Uin_min: -5
// Uin_max: 5
// Vp: 250
// Rp: 100000

table1d_imp<2001> tubetable_JJECC99[2] __rt_data = {
	{ // Ri = 68k
	-5,5,200,2001, {
	127.71410689388159,127.63037097463148,127.54662611437428,127.4628723371091,127.37910966689084,
	127.2953381278304,127.21155774409503,127.1277685399084,127.04397053955091,126.96016376736009,
	126.87634824773065,126.79252400511481,126.70869106402264,126.62484944902212,126.54099918473958,
	126.45714029585977,126.37327280712638,126.28939674334207,126.20551212936867,126.12161899012771,
	126.0377173506005,125.95380723582834,125.86988867091297,125.78596168101654,125.70202629136227,
	125.61808252723432,125.5341304139782,125.45016997700118,125.36620124177233,125.28222423382289,
	125.19823897874652,125.11424550219961,125.03024382990138,124.94623398763443,124.86221600124478,
	124.7781898966421,124.69415569980028,124.6101134367573,124.52606313361588,124.44200481654346,
	124.35793851177264,124.27386424560132,124.1897820443932,124.10569193457773,124.02159394265074,
	123.93748809517437,123.85337441877758,123.76925294015643,123.68512368607419,123.60098668336177,
	123.51684195891782,123.43268953970934,123.3485294527716,123.26436172520866,123.18018638419349,
	123.09600345696836,123.01181297084516,122.9276149532055,122.84340943150124,122.75919643325453,
	122.67497598605829,122.59074811757635,122.50651285554392,122.42227022776767,122.33802026212614,
	122.25376298657007,122.16949842912254,122.08522661787939,122.00094758100946,121.91666134675492,
	121.8323679434315,121.74806739942883,121.6637597432108,121.57944500331568,121.49512320835653,
	121.41079438702162,121.32645856807436,121.24211578035411,121.15776605277597,121.07340941433142,
	120.98904589408853,120.90467552119222,120.82029832486452,120.73591433440515,120.6515235791913,
	120.56712608867859,120.48272189240079,120.39831101997041,120.31389350107911,120.22946936549769,
	120.14503864307673,120.06060136374661,119.97615755751808,119.8917072544823,119.80725048481138,
	119.72278727875862,119.63831766665878,119.55384167892848,119.46935934606633,119.38487069865349,
	119.30037576735378,119.21587458291422,119.13136717616504,119.04685357802029,118.96233381947795,
	118.8778079316204,118.79327594561467,118.70873789271275,118.62419380425187,118.53964371165503,
	118.455087646431,118.37052564017492,118.28595772456846,118.20138393138029,118.11680429246621,
	118.03221883976967,117.94762760532194,117.86303062124257,117.77842791973966,117.69381953311012,
	117.60920549374013,117.52458583410535,117.43996058677138,117.35532978439399,117.27069345971944,
	117.18605164558491,117.10140437491873,117.0167516807408,116.93209359616287,116.8474301543889,
	116.76276138871538,116.6780873325317,116.59340801932044,116.50872348265774,116.42403375621365,
	116.33933887375241,116.25463886913289,116.1699337763088,116.08522362932918,116.00050846233864,
	115.9157883095777,115.83106320538324,115.74633318418866,115.66159828052443,115.57685852901824,
	115.49211396439557,115.40736462147983,115.32261053519282,115.23785174055497,115.15308827268592,
	115.0683201668046,114.98354745822965,114.89877018238002,114.81398837477487,114.72920207103432,
	114.64441130687965,114.55961611813356,114.47481654072075,114.390012610668,114.30520436410478,
	114.22039183726346,114.13557506647966,114.05075408819265,113.96592893894577,113.88109965538662,
	113.79626627426762,113.71142883244619,113.62658736688522,113.54174191465337,113.45689251292546,
	113.37203919898285,113.28718201021374,113.20232098411367,113.11745615828559,113.03258757044058,
	112.947715258398,112.86283926008593,112.77795961354141,112.693076356911,112.608189528451,
	112.5232991665279,112.43840530961864,112.35350799631115,112.26860726530452,112.18370315540952,
	112.09879570554885,112.01388495475766,111.9289709421837,111.84405370708797,111.75913328884485,
	111.67420972694252,111.58928306098345,111.50435333068462,111.41942057587812,111.3344848365111,
	111.24954615264663,111.1646045644637,111.07966011225791,110.99471283644156,110.90976277754415,
	110.82480997621275,110.73985447321239,110.65489630942642,110.56993552585686,110.48497216362479,
	110.40000626397078,110.31503786825516,110.2300670179585,110.14509375468192,110.06011812014754,
	109.97514015619872,109.89015990480058,109.80517740804036,109.72019270812771,109.63520584739511,
	109.55021686829832,109.46522581341664,109.38023272545344,109.29523764723635,109.21024062171776,
	109.12524169197522,109.04024090121175,108.95523829275629,108.870233910064,108.78522779671668,
	108.70021999642319,108.61521055301975,108.53019951047041,108.44518691286734,108.36017280443129,
	108.27515722951196,108.19014023258833,108.10512185826907,108.02010215129295,107.93508115652915,
	107.85005891897778,107.76503548377006,107.68001089616892,107.59498520156919,107.50995844549813,
	107.42493067361575,107.33990193171513,107.25487226572291,107.16984172169964,107.08481034584011,
	106.99977818447381,106.91474528406528,106.8297116912144,106.74467745265699,106.65964261526493,
	106.57460722604678,106.48957133214793,106.40453498085124,106.31949821957718,106.23446109588437,
	106.14942365746988,106.06438595216967,105.97934802795888,105.8943099329523,105.80927171540473,
	105.72423342371134,105.63919510640804,105.5541568121719,105.46911858982148,105.38408048831727,
	105.29904255676195,105.21400484440099,105.12896740062273,105.04393027495902,104.95889351708549,
	104.87385717682184,104.78882130413243,104.7037859491264,104.6187511620583,104.53371699332821,
	104.44868349348243,104.36365071321347,104.27861870336072,104.19358751491072,104.10855719899749,
	104.02352780690305,103.93849939005763,103.85347200004006,103.76844568857825,103.68342050754949,
	103.59839650898074,103.51337374504915,103.42835226808238,103.34333213055888,103.25831338510834,
	103.17329608451202,103.08828028170319,103.0032660297674,102.91825338194279,102.83324239162071,
	102.74823311234576,102.66322559781644,102.57821990188519,102.49321607855912,102.40821418200007,
	102.32321426652513,102.23821638660691,102.15322059687391,102.06822695211096,101.98323550725945,
	101.8982463174178,101.8132594378417,101.72827492394457,101.64329283129773,101.55831321563102,
	101.47333613283293,101.388361638951,101.30338979019221,101.21842064292332,101.13345425367113,
	101.04849067912288,100.96352997612668,100.87857220169161,100.79361741298838,100.70866566734932,
	100.62371702226906,100.53877153540454,100.45382926457557,100.36889026776512,100.2839546031196,
	100.1990223289491,100.11409350372797,100.02916818609494,99.94424643485345,99.85932830897214,
	99.77441386758494,99.6895031699916,99.60459627565784,99.51969324421582,99.43479413546426,
	99.349899009369,99.26500792606306,99.18012094584716,99.09523812918995,99.01035953672816,
	98.92548522926721,98.84061526778126,98.75574971341368,98.67088862747715,98.58603207145417,
	98.50118010699724,98.41633279592918,98.33149020024344,98.24665238210427,98.16181940384723,
	98.07699132797926,97.99216821717911,97.90735013429752,97.82253714235752,97.73772930455485,
	97.65292668425796,97.56812934500856,97.48333735052167,97.39855076468606,97.3137696515644,
	97.22899407539357,97.14422410058492,97.05945979172449,96.97470121357337,96.88994843106778,
	96.80520150931959,96.72046051361619,96.6357255094211,96.55099656237404,96.46627373829115,
	96.38155710316532,96.29684672316634,96.21214266464119,96.12744499411426,96.04275377828759,
	95.95806908404101,95.87339097843252,95.78871952869834,95.70405480225321,95.61939686669068,
	95.53474578978313,95.45010163948217,95.36546448391871,95.28083439140329,95.19621143042613,
	95.11159566965739,95.02698717794745,94.94238602432695,94.8577922780071,94.77320600837977,
	94.68862728501776,94.6040561776749,94.51949275628625,94.43493709096829,94.35038925201904,
	94.26584930991827,94.1813173353277,94.096793399091,94.01227757223411,93.92776992596535,
	93.84327053167546,93.75877946093789,93.67429678550879,93.58982257732733,93.50535690851571,
	93.42089985137922,93.33645147840652,93.2520118622697,93.16758107582439,93.0831591921098,
	92.99874628434901,92.91434242594882,92.82994769050015,92.74556215177788,92.66118588374111,
	92.5768189605331,92.49246145648154,92.40811344609847,92.3237750040804,92.23944620530847,
	92.15512712484839,92.07081783795057,91.98651842005019,91.9022289467672,91.81794949390641,
	91.73368013745763,91.64942095359547,91.56517201867962,91.48093340925472,91.39670520205055,
	91.31248747398188,91.22828030214856,91.14408376383561,91.05989793651314,90.97572289783629,
	90.89155872564542,90.80740549796604,90.72326329300864,90.63913218916889,90.55501226502747,
	90.4709035993502,90.38680627108783,90.30272035937618,90.21864594353595,90.13458310307274,
	90.05053191767712,89.96649246722428,89.88246483177437,89.79844909157201,89.71444532704658,
	89.63045361881193,89.54647404766636,89.46250669459258,89.37855164075756,89.29460896751246,
	89.21067875639251,89.12676108911693,89.04285604758878,88.95896371389492,88.87508417030574,
	88.79121749927523,88.70736378344068,88.62352310562261,88.5396955488246,88.45588119623316,
	88.37208013121759,88.28829243732974,88.20451819830396,88.12075749805676,88.03701042068684,
	87.95327705047474,87.86955747188263,87.7858517695543,87.70216002831475,87.61848233317014,
	87.5348187693074,87.4511694220942,87.36753437707857,87.28391371998875,87.20030753673291,
	87.1167159133989,87.0331389362541,86.94957669174497,86.8660292664969,86.782496747314,
	86.69897922117867,86.61547677525147,86.53198949687066,86.4485174735521,86.36506079298877,
	86.28161954305054,86.1981938117839,86.11478368741152,86.03138925833203,85.94801061311962,
	85.86464784052373,85.78130102946872,85.6979702690534,85.61465564855082,85.53135725740783,
	85.44807518524472,85.36480952185478,85.28156035720401,85.19832778143069,85.11511188484491,
	85.0319127579283,84.94873049133341,84.86556517588359,84.78241690257221,84.69928576256254,
	84.61617184718708,84.5330752479473,84.44999605651299,84.366934364722,84.28389026457957,
	84.20086384825804,84.11785520809632,84.03486443659925,83.95189162643734,83.86893687044613,
	83.7860002616257,83.70308189314018,83.62018185831722,83.53730025064748,83.45443716378405,
	83.37159269154198,83.28876692789765,83.2059599669883,83.12317190311147,83.04040283072433,
	82.95765284444317,82.87492203904294,82.79221050945647,82.70951835077399,82.62684565824249,
	82.54419252726515,82.46155905340078,82.37894533236309,82.29635146002009,82.21377753239356,
	82.13122364565838,82.04868989614178,81.96617638032282,81.88368319483176,81.80121043644928,
	81.71875820210592,81.63632658888137,81.5539156940038,81.47152561484924,81.38915644894081,
	81.3068082939481,81.22448124768638,81.14217540811607,81.05989087334191,80.9776277416123,
	80.8953861113185,80.81316608099411,80.73096774931415,80.64879121509443,80.56663657729085,
	80.48450393499857,80.4023933874514,80.32030503402095,80.23823897421593,80.15619530768146,
	80.07417413419826,79.99217555368185,79.91019966618192,79.82824657188155,79.74631637109636,
	79.66440916427378,79.58252505199238,79.50066413496107,79.41882651401828,79.3370122901312,
	79.2552215643951,79.17345443803254,79.09171101239247,79.0099913889497,78.92829566930395,
	78.8466239551792,78.7649763484228,78.68335295100493,78.60175386501761,78.52017919267409,
	78.43862903630804,78.35710349837282,78.27560268144083,78.19412668820254,78.11267562146601,
	78.03124958415603,77.94984867931343,77.86847301009435,77.78712267976957,77.70579779172374,
	77.62449844945479,77.54322475657317,77.46197681680123,77.38075473397247,77.29955861203105,
	77.21838855503096,77.13724466713558,77.05612705261687,76.97503581585502,76.89397106133764,
	76.81293289365928,76.73192141752098,76.65093673772952,76.56997895919716,76.48904818694095,
	76.40814452608235,76.32726808184681,76.24641895956329,76.16559726466384,76.08480310268334,
	76.00403657925904,75.9232978001303,75.8425868711383,75.76190389822577,75.68124898743683,
	75.60062224491669,75.52002377691163,75.4394536897688,75.35891208993615,75.27839908396255,
	75.19791477849759,75.11745928029177,75.03703269619659,74.95663513316472,74.87626669825022,
	74.79592749860873,74.71561764149794,74.63533723427786,74.55508638441128,74.47486519946433,
	74.39467378710705,74.31451225511404,74.23438071136516,74.15427926384639,74.07420802065064,
	73.99416708997879,73.9141565801407,73.83417659955639,73.75422725675725,73.67430866038742,
	73.59442091920522,73.51456414208465,73.43473843801713,73.35494391611327,73.2751806856047,
	73.19544885584615,73.11574853631765,73.03607983662674,72.95644286651097,72.87683773584044,
	72.79726455462054,72.71772343299492,72.63821448124847,72.55873780981061,72.47929352925867,
	72.39988175032153,72.3205025838834,72.24115614098787,72.16184253284207,72.08256187082107,
	72.0033142664727,71.92409983152227,71.84491867787784,71.76577091763552,71.68665666308526,
	71.60757602671669,71.52852912122542,71.44951605951954,71.37053695472643,71.29159192020009,
	71.21268106952839,71.13380451654113,71.0549623753182,70.97615476019809,70.89738178578702,
	70.8186435669682,70.7399402189117,70.66127185708471,70.58263859726227,70.50404055553842,
	70.42547784833786,70.3469505924282,70.26845890493266,70.19000290334333,70.11158270553503,
	70.03319842977976,69.9548501947618,69.87653811959333,69.79826232383094,69.72002292749258,
	69.64182005107543,69.5636538155744,69.48552434250155,69.4074317539061,69.32937617239541,
	69.25135772115698,69.17337652398099,69.09543270528411,69.01752639013417,68.93965770427576,
	68.8618267741571,68.78403372695763,68.70627869061727,68.62856179386633,68.55088316625698,
	68.47324293819584,68.39564124097794,68.31807820682211,68.2405539689076,68.1630686614124,
	68.08562241955298,68.00821537962561,67.93084767904934,67.85351945641077,67.77623085151045,
	67.69898200541137,67.62177306048902,67.54460416048374,67.46747545055506,67.390387077338,
	67.313339189002,67.23633193531155,67.15936546768988,67.08243993928464,67.0055555050364,
	66.92871232174971,66.85191054816706,66.7751503450455,66.69843187523657,66.62175530376896,
	66.5451207979347,66.46852852737844,66.39197866419035,66.31547138300253,66.23900686108911,
	66.16258527847027,66.08620681802023,66.00987166557928,65.93358001007032,65.85733204361959,
	65.78112796168227,65.70496796317259,65.62885225059917,65.5527810302052,65.47675451211424,
	65.40077291048127,65.32483644364955,65.24894533431349,65.17309980968743,65.09730010168084,
	65.02154644708031,64.94583908773785,64.87017827076669,64.7945642487441,64.71899727992181,
	64.64347762844417,64.56800556457449,64.49258136492959,64.41720531272294,64.34187769801693,
	64.26659881798406,64.19136897717786,64.11618848781362,64.04105767005908,63.96597685233592,
	63.890946371631905,63.815966573824184,63.741037814014234,63.66616045687464,63.59133487700828,
	63.51656145931995,63.4418405994013,63.36717270392904,63.29255819107708,63.21799749094295,
	63.143491045988846,63.06903931149787,62.9946427560458,62.92030186198871,62.846017125967215,
	62.77178905942739,62.6976181891592,62.6235050578524,62.549450224671276,62.47545426584631,
	62.401517775287935,62.32764136521704,62.25382566681679,62.180071330904696,62.10637902862548,
	62.0327494521652,61.959183315487074,61.88568135508951,61.8122443307864,61.738873026510454,
	61.66556825113944,61.59233083934622,61.519161652472256,61.44606157942536,61.37303153760153,
	61.30007247383134,61.2271853653508,61.154371220796826,61.08163108122761,61.008966021167375,
	60.93637714967591,60.86386561144237,60.79143258790339,60.719079298385,60.64680700126792,
	60.57461699517595,60.50251062018655,60.430489259063094,60.35855433850793,60.28670733043512,
	60.21494975326193,60.1432831732176,60.07170920566822,60.000229516455946,59.92884582325058,
	59.8575598969122,59.78637356286184,59.71528870245853,59.644307254379626,59.57343121600188,
	59.50266264478012,59.432003659620015,59.36145644224164,59.29102323852971,59.22070635986646,
	59.15050818444271,59.080431158542346,59.010477797795126,58.940650688392616,58.87095248826133,
	58.80138592818726,58.73195381288537,58.662659022007595,58.59350451108201,58.5244933123764,
	58.455628535678166,58.386913368983095,58.31835107908462,58.24994501205519,58.18169859361125,
	58.11361532935271,58.04569880486816,57.977952685696366,57.91038071713483,57.842986723886156,
	57.77577460953255,57.70874835582919,57.641912021807244,57.575269742677285,57.50882572852407,
	57.44258426278421,57.37654970049819,57.31072646632911,57.24511905234063,57.17973201552733,
	57.11456997509164,57.049637609461804,56.98493965304683,56.920480892724655,56.85626616406139,
	56.792300347260394,56.728588362841315,56.66513516705023,56.60194574700386,56.53902511557209,
	56.47637830600452,56.41401036630834,56.35192635338673,56.290131326948355,56.2286303432002,
	56.167428448338086,56.10653067185026,56.0459420196517,55.98566746706799,55.925711951689316,
	55.86608036611669,55.80677755062352,55.74780828575742,55.689177284908034,55.63088918686718,
	55.5729485484095,55.51535983692123,55.458127423106134,55.401255573797314,55.344748444903686,
	55.288610074520385,55.23284437623091,55.17745513262912,55.122445989088064,55.0678204478014,
	55.01358186212227,54.9597334312229,54.90627819509637,54.853219029920794,54.800558643803555,
	54.74829957292166,54.696444178071815,54.64499464164172,54.593952965011624,54.54332096639295,
	54.49310027910819,54.44329235031402,54.39389844016695,54.344919621429206,54.296356779508976,
	54.24821061292843,54.200481634209616,54.153170171167304,54.106276368595324,54.05980019033166,
	54.01374142168599,53.96809967221193,53.92287437880492,53.878064809106235,53.83367006519183,
	53.789689087525275,53.74612065915217,53.70296341011455,53.66021582206235,53.61787623303999,
	53.57594284242557,53.53441371600096,53.493286791131084,53.45255988203165,53.41223068510462,
	53.37229678432204,53.33275565663929,53.29360467741972,53.254841125853574,53.216462190355124,
	53.17846497392304,53.14084649944961,53.103603714965985,53.06673349881143,53.030232664715406,
	52.99409796678279,52.95832610437316,52.92291372686619,52.887857438306185,52.853153801919824,
	52.81879934450168,52.78479056066337,52.751123916942966,52.717795855771534,52.68480279929505,
	52.652141153050366,52.61980730949435,52.587797651386055,52.556108555022526,52.52473639332871,
	52.49367753880331,52.46292836632187,52.43248525579933,52.4023445947146,52.37250278049958,
	52.342956222795856,52.31370134558187,52.28473458917437,52.25605241210713,52.22765129289098,
	52.199527731658534,52.17167825169768,52.1440994008775,52.11678775297047,52.08973990887495,
	52.062952497741904,52.03642217800942,52.01014563834921,51.984119598528686,51.95834081019243,
	51.932806057566715,51.907512158090576,51.882455962977275,51.857634357709294,51.833044262470175,
	51.80868263251692,51.78454645849552,51.760632766703246,51.73693861930008,51.71346111447286,
	51.690197386554125,51.66714460609909,51.64429997992265,51.621660751099334,51.59922419892833,
	51.576987638865994,51.554948422427735,51.53310393706182,51.51145160599653,51.489988888062975,
	51.468713277495155,51.44762230370898,51.42671353106203,51.405984558595314,51.38543301975889,
	51.365056582122314,51.344852947066805,51.32481984948963,51.304955057446264,51.28525637183518,
	51.26572162604627,51.24634868560695,51.22713544782097,51.208079841401165,51.18917982609669,
	51.17043339231553,51.15183856074329,51.13339338195859,51.11509593604592,51.096944332206576,
	51.078936708368,51.06107123079241,51.04334609368487,51.02575951880141,51.00830975505769,
	50.990995078138376,50.97381379010784,50.95676421902233,50.939844718544016,50.923053667557184,
	50.90638946978684,50.88985055341989,50.873435370729275,50.857142397701146,50.8409701336652,
	50.82491710092855,50.80898184441314,50.79316293129674,50.77745895065795,50.76186851312497,
	50.74639025052852,50.73102281555879,50.715764881426566,50.7006151415287,50.68557230911778,
	50.670635116976165,50.65580231709443,50.6410726803542,50.62644499621545,50.611918072408116,
	50.59749073462841,50.58316182623929,50.568930207975626,50.55479475765367,50.54075436988507,
	50.526807955795114,50.512954442745595,50.499192774061925,50.485521908764525,50.471940821304756,
	50.458448501304815,50.44504395330221,50.43172619649815,50.41849426451027,50.40534720512954,
	50.39228408008094,50.3793039647886,50.366405948144575,50.3535891322818,50.340852632350774,
	50.328195576300196,50.31561710466136,50.30311637033627,50.2906925383895,50.27834478584365,
	50.26607230147842,50.253874285633174,50.241749950013116,50.22969851749868,50.21771922195857,
	50.205811308065826,50.19397403111749,50.1822066568572,50.17050846130115,50.15887873056711,
	50.14731676070644,50.135821857539305,50.12439333649263,50.11303052244112,50.101732749551175,
	50.09049936112745,50.07932970946234,50.068223155688166,50.05717906963196,50.0461968296729,
	50.035275822602415,50.02441544348667,50.013615095531684,50.00287418995075,49.9921921458344,
	49.98156839001725,49.971002356974594,49.96049348866521,49.95004123443375,49.93964505088605,
	49.92930440177243,49.91901875787318,49.908787596886164,49.898610403316354,49.888486668367435,
	49.8784158898353,49.868397572003566,49.85843122554076,49.84851636739964,49.838652520718036,
	49.82883921472169,49.819075984628704,49.80936237155573,49.79969792242592,49.79008218987832,
	49.78051473217912,49.77099511313432,49.76152290200397,49.75209767341803,49.74271900729356,
	49.73338648875357,49.724099708047106,49.71485826047092,49.705661746292414,49.69650977067395,
	49.68740194359856,49.67833787979688,49.6693171986754,49.660339524246,49.651404485056595,
	49.64251171412321,49.63366084886298,49.62485153102851,49.6160834066433,49.607356125938274,
	49.59866934328939,49.59002271715644,49.58141591002277,49.57284858833612,49.56432042245039,
	49.555831086568574,49.547380258686474,49.53896762053744,49.5305928575382,49.52225565873534,
	49.51395571675294,49.5056927277409,49.49746639132436,49.48927641055369,49.481122491855636,
	49.473004344985,49.46492168297731,49.456874222102286,49.44886168181791,49.44088378472553,
	49.43294025652536,49.42503082597318,49.41715522483724,49.409313187856306,49.40150445269813,
	49.393728759918744,49.38598585292235,49.37827547792191,49.37059738390033,49.36295132257235,
	49.355337048346996,49.34775431829064,49.34020289209079,49.33268253202016,49.32519300290171,
	49.317734072073954,49.310305509356944,49.30290708701884,49.295538579742846,49.28819976459491,
	49.28089042099174,49.273610330669456,49.26635927765264,49.25913704822394,49.25194343089423,
	49.24477821637294,49.23764119753932,49.23053216941369,49.223450929129484,49.21639727590553,
	49.20937101101884,49.20237193777779,49.195399861495815,49.18845458946534,49.18153593093226,
	49.174643697070785,49.16777770095854,49.16093775755231,49.1541236836639,49.14733529793646,
	49.140572420821236,49.13383487455461,49.12712248313543,49.12043507230282,49.113772469514224,
	49.10713450392381,49.100521006361184,49.093931809310476,49.087366746889714,49.080825654830385,
	49.07430837045757,49.067814732670094,49.06134458192114,49.05489776019908,49.04847411100866,
	49.04207347935235,49.03569571171206,49.0293406560311,49.02300816169063,49.01669807951579,
	49.01041026172201,49.00414456192299,48.997900835107444,48.99167893762262,48.98547872715801,
	48.979300062729294,48.97314280466251,48.9670068145785,48.960891955377505,48.954798091224006,
	48.94872508753183,48.94267281094941,48.93664112934524,48.93062991179365,48.9246390285606,
	48.918668351089835,48.91271775198917,48.906787105016974,48.9008762850688,48.894985168164304,
	48.88911363143422,48.883261553107666,48.87742881249944,48.87161528999765,48.865820867051475,
	48.86004542615904,48.85428885085551,48.84855102570133,48.84283183627064,48.837131169139816,
	48.83144891187617,48.82578495302694,48.82013918210811,48.814511489593784,48.80890176690537,
	48.80330990640112,48.79773580136564,48.79217934599974,48.78664043541025,48.781118965600065,
	48.775614833458256,48.770127936750384,48.764658174108895,48.75920544502368,48.75376964983268,
	48.74835068971272,48.742948466670406,48.73756288353312,48.73219384394022,48.726841252334204,
	48.7215050139522,48.71618503481736,48.7108812217305,48.70559348226177,48.700321724742494,
	48.69506585825708,48.68982579263505,48.68460143844311,48.679392706977474,48.67419951025609,
	48.66902176101112,48.66385937268143,48.65871225940523,48.65358033601273,48.648463518019035,
	48.64336172161692,48.63827486366989,48.63320286170523,48.62814563390715,48.62310309911003,
	48.618075176791756,48.613061787067096,48.60806285068123,48.603078289003314,48.59810802402012,
	48.59315197832977,48.58821007513551,48.58328223823969,48.57836839203762,48.57346846151164,
	48.56858237222526,48.56371005031723,48.55885142249596,48.55400641603369,48.54917495876094,
	48.54435697906094,48.539552405864214,48.53476116864308,48.52998319740637,48.52521842269408,
	48.52046677557228,48.515728187627786,48.511002590963216,48.50628991819189,48.50159010243279,
	48.49690307730581,48.49222877692671,48.48756713590249,48.48291808932651,48.47828157277388,
	48.47365752229681,48.469045874420004,48.464446566136175,48.459859534901575,48.45528471863153,
	48.45072205569611,48.44617148491579,48.441632945557224,48.437106377328966,48.43259172037735,
	48.42808891528233,48.423597903053434,48.41911862512574,48.414651023355844,48.410195040018,
	48.40575061780019,48.40131769980025,48.39689622952209,48.39248615087197,48.38808740815471,
	48.383699946070095,48.37932370970415,48.37495864454621,48.370604696453555,48.36626181166969,
	48.361929936815265,48.357609018884695,48.353299005242675,48.34899984362088,48.34471148211463,
	48.34043386917957,48.33616695362846,48.331910684627935,48.32766501169538,48.32342988469571,
	48.319205253838305,48.31499106967394,48.310787283091685,48.306593845316016,48.302410707903704,
	48.29823782274095,48.294075142040484,48.28992261833862,48.28578020449245,48.28164785367705,
	48.27752551938263,48.2734131554118,48.269310715876884,48.26521815519719,48.26113542809625,
	48.25706248959937,48.25299929503085,48.248945800011455,48.24490196045586,48.240867732570145,
	48.23684307284921,48.232827938074394,48.22882228531089,48.2248260719055,48.220839255484066,
	48.216861793949185,48.21289364547781,48.20893476851897,48.20498512179144,48.201044664281426,
	48.19711335524038,48.19319115418271,48.1892780208836,48.18537391537684,48.18147879795257,
	48.177592629155285,48.173715369781576,48.16984698087811,48.165987423739516,48.16213665990638,
	48.158294651163146,48.15446135953613,48.150636747291514,48.14682077693342,48.14301341120187,
	48.13921461307095,48.135424345746806,48.131642572665804,48.12786925749262,48.12410436411843,
	48.12034785665901,48.11659969945293,48.11285985705982,48.10912829425845,48.10540497604511,
	48.101689867631734,48.09798293444427,48.094284142120884,48.090593456510305,48.086910843670125,
	48.08323626986516,48.079569701565774,48.07591110544623,48.072260448383105,48.06861769745369,
	48.064982819934364,48.06135578329909,48.05773655521781,48.05412510354755,48.05052139636181,
	48.046925401900126,48.04333708860119,48.0397564250921,48.0361833801869,48.032617922885194,
	48.029060022370544,48.02550964800927,48.02196676934886,48.01843135611663,48.014903378218335,
	48.01138280573683,48.007869608930655,48.00436375823273,48.000865224248976,47.99737397775705,
	47.99388998970501,47.99041323120998,47.98694367355693,47.98348128819737,47.98002604674807,
	47.976577920989875,47.97313688286638,47.96970290448276,47.96627595810454,47.962856016156415,
	47.959443051221015,47.95603703603774,47.95263794350161,47.949245746662065,47.945860418719526,
	47.94248193303539,47.939110263109995,47.93574538260022,47.93238726537272,47.92903588519469,
	47.92569121635046,47.922353233023365,47.91902190959934,47.91569722061411,47.9123791407412,
	47.9090676447966,47.90576270773661,47.902464304656775,47.89917241079093,47.89588700151009,
	47.8926080523216,47.88933553886803,47.886069436926235,47.882809722406435,47.87955637135114,
	47.876309359934375,47.873068664460526,47.8698342613636,47.86660612720617,47.8633842386785,
	47.860168572597665,47.8569591059066,47.853755815673196,47.85055867908949,47.847367673470735,
	47.8441827762545,47.84100396499988,47.83783121738656,47.83466451121404,47.83150382440072,
	47.82834913498316,47.82520042111516,47.82205766106698,47.81892083322455,47.81578991608861,
	47.8126648882831,47.8095457285199,47.80643241564693,47.803324928616476,47.80022324649172,
	47.79712734844595,47.79403721376194,47.79095282183104,47.78787415215254,47.78480118433285,
	47.78173389808483,47.778672273227066,47.77561628968305,47.77256592748059,47.76952116675106,
	47.766481987728646,47.76344837074969,47.76042029625205,47.7573977447743,47.75438069695513,
	47.75136913353268,47.748363035343786,47.74536238332345,47.74236715850406,47.739377342014805,
	47.73639291508098,47.733413859023415,47.730440155257774,47.72747178529397,47.72450873073548,
	47.721550973278795,47.718598494712744,47.715651276917924,47.71270930186611,47.70977255161957,
	47.70684100833054,47.703914654240656,47.70099347168029,47.69807744306802,47.69516655091004,
	47.692260777799575,47.68936010641636,47.686464519526,47.68357399997951,47.68068853071265,
	47.67780809474549,47.674932675181736,47.672062255208346,47.669196818094825,47.66633634719284,
	47.66348082593559,47.660630237837324,47.657784566492836,47.65494379557691,47.65210790884386,
	47.649276890126934,47.64645072333792,47.643629392466586,47.64081288158018,47.63800117482293,
	47.63519425641564,47.63239211065508,47.62959472191363,47.62680207463864,47.6240141533522,
	47.62123094265041,47.61845242720311,47.61567859175328,47.6129094211167,47.61014490018143,
	47.607385013907326,47.604629747325696,47.60187908553875,47.5991330137192,47.59639151710985,
	47.59365458102313,47.59092219084067,47.58819433201288,47.5854709900585,47.58275215056423,
	47.58003779918426,47.57732792163985,47.57462250371902,47.571921531276,47.569224990230886,
	47.566532866569304,47.563845146341876,47.561161815663965,47.558482860715166,47.555808267738975,
	47.553138023042386,47.55047211299551,47.54781052403119,47.545153242644645,47.54250025539305,
	47.539851548895186,47.537207109831094,47.53456692494168,47.531930981028296,47.52929926494708,
	47.52667176362971,47.52404846405194,47.52142935325359,47.51881441833319,47.51620364644764,
	47.51359702481184,47.510994540698384,47.50839618143724,47.505801934415295,47.503211787076154,
	47.50062572691974,47.49804374150196,47.49546581843437,47.49289194538391,47.49032211007252,
	47.48775630027679,47.48519450382774,47.4826367086104,47.48008290256356,47.47753307367945,
	47.474987210003384,47.4724452996335,47.46990733072044,47.46737329146702,47.464843170128,
	47.46231695500968,47.4597946344697,47.45727619691665,47.4547616308099,47.452250924659175,
	47.44974406702435,47.44724104651514,47.44474185179083,47.442246471559955,47.439754894580055,
	47.43726710965736,47.43478310564658,47.432302871450545,47.42982639601997,47.4273536683532,
	47.42488467749592,47.42241941254089,47.41995786262771,47.41750001694247,47.41504586471761,
	47.41259539523153,47.41014859780845,47.407705461818075,47.405265976675366,47.402830131840304,
	47.4003979168176,47.39796932115646,47.39554433445038,47.393122946336824,47.39070514649703,
	47.38829092465578,47.38588027058109,47.38347317408405,47.381069625018554,47.37866961328101,
	47.37627312881021,47.37388016158703,47.37149070163421,47.369104739016116,47.366722263838525,
	47.364343266248405,47.36196773643365,47.35959566462291,47.35722704108536,47.35486185613043,
	47.352500100107626,47.35014176340632,47.347786836455505,47.34543530972361,47.34308717371826,
	47.34074241898606,47.33840103611244,47.336063015721344,47.333728348475155,47.33139702507435,
	47.32906903625742,47.326744372800555,47.324423025517525,47.322104985259465,47.31979024291462,
	47.3174787894082,47.315170615702186,47.31286571279509,47.31056407172181,47.308265683553394,
	47.30597053939691,47.30367863039516,47.30138994772657,47.29910448260497,47.296822226279446,
	47.29454317003407,47.292267305187785,47.28999462309425,47.28772511514154,47.28545877275207,
	47.283195587382394,47.280935550523004,47.27867865369815,47.27642488846571,47.27417424641695,
	47.271926719176385,47.26968229840162,47.26744097578315,47.26520274304423,47.262967591940594,
	47.260735514260446,47.258506501824236,47.256280546484376,47.25405764012524,47.25183777466292,
	47.24962094204508,47.24740713425075,47.245196343290246,47.24298856120497,47.2407837800672,
	47.23858199198001,47.23638318907711,47.2341873635226,47.23199450751094,47.22980461326668,
	47.227617673044385,47.22543367912847,47.22325262383301,47.22107449950163,47.21889929850736,
	47.21672701325242,47.21455763616816,47.21239115971488,47.21022757638164,47.208066878686196,
	47.20590905917479,47.20375411042204,47.20160202503077,47.19945279563193,47.19730641488436,
	47.19516287547475,47.19302217011743,47.190884291554276,47.188749232554514,47.18661698591469,
	47.18448754445843,47.18236090103632,47.18023704852586,47.17811597983122,47.175997687883175,
	47.17388216563897,47.17176940608214,47.16965940222245,47.16755214709572,47.165447633763705,
	47.16334585531397,47.16124680485978,47.15915047553995,47.157056860518715,47.15496595298568,
	47.15287774615556,47.15079223326818,47.1487094075883,47.14662926240551,47.14455179103409,
	47.1424769868129,47.140404843105294,47.138335353298906,47.13626851080564,47.134204309061545,
	47.13214274152661,47.1300838016847,47.128027483043475,47.125973779134235,47.123922683511815,
	47.121874189754465,47.11982829146376,47.11778498226445,47.115744255804444,47.11370610575451,
	47.1116705258084,47.10963750968257,47.107607051116155,47.1055791438708,47.10355378173061,
	47.101530958502025,47.09951066801371,47.09749290411644,47.09547766068305,47.09346493160819,
	47.09145471080844,47.08944699222201,47.08744176980873,47.08543903754994,47.083438789448394,
	47.08144101952812,47.07944572183437,47.077452890433506,47.07546251941289,47.07347460287413,
	47.071489134959215,47.06950610981166,47.06752552160186,47.06554736452074,47.063571632779656,
	47.06159832061026,47.05962742226451,47.057658932014476,47.05569284415225,47.053729152989916,
	47.051767852859406,47.04980893811245,47.047852403120444,47.045898242274376,47.04394644998475,
	47.041997020681485,47.04004994881381,47.03810522885021,47.03616285527829,47.03422282260477,
	47.0322851253553,47.03034975807442,47.028416715325505,47.02648599169063,47.02455758177049,
	47.02263148018434,47.0207076815699,47.018786180583284,47.01686697189889,47.01495005020931,
	47.01303541022533,47.011123046675706,47.00921295430725,47.0073051278846,47.00539956219021,
	47.00349625202433,47.00159519220476,46.99969637756694,46.9977998029638,46.995905463265636,
	46.99401335336014,46.99212346815223,46.99023580256401,46.98835035153472,46.98646711002056,
	46.98458607299477,46.98270723544743,46.9808305923854,46.978956138832345,46.9770838698285,
	46.97521378043074,46.97334586571243,46.97148012076338,46.96961654068978,46.96775512061407,
	46.965895855674965,46.964038741027295,46.96218377184198,46.96033094330596,46.958480250622095,
	46.95663168900914,46.95478525370164,46.95294093994986,46.95109874301974,46.94925865819283,
	46.94742068076619,46.945584806052345,46.94375102937921,46.94191934609003,46.940089751543326,
	46.9382622411128,46.936436810187274,46.93461345417064,46.932792168481804,46.930972948554576,
	46.9291557898377,46.92734068779465,46.92552763790368,46.923716635657726,46.92190767656434,
	46.92010075614563,46.918295869938184,46.916493013493,46.91469218237553,46.912893372165435,
	46.91109657845669,46.90930179685741,46.90750902298988,46.905718252490416,46.903929481009364,
	46.902142704210995,46.90035791777348,46.89857511738885,46.89679429876287,46.895015457614996,
	46.89323858967842,46.89146369069985,46.88969075643959,46.887919782671396,46.88615076518245,
	46.884383699773345,46.882618582257955,46.88085540846342,46.87909417423009,46.87733487541145,
	46.87557750787412,46.87382206749769,46.87206855017481,46.87031695181102,46.86856726832474,
	46.86681949564722,46.8650736297225,46.86332966650729,46.86158760197103,46.85984743209572,
	46.85810915287596,46.85637276031884,46.85463825044389,46.85290561928309,46.85117486288075,
	46.84944597729348,46.84771895859017,46.845993802851886,46.84427050617186,46.842549064655444,
	46.840829474420026,46.839111731595004,46.83739583232174,46.835681772753496,46.833969549055396,
	46.83225915740438,46.830550593989145,46.828843855010106,46.82713893667937,46.82543583522063,
	46.82373454686916,46.82203506787177,46.820337394486764,46.81864152298387,46.81694744964417,
	46.81525517076013,46.81356468263552,46.811875981585345,46.81018906393578,46.80850392602424,
	46.80682056419919,46.80513897482019,46.80345915425783,46.801781098893684,46.80010480512025,
	46.79843026934096,46.796757487970055,46.795086457432625,46.79341717416449,46.791749634612216,
	46.79008383523303,46.78841977249484,46.78675744287611,46.785096842865855,46.78343796896366,
	46.78178081767952,46.78012538553388,46.77847166905757,46.776819664791795,46.77516936928803,
	46.773520779108026,46.771873890823805,46.770228701017516,46.76858520628146,46.76694340321807,
	46.76530328843987,46.76366485856934,46.762028110239015,46.76039304009132,46.758759644778664,
	46.757127920963256,46.75549786531719,46.75386947452234,46.75224274527032,46.75061767426247,
	46.74899425820986,46.74737249383311,46.745752377862544,46.744133907037984,46.74251707810883,
	46.740901887833964,46.73928833298172,46.737676410329854,46.73606611666554,46.73445744878524,
	46.732850403494815,46.731244977609336,46.72964116795314,46.72803897135978,46.72643838467197,
	46.72483940474158,46.72324202842957,46.72164625260595,46.72005207414979,46.718459489949154,
	46.716868496901085,46.71527909191152,46.71369127189533,46.712105033776204,46.71052037448672,
	46.708937290968215
	}},
	{ // Ri = 250k
	-5,5,200,2001, {
	127.71410689388159,127.63037097463148,127.54662611437428,127.4628723371091,127.37910966689084,
	127.2953381278304,127.21155774409506,127.1277685399084,127.04397053955093,126.96016376736009,
	126.87634824773065,126.79252400511481,126.70869106402269,126.62484944902212,126.54099918473958,
	126.45714029585982,126.37327280712638,126.28939674334207,126.20551212936867,126.12161899012771,
	126.0377173506005,125.95380723582834,125.86988867091297,125.78596168101657,125.70202629136229,
	125.61808252723432,125.53413041397822,125.45016997700118,125.36620124177233,125.28222423382289,
	125.1982389787465,125.11424550219961,125.03024382990138,124.94623398763446,124.86221600124476,
	124.7781898966421,124.69415569980029,124.6101134367573,124.52606313361588,124.44200481654346,
	124.35793851177264,124.27386424560133,124.1897820443932,124.10569193457776,124.02159394265074,
	123.93748809517437,123.85337441877759,123.76925294015645,123.68512368607418,123.60098668336177,
	123.51684195891782,123.43268953970934,123.34852945277163,123.26436172520869,123.1801863841935,
	123.09600345696839,123.01181297084518,122.92761495320553,122.84340943150124,122.75919643325453,
	122.67497598605829,122.59074811757637,122.50651285554395,122.42227022776767,122.33802026212615,
	122.2537629865701,122.16949842912254,122.08522661787943,122.00094758100947,121.91666134675494,
	121.83236794343152,121.74806739942885,121.66375974321082,121.57944500331568,121.49512320835657,
	121.41079438702165,121.3264585680744,121.24211578035414,121.15776605277601,121.07340941433145,
	120.98904589408858,120.90467552119223,120.82029832486458,120.73591433440517,120.65152357919136,
	120.56712608867862,120.48272189240083,120.39831101997048,120.31389350107914,120.22946936549776,
	120.14503864307679,120.0606013637467,119.97615755751814,119.89170725448233,119.80725048481145,
	119.7227872787587,119.63831766665885,119.55384167892852,119.46935934606638,119.38487069865356,
	119.30037576735388,119.21587458291428,119.13136717616514,119.04685357802035,118.96233381947802,
	118.8778079316205,118.79327594561475,118.70873789271285,118.62419380425199,118.53964371165515,
	118.45508764643111,118.37052564017503,118.28595772456856,118.20138393138039,118.11680429246634,
	118.03221883976981,117.94762760532208,117.86303062124271,117.7784279197398,117.69381953311029,
	117.60920549374029,117.5245858341055,117.43996058677156,117.35532978439419,117.27069345971964,
	117.18605164558511,117.10140437491891,117.01675168074101,116.93209359616309,116.84743015438913,
	116.7627613887156,116.67808733253193,116.59340801932069,116.50872348265801,116.42403375621392,
	116.33933887375271,116.25463886913317,116.16993377630912,116.08522362932949,116.00050846233901,
	115.91578830957808,115.83106320538361,115.74633318418904,115.6615982805248,115.57685852901865,
	115.49211396439598,115.40736462148026,115.32261053519326,115.23785174055547,115.15308827268642,
	115.06832016680511,114.9835474582302,114.89877018238057,114.81398837477545,114.72920207103492,
	114.64441130688026,114.55961611813422,114.4748165407214,114.39001261066872,114.30520436410553,
	114.22039183726422,114.13557506648046,114.05075408819347,113.96592893894663,113.88109965538752,
	113.79626627426858,113.71142883244717,113.62658736688621,113.54174191465438,113.45689251292653,
	113.37203919898398,113.28718201021492,113.20232098411485,113.11745615828684,113.03258757044189,
	112.94771525839937,112.86283926008734,112.77795961354288,112.69307635691253,112.60818952845261,
	112.52329916652955,112.43840530962034,112.35350799631293,112.26860726530637,112.18370315541144,
	112.09879570555086,112.01388495475973,111.92897094218587,111.84405370709023,111.75913328884718,
	111.67420972694497,111.58928306098599,111.50435333068728,111.41942057588082,111.33448483651392,
	111.24954615264954,111.16460456446677,111.07966011226111,110.99471283644488,110.90976277754758,
	110.82480997621633,110.73985447321611,110.6548963094303,110.56993552586087,110.48497216362897,
	110.40000626397513,110.31503786825968,110.2300670179632,110.14509375468683,110.06011812015262,
	109.97514015620398,109.89015990480608,109.80517740804606,109.72019270813362,109.63520584740125,
	109.55021686830473,109.46522581342332,109.38023272546037,109.29523764724354,109.21024062172522,
	109.12524169198299,109.04024090121985,108.95523829276472,108.87023391007271,108.78522779672576,
	108.70021999643262,108.61521055302956,108.5301995104806,108.44518691287794,108.36017280444231,
	108.27515722952342,108.19014023260023,108.10512185828146,108.0201021513058,107.93508115654255,
	107.85005891899168,107.76503548378453,107.68001089618394,107.59498520158482,107.50995844551439,
	107.42493067363262,107.33990193173268,107.25487226574116,107.1698417217186,107.08481034585984,
	106.9997781844943,106.91474528408656,106.82971169123657,106.74467745268,106.65964261528887,
	106.57460722607166,106.48957133217381,106.40453498087814,106.31949821960512,106.23446109591343,
	106.14942365750008,106.06438595220106,105.97934802799149,105.8943099329862,105.80927171543999,
	105.72423342374798,105.63919510644615,105.5541568122115,105.46911858986266,105.38408048836006,
	105.29904255680644,105.21400484444722,105.12896740067077,105.043930275009,104.95889351713743,
	104.87385717687583,104.78882130418853,104.70378594918473,104.61875116211894,104.5337169933913,
	104.44868349354797,104.3636507132816,104.27861870343152,104.1935875149843,104.10855719907403,
	104.0235278069826,103.93849939014031,103.85347200012602,103.76844568866761,103.68342050764235,
	103.59839650907728,103.51337374514952,103.42835226818671,103.34333213066732,103.25831338522104,
	103.1732960846292,103.088280281825,103.00326602989401,102.91825338207443,102.83324239175752,
	102.748233112488,102.66322559796426,102.57821990203885,102.49321607871886,102.40821418216612,
	102.32321426669773,102.23821638678632,102.15322059706041,102.06822695230481,101.98323550746098,
	101.89824631762728,101.81325943805945,101.72827492417089,101.643292831533,101.55831321587559,
	101.47333613308714,101.38836163921526,101.30338979046691,101.21842064320886,101.13345425396793,
	101.04849067943141,100.96352997644736,100.87857220202498,100.79361741333489,100.70866566770952,
	100.62371702264346,100.53877153579373,100.45382926498016,100.36889026818567,100.28395460355672,
	100.19902232940348,100.11409350420028,100.02916818658589,99.9442464353638,99.8593283095026,
	99.77441386813635,99.68950317056475,99.60459627625363,99.5196932448351,99.43479413610798,
	99.34989901003811,99.26500792675863,99.18012094657017,99.09523812994145,99.01035953750933,
	98.9254852300792,98.84061526862531,98.755749714291,98.6708886283891,98.58603207240212,
	98.50118010798256,98.4163327969534,98.33149020130803,98.24665238321089,98.1618194049975,
	98.07699132917492,97.99216821842191,97.90735013558935,97.82253714370034,97.73772930595062,
	97.65292668570879,97.56812934651663,97.48333735208921,97.39855076631545,97.31376965325805,
	97.22899407715401,97.14422410241478,97.05945979362653,96.97470121555043,96.88994843312283,
	96.80520151145566,96.7204605158365,96.63572551172899,96.55099656477294,96.46627374078467,
	96.38155710575714,96.29684672586036,96.21214266744146,96.12744499702495,96.04275378131305,
	95.95806908718579,95.87339098170128,95.78871953209598,95.7040548057848,95.6193968703615,
	95.53474579359867,95.45010164344814,95.36546448804106,95.28083439568815,95.1962114348799,
	95.11159567428675,95.0269871827593,94.94238602932847,94.85779228320578,94.77320601378338,
	94.68862729063437,94.60405618351292,94.51949276235437,94.43493709727555,94.35038925857489,
	94.26584931673251,94.18131734241052,94.09679340645295,94.01227757988623,93.92776993391901,
	93.84327053994258,93.75877946953075,93.67429679444032,93.58982258661081,93.50535691816499,
	93.42089986140871,93.33645148883124,93.25201187310519,93.16758108708677,93.08315920381595,
	92.99874629651634,92.91434243859554,92.82994770364513,92.74556216544073,92.66118589794222,
	92.57681897529368,92.4924614718236,92.4081134620449,92.32377502065499,92.23944622253595,
	92.15512714275448,92.07081785656194,91.98651843939464,91.90222896687358,91.81794951480474,
	91.73368015917902,91.64942097617237,91.56517204214565,91.48093343364494,91.3967052274013,
	91.31248750033093,91.22828032953525,91.14408379230076,91.05989796609916,90.97572292858732,
	90.89155875760731,90.80740553118643,90.72326332753705,90.63913222505677,90.55501230232835,
	90.47090363811964,90.38680631138364,90.30272040125836,90.21864598706695,90.13458314831743,
	90.0505319647029,89.96649251610125,89.8824648825753,89.79844914437263,89.71444538192551,
	89.63045367585093,89.54647410695043,89.46250675621002,89.37855170480013,89.29460903407553,
	89.21067882557522,89.1267611610223,89.0428561223239,88.95896379157102,88.87508425103856,
	88.79121758318493,88.70736387065217,88.62352319626574,88.53969564303429,88.45588129414965,
	88.37208023298662,88.28829254310281,88.20451830823843,88.12075761231631,88.03701053944148,
	87.95327717390114,87.86955760016451,87.7858519028825,87.70216016688764,87.61848247719387,
	87.53481891899622,87.45116957767078,87.36753453877432,87.2839138880442,87.200307711398,
	87.11671609493341,87.03313912492794,86.94957688783875,86.86602947030221,86.78249695913385,
	86.69897944132802,86.6154770040576,86.53198973467373,86.44851772070558,86.36506104986006,
	86.28161981002144,86.19819408925122,86.1147839757876,86.03138955804546,85.94801092461576,
	85.86464816426543,85.781301365937,85.69797061874819,85.61465601199163,85.5313576351346,
	85.44807557781854,85.3648099298588,85.28156078124421,85.19832822213688,85.11511234287158,
	85.03191323395563,84.94873098606831,84.86556569006062,84.78241743695484,84.69928631794414,
	84.61617242439219,84.53307584783273,84.44999667996926,84.36693501267447,84.28389093798997,
	84.20086454812581,84.11785593546004,84.03486519253833,83.95189241207346,83.86893768694499,
	83.78600111019873,83.70308277504625,83.62018277486467,83.53730120319587,83.4544381537463,
	83.37159372038639,83.2887679971501,83.20596107823454,83.12317305799932,83.04040403096633,
	82.95765409181895,82.87492333540186,82.79221185672044,82.70951975094023,82.62684711338655,
	82.54419403954392,82.46156062505564,82.37894696572334,82.29635315750632,82.21377929652118,
	82.13122547904139,82.04869180149666,81.9661783604725,81.88368525270975,81.80121257510406,
	81.71876042470545,81.63632889871768,81.55391809449796,81.4715281095563,81.38915904155513,
	81.30681098830875,81.22448404778288,81.1421783180942,81.0598938975098,80.97763088444685,
	80.89538937747203,80.81316947530108,80.7309712767984,80.64879488097655,80.5666403869959,
	80.48450789416404,80.40239750193558,80.32030930991148,80.2382434178389,80.1561999256106,
	80.07417893326465,79.99218054098412,79.91020484909659,79.82825195807389,79.74632196853172,
	79.66441498122938,79.58253109706946,79.50067041709748,79.41883304250175,79.33701907461298,
	79.2552286149042,79.17346176499042,79.0917186266285,79.00999930171703,78.92830389229611,
	78.84663250054729,78.7649852287934,78.68336217949863,78.60176345526838,78.52018915884933,
	78.43863939312944,78.35711426113801,78.27561386604582,78.19413831116525,78.11268769995046,
	78.03126213599758,77.94986172304509,77.86848656497399,77.78713676580821,77.70581242971504,
	77.6245136610056,77.54324056413525,77.4619932437043,77.3807718044585,77.29957635128989,
	77.21840698923738,77.13726382348764,77.05614695937605,76.97505650238759,76.89399255815786,
	76.8129552324743,76.73194463127723,76.65096086066133,76.57000402687686,76.4890742363312,
	76.40817159559037,76.32729621138078,76.24644819059097,76.16562764027343,76.08483466764666,
	76.00406938009736,75.92333188518252,75.84262229063192,75.76194070435058,75.68128723442146,
	75.6006619891082,75.52006507685816,75.43949660630541,75.35895668627407,75.27844542578184,
	75.19796293404347,75.1175093204747,75.03708469469615,74.95668916653771,74.87632284604275,
	74.79598584347293,74.71567826931295,74.6354002342757,74.55515184930766,74.47493322559437,
	74.39474447456642,74.31458570790556,74.2344570375511,74.1543585757067,74.07429043484731,
	73.99425272772669,73.91424556738497,73.83426906715678,73.7543233406796,73.67440850190265,
	73.59452466509595,73.51467194485997,73.43485045613566,73.3550603142149,73.27530163475136,
	73.19557453377188,73.11587912768847,73.03621553331058,72.95658386785806,72.87698424897462,
	72.79741679474195,72.71788162369431,72.63837885483385,72.55890860764646,72.47947100211849,
	72.40006615875389,72.32069419859238,72.24135524322804,72.162049414829,72.08277683615778,
	72.00353763059242,71.92433192214861,71.8451598355027,71.7660214960156,71.68691702975765,
	71.60784656353472,71.528810224915,71.44980814225724,71.37084044473988,71.2919072623916,
	71.21300872612285,71.13414496775883,71.05531612007377,70.97652231682657,70.89776369279781,
	70.81904038382835,70.7403525268595,70.66170025997458,70.58308372244238,70.50450305476227,
	70.42595839871099,70.34744989739154,70.26897769528371,70.19054193829687,70.11214277382473,
	70.03378035080222,69.95545481976471,69.87716633290935,69.79891504415927,69.7207011092298,
	69.64252468569747,69.56438593307186,69.48628501287003,69.40822208869388,69.33019732631077,
	69.2522108937369,69.17426296132423,69.09635370185053,69.01848329061319,68.94065190552642,
	68.86285972722224,68.78510693915544,68.7073937277126,68.62972028232508,68.55208679558667,
	68.47449346337547,68.39694048498055,68.3194280632334,68.24195640464447,68.16452571954476,
	68.08713622223299,68.00978813112802,67.9324816689275,67.85521706277201,67.7779945444158,
	67.70081435040368,67.62367672225463,67.54658190665242,67.46953015564308,67.39252172684,
	67.31555688363655,67.23863589542647,67.1617590378327,67.08492659294441,67.00813884956295,
	66.93139610345662,66.85469865762495,66.77804682257263,66.7014409165934,66.62488126606407,
	66.54836820574947,66.4719020791183,66.39548323867015,66.31911204627453,66.24278887352177,
	66.16651410208661,66.09028812410435,66.01411134256057,65.93798417169442,65.86190703741592,
	65.78588037773788,65.70990464322274,65.63398029744468,65.55810781746776,65.48228769434007,
	65.4065204336049,65.33080655582876,65.25514659714729,65.17954110982919,65.10399066285865,
	65.02849584253697,64.95305725310344,64.87767551737647,64.80235127741491,64.72708519520037,
	64.65187795334074,64.57673025579578,64.50164282862441,64.42661642075512,64.35165180477914,
	64.27674977776694,64.20191116210874,64.12713680637887,64.0524275862248,63.97778440528064,
	63.90320819610572,63.828699921148356,63.75426057373482,63.67989117908384,63.60559279534665,
	63.53136651467246,63.45721346429951,63.38313480767129,63.3091317455782,63.235205517323706,
	63.1613574019153,63.087588719279324,63.01390083149925,62.94029514407676,62.866773107215394,
	62.79333621712217,62.719986017334925,62.64672410006289,62.573552107547066,62.50047173343607,
	62.42748472417579,62.35459288041129,62.28179805839856,62.20910217142397,62.13650719122872,
	62.06401514943553,61.991628138974576,61.91934831550523,61.84717789883025,61.77511917429832,
	61.70317449419091,61.63134627908918,61.55963701921577,61.48804927574698,61.416585682089384,
	61.345248945115685,61.27404184635344,61.20296724312036,61.13202806959973,61.06122733784852,
	60.990568138731305,60.92005364277185,60.849687100914856,60.77947184518924,60.7094112892646,
	60.639508928892035,60.56976834222019,60.50019318997743,60.43078721551057,60.361554244670785,
	60.292498185536815,60.22362302796594,60.154932842963085,60.086431781858,60.01812407528164,
	59.95001403193177,59.88210603711914,59.81440455108519,59.74691410708325,59.67963930921499,
	59.61258483001535,59.54575540777875,59.47915584362142,59.41279099827438,59.34666578860328,
	59.2807851838522,59.2151542016094,59.1497779034947,59.084661390569075,59.01980979846861,
	58.95522829226668,58.89092206106925,58.826896312350435,58.76315626603648,58.69970714834864,
	58.63655418541667,58.57370259667665,58.5111575880686,58.4489243450508,58.38700802544981,
	58.32541375216653,58.26414660576007,58.20321161693319,58.142613758943725,58.08235793996821,
	58.02244899544467,57.96289168042258,57.90369066194865,57.84485051151782,57.78637569761907,
	57.728270578405706,57.670539394519956,57.613186262101195,57.556215166006865,57.49962995327386,
	57.44343432684804,57.38763183960761,57.332225888704876,57.27721971024994,57.22261637435696,
	57.16841878057303,57.11462965370651,57.06125154007017,57.00828680415199,56.955737625724076,
	56.90360599739759,56.851893722629455,56.80060241418379,56.749733493048865,56.69928818780742,
	56.649267534456705,56.5996723766712,56.55050336649992,56.50176096548704,56.45344544620369,
	56.40555689417605,56.35809521019394,56.3110601129821,56.26445114221556,56.21826766185884,
	56.1725088638083,56.12717377181586,56.08226124567182,56.03776998562417,55.99369853701155,
	55.95004529508664,55.906808510007636,55.86398629197445,55.82157661648794,55.77957732971005,
	55.73798615390377,55.69680069293227,55.65601843779759,55.6156367722,55.57565297809988,
	55.536064241265414,55.496867656789824,55.45806023456337,55.419638904686174,55.381600522808974,
	55.34394187539024,55.30665968485867,55.26975061467163,55.233211274260846,55.19703822385773,
	55.16122797919157,55.12577701605504,55.090681774732005,55.05593866428371,55.021544066690204,
	54.98749434084448,54.95378582639764,54.92041484745405,54.88737771611606,54.85467073587842,
	54.82229020487293,54.79023241896469,54.75849367470126,54.72707027211698,54.695958517394345,
	54.6651547253856,54.634655221996816,54.604456346438184,54.57455445334341,54.54494591476187,
	54.515627122027276,54.48659448750634,54.45784444623146,54.42937345742152,54.40117800589419,
	54.37325460337431,54.345599789702035,54.3182101339446,54.29108223541605,54.26421272460841,
	54.23759826403835,54.211235549013246,54.18512130832007,54.15925230484116,54.133625336099975,
	54.10823723474076,54.08308486894516,54.058165142789306,54.03347499654447,54.009011406924365,
	53.98477138728205,53.960751987759494,53.93695029539235,53.91336343417276,53.889988565072706,
	53.8668228860304,53.843863631896774,53.821108074376575,53.798553521884024,53.77619731942713,
	53.754036848436726,53.732069526577085,53.710292807534366,53.68870418078405,53.66730117133944,
	53.64608133948245,53.62504228047837,53.60418162427583,53.58349703519342,53.56298621159403,
	53.54264688554834,53.52247682248828,53.50247382085171,53.48263571171927,53.46296035844425,
	53.44344565627648,53.424089531980904,53.404889943451785,53.385844879323145,53.36695235857612,
	53.34821043014399,53.329617172515356,53.31117069333593,53.29286912900979,53.2747106443002,
	53.256693431930756,53.23881571218698,53.221075732519026,53.203471767145714,53.18600211666021,
	53.16866510763768,53.1514590922453,53.13438244785472,53.117433576657284,53.10061090528229,
	53.08391288441839,53.067337988438396,53.05088471502755,53.03455158481552,53.01833714101215,
	53.00223994904725,52.98625859621423,52.97039169131804,52.95463786432722,52.93899576603022,
	52.92346406769613,52.90804146073969,52.89272665639084,52.87751838536868,52.86241539755988,
	52.84741646170173,52.83252036506953,52.81772591316867,52.80303192943121,52.78843725491684,
	52.77394074801861,52.759541284172926,52.74523775557416,52.731029070893676,52.71691415500334,
	52.702891948703346,52.68896140845456,52.67512150611502,52.66137122868091,52.64770957803173,
	52.63413557067964,52.6206482375231,52.607246623604546,52.59392978787219,52.580696802945916,
	52.56754675488706,52.554478742972215,52.54149187947094,52.52858528942731,52.51575811044515,
	52.503009492477155,52.49033859761764,52.477744599898934,52.46522668509128,52.45278405050638,
	52.440415904804404,52.42812146780426,52.415899970297474,52.403750653865245,52.39167277069868,
	52.3796655834225,52.367728364921625,52.35586039817102,52.3440609760686,52.33232940127107,
	52.32066498603271,52.30906705204721,52.297534930292066,52.286067960876146,52.27466549288969,
	52.2633268842572,52.25205150159289,52.24083872005886,52.2296879232257,52.218598502935684,
	52.20756985916843,52.19660139990896,52.18569254101821,52.17484270610582,52.16405132640516,
	52.1533178406454,52.142641694953106,52.13202234270001,52.121459244410154,52.110951867639855,
	52.1004996868657,52.090102183374604,52.07975884515582,52.06946916679489,52.05923264936942,
	52.0490488003469,52.03891713348417,52.02883716872883,52.01880843212225,52.00883045570453,
	51.998902777420945,51.98902494103017,51.979196496014104,51.96941699748935,51.95968600612014,
	51.950003088032936,51.940367814732504,51.9307797630194,51.921238514909035,51.911743657552016,
	51.902294783156066,51.89289148890917,51.883533376904126,51.874220054064416,51.86495113207138,
	51.85572622729263,51.84654496071179,51.83740695785929,51.82831184874462,51.81925926778952,
	51.810248853762396,51.80128024971402,51.79235310291407,51.78346706478901,51.77462179086085,
	51.76581694068713,51.75705217780178,51.74832716965708,51.739641587566574,51.730995106648955,
	51.722387405772956,51.71381816750311,51.70528707804646,51.69679382720013,51.68833810829989,
	51.679919618169414,51.67153805707061,51.663193128654555,51.65488453991338,51.646612001132986,
	51.63837522584644,51.63017393078825,51.62200783584932,51.613876664032674,51.605780141410015,
	51.59771799707874,51.589689963120016,51.58169577455724,51.5737351693153,51.5658078881806,
	51.55791367476154,51.55005227544976,51.54222343938202,51.534426918402694,51.52666246702678,
	51.518929842403615,51.51122880428113,51.503559114970734,51.49592053931259,51.48831284464175,
	51.480735800754445,51.47318917987531,51.46567275662485,51.45818630798746,51.450729613280124,
	51.44330245412141,51.435904614401025,51.428535880249925,51.42119604001074,51.41388488420883,
	51.406602205523654,51.39934779876065,51.39212146082357,51.384922990687194,51.37775218937053,
	51.37060885991035,51.36349280733517,51.356403838639714,51.34934176275958,51.34230639054648,
	51.33529753474379,51.32831500996241,51.32135863265709,51.31442822110307,51.307523595373084,
	51.30064457731468,51.29379099052792,51.28696266034342,51.280159413800696,51.2733810796268,
	51.266627488215384,51.259898471605986,51.25319386346358,51.24651349905862,51.23985721524715,
	51.23322485045136,51.22661624464038,51.22003123931138,51.213469677470876,51.20693140361638,
	51.20041626371834,51.19392410520225,51.1874547769311,51.18100812918804,51.17458401365931,
	51.16818228341742,51.16180279290459,51.155445397916345,51.149109955585494,51.14279632436613,
	51.136504364018116,51.13023393559154,51.1239849014116,51.117757125063534,51.11155047137789,
	51.105364806415906,51.09919999745521,51.09305591297559,51.08693242264509,51.080829397306154,
	51.07474670896215,51.0686842307639,51.062641836996534,51.05661940306643,51.050616805488374,
	51.04463392187298,51.038670630914076,51.032726812376474,51.0268023470838,51.020897116906546,
	51.01501100475018,51.00914389454356,51.003295671227434,50.997466220743036,50.99165543002098,
	50.98586318697016,50.98008938046693,50.9743339003443,50.96859663738135,50.962877483292836,
	50.95717633071879,50.951493073214415,50.94582760523999,50.940179822151,50.93454962018834,
	50.92893689646868,50.92334154897494,50.91776347654686,50.91220257887181,50.90665875647558,
	50.90113191071332,50.89562194376072,50.890128758605144,50.88465225903083,50.87919234963523,
	50.873748935782636,50.868321923621444,50.86291122006953,50.857516732805955,50.852138370263006,
	50.84677604161832,50.84142965678696,50.836099126413714,50.83078436186553,50.8254852752239,
	50.82020177927746,50.814933787514654,50.809681214116466,50.80444397394926,50.79922198255775,
	50.79401515615793,50.7888234116303,50.78364666651294,50.77848483899486,50.77333784790937,
	50.76820561272747,50.763088053551385,50.757985091108196,50.75289664674354,50.74782264241529,
	50.74276300068746,50.73771764472411,50.73268649828331,50.72766948571119,50.722666531936135,
	50.717677562462924,50.71270250336703,50.70774128128894,50.70279382342861,50.69786005753989,
	50.692939911925144,50.68803331542977,50.68314019743691,50.67826048786223,50.673394117148696,
	50.66854101626134,50.663701116682375,50.65887435040602,50.65406064993359,50.64925994826862,
	50.64447217891203,50.63969727585727,50.634935173585696,50.630185807061785,50.62544911172861,
	50.620725023503226,50.61601347877219,50.61131441438705,50.60662776766002,50.60195347635955,
	50.59729147870602,50.592641713367534,50.58800411945574,50.58337863652149,50.57876520455096,
	50.57416376396148,50.569574255597445,50.56499662072648,50.56043080103541,50.555876738626445,
	50.55133437601325,50.54680365611728,50.54228452226389,50.537776918178714,50.53328078798398,
	50.528796076194844,50.52432272771587,50.519860687837365,50.515409902232015,50.51097031695132,
	50.50654187842221,50.502124533443585,50.49771822918303,50.49332291317349,50.48893853330996,
	50.4845650378462,50.48020237539166,50.475850494908144,50.471509345706764,50.46717887744483,
	50.46285904012273,50.45854978408095,50.45425105999699,50.4499628188825,50.445685012080226,
	50.44141759126115,50.437160508421634,50.43291371588053,50.42867716627639,50.42445081256464,
	50.420234608014894,50.41602850620814,50.41183246103411,50.40764642668856,50.40347035767065,
	50.39930420878035,50.395147935115816,50.391001492070814,50.386864835332275,50.382737920877695,
	50.37862070497268,50.37451314416854,50.37041519529979,50.3663268154818,50.36224796210837,
	50.358178592849434,50.35411866564866,50.35006813872123,50.34602697055147,50.34199511989065,
	50.337972545754724,50.33395920742215,50.32995506443163,50.32596007658005,50.32197420392023,
	50.31799740675884,50.31402964565435,50.31007088141486,50.306121075096115,50.302180187999404,
	50.29824818166958,50.2943250178931,50.29041065869596,50.28650506634179,50.28260820332991,
	50.27872003239342,50.274840516497285,50.27096961883646,50.267107302833985,50.26325353213927,
	50.25940827062611,50.25557148239099,50.25174313175123,50.24792318324328,50.24411160162089,
	50.24030835185342,50.23651339912413,50.232726708828416,50.22894824657221,50.225177978170244,
	50.22141586964439,50.21766188722211,50.21391599733471,50.21017816661585,50.206448361899845,
	50.2027265502202,50.19901269880796,50.19530677509022,50.19160874668856,50.18791858141753,
	50.18423624728321,50.18056171248162,50.17689494539736,50.17323591460204,50.16958458885293,
	50.16594093709147,50.16230492844187,50.158676532209725,50.155055717880586,50.15144245511861,
	50.147836713765194,50.1442384638376,50.14064767552765,50.13706431920038,50.13348836539271,
	50.12991978481218,50.12635854833562,50.1228046270079,50.119257992040644,50.11571861481102,
	50.11218646686042,50.108661519893296,50.10514374577589,50.10163311653508,50.09812960435712,
	50.09463318158654,50.091143820724845,50.08766149442946,50.08418617551254,50.0807178369398,
	50.07725645182943,50.0738019934509,50.07035443522393,50.06691375071733,50.06347991364794,
	50.0600528978795,50.056632677421646,50.053219226428745,50.04981251919899,50.0464125301732,
	50.043019233933876,50.039632605204126,50.03625261884674,50.03287924986302,50.029512473391925,
	50.02615226470904,50.02279859922557,50.01945145248735,50.016110800173976,50.01277661809773,
	50.009448882202705,50.006127568563855,50.002812653386044,49.999504113003155,49.996201923877116,
	49.99290606259709,49.98961650587846,49.98633323056206,49.98305621361317,49.979785432120735,
	49.97652086329642,49.97326248447388,49.97001027310771,49.966764206772766,49.96352426316325,
	49.960290420091916,49.95706265548919,49.95384094740241,49.95062527399499,49.947415613545616,
	49.94421194444746,49.941014245207384,49.93782249444515,49.93463667089265,49.931456753393135,
	49.92828272090048,49.92511455247836,49.92195222729956,49.91879572464521,49.915645023904055,
	49.91250010457169,49.90936094624992,49.906227528645886,49.90309983157153,49.89997783494276,
	49.89686151877883,49.893750863201554,49.89064584843471,49.8875464548033,49.884452662732876,
	49.88136445274888,49.87828180547599,49.875204701637415,49.87213312205427,49.869067047644926,
	49.86600645942436,49.86295133850351,49.85990166608859,49.856857423480584,49.853818592074525,
	49.85078515335885,49.8477570889149,49.8447343804162,49.8417170096279,49.838704958406176,
	49.83569820869762,49.83269674253869,49.829700542055036,49.82670958946103,49.82372386705911,
	49.82074335723925,49.817768042472444,49.814797905334025,49.811832928466984,49.808873094605765,
	49.80591838656946,49.80296878726143,49.800024279668605,49.79708484686108,49.7941504719915,
	49.79122113829454,49.78829682908642,49.78537752776435,49.78246321780604,49.779553882769164,
	49.776649506290845,49.77375007208722,49.77085556395282,49.767965965760226,49.765081261459436,
	49.76220143507746,49.759326470717795,49.75645635255998,49.7535910648591,49.75073059194529,
	49.747874918223346,49.745024028172125,49.7421779063442,49.739336537365396,49.73649990593424,
	49.73366799682159,49.73084079487018,49.72801828499415,49.72520045217863,49.72238728147925,
	49.71957875802181,49.7167748670017,49.71397559368362,49.71118092340106,49.70839084155591,
	49.70560533361804,49.7028243851249,49.700047981681045,49.69727610895784,49.6945087526929,
	49.69174589868986,49.68898753281784,49.686233641011114,49.68348420926867,49.68073922365387,
	49.677998670294045,49.675262535380114,49.67253080516613,49.66980346596903,49.667080504168155,
	49.664361906204924,49.661647658582424,49.65893774786512,49.656232160678385,49.65353088370822,
	49.65083390370083,49.64814120746233,49.64545278185836,49.64276861381369,49.64008869031196,
	49.63741299839526,49.63474152516381,49.63207425777559,49.62941118344608,49.62675228944784,
	49.62409756311019,49.621446991818914,49.6188005630159,49.616158264198816,49.613520082920815,
	49.61088600679012,49.60825602346983,49.60563012067751,49.603008286184945,49.60039050781773,
	49.59777677345504,49.595167071029294,49.592561388525866,49.589959713982715,49.58736203549021,
	49.58476834119065,49.58217861927815,49.5795928579982,49.577011045647474,49.57443317057347,
	49.571859221174236,49.5692891858981,49.5667230532434,49.56416081175812,49.56160245003971,
	49.559047956734716,49.556497320538575,49.55395053019528,49.55140757449716,49.54886844228456,
	49.54633312244559,49.54380160391588,49.541273875678236,49.53874992676249,49.53622974624516,
	49.53371332324919,49.53120064694368,49.528691706543725,49.526186491310014,49.52368499054871,
	49.521187193611105,49.51869308989338,49.51620266883645,49.51371591992555,49.511232832690155,
	49.50875339670366,49.50627760158309,49.503805436988976,49.501336892625,49.49887195823785,
	49.49641062361694,49.493952878594136,49.491498713043626,49.48904811688159,49.48660108006605,
	49.48415759259656,49.481717644514056,49.47928122590058,49.4768483268791,49.47441893761324,
	49.47199304830709,49.46957064920497,49.46715173059123,49.46473628279007,49.462324296165214,
	49.45991576111982,49.45751066809616,49.45510900757554,49.45271077007792,49.45031594616191,
	49.447924526424366,49.445536501500314,49.44315186206271,49.44077059882224,49.438392702527075,
	49.43601816396279,49.43364697395201,49.4312791233543,49.42891460306603,49.426553404020034,
	49.42419551718554,49.4218409335679,49.419489644208475,49.417141640184376,49.41479691260828,
	49.41245545262833,49.41011725142784,49.40778230022515,49.405450590273496,49.40312211286072,
	49.40079685930923,49.398474820975665,49.396155989250836,49.3938403555595,49.39152791136018,
	49.38921864814501,49.38691255743956,49.38460963080261,49.38230985982607,49.38001323613476,
	49.37771975138622,49.37542939727055,49.37314216551034,49.370858047860295,49.3685770361073,
	49.36629912207009,49.36402429759919,49.36175255457669,49.35948388491609,49.357218280562186,
	49.35495573349086,49.352696235708954,49.35043977925408,49.3481863561945,49.34593595862897,
	49.34368857868653,49.34144420852644,49.33920284033793,49.336964466340156,49.33472907878194,
	49.332496669941705,49.33026723212729,49.32804075767577,49.325817238953434,49.32359666835544,
	49.32137903830588,49.31916434125746,49.316952569691495,49.31474371611768,49.31253777307398,
	49.31033473312645,49.30813458886922,49.30593733292418,49.30374295794095,49.30155145659675,
	49.299362821596226,49.29717704567129,49.29499412158105,49.29281404211169,49.290636800076186,
	49.28846238831439,49.28629079969271,49.284122027104125,49.28195606346793,49.27979290172971,
	49.277632534861155,49.27547495585994,49.27332015774964,49.271168133579515,49.26901887642447,
	49.266872379384914,49.26472863558659,49.26258763818053,49.26044938034281,49.2583138552746,
	49.25618105620189,49.254050976375446,49.25192360907068,49.24979894758752,49.247676985250294,
	49.245557715407635,49.24344113143235,49.241327226721246,49.23921599469515,49.23710742879865,
	49.23500152250011,49.23289826929144,49.23079766268805,49.22869969622873,49.226604363475566,
	49.22451165801374,49.22242157345151,49.22033410342011,49.21824924157349,49.21616698158843,
	49.214087317164285,49.2120102420229,49.209935749908546,49.207863834587755,49.205794489849296,
	49.203727709503966,49.201663487384614,49.1996018173459,49.19754269326433,49.195486109038,
	49.193432058586666,49.191380535851515,49.189331534795116,49.187285049401304,49.185241073675115,
	49.18319960164263,49.181160627350934,49.179124144868,49.17709014828257,49.17505863170408,
	49.17302958926258,49.171003015108596,49.16897890341308,49.16695724836726,49.16493804418265,
	49.162921285090825,49.16090696534343,49.15889507921204,49.15688562098809,49.15487858498278,
	49.15287396552697,49.150871756971085,49.148871953685074,49.14687455005827,49.144879540499325,
	49.14288691943613,49.1408966813157,49.13890882060412,49.13692333178643,49.13494020936655,
	49.13295944786721,49.13098104182983,49.12900498581449,49.1270312743998,49.12505990218281,
	49.123090863778984,49.12112415382205,49.11915976696397,49.11719769787483,49.11523794124276,
	49.11328049177389,49.1113253441922,49.10937249323952,49.10742193367536,49.10547366027695,
	49.10352766783903,49.10158395117391,49.09964250511123,49.09770332449801,49.095766404198585,
	49.09383173909442,49.09189932408408,49.089969154083235,49.08804122402445,49.08611552885723,
	49.08419206354785,49.08227082307937,49.08035180245145,49.07843499668046,49.07652040079913,
	49.074608009856775,49.07269781891905,49.07078982306788,49.068884017401444,49.06698039703411,
	49.065078957096304,49.063179692734494,49.06128259911111,49.059387671404444,49.05749490480863,
	49.05560429453351,49.05371583580466,49.05182952386325,49.04994535396595,49.04806332138497,
	49.046183421407896,49.04430564933769,49.04243000049254,49.040556470205914,49.038685053826356,
	49.03681574671756,49.034948544258214,49.03308344184194,49.0312204348773,49.029359518787615,
	49.027500689011035,49.02564394100038,49.023789270223126,49.0219366721613,49.020086142311484,
	49.01823767618467,49.01639126930625,49.01454691721598,49.01270461546788,49.01086435963016,
	49.00902614528518,49.00718996802942,49.005355823473366,49.00352370724148,49.00169361497215,
	48.999865542317615,48.99803948494391,48.99621543853083,48.994393398771834,48.99257336137398,
	48.99075532205794,48.98893927655789,48.98712522062145,48.98531315000965,48.983503060496865,
	48.98169494787073,48.979888807932156,48.97808463649521,48.9762824293871,48.974482182448064,
	48.97268389153142,48.97088755250339,48.96909316124315,48.96730071363632,48.96551020560066,
	48.96372163304716,48.9619349919061,48.96015027812035,48.958367487645454,48.95658661644943,
	48.954807660512834,48.95303061582864,48.95125547840219,48.94948224425122,48.9477109094057,
	48.94594146990787,48.94417392181218,48.94240826118513,48.94064448410544,48.93888258666375,
	48.93712256496276,48.9353644151171,48.93360813325328,48.931853715509696,48.9301011580365,
	48.9283504569956,48.92660160856065,48.92485460891692,48.9231094542613,48.92136614080224,
	48.91962466475975,48.917885022365255,48.91614720986162,48.9144112235031,48.91267705955529,
	48.91094471429508,48.90921418401056,48.907485465001066,48.905758553577066,48.904033446060154,
	48.90231013878297,48.90058862808918,48.89886891033346,48.897150981881396,48.89543483910943,
	48.89372047840492,48.89200789616598,48.89029708880152,48.888588052731166,48.886880784385184,
	48.88517528020453,48.8834715366407,48.8817695501558,48.88006931722242,48.8783708343236,
	48.87667409795285,48.87497910461405,48.873285850821404,48.87159433309945,48.86990454798301,
	48.86821649201712,48.86653016175695,48.8648455537679,48.86316266462543,48.861481490915075,
	48.859802029232426,48.85812427618303,48.8564482283824,48.854773882455966,48.853101235039034,
	48.85143028277675,48.849761022324046,48.848093450345615,48.846427563515896,48.844763358519,
	48.843100832048705,48.84143998080835,48.839780801510905,48.83812329087887,48.83646744564421,
	48.83481326254839,48.83316073834229,48.831509869786224,48.82986065364979,48.82821308671196,
	48.826567165760984,48.82492288759435,48.82328024901878,48.821639246850154,48.81999987791354,
	48.81836213904305,48.81672602708195,48.8150915388825,48.81345867130596,48.8118274212226,
	48.81019778551163,48.80856976106113,48.80694334476807,48.80531853353828,48.80369532428636,
	48.802073713935734,48.80045369941852,48.79883527767556,48.797218445656384,48.795603200319114,
	48.79398953863057,48.79237745756606,48.79076695410952,48.78915802525333,48.78755066799839,
	48.78594487935404,48.784340656338046,48.78273799597654,48.781136895304066,48.779537351363416,
	48.77793936120575,48.776342921890446,48.77474803048514,48.77315468406565,48.771562879715994,
	48.769972614528285,48.76838388560281,48.766796690047926,48.76521102497998,48.76362688752345,
	48.7620442748107
	}}
};
table1d_imp<2001> tubetable2_JJECC99[2] __rt_data = {
	{ // Ri = 68k
	-5,5,200,2001, {
	12274.474491258665,12267.292706998116,12260.125203326588,12252.971968290207,12245.832989978866,
	12238.708256528285,12231.59775611796,12224.501476972633,12217.419407360405,12210.351535594116,
	12203.297850030498,12196.258339069918,12189.232991156701,12182.22179477831,12175.224738465713,
	12168.24181079362,12161.273000378515,12154.318295881116,12147.37768600404,12140.45115949288,
	12133.538705135465,12126.640311762032,12119.755968244603,12112.885663497595,12106.02938647686,
	12099.18712618001,12092.35887164632,12085.544611956022,12078.744336230717,12071.958033633133,
	12065.185693366337,12058.427304674662,12051.682856842646,12044.952339195232,12038.235741097471,
	12031.533051954677,12024.84426121168,12018.169358353527,12011.5083329042,12004.861174427637,
	11998.227872526411,11991.6084168427,11985.00279705725,11978.411002889545,11971.833024097628,
	11965.268850478133,11958.718471865579,11952.181878132913,11945.659059190744,11939.150004987172,
	11932.654705508325,11926.173150777538,11919.705330855255,11913.251235838914,11906.810855863037,
	11900.38418109889,11893.971201753855,11887.571908071895,11881.186290333435,11874.814338854703,
	11868.456043987491,11862.111396119559,11855.780385674256,11849.463003109899,11843.15923892009,
	11836.86908363374,11830.592527813815,11824.329562058667,11818.080177000358,11811.844363305816,
	11805.622111675752,11799.413412844622,11793.218257580891,11787.036636686178,11780.868540996127,
	11774.713961378722,11768.572888735407,11762.445314000235,11756.331228140138,11750.230622154162,
	11744.1434870738,11738.069813962315,11732.009593915047,11725.962818059184,11719.929477553229,
	11713.90956358698,11707.903067381068,11701.909980187518,11695.930293288864,11689.963997997997,
	11684.011085658693,11678.071547644264,11672.145375358145,11666.232560233952,11660.333093734334,
	11654.446967351412,11648.574172606599,11642.714701050454,11636.86854426178,11631.035693848387,
	11625.216141446357,11619.409878719896,11613.6168973612,11607.837189090153,11602.070745654213,
	11596.317558828387,11590.577620414599,11584.85092224179,11579.13745616554,11573.43721406828,
	11567.750187858317,11562.076369470395,11556.415750864986,11550.768324028157,11545.134080971744,
	11539.51301373257,11533.905114372603,11528.310374978697,11522.728787662229,11517.160344558788,
	11511.605037828489,11506.062859655287,11500.533802246802,11495.017857834117,11489.515018671735,
	11484.02527703691,11478.548625230522,11473.085055574918,11467.634560415747,11462.197132120504,
	11456.772763078741,11451.361445701492,11445.96317242114,11440.57793569193,11435.205727988507,
	11429.84654180665,11424.500369662472,11419.167204092391,11413.847037653071,11408.539862920941,
	11403.245672491803,11397.964458981174,11392.696215023376,11387.440933271773,11382.19860639826,
	11376.96922709314,11371.752788065021,11366.549282039898,11361.358701762,11356.18103999258,
	11351.016289510284,11345.864443110295,11340.72549360469,11335.599433821828,11330.486256606286,
	11325.38595481842,11320.298521334205,11315.223949045196,11310.162230857384,11305.113359692417,
	11300.077328485924,11295.05413018804,11290.043757763155,11285.046204188964,11280.061462456984,
	11275.08952557193,11270.13038655149,11265.184038425838,11260.25047423783,11255.329687042316,
	11250.421669906162,11245.526415907596,11240.64391813634,11235.774169693083,11230.917163689319,
	11226.072893246948,11221.241351498293,11216.42253158503,11211.6164266589,11206.823029881029,
	11202.042334421256,11197.274333458463,11192.519020179801,11187.776387780503,11183.046429463984,
	11178.329138440984,11173.624507929442,11168.93253115473,11164.253201348341,11159.586511748355,
	11154.932455598993,11150.291026150235,11145.662216657443,11141.046020381062,11136.442430586389,
	11131.851440543509,11127.273043526457,11122.707232813262,11118.154001685329,11113.61334342782,
	11109.085251328213,11104.569718677172,11100.066738767177,11095.576304893268,11091.098410351424,
	11086.633048439775,11082.180212456742,11077.739895701676,11073.312091474454,11068.896793074658,
	11064.493993801812,11060.103686954508,11055.725865830478,11051.36052372627,11047.007653936389,
	11042.667249753598,11038.339304468307,11034.02381136786,11029.720763737025,11025.430154856784,
	11021.1519780045,11016.886226453591,11012.632893472486,11008.391972325464,11004.163456271066,
	10999.947338562562,10995.743612447184,10991.552271166023,10987.37330795358,10983.20671603707,
	10979.05248863675,10974.910618964606,10970.781100225011,10966.663925613759,10962.559088317495,
	10958.466581513936,10954.386398371002,10950.318532046636,10946.262975688736,10942.21972243388,
	10938.188765407931,10934.170097724857,10930.16371248722,10926.169602784801,10922.187761694811,
	10918.218182281367,10914.260857595156,10910.315780672998,10906.382944537105,10902.462342195406,
	10898.553966640393,10894.657810849352,10890.773867783426,10886.90213038746,10883.04259158956,
	10879.195244300912,10875.360081414656,10871.537095806492,10867.726280333323,10863.92762783348,
	10860.141131125858,10856.366783009677,10852.604576264428,10848.854503648605,10845.116557900057,
	10841.390731735233,10837.677017848391,10833.975408912112,10830.285897575806,10826.608476466017,
	10822.943138185714,10819.289875313803,10815.648680404754,10812.019545987958,10808.402464567747,
	10804.797428622338,10801.204430603986,10797.623462938152,10794.054518023033,10790.497588229156,
	10786.952665899229,10783.419743347169,10779.898812858046,10776.3898666872,10772.892897060421,
	10769.4078961727,10765.93485618845,10762.473769240622,10759.024627430168,10755.587422825936,
	10752.162147463878,10748.748793346866,10745.347352443723,10741.957816689344,10738.580177983531,
	10735.214428191408,10731.860559141905,10728.51856262794,10725.188430405902,10721.870154194681,
	10718.563725675844,10715.269136492312,10711.986378248996,10708.715442510955,10705.456320803893,
	10702.209004613509,10698.973485384255,10695.749754519777,10692.537803382029,10689.337623290423,
	10686.149205521975,10682.972541310188,10679.807621844739,10676.654438271215,10673.512981690184,
	10670.383243156819,10667.265213680621,10664.158884224546,10661.064245704405,10657.98128898896,
	10654.910004898622,10651.850384205422,10648.802417632007,10645.766095851961,10642.74140948823,
	10639.728349113055,10636.726905247882,10633.737068361752,10630.758828871902,10627.792177142235,
	10624.837103483573,10621.8935981524,10618.961651350854,10616.041253226022,10613.13239386915,
	10610.235063315296,10607.349251543013,10604.474948472962,10601.612143968536,10598.760827834163,
	10595.920989815259,10593.092619598041,10590.275706808035,10587.470241010253,10584.676211708718,
	10581.893608344822,10579.122420297968,10576.36263688457,10573.614247357089,10570.877240903992,
	10568.151606648968,10565.437333650178,10562.734410900037,10560.042827324112,10557.362571781146,
	10554.693633062021,10552.035999889225,10549.389660916522,10546.754604728123,10544.130819838154,
	10541.518294689979,10538.917017655767,10536.32697703588,10533.748161057938,10531.180557876864,
	10528.624155573629,10526.078942155033,10523.544905553019,10521.022033623973,10518.51031414828,
	10516.009734829828,10513.520283294765,10511.041947091466,10508.574713690248,10506.118570481764,
	10503.673504776942,10501.239503806933,10498.816554721285,10496.404644588309,10494.003760394173,
	10491.613889042048,10489.235017351955,10486.86713205971,10484.510219816419,10482.164267188047,
	10479.829260654846,10477.5051866102,10475.19203136062,10472.889781124988,10470.598422033636,
	10468.317940127847,10466.048321359574,10463.789551590471,10461.541616591187,10459.304502041234,
	10457.078193527614,10454.862676545084,10452.657936494685,10450.463958683948,10448.280728325184,
	10446.108230536254,10443.946450338844,10441.795372658025,10439.654982322038,10437.525264061605,
	10435.40620250862,10433.297782196525,10431.199987559035,10429.11280292964,10427.036212541141,
	10424.970200524833,10422.91475090996,10420.869847623057,10418.835474487742,10416.811615223163,
	10414.798253444185,10412.795372660668,10410.802956276559,10408.820987589444,10406.849449789781,
	10404.888325960694,10402.93759907686,10400.997252004021,10399.067267498674,10397.147628206954,
	10395.238316664618,10393.339315295967,10391.450606413327,10389.572172216423,10387.703994792097,
	10385.846056113152,10383.99833803823,10382.160822310929,10380.333490559202,10378.516324295026,
	10376.709304913431,10374.912413692135,10373.125631790883,10371.348940250748,10369.582319993764,
	10367.825751822278,10366.079216418022,10364.34269434187,10362.616166033426,10360.899611809722,
	10359.193011865467,10357.496346271799,10355.809594976248,10354.132737801554,10352.465754445786,
	10350.808624481277,10349.161327354017,10347.523842383467,10345.896148761582,10344.278225552594,
	10342.670051692354,10341.071605987481,10339.482867115068,10337.903813622357,10336.334423925582,
	10334.774676309962,10333.224548928814,10331.684019803277,10330.153066821584,10328.631667738651,
	10327.119800175247,10325.61744161788,10324.12456941803,10322.641160791758,10321.16719281887,
	10319.702642442791,10318.247486469834,10316.80170156879,10315.365264270267,10313.938150966329,
	10312.520337910057,10311.111801214756,10309.71251685379,10308.322460659905,10306.941608324838,
	10305.569935398747,10304.207417289805,10302.854029263743,10301.509746443282,10300.174543807863,
	10298.848396192732,10297.531278289289,10296.223164643792,10294.924029657495,10293.633847585685,
	10292.35259253811,10291.080238477343,10289.81675921955,10288.562128433166,10287.31631963901,
	10286.079306209767,10284.851061369205,10283.63155819247,10282.420769605093,10281.218668382817,
	10280.025227151378,10278.840418385727,10277.66421441011,10276.496587397354,10275.337509368608,
	10274.18695219314,10273.044887587812,10271.911287116716,10270.786122191066,10269.66936406857,
	10268.560983853222,10267.460952495152,10266.369240790002,10265.285819378916,10264.21065874803,
	10263.143729228303,10262.085000995272,10261.034444068438,10259.992028311488,10258.957723431718,
	10257.931498979671,10256.913324349372,10255.903168777426,10254.901001343478,10253.90679096921,
	10252.920506418874,10251.94211629875,10250.97158905654,10250.008892981896,10249.053996205788,
	10248.106866700398,10247.167472278888,10246.235780595565,10245.311759145105,10244.395375262851,
	10243.486596124596,10242.58538874646,10241.69171998465,10240.805556535364,10239.92686493476,
	10239.055611558688,10238.191762622777,10237.335284182393,10236.486142132133,10235.64430220638,
	10234.809729978666,10233.982390861845,10233.162250108322,10232.349272809597,10231.543423896246,
	10230.7446681383,10229.952970144888,10229.168294364228,10228.390605083905,10227.619866430476,
	10226.856042370033,10226.099096707736,10225.348993088044,10224.605694994883,10223.869165751452,
	10223.139368520615,10222.416266304708,10221.699821945687,10220.989998125366,10220.286757365227,
	10219.59006202702,10218.899874312388,10218.216156263252,10217.538869761931,10216.867976531325,
	10216.203438134953,10215.545215977185,10214.893271303623,10214.247565200885,10213.608058597238,
	10212.974712262616,10212.34748680858,10211.726342688991,10211.111240200094,10210.502139480717,
	10209.899000512441,10209.301783120067,10208.710446971809,10208.12495157946,10207.54525629906,
	10206.971320330626,10206.403102719089,10205.840562354015,10205.2836579704,10204.732348148993,
	10204.186591316138,10203.646345744908,10203.111569554818,10202.582220712577,10202.058257032302,
	10201.539636175949,10201.026315653942,10200.518252825033,10200.015404897362,10199.517728928682,
	10199.025181826411,10198.537720348633,10198.055301104321,10197.577880553637,10197.105415008737,
	10196.637860634064,10196.175173446694,10195.717309317326,10195.264223970014,10194.815872983618,
	10194.372211791377,10193.933195682239,10193.498779800724,10193.068919148027,10192.643568582213,
	10192.222682818772,10191.806216431381,10191.394123852362,10190.986359373172,10190.582877145185,
	10190.183631179858,10189.788575349854,10189.39766338908,10189.010848893884,10188.62808532305,
	10188.249325998773,10187.87452410711,10187.503632698645,10187.136604689042,10186.773392859583,
	10186.413949858055,10186.058228199101,10185.706180264797,10185.357758305398,10185.012914439982,
	10184.671600656913,10184.33376881457,10183.99937064176,10183.668357738545,10183.340681576774,
	10183.01629350064,10182.695144727119,10182.377186347032,10182.062369324907,10181.750644500267,
	10181.441962587684,10181.136274177565,10180.83352973667,10180.533679608643,10180.23667401455,
	10179.942463053247,10179.6509967021,10179.362224817458,10179.07609713489,10178.792563269939,
	10178.5115727183,10178.233074856476,10177.95701894212,10177.683354114288,10177.41202939392,
	10177.142993684343,10176.876195771118,10176.611584322878,10176.34910789118,10176.088714911111,
	10175.830353701032,10175.573972463359,10175.319519284118,10175.066942133557,10174.816188865614,
	10174.56720721872,10174.31994481521,10174.074349161452,10173.83036764782,10173.587947548549,
	10173.347036021496,10173.107580107935,10172.86952673226,10172.632822701653,10172.397414705583,
	10172.163249315648,10171.930272984611,10171.698432046294,10171.467672714514,10171.237941082562,
	10171.00918312217,10170.781344683135,10170.554371491897,10170.32820915033,10170.102803135302,
	10169.878098796678,10169.65404135658,10169.430575907774,10169.207647411778,10168.985200697682,
	10168.76318046028,10168.54153125818,10168.320197511597,10168.099123500608,10167.878253362704,
	10167.657531090274,10167.436900528128,10167.216305371277,10166.995689161393,10166.774995284051,
	10166.554166965934,10166.33314727097,10166.111879097067,10165.890305172717,10165.668368052364,
	10165.446010112979,10165.223173549506,10164.999800370158,10164.775832392057,10164.551211236145,
	10164.325878321617,10164.099774861146,10163.872841854307,10163.645020082491,10163.416250101902,
	10163.186472237432,10162.955626575484,10162.723652957511,10162.490490971446,10162.256079945015,
	10162.02035893682,10161.78326672814,10161.544741814047,10161.304722394214,10161.063146363183,
	10160.81995130047,10160.575074459803,10160.32845275866,10160.08002276682,10159.829720694448,
	10159.57748237955,10159.323243276282,10159.066938440392,10158.808502516264,10158.547869722324,
	10158.2849738364,10158.019748179879,10157.752125602241,10157.482038463726,10157.209418618802,
	10156.934197397692,10156.656305588202,10156.375673416353,10156.092230526292,10155.805905959794,
	10155.516628135163,10155.224324824381,10154.928923130821,10154.630349465395,10154.328529521707,
	10154.023388251115,10153.714849836406,10153.402837664622,10153.087274299041,10152.768081450446,
	10152.445179947468,10152.118489705335,10151.787929694852,10151.453417909172,10151.114871330235,
	10150.772205894378,10150.425336456461,10150.074176753018,10149.718639364739,10149.35863567758,
	10148.994075842933,10148.624868736551,10148.25092191679,10147.872141581482,10147.48843252397,
	10147.09969808769,10146.705840120432,10146.306758926603,10145.902353219513,10145.492520071884,
	10145.077154866027,10144.656151242254,10144.229401047261,10143.796794281474,10143.358219045158,
	10142.913561484203,10142.462705735115,10142.005533869438,10141.54192583788,10141.071759413278,
	10140.594910134569,10140.111251248958,10139.620653655506,10139.122985847904,10138.61811385763,
	10138.105901197527,10137.586208806379,10137.058894993463,10136.523815384833,10135.98082287018,
	10135.42976755196,10134.870496695488,10134.302854681317,10133.726682960445,10133.14182001151,
	10132.548101301298,10131.945359249083,10131.333423194257,10130.71211936799,10130.081270871118,
	10129.44069765527,10128.790216511017,10128.129641062196,10127.45878176651,10126.77744592417,
	10126.085437694746,10125.382558121606,10124.668605167495,10123.943373758933,10123.206655842076,
	10122.458240450427,10121.697913784323,10120.92545930406,10120.140657837634,10119.343287702064,
	10118.53312484238,10117.709942985039,10116.873513811102,10116.02360714602,10115.159991169745,
	10114.28243264669,10113.390697176423,10112.484549466462,10111.563753627268,10110.628073491165,
	10109.677272954235,10108.711116343766,10107.729368810773,10106.731796746886,10105.718168229563,
	10104.688253491451,10103.641825417326,10102.57866006715,10101.4985372259,10100.401240978963,
	10099.28656031377,10098.154289746204,10097.004229971097,10095.836188536541,10094.649980539958,
	10093.445429344398,10092.22236731481,10090.980636569728,10089.720089749622,10088.440590796508,
	10087.142015743364,10085.824253511195,10084.487206709598,10083.130792436516,10081.754943076765,
	10080.359607091697,10078.944749799177,10077.510354136582,10076.056421405805,10074.582971992733,
	10073.090046058678,10071.57770419774,10070.046028056215,10068.495120908585,10066.92510818662,
	10065.336137955312,10063.728381331779,10062.102032844183,10060.457310724314,10058.794457130884,
	10057.113738301206,10055.41544462563,10053.699890644093,10051.967414960527,10050.218380075316,
	10048.453172132187,10046.672200580222,10044.875897748969,10043.064718339192,10041.239138827663,
	10039.399656788677,10037.546790134395,10035.68107627487,10033.803071203196,10031.913348508067,
	10030.01249831762,10028.101126180303,10026.179851886402,10024.249308238559,10022.310139773099,
	10020.36300144228,10018.40855726139,10016.447478928756,10014.48044442459,10012.508136597218,
	10010.531241740746,10008.550448174725,10006.566444829281,10004.579919845022,10002.59155919243,
	10000.602045318452,9998.612055824737,9996.622262183411,9994.633328498046,9992.64591031005,
	9990.660653459703,9988.678193001439,9986.69915218028,9984.724141470799,9982.75375767995,
	9980.788583118594,9978.82918483989,9976.87611394844,9974.929904978853,9972.99107534501,
	9971.060124856995,9969.137535310167,9967.223770140188,9965.319274143898,9963.424473266161,
	9961.539774449104,9959.665565540565,9957.802215261248,9955.950073226792,9954.109470021256,
	9952.280717321188,9950.464108062999,9948.659916657427,9946.868399239616,9945.089793958645,
	9943.324321298938,9941.572184431823,9939.833569595932,9938.108646499644,9936.397568745195,
	9934.700474272717,9933.017485817036,9931.348711380379,9929.694244712815,9928.054165803136,
	9926.428541374316,9924.817425381503,9923.22085951591,9921.63887370382,9920.071486607065,
	9918.518706119456,9916.980529857834,9915.456945648803,9913.94793200687,9912.453458604636,
	9910.973486736086,9909.50796976665,9908.056853576158,9906.620076988023,9905.19757218868,
	9903.789265134412,9902.395075945256,9901.014919287878,9899.648704743577,9898.296337165588,
	9896.957717021685,9895.632740726176,9894.32130095421,9893.023286950427,9891.738584818488,
	9890.467077801453,9889.208646549227,9887.963169373554,9886.730522490512,9885.51058025419,
	9884.303215375452,9883.108299132002,9881.92570156644,9880.755291676594,9879.596937590897,
	9878.450506740397,9877.31586601366,9876.192881911355,9875.081420684155,9873.981348468156,
	9872.892531408128,9871.814835775816,9870.748128077796,9869.692275159945,9868.64714430411,
	9867.612603313737,9866.588520601104,9865.574765261137,9864.571207145043,9863.577716925336,
	9862.59416615775,9861.620427336788,9860.656373946338,9859.701880509152,9858.756822628833,
	9857.821077027618,9856.894521583323,9855.977035361137,9855.068498642004,9854.168792947032,
	9853.277801061031,9852.39540705217,9851.521496290867,9850.655955459139,9849.798672567973,
	9848.949536966096,9848.108439346544,9847.275271755425,9846.449927594087,9845.632301622696,
	9844.82228996244,9844.019790093636,9843.224700856037,9842.436922443116,9841.656356400925,
	9840.882905622135,9840.11647434007,9839.35696811991,9838.604293853916,9837.85835975064,
	9837.119075326345,9836.386351393992,9835.660100055247,9834.940234686173,9834.22666992813,
	9833.519321673495,9832.818107055085,9832.122944431272,9831.433753376348,9830.750454662584,
	9830.072970249872,9829.401223270002,9828.735138013617,9828.074639915529,9827.419655540809,
	9826.77011256847,9826.125939779815,9825.48706704077,9824.853425290303,9824.224946522736,
	9823.60156377507,9822.983211111017,9822.369823607889,9821.761337340411,9821.157689367206,
	9820.558817714826,9819.964661366144,9819.375160242358,9818.790255191921,9818.20988797472,
	9817.634001248294,9817.062538553972,9816.495444304232,9815.93266376643,9815.37414305215,
	9814.81982910167,9814.269669672192,9813.723613325006,9813.181609409663,9812.643608054568,
	9812.109560153858,9811.57941735235,9811.053132036996,9810.53065732063,9810.011947034938,
	9809.496955713636,9808.985638584265,9808.477951555686,9807.973851205808,9807.473294771371,
	9806.97624013931,9806.482645830018,9805.992470992273,9805.505675390377,9805.022219393759,
	9804.542063969384,9804.06517066536,9803.591501608455,9803.1210194916,9802.65368756323,
	9802.189469618383,9801.72832999031,9801.27023354076,9800.815145652043,9800.363032216717,
	9799.913859630746,9799.467594782805,9799.024205048416,9798.58365828042,9798.145922799704,
	9797.710967390894,9797.278761290936,9796.849274183707,9796.42247619183,9795.998337868601,
	9795.57683019007,9795.15792455444,9794.74159276447,9794.32780702804,9793.916539949345,
	9793.507764522265,9793.101454125403,9792.697582511753,9792.296123806995,9791.897052499346,
	9791.500343437283,9791.105971821418,9790.713913198566,9790.324143455702,9789.936638816078,
	9789.551375834315,9789.168331384857,9788.787482666276,9788.408807186577,9788.032282765244,
	9787.657887524641,9787.285599884599,9786.915398561483,9786.547262555463,9786.181171157808,
	9785.817103933865,9785.455040726081,9785.094961648272,9784.736847080578,9784.380677662264,
	9784.026434294752,9783.674098131605,9783.323650572105,9782.975073267711,9782.628348108556,
	9782.283457219984,9781.940382965573,9781.599107937021,9781.25961495401,9780.921887058317,
	9780.585907511864,9780.251659792173,9779.919127589981,9779.58829480699,9779.259145548187,
	9778.931664123122,9778.605835042365,9778.281643009495,9777.959072924783,9777.638109880309,
	9777.318739152039,9777.00094620368,9776.684716678785,9776.370036402319,9776.056891374932,
	9775.745267769598,9775.435151933933,9775.126530380618,9774.819389788541,9774.513717002292,
	9774.20949902527,9773.906723022881,9773.605376310017,9773.305446363993,9773.00692080599,
	9772.709787412681,9772.414034102225,9772.119648942435,9771.826620141896,9771.534936049098,
	9771.244585151671,9770.955556074889,9770.66783757644,9770.381418548915,9770.096288014778,
	9769.812435123107,9769.529849152214,9769.248519505949,9768.9684357096,9768.689587410208,
	9768.411964374627,9768.135556487729,9767.860353752712,9767.58634628345,9767.313524308232,
	9767.041878169692,9766.771398316549,9766.502075307373,9766.233899806362,9765.966862585054,
	9765.70095451647,9765.436166577838,9765.172489845498,9764.909915496073,9764.648434805305,
	9764.388039142796,9764.128719977023,9763.870468866493,9763.613277468114,9763.357137522893,
	9763.102040868023,9762.84797942783,9762.59494521443,9762.34293032522,9762.091926945737,
	9761.841927343643,9761.592923868706,9761.344908956487,9761.097875120407,9760.851814953843,
	9760.606721128936,9760.362586399135,9760.119403587662,9759.87716559923,9759.635865411634,
	9759.395496074507,9759.156050712536,9758.917522520112,9758.67990476135,9758.4431907773,
	9758.207373969908,9757.97244781241,9757.738405844173,9757.505241672454,9757.272948969356,
	9757.04152147066,9756.81095297589,9756.581237348919,9756.352368513952,9756.124340459117,
	9755.897147231202,9755.67078293525,9755.445241737296,9755.220517863216,9754.996605593984,
	9754.773499267741,9754.55119327849,9754.329682076774,9754.108960167358,9753.889022109606,
	9753.669862514591,9753.451476047305,9753.233857423535,9753.0170014123,9752.80090283311,
	9752.585556554197,9752.370957493178,9752.157100619881,9751.943980949405,9751.731593542836,
	9751.519933511812,9751.308996016136,9751.098776255854,9750.889269481733,9750.680470986475,
	9750.472376107517,9750.26498022737,9750.058278771132,9749.852267205595,9749.646941042356,
	9749.442295832692,9749.23832717094,9749.035030688412,9748.83240206302,9748.6304370048,
	9748.429131272394,9748.228480655967,9748.028480984554,9747.829128130512,9747.630417996574,
	9747.432346529386,9747.234909711082,9747.038103553643,9746.841924112498,9746.646367475483,
	9746.45142976448,9746.257107139443,9746.063395790636,9745.87029194355,9745.677791858843,
	9745.485891828854,9745.294588178454,9745.103877265252,9744.91375547784,9744.724219238125,
	9744.535264998542,9744.346889242397,9744.159088485128,9743.971859268691,9743.78519816748,
	9743.599101785698,9743.413566755495,9743.228589740238,9743.044167430779,9742.860296543666,
	9742.676973826783,9742.494196053076,9742.31196002741,9742.130262576691,9741.949100557498,
	9741.768470850786,9741.588370364449,9741.408796036221,9741.229744821563,9741.051213708657,
	9740.873199708627,9740.695699855523,9740.518711207143,9740.342230849928,9740.166255893322,
	9739.990783463976,9739.81581072499,9739.641334850097,9739.46735304311,9739.29386252627,
	9739.120860550891,9738.948344383723,9738.776311315947,9738.604758663128,9738.433683758682,
	9738.263083960544,9738.092956647066,9737.923299215658,9737.754109085274,9737.585383699226,
	9737.41712051356,9737.249317011485,9737.08197069384,9736.915079080038,9736.748639710639,
	9736.58265014282,9736.41710795796,9736.252010748698,9736.087356136673,9735.92314175176,
	9735.759365249987,9735.596024298347,9735.433116588385,9735.270639826878,9735.108591739552,
	9734.946970067505,9734.78577256608,9734.62499701721,9734.46464121318,9734.304702961073,
	9734.145180092388,9733.986070446186,9733.82737188341,9733.669082279333,9733.511199527698,
	9733.353721534024,9733.196646222097,9733.039971530972,9732.88369541314,9732.727815840006,
	9732.57233079432,9732.417238278424,9732.262536300614,9732.108222895995,9731.954296103768,
	9731.800753984275,9731.64759460676,9731.494816059205,9731.342416442583,9731.190393866522,
	9731.038746463457,9730.887472372076,9730.73656974759,9730.58603675724,9730.43587158197,
	9730.286072416033,9730.136637468802,9729.98756495609,9729.838853114374,9729.690500187162,
	9729.542504434605,9729.394864121368,9729.247577535554,9729.100642967956,9728.954058727524,
	9728.807823133153,9728.661934511598,9728.516391208599,9728.371191573831,9728.226333978588,
	9728.08181679276,9727.937638407171,9727.793797220664,9727.650291644048,9727.507120097944,
	9727.364281011578,9727.221772832094,9727.079594009478,9726.937743008675,9726.79621830515,
	9726.655018380456,9726.514141735723,9726.373586870324,9726.233352304305,9726.093436560057,
	9725.953838175627,9725.81455569667,9725.675587673444,9725.536932676654,9725.398589279106,
	9725.260556063588,9725.122831624567,9724.985414565263,9724.848303497241,9724.711497041844,
	9724.574993829665,9724.438792500747,9724.302891703745,9724.167290093224,9724.03198633969,
	9723.896979118483,9723.762267105887,9723.627849000573,9723.493723503172,9723.359889320896,
	9723.226345172598,9723.093089781172,9722.960121883616,9722.827440221059,9722.695043545798,
	9722.562930614458,9722.431100194206,9722.299551057846,9722.168281988012,9722.037291776109,
	9721.906579216988,9721.776143118861,9721.645982290629,9721.516095555959,9721.386481743597,
	9721.25713968154,9721.128068220496,9720.999266205392,9720.87073248565,9720.742465950954,
	9720.614465448421,9720.486729863134,9720.359258079015,9720.232048990505,9720.105101496201,
	9719.97841449837,9719.851986914213,9719.725817660881,9719.59990566354,9719.474249856565,
	9719.348849176611,9719.223702570605,9719.098808990613,9718.974167393008,9718.849776743233,
	9718.725636014993,9718.601744179367,9718.478100225202,9718.354703149296,9718.231551916942,
	9718.108645560102,9717.98598307792,9717.863563481349,9717.741385791918,9717.61944903529,
	9717.49775223724,9717.376294440159,9717.255074686112,9717.134092019804,9717.013345497113,
	9716.89283417846,9716.772557128155,9716.652513413592,9716.532702114651,9716.413122311254,
	9716.293773087416,9716.174653540398,9716.05576276372,9715.937099862016,9715.81866394198,
	9715.700454113876,9715.58246950061,9715.464709220952,9715.34717240637,9715.229858188548,
	9715.112765706075,9714.995894102636,9714.8792425241,9714.762810126016,9714.646596062263,
	9714.530599501484,9714.414819604413,9714.299255546564,9714.183906504504,9714.068771660577,
	9713.953850198977,9713.83914131088,9713.724644190455,9713.610358037398,9713.496282056354,
	9713.38241545592,9713.26875745062,9713.155307253697,9713.042064091793,9712.92902718768,
	9712.816195770885,9712.703569078632,9712.591146351053,9712.478926825159,9712.366909754794,
	9712.255094385986,9712.14347997949,9712.032065788771,9711.920851082126,9711.809835125328,
	9711.699017191533,9711.588396551031,9711.47797248725,9711.367744283441,9711.257711231387,
	9711.14787261372,9711.038227728837,9710.928775879,9710.819516360658,9710.710448484078,
	9710.601571559366,9710.492884897772,9710.384387817123,9710.276079639461,9710.167959690361,
	9710.060027293692,9709.952281785494,9709.844722497943,9709.737348774619,9709.630159954988,
	9709.523155379518,9709.416334406074,9709.309696382117,9709.203240666822,9709.09696661521,
	9708.990873593471,9708.884960966263,9708.779228105022,9708.67367437881,9708.568299166833,
	9708.463101845717,9708.3580817982,9708.25323840946,9708.148571070788,9708.044079170359,
	9707.93976211115,9707.835619278467,9707.731650082089,9707.627853927359,9707.524230215085,
	9707.420778359578,9707.317497770417,9707.2143878724,9707.111448076656,9707.008677807431,
	9706.90607649255,9706.803643556723,9706.701378431171,9706.599280551256,9706.497349350411,
	9706.395584274384,9706.293984758719,9706.192550250911,9706.091280198589,9705.99017405714,
	9705.889231270457,9705.78845130307,9705.687833608305,9705.587377648848,9705.48708288948,
	9705.386948798208,9705.286974838655,9705.187160489997,9705.08750522436,9704.98800851735,
	9704.88866984961,9704.789488701519,9704.690464561116,9704.591596915361,9704.492885249534,
	9704.394329061617,9704.295927844869,9704.197681092859,9704.0995883083,9704.001648993053,
	9703.903862651927,9703.806228789217,9703.708746917639,9703.611416544056,9703.5142371866,
	9703.417208360375,9703.320329585766,9703.223600379057,9703.1270202685,9703.030588773994,
	9702.934305425655,9702.838169754865,9702.742181293805,9702.6463395728,9702.550644133646,
	9702.455094511486,9702.35969024748,9702.26443088808,9702.169315971603,9702.07434505316,
	9701.979517675496,9701.884833395596,9701.790291762718,9701.695892338363,9701.601634673545,
	9701.507518332164,9701.41354287266,9701.319707865518,9701.226012867053,9701.132457455276,
	9701.03904119448,9700.945763657937,9700.852624419109,9700.759623052254,9700.666759137057,
	9700.574032251587,9700.481441983491,9700.388987910768,9700.296669614765,9700.204486690845,
	9700.112438727785,9700.020525311751,9699.928746037562,9699.83710050247,9699.74558829799,
	9699.654209026556,9699.56296228761,9699.471847685087,9699.380864818026,9699.290013295353,
	9699.19929272333,9699.108702712365,9699.018242874381,9698.927912814866,9698.83771215665,
	9698.747640515667,9698.657697502009,9698.567882739053,9698.478195853173,9698.388636456146,
	9698.299204181598,9698.209898655952,9698.120719498898,9698.031666347304,9697.94273882954,
	9697.853936578937,9697.765259227706,9697.676706412558,9697.588277772218,9697.499972947802,
	9697.411791574254,9697.32373329772,9697.235797759427,9697.14798460906,9697.060293487073,
	9696.972724048557,9696.885275938037,9696.79794880976,9696.71074231304,9696.623656109756,
	9696.536689845021,9696.449843186883,9696.36311578486,9696.27650730899,9696.19001741171,
	9696.103645760462,9696.017392018464,9695.931255853206,9695.845236932264,9695.759334922011,
	9695.67354949625,9695.58788032546,9695.502327078522,9695.416889431812,9695.331567068826,
	9695.246359655177,9695.161266877187,9695.076288408083,9694.99142393483,9694.906673139816,
	9694.822035703692,9694.737511313893,9694.653099651967,9694.568800413943,9694.48461328021,
	9694.400537950081,9694.316574109955,9694.232721449784,9694.148979669164,9694.065348464463,
	9693.981827527152,9693.898416557315,9693.815115253246,9693.731923319701,9693.64884045368,
	9693.565866356465,9693.483000737866,9693.400243302138,9693.317593753614,9693.235051798236,
	9693.152617147822,9693.070289513658,9692.98806860265,9692.90595413154,9692.823945814718,
	9692.74204335926,9692.660246486039,9692.578554915217,9692.496968359359,9692.415486545913,
	9692.334109182302,9692.252835999505,9692.171666719005,9692.090601061713,9692.009638760153,
	9691.928779528418,9691.848023102328,9691.767369206662,9691.686817572318,9691.60636792741,
	9691.526020005573,9691.445773541544,9691.365628260071,9691.285583902729,9691.205640204478,
	9691.12579690128,9691.046053728485,9690.96641042842,9690.886866737781,9690.807422399701,
	9690.728077154748,9690.648830746266,9690.569682919353,9690.490633415367,9690.411681980522,
	9690.332828361923,9690.254072310707,9690.175413575866,9690.096851899525,9690.018387038228,
	9689.940018744112,9689.861746765595,9689.783570861868,9689.7054907805,9689.627506283181,
	9689.549617124705,9689.471823055968,9689.394123847469,9689.316519249189,9689.239009022609,
	9689.16159292924,9689.084270731002,9689.007042194547,9688.92990707575,9688.852865146875,
	9688.775916166971,9688.699059908386,9688.622296132351,9688.545624616172,9688.46904511629,
	9688.392557410027,9688.316161266896,9688.239856461352,9688.16364276396,9688.087519945644,
	9688.011487782347,9687.935546051009,9687.8596945245,9687.783932977918,9687.70826119428,
	9687.63267894634,9687.557186020986,9687.481782185,9687.40646723738,9687.33124094382,
	9687.256103093516,9687.181053468828,9687.106091854826,9687.031218034663,9686.956431795314,
	9686.88173292073,9686.80712119916,9686.732596425512,9686.65815837627,9686.583806849681,
	9686.509541631243,9686.435362515813,9686.361269292083,9686.287261757656,9686.213339699809,
	9686.139502910968,9686.06575120026,9685.992084344698,9685.918502150538,9685.845004416416,
	9685.771590933604,9685.698261506845,9685.625015929127,9685.551854007914,9685.47877553506,
	9685.40578032195,9685.332868161948,9685.260038861788,9685.187292225617,9685.114628054818,
	9685.04204615975,9684.96954633877,9684.897128402865,9684.824792154346,9684.752537410392,
	9684.680363968713,9684.608271646825,9684.536260248382,9684.464329587652,9684.392479474725,
	9684.320709717664,9684.249020133293,9684.177410536911,9684.10588073675,9684.034430545167,
	9683.963059785037,9683.891768265008,9683.820555807215,9683.74942222835,9683.67836733715,
	9683.607390962581,9683.536492920291,9683.465673022889,9683.394931097744,9683.324266967433,
	9683.25368044729,9683.18317136376,9683.112739537031,9683.042384791066,9682.97210694664,
	9682.901905838262,9682.83178127277,9682.761733097139,9682.691761120352,9682.62186517935,
	9682.55204509836,9682.482300707,9682.41263182429,9682.343038292953,9682.27351994186,
	9682.204076589662,9682.134708075855,9682.065414230132,9681.996194885398,9681.927049872393,
	9681.8579790296,9681.78898218376,9681.720059171037,9681.651209831747,9681.582433994145,
	9681.513731495064,9681.44510217748,9681.37654587078,9681.308062418679,9681.239651654967,
	9681.171313420458,9681.10304755547,9681.034853894596,9680.96673229308,9680.89868256496,
	9680.830704581507,9680.762798165084,9680.694963161726,9680.627199420289,9680.559506776222,
	9680.491885080124,9680.42433417854,9680.356853905678,9680.289444117525,9680.22210465328,
	9680.154835365262,9680.087636094922,9680.02050669612,9679.953447012218,9679.886456892209,
	9679.819536187937,9679.752684747702,9679.685902419125,9679.619189058258,9679.55254450838,
	9679.485968630104,9679.419461266642,9679.353022277084,9679.286651510205,9679.220348823379,
	9679.154114065925,9679.087947099508,9679.021847769478,9678.955815940802,9678.889851459882,
	9678.823954187299,9678.7581239837,9678.692360699384,9678.626664199219,9678.561034333945,
	9678.495470969665,9678.429973960272,9678.364543163978,9678.299178443098,9678.23387966069,
	9678.168646672177,9678.103479345722,9678.038377533736,9677.973341107658,9677.908369925754,
	9677.843463851717,9677.778622745063,9677.713846475292,9677.649134906938,9677.584487903528,
	9677.519905326937,9677.45538703861,9677.390932924733,9677.326542827837,9677.262216626423,
	9677.197954188001,9677.133755379185,9677.069620070364,9677.005548120904,9676.94153941221,
	9676.877593804853,9676.813711173112,9676.74989138814,9676.686134308036,9676.622439819317,
	9676.558807791007,9676.495238087891,9676.43173059074,9676.368285160353,9676.304901677773,
	9676.241580016233,9676.178320050454,9676.115121649418,9676.0519846959,9675.988909054657,
	9675.92589461112,9675.862941228346,9675.800048792576,9675.737217184593,9675.67444626646,
	9675.611735927061,9675.549086040888,9675.48649647894,9675.423967131845,9675.361497871141,
	9675.299088574666,9675.236739125447,9675.174449399741,9675.112219286124,9675.050048655401,
	9674.987937393029,9674.925885379176,9674.863892495367,9674.80195862256,9674.740083644938,
	9674.678267450208,9674.61650990574,9674.554810911284,9674.49317034451,9674.431588084539,
	9674.37006402487,9674.308598040667,9674.247190030976,9674.185839866472,9674.124547440584,
	9674.063312640008,9674.00213534734,9673.941015450831,9673.879952838577,9673.818947399677,
	9673.75799901594,9673.697107583133,9673.636272984555,9673.57549511253,9673.514773852674,
	9673.454109096618,9673.393500730213,9673.332948654823,9673.272452749152,9673.212012904898,
	9673.151629019674,9673.091300980863,9673.031028684494,9672.97081201536,9672.910650870886,
	9672.850545139889
	}},
	{ // Ri = 250k
	-5,5,200,2001, {
	12274.474491258665,12267.292706998116,12260.12520332666,12252.971968290194,12245.832989978906,
	12238.708256528285,12231.597756118064,12224.501476972633,12217.419407360374,12210.351535594116,
	12203.297850030416,12196.258339069918,12189.232991156705,12182.221794778257,12175.224738465797,
	12168.241810793566,12161.27300037843,12154.318295881116,12147.37768600407,12140.451159492919,
	12133.538705135465,12126.640311761948,12119.755968244603,12112.885663497538,12106.029386476792,
	12099.18712618001,12092.358871646386,12085.544611955938,12078.744336230751,12071.958033633133,
	12065.185693366235,12058.427304674662,12051.682856842743,12044.952339195119,12038.23574109738,
	12031.53305195467,12024.84426121179,12018.169358353454,12011.5083329042,12004.861174427637,
	11998.227872526411,11991.6084168427,11985.002797057195,11978.411002889472,11971.8330240976,
	11965.268850478142,11958.718471865643,11952.181878132988,11945.659059190617,11939.150004987181,
	11932.654705508297,11926.173150777566,11919.70533085511,11913.251235838896,11906.810855863083,
	11900.384181098818,11893.971201753737,11887.571908071968,11881.186290333406,11874.814338854649,
	11868.456043987444,11862.111396119666,11855.780385674092,11849.463003109908,11843.159238920189,
	11836.869083633721,11830.592527813822,11824.329562058647,11818.08017700043,11811.844363305805,
	11805.622111675775,11799.413412844573,11793.218257580844,11787.036636686302,11780.868540996142,
	11774.713961378682,11768.572888735369,11762.445314000259,11756.331228140081,11750.230622154031,
	11744.143487073723,11738.06981396216,11732.009593915069,11725.962818059294,11719.929477553273,
	11713.909563586909,11707.903067380948,11701.909980187444,11695.930293288695,11689.963997997998,
	11684.011085658683,11678.071547644173,11672.14537535823,11666.232560233939,11660.333093734354,
	11654.446967351416,11648.574172606544,11642.714701050361,11636.868544261646,11631.035693848447,
	11625.216141446383,11619.409878719893,11613.616897361186,11607.837189090023,11602.070745654233,
	11596.317558828308,11590.577620414537,11584.850922241736,11579.137456165528,11573.437214068224,
	11567.750187858299,11562.076369470296,11556.415750864859,11550.76832402807,11545.134080971611,
	11539.513013732478,11533.90511437264,11528.310374978682,11522.728787662094,11517.160344558728,
	11511.605037828513,11506.062859655285,11500.533802246839,11495.017857834007,11489.515018671691,
	11484.025277036866,11478.548625230285,11473.085055574868,11467.634560415738,11462.197132120547,
	11456.772763078634,11451.361445701397,11445.963172421069,11440.577935691828,11435.205727988492,
	11429.846541806539,11424.500369662348,11419.167204092391,11413.84703765303,11408.539862920907,
	11403.245672491701,11397.964458981198,11392.69621502325,11387.440933271795,11382.19860639826,
	11376.96922709308,11371.752788064843,11366.5492820399,11361.358701761988,11356.18103999255,
	11351.0162895102,11345.864443110146,11340.725493604545,11335.599433821768,11330.486256606258,
	11325.385954818392,11320.298521334174,11315.223949044997,11310.162230857197,11305.113359692306,
	11300.077328485755,11295.05413018794,11290.043757762944,11285.046204188773,11280.061462456833,
	11275.089525571846,11270.130386551284,11265.18403842561,11260.250474237626,11255.329687042024,
	11250.421669905889,11245.526415907298,11240.64391813603,11235.774169692826,11230.917163689039,
	11226.072893246703,11221.241351497983,11216.422531584745,11211.616426658686,11206.823029880721,
	11202.042334420976,11197.274333458126,11192.519020179358,11187.77638778016,11183.046429463637,
	11178.329138440484,11173.624507929128,11168.932531154307,11164.253201347816,11159.586511747826,
	11154.932455598464,11150.291026149716,11145.662216656852,11141.046020380438,11136.442430585837,
	11131.851440542936,11127.273043525904,11122.707232812512,11118.154001684694,11113.613343426974,
	11109.0852513275,11104.56971867631,11100.066738766367,11095.576304892355,11091.098410350598,
	11086.633048438767,11082.180212455803,11077.739895700806,11073.312091473479,11068.896793073629,
	11064.49399380079,11060.10368695341,11055.72586582928,11051.360523725072,11047.007653935152,
	11042.667249752298,11038.33930446687,11034.023811366455,11029.72076373556,11025.43015485526,
	11021.151978002894,11016.886226451874,11012.63289347075,11008.391972323636,11004.163456269249,
	10999.947338560616,10995.743612445107,10991.55227116403,10987.373307951331,10983.206716034809,
	10979.052488634368,10974.910618962227,10970.781100222492,10966.663925611098,10962.559088314707,
	10958.466581511018,10954.386398368044,10950.318532043668,10946.262975685508,10942.219722430527,
	10938.18876540436,10934.170097721368,10930.163712483552,10926.169602780905,10922.187761690713,
	10918.218182277154,10914.260857590902,10910.315780668483,10906.382944532419,10902.462342190587,
	10898.553966635438,10894.657810844195,10890.773867777969,10886.902130381848,10883.042591583771,
	10879.195244294777,10875.360081408377,10871.537095799866,10867.726280326491,10863.927627826299,
	10860.141131118366,10856.366783002104,10852.604576256477,10848.85450364039,10845.116557891535,
	10841.39073172626,10837.677017839103,10833.97540890242,10830.285897565747,10826.608476455665,
	10822.943138174918,10819.289875302622,10815.648680393027,10812.019545975783,10808.402464555069,
	10804.79742860922,10801.204430590442,10797.623462923966,10794.054518008243,10790.497588213893,
	10786.952665883271,10783.419743330702,10779.89881284082,10776.38986666943,10772.892897041982,
	10769.407896153536,10765.934856168427,10762.473769219827,10759.02462740859,10755.587422803377,
	10752.162147440658,10748.748793322651,10745.347352418526,10741.957816663142,10738.580177956388,
	10735.214428163164,10731.860559112672,10728.518562597557,10725.188430374248,10721.870154161868,
	10718.563725641538,10715.26913645684,10711.986378212088,10708.715442472583,10705.456320764139,
	10702.209004572102,10698.973485341145,10695.74975447508,10692.537803335563,10689.337623242185,
	10686.149205471922,10682.972541258065,10679.80762179064,10676.654438214919,10673.512981631719,
	10670.383243096157,10667.265213617493,10664.158884158966,10661.064245636291,10657.981288918196,
	10654.910004825027,10651.850384128915,10648.802417552535,10645.766095769515,10642.741409402473,
	10639.72834902415,10636.726905155398,10633.737068265737,10630.758828772083,10627.792177038442,
	10624.83710337565,10621.893598040302,10618.961651234331,10616.041253105017,10613.132393743323,
	10610.235063184624,10607.349251407219,10604.474948331877,10601.612143821923,10598.760827681734,
	10595.920989656935,10593.092619433482,10590.275706637107,10587.47024083278,10584.676211524074,
	10581.893608153,10579.122420098734,10576.362636677499,10573.614247141917,10570.877240680373,
	10568.151606416686,10565.437333408869,10562.734410649167,10560.04282706345,10557.362571510288,
	10554.693632780607,10552.035999596832,10549.389660612776,10546.754604412523,10544.13081951015,
	10541.518294349124,10538.917017301635,10536.326976667824,10533.748160675546,10531.18055747951,
	10528.624155160645,10526.078941725968,10523.544905107134,10521.022033160747,10518.510313666988,
	10516.00973432962,10513.520282774964,10511.041946551486,10508.574713129065,10506.118569898548,
	10503.673504171107,10501.239503177254,10498.81655406703,10496.404643908458,10494.003759687772,
	10491.613888307993,10489.235016589166,10486.86713126706,10484.510218992846,10482.164266332238,
	10479.829259765418,10477.505185686088,10475.192030400482,10472.889780127181,10470.598420996741,
	10468.317939050377,10466.048320240063,10463.789550427042,10461.541615382352,10459.304500785025,
	10457.07819222225,10454.862675188742,10452.657935085255,10450.463957219315,10448.280726803385,
	10446.108228954896,10443.946448695573,10441.795370950445,10439.654980547746,10437.525262217712,
	10435.406200592677,10433.297780205585,10431.199985490242,10429.11280077997,10427.036210307268,
	10424.970198203544,10422.91474849787,10420.86984511668,10418.83547188312,10416.811612516638,
	10414.798250631797,10412.795369738242,10410.80295323975,10408.820984433834,10406.849446510749,
	10404.88832255327,10402.937595535988,10400.997248324637,10399.067263675213,10397.147624233958,
	10395.238312536208,10393.339311005997,10391.450601955316,10389.572167584069,10387.703989978389,
	10385.84605111111,10383.998332840296,10382.160816909596,10380.333484946485,10378.516318462662,
	10376.709298852682,10374.912407394162,10373.125625246383,10371.348933450134,10369.582312927016,
	10367.825744478832,10366.079208787212,10364.342686412372,10362.61615779345,10360.899603247279,
	10359.19300296785,10357.496337025823,10355.809585368352,10354.132727817609,10352.465744071073,
	10350.808613700321,10349.161316151041,10347.523830741906,10345.896136664354,10344.278212981795,
	10342.670038629456,10341.071592413162,10339.482853009424,10337.903798964458,10336.334408693825,
	10334.774660481906,10333.224532481127,10331.684002711776,10330.153049060958,10328.631649282694,
	10327.119780996742,10325.61742168856,10324.124548708589,10322.641139271447,10321.167170456076,
	10319.702619204587,10318.247462321811,10316.80167647535,10315.365238194441,10313.938123869639,
	10312.520309752521,10311.111771954847,10309.71248644834,10308.322429064112,10306.941575491994,
	10305.569901280576,10304.207381835895,10302.853992421793,10301.509708158957,10300.174504024615,
	10298.84835485213,10297.531235330209,10296.22312000292,10294.923983268809,10293.633799381021,
	10292.352542446199,10291.08018642437,10289.81670512874,10288.562072224775,10287.316261230093,
	10286.079245514195,10284.850998297543,10283.631492651613,10282.420701498415,10281.218597609968,
	10280.025153607918,10278.84034196323,10277.664134995874,10276.496504874312,10275.337423615112,
	10274.186863082621,10273.044794989082,10271.911190893143,10270.786022200777,10269.669260164073,
	10268.56087588145,10267.460840296842,10266.36912419979,10265.28569822494,10264.210532851746,
	10263.14359840414,10262.084865050341,10261.034302802387,10259.991881516085,10258.957570890594,
	10257.931340468063,10256.913159633586,10255.902997614807,10254.90082348175,10253.906606146287,
	10252.920314362469,10251.941916725742,10250.971381672904,10250.008677482076,10249.053772272448,
	10248.10663400351,10247.167230475756,10246.235529329824,10245.311498046658,10244.395103947145,
	10243.486314192001,10242.58509578177,10241.691415556385,10240.805240195097,10239.926536216764,
	10239.055269978793,10238.191407678161,10237.334915350291,10236.485758869669,10235.643903949185,
	10234.809316140472,10233.981960833482,10233.161803256777,10232.348808477032,10231.542941399433,
	10230.744166767041,10229.9524491613,10229.167753001744,10228.390042545878,10227.619281889254,
	10226.855434965617,10226.0984655465,10225.348337241507,10224.605013498292,10223.868457602439,
	10223.138632677685,10222.41550168554,10221.69902742594,10220.98917253678,10220.285899493947,
	10219.589170611625,10218.89894804246,10218.215193777265,10217.537869644977,10216.866937313489,
	10216.202358288881,10215.544093916118,10214.892105378744,10214.246353699076,10213.606799738596,
	10212.97340419767,10212.346127615929,10211.724930372404,10211.109772685273,10210.500614612445,
	10209.897416051686,10209.300136740441,10208.708736256078,10208.123174016402,10207.543409279477,
	10206.969401143595,10206.40110854796,10205.838490272574,10205.281504938377,10204.730111007399,
	10204.18426678334,10203.643930411135,10203.109059877444,10202.579613011265,10202.055547483142,
	10201.5368208062,10201.023390336022,10200.515213270886,10200.012246651902,10199.514447363154,
	10199.021772132155,10198.534177529686,10198.051619970347,10197.574055712234,10197.101440857634,
	10196.633731353044,10196.170882989216,10195.71285140141,10195.259592069486,10194.811060318238,
	10194.367211317482,10193.928000081965,10193.493381471892,10193.06331019273,10192.637740795531,
	10192.216627676831,10191.799925079125,10191.387587090367,10190.97956764462,10190.575820521739,
	10190.176299347713,10189.7809575942,10189.389748579257,10189.002625466612,10188.619541266105,
	10188.240448833429,10187.865300870106,10187.494049923569,10187.126648386538,10186.763048497496,
	10186.403202340196,10186.047061843385,10185.694578780744,10185.345704770656,10185.000391275606,
	10184.658589602228,10184.320250900733,10183.985326164453,10183.653766229465,10183.325521774355,
	10183.00054331896,10182.678781224646,10182.36018569293,10182.044706765535,10181.73229432274,
	10181.422898083294,10181.116467603539,10180.812952275719,10180.512301328205,10180.214463823218,
	10179.919388656479,10179.62702455571,10179.337320079427,10179.05022361561,10178.76568338002,
	10178.483647415062,10178.20406358765,10177.926879587973,10177.652042927306,10177.379500936215,
	10177.109200762576,10176.841089369245,10176.575113532028,10176.311219836984,10176.049354678078,
	10175.78946425453,10175.531494567867,10175.275391419318,10175.02110040636,10174.768566919363,
	10174.517736138783,10174.268553031017,10174.020962344812,10173.77490860746,10173.53033612054,
	10173.28718895543,10173.045410949193,10172.804945699534,10172.565736559798,10172.327726634147,
	10172.090858771578,10171.855075560743,10171.620319323909,10171.38653211041,10171.153655690794,
	10170.921631549605,10170.690400878453,10170.459904568805,10170.230083204042,10170.000877051913,
	10169.772226055697,10169.544069825819,10169.316347630858,10169.088998387815,10168.861960652588,
	10168.635172609862,10168.408572061853,10168.182096418032,10167.955682683,10167.729267444924,
	10167.502786862808,10167.27617665385,10167.049372079437,10166.82230793193,10166.594918519537,
	10166.367137651412,10166.138898622105,10165.910134195205,10165.680776586478,10165.45075744636,
	10165.220007841794,10164.988458237536,10164.75603847634,10164.522677758863,10164.288304623058,
	10164.052846921693,10163.816231800567,10163.578385674837,10163.339234204825,10163.098702271718,
	10162.856713950665,10162.613192485229,10162.368060258812,10162.12123876689,10161.872648587032,
	10161.622209348863,10161.369839702267,10161.11545728533,10160.858978690483,10160.600319430414,
	10160.33939390203,10160.076115350552,10159.810395830846,10159.542146169337,10159.27127592369,
	10158.997693341506,10158.721305318597,10158.442017355086,10158.159733511195,10157.874356360895,
	10157.58578694601,10157.293924726973,10156.998667534432,10156.699911518575,10156.397551097609,
	10156.091478905131,10155.781585736391,10155.467760493511,10155.149890129658,10154.827859592066,
	10154.501551764435,10154.170847408368,10153.835625103187,10153.49576118655,10153.151129692687,
	10152.801602291536,10152.447048225915,10152.08733424959,10151.722324564202,10151.351880756816,
	10150.975861736462,10150.594123671613,10150.206519928344,10149.812901007543,10149.41311448459,
	10149.00700494915,10148.59441394605,10148.175179917924,10147.749138149764,10147.316120715413,
	10146.875956426373,10146.428470783401,10145.973485931678,10145.510820618883,10145.040290157736,
	10144.561706393248,10144.074877673647,10143.579608828746,10143.075701152635,10142.562952393491,
	10142.04115675131,10141.510104882509,10140.969583913331,10140.4193774626,10139.85926567466,
	10139.289025261995,10138.708429560855,10138.117248597768,10137.515249169945,10136.902194939341,
	10136.277846541487,10135.641961710913,10134.994295421675,10134.334600046675,10133.66262553498,
	10132.978119608555,10132.280827979539,10131.570494587764,10130.846861861957,10130.10967100209,
	10129.35866228663,10128.59357540365,10127.814149807476,10127.020125100746,10126.211241443298,
	10125.387239987427,10124.547863340518,10123.692856055339,10122.821965148092,10121.934940643088,
	10121.031536146407,10120.111509445042,10119.174623134115,10118.220645269283,10117.249350043805,
	10116.260518491159,10115.253939208114,10114.229409100533,10113.186734147834,10112.125730184447,
	10111.046223696569,10109.94805263082,10108.831067212983,10107.695130772221,10106.540120569882,
	10105.36592862579,10104.172462542383,10102.959646319116,10101.727421155092,10100.47574623424,
	10099.204599489642,10097.9139783416,10096.60390040431,10095.274404157823,10093.925549577953,
	10092.557418722898,10091.17011626713,10089.763769982497,10088.338531159134,10086.894574962083,
	10085.432100720913,10083.951332146673,10082.452517474661,10080.935929527814,10079.40186569958,
	10077.850647853418,10076.282622136681,10074.69815870868,10073.097651381424,10071.481517172417,
	10069.850195771822,10068.204148922852,10066.543859718658,10064.869831816282,10063.182588572618,
	10061.482672103624,10059.770642272331,10058.04707560936,10056.312564169964,10054.56771433586,
	10052.81314556361,10051.049489089712,10049.277386595135,10047.497488839419,10045.710454267932,
	10043.91694760205,10042.117638416852,10040.313199716004,10038.504306507713,10036.691634391931,
	10034.875858161136,10033.057650427307,10031.237680274293,10029.416611946677,10027.595103578593,
	10025.773805966774,10023.953361394118,10022.13440250722,10020.31755125068,10018.503417863873,
	10016.692599939825,10014.885681550599,10013.083232440003,10011.28580728603,10009.493945031416,
	10007.708168285499,10005.928982794281,10004.15687698243,10002.392321560597,10000.635769201926,
	9998.88765428321,9997.148392689603,9995.41838168127,9993.697999817983,9991.987606941608,
	9990.28754421058,9988.598134186233,9986.919680966406,9985.252470363299,9983.596770123484,
	9981.952830185008,9980.320882970724,9978.701143713739,9977.093810809156,9975.499066195123,
	9973.917075753838,9972.347989733671,9970.791943188924,9969.2490564322,9967.719435500327,
	9966.203172629084,9964.700346734928,9963.211023902239,9961.735257872531,9960.273090536992,
	9958.82455242546,9957.38966319505,9955.968432115162,9954.560858546489,9953.166932414082,
	9951.78663467416,9950.41993777067,9949.066806085046,9947.727196373744,9946.40105819685,
	9945.088334335336,9943.78896119698,9942.502869208096,9941.229983197885,9939.970222764969,
	9938.72350263561,9937.489733006381,9936.268819876555,9935.060665365772,9933.865168019689,
	9932.682223103697,9931.511722885429,9930.353556900702,9929.207612213315,9928.073773658069,
	9926.95192407521,9925.841944533984,9924.74371454008,9923.65711224186,9922.582014617074,
	9921.518297654608,9920.465836524012,9919.424505738265,9918.394179304505,9917.374730868969,
	9916.366033850773,9915.36796156917,9914.380387363079,9913.403184702871,9912.436227293809,
	9911.479389175269,9910.532544811043,9909.595569175033,9908.668337828438,9907.750726995855,
	9906.842613630415,9905.94387547762,9905.054391136582,9904.174040105117,9903.302702836996,
	9902.440260780999,9901.586596425295,9900.741593330622,9899.9051361671,9899.077110742337,
	9898.25740402819,9897.445904186236,9896.642500586195,9895.847083826722,9895.05954575051,
	9894.2797794574,9893.507679315588,9892.743140972309,9891.986061359967,9891.23633870134,
	9890.49387251473,9889.758563615744,9889.030314117586,9888.309027432018,9887.59460826455,
	9886.886962614883,9886.185997770284,9885.491622302388,9884.803746059282,9884.122280159503,
	9883.447136984336,9882.778230169582,9882.115474594995,9881.458786376661,9880.808082854232,
	9880.163282583186,9879.524305319364,9878.891072010687,9878.263504785373,9877.641526935338,
	9877.025062907804,9876.414038290064,9875.808379797782,9875.208015259324,9874.6128736038,
	9874.02288484755,9873.437980079507,9872.858091446742,9872.283152141736,9871.713096387923,
	9871.147859424877,9870.587377494794,9870.031587828056,9869.480428629691,9868.933839064643,
	9868.391759244674,9867.85413021262,9867.320893930362,9866.791993264562,9866.26737197181,
	9865.746974685493,9865.230746903972,9864.718634975137,9864.210586082643,9863.706548235767,
	9863.20647025225,9862.710301749308,9862.217993127892,9861.729495561442,9861.244760983702,
	9860.763742074452,9860.286392250278,9859.812665650816,9859.342517124693,9858.87590222336,
	9858.412777183721,9857.953098919304,9857.49682501203,9857.043913693395,9856.594323841393,
	9856.148014964941,9855.704947196331,9855.265081277324,9854.828378551472,9854.394800954376,
	9853.964311001826,9853.53687177979,9853.112446936577,9852.69100067356,9852.272497731894,
	9851.856903389713,9851.444183445717,9851.034304216311,9850.62723252552,9850.222935691605,
	9849.821381526595,9849.422538321487,9849.026374840669,9848.632860314032,9848.241964428265,
	9847.853657318317,9847.46790956324,9847.084692174876,9846.703976591287,9846.32573467209,
	9845.949938685859,9845.576561311651,9845.20557562329,9844.836955087585,9844.470673556783,
	9844.106705261045,9843.74502480546,9843.385607158403,9843.02842764944,9842.673461961576,
	9842.320686126122,9841.97007651555,9841.621609840315,9841.275263140515,9840.931013781095,
	9840.588839447899,9840.248718140414,9839.910628168182,9839.574548143077,9839.240456978596,
	9838.90833387945,9838.578158341299,9838.249910144365,9837.923569347491,9837.599116285252,
	9837.276531563439,9836.955796053526,9836.6368908884,9836.319797458167,9836.004497407665,
	9835.690972629614,9835.379205262918,9835.069177687004,9834.760872518918,9834.454272607805,
	9834.14936103488,9833.846121105946,9833.544536347845,9833.244590509072,9832.946267551604,
	9832.649551648537,9832.354427182867,9832.060878742586,9831.768891116977,9831.478449294225,
	9831.18953845715,9830.902143982401,9830.61625143671,9830.331846570303,9830.048915318555,
	9829.767443798457,9829.487418304252,9829.208825303236,9828.931651438497,9828.655883519326,
	9828.38150852501,9828.108513596695,9827.836886039377,9827.566613317293,9827.297683048795,
	9827.030083011769,9826.763801132067,9826.498825488086,9826.235144303955,9825.97274594939,
	9825.711618939375,9825.45175192751,9825.193133707951,9824.935753209933,9824.67959949809,
	9824.42466177227,9824.170929357502,9823.918391713962,9823.667038424474,9823.416859198574,
	9823.167843867075,9822.919982386225,9822.673264826435,9822.427681379495,9822.183222354633,
	9821.939878170475,9821.697639362634,9821.456496575891,9821.216440565138,9820.97746219292,
	9820.739552427063,9820.502702342745,9820.266903116695,9820.032146027588,9819.798422452748,
	9819.565723873142,9819.334041862074,9819.103368092225,9818.873694329519,9818.645012434372,
	9818.41731435821,9818.19059214338,9817.96483792352,9817.740043918191,9817.516202435158,
	9817.293305867817,9817.071346693723,9816.850317475635,9816.63021085753,9816.411019562242,
	9816.192736397972,9815.975354246171,9815.758866070453,9815.543264909047,9815.328543876363,
	9815.114696160583,9814.901715027187,9814.689593811107,9814.478325918439,9814.26790482848,
	9814.05832408993,9813.8495773184,9813.641658200568,9813.434560487178,9813.228277997154,
	9813.022804613607,9812.818134283303,9812.614261020703,9812.411178897655,9812.208882051531,
	9812.007364679092,9811.806621037182,9811.606645445103,9811.40743227719,9811.208975967678,
	9811.011271007581,9810.814311943568,9810.618093380219,9810.422609977244,9810.227856444475,
	9810.033827549361,9809.840518111005,9809.647923001221,9809.456037145354,9809.264855513533,
	9809.074373133648,9808.884585078426,9808.695486470833,9808.507072484075,9808.319338335315,
	9808.132279294505,9807.945890672618,9807.760167829496,9807.575106169625,9807.390701145183,
	9807.206948248331,9807.023843018513,9806.841381035549,9806.659557926032,9806.47836935303,
	9806.297811027023,9806.117878697292,9805.938568153564,9805.759875226446,9805.581795785643,
	9805.404325739219,9805.227461037357,9805.051197665121,9804.875531646687,9804.700459044292,
	9804.525975955821,9804.352078517555,9804.178762899965,9804.00602530975,9803.833861989227,
	9803.662269215301,9803.491243299035,9803.32078058462,9803.150877451706,9802.981530315714,
	9802.812735617103,9802.644489835617,9802.476789479393,9802.309631091926,9802.143011241877,
	9801.97692653733,9801.811373609058,9801.646349121276,9801.481849771506,9801.317872280253,
	9801.154413402151,9800.99146991786,9800.82903864102,9800.667116407823,9800.50570008555,
	9800.344786568705,9800.184372779926,9800.024455666111,9799.865032203916,9799.706099395453,
	9799.547654268623,9799.38969387583,9799.232215298633,9799.075215639457,9798.918692029054,
	9798.762641620659,9798.607061594952,9798.451949153972,9798.29730152228,9798.143115952336,
	9797.989389718283,9797.83612011549,9797.683304464708,9797.530940108018,9797.379024410326,
	9797.227554758874,9797.076528561483,9796.925943249043,9796.775796273756,9796.626085108504,
	9796.476807248635,9796.327960207422,9796.179541519497,9796.031548741084,9795.883979449822,
	9795.736831241664,9795.590101728194,9795.443788548077,9795.297889354437,9795.152401818568,
	9795.007323636153,9794.862652517608,9794.718386187124,9794.574522396983,9794.43105891208,
	9794.287993517079,9794.145324011002,9794.003048212593,9793.861163960904,9793.71966910601,
	9793.578561520015,9793.437839089876,9793.297499721632,9793.157541332634,9793.017961860809,
	9792.878759261306,9792.739931501368,9792.60147656408,9792.463392452466,9792.325677182585,
	9792.188328784274,9792.051345305532,9791.914724806884,9791.7784653676,9791.642565077425,
	9791.507022040303,9791.37183438165,9791.237000232373,9791.102517742032,9790.968385077127,
	9790.83460041102,9790.701161936155,9790.568067857757,9790.435316392413,9790.302905772378,
	9790.170834243429,9790.03910006131,9789.90770149838,9789.776636837967,9789.645904376524,
	9789.515502423512,9789.385429300644,9789.25568334053,9789.126262893396,9788.997166312718,
	9788.868391973774,9788.739938254183,9788.61180355289,9788.483986273603,9788.356484832168,
	9788.229297662652,9788.102423200937,9787.975859900826,9787.849606225296,9787.72366064773,
	9787.598021653539,9787.472687736965,9787.347657407527,9787.222929178475,9787.09850158206,
	9786.974373153622,9786.85054244447,9786.727008010377,9786.603768421232,9786.480822257454,
	9786.358168107467,9786.235804570953,9786.11373025476,9785.991943779642,9785.870443773087,
	9785.749228873554,9785.62829772598,9785.50764899079,9785.387281330979,9785.267193422773,
	9785.147383950001,9785.027851605977,9784.908595094475,9784.789613126048,9784.670904419161,
	9784.552467702613,9784.43430171524,9784.316405202546,9784.198776918882,9784.081415627374,
	9783.96432009861,9783.847489111666,9783.730921457174,9783.614615927301,9783.498571328999,
	9783.3827864705,9783.267260176211,9783.151991269768,9783.036978590608,9782.922220978866,
	9782.807717283895,9782.693466369221,9782.579467097052,9782.465718343703,9782.352218986898,
	9782.238967917297,9782.125964028413,9782.013206223713,9781.900693413427,9781.788424516339,
	9781.676398451329,9781.564614152974,9781.453070557756,9781.341766610401,9781.2307012641,
	9781.119873475729,9781.009282209658,9780.898926440157,9780.788805140059,9780.678917297939,
	9780.569261903986,9780.45983795642,9780.350644457918,9780.241680418148,9780.13294485358,
	9780.024436790205,9779.916155252642,9779.808099276763,9779.700267904094,9779.592660180844,
	9779.48527516057,9779.378111902572,9779.271169471662,9779.164446934843,9779.05794337133,
	9778.951657862064,9778.845589494813,9778.73973736332,9778.634100564694,9778.528678205423,
	9778.423469393845,9778.318473245085,9778.21368888078,9778.109115425372,9778.00475201145,
	9777.900597776907,9777.796651859,9777.69291340988,9777.589381578657,9777.486055521756,
	9777.382934403835,9777.280017392108,9777.177303658968,9777.074792379492,9776.972482737838,
	9776.870373921116,9776.768465120434,9776.66675553227,9776.565244358382,9776.463930808373,
	9776.362814086895,9776.261893413654,9776.161168008759,9776.060637095707,9775.960299902961,
	9775.86015566614,9775.76020362426,9775.660443015307,9775.560873091443,9775.4614931035,
	9775.362302305288,9775.26329995856,9775.164485326928,9775.065857679636,9774.967416289612,
	9774.869160431213,9774.771089389717,9774.673202449769,9774.57549889982,9774.477978031007,
	9774.380639146719,9774.283481543433,9774.186504527328,9774.08970740938,9773.99308950173,
	9773.896650124077,9773.80038859379,9773.704304237372,9773.608396383916,9773.51266436663,
	9773.417107517795,9773.321725181637,9773.226516700808,9773.131481421453,9773.036618696053,
	9772.941927877675,9772.847408323665,9772.753059396096,9772.658880461337,9772.564870887549,
	9772.471030045612,9772.377357314297,9772.283852068978,9772.190513694064,9772.097341572251,
	9772.004335097852,9771.911493658536,9771.8188166536,9771.726303480073,9771.633953540593,
	9771.54176623964,9771.449740988272,9771.357877198181,9771.266174282768,9771.174631661594,
	9771.08324875452,9770.992024986148,9770.9009597853,9770.810052583185,9770.719302810996,
	9770.628709908367,9770.538273310727,9770.447992464384,9770.357866815188,9770.267895808796,
	9770.178078899102,9770.088415540666,9769.998905185972,9769.909547302188,9769.820341345532,
	9769.731286786797,9769.642383090593,9769.553629730295,9769.46502617972,9769.376571914447,
	9769.288266415413,9769.200109163634,9769.112099644182,9769.024237345731,9768.936521757087,
	9768.848952372507,9768.761528683852,9768.674250191532,9768.58711639737,9768.500126802386,
	9768.41328091335,9768.326578236758,9768.240018285094,9768.153600571506,9768.06732461126,
	9767.981189921158,9767.895196023781,9767.809342440902,9767.723628695983,9767.638054319743,
	9767.552618840087,9767.467321795273,9767.382162709819,9767.297141129335,9767.212256590545,
	9767.127508633348,9767.042896805226,9766.958420650873,9766.87407971622,9766.78987355965,
	9766.7058017247,9766.621863770857,9766.538059259055,9766.454387742939,9766.370848788136,
	9766.287441953644,9766.204166814501,9766.121022931364,9766.038009874706,9765.955127223395,
	9765.872374544082,9765.789751417093,9765.70725741984,9765.624892134896,9765.542655144005,
	9765.46054603054,9765.378564382401,9765.296709788949,9765.214981840525,9765.133380129573,
	9765.051904248332,9764.97055379799,9764.889328372581,9764.808227575768,9764.72725100938,
	9764.64639827526,9764.565668980575,9764.485062732896,9764.40457914474,9764.324217824886,
	9764.243978388895,9764.163860449578,9764.08386362721,9764.00398753665,9763.92423180084,
	9763.844596044375,9763.765079889898,9763.68568296176,9763.606404888875,9763.527245302537,
	9763.448203830825,9763.369280108882,9763.290473768204,9763.21178445041,9763.13321179119,
	9763.054755429499,9762.97641500397,9762.898190164555,9762.820080547968,9762.74208580793,
	9762.664205587205,9762.586439539788,9762.508787311568,9762.431248561203,9762.353822936508,
	9762.276510098087,9762.199309701367,9762.122221407473,9762.045244870142,9761.968379761447,
	9761.891625741626,9761.814982471851,9761.738449623821,9761.662026857608,9761.585713854847,
	9761.509510280643,9761.433415801435,9761.357430102033,9761.281552853225,9761.205783729878,
	9761.130122413202,9761.054568582584,9760.979121920172,9760.90378210724,9760.828548826727,
	9760.75342176387,9760.67840061183,9760.603485053196,9760.52867477677,9760.453969477294,
	9760.379368845,9760.304872576171,9760.230480360362,9760.156191898517,9760.082006888528,
	9760.007925025893,9759.933946014817,9759.860069554723,9759.786295348576,9759.712623102938,
	9759.639052522516,9759.56558331096,9759.492215176888,9759.41894783601,9759.345780990165,
	9759.27271435968,9759.199747649856,9759.126880580294,9759.054112865126,9758.981444216457,
	9758.90887436134,9758.836403012974,9758.764029891281,9758.691754717274,9758.619577220685,
	9758.547497116153,9758.475514137526,9758.403628001091,9758.331838445793,9758.260145188784,
	9758.188547967582,9758.117046507326,9758.045640550086,9757.974329816154,9757.90311404399,
	9757.8319929769,9757.760966341777,9757.690033879848,9757.619195328663,9757.54845042872,
	9757.477798919283,9757.407240545619,9757.336775049705,9757.266402172036,9757.19612166038,
	9757.125933260497,9757.055836722388,9756.985831791193,9756.915918212242,9756.846095745152,
	9756.776364131354,9756.70672313328,9756.63717249615,9756.56771197444,9756.498341333423,
	9756.429060318056,9756.359868687287,9756.290766205084,9756.221752628002,9756.15282771597,
	9756.08399122799,9756.015242934409,9755.946582589371,9755.878009961107,9755.809524810848,
	9755.741126911074,9755.672816024871,9755.604591917421,9755.536454364694,9755.468403127543,
	9755.400437987888,9755.332558709913,9755.264765064887,9755.197056830739,9755.129433778622,
	9755.06189568566,9754.99444232589,9754.927073480196,9754.859788922848,9754.792588431314,
	9754.725471792652,9754.65843877894,9754.591489175415,9754.524622759862,9754.457839324947,
	9754.391138647943,9754.324520514132,9754.257984709406,9754.191531020275,9754.12515923672,
	9754.058869139872,9753.992660524229,9753.926533181646,9753.860486897374,9753.794521464302,
	9753.728636678243,9753.66283232707,9753.597108209993,9753.531464112197,9753.465899838708,
	9753.400415180473,9753.335009940885,9753.26968391027,9753.204436893018,9753.139268680057,
	9753.0741790802,9753.009167888089,9752.944234908948,9752.879379948172,9752.8146028019,
	9752.749903275713,9752.685281176855,9752.620736310104,9752.556268479055,9752.491877495075,
	9752.427563157664,9752.363325282511,9752.299163680527,9752.23507815332,9752.171068513911,
	9752.107134577036,9752.043276151406,9751.979493048257,9751.91578508142,9751.85215207234,
	9751.788593827305,9751.725110159641,9751.661700894574,9751.598365843762,9751.535104822498,
	9751.47191764803,9751.408804147683,9751.345764132457,9751.282797425238,9751.21990384525,
	9751.157083215012,9751.094335359272,9751.031660097637,9750.969057253502,9750.906526652017,
	9750.844068115384,9750.78168147131,9750.719366548321,9750.657123164976,9750.594951156583,
	9750.53285034572,9750.47082056271,9750.408861641115,9750.346973402542,9750.285155677384,
	9750.223408304117,9750.161731111724,9750.100123927605,9750.038586589446,9749.977118924937,
	9749.915720776035,9749.854391973602,9749.793132350602,9749.731941747126,9749.670819992962,
	9749.609766931142,9749.54878239725,9749.487866232708,9749.427018264101,9749.366238343553,
	9749.30552630664,9749.244881994458,9749.184305244215,9749.12379590282,9749.063353809915,
	9749.00297880567,9748.942670734752,9748.882429443796,9748.822254773533,9748.76214657192,
	9748.702104680053,9748.642128946272,9748.582219220545,9748.522375343662,9748.462597163962,
	9748.40288453484,9748.343237300247,9748.28365530647,9748.224138415655,9748.164686463328,
	9748.10529930633,9748.04597679576,9747.986718784285,9747.927525123238,9747.86839566502,
	9747.809330266155,9747.750328775,9747.691391046765,9747.63251693931,9747.573706304622,
	9747.514959002627,9747.456274887965,9747.397653812131,9747.339095638436,9747.280600224112,
	9747.222167428377,9747.163797102963,9747.105489112515,9747.047243318877,9746.989059575699,
	9746.930937751515,9746.87287770066,9746.814879287931,9746.756942372918,9746.699066821813,
	9746.641252490148,9746.583499252516,9746.525806966883,9746.468175496462,9746.410604707538,
	9746.353094464046,9746.29564463165,9746.238255076247,9746.180925670735,9746.123656276635,
	9746.066446759116,9746.009296990265,9745.952206835065,9745.895176168862,9745.838204854115,
	9745.781292762507,9745.72443976464,9745.66764573205,9745.610910532865,9745.554234038042,
	9745.497616127735,9745.44105666405,9745.384555523258,9745.328112577157,9745.271727706724,
	9745.215400773443,9745.159131661647,9745.102920243438,9745.046766391168,9744.990669981848,
	9744.934630896889,9744.878649004453,9744.822724186757,9744.766856313312,9744.711045274787,
	9744.655290934554,9744.59959318172,9744.543951892729,9744.488366944452,9744.43283821576,
	9744.377365592081,9744.321948945924,9744.266588164908,9744.211283124723,9744.156033714647,
	9744.10083980487,9744.045701287876,9743.990618045213,9743.935589950757,9743.88061689852,
	9743.82569876399,9743.77083544191,9743.716026802113,9743.661272747833,9743.606573147801,
	9743.551927894241,9743.49733687034,9743.44279997069,9743.388317071152,9743.333888066198,
	9743.279512837553,9743.225191283145,9743.17092327773,9743.116708717282,9743.062547490357,
	9743.00843948839,9742.954384590934,9742.900382698268,9742.846433698933,9742.792537480811,
	9742.738693933754,9742.68490295218,9742.631164423885,9742.577478244706,9742.523844303003,
	9742.470262495655,9742.416732714162,9742.363254849253,9742.309828801514,9742.256454455004,
	9742.203131709006,9742.14986045879,9742.096640597052,9742.043472023079,9741.990354626469,
	9741.937288307661,9741.88427296551,9741.831308488236,9741.778394772566,9741.72553172474,
	9741.672719241677,9741.619957211602,9741.567245539321,9741.514584118748,9741.461972852723,
	9741.409411645018,9741.356900384244,9741.30443897539,9741.252027318682,9741.199665312828,
	9741.147352858457,9741.09508985921,9741.042876216454,9740.990711820667,9740.938596590526,
	9740.886530416123,9740.834513205411,9740.782544860343,9740.730625276166,9740.67875436525,
	9740.626932027733,9740.575158171905,9740.523432698365,9740.47175550837,9740.42012651173,
	9740.368545604571,9740.317012707319,9740.265527709576,9740.214090529123,9740.162701065374,
	9740.11135922943,9740.060064925316,9740.008818055458,9739.957618531864,9739.906466260567,
	9739.855361154796,9739.804303113047,9739.75329205264,9739.702327875277,9739.651410494278,
	9739.600539817051,9739.549715751764,9739.498938208511,9739.44820709649,9739.397522332663,
	9739.346883815382,9739.296291469405,9739.245745190383,9739.195244904824,9739.144790510842,
	9739.094381926621,9739.04401906379,9738.993701836673,9738.943430156323,9738.893203933274,
	9738.84302308513,9738.792887513193,9738.742797140376,9738.692751886272,9738.64275165721,
	9738.592796370198,9738.54288593146,9738.4930202716,9738.443199284768,9738.393422909685,
	9738.343691043598,9738.294003606397,9738.244360522234,9738.194761698269,9738.145207060337,
	9738.095696511426
	}}
};
