/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.option;

import java.io.File;
import java.util.StringTokenizer;

public class PathOption extends Option<String> {

    private String invalidPathElement = "";

    public PathOption() {
        super();
        hasArgument(true);
    }

    public PathOption(String longName) {
        super(longName);
        hasArgument(true);
    }

    public PathOption(String longName, String shortName) {
        super(longName, shortName);
        hasArgument(true);
    }

    @Override
	public void addValueFromString(String value) {
		addValue(value);
	}
    
    public String getInvalidPathElement() {
        return invalidPathElement;
    }

	@Override
	public void setValueFromString(String value) {
		setValue(value);
	}

	protected boolean checkArgument(String arg) {

        if (arg == null) {
            throw new IllegalArgumentException("The argument arg may not be null!");
        }
 
        StringTokenizer stz = new StringTokenizer(arg, System.getProperty("path.separator"));
        String token;

        File path;
        String pathElement;

        while (stz.hasMoreTokens()) {

            token = stz.nextToken();
            
            pathElement = token;

            if (pathElement.startsWith("~")) {

                if (pathElement.equals("~")) {

                    pathElement = System.getProperty("user.home");

                } else {
                    
                    pathElement = System.getProperty("user.home") 
                        + pathElement.substring(1);
                }
            }
            
            path = new File(pathElement);
            
            if (path.exists() == false) {
                invalidPathElement = pathElement;
                return false;
            }
        }
    
        return true;
    }

	@Override
	public OptionType getType() {
		return OptionType.TEXT;
	}
}
/*
 * $Log$
 */
