/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.trafo.internal.html.docbook.editor;

import org.dbdoclet.tag.docbook.BaseTagFactory;
import org.dbdoclet.tag.docbook.DocBookElement;
import org.dbdoclet.tag.docbook.Para;
import org.dbdoclet.tag.docbook.Term;
import org.dbdoclet.tag.docbook.Varlistentry;
import org.dbdoclet.tag.docbook.Variablelist;
import org.dbdoclet.trafo.html.EditorException;
import org.dbdoclet.trafo.html.EditorInstruction;

public class DdEditor extends DocBookEditor {

	@Override
	public EditorInstruction edit(EditorInstruction values)
			throws EditorException {

		DocBookElement list = null;

		setValues(super.edit(values));
		BaseTagFactory dbfactory = getTagFactory();

		// Try to detect two sequenced dd tags.
		if (getParent() instanceof Variablelist) {

			Varlistentry entry = dbfactory.createVarlistentry();
			getParent().appendChild(entry);

			Term term = dbfactory.createTerm();
			entry.appendChild(term);

			list = dbfactory.createListitem();
			entry.appendChild(list);

		} else if (getParent() instanceof Varlistentry) {

			list = dbfactory.createListitem();
			getParent().appendChild(list);
			setParent((DocBookElement) getParent().getParentNode());
		}

		if (list == null) {

			return finalizeValues();
		} // end of else

		Para para = dbfactory.createPara();
		copyCommonAttributes(getHtmlElement(), para);
		setCurrent(para);
		list.appendChild(getCurrent());
		traverse(true);

		return finalizeValues();
	}
}
