/* Copyright 2017 R. Thomas
 * Copyright 2017 Quarkslab
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef LIEF_PE_OLE32_DLL_LOOKUP_H_
#define LIEF_PE_OLE32_DLL_LOOKUP_H_

#include <map>

namespace LIEF {
namespace PE {

static const std::map<uint32_t, const char*> ole32_dll_lookup {
    { 0x0002, "BindMoniker"                                },
    { 0x0003, "CLIPFORMAT_UserFree"                        },
    { 0x0004, "CLIPFORMAT_UserMarshal"                     },
    { 0x0005, "CLIPFORMAT_UserSize"                        },
    { 0x0006, "CLIPFORMAT_UserUnmarshal"                   },
    { 0x0007, "CLSIDFromOle1Class"                         },
    { 0x0008, "CLSIDFromProgID"                            },
    { 0x0009, "CLSIDFromProgIDEx"                          },
    { 0x000a, "CLSIDFromString"                            },
    { 0x000b, "CoAddRefServerProcess"                      },
    { 0x000c, "CoAllowSetForegroundWindow"                 },
    { 0x000d, "CoBuildVersion"                             },
    { 0x000e, "CoCancelCall"                               },
    { 0x000f, "CoCopyProxy"                                },
    { 0x0010, "CoCreateFreeThreadedMarshaler"              },
    { 0x0011, "CoCreateGuid"                               },
    { 0x0012, "CoCreateInstance"                           },
    { 0x0013, "CoCreateInstanceEx"                         },
    { 0x0014, "CoCreateObjectInContext"                    },
    { 0x0015, "CoDeactivateObject"                         },
    { 0x0016, "CoDisableCallCancellation"                  },
    { 0x0017, "CoDisconnectObject"                         },
    { 0x0018, "CoDosDateTimeToFileTime"                    },
    { 0x0019, "CoEnableCallCancellation"                   },
    { 0x001a, "CoFileTimeNow"                              },
    { 0x001b, "CoFileTimeToDosDateTime"                    },
    { 0x001c, "CoFreeAllLibraries"                         },
    { 0x001d, "CoFreeLibrary"                              },
    { 0x001e, "CoFreeUnusedLibraries"                      },
    { 0x001f, "CoFreeUnusedLibrariesEx"                    },
    { 0x0020, "CoGetApartmentID"                           },
    { 0x0021, "CoGetCallContext"                           },
    { 0x0022, "CoGetCallerTID"                             },
    { 0x0023, "CoGetCancelObject"                          },
    { 0x0024, "CoGetClassObject"                           },
    { 0x0025, "CoGetClassVersion"                          },
    { 0x0026, "CoGetComCatalog"                            },
    { 0x0027, "CoGetContextToken"                          },
    { 0x0028, "CoGetCurrentLogicalThreadId"                },
    { 0x0029, "CoGetCurrentProcess"                        },
    { 0x002a, "CoGetDefaultContext"                        },
    { 0x002b, "CoGetInstanceFromFile"                      },
    { 0x002c, "CoGetInstanceFromIStorage"                  },
    { 0x002d, "CoGetInterceptor"                           },
    { 0x002e, "CoGetInterceptorFromTypeInfo"               },
    { 0x002f, "CoGetInterfaceAndReleaseStream"             },
    { 0x0030, "CoGetMalloc"                                },
    { 0x0031, "CoGetMarshalSizeMax"                        },
    { 0x0032, "CoGetObject"                                },
    { 0x0033, "CoGetObjectContext"                         },
    { 0x0034, "CoGetPSClsid"                               },
    { 0x0035, "CoGetProcessIdentifier"                     },
    { 0x0036, "CoGetStandardMarshal"                       },
    { 0x0037, "CoGetState"                                 },
    { 0x0038, "CoGetStdMarshalEx"                          },
    { 0x0039, "CoGetSystemSecurityPermissions"             },
    { 0x003a, "CoGetTreatAsClass"                          },
    { 0x003b, "CoImpersonateClient"                        },
    { 0x003c, "CoInitialize"                               },
    { 0x003d, "CoInitializeEx"                             },
    { 0x003e, "CoInitializeSecurity"                       },
    { 0x003f, "CoInitializeWOW"                            },
    { 0x0040, "CoInstall"                                  },
    { 0x0041, "CoInvalidateRemoteMachineBindings"          },
    { 0x0042, "CoIsHandlerConnected"                       },
    { 0x0043, "CoIsOle1Class"                              },
    { 0x0044, "CoLoadLibrary"                              },
    { 0x0045, "CoLockObjectExternal"                       },
    { 0x0046, "CoMarshalHresult"                           },
    { 0x0047, "CoMarshalInterThreadInterfaceInStream"      },
    { 0x0048, "CoMarshalInterface"                         },
    { 0x0049, "CoPopServiceDomain"                         },
    { 0x004a, "CoPushServiceDomain"                        },
    { 0x004b, "CoQueryAuthenticationServices"              },
    { 0x004c, "CoQueryClientBlanket"                       },
    { 0x004d, "CoQueryProxyBlanket"                        },
    { 0x004e, "CoQueryReleaseObject"                       },
    { 0x004f, "CoReactivateObject"                         },
    { 0x0050, "CoRegisterChannelHook"                      },
    { 0x0051, "CoRegisterClassObject"                      },
    { 0x0052, "CoRegisterInitializeSpy"                    },
    { 0x0053, "CoRegisterMallocSpy"                        },
    { 0x0054, "CoRegisterMessageFilter"                    },
    { 0x0055, "CoRegisterPSClsid"                          },
    { 0x0056, "CoRegisterSurrogate"                        },
    { 0x0057, "CoRegisterSurrogateEx"                      },
    { 0x0058, "CoReleaseMarshalData"                       },
    { 0x0059, "CoReleaseServerProcess"                     },
    { 0x005a, "CoResumeClassObjects"                       },
    { 0x005b, "CoRetireServer"                             },
    { 0x005c, "CoRevertToSelf"                             },
    { 0x005d, "CoRevokeClassObject"                        },
    { 0x005e, "CoRevokeInitializeSpy"                      },
    { 0x005f, "CoRevokeMallocSpy"                          },
    { 0x0060, "CoSetCancelObject"                          },
    { 0x0061, "CoSetProxyBlanket"                          },
    { 0x0062, "CoSetState"                                 },
    { 0x0063, "CoSuspendClassObjects"                      },
    { 0x0064, "CoSwitchCallContext"                        },
    { 0x0065, "CoTaskMemAlloc"                             },
    { 0x0066, "CoTaskMemFree"                              },
    { 0x0067, "CoTaskMemRealloc"                           },
    { 0x0068, "CoTestCancel"                               },
    { 0x0069, "CoTreatAsClass"                             },
    { 0x006a, "CoUninitialize"                             },
    { 0x006b, "CoUnloadingWOW"                             },
    { 0x006c, "CoUnmarshalHresult"                         },
    { 0x006d, "CoUnmarshalInterface"                       },
    { 0x006e, "CoWaitForMultipleHandles"                   },
    { 0x006f, "ComPs_CStdStubBuffer_AddRef"                },
    { 0x0070, "ComPs_CStdStubBuffer_Connect"               },
    { 0x0071, "ComPs_CStdStubBuffer_CountRefs"             },
    { 0x0072, "ComPs_CStdStubBuffer_DebugServerQueryInterface" },
    { 0x0073, "ComPs_CStdStubBuffer_DebugServerRelease"    },
    { 0x0074, "ComPs_CStdStubBuffer_Disconnect"            },
    { 0x0075, "ComPs_CStdStubBuffer_Invoke"                },
    { 0x0076, "ComPs_CStdStubBuffer_IsIIDSupported"        },
    { 0x0077, "ComPs_CStdStubBuffer_QueryInterface"        },
    { 0x0078, "ComPs_IUnknown_AddRef_Proxy"                },
    { 0x0079, "ComPs_IUnknown_QueryInterface_Proxy"        },
    { 0x007a, "ComPs_IUnknown_Release_Proxy"               },
    { 0x007b, "ComPs_NdrCStdStubBuffer2_Release"           },
    { 0x007c, "ComPs_NdrCStdStubBuffer_Release"            },
    { 0x007d, "ComPs_NdrClientCall2"                       },
    { 0x007e, "ComPs_NdrClientCall2_va"                    },
    { 0x007f, "ComPs_NdrDllCanUnloadNow"                   },
    { 0x0080, "ComPs_NdrDllGetClassObject"                 },
    { 0x0081, "ComPs_NdrDllRegisterProxy"                  },
    { 0x0082, "ComPs_NdrDllUnregisterProxy"                },
    { 0x0083, "ComPs_NdrStubCall2"                         },
    { 0x0084, "ComPs_NdrStubForwardingFunction"            },
    { 0x0085, "CreateAntiMoniker"                          },
    { 0x0086, "CreateBindCtx"                              },
    { 0x0087, "CreateClassMoniker"                         },
    { 0x0088, "CreateDataAdviseHolder"                     },
    { 0x0089, "CreateDataCache"                            },
    { 0x008a, "CreateErrorInfo"                            },
    { 0x008b, "CreateFileMoniker"                          },
    { 0x008c, "CreateGenericComposite"                     },
    { 0x008d, "CreateILockBytesOnHGlobal"                  },
    { 0x008e, "CreateItemMoniker"                          },
    { 0x008f, "CreateObjrefMoniker"                        },
    { 0x0090, "CreateOleAdviseHolder"                      },
    { 0x0091, "CreatePointerMoniker"                       },
    { 0x0092, "CreateStdProgressIndicator"                 },
    { 0x0093, "CreateStreamOnHGlobal"                      },
    { 0x0094, "DcomChannelSetHResult"                      },
    { 0x0095, "DllDebugObjectRPCHook"                      },
    { 0x0096, "DllGetClassObject"                          },
    { 0x0097, "DllGetClassObjectWOW"                       },
    { 0x0098, "DllRegisterServer"                          },
    { 0x0099, "DoDragDrop"                                 },
    { 0x009a, "EnableHookObject"                           },
    { 0x009b, "FmtIdToPropStgName"                         },
    { 0x009c, "FreePropVariantArray"                       },
    { 0x009d, "GetClassFile"                               },
    { 0x009e, "GetConvertStg"                              },
    { 0x009f, "GetDocumentBitStg"                          },
    { 0x00a0, "GetErrorInfo"                               },
    { 0x00a1, "GetHGlobalFromILockBytes"                   },
    { 0x00a2, "GetHGlobalFromStream"                       },
    { 0x00a3, "GetHookInterface"                           },
    { 0x00a4, "GetRunningObjectTable"                      },
    { 0x00a5, "HACCEL_UserFree"                            },
    { 0x00a6, "HACCEL_UserMarshal"                         },
    { 0x00a7, "HACCEL_UserSize"                            },
    { 0x00a8, "HACCEL_UserUnmarshal"                       },
    { 0x00a9, "HBITMAP_UserFree"                           },
    { 0x00aa, "HBITMAP_UserMarshal"                        },
    { 0x00ab, "HBITMAP_UserSize"                           },
    { 0x00ac, "HBITMAP_UserUnmarshal"                      },
    { 0x00ad, "HBRUSH_UserFree"                            },
    { 0x00ae, "HBRUSH_UserMarshal"                         },
    { 0x00af, "HBRUSH_UserSize"                            },
    { 0x00b0, "HBRUSH_UserUnmarshal"                       },
    { 0x00b1, "HDC_UserFree"                               },
    { 0x00b2, "HDC_UserMarshal"                            },
    { 0x00b3, "HDC_UserSize"                               },
    { 0x00b4, "HDC_UserUnmarshal"                          },
    { 0x00b5, "HENHMETAFILE_UserFree"                      },
    { 0x00b6, "HENHMETAFILE_UserMarshal"                   },
    { 0x00b7, "HENHMETAFILE_UserSize"                      },
    { 0x00b8, "HENHMETAFILE_UserUnmarshal"                 },
    { 0x00b9, "HGLOBAL_UserFree"                           },
    { 0x00ba, "HGLOBAL_UserMarshal"                        },
    { 0x00bb, "HGLOBAL_UserSize"                           },
    { 0x00bc, "HGLOBAL_UserUnmarshal"                      },
    { 0x00bd, "HICON_UserFree"                             },
    { 0x00be, "HICON_UserMarshal"                          },
    { 0x00bf, "HICON_UserSize"                             },
    { 0x00c0, "HICON_UserUnmarshal"                        },
    { 0x00c1, "HMENU_UserFree"                             },
    { 0x00c2, "HMENU_UserMarshal"                          },
    { 0x00c3, "HMENU_UserSize"                             },
    { 0x00c4, "HMENU_UserUnmarshal"                        },
    { 0x00c5, "HMETAFILEPICT_UserFree"                     },
    { 0x00c6, "HMETAFILEPICT_UserMarshal"                  },
    { 0x00c7, "HMETAFILEPICT_UserSize"                     },
    { 0x00c8, "HMETAFILEPICT_UserUnmarshal"                },
    { 0x00c9, "HMETAFILE_UserFree"                         },
    { 0x00ca, "HMETAFILE_UserMarshal"                      },
    { 0x00cb, "HMETAFILE_UserSize"                         },
    { 0x00cc, "HMETAFILE_UserUnmarshal"                    },
    { 0x00cd, "HPALETTE_UserFree"                          },
    { 0x00ce, "HPALETTE_UserMarshal"                       },
    { 0x00cf, "HPALETTE_UserSize"                          },
    { 0x00d0, "HPALETTE_UserUnmarshal"                     },
    { 0x00d1, "HWND_UserFree"                              },
    { 0x00d2, "HWND_UserMarshal"                           },
    { 0x00d3, "HWND_UserSize"                              },
    { 0x00d4, "HWND_UserUnmarshal"                         },
    { 0x00d5, "HkOleRegisterObject"                        },
    { 0x00d6, "IIDFromString"                              },
    { 0x00d7, "IsAccelerator"                              },
    { 0x00d8, "IsEqualGUID"                                },
    { 0x00d9, "IsValidIid"                                 },
    { 0x00da, "IsValidInterface"                           },
    { 0x00db, "IsValidPtrIn"                               },
    { 0x00dc, "IsValidPtrOut"                              },
    { 0x00dd, "MkParseDisplayName"                         },
    { 0x00de, "MonikerCommonPrefixWith"                    },
    { 0x00df, "MonikerRelativePathTo"                      },
    { 0x00e0, "OleBuildVersion"                            },
    { 0x00e1, "OleConvertIStorageToOLESTREAM"              },
    { 0x00e2, "OleConvertIStorageToOLESTREAMEx"            },
    { 0x00e3, "OleConvertOLESTREAMToIStorage"              },
    { 0x00e4, "OleConvertOLESTREAMToIStorageEx"            },
    { 0x00e5, "OleCreate"                                  },
    { 0x00e6, "OleCreateDefaultHandler"                    },
    { 0x00e7, "OleCreateEmbeddingHelper"                   },
    { 0x00e8, "OleCreateEx"                                },
    { 0x00e9, "OleCreateFromData"                          },
    { 0x00ea, "OleCreateFromDataEx"                        },
    { 0x00eb, "OleCreateFromFile"                          },
    { 0x00ec, "OleCreateFromFileEx"                        },
    { 0x00ed, "OleCreateLink"                              },
    { 0x00ee, "OleCreateLinkEx"                            },
    { 0x00ef, "OleCreateLinkFromData"                      },
    { 0x00f0, "OleCreateLinkFromDataEx"                    },
    { 0x00f1, "OleCreateLinkToFile"                        },
    { 0x00f2, "OleCreateLinkToFileEx"                      },
    { 0x00f3, "OleCreateMenuDescriptor"                    },
    { 0x00f4, "OleCreateStaticFromData"                    },
    { 0x00f5, "OleDestroyMenuDescriptor"                   },
    { 0x00f6, "OleDoAutoConvert"                           },
    { 0x00f7, "OleDraw"                                    },
    { 0x00f8, "OleDuplicateData"                           },
    { 0x00f9, "OleFlushClipboard"                          },
    { 0x00fa, "OleGetAutoConvert"                          },
    { 0x00fb, "OleGetClipboard"                            },
    { 0x00fc, "OleGetIconOfClass"                          },
    { 0x00fd, "OleGetIconOfFile"                           },
    { 0x00fe, "OleInitialize"                              },
    { 0x00ff, "OleInitializeWOW"                           },
    { 0x0100, "OleIsCurrentClipboard"                      },
    { 0x0101, "OleIsRunning"                               },
    { 0x0102, "OleLoad"                                    },
    { 0x0103, "OleLoadFromStream"                          },
    { 0x0104, "OleLockRunning"                             },
    { 0x0105, "OleMetafilePictFromIconAndLabel"            },
    { 0x0106, "OleNoteObjectVisible"                       },
    { 0x0107, "OleQueryCreateFromData"                     },
    { 0x0108, "OleQueryLinkFromData"                       },
    { 0x0109, "OleRegEnumFormatEtc"                        },
    { 0x010a, "OleRegEnumVerbs"                            },
    { 0x010b, "OleRegGetMiscStatus"                        },
    { 0x010c, "OleRegGetUserType"                          },
    { 0x010d, "OleRun"                                     },
    { 0x010e, "OleSave"                                    },
    { 0x010f, "OleSaveToStream"                            },
    { 0x0110, "OleSetAutoConvert"                          },
    { 0x0111, "OleSetClipboard"                            },
    { 0x0112, "OleSetContainedObject"                      },
    { 0x0113, "OleSetMenuDescriptor"                       },
    { 0x0114, "OleTranslateAccelerator"                    },
    { 0x0115, "OleUninitialize"                            },
    { 0x0116, "OpenOrCreateStream"                         },
    { 0x0117, "ProgIDFromCLSID"                            },
    { 0x0118, "PropStgNameToFmtId"                         },
    { 0x0119, "PropSysAllocString"                         },
    { 0x011a, "PropSysFreeString"                          },
    { 0x0001, "PropVariantChangeType"                      },
    { 0x011b, "PropVariantClear"                           },
    { 0x011c, "PropVariantCopy"                            },
    { 0x011d, "ReadClassStg"                               },
    { 0x011e, "ReadClassStm"                               },
    { 0x011f, "ReadFmtUserTypeStg"                         },
    { 0x0120, "ReadOleStg"                                 },
    { 0x0121, "ReadStringStream"                           },
    { 0x0122, "RegisterDragDrop"                           },
    { 0x0123, "ReleaseStgMedium"                           },
    { 0x0124, "RevokeDragDrop"                             },
    { 0x0125, "SNB_UserFree"                               },
    { 0x0126, "SNB_UserMarshal"                            },
    { 0x0127, "SNB_UserSize"                               },
    { 0x0128, "SNB_UserUnmarshal"                          },
    { 0x0129, "STGMEDIUM_UserFree"                         },
    { 0x012a, "STGMEDIUM_UserMarshal"                      },
    { 0x012b, "STGMEDIUM_UserSize"                         },
    { 0x012c, "STGMEDIUM_UserUnmarshal"                    },
    { 0x012d, "SetConvertStg"                              },
    { 0x012e, "SetDocumentBitStg"                          },
    { 0x012f, "SetErrorInfo"                               },
    { 0x0130, "StgConvertPropertyToVariant"                },
    { 0x0131, "StgConvertVariantToProperty"                },
    { 0x0132, "StgCreateDocfile"                           },
    { 0x0133, "StgCreateDocfileOnILockBytes"               },
    { 0x0134, "StgCreatePropSetStg"                        },
    { 0x0135, "StgCreatePropStg"                           },
    { 0x0136, "StgCreateStorageEx"                         },
    { 0x0137, "StgGetIFillLockBytesOnFile"                 },
    { 0x0138, "StgGetIFillLockBytesOnILockBytes"           },
    { 0x0139, "StgIsStorageFile"                           },
    { 0x013a, "StgIsStorageILockBytes"                     },
    { 0x013b, "StgOpenAsyncDocfileOnIFillLockBytes"        },
    { 0x013c, "StgOpenPropStg"                             },
    { 0x013d, "StgOpenStorage"                             },
    { 0x013e, "StgOpenStorageEx"                           },
    { 0x013f, "StgOpenStorageOnHandle"                     },
    { 0x0140, "StgOpenStorageOnILockBytes"                 },
    { 0x0141, "StgPropertyLengthAsVariant"                 },
    { 0x0142, "StgSetTimes"                                },
    { 0x0143, "StringFromCLSID"                            },
    { 0x0144, "StringFromGUID2"                            },
    { 0x0145, "StringFromIID"                              },
    { 0x0146, "UpdateDCOMSettings"                         },
    { 0x0147, "UtConvertDvtd16toDvtd32"                    },
    { 0x0148, "UtConvertDvtd32toDvtd16"                    },
    { 0x0149, "UtGetDvtd16Info"                            },
    { 0x014a, "UtGetDvtd32Info"                            },
    { 0x014b, "WdtpInterfacePointer_UserFree"              },
    { 0x014c, "WdtpInterfacePointer_UserMarshal"           },
    { 0x014d, "WdtpInterfacePointer_UserSize"              },
    { 0x014e, "WdtpInterfacePointer_UserUnmarshal"         },
    { 0x014f, "WriteClassStg"                              },
    { 0x0150, "WriteClassStm"                              },
    { 0x0151, "WriteFmtUserTypeStg"                        },
    { 0x0152, "WriteOleStg"                                },
    { 0x0153, "WriteStringStream"                          },
};


}
}

#endif

