// Copyright 2009-present MongoDB, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#if !defined(BSONCXX_PRIVATE_DOXYGEN_PREPROCESSOR)
#error "This file is for documentation purposes only. It should not be included."
#endif // !defined(BSONCXX_PRIVATE_DOXYGEN_PREPROCESSOR)

///
/// @file
/// For documentation purposes only.
///
/// @note This header is not includable!
///

///
/// @dir mongocxx/v_noabi
/// The directory relative to which headers declaring entities in @ref mongocxx::v_noabi
/// are typically included.
///
/// For backward compatibility, unstable ABI headers may be included using the syntax
/// `<mongocxx/foo.hpp>`, which is equivalent to `<mongocxx/v_noabi/mongocxx/foo.hpp>`.
///

///
/// @dir mongocxx/v_noabi/mongocxx
/// Provides headers declaring entities in @ref mongocxx::v_noabi.
///

///
/// @dir mongocxx/v_noabi/mongocxx/config
/// Provides headers related to mongocxx library configuration.
///

///
/// @dir mongocxx/v_noabi/mongocxx/events
/// Provides headers declaring entities in @ref mongocxx::v_noabi::events.
///

///
/// @dir mongocxx/v_noabi/mongocxx/exception
/// Provides headers declaring entities in @ref mongocxx::v_noabi::exception.
///

///
/// @dir mongocxx/v_noabi/mongocxx/gridfs
/// Provides headers declaring entities in @ref mongocxx::v_noabi::gridfs.
///

///
/// @dir mongocxx/v_noabi/mongocxx/model
/// Provides headers declaring entities in @ref mongocxx::v_noabi::model.
///

///
/// @dir mongocxx/v_noabi/mongocxx/options
/// Provides headers declaring entities in @ref mongocxx::v_noabi::options.
///

///
/// @dir mongocxx/v_noabi/mongocxx/options/gridfs
/// Provides headers declaring entities in @ref mongocxx::v_noabi::options::gridfs.
///

///
/// @dir mongocxx/v_noabi/mongocxx/result
/// Provides headers declaring entities in @ref mongocxx::v_noabi::result.
///

///
/// @dir mongocxx/v_noabi/mongocxx/result/gridfs
/// Provides headers declaring entities in @ref mongocxx::v_noabi::result::gridfs.
///

///
/// @namespace mongocxx::v_noabi
/// Declares entities whose ABI stability is NOT guaranteed.
///

///
/// @namespace mongocxx::v_noabi::events
/// @copydoc mongocxx::events
///

///
/// @namespace mongocxx::v_noabi::gridfs
/// @copydoc mongocxx::gridfs
///

///
/// @namespace mongocxx::v_noabi::model
/// @copydoc mongocxx::model
///
/// @see
/// - @ref mongocxx::v_noabi::bulk_write
///

///
/// @namespace mongocxx::v_noabi::options
/// @copydoc mongocxx::options
///

///
/// @namespace mongocxx::v_noabi::options::gridfs
/// @copydoc mongocxx::options::gridfs
///

///
/// @namespace mongocxx::v_noabi::result
/// @copydoc mongocxx::result
///

///
/// @namespace mongocxx::v_noabi::result::gridfs
/// @copydoc mongocxx::result::gridfs
///
