[//]: # (generated using SlashBack 0.2.0)

  
# constants methods  
The following methods are all part of the **constants methods**\.  
Provide a list of constants and precomputed useful values\.  
## Table of contents  
  
* [**e** function](#e-function)  
* [**epsilon** function](#epsilon-function)  
* [**euler** function](#euler-function)  
* [**four\_over\_pi** function](#four_over_pi-function)  
* [**golden\_ratio** function](#golden_ratio-function)  
* [**half\_pi** function](#half_pi-function)  
* [**ln\_ln\_two** function](#ln_ln_two-function)  
* [**ln\_ten** function](#ln_ten-function)  
* [**ln\_two** function](#ln_two-function)  
* [**one** function](#one-function)  
* [**one\_over\_pi** function](#one_over_pi-function)  
* [**one\_over\_root\_two** function](#one_over_root_two-function)  
* [**one\_over\_two\_pi** function](#one_over_two_pi-function)  
* [**pi** function](#pi-function)  
* [**quarter\_pi** function](#quarter_pi-function)  
* [**root\_five** function](#root_five-function)  
* [**root\_half\_pi** function](#root_half_pi-function)  
* [**root\_ln\_four** function](#root_ln_four-function)  
* [**root\_pi** function](#root_pi-function)  
* [**root\_three** function](#root_three-function)  
* [**root\_two** function](#root_two-function)  
* [**root\_two\_pi** function](#root_two_pi-function)  
* [**third** function](#third-function)  
* [**three\_over\_two\_pi** function](#three_over_two_pi-function)  
* [**two\_over\_pi** function](#two_over_pi-function)  
* [**two\_over\_root\_pi** function](#two_over_root_pi-function)  
* [**two\_pi** function](#two_pi-function)  
* [**two\_thirds** function](#two_thirds-function)  
* [**zero** function](#zero-function)  
  
### e\(\) function  
#### <code>glm.<code>**e**() -\> *float*</code></code>  
&emsp;&emsp;Return ``` e ``` constant\.  
  
### epsilon\(\) function  
#### <code>glm.<code>**epsilon**() -\> *float*</code></code>  
&emsp;&emsp;Return the ``` epsilon ``` constant for floating point types\.  
  
### euler\(\) function  
#### <code>glm.<code>**euler**() -\> *float*</code></code>  
&emsp;&emsp;Return Euler's constant\.  
  
### four\_over\_pi\(\) function  
#### <code>glm.<code>**four_over_pi**() -\> *float*</code></code>  
&emsp;&emsp;Return ``` 4 / pi ```\.  
  
### golden\_ratio\(\) function  
#### <code>glm.<code>**golden_ratio**() -\> *float*</code></code>  
&emsp;&emsp;Return the golden ratio constant\.  
  
### half\_pi\(\) function  
#### <code>glm.<code>**half_pi**() -\> *float*</code></code>  
&emsp;&emsp;Return ``` pi / 2 ```\.  
  
### ln\_ln\_two\(\) function  
#### <code>glm.<code>**ln_ln_two**() -\> *float*</code></code>  
&emsp;&emsp;Return ``` ln(ln(2)) ```\.  
  
### ln\_ten\(\) function  
#### <code>glm.<code>**ln_ten**() -\> *float*</code></code>  
&emsp;&emsp;Return ``` ln(10) ```\.  
  
### ln\_two\(\) function  
#### <code>glm.<code>**ln_two**() -\> *float*</code></code>  
&emsp;&emsp;Return ``` ln(2) ```\.  
  
### one\(\) function  
#### <code>glm.<code>**one**() -\> *float*</code></code>  
&emsp;&emsp;Return ``` 1 ```\.  
  
### one\_over\_pi\(\) function  
#### <code>glm.<code>**one_over_pi**() -\> *float*</code></code>  
&emsp;&emsp;Return ``` 1 / pi ```\.  
  
### one\_over\_root\_two\(\) function  
#### <code>glm.<code>**one_over_root_two**() -\> *float*</code></code>  
&emsp;&emsp;Return ``` 1 / sqrt(2) ```\.  
  
### one\_over\_two\_pi\(\) function  
#### <code>glm.<code>**one_over_two_pi**() -\> *float*</code></code>  
&emsp;&emsp;Return ``` 1 / (pi * 2) ```\.  
  
### pi\(\) function  
#### <code>glm.<code>**pi**() -\> *float*</code></code>  
&emsp;&emsp;Return the ``` pi ``` constant for floating point types\.  
  
### quarter\_pi\(\) function  
#### <code>glm.<code>**quarter_pi**() -\> *float*</code></code>  
&emsp;&emsp;Return ``` pi / 4 ```\.  
  
### root\_five\(\) function  
#### <code>glm.<code>**root_five**() -\> *float*</code></code>  
&emsp;&emsp;Return ``` sqrt(5) ```\.  
  
### root\_half\_pi\(\) function  
#### <code>glm.<code>**root_half_pi**() -\> *float*</code></code>  
&emsp;&emsp;Return ``` sqrt(pi / 2) ```\.  
  
### root\_ln\_four\(\) function  
#### <code>glm.<code>**root_ln_four**() -\> *float*</code></code>  
&emsp;&emsp;Return ``` sqrt(ln(4)) ```\.  
  
### root\_pi\(\) function  
#### <code>glm.<code>**root_pi**() -\> *float*</code></code>  
&emsp;&emsp;Return square root of ``` pi ```\.  
  
### root\_three\(\) function  
#### <code>glm.<code>**root_three**() -\> *float*</code></code>  
&emsp;&emsp;Return ``` sqrt(3) ```\.  
  
### root\_two\(\) function  
#### <code>glm.<code>**root_two**() -\> *float*</code></code>  
&emsp;&emsp;Return ``` sqrt(2) ```\.  
  
### root\_two\_pi\(\) function  
#### <code>glm.<code>**root_two_pi**() -\> *float*</code></code>  
&emsp;&emsp;Return ``` sqrt(2 * pi) ```\.  
  
### third\(\) function  
#### <code>glm.<code>**third**() -\> *float*</code></code>  
&emsp;&emsp;Return ``` 1 / 3 ```\.  
  
### three\_over\_two\_pi\(\) function  
#### <code>glm.<code>**three_over_two_pi**() -\> *float*</code></code>  
&emsp;&emsp;Return ``` pi / 2 * 3 ```\.  
  
### two\_over\_pi\(\) function  
#### <code>glm.<code>**two_over_pi**() -\> *float*</code></code>  
&emsp;&emsp;Return ``` 2 / pi ```\.  
  
### two\_over\_root\_pi\(\) function  
#### <code>glm.<code>**two_over_root_pi**() -\> *float*</code></code>  
&emsp;&emsp;Return ``` 2 / sqrt(pi) ```\.  
  
### two\_pi\(\) function  
#### <code>glm.<code>**two_pi**() -\> *float*</code></code>  
&emsp;&emsp;Return ``` pi * 2 ```\.  
  
### two\_thirds\(\) function  
#### <code>glm.<code>**two_thirds**() -\> *float*</code></code>  
&emsp;&emsp;Return ``` 2 / 3 ```\.  
  
### zero\(\) function  
#### <code>glm.<code>**zero**() -\> *float*</code></code>  
&emsp;&emsp;Return ``` 0 ```\.  
  
