SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE VIEW [DEST].[V_DIFFERENCE_NURSING_HOME__INFECTED_LOCATIONS_TOTAL_PER_REGION] AS

SELECT TOP 1 DATE_OF_REPORT
FROM BASE_CTE;

GO

CREATE OR ALTER VIEW [DEST].[V_DIFFERENCE_NURSING_HOME__INFECTED_LOCATIONS_TOTAL_PER_REGION] AS

SELECT TOP 1 DATE_OF_REPORT
FROM BASE_CTE
ORDER BY DATE_OF_REPORT;

GO


ALTER VIEW [DEST].[V_DIFFERENCE_NURSING_HOME__INFECTED_LOCATIONS_TOTAL_PER_REGION] AS

SELECT DATE_OF_REPORT
	  ,NEW_DATE_OF_REPORT_UNIX AS NEW_DATE_UNIX
	  ,OLD_DATE_OF_REPORT_UNIX AS OLD_DATE_UNIX
	  ,T1.VRCODE
	  ,CASE WHEN OLD_VALUE IS NULL THEN 0 ELSE OLD_VALUE END AS OLD_VALUE
	  ,CASE WHEN [DIFFERENCE] IS NULL THEN 0 ELSE [DIFFERENCE] END AS [DIFFERENCE]
FROM BASE_CTE T1
LEFT JOIN LAST_DATE_OF_REPORT T2
	ON T1.[VRCODE] = T2.[VRCODE]
WHERE DATE_OF_REPORT = LAST_DATE_OF_REPORT;

GO
